/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.slice;

import android.content.ContentProvider;
import android.content.Context;
import android.net.Uri;
import android.os.Environment;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.AtomicFile;
import android.util.Log;
import android.util.Slog;
import android.util.Xml;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.util.XmlUtils;
import com.android.server.slice.DirtyTracker;
import com.android.server.slice.SliceClientPermissions;
import com.android.server.slice.SliceProviderPermissions;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;
import org.xmlpull.v1.XmlSerializer;

public class SlicePermissionManager
implements DirtyTracker {
    private static final String TAG = "SlicePermissionManager";
    private static final long PERMISSION_CACHE_PERIOD = 300000L;
    private static final long WRITE_GRACE_PERIOD = 500L;
    private static final String SLICE_DIR = "slice";
    static final int DB_VERSION = 2;
    private static final String TAG_LIST = "slice-access-list";
    private final String ATT_VERSION = "version";
    private final File mSliceDir;
    private final Context mContext;
    private final Handler mHandler;
    private final ArrayMap<PkgUser, SliceProviderPermissions> mCachedProviders = new ArrayMap();
    private final ArrayMap<PkgUser, SliceClientPermissions> mCachedClients = new ArrayMap();
    private final ArraySet<DirtyTracker.Persistable> mDirty = new ArraySet();

    @VisibleForTesting
    SlicePermissionManager(Context context, Looper looper, File sliceDir) {
        this.mContext = context;
        this.mHandler = new H(looper);
        this.mSliceDir = sliceDir;
    }

    public SlicePermissionManager(Context context, Looper looper) {
        this(context, looper, new File(Environment.getDataDirectory(), "system/slice"));
    }

    public void grantFullAccess(String pkg, int userId) {
        PkgUser pkgUser = new PkgUser(pkg, userId);
        SliceClientPermissions client = this.getClient(pkgUser);
        client.setHasFullAccess(true);
    }

    public void grantSliceAccess(String pkg, int userId, String providerPkg, int providerUser, Uri uri) {
        PkgUser pkgUser = new PkgUser(pkg, userId);
        PkgUser providerPkgUser = new PkgUser(providerPkg, providerUser);
        SliceClientPermissions client = this.getClient(pkgUser);
        client.grantUri(uri, providerPkgUser);
        SliceProviderPermissions provider = this.getProvider(providerPkgUser);
        provider.getOrCreateAuthority(ContentProvider.getUriWithoutUserId(uri).getAuthority()).addPkg(pkgUser);
    }

    public void revokeSliceAccess(String pkg, int userId, String providerPkg, int providerUser, Uri uri) {
        PkgUser pkgUser = new PkgUser(pkg, userId);
        PkgUser providerPkgUser = new PkgUser(providerPkg, providerUser);
        SliceClientPermissions client = this.getClient(pkgUser);
        client.revokeUri(uri, providerPkgUser);
    }

    public void removePkg(String pkg, int userId) {
        PkgUser pkgUser = new PkgUser(pkg, userId);
        SliceProviderPermissions provider = this.getProvider(pkgUser);
        for (SliceProviderPermissions.SliceAuthority authority : provider.getAuthorities()) {
            for (PkgUser p : authority.getPkgs()) {
                this.getClient(p).removeAuthority(authority.getAuthority(), userId);
            }
        }
        SliceClientPermissions client = this.getClient(pkgUser);
        client.clear();
        this.mHandler.obtainMessage(3, pkgUser);
    }

    public String[] getAllPackagesGranted(String pkg) {
        ArraySet<String> ret = new ArraySet<String>();
        for (SliceProviderPermissions.SliceAuthority authority : this.getProvider(new PkgUser(pkg, 0)).getAuthorities()) {
            for (PkgUser pkgUser : authority.getPkgs()) {
                ret.add(pkgUser.mPkg);
            }
        }
        return ret.toArray(new String[ret.size()]);
    }

    public boolean hasFullAccess(String pkg, int userId) {
        PkgUser pkgUser = new PkgUser(pkg, userId);
        return this.getClient(pkgUser).hasFullAccess();
    }

    public boolean hasPermission(String pkg, int userId, Uri uri) {
        PkgUser pkgUser = new PkgUser(pkg, userId);
        SliceClientPermissions client = this.getClient(pkgUser);
        int providerUserId = ContentProvider.getUserIdFromUri(uri, userId);
        return client.hasFullAccess() || client.hasPermission(ContentProvider.getUriWithoutUserId(uri), providerUserId);
    }

    @Override
    public void onPersistableDirty(DirtyTracker.Persistable obj) {
        this.mHandler.removeMessages(2);
        this.mHandler.obtainMessage(1, obj).sendToTarget();
        this.mHandler.sendEmptyMessageDelayed(2, 500L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeBackup(XmlSerializer out) throws IOException, XmlPullParserException {
        SlicePermissionManager slicePermissionManager = this;
        synchronized (slicePermissionManager) {
            out.startTag(null, TAG_LIST);
            out.attribute(null, "version", String.valueOf(2));
            DirtyTracker tracker = obj -> {};
            if (this.mHandler.hasMessages(2)) {
                this.mHandler.removeMessages(2);
                this.handlePersist();
            }
            for (String file : new File(this.mSliceDir.getAbsolutePath()).list()) {
                try (ParserHolder parser = this.getParser(file);){
                    DirtyTracker.Persistable p = null;
                    while (parser.parser.getEventType() != 1) {
                        if (parser.parser.getEventType() == 2) {
                            if ("client".equals(parser.parser.getName())) {
                                p = SliceClientPermissions.createFrom(parser.parser, tracker);
                                break;
                            }
                            p = SliceProviderPermissions.createFrom(parser.parser, tracker);
                            break;
                        }
                        parser.parser.next();
                    }
                    if (p != null) {
                        p.writeTo(out);
                        continue;
                    }
                    Slog.w(TAG, "Invalid or empty slice permissions file: " + file);
                }
            }
            out.endTag(null, TAG_LIST);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readRestore(XmlPullParser parser) throws IOException, XmlPullParserException {
        SlicePermissionManager slicePermissionManager = this;
        synchronized (slicePermissionManager) {
            while (!(parser.getEventType() == 2 && TAG_LIST.equals(parser.getName()) || parser.getEventType() == 1)) {
                parser.next();
            }
            int xmlVersion = XmlUtils.readIntAttribute(parser, "version", 0);
            if (xmlVersion < 2) {
                return;
            }
            while (parser.getEventType() != 1) {
                if (parser.getEventType() == 2) {
                    ArrayMap<PkgUser, DirtyTracker.Persistable> arrayMap;
                    if ("client".equals(parser.getName())) {
                        SliceClientPermissions client = SliceClientPermissions.createFrom(parser, this);
                        arrayMap = this.mCachedClients;
                        synchronized (arrayMap) {
                            this.mCachedClients.put(client.getPkg(), client);
                        }
                        this.onPersistableDirty(client);
                        this.mHandler.sendMessageDelayed(this.mHandler.obtainMessage(4, client.getPkg()), 300000L);
                        continue;
                    }
                    if ("provider".equals(parser.getName())) {
                        SliceProviderPermissions provider = SliceProviderPermissions.createFrom(parser, this);
                        arrayMap = this.mCachedProviders;
                        synchronized (arrayMap) {
                            this.mCachedProviders.put(provider.getPkg(), provider);
                        }
                        this.onPersistableDirty(provider);
                        this.mHandler.sendMessageDelayed(this.mHandler.obtainMessage(5, provider.getPkg()), 300000L);
                        continue;
                    }
                    parser.next();
                    continue;
                }
                parser.next();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SliceClientPermissions getClient(PkgUser pkgUser) {
        SliceClientPermissions client;
        ArrayMap<PkgUser, SliceClientPermissions> arrayMap = this.mCachedClients;
        synchronized (arrayMap) {
            client = this.mCachedClients.get(pkgUser);
        }
        if (client == null) {
            block21: {
                Object object;
                block20: {
                    ParserHolder parser2 = this.getParser(SliceClientPermissions.getFileName(pkgUser));
                    Throwable throwable = null;
                    try {
                        client = SliceClientPermissions.createFrom(parser2.parser, this);
                        object = this.mCachedClients;
                        synchronized (object) {
                            this.mCachedClients.put(pkgUser, client);
                        }
                        this.mHandler.sendMessageDelayed(this.mHandler.obtainMessage(4, pkgUser), 300000L);
                        object = client;
                        if (parser2 == null) break block20;
                    }
                    catch (Throwable throwable2) {
                        try {
                            try {
                                throwable = throwable2;
                                throw throwable2;
                            }
                            catch (Throwable throwable3) {
                                if (parser2 != null) {
                                    SlicePermissionManager.$closeResource(throwable, parser2);
                                }
                                throw throwable3;
                            }
                        }
                        catch (FileNotFoundException parser2) {
                            break block21;
                        }
                        catch (IOException e) {
                            Log.e(TAG, "Can't read client", e);
                            break block21;
                        }
                        catch (XmlPullParserException e) {
                            Log.e(TAG, "Can't read client", e);
                        }
                    }
                    SlicePermissionManager.$closeResource(throwable, parser2);
                }
                return object;
            }
            client = new SliceClientPermissions(pkgUser, this);
            ArrayMap<PkgUser, SliceClientPermissions> arrayMap2 = this.mCachedClients;
            synchronized (arrayMap2) {
                this.mCachedClients.put(pkgUser, client);
            }
        }
        return client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SliceProviderPermissions getProvider(PkgUser pkgUser) {
        SliceProviderPermissions provider;
        ArrayMap<PkgUser, SliceProviderPermissions> arrayMap = this.mCachedProviders;
        synchronized (arrayMap) {
            provider = this.mCachedProviders.get(pkgUser);
        }
        if (provider == null) {
            block21: {
                Object object;
                block20: {
                    ParserHolder parser2 = this.getParser(SliceProviderPermissions.getFileName(pkgUser));
                    Throwable throwable = null;
                    try {
                        provider = SliceProviderPermissions.createFrom(parser2.parser, this);
                        object = this.mCachedProviders;
                        synchronized (object) {
                            this.mCachedProviders.put(pkgUser, provider);
                        }
                        this.mHandler.sendMessageDelayed(this.mHandler.obtainMessage(5, pkgUser), 300000L);
                        object = provider;
                        if (parser2 == null) break block20;
                    }
                    catch (Throwable throwable2) {
                        try {
                            try {
                                throwable = throwable2;
                                throw throwable2;
                            }
                            catch (Throwable throwable3) {
                                if (parser2 != null) {
                                    SlicePermissionManager.$closeResource(throwable, parser2);
                                }
                                throw throwable3;
                            }
                        }
                        catch (FileNotFoundException parser2) {
                            break block21;
                        }
                        catch (IOException e) {
                            Log.e(TAG, "Can't read provider", e);
                            break block21;
                        }
                        catch (XmlPullParserException e) {
                            Log.e(TAG, "Can't read provider", e);
                        }
                    }
                    SlicePermissionManager.$closeResource(throwable, parser2);
                }
                return object;
            }
            provider = new SliceProviderPermissions(pkgUser, this);
            ArrayMap<PkgUser, SliceProviderPermissions> arrayMap2 = this.mCachedProviders;
            synchronized (arrayMap2) {
                this.mCachedProviders.put(pkgUser, provider);
            }
        }
        return provider;
    }

    private ParserHolder getParser(String fileName) throws FileNotFoundException, XmlPullParserException {
        AtomicFile file = this.getFile(fileName);
        ParserHolder holder = new ParserHolder();
        holder.input = file.openRead();
        holder.parser = XmlPullParserFactory.newInstance().newPullParser();
        holder.parser.setInput(holder.input, Xml.Encoding.UTF_8.name());
        return holder;
    }

    private AtomicFile getFile(String fileName) {
        if (!this.mSliceDir.exists()) {
            this.mSliceDir.mkdir();
        }
        return new AtomicFile(new File(this.mSliceDir, fileName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void handlePersist() {
        SlicePermissionManager slicePermissionManager = this;
        synchronized (slicePermissionManager) {
            for (DirtyTracker.Persistable persistable : this.mDirty) {
                FileOutputStream stream;
                AtomicFile file = this.getFile(persistable.getFileName());
                try {
                    stream = file.startWrite();
                }
                catch (IOException e) {
                    Slog.w(TAG, "Failed to save access file", e);
                    return;
                }
                try {
                    XmlSerializer out = XmlPullParserFactory.newInstance().newSerializer();
                    out.setOutput(stream, Xml.Encoding.UTF_8.name());
                    persistable.writeTo(out);
                    out.flush();
                    file.finishWrite(stream);
                }
                catch (IOException | RuntimeException | XmlPullParserException e) {
                    Slog.w(TAG, "Failed to save access file, restoring backup", e);
                    file.failWrite(stream);
                }
            }
            this.mDirty.clear();
        }
    }

    @VisibleForTesting
    void addDirtyImmediate(DirtyTracker.Persistable obj) {
        this.mDirty.add(obj);
    }

    private void handleRemove(PkgUser pkgUser) {
        this.getFile(SliceClientPermissions.getFileName(pkgUser)).delete();
        this.getFile(SliceProviderPermissions.getFileName(pkgUser)).delete();
        this.mDirty.remove(this.mCachedClients.remove(pkgUser));
        this.mDirty.remove(this.mCachedProviders.remove(pkgUser));
    }

    private class ParserHolder
    implements AutoCloseable {
        private InputStream input;
        private XmlPullParser parser;

        private ParserHolder() {
        }

        @Override
        public void close() throws IOException {
            this.input.close();
        }
    }

    public static class PkgUser {
        private static final String SEPARATOR = "@";
        private static final String FORMAT = "%s@%d";
        private final String mPkg;
        private final int mUserId;

        public PkgUser(String pkg, int userId) {
            this.mPkg = pkg;
            this.mUserId = userId;
        }

        public PkgUser(String pkgUserStr) throws IllegalArgumentException {
            try {
                String[] vals = pkgUserStr.split(SEPARATOR, 2);
                this.mPkg = vals[0];
                this.mUserId = Integer.parseInt(vals[1]);
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e);
            }
        }

        public String getPkg() {
            return this.mPkg;
        }

        public int getUserId() {
            return this.mUserId;
        }

        public int hashCode() {
            return this.mPkg.hashCode() + this.mUserId;
        }

        public boolean equals(Object obj) {
            if (!this.getClass().equals(obj != null ? obj.getClass() : null)) {
                return false;
            }
            PkgUser other = (PkgUser)obj;
            return Objects.equals(other.mPkg, this.mPkg) && other.mUserId == this.mUserId;
        }

        public String toString() {
            return String.format(FORMAT, this.mPkg, this.mUserId);
        }
    }

    private final class H
    extends Handler {
        private static final int MSG_ADD_DIRTY = 1;
        private static final int MSG_PERSIST = 2;
        private static final int MSG_REMOVE = 3;
        private static final int MSG_CLEAR_CLIENT = 4;
        private static final int MSG_CLEAR_PROVIDER = 5;

        public H(Looper looper) {
            super(looper);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    SlicePermissionManager.this.mDirty.add((DirtyTracker.Persistable)msg.obj);
                    break;
                }
                case 2: {
                    SlicePermissionManager.this.handlePersist();
                    break;
                }
                case 3: {
                    SlicePermissionManager.this.handleRemove((PkgUser)msg.obj);
                    break;
                }
                case 4: {
                    ArrayMap arrayMap = SlicePermissionManager.this.mCachedClients;
                    synchronized (arrayMap) {
                        SlicePermissionManager.this.mCachedClients.remove(msg.obj);
                        break;
                    }
                }
                case 5: {
                    ArrayMap arrayMap = SlicePermissionManager.this.mCachedProviders;
                    synchronized (arrayMap) {
                        SlicePermissionManager.this.mCachedProviders.remove(msg.obj);
                        break;
                    }
                }
            }
        }
    }
}

