/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.soundtrigger;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.ResolveInfo;
import android.hardware.soundtrigger.IRecognitionStatusCallback;
import android.hardware.soundtrigger.SoundTrigger;
import android.media.AudioAttributes;
import android.media.AudioFormat;
import android.media.AudioRecord;
import android.media.soundtrigger.ISoundTriggerDetectionService;
import android.media.soundtrigger.ISoundTriggerDetectionServiceClient;
import android.os.Binder;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Parcel;
import android.os.ParcelUuid;
import android.os.PowerManager;
import android.os.RemoteException;
import android.os.UserHandle;
import android.provider.Settings;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.Slog;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.app.ISoundTriggerService;
import com.android.internal.util.Preconditions;
import com.android.internal.util.function.pooled.PooledLambda;
import com.android.server.SystemService;
import com.android.server.soundtrigger.SoundTriggerDbHelper;
import com.android.server.soundtrigger.SoundTriggerHelper;
import com.android.server.soundtrigger.SoundTriggerInternal;
import com.android.server.soundtrigger.SoundTriggerLogger;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.TimeUnit;

public class SoundTriggerService
extends SystemService {
    private static final String TAG = "SoundTriggerService";
    private static final boolean DEBUG = true;
    final Context mContext;
    private Object mLock;
    private final SoundTriggerServiceStub mServiceStub;
    private final LocalSoundTriggerService mLocalSoundTriggerService;
    private SoundTriggerDbHelper mDbHelper;
    private SoundTriggerHelper mSoundTriggerHelper;
    private final TreeMap<UUID, SoundTrigger.SoundModel> mLoadedModels;
    private Object mCallbacksLock;
    private final TreeMap<UUID, IRecognitionStatusCallback> mCallbacks;
    @GuardedBy(value={"mLock"})
    private final ArrayMap<String, NumOps> mNumOpsPerPackage = new ArrayMap();
    private static final SoundTriggerLogger sEventLogger = new SoundTriggerLogger(200, "SoundTrigger activity");

    public SoundTriggerService(Context context) {
        super(context);
        this.mContext = context;
        this.mServiceStub = new SoundTriggerServiceStub();
        this.mLocalSoundTriggerService = new LocalSoundTriggerService(context);
        this.mLoadedModels = new TreeMap();
        this.mCallbacksLock = new Object();
        this.mCallbacks = new TreeMap();
        this.mLock = new Object();
    }

    @Override
    public void onStart() {
        this.publishBinderService("soundtrigger", this.mServiceStub);
        this.publishLocalService(SoundTriggerInternal.class, this.mLocalSoundTriggerService);
    }

    @Override
    public void onBootPhase(int phase) {
        if (500 == phase) {
            this.initSoundTriggerHelper();
            this.mLocalSoundTriggerService.setSoundTriggerHelper(this.mSoundTriggerHelper);
        } else if (600 == phase) {
            this.mDbHelper = new SoundTriggerDbHelper(this.mContext);
        }
    }

    @Override
    public void onStartUser(int userHandle) {
    }

    @Override
    public void onSwitchUser(int userHandle) {
    }

    private synchronized void initSoundTriggerHelper() {
        if (this.mSoundTriggerHelper == null) {
            this.mSoundTriggerHelper = new SoundTriggerHelper(this.mContext);
        }
    }

    private synchronized boolean isInitialized() {
        if (this.mSoundTriggerHelper == null) {
            Slog.e(TAG, "SoundTriggerHelper not initialized.");
            return false;
        }
        return true;
    }

    private void enforceCallingPermission(String permission2) {
        if (this.mContext.checkCallingOrSelfPermission(permission2) != 0) {
            throw new SecurityException("Caller does not hold the permission " + permission2);
        }
    }

    public final class LocalSoundTriggerService
    extends SoundTriggerInternal {
        private final Context mContext;
        private SoundTriggerHelper mSoundTriggerHelper;

        LocalSoundTriggerService(Context context) {
            this.mContext = context;
        }

        synchronized void setSoundTriggerHelper(SoundTriggerHelper helper) {
            this.mSoundTriggerHelper = helper;
        }

        @Override
        public int startRecognition(int keyphraseId, SoundTrigger.KeyphraseSoundModel soundModel, IRecognitionStatusCallback listener, SoundTrigger.RecognitionConfig recognitionConfig) {
            if (!this.isInitialized()) {
                return Integer.MIN_VALUE;
            }
            return this.mSoundTriggerHelper.startKeyphraseRecognition(keyphraseId, soundModel, listener, recognitionConfig);
        }

        @Override
        public synchronized int stopRecognition(int keyphraseId, IRecognitionStatusCallback listener) {
            if (!this.isInitialized()) {
                return Integer.MIN_VALUE;
            }
            return this.mSoundTriggerHelper.stopKeyphraseRecognition(keyphraseId, listener);
        }

        @Override
        public SoundTrigger.ModuleProperties getModuleProperties() {
            if (!this.isInitialized()) {
                return null;
            }
            return this.mSoundTriggerHelper.getModuleProperties();
        }

        @Override
        public int unloadKeyphraseModel(int keyphraseId) {
            if (!this.isInitialized()) {
                return Integer.MIN_VALUE;
            }
            return this.mSoundTriggerHelper.unloadKeyphraseSoundModel(keyphraseId);
        }

        @Override
        public void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
            if (!this.isInitialized()) {
                return;
            }
            this.mSoundTriggerHelper.dump(fd, pw, args);
            sEventLogger.dump(pw);
        }

        private synchronized boolean isInitialized() {
            if (this.mSoundTriggerHelper == null) {
                Slog.e(SoundTriggerService.TAG, "SoundTriggerHelper not initialized.");
                sEventLogger.log(new SoundTriggerLogger.StringEvent("SoundTriggerHelper not initialized."));
                return false;
            }
            return true;
        }
    }

    private class RemoteSoundTriggerDetectionService
    extends IRecognitionStatusCallback.Stub
    implements ServiceConnection {
        private static final int MSG_STOP_ALL_PENDING_OPERATIONS = 1;
        private final Object mRemoteServiceLock = new Object();
        private final ParcelUuid mPuuid;
        private final Bundle mParams;
        private final ComponentName mServiceName;
        private final UserHandle mUser;
        private final SoundTrigger.RecognitionConfig mRecognitionConfig;
        private final PowerManager.WakeLock mRemoteServiceWakeLock;
        private final Handler mHandler;
        private final ISoundTriggerDetectionServiceClient mClient;
        @GuardedBy(value={"mRemoteServiceLock"})
        private final ArrayList<Operation> mPendingOps = new ArrayList();
        @GuardedBy(value={"mRemoteServiceLock"})
        private final ArraySet<Integer> mRunningOpIds = new ArraySet();
        private final NumOps mNumOps;
        @GuardedBy(value={"mRemoteServiceLock"})
        private ISoundTriggerDetectionService mService;
        @GuardedBy(value={"mRemoteServiceLock"})
        private boolean mIsBound;
        @GuardedBy(value={"mRemoteServiceLock"})
        private boolean mIsDestroyed;
        @GuardedBy(value={"mRemoteServiceLock"})
        private boolean mDestroyOnceRunningOpsDone;
        @GuardedBy(value={"mRemoteServiceLock"})
        private int mNumTotalOpsPerformed;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public RemoteSoundTriggerDetectionService(UUID modelUuid, Bundle params, ComponentName serviceName, UserHandle user, SoundTrigger.RecognitionConfig config) {
            this.mPuuid = new ParcelUuid(modelUuid);
            this.mParams = params;
            this.mServiceName = serviceName;
            this.mUser = user;
            this.mRecognitionConfig = config;
            this.mHandler = new Handler(Looper.getMainLooper());
            PowerManager pm = (PowerManager)SoundTriggerService.this.mContext.getSystemService("power");
            this.mRemoteServiceWakeLock = pm.newWakeLock(1, "RemoteSoundTriggerDetectionService " + this.mServiceName.getPackageName() + ":" + this.mServiceName.getClassName());
            Object object = SoundTriggerService.this.mLock;
            synchronized (object) {
                NumOps numOps = (NumOps)SoundTriggerService.this.mNumOpsPerPackage.get(this.mServiceName.getPackageName());
                if (numOps == null) {
                    numOps = new NumOps();
                    SoundTriggerService.this.mNumOpsPerPackage.put(this.mServiceName.getPackageName(), numOps);
                }
                this.mNumOps = numOps;
            }
            this.mClient = new ISoundTriggerDetectionServiceClient.Stub(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onOpFinished(int opId) {
                    long token = Binder.clearCallingIdentity();
                    try {
                        Object object = RemoteSoundTriggerDetectionService.this.mRemoteServiceLock;
                        synchronized (object) {
                            RemoteSoundTriggerDetectionService.this.mRunningOpIds.remove(opId);
                            if (RemoteSoundTriggerDetectionService.this.mRunningOpIds.isEmpty() && RemoteSoundTriggerDetectionService.this.mPendingOps.isEmpty()) {
                                if (RemoteSoundTriggerDetectionService.this.mDestroyOnceRunningOpsDone) {
                                    RemoteSoundTriggerDetectionService.this.destroy();
                                } else {
                                    RemoteSoundTriggerDetectionService.this.disconnectLocked();
                                }
                            }
                        }
                    }
                    finally {
                        Binder.restoreCallingIdentity(token);
                    }
                }
            };
        }

        @Override
        public boolean pingBinder() {
            return !this.mIsDestroyed && !this.mDestroyOnceRunningOpsDone;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @GuardedBy(value={"mRemoteServiceLock"})
        private void disconnectLocked() {
            if (this.mService != null) {
                try {
                    this.mService.removeClient(this.mPuuid);
                }
                catch (Exception e) {
                    Slog.e(SoundTriggerService.TAG, this.mPuuid + ": Cannot remove client", e);
                    sEventLogger.log(new SoundTriggerLogger.StringEvent(this.mPuuid + ": Cannot remove client"));
                }
                this.mService = null;
            }
            if (this.mIsBound) {
                SoundTriggerService.this.mContext.unbindService(this);
                this.mIsBound = false;
                Object object = SoundTriggerService.this.mCallbacksLock;
                synchronized (object) {
                    this.mRemoteServiceWakeLock.release();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void destroy() {
            Slog.v(SoundTriggerService.TAG, this.mPuuid + ": destroy");
            sEventLogger.log(new SoundTriggerLogger.StringEvent(this.mPuuid + ": destroy"));
            Object object = this.mRemoteServiceLock;
            synchronized (object) {
                this.disconnectLocked();
                this.mIsDestroyed = true;
            }
            if (!this.mDestroyOnceRunningOpsDone) {
                object = SoundTriggerService.this.mCallbacksLock;
                synchronized (object) {
                    SoundTriggerService.this.mCallbacks.remove(this.mPuuid.getUuid());
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void stopAllPendingOperations() {
            Object object = this.mRemoteServiceLock;
            synchronized (object) {
                if (this.mIsDestroyed) {
                    return;
                }
                if (this.mService != null) {
                    int numOps = this.mRunningOpIds.size();
                    for (int i = 0; i < numOps; ++i) {
                        try {
                            this.mService.onStopOperation(this.mPuuid, this.mRunningOpIds.valueAt(i));
                            continue;
                        }
                        catch (Exception e) {
                            Slog.e(SoundTriggerService.TAG, this.mPuuid + ": Could not stop operation " + this.mRunningOpIds.valueAt(i), e);
                            sEventLogger.log(new SoundTriggerLogger.StringEvent(this.mPuuid + ": Could not stop operation " + this.mRunningOpIds.valueAt(i)));
                        }
                    }
                    this.mRunningOpIds.clear();
                }
                this.disconnectLocked();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void bind() {
            long token = Binder.clearCallingIdentity();
            try {
                Intent i = new Intent();
                i.setComponent(this.mServiceName);
                ResolveInfo ri = SoundTriggerService.this.mContext.getPackageManager().resolveServiceAsUser(i, 268435588, this.mUser.getIdentifier());
                if (ri == null) {
                    Slog.w(SoundTriggerService.TAG, this.mPuuid + ": " + this.mServiceName + " not found");
                    sEventLogger.log(new SoundTriggerLogger.StringEvent(this.mPuuid + ": " + this.mServiceName + " not found"));
                    return;
                }
                if (!"android.permission.BIND_SOUND_TRIGGER_DETECTION_SERVICE".equals(ri.serviceInfo.permission)) {
                    Slog.w(SoundTriggerService.TAG, this.mPuuid + ": " + this.mServiceName + " does not require " + "android.permission.BIND_SOUND_TRIGGER_DETECTION_SERVICE");
                    sEventLogger.log(new SoundTriggerLogger.StringEvent(this.mPuuid + ": " + this.mServiceName + " does not require " + "android.permission.BIND_SOUND_TRIGGER_DETECTION_SERVICE"));
                    return;
                }
                this.mIsBound = SoundTriggerService.this.mContext.bindServiceAsUser(i, this, 0x4000001, this.mUser);
                if (this.mIsBound) {
                    this.mRemoteServiceWakeLock.acquire();
                } else {
                    Slog.w(SoundTriggerService.TAG, this.mPuuid + ": Could not bind to " + this.mServiceName);
                    sEventLogger.log(new SoundTriggerLogger.StringEvent(this.mPuuid + ": Could not bind to " + this.mServiceName));
                }
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void runOrAddOperation(Operation op) {
            Object object = this.mRemoteServiceLock;
            synchronized (object) {
                if (this.mIsDestroyed || this.mDestroyOnceRunningOpsDone) {
                    Slog.w(SoundTriggerService.TAG, this.mPuuid + ": Dropped operation as already destroyed or marked for destruction");
                    sEventLogger.log(new SoundTriggerLogger.StringEvent(this.mPuuid + ":Dropped operation as already destroyed or marked for destruction"));
                    op.drop();
                    return;
                }
                if (this.mService == null) {
                    this.mPendingOps.add(op);
                    if (!this.mIsBound) {
                        this.bind();
                    }
                } else {
                    long currentTime = System.nanoTime();
                    this.mNumOps.clearOldOps(currentTime);
                    int opsAllowed = Settings.Global.getInt(SoundTriggerService.this.mContext.getContentResolver(), "max_sound_trigger_detection_service_ops_per_day", Integer.MAX_VALUE);
                    int opsAdded = this.mNumOps.getOpsAdded();
                    this.mNumOps.addOp(currentTime);
                    int opId = this.mNumTotalOpsPerformed;
                    do {
                        ++this.mNumTotalOpsPerformed;
                    } while (this.mRunningOpIds.contains(opId));
                    try {
                        Slog.v(SoundTriggerService.TAG, this.mPuuid + ": runOp " + opId);
                        sEventLogger.log(new SoundTriggerLogger.StringEvent(this.mPuuid + ": runOp " + opId));
                        op.run(opId, this.mService);
                        this.mRunningOpIds.add(opId);
                    }
                    catch (Exception e) {
                        Slog.e(SoundTriggerService.TAG, this.mPuuid + ": Could not run operation " + opId, e);
                        sEventLogger.log(new SoundTriggerLogger.StringEvent(this.mPuuid + ": Could not run operation " + opId));
                    }
                    if (this.mPendingOps.isEmpty() && this.mRunningOpIds.isEmpty()) {
                        if (this.mDestroyOnceRunningOpsDone) {
                            this.destroy();
                        } else {
                            this.disconnectLocked();
                        }
                    } else {
                        this.mHandler.removeMessages(1);
                        this.mHandler.sendMessageDelayed(PooledLambda.obtainMessage(RemoteSoundTriggerDetectionService::stopAllPendingOperations, this).setWhat(1), Settings.Global.getLong(SoundTriggerService.this.mContext.getContentResolver(), "sound_trigger_detection_service_op_timeout", Long.MAX_VALUE));
                    }
                }
            }
        }

        @Override
        public void onKeyphraseDetected(SoundTrigger.KeyphraseRecognitionEvent event) {
            Slog.w(SoundTriggerService.TAG, this.mPuuid + "->" + this.mServiceName + ": IGNORED onKeyphraseDetected(" + event + ")");
            sEventLogger.log(new SoundTriggerLogger.StringEvent(this.mPuuid + "->" + this.mServiceName + ": IGNORED onKeyphraseDetected(" + event + ")"));
        }

        private AudioRecord createAudioRecordForEvent(SoundTrigger.GenericRecognitionEvent event) {
            AudioAttributes.Builder attributesBuilder = new AudioAttributes.Builder();
            attributesBuilder.setInternalCapturePreset(1999);
            AudioAttributes attributes = attributesBuilder.build();
            AudioFormat originalFormat = event.getCaptureFormat();
            AudioFormat captureFormat = new AudioFormat.Builder().setChannelMask(originalFormat.getChannelMask()).setEncoding(originalFormat.getEncoding()).setSampleRate(originalFormat.getSampleRate()).build();
            int bufferSize = AudioRecord.getMinBufferSize(captureFormat.getSampleRate() == 0 ? 192000 : captureFormat.getSampleRate(), captureFormat.getChannelCount() == 2 ? 12 : 16, captureFormat.getEncoding());
            sEventLogger.log(new SoundTriggerLogger.StringEvent("createAudioRecordForEvent"));
            return new AudioRecord(attributes, captureFormat, bufferSize, event.getCaptureSession());
        }

        @Override
        public void onGenericSoundTriggerDetected(SoundTrigger.GenericRecognitionEvent event) {
            Slog.v(SoundTriggerService.TAG, this.mPuuid + ": Generic sound trigger event: " + event);
            sEventLogger.log(new SoundTriggerLogger.StringEvent(this.mPuuid + ": Generic sound trigger event: " + event));
            this.runOrAddOperation(new Operation(() -> {
                if (!this.mRecognitionConfig.allowMultipleTriggers) {
                    Object object = SoundTriggerService.this.mCallbacksLock;
                    synchronized (object) {
                        SoundTriggerService.this.mCallbacks.remove(this.mPuuid.getUuid());
                    }
                    this.mDestroyOnceRunningOpsDone = true;
                }
            }, (opId, service) -> service.onGenericRecognitionEvent(this.mPuuid, opId, event), () -> {
                if (event.isCaptureAvailable()) {
                    AudioRecord capturedData = this.createAudioRecordForEvent(event);
                    capturedData.startRecording();
                    capturedData.release();
                }
            }));
        }

        @Override
        public void onError(int status) {
            Slog.v(SoundTriggerService.TAG, this.mPuuid + ": onError: " + status);
            sEventLogger.log(new SoundTriggerLogger.StringEvent(this.mPuuid + ": onError: " + status));
            this.runOrAddOperation(new Operation(() -> {
                Object object = SoundTriggerService.this.mCallbacksLock;
                synchronized (object) {
                    SoundTriggerService.this.mCallbacks.remove(this.mPuuid.getUuid());
                }
                this.mDestroyOnceRunningOpsDone = true;
            }, (opId, service) -> service.onError(this.mPuuid, opId, status), null));
        }

        @Override
        public void onRecognitionPaused() {
            Slog.i(SoundTriggerService.TAG, this.mPuuid + "->" + this.mServiceName + ": IGNORED onRecognitionPaused");
            sEventLogger.log(new SoundTriggerLogger.StringEvent(this.mPuuid + "->" + this.mServiceName + ": IGNORED onRecognitionPaused"));
        }

        @Override
        public void onRecognitionResumed() {
            Slog.i(SoundTriggerService.TAG, this.mPuuid + "->" + this.mServiceName + ": IGNORED onRecognitionResumed");
            sEventLogger.log(new SoundTriggerLogger.StringEvent(this.mPuuid + "->" + this.mServiceName + ": IGNORED onRecognitionResumed"));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onServiceConnected(ComponentName name, IBinder service) {
            Slog.v(SoundTriggerService.TAG, this.mPuuid + ": onServiceConnected(" + service + ")");
            sEventLogger.log(new SoundTriggerLogger.StringEvent(this.mPuuid + ": onServiceConnected(" + service + ")"));
            Object object = this.mRemoteServiceLock;
            synchronized (object) {
                this.mService = ISoundTriggerDetectionService.Stub.asInterface(service);
                try {
                    this.mService.setClient(this.mPuuid, this.mParams, this.mClient);
                }
                catch (Exception e) {
                    Slog.e(SoundTriggerService.TAG, this.mPuuid + ": Could not init " + this.mServiceName, e);
                    return;
                }
                while (!this.mPendingOps.isEmpty()) {
                    this.runOrAddOperation(this.mPendingOps.remove(0));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onServiceDisconnected(ComponentName name) {
            Slog.v(SoundTriggerService.TAG, this.mPuuid + ": onServiceDisconnected");
            sEventLogger.log(new SoundTriggerLogger.StringEvent(this.mPuuid + ": onServiceDisconnected"));
            Object object = this.mRemoteServiceLock;
            synchronized (object) {
                this.mService = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onBindingDied(ComponentName name) {
            Slog.v(SoundTriggerService.TAG, this.mPuuid + ": onBindingDied");
            sEventLogger.log(new SoundTriggerLogger.StringEvent(this.mPuuid + ": onBindingDied"));
            Object object = this.mRemoteServiceLock;
            synchronized (object) {
                this.destroy();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onNullBinding(ComponentName name) {
            Slog.w(SoundTriggerService.TAG, name + " for model " + this.mPuuid + " returned a null binding");
            sEventLogger.log(new SoundTriggerLogger.StringEvent(name + " for model " + this.mPuuid + " returned a null binding"));
            Object object = this.mRemoteServiceLock;
            synchronized (object) {
                this.disconnectLocked();
            }
        }
    }

    private static class Operation {
        private final Runnable mSetupOp;
        private final ExecuteOp mExecuteOp;
        private final Runnable mDropOp;

        private Operation(Runnable setupOp, ExecuteOp executeOp, Runnable cancelOp) {
            this.mSetupOp = setupOp;
            this.mExecuteOp = executeOp;
            this.mDropOp = cancelOp;
        }

        private void setup() {
            if (this.mSetupOp != null) {
                this.mSetupOp.run();
            }
        }

        void run(int opId, ISoundTriggerDetectionService service) throws RemoteException {
            this.setup();
            this.mExecuteOp.run(opId, service);
        }

        void drop() {
            this.setup();
            if (this.mDropOp != null) {
                this.mDropOp.run();
            }
        }

        private static interface ExecuteOp {
            public void run(int var1, ISoundTriggerDetectionService var2) throws RemoteException;
        }
    }

    private static class NumOps {
        private final Object mLock = new Object();
        @GuardedBy(value={"mLock"})
        private int[] mNumOps = new int[24];
        @GuardedBy(value={"mLock"})
        private long mLastOpsHourSinceBoot;

        private NumOps() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void clearOldOps(long currentTime) {
            Object object = this.mLock;
            synchronized (object) {
                long numHoursSinceBoot = TimeUnit.HOURS.convert(currentTime, TimeUnit.NANOSECONDS);
                if (this.mLastOpsHourSinceBoot != 0L) {
                    for (long hour = this.mLastOpsHourSinceBoot + 1L; hour <= numHoursSinceBoot; ++hour) {
                        this.mNumOps[(int)(hour % 24L)] = 0;
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void addOp(long currentTime) {
            Object object = this.mLock;
            synchronized (object) {
                long numHoursSinceBoot = TimeUnit.HOURS.convert(currentTime, TimeUnit.NANOSECONDS);
                int n = (int)(numHoursSinceBoot % 24L);
                this.mNumOps[n] = this.mNumOps[n] + 1;
                this.mLastOpsHourSinceBoot = numHoursSinceBoot;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        int getOpsAdded() {
            Object object = this.mLock;
            synchronized (object) {
                int totalOperationsInLastDay = 0;
                for (int i = 0; i < 24; ++i) {
                    totalOperationsInLastDay += this.mNumOps[i];
                }
                return totalOperationsInLastDay;
            }
        }
    }

    class SoundTriggerServiceStub
    extends ISoundTriggerService.Stub {
        SoundTriggerServiceStub() {
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            try {
                return super.onTransact(code, data, reply, flags);
            }
            catch (RuntimeException e) {
                if (!(e instanceof SecurityException)) {
                    Slog.wtf(SoundTriggerService.TAG, "SoundTriggerService Crash", e);
                }
                throw e;
            }
        }

        @Override
        public int startRecognition(ParcelUuid parcelUuid, IRecognitionStatusCallback callback, SoundTrigger.RecognitionConfig config) {
            SoundTriggerService.this.enforceCallingPermission("android.permission.MANAGE_SOUND_TRIGGER");
            if (!SoundTriggerService.this.isInitialized()) {
                return Integer.MIN_VALUE;
            }
            Slog.i(SoundTriggerService.TAG, "startRecognition(): Uuid : " + parcelUuid);
            sEventLogger.log(new SoundTriggerLogger.StringEvent("startRecognition(): Uuid : " + parcelUuid));
            SoundTrigger.GenericSoundModel model = this.getSoundModel(parcelUuid);
            if (model == null) {
                Slog.e(SoundTriggerService.TAG, "Null model in database for id: " + parcelUuid);
                sEventLogger.log(new SoundTriggerLogger.StringEvent("startRecognition(): Null model in database for id: " + parcelUuid));
                return Integer.MIN_VALUE;
            }
            return SoundTriggerService.this.mSoundTriggerHelper.startGenericRecognition(parcelUuid.getUuid(), model, callback, config);
        }

        @Override
        public int stopRecognition(ParcelUuid parcelUuid, IRecognitionStatusCallback callback) {
            SoundTriggerService.this.enforceCallingPermission("android.permission.MANAGE_SOUND_TRIGGER");
            Slog.i(SoundTriggerService.TAG, "stopRecognition(): Uuid : " + parcelUuid);
            sEventLogger.log(new SoundTriggerLogger.StringEvent("stopRecognition(): Uuid : " + parcelUuid));
            if (!SoundTriggerService.this.isInitialized()) {
                return Integer.MIN_VALUE;
            }
            return SoundTriggerService.this.mSoundTriggerHelper.stopGenericRecognition(parcelUuid.getUuid(), callback);
        }

        @Override
        public SoundTrigger.GenericSoundModel getSoundModel(ParcelUuid soundModelId) {
            SoundTriggerService.this.enforceCallingPermission("android.permission.MANAGE_SOUND_TRIGGER");
            Slog.i(SoundTriggerService.TAG, "getSoundModel(): id = " + soundModelId);
            sEventLogger.log(new SoundTriggerLogger.StringEvent("getSoundModel(): id = " + soundModelId));
            SoundTrigger.GenericSoundModel model = SoundTriggerService.this.mDbHelper.getGenericSoundModel(soundModelId.getUuid());
            return model;
        }

        @Override
        public void updateSoundModel(SoundTrigger.GenericSoundModel soundModel) {
            SoundTriggerService.this.enforceCallingPermission("android.permission.MANAGE_SOUND_TRIGGER");
            Slog.i(SoundTriggerService.TAG, "updateSoundModel(): model = " + soundModel);
            sEventLogger.log(new SoundTriggerLogger.StringEvent("updateSoundModel(): model = " + soundModel));
            SoundTriggerService.this.mDbHelper.updateGenericSoundModel(soundModel);
        }

        @Override
        public void deleteSoundModel(ParcelUuid soundModelId) {
            SoundTriggerService.this.enforceCallingPermission("android.permission.MANAGE_SOUND_TRIGGER");
            Slog.i(SoundTriggerService.TAG, "deleteSoundModel(): id = " + soundModelId);
            sEventLogger.log(new SoundTriggerLogger.StringEvent("deleteSoundModel(): id = " + soundModelId));
            SoundTriggerService.this.mSoundTriggerHelper.unloadGenericSoundModel(soundModelId.getUuid());
            SoundTriggerService.this.mDbHelper.deleteGenericSoundModel(soundModelId.getUuid());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int loadGenericSoundModel(SoundTrigger.GenericSoundModel soundModel) {
            SoundTriggerService.this.enforceCallingPermission("android.permission.MANAGE_SOUND_TRIGGER");
            if (!SoundTriggerService.this.isInitialized()) {
                return Integer.MIN_VALUE;
            }
            if (soundModel == null || soundModel.uuid == null) {
                Slog.e(SoundTriggerService.TAG, "Invalid sound model");
                sEventLogger.log(new SoundTriggerLogger.StringEvent("loadGenericSoundModel(): Invalid sound model"));
                return Integer.MIN_VALUE;
            }
            Slog.i(SoundTriggerService.TAG, "loadGenericSoundModel(): id = " + soundModel.uuid);
            sEventLogger.log(new SoundTriggerLogger.StringEvent("loadGenericSoundModel(): id = " + soundModel.uuid));
            Object object = SoundTriggerService.this.mLock;
            synchronized (object) {
                SoundTrigger.SoundModel oldModel = (SoundTrigger.SoundModel)SoundTriggerService.this.mLoadedModels.get(soundModel.uuid);
                if (oldModel != null && !oldModel.equals(soundModel)) {
                    SoundTriggerService.this.mSoundTriggerHelper.unloadGenericSoundModel(soundModel.uuid);
                    Object object2 = SoundTriggerService.this.mCallbacksLock;
                    synchronized (object2) {
                        SoundTriggerService.this.mCallbacks.remove(soundModel.uuid);
                    }
                }
                SoundTriggerService.this.mLoadedModels.put(soundModel.uuid, soundModel);
            }
            return 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int loadKeyphraseSoundModel(SoundTrigger.KeyphraseSoundModel soundModel) {
            SoundTriggerService.this.enforceCallingPermission("android.permission.MANAGE_SOUND_TRIGGER");
            if (!SoundTriggerService.this.isInitialized()) {
                return Integer.MIN_VALUE;
            }
            if (soundModel == null || soundModel.uuid == null) {
                Slog.e(SoundTriggerService.TAG, "Invalid sound model");
                sEventLogger.log(new SoundTriggerLogger.StringEvent("loadKeyphraseSoundModel(): Invalid sound model"));
                return Integer.MIN_VALUE;
            }
            if (soundModel.keyphrases == null || soundModel.keyphrases.length != 1) {
                Slog.e(SoundTriggerService.TAG, "Only one keyphrase per model is currently supported.");
                sEventLogger.log(new SoundTriggerLogger.StringEvent("loadKeyphraseSoundModel(): Only one keyphrase per model is currently supported."));
                return Integer.MIN_VALUE;
            }
            Slog.i(SoundTriggerService.TAG, "loadKeyphraseSoundModel(): id = " + soundModel.uuid);
            sEventLogger.log(new SoundTriggerLogger.StringEvent("loadKeyphraseSoundModel(): id = " + soundModel.uuid));
            Object object = SoundTriggerService.this.mLock;
            synchronized (object) {
                SoundTrigger.SoundModel oldModel = (SoundTrigger.SoundModel)SoundTriggerService.this.mLoadedModels.get(soundModel.uuid);
                if (oldModel != null && !oldModel.equals(soundModel)) {
                    SoundTriggerService.this.mSoundTriggerHelper.unloadKeyphraseSoundModel(soundModel.keyphrases[0].id);
                    Object object2 = SoundTriggerService.this.mCallbacksLock;
                    synchronized (object2) {
                        SoundTriggerService.this.mCallbacks.remove(soundModel.uuid);
                    }
                }
                SoundTriggerService.this.mLoadedModels.put(soundModel.uuid, soundModel);
            }
            return 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int startRecognitionForService(ParcelUuid soundModelId, Bundle params, ComponentName detectionService, SoundTrigger.RecognitionConfig config) {
            Preconditions.checkNotNull(soundModelId);
            Preconditions.checkNotNull(detectionService);
            Preconditions.checkNotNull(config);
            SoundTriggerService.this.enforceCallingPermission("android.permission.MANAGE_SOUND_TRIGGER");
            if (!SoundTriggerService.this.isInitialized()) {
                return Integer.MIN_VALUE;
            }
            Slog.i(SoundTriggerService.TAG, "startRecognition(): id = " + soundModelId);
            sEventLogger.log(new SoundTriggerLogger.StringEvent("startRecognitionForService(): id = " + soundModelId));
            RemoteSoundTriggerDetectionService callback = new RemoteSoundTriggerDetectionService(soundModelId.getUuid(), params, detectionService, Binder.getCallingUserHandle(), config);
            Object object = SoundTriggerService.this.mLock;
            synchronized (object) {
                int ret;
                SoundTrigger.SoundModel soundModel = (SoundTrigger.SoundModel)SoundTriggerService.this.mLoadedModels.get(soundModelId.getUuid());
                if (soundModel == null) {
                    Slog.e(SoundTriggerService.TAG, soundModelId + " is not loaded");
                    sEventLogger.log(new SoundTriggerLogger.StringEvent("startRecognitionForService():" + soundModelId + " is not loaded"));
                    return Integer.MIN_VALUE;
                }
                IRecognitionStatusCallback existingCallback = null;
                Object object2 = SoundTriggerService.this.mCallbacksLock;
                synchronized (object2) {
                    existingCallback = (IRecognitionStatusCallback)SoundTriggerService.this.mCallbacks.get(soundModelId.getUuid());
                }
                if (existingCallback != null) {
                    Slog.e(SoundTriggerService.TAG, soundModelId + " is already running");
                    sEventLogger.log(new SoundTriggerLogger.StringEvent("startRecognitionForService():" + soundModelId + " is already running"));
                    return Integer.MIN_VALUE;
                }
                switch (soundModel.type) {
                    case 1: {
                        ret = SoundTriggerService.this.mSoundTriggerHelper.startGenericRecognition(soundModel.uuid, (SoundTrigger.GenericSoundModel)soundModel, callback, config);
                        break;
                    }
                    default: {
                        Slog.e(SoundTriggerService.TAG, "Unknown model type");
                        sEventLogger.log(new SoundTriggerLogger.StringEvent("startRecognitionForService(): Unknown model type"));
                        return Integer.MIN_VALUE;
                    }
                }
                if (ret != 0) {
                    Slog.e(SoundTriggerService.TAG, "Failed to start model: " + ret);
                    sEventLogger.log(new SoundTriggerLogger.StringEvent("startRecognitionForService(): Failed to start model:"));
                    return ret;
                }
                Object object3 = SoundTriggerService.this.mCallbacksLock;
                synchronized (object3) {
                    SoundTriggerService.this.mCallbacks.put(soundModelId.getUuid(), callback);
                }
            }
            return 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int stopRecognitionForService(ParcelUuid soundModelId) {
            SoundTriggerService.this.enforceCallingPermission("android.permission.MANAGE_SOUND_TRIGGER");
            if (!SoundTriggerService.this.isInitialized()) {
                return Integer.MIN_VALUE;
            }
            Slog.i(SoundTriggerService.TAG, "stopRecognition(): id = " + soundModelId);
            sEventLogger.log(new SoundTriggerLogger.StringEvent("stopRecognitionForService(): id = " + soundModelId));
            Object object = SoundTriggerService.this.mLock;
            synchronized (object) {
                int ret;
                SoundTrigger.SoundModel soundModel = (SoundTrigger.SoundModel)SoundTriggerService.this.mLoadedModels.get(soundModelId.getUuid());
                if (soundModel == null) {
                    Slog.e(SoundTriggerService.TAG, soundModelId + " is not loaded");
                    sEventLogger.log(new SoundTriggerLogger.StringEvent("stopRecognitionForService(): " + soundModelId + " is not loaded"));
                    return Integer.MIN_VALUE;
                }
                IRecognitionStatusCallback callback = null;
                Object object2 = SoundTriggerService.this.mCallbacksLock;
                synchronized (object2) {
                    callback = (IRecognitionStatusCallback)SoundTriggerService.this.mCallbacks.get(soundModelId.getUuid());
                }
                if (callback == null) {
                    Slog.e(SoundTriggerService.TAG, soundModelId + " is not running");
                    sEventLogger.log(new SoundTriggerLogger.StringEvent("stopRecognitionForService(): " + soundModelId + " is not running"));
                    return Integer.MIN_VALUE;
                }
                switch (soundModel.type) {
                    case 1: {
                        ret = SoundTriggerService.this.mSoundTriggerHelper.stopGenericRecognition(soundModel.uuid, callback);
                        break;
                    }
                    default: {
                        Slog.e(SoundTriggerService.TAG, "Unknown model type");
                        sEventLogger.log(new SoundTriggerLogger.StringEvent("stopRecognitionForService(): Unknown model type"));
                        return Integer.MIN_VALUE;
                    }
                }
                if (ret != 0) {
                    Slog.e(SoundTriggerService.TAG, "Failed to stop model: " + ret);
                    sEventLogger.log(new SoundTriggerLogger.StringEvent("stopRecognitionForService(): Failed to stop model: " + ret));
                    return ret;
                }
                Object object3 = SoundTriggerService.this.mCallbacksLock;
                synchronized (object3) {
                    SoundTriggerService.this.mCallbacks.remove(soundModelId.getUuid());
                }
            }
            return 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int unloadSoundModel(ParcelUuid soundModelId) {
            SoundTriggerService.this.enforceCallingPermission("android.permission.MANAGE_SOUND_TRIGGER");
            if (!SoundTriggerService.this.isInitialized()) {
                return Integer.MIN_VALUE;
            }
            Slog.i(SoundTriggerService.TAG, "unloadSoundModel(): id = " + soundModelId);
            sEventLogger.log(new SoundTriggerLogger.StringEvent("unloadSoundModel(): id = " + soundModelId));
            Object object = SoundTriggerService.this.mLock;
            synchronized (object) {
                int ret;
                SoundTrigger.SoundModel soundModel = (SoundTrigger.SoundModel)SoundTriggerService.this.mLoadedModels.get(soundModelId.getUuid());
                if (soundModel == null) {
                    Slog.e(SoundTriggerService.TAG, soundModelId + " is not loaded");
                    sEventLogger.log(new SoundTriggerLogger.StringEvent("unloadSoundModel(): " + soundModelId + " is not loaded"));
                    return Integer.MIN_VALUE;
                }
                switch (soundModel.type) {
                    case 0: {
                        ret = SoundTriggerService.this.mSoundTriggerHelper.unloadKeyphraseSoundModel(((SoundTrigger.KeyphraseSoundModel)soundModel).keyphrases[0].id);
                        break;
                    }
                    case 1: {
                        ret = SoundTriggerService.this.mSoundTriggerHelper.unloadGenericSoundModel(soundModel.uuid);
                        break;
                    }
                    default: {
                        Slog.e(SoundTriggerService.TAG, "Unknown model type");
                        sEventLogger.log(new SoundTriggerLogger.StringEvent("unloadSoundModel(): Unknown model type"));
                        return Integer.MIN_VALUE;
                    }
                }
                if (ret != 0) {
                    Slog.e(SoundTriggerService.TAG, "Failed to unload model");
                    sEventLogger.log(new SoundTriggerLogger.StringEvent("unloadSoundModel(): Failed to unload model"));
                    return ret;
                }
                SoundTriggerService.this.mLoadedModels.remove(soundModelId.getUuid());
                return 0;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isRecognitionActive(ParcelUuid parcelUuid) {
            SoundTriggerService.this.enforceCallingPermission("android.permission.MANAGE_SOUND_TRIGGER");
            if (!SoundTriggerService.this.isInitialized()) {
                return false;
            }
            Object object = SoundTriggerService.this.mCallbacksLock;
            synchronized (object) {
                IRecognitionStatusCallback callback = (IRecognitionStatusCallback)SoundTriggerService.this.mCallbacks.get(parcelUuid.getUuid());
                if (callback == null) {
                    return false;
                }
            }
            return SoundTriggerService.this.mSoundTriggerHelper.isRecognitionRequested(parcelUuid.getUuid());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int getModelState(ParcelUuid soundModelId) {
            SoundTriggerService.this.enforceCallingPermission("android.permission.MANAGE_SOUND_TRIGGER");
            int ret = Integer.MIN_VALUE;
            if (!SoundTriggerService.this.isInitialized()) {
                return ret;
            }
            Slog.i(SoundTriggerService.TAG, "getModelState(): id = " + soundModelId);
            sEventLogger.log(new SoundTriggerLogger.StringEvent("getModelState(): id = " + soundModelId));
            Object object = SoundTriggerService.this.mLock;
            synchronized (object) {
                SoundTrigger.SoundModel soundModel = (SoundTrigger.SoundModel)SoundTriggerService.this.mLoadedModels.get(soundModelId.getUuid());
                if (soundModel == null) {
                    Slog.e(SoundTriggerService.TAG, soundModelId + " is not loaded");
                    sEventLogger.log(new SoundTriggerLogger.StringEvent("getModelState(): " + soundModelId + " is not loaded"));
                    return ret;
                }
                switch (soundModel.type) {
                    case 1: {
                        ret = SoundTriggerService.this.mSoundTriggerHelper.getGenericModelState(soundModel.uuid);
                        break;
                    }
                    default: {
                        Slog.e(SoundTriggerService.TAG, "Unsupported model type, " + soundModel.type);
                        sEventLogger.log(new SoundTriggerLogger.StringEvent("getModelState(): Unsupported model type, " + soundModel.type));
                    }
                }
                return ret;
            }
        }
    }
}

