/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.stats;

import android.app.ActivityManagerInternal;
import android.app.AlarmManager;
import android.app.AppOpsManager;
import android.app.ProcessMemoryState;
import android.bluetooth.BluetoothActivityEnergyInfo;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.UidTraffic;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.IntentSender;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.PermissionInfo;
import android.content.pm.UserInfo;
import android.hardware.face.FaceManager;
import android.hardware.fingerprint.FingerprintManager;
import android.icu.util.TimeZone;
import android.net.ConnectivityManager;
import android.net.INetworkStatsService;
import android.net.Network;
import android.net.NetworkRequest;
import android.net.NetworkStats;
import android.net.wifi.IWifiManager;
import android.net.wifi.WifiActivityEnergyInfo;
import android.os.BatteryStatsInternal;
import android.os.Binder;
import android.os.Build;
import android.os.Bundle;
import android.os.CoolingDevice;
import android.os.Environment;
import android.os.FileUtils;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.IBinder;
import android.os.IStatsCompanionService;
import android.os.IStatsManager;
import android.os.IStoraged;
import android.os.IThermalEventListener;
import android.os.IThermalService;
import android.os.Looper;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import android.os.Process;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.StatFs;
import android.os.StatsDimensionsValue;
import android.os.StatsLogEventWrapper;
import android.os.SynchronousResultReceiver;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.os.Temperature;
import android.os.UserHandle;
import android.os.UserManager;
import android.os.storage.DiskInfo;
import android.os.storage.StorageManager;
import android.os.storage.VolumeInfo;
import android.provider.Settings;
import android.telephony.ModemActivityInfo;
import android.telephony.TelephonyManager;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.Log;
import android.util.Slog;
import android.util.StatsLog;
import android.util.proto.ProtoOutputStream;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.app.procstats.IProcessStats;
import com.android.internal.os.BackgroundThread;
import com.android.internal.os.BatterySipper;
import com.android.internal.os.BatteryStatsHelper;
import com.android.internal.os.BinderCallsStats;
import com.android.internal.os.KernelCpuSpeedReader;
import com.android.internal.os.KernelCpuThreadReader;
import com.android.internal.os.KernelCpuThreadReaderDiff;
import com.android.internal.os.KernelCpuThreadReaderSettingsObserver;
import com.android.internal.os.KernelCpuUidTimeReader;
import com.android.internal.os.KernelWakelockReader;
import com.android.internal.os.KernelWakelockStats;
import com.android.internal.os.LooperStats;
import com.android.internal.os.PowerProfile;
import com.android.internal.os.ProcessCpuTracker;
import com.android.internal.os.StoragedUidIoStatsReader;
import com.android.internal.util.DumpUtils;
import com.android.internal.util.Preconditions;
import com.android.server.BinderCallsStatsService;
import com.android.server.LocalServices;
import com.android.server.SystemService;
import com.android.server.SystemServiceManager;
import com.android.server.am.MemoryStatUtil;
import com.android.server.role.RoleManagerInternal;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import libcore.io.IoUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class StatsCompanionService
extends IStatsCompanionService.Stub {
    private static final long EXTERNAL_STATS_SYNC_TIMEOUT_MILLIS = 2000L;
    private static final long MILLIS_IN_A_DAY = TimeUnit.DAYS.toMillis(1L);
    public static final String RESULT_RECEIVER_CONTROLLER_KEY = "controller_activity";
    public static final String CONFIG_DIR = "/data/misc/stats-service";
    static final String TAG = "StatsCompanionService";
    static final boolean DEBUG = false;
    private static final int APPLICATION_INFO_FIELD_ID = 1;
    private static final int UID_FIELD_ID = 1;
    private static final int VERSION_FIELD_ID = 2;
    private static final int VERSION_STRING_FIELD_ID = 3;
    private static final int PACKAGE_NAME_FIELD_ID = 4;
    private static final int INSTALLER_FIELD_ID = 5;
    public static final int CODE_DATA_BROADCAST = 1;
    public static final int CODE_SUBSCRIBER_BROADCAST = 1;
    public static final int CODE_ACTIVE_CONFIGS_BROADCAST = 1;
    public static final String EXTRA_LAST_REPORT_TIME = "android.app.extra.LAST_REPORT_TIME";
    public static final int DEATH_THRESHOLD = 10;
    private static final String[] MEMORY_INTERESTING_NATIVE_PROCESSES = new String[]{"/system/bin/statsd", "/system/bin/surfaceflinger", "/system/bin/apexd", "/system/bin/audioserver", "/system/bin/cameraserver", "/system/bin/drmserver", "/system/bin/healthd", "/system/bin/incidentd", "/system/bin/installd", "/system/bin/lmkd", "/system/bin/logd", "media.codec", "media.extractor", "media.metrics", "/system/bin/mediadrmserver", "/system/bin/mediaserver", "/system/bin/performanced", "/system/bin/tombstoned", "/system/bin/traced", "/system/bin/traced_probes", "webview_zygote", "zygote", "zygote64"};
    private static final int CPU_TIME_PER_THREAD_FREQ_MAX_NUM_FREQUENCIES = 8;
    private final Context mContext;
    private final AlarmManager mAlarmManager;
    private final INetworkStatsService mNetworkStatsService;
    @GuardedBy(value={"sStatsdLock"})
    private static IStatsManager sStatsd;
    private static final Object sStatsdLock;
    private final AlarmManager.OnAlarmListener mAnomalyAlarmListener = new AnomalyAlarmListener();
    private final AlarmManager.OnAlarmListener mPullingAlarmListener = new PullingAlarmListener();
    private final AlarmManager.OnAlarmListener mPeriodicAlarmListener = new PeriodicAlarmListener();
    private final BroadcastReceiver mAppUpdateReceiver;
    private final BroadcastReceiver mUserUpdateReceiver;
    private final ShutdownEventReceiver mShutdownEventReceiver;
    private final KernelWakelockReader mKernelWakelockReader = new KernelWakelockReader();
    private final KernelWakelockStats mTmpWakelockStats = new KernelWakelockStats();
    private IWifiManager mWifiManager = null;
    private TelephonyManager mTelephony = null;
    @GuardedBy(value={"sStatsdLock"})
    private final HashSet<Long> mDeathTimeMillis = new HashSet();
    @GuardedBy(value={"sStatsdLock"})
    private final HashMap<Long, String> mDeletedFiles = new HashMap();
    private final CompanionHandler mHandler;
    private KernelCpuUidTimeReader.KernelCpuUidUserSysTimeReader mCpuUidUserSysTimeReader = new KernelCpuUidTimeReader.KernelCpuUidUserSysTimeReader(false);
    private KernelCpuSpeedReader[] mKernelCpuSpeedReaders;
    private KernelCpuUidTimeReader.KernelCpuUidFreqTimeReader mCpuUidFreqTimeReader = new KernelCpuUidTimeReader.KernelCpuUidFreqTimeReader(false);
    private KernelCpuUidTimeReader.KernelCpuUidActiveTimeReader mCpuUidActiveTimeReader = new KernelCpuUidTimeReader.KernelCpuUidActiveTimeReader(false);
    private KernelCpuUidTimeReader.KernelCpuUidClusterTimeReader mCpuUidClusterTimeReader = new KernelCpuUidTimeReader.KernelCpuUidClusterTimeReader(false);
    private StoragedUidIoStatsReader mStoragedUidIoStatsReader = new StoragedUidIoStatsReader();
    private final KernelCpuThreadReaderDiff mKernelCpuThreadReader;
    private long mDebugElapsedClockPreviousValue = 0L;
    private long mDebugElapsedClockPullCount = 0L;
    private long mDebugFailingElapsedClockPreviousValue = 0L;
    private long mDebugFailingElapsedClockPullCount = 0L;
    private BatteryStatsHelper mBatteryStatsHelper = null;
    private static final int MAX_BATTERY_STATS_HELPER_FREQUENCY_MS = 1000;
    private long mBatteryStatsHelperTimestampMs = -1000L;
    private static IThermalService sThermalService;
    private File mBaseDir = new File(SystemServiceManager.ensureSystemDir(), "stats_companion");
    @GuardedBy(value={"this"})
    ProcessCpuTracker mProcessCpuTracker = null;
    private IProcessStats mProcessStats = IProcessStats.Stub.asInterface(ServiceManager.getService("procstats"));

    public StatsCompanionService(Context context) {
        this.mContext = context;
        this.mAlarmManager = (AlarmManager)this.mContext.getSystemService("alarm");
        this.mNetworkStatsService = INetworkStatsService.Stub.asInterface(ServiceManager.getService("netstats"));
        this.mBaseDir.mkdirs();
        this.mAppUpdateReceiver = new AppUpdateReceiver();
        this.mUserUpdateReceiver = new BroadcastReceiver(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onReceive(Context context, Intent intent) {
                Object object = sStatsdLock;
                synchronized (object) {
                    sStatsd = StatsCompanionService.fetchStatsdService();
                    if (sStatsd == null) {
                        Slog.w(StatsCompanionService.TAG, "Could not access statsd for UserUpdateReceiver");
                        return;
                    }
                    try {
                        StatsCompanionService.this.informAllUidsLocked(context);
                    }
                    catch (RemoteException e) {
                        Slog.e(StatsCompanionService.TAG, "Failed to inform statsd latest update of all apps", e);
                        StatsCompanionService.this.forgetEverythingLocked();
                    }
                }
            }
        };
        this.mShutdownEventReceiver = new ShutdownEventReceiver();
        PowerProfile powerProfile = new PowerProfile(context);
        int numClusters = powerProfile.getNumCpuClusters();
        this.mKernelCpuSpeedReaders = new KernelCpuSpeedReader[numClusters];
        int firstCpuOfCluster = 0;
        for (int i = 0; i < numClusters; ++i) {
            int numSpeedSteps = powerProfile.getNumSpeedStepsInCpuCluster(i);
            this.mKernelCpuSpeedReaders[i] = new KernelCpuSpeedReader(firstCpuOfCluster, numSpeedSteps);
            firstCpuOfCluster += powerProfile.getNumCoresInCpuCluster(i);
        }
        IBinder b = ServiceManager.getService("thermalservice");
        if (b != null) {
            sThermalService = IThermalService.Stub.asInterface(b);
            try {
                sThermalService.registerThermalEventListener(new ThermalEventListener());
                Slog.i(TAG, "register thermal listener successfully");
            }
            catch (RemoteException e) {
                Slog.e(TAG, "register thermal listener error");
            }
        } else {
            Slog.e(TAG, "cannot find thermalservice, no throttling push notifications");
        }
        NetworkRequest request = new NetworkRequest.Builder().build();
        ConnectivityManager connectivityManager = (ConnectivityManager)this.mContext.getSystemService("connectivity");
        connectivityManager.registerNetworkCallback(request, new ConnectivityStatsCallback());
        HandlerThread handlerThread = new HandlerThread(TAG);
        handlerThread.start();
        this.mHandler = new CompanionHandler(handlerThread.getLooper());
        this.mKernelCpuThreadReader = KernelCpuThreadReaderSettingsObserver.getSettingsModifiedReader(this.mContext);
    }

    @Override
    public void sendDataBroadcast(IBinder intentSenderBinder, long lastReportTimeNs) {
        this.enforceCallingPermission();
        IntentSender intentSender = new IntentSender(intentSenderBinder);
        Intent intent = new Intent();
        intent.putExtra(EXTRA_LAST_REPORT_TIME, lastReportTimeNs);
        try {
            intentSender.sendIntent(this.mContext, 1, intent, null, null);
        }
        catch (IntentSender.SendIntentException e) {
            Slog.w(TAG, "Unable to send using IntentSender");
        }
    }

    @Override
    public void sendActiveConfigsChangedBroadcast(IBinder intentSenderBinder, long[] configIds) {
        this.enforceCallingPermission();
        IntentSender intentSender = new IntentSender(intentSenderBinder);
        Intent intent = new Intent();
        intent.putExtra("android.app.extra.STATS_ACTIVE_CONFIG_KEYS", configIds);
        try {
            intentSender.sendIntent(this.mContext, 1, intent, null, null);
        }
        catch (IntentSender.SendIntentException e) {
            Slog.w(TAG, "Unable to send active configs changed broadcast using IntentSender");
        }
    }

    @Override
    public void sendSubscriberBroadcast(IBinder intentSenderBinder, long configUid, long configKey, long subscriptionId, long subscriptionRuleId, String[] cookies, StatsDimensionsValue dimensionsValue) {
        this.enforceCallingPermission();
        IntentSender intentSender = new IntentSender(intentSenderBinder);
        Intent intent = new Intent().putExtra("android.app.extra.STATS_CONFIG_UID", configUid).putExtra("android.app.extra.STATS_CONFIG_KEY", configKey).putExtra("android.app.extra.STATS_SUBSCRIPTION_ID", subscriptionId).putExtra("android.app.extra.STATS_SUBSCRIPTION_RULE_ID", subscriptionRuleId).putExtra("android.app.extra.STATS_DIMENSIONS_VALUE", dimensionsValue);
        ArrayList<String> cookieList = new ArrayList<String>(cookies.length);
        for (String cookie : cookies) {
            cookieList.add(cookie);
        }
        intent.putStringArrayListExtra("android.app.extra.STATS_BROADCAST_SUBSCRIBER_COOKIES", cookieList);
        try {
            intentSender.sendIntent(this.mContext, 1, intent, null, null);
        }
        catch (IntentSender.SendIntentException e) {
            Slog.w(TAG, "Unable to send using IntentSender from uid " + configUid + "; presumably it had been cancelled.");
        }
    }

    private static final int[] toIntArray(List<Integer> list) {
        int[] ret = new int[list.size()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = list.get(i);
        }
        return ret;
    }

    private static final long[] toLongArray(List<Long> list) {
        long[] ret = new long[list.size()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = list.get(i);
        }
        return ret;
    }

    @GuardedBy(value={"sStatsdLock"})
    private final void informAllUidsLocked(Context context) throws RemoteException {
        ParcelFileDescriptor[] fds;
        UserManager um = (UserManager)context.getSystemService("user");
        PackageManager pm = context.getPackageManager();
        List<UserInfo> users = um.getUsers(true);
        try {
            fds = ParcelFileDescriptor.createPipe();
        }
        catch (IOException e) {
            Slog.e(TAG, "Failed to create a pipe to send uid map data.", e);
            return;
        }
        sStatsd.informAllUidData(fds[0]);
        try {
            fds[0].close();
        }
        catch (IOException e) {
            Slog.e(TAG, "Failed to close the read side of the pipe.", e);
        }
        ParcelFileDescriptor writeFd = fds[1];
        BackgroundThread.getHandler().post(() -> {
            ParcelFileDescriptor.AutoCloseOutputStream fout = new ParcelFileDescriptor.AutoCloseOutputStream(writeFd);
            try {
                ProtoOutputStream output = new ProtoOutputStream(fout);
                int numRecords = 0;
                for (UserInfo profile : users) {
                    List<PackageInfo> pi = pm.getInstalledPackagesAsUser(0x402000, profile.id);
                    for (int j = 0; j < pi.size(); ++j) {
                        String installer;
                        if (pi.get((int)j).applicationInfo == null) continue;
                        try {
                            installer = pm.getInstallerPackageName(pi.get((int)j).packageName);
                        }
                        catch (IllegalArgumentException e) {
                            installer = "";
                        }
                        long applicationInfoToken = output.start(2246267895809L);
                        output.write(0x10500000001L, pi.get((int)j).applicationInfo.uid);
                        output.write(1112396529666L, pi.get(j).getLongVersionCode());
                        output.write(1138166333443L, pi.get((int)j).versionName);
                        output.write(1138166333444L, pi.get((int)j).packageName);
                        output.write(1138166333445L, installer == null ? "" : installer);
                        ++numRecords;
                        output.end(applicationInfoToken);
                    }
                }
                output.flush();
            }
            finally {
                IoUtils.closeQuietly(fout);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAnomalyAlarm(long timestampMs) {
        this.enforceCallingPermission();
        long callingToken = Binder.clearCallingIdentity();
        try {
            this.mAlarmManager.setExact(3, timestampMs, "StatsCompanionService.anomaly", this.mAnomalyAlarmListener, this.mHandler);
        }
        finally {
            Binder.restoreCallingIdentity(callingToken);
        }
    }

    @Override
    public void cancelAnomalyAlarm() {
        this.enforceCallingPermission();
        long callingToken = Binder.clearCallingIdentity();
        try {
            this.mAlarmManager.cancel(this.mAnomalyAlarmListener);
        }
        finally {
            Binder.restoreCallingIdentity(callingToken);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAlarmForSubscriberTriggering(long timestampMs) {
        this.enforceCallingPermission();
        long callingToken = Binder.clearCallingIdentity();
        try {
            this.mAlarmManager.setExact(3, timestampMs, "StatsCompanionService.periodic", this.mPeriodicAlarmListener, this.mHandler);
        }
        finally {
            Binder.restoreCallingIdentity(callingToken);
        }
    }

    @Override
    public void cancelAlarmForSubscriberTriggering() {
        this.enforceCallingPermission();
        long callingToken = Binder.clearCallingIdentity();
        try {
            this.mAlarmManager.cancel(this.mPeriodicAlarmListener);
        }
        finally {
            Binder.restoreCallingIdentity(callingToken);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPullingAlarm(long nextPullTimeMs) {
        this.enforceCallingPermission();
        long callingToken = Binder.clearCallingIdentity();
        try {
            this.mAlarmManager.setExact(3, nextPullTimeMs, "StatsCompanionService.pull", this.mPullingAlarmListener, this.mHandler);
        }
        finally {
            Binder.restoreCallingIdentity(callingToken);
        }
    }

    @Override
    public void cancelPullingAlarm() {
        this.enforceCallingPermission();
        long callingToken = Binder.clearCallingIdentity();
        try {
            this.mAlarmManager.cancel(this.mPullingAlarmListener);
        }
        finally {
            Binder.restoreCallingIdentity(callingToken);
        }
    }

    private void addNetworkStats(int tag, List<StatsLogEventWrapper> ret, NetworkStats stats, boolean withFGBG) {
        int size = stats.size();
        long elapsedNanos = SystemClock.elapsedRealtimeNanos();
        long wallClockNanos = SystemClock.currentTimeMicro() * 1000L;
        NetworkStats.Entry entry = new NetworkStats.Entry();
        for (int j = 0; j < size; ++j) {
            stats.getValues(j, entry);
            StatsLogEventWrapper e = new StatsLogEventWrapper(tag, elapsedNanos, wallClockNanos);
            e.writeInt(entry.uid);
            if (withFGBG) {
                e.writeInt(entry.set);
            }
            e.writeLong(entry.rxBytes);
            e.writeLong(entry.rxPackets);
            e.writeLong(entry.txBytes);
            e.writeLong(entry.txPackets);
            ret.add(e);
        }
    }

    private NetworkStats rollupNetworkStatsByFGBG(NetworkStats stats) {
        NetworkStats ret = new NetworkStats(stats.getElapsedRealtime(), 1);
        NetworkStats.Entry entry = new NetworkStats.Entry();
        entry.iface = NetworkStats.IFACE_ALL;
        entry.tag = 0;
        entry.metered = -1;
        entry.roaming = -1;
        int size = stats.size();
        NetworkStats.Entry recycle = new NetworkStats.Entry();
        for (int i = 0; i < size; ++i) {
            stats.getValues(i, recycle);
            if (recycle.tag != 0) continue;
            entry.set = recycle.set;
            entry.uid = recycle.uid;
            entry.rxBytes = recycle.rxBytes;
            entry.rxPackets = recycle.rxPackets;
            entry.txBytes = recycle.txBytes;
            entry.txPackets = recycle.txPackets;
            ret.combineValues(entry);
        }
        return ret;
    }

    private static <T extends Parcelable> T awaitControllerInfo(SynchronousResultReceiver receiver) {
        if (receiver == null) {
            return null;
        }
        try {
            SynchronousResultReceiver.Result result = receiver.awaitResult(2000L);
            if (result.bundle != null) {
                result.bundle.setDefusable(true);
                Object data = result.bundle.getParcelable(RESULT_RECEIVER_CONTROLLER_KEY);
                if (data != null) {
                    return data;
                }
            }
            Slog.e(TAG, "no controller energy info supplied for " + receiver.getName());
        }
        catch (TimeoutException e) {
            Slog.w(TAG, "timeout reading " + receiver.getName() + " stats");
        }
        return null;
    }

    private void pullKernelWakelock(int tagId, long elapsedNanos, long wallClockNanos, List<StatsLogEventWrapper> pulledData) {
        KernelWakelockStats wakelockStats = this.mKernelWakelockReader.readKernelWakelockStats(this.mTmpWakelockStats);
        for (Map.Entry ent : wakelockStats.entrySet()) {
            String name = (String)ent.getKey();
            KernelWakelockStats.Entry kws = (KernelWakelockStats.Entry)ent.getValue();
            StatsLogEventWrapper e = new StatsLogEventWrapper(tagId, elapsedNanos, wallClockNanos);
            e.writeString(name);
            e.writeInt(kws.mCount);
            e.writeInt(kws.mVersion);
            e.writeLong(kws.mTotalTime);
            pulledData.add(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pullWifiBytesTransfer(int tagId, long elapsedNanos, long wallClockNanos, List<StatsLogEventWrapper> pulledData) {
        long token = Binder.clearCallingIdentity();
        try {
            BatteryStatsInternal bs = LocalServices.getService(BatteryStatsInternal.class);
            String[] ifaces = bs.getWifiIfaces();
            if (ifaces.length == 0) {
                return;
            }
            if (this.mNetworkStatsService == null) {
                Slog.e(TAG, "NetworkStats Service is not available!");
                return;
            }
            NetworkStats stats = this.mNetworkStatsService.getDetailedUidStats(ifaces).groupedByUid();
            this.addNetworkStats(tagId, pulledData, stats, false);
        }
        catch (RemoteException e) {
            Slog.e(TAG, "Pulling netstats for wifi bytes has error", e);
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pullWifiBytesTransferByFgBg(int tagId, long elapsedNanos, long wallClockNanos, List<StatsLogEventWrapper> pulledData) {
        long token = Binder.clearCallingIdentity();
        try {
            BatteryStatsInternal bs = LocalServices.getService(BatteryStatsInternal.class);
            String[] ifaces = bs.getWifiIfaces();
            if (ifaces.length == 0) {
                return;
            }
            if (this.mNetworkStatsService == null) {
                Slog.e(TAG, "NetworkStats Service is not available!");
                return;
            }
            NetworkStats stats = this.rollupNetworkStatsByFGBG(this.mNetworkStatsService.getDetailedUidStats(ifaces));
            this.addNetworkStats(tagId, pulledData, stats, true);
        }
        catch (RemoteException e) {
            Slog.e(TAG, "Pulling netstats for wifi bytes w/ fg/bg has error", e);
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pullMobileBytesTransfer(int tagId, long elapsedNanos, long wallClockNanos, List<StatsLogEventWrapper> pulledData) {
        long token = Binder.clearCallingIdentity();
        try {
            BatteryStatsInternal bs = LocalServices.getService(BatteryStatsInternal.class);
            String[] ifaces = bs.getMobileIfaces();
            if (ifaces.length == 0) {
                return;
            }
            if (this.mNetworkStatsService == null) {
                Slog.e(TAG, "NetworkStats Service is not available!");
                return;
            }
            NetworkStats stats = this.mNetworkStatsService.getDetailedUidStats(ifaces).groupedByUid();
            this.addNetworkStats(tagId, pulledData, stats, false);
        }
        catch (RemoteException e) {
            Slog.e(TAG, "Pulling netstats for mobile bytes has error", e);
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    private void pullBluetoothBytesTransfer(int tagId, long elapsedNanos, long wallClockNanos, List<StatsLogEventWrapper> pulledData) {
        BluetoothActivityEnergyInfo info = this.fetchBluetoothData();
        if (info.getUidTraffic() != null) {
            for (UidTraffic traffic : info.getUidTraffic()) {
                StatsLogEventWrapper e = new StatsLogEventWrapper(tagId, elapsedNanos, wallClockNanos);
                e.writeInt(traffic.getUid());
                e.writeLong(traffic.getRxBytes());
                e.writeLong(traffic.getTxBytes());
                pulledData.add(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pullMobileBytesTransferByFgBg(int tagId, long elapsedNanos, long wallClockNanos, List<StatsLogEventWrapper> pulledData) {
        long token = Binder.clearCallingIdentity();
        try {
            BatteryStatsInternal bs = LocalServices.getService(BatteryStatsInternal.class);
            String[] ifaces = bs.getMobileIfaces();
            if (ifaces.length == 0) {
                return;
            }
            if (this.mNetworkStatsService == null) {
                Slog.e(TAG, "NetworkStats Service is not available!");
                return;
            }
            NetworkStats stats = this.rollupNetworkStatsByFGBG(this.mNetworkStatsService.getDetailedUidStats(ifaces));
            this.addNetworkStats(tagId, pulledData, stats, true);
        }
        catch (RemoteException e) {
            Slog.e(TAG, "Pulling netstats for mobile bytes w/ fg/bg has error", e);
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    private void pullCpuTimePerFreq(int tagId, long elapsedNanos, long wallClockNanos, List<StatsLogEventWrapper> pulledData) {
        for (int cluster = 0; cluster < this.mKernelCpuSpeedReaders.length; ++cluster) {
            long[] clusterTimeMs = this.mKernelCpuSpeedReaders[cluster].readAbsolute();
            if (clusterTimeMs == null) continue;
            for (int speed = clusterTimeMs.length - 1; speed >= 0; --speed) {
                StatsLogEventWrapper e = new StatsLogEventWrapper(tagId, elapsedNanos, wallClockNanos);
                e.writeInt(cluster);
                e.writeInt(speed);
                e.writeLong(clusterTimeMs[speed]);
                pulledData.add(e);
            }
        }
    }

    private void pullKernelUidCpuTime(int tagId, long elapsedNanos, long wallClockNanos, List<StatsLogEventWrapper> pulledData) {
        this.mCpuUidUserSysTimeReader.readAbsolute((uid, timesUs) -> {
            long userTimeUs = timesUs[0];
            long systemTimeUs = timesUs[1];
            StatsLogEventWrapper e = new StatsLogEventWrapper(tagId, elapsedNanos, wallClockNanos);
            e.writeInt(uid);
            e.writeLong(userTimeUs);
            e.writeLong(systemTimeUs);
            pulledData.add(e);
        });
    }

    private void pullKernelUidCpuFreqTime(int tagId, long elapsedNanos, long wallClockNanos, List<StatsLogEventWrapper> pulledData) {
        this.mCpuUidFreqTimeReader.readAbsolute((uid, cpuFreqTimeMs) -> {
            for (int freqIndex = 0; freqIndex < ((long[])cpuFreqTimeMs).length; ++freqIndex) {
                if (cpuFreqTimeMs[freqIndex] == 0L) continue;
                StatsLogEventWrapper e = new StatsLogEventWrapper(tagId, elapsedNanos, wallClockNanos);
                e.writeInt(uid);
                e.writeInt(freqIndex);
                e.writeLong(cpuFreqTimeMs[freqIndex]);
                pulledData.add(e);
            }
        });
    }

    private void pullKernelUidCpuClusterTime(int tagId, long elapsedNanos, long wallClockNanos, List<StatsLogEventWrapper> pulledData) {
        this.mCpuUidClusterTimeReader.readAbsolute((uid, cpuClusterTimesMs) -> {
            for (int i = 0; i < ((long[])cpuClusterTimesMs).length; ++i) {
                StatsLogEventWrapper e = new StatsLogEventWrapper(tagId, elapsedNanos, wallClockNanos);
                e.writeInt(uid);
                e.writeInt(i);
                e.writeLong(cpuClusterTimesMs[i]);
                pulledData.add(e);
            }
        });
    }

    private void pullKernelUidCpuActiveTime(int tagId, long elapsedNanos, long wallClockNanos, List<StatsLogEventWrapper> pulledData) {
        this.mCpuUidActiveTimeReader.readAbsolute((uid, cpuActiveTimesMs) -> {
            StatsLogEventWrapper e = new StatsLogEventWrapper(tagId, elapsedNanos, wallClockNanos);
            e.writeInt(uid);
            e.writeLong((long)cpuActiveTimesMs);
            pulledData.add(e);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pullWifiActivityInfo(int tagId, long elapsedNanos, long wallClockNanos, List<StatsLogEventWrapper> pulledData) {
        long token = Binder.clearCallingIdentity();
        StatsCompanionService statsCompanionService = this;
        synchronized (statsCompanionService) {
            if (this.mWifiManager == null) {
                this.mWifiManager = IWifiManager.Stub.asInterface(ServiceManager.getService("wifi"));
            }
        }
        if (this.mWifiManager != null) {
            try {
                SynchronousResultReceiver wifiReceiver = new SynchronousResultReceiver("wifi");
                this.mWifiManager.requestActivityInfo(wifiReceiver);
                WifiActivityEnergyInfo wifiInfo = (WifiActivityEnergyInfo)StatsCompanionService.awaitControllerInfo(wifiReceiver);
                StatsLogEventWrapper e = new StatsLogEventWrapper(tagId, elapsedNanos, wallClockNanos);
                e.writeLong(wifiInfo.getTimeStamp());
                e.writeInt(wifiInfo.getStackState());
                e.writeLong(wifiInfo.getControllerTxTimeMillis());
                e.writeLong(wifiInfo.getControllerRxTimeMillis());
                e.writeLong(wifiInfo.getControllerIdleTimeMillis());
                e.writeLong(wifiInfo.getControllerEnergyUsed());
                pulledData.add(e);
            }
            catch (RemoteException e) {
                Slog.e(TAG, "Pulling wifiManager for wifi controller activity energy info has error", e);
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pullModemActivityInfo(int tagId, long elapsedNanos, long wallClockNanos, List<StatsLogEventWrapper> pulledData) {
        long token = Binder.clearCallingIdentity();
        StatsCompanionService statsCompanionService = this;
        synchronized (statsCompanionService) {
            if (this.mTelephony == null) {
                this.mTelephony = TelephonyManager.from(this.mContext);
            }
        }
        if (this.mTelephony != null) {
            SynchronousResultReceiver modemReceiver = new SynchronousResultReceiver("telephony");
            this.mTelephony.requestModemActivityInfo(modemReceiver);
            ModemActivityInfo modemInfo = (ModemActivityInfo)StatsCompanionService.awaitControllerInfo(modemReceiver);
            StatsLogEventWrapper e = new StatsLogEventWrapper(tagId, elapsedNanos, wallClockNanos);
            e.writeLong(modemInfo.getTimestamp());
            e.writeLong(modemInfo.getSleepTimeMillis());
            e.writeLong(modemInfo.getIdleTimeMillis());
            e.writeLong(modemInfo.getTxTimeMillis()[0]);
            e.writeLong(modemInfo.getTxTimeMillis()[1]);
            e.writeLong(modemInfo.getTxTimeMillis()[2]);
            e.writeLong(modemInfo.getTxTimeMillis()[3]);
            e.writeLong(modemInfo.getTxTimeMillis()[4]);
            e.writeLong(modemInfo.getRxTimeMillis());
            e.writeLong(modemInfo.getEnergyUsed());
            pulledData.add(e);
        }
    }

    private void pullBluetoothActivityInfo(int tagId, long elapsedNanos, long wallClockNanos, List<StatsLogEventWrapper> pulledData) {
        BluetoothActivityEnergyInfo info = this.fetchBluetoothData();
        StatsLogEventWrapper e = new StatsLogEventWrapper(tagId, elapsedNanos, wallClockNanos);
        e.writeLong(info.getTimeStamp());
        e.writeInt(info.getBluetoothStackState());
        e.writeLong(info.getControllerTxTimeMillis());
        e.writeLong(info.getControllerRxTimeMillis());
        e.writeLong(info.getControllerIdleTimeMillis());
        e.writeLong(info.getControllerEnergyUsed());
        pulledData.add(e);
    }

    private synchronized BluetoothActivityEnergyInfo fetchBluetoothData() {
        BluetoothAdapter adapter = BluetoothAdapter.getDefaultAdapter();
        if (adapter != null) {
            SynchronousResultReceiver bluetoothReceiver = new SynchronousResultReceiver("bluetooth");
            adapter.requestControllerActivityEnergyInfo(bluetoothReceiver);
            return (BluetoothActivityEnergyInfo)StatsCompanionService.awaitControllerInfo(bluetoothReceiver);
        }
        Slog.e(TAG, "Failed to get bluetooth adapter!");
        return null;
    }

    private void pullSystemElapsedRealtime(int tagId, long elapsedNanos, long wallClockNanos, List<StatsLogEventWrapper> pulledData) {
        StatsLogEventWrapper e = new StatsLogEventWrapper(tagId, elapsedNanos, wallClockNanos);
        e.writeLong(SystemClock.elapsedRealtime());
        pulledData.add(e);
    }

    private void pullSystemUpTime(int tagId, long elapsedNanos, long wallClockNanos, List<StatsLogEventWrapper> pulledData) {
        StatsLogEventWrapper e = new StatsLogEventWrapper(tagId, elapsedNanos, wallClockNanos);
        e.writeLong(SystemClock.uptimeMillis());
        pulledData.add(e);
    }

    private void pullProcessMemoryState(int tagId, long elapsedNanos, long wallClockNanos, List<StatsLogEventWrapper> pulledData) {
        List<ProcessMemoryState> processMemoryStates = LocalServices.getService(ActivityManagerInternal.class).getMemoryStateForProcesses();
        for (ProcessMemoryState processMemoryState : processMemoryStates) {
            MemoryStatUtil.MemoryStat memoryStat = MemoryStatUtil.readMemoryStatFromFilesystem(processMemoryState.uid, processMemoryState.pid);
            if (memoryStat == null) continue;
            StatsLogEventWrapper e = new StatsLogEventWrapper(tagId, elapsedNanos, wallClockNanos);
            e.writeInt(processMemoryState.uid);
            e.writeString(processMemoryState.processName);
            e.writeInt(processMemoryState.oomScore);
            e.writeLong(memoryStat.pgfault);
            e.writeLong(memoryStat.pgmajfault);
            e.writeLong(memoryStat.rssInBytes);
            e.writeLong(memoryStat.cacheInBytes);
            e.writeLong(memoryStat.swapInBytes);
            e.writeLong(0L);
            e.writeLong(memoryStat.startTimeNanos);
            e.writeInt(StatsCompanionService.anonAndSwapInKilobytes(memoryStat));
            pulledData.add(e);
        }
    }

    private void pullNativeProcessMemoryState(int tagId, long elapsedNanos, long wallClockNanos, List<StatsLogEventWrapper> pulledData) {
        List<String> processNames = Arrays.asList(MEMORY_INTERESTING_NATIVE_PROCESSES);
        int[] pids = Process.getPidsForCommands(MEMORY_INTERESTING_NATIVE_PROCESSES);
        for (int i = 0; i < pids.length; ++i) {
            int pid = pids[i];
            MemoryStatUtil.MemoryStat memoryStat = MemoryStatUtil.readMemoryStatFromProcfs(pid);
            if (memoryStat == null) continue;
            int uid = Process.getUidForPid(pid);
            String processName = MemoryStatUtil.readCmdlineFromProcfs(pid);
            if (!processNames.contains(processName)) continue;
            StatsLogEventWrapper e = new StatsLogEventWrapper(tagId, elapsedNanos, wallClockNanos);
            e.writeInt(uid);
            e.writeString(processName);
            e.writeLong(memoryStat.pgfault);
            e.writeLong(memoryStat.pgmajfault);
            e.writeLong(memoryStat.rssInBytes);
            e.writeLong(0L);
            e.writeLong(memoryStat.startTimeNanos);
            e.writeLong(memoryStat.swapInBytes);
            e.writeInt(StatsCompanionService.anonAndSwapInKilobytes(memoryStat));
            pulledData.add(e);
        }
    }

    private static int anonAndSwapInKilobytes(MemoryStatUtil.MemoryStat memoryStat) {
        return (int)((memoryStat.anonRssInBytes + memoryStat.swapInBytes) / 1024L);
    }

    private void pullProcessMemoryHighWaterMark(int tagId, long elapsedNanos, long wallClockNanos, List<StatsLogEventWrapper> pulledData) {
        List<ProcessMemoryState> managedProcessList = LocalServices.getService(ActivityManagerInternal.class).getMemoryStateForProcesses();
        for (ProcessMemoryState managedProcess : managedProcessList) {
            long rssHighWaterMarkInBytes = MemoryStatUtil.readRssHighWaterMarkFromProcfs(managedProcess.pid);
            if (rssHighWaterMarkInBytes == 0L) continue;
            StatsLogEventWrapper e = new StatsLogEventWrapper(tagId, elapsedNanos, wallClockNanos);
            e.writeInt(managedProcess.uid);
            e.writeString(managedProcess.processName);
            e.writeLong(rssHighWaterMarkInBytes);
            pulledData.add(e);
        }
        int[] pids = Process.getPidsForCommands(MEMORY_INTERESTING_NATIVE_PROCESSES);
        for (int i = 0; i < pids.length; ++i) {
            int pid = pids[i];
            int uid = Process.getUidForPid(pid);
            String processName = MemoryStatUtil.readCmdlineFromProcfs(pid);
            long rssHighWaterMarkInBytes = MemoryStatUtil.readRssHighWaterMarkFromProcfs(pid);
            StatsLogEventWrapper e = new StatsLogEventWrapper(tagId, elapsedNanos, wallClockNanos);
            e.writeInt(uid);
            e.writeString(processName);
            e.writeLong(rssHighWaterMarkInBytes);
            pulledData.add(e);
        }
        SystemProperties.set("sys.rss_hwm_reset.on", "1");
    }

    private void pullSystemIonHeapSize(int tagId, long elapsedNanos, long wallClockNanos, List<StatsLogEventWrapper> pulledData) {
        long systemIonHeapSizeInBytes = MemoryStatUtil.readSystemIonHeapSizeFromDebugfs();
        StatsLogEventWrapper e = new StatsLogEventWrapper(tagId, elapsedNanos, wallClockNanos);
        e.writeLong(systemIonHeapSizeInBytes);
        pulledData.add(e);
    }

    private void pullProcessSystemIonHeapSize(int tagId, long elapsedNanos, long wallClockNanos, List<StatsLogEventWrapper> pulledData) {
        List<MemoryStatUtil.IonAllocations> result = MemoryStatUtil.readProcessSystemIonHeapSizesFromDebugfs();
        for (MemoryStatUtil.IonAllocations allocations : result) {
            StatsLogEventWrapper e = new StatsLogEventWrapper(tagId, elapsedNanos, wallClockNanos);
            e.writeInt(Process.getUidForPid(allocations.pid));
            e.writeString(MemoryStatUtil.readCmdlineFromProcfs(allocations.pid));
            e.writeInt((int)(allocations.totalSizeInBytes / 1024L));
            e.writeInt(allocations.count);
            e.writeInt((int)(allocations.maxSizeInBytes / 1024L));
            pulledData.add(e);
        }
    }

    private void pullBinderCallsStats(int tagId, long elapsedNanos, long wallClockNanos, List<StatsLogEventWrapper> pulledData) {
        BinderCallsStatsService.Internal binderStats = LocalServices.getService(BinderCallsStatsService.Internal.class);
        if (binderStats == null) {
            throw new IllegalStateException("binderStats is null");
        }
        ArrayList<BinderCallsStats.ExportedCallStat> callStats = binderStats.getExportedCallStats();
        binderStats.reset();
        for (BinderCallsStats.ExportedCallStat callStat : callStats) {
            StatsLogEventWrapper e = new StatsLogEventWrapper(tagId, elapsedNanos, wallClockNanos);
            e.writeInt(callStat.workSourceUid);
            e.writeString(callStat.className);
            e.writeString(callStat.methodName);
            e.writeLong(callStat.callCount);
            e.writeLong(callStat.exceptionCount);
            e.writeLong(callStat.latencyMicros);
            e.writeLong(callStat.maxLatencyMicros);
            e.writeLong(callStat.cpuTimeMicros);
            e.writeLong(callStat.maxCpuTimeMicros);
            e.writeLong(callStat.maxReplySizeBytes);
            e.writeLong(callStat.maxRequestSizeBytes);
            e.writeLong(callStat.recordedCallCount);
            e.writeInt(callStat.screenInteractive ? 1 : 0);
            e.writeInt(callStat.callingUid);
            pulledData.add(e);
        }
    }

    private void pullBinderCallsStatsExceptions(int tagId, long elapsedNanos, long wallClockNanos, List<StatsLogEventWrapper> pulledData) {
        BinderCallsStatsService.Internal binderStats = LocalServices.getService(BinderCallsStatsService.Internal.class);
        if (binderStats == null) {
            throw new IllegalStateException("binderStats is null");
        }
        ArrayMap<String, Integer> exceptionStats = binderStats.getExportedExceptionStats();
        for (Map.Entry<String, Integer> entry : exceptionStats.entrySet()) {
            StatsLogEventWrapper e = new StatsLogEventWrapper(tagId, elapsedNanos, wallClockNanos);
            e.writeString(entry.getKey());
            e.writeInt(entry.getValue());
            pulledData.add(e);
        }
    }

    private void pullLooperStats(int tagId, long elapsedNanos, long wallClockNanos, List<StatsLogEventWrapper> pulledData) {
        LooperStats looperStats = LocalServices.getService(LooperStats.class);
        if (looperStats == null) {
            throw new IllegalStateException("looperStats null");
        }
        List<LooperStats.ExportedEntry> entries = looperStats.getEntries();
        looperStats.reset();
        for (LooperStats.ExportedEntry entry : entries) {
            StatsLogEventWrapper e = new StatsLogEventWrapper(tagId, elapsedNanos, wallClockNanos);
            e.writeInt(entry.workSourceUid);
            e.writeString(entry.handlerClassName);
            e.writeString(entry.threadName);
            e.writeString(entry.messageName);
            e.writeLong(entry.messageCount);
            e.writeLong(entry.exceptionCount);
            e.writeLong(entry.recordedMessageCount);
            e.writeLong(entry.totalLatencyMicros);
            e.writeLong(entry.cpuUsageMicros);
            e.writeBoolean(entry.isInteractive);
            e.writeLong(entry.maxCpuUsageMicros);
            e.writeLong(entry.maxLatencyMicros);
            e.writeLong(entry.recordedDelayMessageCount);
            e.writeLong(entry.delayMillis);
            e.writeLong(entry.maxDelayMillis);
            pulledData.add(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pullDiskStats(int tagId, long elapsedNanos, long wallClockNanos, List<StatsLogEventWrapper> pulledData) {
        byte[] junk = new byte[512];
        for (int i = 0; i < junk.length; ++i) {
            junk[i] = (byte)i;
        }
        File tmp = new File(Environment.getDataDirectory(), "system/statsdperftest.tmp");
        FileOutputStream fos = null;
        IOException error = null;
        long before = SystemClock.elapsedRealtime();
        try {
            fos = new FileOutputStream(tmp);
            fos.write(junk);
        }
        catch (IOException e) {
            error = e;
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException e) {}
        }
        long latency = SystemClock.elapsedRealtime() - before;
        if (tmp.exists()) {
            tmp.delete();
        }
        if (error != null) {
            Slog.e(TAG, "Error performing diskstats latency test");
            latency = -1L;
        }
        boolean fileBased = StorageManager.isFileEncryptedNativeOnly();
        int writeSpeed = -1;
        try {
            IBinder binder = ServiceManager.getService("storaged");
            if (binder == null) {
                Slog.e(TAG, "storaged not found");
            }
            IStoraged storaged = IStoraged.Stub.asInterface(binder);
            writeSpeed = storaged.getRecentPerf();
        }
        catch (RemoteException e) {
            Slog.e(TAG, "storaged not found");
        }
        StatsLogEventWrapper e = new StatsLogEventWrapper(tagId, elapsedNanos, wallClockNanos);
        e.writeLong(latency);
        e.writeBoolean(fileBased);
        e.writeInt(writeSpeed);
        pulledData.add(e);
    }

    private void pullDirectoryUsage(int tagId, long elapsedNanos, long wallClockNanos, List<StatsLogEventWrapper> pulledData) {
        StatFs statFsData = new StatFs(Environment.getDataDirectory().getAbsolutePath());
        StatFs statFsSystem = new StatFs(Environment.getRootDirectory().getAbsolutePath());
        StatFs statFsCache = new StatFs(Environment.getDownloadCacheDirectory().getAbsolutePath());
        StatsLogEventWrapper e = new StatsLogEventWrapper(tagId, elapsedNanos, wallClockNanos);
        e.writeInt(1);
        e.writeLong(statFsData.getAvailableBytes());
        e.writeLong(statFsData.getTotalBytes());
        pulledData.add(e);
        e = new StatsLogEventWrapper(tagId, elapsedNanos, wallClockNanos);
        e.writeInt(2);
        e.writeLong(statFsCache.getAvailableBytes());
        e.writeLong(statFsCache.getTotalBytes());
        pulledData.add(e);
        e = new StatsLogEventWrapper(tagId, elapsedNanos, wallClockNanos);
        e.writeInt(3);
        e.writeLong(statFsSystem.getAvailableBytes());
        e.writeLong(statFsSystem.getTotalBytes());
        pulledData.add(e);
    }

    private void pullAppSize(int tagId, long elapsedNanos, long wallClockNanos, List<StatsLogEventWrapper> pulledData) {
        try {
            String jsonStr = IoUtils.readFileAsString("/data/system/diskstats_cache.json");
            JSONObject json = new JSONObject(jsonStr);
            long cache_time = json.optLong("queryTime", -1L);
            JSONArray pkg_names = json.getJSONArray("packageNames");
            JSONArray app_sizes = json.getJSONArray("appSizes");
            JSONArray app_data_sizes = json.getJSONArray("appDataSizes");
            JSONArray app_cache_sizes = json.getJSONArray("cacheSizes");
            int length = pkg_names.length();
            if (app_sizes.length() != length || app_data_sizes.length() != length || app_cache_sizes.length() != length) {
                Slog.e(TAG, "formatting error in diskstats cache file!");
                return;
            }
            for (int i = 0; i < length; ++i) {
                StatsLogEventWrapper e = new StatsLogEventWrapper(tagId, elapsedNanos, wallClockNanos);
                e.writeString(pkg_names.getString(i));
                e.writeLong(app_sizes.optLong(i, -1L));
                e.writeLong(app_data_sizes.optLong(i, -1L));
                e.writeLong(app_cache_sizes.optLong(i, -1L));
                e.writeLong(cache_time);
                pulledData.add(e);
            }
        }
        catch (IOException | JSONException e) {
            Slog.e(TAG, "exception reading diskstats cache file", e);
        }
    }

    private void pullCategorySize(int tagId, long elapsedNanos, long wallClockNanos, List<StatsLogEventWrapper> pulledData) {
        try {
            String jsonStr = IoUtils.readFileAsString("/data/system/diskstats_cache.json");
            JSONObject json = new JSONObject(jsonStr);
            long cacheTime = json.optLong("queryTime", -1L);
            StatsLogEventWrapper e = new StatsLogEventWrapper(tagId, elapsedNanos, wallClockNanos);
            e.writeInt(1);
            e.writeLong(json.optLong("appSize", -1L));
            e.writeLong(cacheTime);
            pulledData.add(e);
            e = new StatsLogEventWrapper(tagId, elapsedNanos, wallClockNanos);
            e.writeInt(2);
            e.writeLong(json.optLong("appDataSize", -1L));
            e.writeLong(cacheTime);
            pulledData.add(e);
            e = new StatsLogEventWrapper(tagId, elapsedNanos, wallClockNanos);
            e.writeInt(3);
            e.writeLong(json.optLong("cacheSize", -1L));
            e.writeLong(cacheTime);
            pulledData.add(e);
            e = new StatsLogEventWrapper(tagId, elapsedNanos, wallClockNanos);
            e.writeInt(4);
            e.writeLong(json.optLong("photosSize", -1L));
            e.writeLong(cacheTime);
            pulledData.add(e);
            e = new StatsLogEventWrapper(tagId, elapsedNanos, wallClockNanos);
            e.writeInt(5);
            e.writeLong(json.optLong("videosSize", -1L));
            e.writeLong(cacheTime);
            pulledData.add(e);
            e = new StatsLogEventWrapper(tagId, elapsedNanos, wallClockNanos);
            e.writeInt(6);
            e.writeLong(json.optLong("audioSize", -1L));
            e.writeLong(cacheTime);
            pulledData.add(e);
            e = new StatsLogEventWrapper(tagId, elapsedNanos, wallClockNanos);
            e.writeInt(7);
            e.writeLong(json.optLong("downloadsSize", -1L));
            e.writeLong(cacheTime);
            pulledData.add(e);
            e = new StatsLogEventWrapper(tagId, elapsedNanos, wallClockNanos);
            e.writeInt(8);
            e.writeLong(json.optLong("systemSize", -1L));
            e.writeLong(cacheTime);
            pulledData.add(e);
            e = new StatsLogEventWrapper(tagId, elapsedNanos, wallClockNanos);
            e.writeInt(9);
            e.writeLong(json.optLong("otherSize", -1L));
            e.writeLong(cacheTime);
            pulledData.add(e);
        }
        catch (IOException | JSONException e) {
            Slog.e(TAG, "exception reading diskstats cache file", e);
        }
    }

    private void pullNumBiometricsEnrolled(int modality, int tagId, long elapsedNanos, long wallClockNanos, List<StatsLogEventWrapper> pulledData) {
        PackageManager pm = this.mContext.getPackageManager();
        FingerprintManager fingerprintManager = null;
        FaceManager faceManager = null;
        if (pm.hasSystemFeature("android.hardware.fingerprint")) {
            fingerprintManager = this.mContext.getSystemService(FingerprintManager.class);
        }
        if (pm.hasSystemFeature("android.hardware.biometrics.face")) {
            faceManager = this.mContext.getSystemService(FaceManager.class);
        }
        if (modality == 1 && fingerprintManager == null) {
            return;
        }
        if (modality == 4 && faceManager == null) {
            return;
        }
        UserManager userManager = this.mContext.getSystemService(UserManager.class);
        if (userManager == null) {
            return;
        }
        long token = Binder.clearCallingIdentity();
        for (UserInfo user : userManager.getUsers()) {
            int userId = user.getUserHandle().getIdentifier();
            int numEnrolled = 0;
            if (modality == 1) {
                numEnrolled = fingerprintManager.getEnrolledFingerprints(userId).size();
            } else if (modality == 4) {
                numEnrolled = faceManager.getEnrolledFaces(userId).size();
            } else {
                return;
            }
            StatsLogEventWrapper e = new StatsLogEventWrapper(tagId, elapsedNanos, wallClockNanos);
            e.writeInt(userId);
            e.writeInt(numEnrolled);
            pulledData.add(e);
        }
        Binder.restoreCallingIdentity(token);
    }

    private long readProcStatsHighWaterMark(int section) {
        try {
            File[] files = this.mBaseDir.listFiles((d, name) -> name.toLowerCase().startsWith(String.valueOf(section) + '_'));
            if (files == null || files.length == 0) {
                return 0L;
            }
            if (files.length > 1) {
                Log.e(TAG, "Only 1 file expected for high water mark. Found " + files.length);
            }
            return Long.valueOf(files[0].getName().split("_")[1]);
        }
        catch (SecurityException e) {
            Log.e(TAG, "Failed to get procstats high watermark file.", e);
        }
        catch (NumberFormatException e) {
            Log.e(TAG, "Failed to parse file name.", e);
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pullProcessStats(int section, int tagId, long elapsedNanos, long wallClockNanos, List<StatsLogEventWrapper> pulledData) {
        StatsCompanionService statsCompanionService = this;
        synchronized (statsCompanionService) {
            try {
                long lastHighWaterMark = this.readProcStatsHighWaterMark(section);
                ArrayList<ParcelFileDescriptor> statsFiles = new ArrayList<ParcelFileDescriptor>();
                long highWaterMark = this.mProcessStats.getCommittedStats(lastHighWaterMark, section, true, statsFiles);
                if (statsFiles.size() != 1) {
                    return;
                }
                ParcelFileDescriptor.AutoCloseInputStream stream = new ParcelFileDescriptor.AutoCloseInputStream((ParcelFileDescriptor)statsFiles.get(0));
                int[] len = new int[1];
                byte[] stats = StatsCompanionService.readFully(stream, len);
                StatsLogEventWrapper e = new StatsLogEventWrapper(tagId, elapsedNanos, wallClockNanos);
                e.writeStorage(Arrays.copyOf(stats, len[0]));
                pulledData.add(e);
                new File(this.mBaseDir.getAbsolutePath() + "/" + section + "_" + lastHighWaterMark).delete();
                new File(this.mBaseDir.getAbsolutePath() + "/" + section + "_" + highWaterMark).createNewFile();
            }
            catch (IOException e) {
                Log.e(TAG, "Getting procstats failed: ", e);
            }
            catch (RemoteException e) {
                Log.e(TAG, "Getting procstats failed: ", e);
            }
            catch (SecurityException e) {
                Log.e(TAG, "Getting procstats failed: ", e);
            }
        }
    }

    static byte[] readFully(InputStream stream, int[] outLen) throws IOException {
        int pos = 0;
        int initialAvail = stream.available();
        byte[] data = new byte[initialAvail > 0 ? initialAvail + 1 : 16384];
        while (true) {
            int amt;
            if ((amt = stream.read(data, pos, data.length - pos)) < 0) {
                outLen[0] = pos;
                return data;
            }
            if ((pos += amt) < data.length) continue;
            byte[] newData = new byte[pos + 16384];
            System.arraycopy(data, 0, newData, 0, pos);
            data = newData;
        }
    }

    private void pullPowerProfile(int tagId, long elapsedNanos, long wallClockNanos, List<StatsLogEventWrapper> pulledData) {
        PowerProfile powerProfile = new PowerProfile(this.mContext);
        Preconditions.checkNotNull(powerProfile);
        StatsLogEventWrapper e = new StatsLogEventWrapper(tagId, elapsedNanos, wallClockNanos);
        ProtoOutputStream proto = new ProtoOutputStream();
        powerProfile.writeToProto(proto);
        proto.flush();
        e.writeStorage(proto.getBytes());
        pulledData.add(e);
    }

    private void pullBuildInformation(int tagId, long elapsedNanos, long wallClockNanos, List<StatsLogEventWrapper> pulledData) {
        StatsLogEventWrapper e = new StatsLogEventWrapper(tagId, elapsedNanos, wallClockNanos);
        e.writeString(Build.FINGERPRINT);
        e.writeString(Build.BRAND);
        e.writeString(Build.PRODUCT);
        e.writeString(Build.DEVICE);
        e.writeString(Build.VERSION.RELEASE);
        e.writeString(Build.ID);
        e.writeString(Build.VERSION.INCREMENTAL);
        e.writeString(Build.TYPE);
        e.writeString(Build.TAGS);
        pulledData.add(e);
    }

    private BatteryStatsHelper getBatteryStatsHelper() {
        long currentTime;
        if (this.mBatteryStatsHelper == null) {
            long callingToken = Binder.clearCallingIdentity();
            try {
                this.mBatteryStatsHelper = new BatteryStatsHelper(this.mContext, false);
            }
            finally {
                Binder.restoreCallingIdentity(callingToken);
            }
            this.mBatteryStatsHelper.create((Bundle)null);
        }
        if ((currentTime = SystemClock.elapsedRealtime()) - this.mBatteryStatsHelperTimestampMs >= 1000L) {
            this.mBatteryStatsHelper.refreshStats(0, -1);
            this.mBatteryStatsHelper.clearStats();
            this.mBatteryStatsHelperTimestampMs = currentTime;
        }
        return this.mBatteryStatsHelper;
    }

    private long milliAmpHrsToNanoAmpSecs(double mAh) {
        long MILLI_AMP_HR_TO_NANO_AMP_SECS = 3600000000L;
        return (long)(mAh * 3.6E9 + 0.5);
    }

    private void pullDeviceCalculatedPowerUse(int tagId, long elapsedNanos, long wallClockNanos, List<StatsLogEventWrapper> pulledData) {
        BatteryStatsHelper bsHelper = this.getBatteryStatsHelper();
        StatsLogEventWrapper e = new StatsLogEventWrapper(tagId, elapsedNanos, wallClockNanos);
        e.writeLong(this.milliAmpHrsToNanoAmpSecs(bsHelper.getComputedPower()));
        pulledData.add(e);
    }

    private void pullDeviceCalculatedPowerBlameUid(int tagId, long elapsedNanos, long wallClockNanos, List<StatsLogEventWrapper> pulledData) {
        List<BatterySipper> sippers = this.getBatteryStatsHelper().getUsageList();
        if (sippers == null) {
            return;
        }
        for (BatterySipper bs : sippers) {
            BatterySipper.DrainType cfr_ignored_0 = bs.drainType;
            if (bs.drainType != BatterySipper.DrainType.APP) continue;
            StatsLogEventWrapper e = new StatsLogEventWrapper(tagId, elapsedNanos, wallClockNanos);
            e.writeInt(bs.uidObj.getUid());
            e.writeLong(this.milliAmpHrsToNanoAmpSecs(bs.totalPowerMah));
            pulledData.add(e);
        }
    }

    private void pullDeviceCalculatedPowerBlameOther(int tagId, long elapsedNanos, long wallClockNanos, List<StatsLogEventWrapper> pulledData) {
        List<BatterySipper> sippers = this.getBatteryStatsHelper().getUsageList();
        if (sippers == null) {
            return;
        }
        for (BatterySipper bs : sippers) {
            BatterySipper.DrainType cfr_ignored_0 = bs.drainType;
            if (bs.drainType == BatterySipper.DrainType.APP) continue;
            BatterySipper.DrainType cfr_ignored_1 = bs.drainType;
            if (bs.drainType == BatterySipper.DrainType.USER) continue;
            StatsLogEventWrapper e = new StatsLogEventWrapper(tagId, elapsedNanos, wallClockNanos);
            e.writeInt(bs.drainType.ordinal());
            e.writeLong(this.milliAmpHrsToNanoAmpSecs(bs.totalPowerMah));
            pulledData.add(e);
        }
    }

    private void pullDiskIo(int tagId, long elapsedNanos, long wallClockNanos, List<StatsLogEventWrapper> pulledData) {
        this.mStoragedUidIoStatsReader.readAbsolute((uid, fgCharsRead, fgCharsWrite, fgBytesRead, fgBytesWrite, bgCharsRead, bgCharsWrite, bgBytesRead, bgBytesWrite, fgFsync, bgFsync) -> {
            StatsLogEventWrapper e = new StatsLogEventWrapper(tagId, elapsedNanos, wallClockNanos);
            e.writeInt(uid);
            e.writeLong(fgCharsRead);
            e.writeLong(fgCharsWrite);
            e.writeLong(fgBytesRead);
            e.writeLong(fgBytesWrite);
            e.writeLong(bgCharsRead);
            e.writeLong(bgCharsWrite);
            e.writeLong(bgBytesRead);
            e.writeLong(bgBytesWrite);
            e.writeLong(fgFsync);
            e.writeLong(bgFsync);
            pulledData.add(e);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pullProcessCpuTime(int tagId, long elapsedNanos, long wallClockNanos, List<StatsLogEventWrapper> pulledData) {
        StatsCompanionService statsCompanionService = this;
        synchronized (statsCompanionService) {
            if (this.mProcessCpuTracker == null) {
                this.mProcessCpuTracker = new ProcessCpuTracker(false);
                this.mProcessCpuTracker.init();
            }
            this.mProcessCpuTracker.update();
            for (int i = 0; i < this.mProcessCpuTracker.countStats(); ++i) {
                ProcessCpuTracker.Stats st = this.mProcessCpuTracker.getStats(i);
                StatsLogEventWrapper e = new StatsLogEventWrapper(tagId, elapsedNanos, wallClockNanos);
                e.writeInt(st.uid);
                e.writeString(st.name);
                e.writeLong(st.base_utime);
                e.writeLong(st.base_stime);
                pulledData.add(e);
            }
        }
    }

    private void pullCpuTimePerThreadFreq(int tagId, long elapsedNanos, long wallClockNanos, List<StatsLogEventWrapper> pulledData) {
        if (this.mKernelCpuThreadReader == null) {
            throw new IllegalStateException("mKernelCpuThreadReader is null");
        }
        ArrayList<KernelCpuThreadReader.ProcessCpuUsage> processCpuUsages = this.mKernelCpuThreadReader.getProcessCpuUsageDiffed();
        if (processCpuUsages == null) {
            throw new IllegalStateException("processCpuUsages is null");
        }
        int[] cpuFrequencies = this.mKernelCpuThreadReader.getCpuFrequenciesKhz();
        if (cpuFrequencies.length > 8) {
            String message = "Expected maximum 8 frequencies, but got " + cpuFrequencies.length;
            Slog.w(TAG, message);
            throw new IllegalStateException(message);
        }
        for (int i = 0; i < processCpuUsages.size(); ++i) {
            KernelCpuThreadReader.ProcessCpuUsage processCpuUsage = processCpuUsages.get(i);
            ArrayList<KernelCpuThreadReader.ThreadCpuUsage> threadCpuUsages = processCpuUsage.threadCpuUsages;
            for (int j = 0; j < threadCpuUsages.size(); ++j) {
                KernelCpuThreadReader.ThreadCpuUsage threadCpuUsage = threadCpuUsages.get(j);
                if (threadCpuUsage.usageTimesMillis.length != cpuFrequencies.length) {
                    String message = "Unexpected number of usage times, expected " + cpuFrequencies.length + " but got " + threadCpuUsage.usageTimesMillis.length;
                    Slog.w(TAG, message);
                    throw new IllegalStateException(message);
                }
                StatsLogEventWrapper e = new StatsLogEventWrapper(tagId, elapsedNanos, wallClockNanos);
                e.writeInt(processCpuUsage.uid);
                e.writeInt(processCpuUsage.processId);
                e.writeInt(threadCpuUsage.threadId);
                e.writeString(processCpuUsage.processName);
                e.writeString(threadCpuUsage.threadName);
                for (int k = 0; k < 8; ++k) {
                    if (k < cpuFrequencies.length) {
                        e.writeInt(cpuFrequencies[k]);
                        e.writeInt(threadCpuUsage.usageTimesMillis[k]);
                        continue;
                    }
                    e.writeInt(0);
                    e.writeInt(0);
                }
                pulledData.add(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pullTemperature(int tagId, long elapsedNanos, long wallClockNanos, List<StatsLogEventWrapper> pulledData) {
        long callingToken = Binder.clearCallingIdentity();
        try {
            List<Temperature> temperatures = sThermalService.getCurrentTemperatures();
            for (Temperature temp : temperatures) {
                StatsLogEventWrapper e = new StatsLogEventWrapper(tagId, elapsedNanos, wallClockNanos);
                e.writeInt(temp.getType());
                e.writeString(temp.getName());
                e.writeInt((int)(temp.getValue() * 10.0f));
                e.writeInt(temp.getStatus());
                pulledData.add(e);
            }
        }
        catch (RemoteException e) {
            Slog.e(TAG, "Disconnected from thermal service. Cannot pull temperatures.");
        }
        finally {
            Binder.restoreCallingIdentity(callingToken);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pullCoolingDevices(int tagId, long elapsedNanos, long wallClockNanos, List<StatsLogEventWrapper> pulledData) {
        long callingToken = Binder.clearCallingIdentity();
        try {
            List<CoolingDevice> devices = sThermalService.getCurrentCoolingDevices();
            for (CoolingDevice device : devices) {
                StatsLogEventWrapper e = new StatsLogEventWrapper(tagId, elapsedNanos, wallClockNanos);
                e.writeInt(device.getType());
                e.writeString(device.getName());
                e.writeInt((int)device.getValue());
                pulledData.add(e);
            }
        }
        catch (RemoteException e) {
            Slog.e(TAG, "Disconnected from thermal service. Cannot pull temperatures.");
        }
        finally {
            Binder.restoreCallingIdentity(callingToken);
        }
    }

    private void pullDebugElapsedClock(int tagId, long elapsedNanos, long wallClockNanos, List<StatsLogEventWrapper> pulledData) {
        long elapsedMillis = SystemClock.elapsedRealtime();
        long clockDiffMillis = this.mDebugElapsedClockPreviousValue == 0L ? 0L : elapsedMillis - this.mDebugElapsedClockPreviousValue;
        StatsLogEventWrapper e = new StatsLogEventWrapper(tagId, elapsedNanos, wallClockNanos);
        e.writeLong(this.mDebugElapsedClockPullCount);
        e.writeLong(elapsedMillis);
        e.writeLong(elapsedMillis);
        e.writeLong(clockDiffMillis);
        e.writeInt(1);
        pulledData.add(e);
        if (this.mDebugElapsedClockPullCount % 2L == 1L) {
            StatsLogEventWrapper e2 = new StatsLogEventWrapper(tagId, elapsedNanos, wallClockNanos);
            e2.writeLong(this.mDebugElapsedClockPullCount);
            e2.writeLong(elapsedMillis);
            e2.writeLong(elapsedMillis);
            e2.writeLong(clockDiffMillis);
            e2.writeInt(2);
            pulledData.add(e2);
        }
        ++this.mDebugElapsedClockPullCount;
        this.mDebugElapsedClockPreviousValue = elapsedMillis;
    }

    private void pullDebugFailingElapsedClock(int tagId, long elapsedNanos, long wallClockNanos, List<StatsLogEventWrapper> pulledData) {
        StatsLogEventWrapper e = new StatsLogEventWrapper(tagId, elapsedNanos, wallClockNanos);
        long elapsedMillis = SystemClock.elapsedRealtime();
        if (this.mDebugFailingElapsedClockPullCount++ % 5L == 0L) {
            this.mDebugFailingElapsedClockPreviousValue = elapsedMillis;
            throw new RuntimeException("Failing debug elapsed clock");
        }
        e.writeLong(this.mDebugFailingElapsedClockPullCount);
        e.writeLong(elapsedMillis);
        e.writeLong(elapsedMillis);
        e.writeLong(this.mDebugFailingElapsedClockPreviousValue == 0L ? 0L : elapsedMillis - this.mDebugFailingElapsedClockPreviousValue);
        this.mDebugFailingElapsedClockPreviousValue = elapsedMillis;
        pulledData.add(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pullDangerousPermissionState(long elapsedNanos, long wallClockNanos, List<StatsLogEventWrapper> pulledData) {
        long token = Binder.clearCallingIdentity();
        try {
            PackageManager pm = this.mContext.getPackageManager();
            List<UserInfo> users = this.mContext.getSystemService(UserManager.class).getUsers();
            int numUsers = users.size();
            for (int userNum = 0; userNum < numUsers; ++userNum) {
                UserHandle user = users.get(userNum).getUserHandle();
                List<PackageInfo> pkgs = pm.getInstalledPackagesAsUser(4096, user.getIdentifier());
                int numPkgs = pkgs.size();
                for (int pkgNum = 0; pkgNum < numPkgs; ++pkgNum) {
                    PackageInfo pkg = pkgs.get(pkgNum);
                    if (pkg.requestedPermissions == null) continue;
                    int numPerms = pkg.requestedPermissions.length;
                    for (int permNum = 0; permNum < numPerms; ++permNum) {
                        PermissionInfo permissionInfo;
                        String permName = pkg.requestedPermissions[permNum];
                        int permissionFlags = 0;
                        try {
                            permissionInfo = pm.getPermissionInfo(permName, 0);
                            permissionFlags = pm.getPermissionFlags(permName, pkg.packageName, user);
                        }
                        catch (PackageManager.NameNotFoundException ignored) {
                            continue;
                        }
                        if (permissionInfo.getProtection() != 1) continue;
                        StatsLogEventWrapper e = new StatsLogEventWrapper(10050, elapsedNanos, wallClockNanos);
                        e.writeString(permName);
                        e.writeInt(pkg.applicationInfo.uid);
                        e.writeString(pkg.packageName);
                        e.writeBoolean((pkg.requestedPermissionsFlags[permNum] & 2) != 0);
                        e.writeInt(permissionFlags);
                        pulledData.add(e);
                    }
                }
            }
        }
        catch (Throwable t) {
            Log.e(TAG, "Could not read permissions", t);
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pullAppOps(long elapsedNanos, long wallClockNanos, List<StatsLogEventWrapper> pulledData) {
        long token = Binder.clearCallingIdentity();
        try {
            AppOpsManager appOps = this.mContext.getSystemService(AppOpsManager.class);
            CompletableFuture ops = new CompletableFuture();
            AppOpsManager.HistoricalOpsRequest histOpsRequest = new AppOpsManager.HistoricalOpsRequest.Builder(Instant.now().minus(1L, ChronoUnit.HOURS).toEpochMilli(), Long.MAX_VALUE).build();
            appOps.getHistoricalOps(histOpsRequest, this.mContext.getMainExecutor(), ops::complete);
            AppOpsManager.HistoricalOps histOps = (AppOpsManager.HistoricalOps)ops.get(2000L, TimeUnit.MILLISECONDS);
            StatsLogEventWrapper e = new StatsLogEventWrapper(10060, elapsedNanos, wallClockNanos);
            for (int uidIdx = 0; uidIdx < histOps.getUidCount(); ++uidIdx) {
                AppOpsManager.HistoricalUidOps uidOps = histOps.getUidOpsAt(uidIdx);
                int uid = uidOps.getUid();
                for (int pkgIdx = 0; pkgIdx < uidOps.getPackageCount(); ++pkgIdx) {
                    AppOpsManager.HistoricalPackageOps packageOps = uidOps.getPackageOpsAt(pkgIdx);
                    for (int opIdx = 0; opIdx < packageOps.getOpCount(); ++opIdx) {
                        AppOpsManager.HistoricalOp op = packageOps.getOpAt(opIdx);
                        e.writeInt(uid);
                        e.writeString(packageOps.getPackageName());
                        e.writeInt(op.getOpCode());
                        e.writeLong(op.getForegroundAccessCount(13));
                        e.writeLong(op.getBackgroundAccessCount(13));
                        e.writeLong(op.getForegroundRejectCount(13));
                        e.writeLong(op.getBackgroundRejectCount(13));
                        e.writeLong(op.getForegroundAccessDuration(13));
                        e.writeLong(op.getBackgroundAccessDuration(13));
                        pulledData.add(e);
                    }
                }
            }
        }
        catch (Throwable t) {
            Log.e(TAG, "Could not read appops", t);
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pullRoleHolders(long elapsedNanos, long wallClockNanos, List<StatsLogEventWrapper> pulledData) {
        long callingToken = Binder.clearCallingIdentity();
        try {
            PackageManager pm = this.mContext.getPackageManager();
            RoleManagerInternal rmi = LocalServices.getService(RoleManagerInternal.class);
            List<UserInfo> users = this.mContext.getSystemService(UserManager.class).getUsers();
            int numUsers = users.size();
            for (int userNum = 0; userNum < numUsers; ++userNum) {
                int userId = users.get(userNum).getUserHandle().getIdentifier();
                ArrayMap<String, ArraySet<String>> roles = rmi.getRolesAndHolders(userId);
                int numRoles = roles.size();
                for (int roleNum = 0; roleNum < numRoles; ++roleNum) {
                    String roleName = roles.keyAt(roleNum);
                    ArraySet<String> holders = roles.valueAt(roleNum);
                    int numHolders = holders.size();
                    for (int holderNum = 0; holderNum < numHolders; ++holderNum) {
                        PackageInfo pkg;
                        String holderName = holders.valueAt(holderNum);
                        try {
                            pkg = pm.getPackageInfoAsUser(holderName, 0, userId);
                        }
                        catch (PackageManager.NameNotFoundException e) {
                            Log.w(TAG, "Role holder " + holderName + " not found");
                            Binder.restoreCallingIdentity(callingToken);
                            return;
                        }
                        StatsLogEventWrapper e = new StatsLogEventWrapper(10049, elapsedNanos, wallClockNanos);
                        e.writeInt(pkg.applicationInfo.uid);
                        e.writeString(holderName);
                        e.writeString(roleName);
                        pulledData.add(e);
                    }
                }
            }
        }
        finally {
            Binder.restoreCallingIdentity(callingToken);
        }
    }

    private void pullTimeZoneDataInfo(int tagId, long elapsedNanos, long wallClockNanos, List<StatsLogEventWrapper> pulledData) {
        String tzDbVersion = "Unknown";
        try {
            tzDbVersion = TimeZone.getTZDataVersion();
        }
        catch (Exception e) {
            Log.e(TAG, "Getting tzdb version failed: ", e);
        }
        StatsLogEventWrapper e = new StatsLogEventWrapper(tagId, elapsedNanos, wallClockNanos);
        e.writeString(tzDbVersion);
        pulledData.add(e);
    }

    private void pullExternalStorageInfo(int tagId, long elapsedNanos, long wallClockNanos, List<StatsLogEventWrapper> pulledData) {
        StorageManager storageManager = this.mContext.getSystemService(StorageManager.class);
        if (storageManager != null) {
            List<VolumeInfo> volumes = storageManager.getVolumes();
            for (VolumeInfo vol : volumes) {
                String envState = VolumeInfo.getEnvironmentForState(vol.getState());
                DiskInfo diskInfo = vol.getDisk();
                if (diskInfo == null || !envState.equals("mounted")) continue;
                int volumeType = 3;
                if (vol.getType() == 0) {
                    volumeType = 1;
                } else if (vol.getType() == 1) {
                    volumeType = 2;
                }
                int externalStorageType = diskInfo.isSd() ? 1 : (diskInfo.isUsb() ? 2 : 3);
                StatsLogEventWrapper e = new StatsLogEventWrapper(tagId, elapsedNanos, wallClockNanos);
                e.writeInt(externalStorageType);
                e.writeInt(volumeType);
                e.writeLong(diskInfo.size);
                pulledData.add(e);
            }
        }
    }

    private void pullAppsOnExternalStorageInfo(int tagId, long elapsedNanos, long wallClockNanos, List<StatsLogEventWrapper> pulledData) {
        PackageManager pm = this.mContext.getPackageManager();
        StorageManager storage = this.mContext.getSystemService(StorageManager.class);
        List<ApplicationInfo> apps = pm.getInstalledApplications(0);
        for (ApplicationInfo appInfo : apps) {
            DiskInfo diskInfo;
            VolumeInfo volumeInfo;
            UUID storageUuid = appInfo.storageUuid;
            if (storageUuid == null || (volumeInfo = storage.findVolumeByUuid(appInfo.storageUuid.toString())) == null || (diskInfo = volumeInfo.getDisk()) == null) continue;
            int externalStorageType = -1;
            if (diskInfo.isSd()) {
                externalStorageType = 1;
            } else if (diskInfo.isUsb()) {
                externalStorageType = 2;
            } else if (appInfo.isExternal()) {
                externalStorageType = 3;
            }
            if (externalStorageType == -1) continue;
            StatsLogEventWrapper e = new StatsLogEventWrapper(tagId, elapsedNanos, wallClockNanos);
            e.writeInt(externalStorageType);
            e.writeString(appInfo.packageName);
            pulledData.add(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pullFaceSettings(int tagId, long elapsedNanos, long wallClockNanos, List<StatsLogEventWrapper> pulledData) {
        long callingToken = Binder.clearCallingIdentity();
        try {
            List<UserInfo> users = this.mContext.getSystemService(UserManager.class).getUsers();
            int numUsers = users.size();
            for (int userNum = 0; userNum < numUsers; ++userNum) {
                int userId = users.get(userNum).getUserHandle().getIdentifier();
                StatsLogEventWrapper e = new StatsLogEventWrapper(tagId, elapsedNanos, wallClockNanos);
                e.writeBoolean(Settings.Secure.getIntForUser(this.mContext.getContentResolver(), "face_unlock_keyguard_enabled", 1, userId) != 0);
                e.writeBoolean(Settings.Secure.getIntForUser(this.mContext.getContentResolver(), "face_unlock_dismisses_keyguard", 0, userId) != 0);
                e.writeBoolean(Settings.Secure.getIntForUser(this.mContext.getContentResolver(), "face_unlock_attention_required", 1, userId) != 0);
                e.writeBoolean(Settings.Secure.getIntForUser(this.mContext.getContentResolver(), "face_unlock_app_enabled", 1, userId) != 0);
                e.writeBoolean(Settings.Secure.getIntForUser(this.mContext.getContentResolver(), "face_unlock_always_require_confirmation", 0, userId) != 0);
                e.writeBoolean(Settings.Secure.getIntForUser(this.mContext.getContentResolver(), "face_unlock_diversity_required", 1, userId) != 0);
                pulledData.add(e);
            }
        }
        finally {
            Binder.restoreCallingIdentity(callingToken);
        }
    }

    @Override
    public StatsLogEventWrapper[] pullData(int tagId) {
        this.enforceCallingPermission();
        ArrayList<StatsLogEventWrapper> ret = new ArrayList<StatsLogEventWrapper>();
        long elapsedNanos = SystemClock.elapsedRealtimeNanos();
        long wallClockNanos = SystemClock.currentTimeMicro() * 1000L;
        switch (tagId) {
            case 10000: {
                this.pullWifiBytesTransfer(tagId, elapsedNanos, wallClockNanos, ret);
                break;
            }
            case 10002: {
                this.pullMobileBytesTransfer(tagId, elapsedNanos, wallClockNanos, ret);
                break;
            }
            case 10001: {
                this.pullWifiBytesTransferByFgBg(tagId, elapsedNanos, wallClockNanos, ret);
                break;
            }
            case 10003: {
                this.pullMobileBytesTransferByFgBg(tagId, elapsedNanos, wallClockNanos, ret);
                break;
            }
            case 10006: {
                this.pullBluetoothBytesTransfer(tagId, elapsedNanos, wallClockNanos, ret);
                break;
            }
            case 10004: {
                this.pullKernelWakelock(tagId, elapsedNanos, wallClockNanos, ret);
                break;
            }
            case 10008: {
                this.pullCpuTimePerFreq(tagId, elapsedNanos, wallClockNanos, ret);
                break;
            }
            case 10009: {
                this.pullKernelUidCpuTime(tagId, elapsedNanos, wallClockNanos, ret);
                break;
            }
            case 10010: {
                this.pullKernelUidCpuFreqTime(tagId, elapsedNanos, wallClockNanos, ret);
                break;
            }
            case 10017: {
                this.pullKernelUidCpuClusterTime(tagId, elapsedNanos, wallClockNanos, ret);
                break;
            }
            case 10016: {
                this.pullKernelUidCpuActiveTime(tagId, elapsedNanos, wallClockNanos, ret);
                break;
            }
            case 10011: {
                this.pullWifiActivityInfo(tagId, elapsedNanos, wallClockNanos, ret);
                break;
            }
            case 10012: {
                this.pullModemActivityInfo(tagId, elapsedNanos, wallClockNanos, ret);
                break;
            }
            case 10007: {
                this.pullBluetoothActivityInfo(tagId, elapsedNanos, wallClockNanos, ret);
                break;
            }
            case 10015: {
                this.pullSystemUpTime(tagId, elapsedNanos, wallClockNanos, ret);
                break;
            }
            case 10014: {
                this.pullSystemElapsedRealtime(tagId, elapsedNanos, wallClockNanos, ret);
                break;
            }
            case 10013: {
                this.pullProcessMemoryState(tagId, elapsedNanos, wallClockNanos, ret);
                break;
            }
            case 10036: {
                this.pullNativeProcessMemoryState(tagId, elapsedNanos, wallClockNanos, ret);
                break;
            }
            case 10042: {
                this.pullProcessMemoryHighWaterMark(tagId, elapsedNanos, wallClockNanos, ret);
                break;
            }
            case 10056: {
                this.pullSystemIonHeapSize(tagId, elapsedNanos, wallClockNanos, ret);
                break;
            }
            case 10061: {
                this.pullProcessSystemIonHeapSize(tagId, elapsedNanos, wallClockNanos, ret);
                break;
            }
            case 10022: {
                this.pullBinderCallsStats(tagId, elapsedNanos, wallClockNanos, ret);
                break;
            }
            case 10023: {
                this.pullBinderCallsStatsExceptions(tagId, elapsedNanos, wallClockNanos, ret);
                break;
            }
            case 10024: {
                this.pullLooperStats(tagId, elapsedNanos, wallClockNanos, ret);
                break;
            }
            case 10025: {
                this.pullDiskStats(tagId, elapsedNanos, wallClockNanos, ret);
                break;
            }
            case 10026: {
                this.pullDirectoryUsage(tagId, elapsedNanos, wallClockNanos, ret);
                break;
            }
            case 10027: {
                this.pullAppSize(tagId, elapsedNanos, wallClockNanos, ret);
                break;
            }
            case 10028: {
                this.pullCategorySize(tagId, elapsedNanos, wallClockNanos, ret);
                break;
            }
            case 10031: {
                this.pullNumBiometricsEnrolled(1, tagId, elapsedNanos, wallClockNanos, ret);
                break;
            }
            case 10048: {
                this.pullNumBiometricsEnrolled(4, tagId, elapsedNanos, wallClockNanos, ret);
                break;
            }
            case 10029: {
                this.pullProcessStats(15, tagId, elapsedNanos, wallClockNanos, ret);
                break;
            }
            case 10034: {
                this.pullProcessStats(2, tagId, elapsedNanos, wallClockNanos, ret);
                break;
            }
            case 10032: {
                this.pullDiskIo(tagId, elapsedNanos, wallClockNanos, ret);
                break;
            }
            case 10033: {
                this.pullPowerProfile(tagId, elapsedNanos, wallClockNanos, ret);
                break;
            }
            case 10044: {
                this.pullBuildInformation(tagId, elapsedNanos, wallClockNanos, ret);
                break;
            }
            case 10035: {
                this.pullProcessCpuTime(tagId, elapsedNanos, wallClockNanos, ret);
                break;
            }
            case 10037: {
                this.pullCpuTimePerThreadFreq(tagId, elapsedNanos, wallClockNanos, ret);
                break;
            }
            case 10039: {
                this.pullDeviceCalculatedPowerUse(tagId, elapsedNanos, wallClockNanos, ret);
                break;
            }
            case 10040: {
                this.pullDeviceCalculatedPowerBlameUid(tagId, elapsedNanos, wallClockNanos, ret);
                break;
            }
            case 10041: {
                this.pullDeviceCalculatedPowerBlameOther(tagId, elapsedNanos, wallClockNanos, ret);
                break;
            }
            case 10021: {
                this.pullTemperature(tagId, elapsedNanos, wallClockNanos, ret);
                break;
            }
            case 10059: {
                this.pullCoolingDevices(tagId, elapsedNanos, wallClockNanos, ret);
                break;
            }
            case 10046: {
                this.pullDebugElapsedClock(tagId, elapsedNanos, wallClockNanos, ret);
                break;
            }
            case 10047: {
                this.pullDebugFailingElapsedClock(tagId, elapsedNanos, wallClockNanos, ret);
                break;
            }
            case 10049: {
                this.pullRoleHolders(elapsedNanos, wallClockNanos, ret);
                break;
            }
            case 10050: {
                this.pullDangerousPermissionState(elapsedNanos, wallClockNanos, ret);
                break;
            }
            case 10052: {
                this.pullTimeZoneDataInfo(tagId, elapsedNanos, wallClockNanos, ret);
                break;
            }
            case 10053: {
                this.pullExternalStorageInfo(tagId, elapsedNanos, wallClockNanos, ret);
                break;
            }
            case 10057: {
                this.pullAppsOnExternalStorageInfo(tagId, elapsedNanos, wallClockNanos, ret);
                break;
            }
            case 10058: {
                this.pullFaceSettings(tagId, elapsedNanos, wallClockNanos, ret);
                break;
            }
            case 10060: {
                this.pullAppOps(elapsedNanos, wallClockNanos, ret);
                break;
            }
            default: {
                Slog.w(TAG, "No such tagId data as " + tagId);
                return null;
            }
        }
        return ret.toArray(new StatsLogEventWrapper[ret.size()]);
    }

    @Override
    public void statsdReady() {
        this.enforceCallingPermission();
        this.sayHiToStatsd();
        this.mContext.sendBroadcastAsUser(new Intent("android.app.action.STATSD_STARTED").addFlags(0x1000000), UserHandle.SYSTEM, "android.permission.DUMP");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void triggerUidSnapshot() {
        this.enforceCallingPermission();
        Object object = sStatsdLock;
        synchronized (object) {
            long token = Binder.clearCallingIdentity();
            try {
                this.informAllUidsLocked(this.mContext);
            }
            catch (RemoteException e) {
                Slog.e(TAG, "Failed to trigger uid snapshot.", e);
            }
            finally {
                StatsCompanionService.restoreCallingIdentity(token);
            }
        }
    }

    private void enforceCallingPermission() {
        if (Binder.getCallingPid() == Process.myPid()) {
            return;
        }
        this.mContext.enforceCallingPermission("android.permission.STATSCOMPANION", null);
    }

    private static IStatsManager fetchStatsdService() {
        return IStatsManager.Stub.asInterface(ServiceManager.getService("stats"));
    }

    private void systemReady() {
        this.sayHiToStatsd();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sayHiToStatsd() {
        Object object = sStatsdLock;
        synchronized (object) {
            if (sStatsd != null) {
                Slog.e(TAG, "Trying to fetch statsd, but it was already fetched", new IllegalStateException("sStatsd is not null when being fetched"));
                return;
            }
            sStatsd = StatsCompanionService.fetchStatsdService();
            if (sStatsd == null) {
                Slog.i(TAG, "Could not yet find statsd to tell it that StatsCompanion is alive.");
                return;
            }
            try {
                sStatsd.statsCompanionReady();
                try {
                    sStatsd.asBinder().linkToDeath(new StatsdDeathRecipient(), 0);
                }
                catch (RemoteException e) {
                    Slog.e(TAG, "linkToDeath(StatsdDeathRecipient) failed", e);
                    this.forgetEverythingLocked();
                }
                IntentFilter filter = new IntentFilter("android.intent.action.PACKAGE_REPLACED");
                filter.addAction("android.intent.action.PACKAGE_ADDED");
                filter.addAction("android.intent.action.PACKAGE_REMOVED");
                filter.addDataScheme("package");
                this.mContext.registerReceiverAsUser(this.mAppUpdateReceiver, UserHandle.ALL, filter, null, null);
                filter = new IntentFilter("android.intent.action.USER_INITIALIZE");
                filter.addAction("android.intent.action.USER_REMOVED");
                this.mContext.registerReceiverAsUser(this.mUserUpdateReceiver, UserHandle.ALL, filter, null, null);
                filter = new IntentFilter("android.intent.action.REBOOT");
                filter.addAction("android.intent.action.ACTION_SHUTDOWN");
                this.mContext.registerReceiverAsUser(this.mShutdownEventReceiver, UserHandle.ALL, filter, null, null);
                long token = Binder.clearCallingIdentity();
                try {
                    this.informAllUidsLocked(this.mContext);
                }
                finally {
                    StatsCompanionService.restoreCallingIdentity(token);
                }
                Slog.i(TAG, "Told statsd that StatsCompanionService is alive.");
            }
            catch (RemoteException e) {
                Slog.e(TAG, "Failed to inform statsd that statscompanion is ready", e);
                this.forgetEverythingLocked();
            }
        }
    }

    @GuardedBy(value={"StatsCompanionService.sStatsdLock"})
    private void forgetEverythingLocked() {
        LooperStats looperStats;
        sStatsd = null;
        this.mContext.unregisterReceiver(this.mAppUpdateReceiver);
        this.mContext.unregisterReceiver(this.mUserUpdateReceiver);
        this.mContext.unregisterReceiver(this.mShutdownEventReceiver);
        this.cancelAnomalyAlarm();
        this.cancelPullingAlarm();
        BinderCallsStatsService.Internal binderStats = LocalServices.getService(BinderCallsStatsService.Internal.class);
        if (binderStats != null) {
            binderStats.reset();
        }
        if ((looperStats = LocalServices.getService(LooperStats.class)) != null) {
            looperStats.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void dump(FileDescriptor fd, PrintWriter writer, String[] args) {
        if (!DumpUtils.checkDumpPermission(this.mContext, TAG, writer)) {
            return;
        }
        Object object = sStatsdLock;
        synchronized (object) {
            writer.println("Number of configuration files deleted: " + this.mDeletedFiles.size());
            if (this.mDeletedFiles.size() > 0) {
                writer.println("  timestamp, deleted file name");
            }
            long lastBootMillis = SystemClock.currentThreadTimeMillis() - SystemClock.elapsedRealtime();
            for (Long elapsedMillis : this.mDeletedFiles.keySet()) {
                long deletionMillis = lastBootMillis + elapsedMillis;
                writer.println("  " + deletionMillis + ", " + this.mDeletedFiles.get(elapsedMillis));
            }
        }
    }

    static {
        sStatsdLock = new Object();
    }

    private static final class ConnectivityStatsCallback
    extends ConnectivityManager.NetworkCallback {
        private ConnectivityStatsCallback() {
        }

        @Override
        public void onAvailable(Network network) {
            StatsLog.write(98, network.netId, 1);
        }

        @Override
        public void onLost(Network network) {
            StatsLog.write(98, network.netId, 2);
        }
    }

    private static final class ThermalEventListener
    extends IThermalEventListener.Stub {
        private ThermalEventListener() {
        }

        @Override
        public void notifyThrottling(Temperature temp) {
            StatsLog.write(189, temp.getType(), temp.getName(), (int)(temp.getValue() * 10.0f), temp.getStatus());
        }
    }

    private class StatsdDeathRecipient
    implements IBinder.DeathRecipient {
        private StatsdDeathRecipient() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void binderDied() {
            Slog.i(StatsCompanionService.TAG, "Statsd is dead - erase all my knowledge.");
            Object object = sStatsdLock;
            synchronized (object) {
                long ageMillis;
                long now = SystemClock.elapsedRealtime();
                for (Long timeMillis : StatsCompanionService.this.mDeathTimeMillis) {
                    ageMillis = now - timeMillis;
                    if (ageMillis <= MILLIS_IN_A_DAY) continue;
                    StatsCompanionService.this.mDeathTimeMillis.remove(timeMillis);
                }
                for (Long timeMillis : StatsCompanionService.this.mDeletedFiles.keySet()) {
                    ageMillis = now - timeMillis;
                    if (ageMillis <= MILLIS_IN_A_DAY * 7L) continue;
                    StatsCompanionService.this.mDeletedFiles.remove(timeMillis);
                }
                StatsCompanionService.this.mDeathTimeMillis.add(now);
                if (StatsCompanionService.this.mDeathTimeMillis.size() >= 10) {
                    StatsCompanionService.this.mDeathTimeMillis.clear();
                    File[] configs = FileUtils.listFilesOrEmpty(new File(StatsCompanionService.CONFIG_DIR));
                    if (configs.length > 0) {
                        String fileName = configs[0].getName();
                        if (configs[0].delete()) {
                            StatsCompanionService.this.mDeletedFiles.put(now, fileName);
                        }
                    }
                }
                StatsCompanionService.this.forgetEverythingLocked();
            }
        }
    }

    public static final class Lifecycle
    extends SystemService {
        private StatsCompanionService mStatsCompanionService;

        public Lifecycle(Context context) {
            super(context);
        }

        @Override
        public void onStart() {
            this.mStatsCompanionService = new StatsCompanionService(this.getContext());
            try {
                this.publishBinderService("statscompanion", this.mStatsCompanionService);
            }
            catch (Exception e) {
                Slog.e(StatsCompanionService.TAG, "Failed to publishBinderService", e);
            }
        }

        @Override
        public void onBootPhase(int phase) {
            super.onBootPhase(phase);
            if (phase == 600) {
                this.mStatsCompanionService.systemReady();
            }
        }
    }

    public static final class ShutdownEventReceiver
    extends BroadcastReceiver {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onReceive(Context context, Intent intent) {
            if (!(intent.getAction().equals("android.intent.action.REBOOT") || intent.getAction().equals("android.intent.action.ACTION_SHUTDOWN") && (intent.getFlags() & 0x10000000) != 0)) {
                return;
            }
            Slog.i(StatsCompanionService.TAG, "StatsCompanionService noticed a shutdown.");
            Object object = sStatsdLock;
            synchronized (object) {
                if (sStatsd == null) {
                    Slog.w(StatsCompanionService.TAG, "Could not access statsd to inform it of a shutdown event.");
                    return;
                }
                try {
                    sStatsd.informDeviceShutdown();
                }
                catch (Exception e) {
                    Slog.w(StatsCompanionService.TAG, "Failed to inform statsd of a shutdown event.", e);
                }
            }
        }
    }

    public static final class PeriodicAlarmListener
    implements AlarmManager.OnAlarmListener {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onAlarm() {
            Object object = sStatsdLock;
            synchronized (object) {
                if (sStatsd == null) {
                    Slog.w(StatsCompanionService.TAG, "Could not access statsd to inform it of periodic alarm firing.");
                    return;
                }
                try {
                    sStatsd.informAlarmForSubscriberTriggeringFired();
                }
                catch (RemoteException e) {
                    Slog.w(StatsCompanionService.TAG, "Failed to inform statsd of periodic alarm firing.", e);
                }
            }
        }
    }

    public static final class PullingAlarmListener
    implements AlarmManager.OnAlarmListener {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onAlarm() {
            Object object = sStatsdLock;
            synchronized (object) {
                if (sStatsd == null) {
                    Slog.w(StatsCompanionService.TAG, "Could not access statsd to inform it of pulling alarm firing.");
                    return;
                }
                try {
                    sStatsd.informPollAlarmFired();
                }
                catch (RemoteException e) {
                    Slog.w(StatsCompanionService.TAG, "Failed to inform statsd of pulling alarm firing.", e);
                }
            }
        }
    }

    public static final class AnomalyAlarmListener
    implements AlarmManager.OnAlarmListener {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onAlarm() {
            Slog.i(StatsCompanionService.TAG, "StatsCompanionService believes an anomaly has occurred at time " + System.currentTimeMillis() + "ms.");
            Object object = sStatsdLock;
            synchronized (object) {
                if (sStatsd == null) {
                    Slog.w(StatsCompanionService.TAG, "Could not access statsd to inform it of anomaly alarm firing");
                    return;
                }
                try {
                    sStatsd.informAnomalyAlarmFired();
                }
                catch (RemoteException e) {
                    Slog.w(StatsCompanionService.TAG, "Failed to inform statsd of anomaly alarm firing", e);
                }
            }
        }
    }

    private static final class AppUpdateReceiver
    extends BroadcastReceiver {
        private AppUpdateReceiver() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onReceive(Context context, Intent intent) {
            if (!intent.getAction().equals("android.intent.action.PACKAGE_REPLACED") && intent.getBooleanExtra("android.intent.extra.REPLACING", false)) {
                return;
            }
            Object object = sStatsdLock;
            synchronized (object) {
                block11: {
                    if (sStatsd == null) {
                        Slog.w(StatsCompanionService.TAG, "Could not access statsd to inform it of an app update");
                        return;
                    }
                    try {
                        String installer;
                        if (intent.getAction().equals("android.intent.action.PACKAGE_REMOVED")) {
                            Bundle b = intent.getExtras();
                            int uid = b.getInt("android.intent.extra.UID");
                            boolean replacing = intent.getBooleanExtra("android.intent.extra.REPLACING", false);
                            if (!replacing) {
                                PackageManager pm = context.getPackageManager();
                                String app = intent.getData().getSchemeSpecificPart();
                                sStatsd.informOnePackageRemoved(app, uid);
                            }
                            break block11;
                        }
                        PackageManager pm = context.getPackageManager();
                        Bundle b = intent.getExtras();
                        int uid = b.getInt("android.intent.extra.UID");
                        String app = intent.getData().getSchemeSpecificPart();
                        PackageInfo pi = pm.getPackageInfo(app, 0x400000);
                        try {
                            installer = pm.getInstallerPackageName(app);
                        }
                        catch (IllegalArgumentException e) {
                            installer = "";
                        }
                        sStatsd.informOnePackage(app, uid, pi.getLongVersionCode(), pi.versionName, installer == null ? "" : installer);
                    }
                    catch (Exception e) {
                        Slog.w(StatsCompanionService.TAG, "Failed to inform statsd of an app update", e);
                    }
                }
            }
        }
    }

    static final class CompanionHandler
    extends Handler {
        CompanionHandler(Looper looper) {
            super(looper);
        }
    }
}

