/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.statusbar;

import android.app.StatusBarManager;
import android.content.ComponentName;
import android.content.Context;
import android.os.Binder;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.ShellCommand;
import android.service.quicksettings.TileService;
import android.util.Pair;
import com.android.server.statusbar.StatusBarManagerService;
import java.io.PrintWriter;

public class StatusBarShellCommand
extends ShellCommand {
    private static final IBinder sToken = new StatusBarShellCommandToken();
    private final StatusBarManagerService mInterface;
    private final Context mContext;

    public StatusBarShellCommand(StatusBarManagerService service, Context context) {
        this.mInterface = service;
        this.mContext = context;
    }

    @Override
    public int onCommand(String cmd) {
        if (cmd == null) {
            return this.handleDefaultCommands(cmd);
        }
        try {
            switch (cmd) {
                case "expand-notifications": {
                    return this.runExpandNotifications();
                }
                case "expand-settings": {
                    return this.runExpandSettings();
                }
                case "collapse": {
                    return this.runCollapse();
                }
                case "add-tile": {
                    return this.runAddTile();
                }
                case "remove-tile": {
                    return this.runRemoveTile();
                }
                case "click-tile": {
                    return this.runClickTile();
                }
                case "check-support": {
                    PrintWriter pw = this.getOutPrintWriter();
                    pw.println(String.valueOf(TileService.isQuickSettingsSupported()));
                    return 0;
                }
                case "get-status-icons": {
                    return this.runGetStatusIcons();
                }
                case "disable-for-setup": {
                    return this.runDisableForSetup();
                }
                case "send-disable-flag": {
                    return this.runSendDisableFlag();
                }
            }
            return this.handleDefaultCommands(cmd);
        }
        catch (RemoteException e) {
            PrintWriter pw = this.getOutPrintWriter();
            pw.println("Remote exception: " + e);
            return -1;
        }
    }

    private int runAddTile() throws RemoteException {
        this.mInterface.addTile(ComponentName.unflattenFromString(this.getNextArgRequired()));
        return 0;
    }

    private int runRemoveTile() throws RemoteException {
        this.mInterface.remTile(ComponentName.unflattenFromString(this.getNextArgRequired()));
        return 0;
    }

    private int runClickTile() throws RemoteException {
        this.mInterface.clickTile(ComponentName.unflattenFromString(this.getNextArgRequired()));
        return 0;
    }

    private int runCollapse() throws RemoteException {
        this.mInterface.collapsePanels();
        return 0;
    }

    private int runExpandSettings() throws RemoteException {
        this.mInterface.expandSettingsPanel(null);
        return 0;
    }

    private int runExpandNotifications() throws RemoteException {
        this.mInterface.expandNotificationsPanel();
        return 0;
    }

    private int runGetStatusIcons() {
        PrintWriter pw = this.getOutPrintWriter();
        for (String icon : this.mInterface.getStatusBarIcons()) {
            pw.println(icon);
        }
        return 0;
    }

    private int runDisableForSetup() {
        String arg = this.getNextArgRequired();
        String pkg = this.mContext.getPackageName();
        boolean disable = Boolean.parseBoolean(arg);
        if (disable) {
            this.mInterface.disable(61145088, sToken, pkg);
            this.mInterface.disable2(16, sToken, pkg);
        } else {
            this.mInterface.disable(0, sToken, pkg);
            this.mInterface.disable2(0, sToken, pkg);
        }
        return 0;
    }

    private int runSendDisableFlag() {
        String pkg = this.mContext.getPackageName();
        boolean disable1 = false;
        boolean disable2 = false;
        StatusBarManager.DisableInfo info = new StatusBarManager.DisableInfo();
        String arg = this.getNextArg();
        while (arg != null) {
            switch (arg) {
                case "search": {
                    info.setSearchDisabled(true);
                    break;
                }
                case "home": {
                    info.setNagivationHomeDisabled(true);
                    break;
                }
                case "recents": {
                    info.setRecentsDisabled(true);
                    break;
                }
                case "notification-alerts": {
                    info.setNotificationPeekingDisabled(true);
                    break;
                }
                case "statusbar-expansion": {
                    info.setStatusBarExpansionDisabled(true);
                    break;
                }
            }
            arg = this.getNextArg();
        }
        Pair<Integer, Integer> flagPair = info.toFlags();
        this.mInterface.disable((Integer)flagPair.first, sToken, pkg);
        this.mInterface.disable2((Integer)flagPair.second, sToken, pkg);
        return 0;
    }

    @Override
    public void onHelp() {
        PrintWriter pw = this.getOutPrintWriter();
        pw.println("Status bar commands:");
        pw.println("  help");
        pw.println("    Print this help text.");
        pw.println("");
        pw.println("  expand-notifications");
        pw.println("    Open the notifications panel.");
        pw.println("");
        pw.println("  expand-settings");
        pw.println("    Open the notifications panel and expand quick settings if present.");
        pw.println("");
        pw.println("  collapse");
        pw.println("    Collapse the notifications and settings panel.");
        pw.println("");
        pw.println("  add-tile COMPONENT");
        pw.println("    Add a TileService of the specified component");
        pw.println("");
        pw.println("  remove-tile COMPONENT");
        pw.println("    Remove a TileService of the specified component");
        pw.println("");
        pw.println("  click-tile COMPONENT");
        pw.println("    Click on a TileService of the specified component");
        pw.println("");
        pw.println("  check-support");
        pw.println("    Check if this device supports QS + APIs");
        pw.println("");
        pw.println("  get-status-icons");
        pw.println("    Print the list of status bar icons and the order they appear in");
        pw.println("");
        pw.println("  disable-for-setup DISABLE");
        pw.println("    If true, disable status bar components unsuitable for device setup");
        pw.println("");
        pw.println("  send-disable-flag FLAG...");
        pw.println("    Send zero or more disable flags (parsed individually) to StatusBarManager");
        pw.println("    Valid options:");
        pw.println("        <blank>             - equivalent to \"none\"");
        pw.println("        none                - re-enables all components");
        pw.println("        search              - disable search");
        pw.println("        home                - disable naviagation home");
        pw.println("        recents             - disable recents/overview");
        pw.println("        notification-peek   - disable notification peeking");
        pw.println("        statusbar-expansion - disable status bar expansion");
        pw.println("");
    }

    private static final class StatusBarShellCommandToken
    extends Binder {
        private StatusBarShellCommandToken() {
        }
    }
}

