/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.storage;

import android.app.usage.CacheQuotaHint;
import android.app.usage.ICacheQuotaService;
import android.app.usage.UsageStats;
import android.app.usage.UsageStatsManagerInternal;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.content.pm.UserInfo;
import android.os.AsyncTask;
import android.os.Bundle;
import android.os.Environment;
import android.os.IBinder;
import android.os.RemoteCallback;
import android.os.RemoteException;
import android.os.UserHandle;
import android.os.UserManager;
import android.util.ArrayMap;
import android.util.Pair;
import android.util.Slog;
import android.util.SparseLongArray;
import android.util.Xml;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.os.AtomicFile;
import com.android.internal.util.FastXmlSerializer;
import com.android.internal.util.Preconditions;
import com.android.server.pm.Installer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

public class CacheQuotaStrategy
implements RemoteCallback.OnResultListener {
    private static final String TAG = "CacheQuotaStrategy";
    private final Object mLock = new Object();
    private static final String CACHE_INFO_TAG = "cache-info";
    private static final String ATTR_PREVIOUS_BYTES = "previousBytes";
    private static final String TAG_QUOTA = "quota";
    private static final String ATTR_UUID = "uuid";
    private static final String ATTR_UID = "uid";
    private static final String ATTR_QUOTA_IN_BYTES = "bytes";
    private final Context mContext;
    private final UsageStatsManagerInternal mUsageStats;
    private final Installer mInstaller;
    private final ArrayMap<String, SparseLongArray> mQuotaMap;
    private ServiceConnection mServiceConnection;
    private ICacheQuotaService mRemoteService;
    private AtomicFile mPreviousValuesFile;

    public CacheQuotaStrategy(Context context, UsageStatsManagerInternal usageStatsManager, Installer installer, ArrayMap<String, SparseLongArray> quotaMap) {
        this.mContext = Preconditions.checkNotNull(context);
        this.mUsageStats = Preconditions.checkNotNull(usageStatsManager);
        this.mInstaller = Preconditions.checkNotNull(installer);
        this.mQuotaMap = Preconditions.checkNotNull(quotaMap);
        this.mPreviousValuesFile = new AtomicFile(new File(new File(Environment.getDataDirectory(), "system"), "cachequota.xml"));
    }

    public void recalculateQuotas() {
        this.createServiceConnection();
        ComponentName component = this.getServiceComponentName();
        if (component != null) {
            Intent intent = new Intent();
            intent.setComponent(component);
            this.mContext.bindServiceAsUser(intent, this.mServiceConnection, 1, UserHandle.CURRENT);
        }
    }

    private void createServiceConnection() {
        if (this.mServiceConnection != null) {
            return;
        }
        this.mServiceConnection = new ServiceConnection(){

            @Override
            public void onServiceConnected(ComponentName name, final IBinder service) {
                Runnable runnable = new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Object object = CacheQuotaStrategy.this.mLock;
                        synchronized (object) {
                            CacheQuotaStrategy.this.mRemoteService = ICacheQuotaService.Stub.asInterface(service);
                            List requests = CacheQuotaStrategy.this.getUnfulfilledRequests();
                            RemoteCallback remoteCallback = new RemoteCallback(CacheQuotaStrategy.this);
                            try {
                                CacheQuotaStrategy.this.mRemoteService.computeCacheQuotaHints(remoteCallback, requests);
                            }
                            catch (RemoteException ex) {
                                Slog.w(CacheQuotaStrategy.TAG, "Remote exception occurred while trying to get cache quota", ex);
                            }
                        }
                    }
                };
                AsyncTask.execute(runnable);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onServiceDisconnected(ComponentName name) {
                Object object = CacheQuotaStrategy.this.mLock;
                synchronized (object) {
                    CacheQuotaStrategy.this.mRemoteService = null;
                }
            }
        };
    }

    private List<CacheQuotaHint> getUnfulfilledRequests() {
        long timeNow = System.currentTimeMillis();
        long oneYearAgo = timeNow - 31449600000L;
        ArrayList<CacheQuotaHint> requests = new ArrayList<CacheQuotaHint>();
        UserManager um = this.mContext.getSystemService(UserManager.class);
        List<UserInfo> users = um.getUsers();
        int userCount = users.size();
        PackageManager packageManager = this.mContext.getPackageManager();
        for (int i = 0; i < userCount; ++i) {
            UserInfo info = users.get(i);
            List<UsageStats> stats = this.mUsageStats.queryUsageStatsForUser(info.id, 4, oneYearAgo, timeNow, false);
            if (stats == null) continue;
            for (UsageStats stat : stats) {
                String packageName = stat.getPackageName();
                try {
                    ApplicationInfo appInfo = packageManager.getApplicationInfoAsUser(packageName, 0, info.id);
                    requests.add(new CacheQuotaHint.Builder().setVolumeUuid(appInfo.volumeUuid).setUid(appInfo.uid).setUsageStats(stat).setQuota(-1L).build());
                }
                catch (PackageManager.NameNotFoundException e) {}
            }
        }
        return requests;
    }

    @Override
    public void onResult(Bundle data) {
        ArrayList<CacheQuotaHint> processedRequests = data.getParcelableArrayList("requests");
        this.pushProcessedQuotas(processedRequests);
        this.writeXmlToFile(processedRequests);
    }

    private void pushProcessedQuotas(List<CacheQuotaHint> processedRequests) {
        int requestSize = processedRequests.size();
        for (int i = 0; i < requestSize; ++i) {
            CacheQuotaHint request = processedRequests.get(i);
            long proposedQuota = request.getQuota();
            if (proposedQuota == -1L) continue;
            try {
                int uid = request.getUid();
                this.mInstaller.setAppQuota(request.getVolumeUuid(), UserHandle.getUserId(uid), UserHandle.getAppId(uid), proposedQuota);
                this.insertIntoQuotaMap(request.getVolumeUuid(), UserHandle.getUserId(uid), UserHandle.getAppId(uid), proposedQuota);
                continue;
            }
            catch (Installer.InstallerException ex) {
                Slog.w(TAG, "Failed to set cache quota for " + request.getUid(), ex);
            }
        }
        this.disconnectService();
    }

    private void insertIntoQuotaMap(String volumeUuid, int userId, int appId, long quota) {
        SparseLongArray volumeMap = this.mQuotaMap.get(volumeUuid);
        if (volumeMap == null) {
            volumeMap = new SparseLongArray();
            this.mQuotaMap.put(volumeUuid, volumeMap);
        }
        volumeMap.put(UserHandle.getUid(userId, appId), quota);
    }

    private void disconnectService() {
        if (this.mServiceConnection != null) {
            this.mContext.unbindService(this.mServiceConnection);
            this.mServiceConnection = null;
        }
    }

    private ComponentName getServiceComponentName() {
        String packageName = this.mContext.getPackageManager().getServicesSystemSharedLibraryPackageName();
        if (packageName == null) {
            Slog.w(TAG, "could not access the cache quota service: no package!");
            return null;
        }
        Intent intent = new Intent("android.app.usage.CacheQuotaService");
        intent.setPackage(packageName);
        ResolveInfo resolveInfo = this.mContext.getPackageManager().resolveService(intent, 132);
        if (resolveInfo == null || resolveInfo.serviceInfo == null) {
            Slog.w(TAG, "No valid components found.");
            return null;
        }
        ServiceInfo serviceInfo = resolveInfo.serviceInfo;
        return new ComponentName(serviceInfo.packageName, serviceInfo.name);
    }

    private void writeXmlToFile(List<CacheQuotaHint> processedRequests) {
        FileOutputStream fileStream = null;
        try {
            FastXmlSerializer out = new FastXmlSerializer();
            fileStream = this.mPreviousValuesFile.startWrite();
            out.setOutput(fileStream, StandardCharsets.UTF_8.name());
            CacheQuotaStrategy.saveToXml(out, processedRequests, 0L);
            this.mPreviousValuesFile.finishWrite(fileStream);
        }
        catch (Exception e) {
            Slog.e(TAG, "An error occurred while writing the cache quota file.", e);
            this.mPreviousValuesFile.failWrite(fileStream);
        }
    }

    public long setupQuotasFromFile() throws IOException {
        Pair<Long, List<CacheQuotaHint>> cachedValues = null;
        try (FileInputStream stream = this.mPreviousValuesFile.openRead();){
            try {
                cachedValues = CacheQuotaStrategy.readFromXml(stream);
            }
            catch (XmlPullParserException e) {
                throw new IllegalStateException(e.getMessage());
            }
        }
        catch (FileNotFoundException e) {
            return -1L;
        }
        if (cachedValues == null) {
            Slog.e(TAG, "An error occurred while parsing the cache quota file.");
            return -1L;
        }
        this.pushProcessedQuotas((List)cachedValues.second);
        return (Long)cachedValues.first;
    }

    @VisibleForTesting
    static void saveToXml(XmlSerializer out, List<CacheQuotaHint> requests, long bytesWhenCalculated) throws IOException {
        out.startDocument(null, true);
        out.startTag(null, CACHE_INFO_TAG);
        int requestSize = requests.size();
        out.attribute(null, ATTR_PREVIOUS_BYTES, Long.toString(bytesWhenCalculated));
        for (int i = 0; i < requestSize; ++i) {
            CacheQuotaHint request = requests.get(i);
            out.startTag(null, TAG_QUOTA);
            String uuid = request.getVolumeUuid();
            if (uuid != null) {
                out.attribute(null, ATTR_UUID, request.getVolumeUuid());
            }
            out.attribute(null, ATTR_UID, Integer.toString(request.getUid()));
            out.attribute(null, ATTR_QUOTA_IN_BYTES, Long.toString(request.getQuota()));
            out.endTag(null, TAG_QUOTA);
        }
        out.endTag(null, CACHE_INFO_TAG);
        out.endDocument();
    }

    protected static Pair<Long, List<CacheQuotaHint>> readFromXml(InputStream inputStream) throws XmlPullParserException, IOException {
        long previousBytes;
        XmlPullParser parser = Xml.newPullParser();
        parser.setInput(inputStream, StandardCharsets.UTF_8.name());
        int eventType = parser.getEventType();
        while (eventType != 2 && eventType != 1) {
            eventType = parser.next();
        }
        if (eventType == 1) {
            Slog.d(TAG, "No quotas found in quota file.");
            return null;
        }
        String tagName = parser.getName();
        if (!CACHE_INFO_TAG.equals(tagName)) {
            throw new IllegalStateException("Invalid starting tag.");
        }
        ArrayList<CacheQuotaHint> quotas = new ArrayList<CacheQuotaHint>();
        try {
            previousBytes = Long.parseLong(parser.getAttributeValue(null, ATTR_PREVIOUS_BYTES));
        }
        catch (NumberFormatException e) {
            throw new IllegalStateException("Previous bytes formatted incorrectly; aborting quota read.");
        }
        eventType = parser.next();
        do {
            if (eventType == 2 && TAG_QUOTA.equals(tagName = parser.getName())) {
                CacheQuotaHint request = CacheQuotaStrategy.getRequestFromXml(parser);
                if (request == null) continue;
                quotas.add(request);
            }
            eventType = parser.next();
        } while (eventType != 1);
        return new Pair<Long, List<CacheQuotaHint>>(previousBytes, quotas);
    }

    @VisibleForTesting
    static CacheQuotaHint getRequestFromXml(XmlPullParser parser) {
        try {
            String uuid = parser.getAttributeValue(null, ATTR_UUID);
            int uid = Integer.parseInt(parser.getAttributeValue(null, ATTR_UID));
            long bytes = Long.parseLong(parser.getAttributeValue(null, ATTR_QUOTA_IN_BYTES));
            return new CacheQuotaHint.Builder().setVolumeUuid(uuid).setUid(uid).setQuota(bytes).build();
        }
        catch (NumberFormatException e) {
            Slog.e(TAG, "Invalid cache quota request, skipping.");
            return null;
        }
    }
}

