/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.systemcaptions;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.UserHandle;
import android.util.Slog;
import com.android.internal.annotations.GuardedBy;

final class RemoteSystemCaptionsManagerService {
    private static final String TAG = RemoteSystemCaptionsManagerService.class.getSimpleName();
    private static final String SERVICE_INTERFACE = "android.service.systemcaptions.SystemCaptionsManagerService";
    private final Object mLock = new Object();
    private final Context mContext;
    private final Intent mIntent;
    private final ComponentName mComponentName;
    private final int mUserId;
    private final boolean mVerbose;
    private final Handler mHandler;
    private final RemoteServiceConnection mServiceConnection = new RemoteServiceConnection();
    @GuardedBy(value={"mLock"})
    private IBinder mService;
    @GuardedBy(value={"mLock"})
    private boolean mBinding = false;
    @GuardedBy(value={"mLock"})
    private boolean mDestroyed = false;

    RemoteSystemCaptionsManagerService(Context context, ComponentName componentName, int userId, boolean verbose) {
        this.mContext = context;
        this.mComponentName = componentName;
        this.mUserId = userId;
        this.mVerbose = verbose;
        this.mIntent = new Intent(SERVICE_INTERFACE).setComponent(componentName);
        this.mHandler = new Handler(Looper.getMainLooper());
    }

    void initialize() {
        if (this.mVerbose) {
            Slog.v(TAG, "initialize()");
        }
        this.ensureBound();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void destroy() {
        if (this.mVerbose) {
            Slog.v(TAG, "destroy()");
        }
        Object object = this.mLock;
        synchronized (object) {
            if (this.mDestroyed) {
                if (this.mVerbose) {
                    Slog.v(TAG, "destroy(): Already destroyed");
                }
                return;
            }
            this.mDestroyed = true;
            this.ensureUnboundLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isDestroyed() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mDestroyed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureBound() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mService != null || this.mBinding) {
                return;
            }
            if (this.mVerbose) {
                Slog.v(TAG, "ensureBound(): binding");
            }
            this.mBinding = true;
            int flags = 0x4000001;
            boolean willBind = this.mContext.bindServiceAsUser(this.mIntent, this.mServiceConnection, flags, this.mHandler, new UserHandle(this.mUserId));
            if (!willBind) {
                Slog.w(TAG, "Could not bind to " + this.mIntent + " with flags " + flags);
                this.mBinding = false;
                this.mService = null;
            }
        }
    }

    @GuardedBy(value={"mLock"})
    private void ensureUnboundLocked() {
        if (this.mService == null && !this.mBinding) {
            return;
        }
        this.mBinding = false;
        this.mService = null;
        if (this.mVerbose) {
            Slog.v(TAG, "ensureUnbound(): unbinding");
        }
        this.mContext.unbindService(this.mServiceConnection);
    }

    private class RemoteServiceConnection
    implements ServiceConnection {
        private RemoteServiceConnection() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onServiceConnected(ComponentName name, IBinder service) {
            Object object = RemoteSystemCaptionsManagerService.this.mLock;
            synchronized (object) {
                if (RemoteSystemCaptionsManagerService.this.mVerbose) {
                    Slog.v(TAG, "onServiceConnected()");
                }
                if (RemoteSystemCaptionsManagerService.this.mDestroyed || !RemoteSystemCaptionsManagerService.this.mBinding) {
                    Slog.wtf(TAG, "onServiceConnected() dispatched after unbindService");
                    return;
                }
                RemoteSystemCaptionsManagerService.this.mBinding = false;
                RemoteSystemCaptionsManagerService.this.mService = service;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onServiceDisconnected(ComponentName name) {
            Object object = RemoteSystemCaptionsManagerService.this.mLock;
            synchronized (object) {
                if (RemoteSystemCaptionsManagerService.this.mVerbose) {
                    Slog.v(TAG, "onServiceDisconnected()");
                }
                RemoteSystemCaptionsManagerService.this.mBinding = true;
                RemoteSystemCaptionsManagerService.this.mService = null;
            }
        }
    }
}

