/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.systemcaptions;

import android.app.AppGlobals;
import android.content.ComponentName;
import android.content.pm.PackageManager;
import android.content.pm.ServiceInfo;
import android.os.RemoteException;
import android.util.Slog;
import com.android.internal.annotations.GuardedBy;
import com.android.server.infra.AbstractPerUserSystemService;
import com.android.server.systemcaptions.RemoteSystemCaptionsManagerService;
import com.android.server.systemcaptions.SystemCaptionsManagerService;

final class SystemCaptionsManagerPerUserService
extends AbstractPerUserSystemService<SystemCaptionsManagerPerUserService, SystemCaptionsManagerService> {
    private static final String TAG = SystemCaptionsManagerPerUserService.class.getSimpleName();
    @GuardedBy(value={"mLock"})
    private RemoteSystemCaptionsManagerService mRemoteService;

    SystemCaptionsManagerPerUserService(SystemCaptionsManagerService master, Object lock, boolean disabled, int userId) {
        super(master, lock, userId);
    }

    @Override
    protected ServiceInfo newServiceInfoLocked(ComponentName serviceComponent) throws PackageManager.NameNotFoundException {
        try {
            return AppGlobals.getPackageManager().getServiceInfo(serviceComponent, 128, this.mUserId);
        }
        catch (RemoteException e) {
            throw new PackageManager.NameNotFoundException("Could not get service for " + serviceComponent);
        }
    }

    @GuardedBy(value={"mLock"})
    void initializeLocked() {
        RemoteSystemCaptionsManagerService service;
        if (((SystemCaptionsManagerService)this.mMaster).verbose) {
            Slog.v(TAG, "initialize()");
        }
        if ((service = this.getRemoteServiceLocked()) == null && ((SystemCaptionsManagerService)this.mMaster).verbose) {
            Slog.v(TAG, "initialize(): Failed to init remote server");
        }
    }

    @GuardedBy(value={"mLock"})
    void destroyLocked() {
        if (((SystemCaptionsManagerService)this.mMaster).verbose) {
            Slog.v(TAG, "destroyLocked()");
        }
        if (this.mRemoteService != null) {
            this.mRemoteService.destroy();
            this.mRemoteService = null;
        }
    }

    @GuardedBy(value={"mLock"})
    private RemoteSystemCaptionsManagerService getRemoteServiceLocked() {
        if (this.mRemoteService == null) {
            String serviceName = this.getComponentNameLocked();
            if (serviceName == null) {
                if (((SystemCaptionsManagerService)this.mMaster).verbose) {
                    Slog.v(TAG, "getRemoteServiceLocked(): Not set");
                }
                return null;
            }
            ComponentName serviceComponent = ComponentName.unflattenFromString(serviceName);
            this.mRemoteService = new RemoteSystemCaptionsManagerService(this.getContext(), serviceComponent, this.mUserId, ((SystemCaptionsManagerService)this.mMaster).verbose);
            if (((SystemCaptionsManagerService)this.mMaster).verbose) {
                Slog.v(TAG, "getRemoteServiceLocked(): initialize for user " + this.mUserId);
            }
            this.mRemoteService.initialize();
        }
        return this.mRemoteService;
    }
}

