/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.telecom;

import android.app.role.RoleManager;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.ServiceConnection;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.UserHandle;
import android.telecom.DefaultDialerManager;
import android.telecom.PhoneAccountHandle;
import android.telecom.TelecomManager;
import android.util.IntArray;
import android.util.Slog;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.telephony.SmsApplication;
import com.android.server.LocalServices;
import com.android.server.SystemService;
import com.android.server.pm.UserManagerService;
import com.android.server.pm.permission.DefaultPermissionGrantPolicy;
import com.android.server.pm.permission.PermissionManagerServiceInternal;

public class TelecomLoaderService
extends SystemService {
    private static final String TAG = "TelecomLoaderService";
    private static final ComponentName SERVICE_COMPONENT = new ComponentName("com.android.server.telecom", "com.android.server.telecom.components.TelecomService");
    private static final String SERVICE_ACTION = "com.android.ITelecomService";
    private final Object mLock = new Object();
    @GuardedBy(value={"mLock"})
    private IntArray mDefaultSimCallManagerRequests;
    private final Context mContext;
    @GuardedBy(value={"mLock"})
    private TelecomServiceConnection mServiceConnection;

    private DefaultPermissionGrantPolicy getDefaultPermissionGrantPolicy() {
        return LocalServices.getService(PermissionManagerServiceInternal.class).getDefaultPermissionGrantPolicy();
    }

    public TelecomLoaderService(Context context) {
        super(context);
        this.mContext = context;
        this.registerDefaultAppProviders();
    }

    @Override
    public void onStart() {
    }

    @Override
    public void onBootPhase(int phase) {
        if (phase == 550) {
            this.registerDefaultAppNotifier();
            this.registerCarrierConfigChangedReceiver();
            this.connectToTelecom();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connectToTelecom() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mServiceConnection != null) {
                this.mContext.unbindService(this.mServiceConnection);
                this.mServiceConnection = null;
            }
            TelecomServiceConnection serviceConnection = new TelecomServiceConnection();
            Intent intent = new Intent(SERVICE_ACTION);
            intent.setComponent(SERVICE_COMPONENT);
            int flags = 0x4000041;
            if (this.mContext.bindServiceAsUser(intent, serviceConnection, flags, UserHandle.SYSTEM)) {
                this.mServiceConnection = serviceConnection;
            }
        }
    }

    private void registerDefaultAppProviders() {
        DefaultPermissionGrantPolicy permissionPolicy = this.getDefaultPermissionGrantPolicy();
        permissionPolicy.setSmsAppPackagesProvider(userId -> {
            Object object = this.mLock;
            synchronized (object) {
                if (this.mServiceConnection == null) {
                    return null;
                }
            }
            ComponentName smsComponent = SmsApplication.getDefaultSmsApplication(this.mContext, true);
            if (smsComponent != null) {
                return new String[]{smsComponent.getPackageName()};
            }
            return null;
        });
        permissionPolicy.setDialerAppPackagesProvider(userId -> {
            Object object = this.mLock;
            synchronized (object) {
                if (this.mServiceConnection == null) {
                    return null;
                }
            }
            String packageName = DefaultDialerManager.getDefaultDialerApplication(this.mContext);
            if (packageName != null) {
                return new String[]{packageName};
            }
            return null;
        });
        permissionPolicy.setSimCallManagerPackagesProvider(userId -> {
            Object object = this.mLock;
            synchronized (object) {
                if (this.mServiceConnection == null) {
                    if (this.mDefaultSimCallManagerRequests == null) {
                        this.mDefaultSimCallManagerRequests = new IntArray();
                    }
                    this.mDefaultSimCallManagerRequests.add(userId);
                    return null;
                }
            }
            TelecomManager telecomManager = (TelecomManager)this.mContext.getSystemService("telecom");
            PhoneAccountHandle phoneAccount = telecomManager.getSimCallManager(userId);
            if (phoneAccount != null) {
                return new String[]{phoneAccount.getComponentName().getPackageName()};
            }
            return null;
        });
    }

    private void registerDefaultAppNotifier() {
        DefaultPermissionGrantPolicy permissionPolicy = this.getDefaultPermissionGrantPolicy();
        RoleManager roleManager = this.mContext.getSystemService(RoleManager.class);
        roleManager.addOnRoleHoldersChangedListenerAsUser(this.mContext.getMainExecutor(), (roleName, user) -> this.updateSimCallManagerPermissions(permissionPolicy, user.getIdentifier()), UserHandle.ALL);
    }

    private void registerCarrierConfigChangedReceiver() {
        BroadcastReceiver receiver = new BroadcastReceiver(){

            @Override
            public void onReceive(Context context, Intent intent) {
                if (intent.getAction().equals("android.telephony.action.CARRIER_CONFIG_CHANGED")) {
                    for (int userId : UserManagerService.getInstance().getUserIds()) {
                        TelecomLoaderService.this.updateSimCallManagerPermissions(TelecomLoaderService.this.getDefaultPermissionGrantPolicy(), userId);
                    }
                }
            }
        };
        this.mContext.registerReceiverAsUser(receiver, UserHandle.ALL, new IntentFilter("android.telephony.action.CARRIER_CONFIG_CHANGED"), null, null);
    }

    private void updateSimCallManagerPermissions(DefaultPermissionGrantPolicy permissionGrantPolicy, int userId) {
        TelecomManager telecomManager = (TelecomManager)this.mContext.getSystemService("telecom");
        PhoneAccountHandle phoneAccount = telecomManager.getSimCallManager(userId);
        if (phoneAccount != null) {
            Slog.i(TAG, "updating sim call manager permissions for userId:" + userId);
            String packageName = phoneAccount.getComponentName().getPackageName();
            permissionGrantPolicy.grantDefaultPermissionsToDefaultSimCallManager(packageName, userId);
        }
    }

    private class TelecomServiceConnection
    implements ServiceConnection {
        private TelecomServiceConnection() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onServiceConnected(ComponentName name, IBinder service) {
            try {
                service.linkToDeath(new IBinder.DeathRecipient(){

                    @Override
                    public void binderDied() {
                        TelecomLoaderService.this.connectToTelecom();
                    }
                }, 0);
                SmsApplication.getDefaultMmsApplication(TelecomLoaderService.this.mContext, false);
                ServiceManager.addService("telecom", service);
                Object object = TelecomLoaderService.this.mLock;
                synchronized (object) {
                    if (TelecomLoaderService.this.mDefaultSimCallManagerRequests != null) {
                        TelecomManager telecomManager;
                        PhoneAccountHandle phoneAccount;
                        DefaultPermissionGrantPolicy permissionPolicy = TelecomLoaderService.this.getDefaultPermissionGrantPolicy();
                        if (TelecomLoaderService.this.mDefaultSimCallManagerRequests != null && (phoneAccount = (telecomManager = (TelecomManager)TelecomLoaderService.this.mContext.getSystemService("telecom")).getSimCallManager()) != null) {
                            int requestCount = TelecomLoaderService.this.mDefaultSimCallManagerRequests.size();
                            String packageName = phoneAccount.getComponentName().getPackageName();
                            for (int i = requestCount - 1; i >= 0; --i) {
                                int userId = TelecomLoaderService.this.mDefaultSimCallManagerRequests.get(i);
                                TelecomLoaderService.this.mDefaultSimCallManagerRequests.remove(i);
                                permissionPolicy.grantDefaultPermissionsToDefaultSimCallManager(packageName, userId);
                            }
                        }
                    }
                }
            }
            catch (RemoteException e) {
                Slog.w(TelecomLoaderService.TAG, "Failed linking to death.");
            }
        }

        @Override
        public void onServiceDisconnected(ComponentName name) {
            TelecomLoaderService.this.connectToTelecom();
        }
    }
}

