/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.timedetector;

import android.app.timedetector.TimeSignal;
import android.content.Intent;
import android.util.Slog;
import android.util.TimestampedValue;
import com.android.server.timedetector.TimeDetectorStrategy;
import java.io.PrintWriter;

public final class SimpleTimeDetectorStrategy
implements TimeDetectorStrategy {
    private static final String TAG = "timedetector.SimpleTimeDetectorStrategy";
    private static final long SYSTEM_CLOCK_PARANOIA_THRESHOLD_MILLIS = 2000L;
    private TimeDetectorStrategy.Callback mCallback;
    private TimestampedValue<Long> mLastNitzTime;
    private TimestampedValue<Long> mLastSystemClockTime;
    private boolean mLastSystemClockTimeSendNetworkBroadcast;
    private TimestampedValue<Long> mLastSystemClockTimeSet;

    @Override
    public void initialize(TimeDetectorStrategy.Callback callback) {
        this.mCallback = callback;
    }

    @Override
    public void suggestTime(TimeSignal timeSignal) {
        if (!"nitz".equals(timeSignal.getSourceId())) {
            Slog.w(TAG, "Ignoring signal from unsupported source: " + timeSignal);
            return;
        }
        TimestampedValue<Long> newNitzUtcTime = timeSignal.getUtcTime();
        boolean nitzTimeIsValid = SimpleTimeDetectorStrategy.validateNewNitzTime(newNitzUtcTime, this.mLastNitzTime);
        if (!nitzTimeIsValid) {
            return;
        }
        this.mLastNitzTime = newNitzUtcTime;
        boolean sendNetworkBroadcast = "nitz".equals(timeSignal.getSourceId());
        TimestampedValue<Long> newUtcTime = newNitzUtcTime;
        this.setSystemClockIfRequired(newUtcTime, sendNetworkBroadcast);
    }

    private static boolean validateNewNitzTime(TimestampedValue<Long> newNitzUtcTime, TimestampedValue<Long> lastNitzTime) {
        long referenceTimeDifference;
        if (lastNitzTime != null && ((referenceTimeDifference = TimestampedValue.referenceTimeDifference(newNitzUtcTime, lastNitzTime)) < 0L || referenceTimeDifference > Integer.MAX_VALUE)) {
            Slog.w(TAG, "validateNewNitzTime: Bad NITZ signal received. referenceTimeDifference=" + referenceTimeDifference + " lastNitzTime=" + lastNitzTime + " newNitzUtcTime=" + newNitzUtcTime);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setSystemClockIfRequired(TimestampedValue<Long> time, boolean sendNetworkBroadcast) {
        this.mLastSystemClockTime = time;
        this.mLastSystemClockTimeSendNetworkBroadcast = sendNetworkBroadcast;
        if (!this.mCallback.isTimeDetectionEnabled()) {
            Slog.d(TAG, "setSystemClockIfRequired: Time detection is not enabled. time=" + time);
            return;
        }
        this.mCallback.acquireWakeLock();
        try {
            long expectedTimeMillis;
            long absSystemClockDifference;
            long elapsedRealtimeMillis = this.mCallback.elapsedRealtimeMillis();
            long actualTimeMillis = this.mCallback.systemClockMillis();
            if (this.mLastSystemClockTimeSet != null && (absSystemClockDifference = Math.abs((expectedTimeMillis = TimeDetectorStrategy.getTimeAt(this.mLastSystemClockTimeSet, elapsedRealtimeMillis)) - actualTimeMillis)) > 2000L) {
                Slog.w(TAG, "System clock has not tracked elapsed real time clock. A clock may be inaccurate or something unexpectedly set the system clock. elapsedRealtimeMillis=" + elapsedRealtimeMillis + " expectedTimeMillis=" + expectedTimeMillis + " actualTimeMillis=" + actualTimeMillis);
            }
            String reason = "New time signal";
            this.adjustAndSetDeviceSystemClock(time, sendNetworkBroadcast, elapsedRealtimeMillis, actualTimeMillis, "New time signal");
        }
        finally {
            this.mCallback.releaseWakeLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleAutoTimeDetectionToggle(boolean enabled) {
        if (enabled) {
            if (this.mLastSystemClockTime != null) {
                boolean sendNetworkBroadcast = this.mLastSystemClockTimeSendNetworkBroadcast;
                this.mCallback.acquireWakeLock();
                try {
                    long elapsedRealtimeMillis = this.mCallback.elapsedRealtimeMillis();
                    long actualTimeMillis = this.mCallback.systemClockMillis();
                    String reason = "Automatic time detection enabled.";
                    this.adjustAndSetDeviceSystemClock(this.mLastSystemClockTime, sendNetworkBroadcast, elapsedRealtimeMillis, actualTimeMillis, "Automatic time detection enabled.");
                }
                finally {
                    this.mCallback.releaseWakeLock();
                }
            }
        } else {
            this.mLastSystemClockTimeSet = null;
        }
    }

    @Override
    public void dump(PrintWriter pw, String[] args) {
        pw.println("mLastNitzTime=" + this.mLastNitzTime);
        pw.println("mLastSystemClockTimeSet=" + this.mLastSystemClockTimeSet);
        pw.println("mLastSystemClockTime=" + this.mLastSystemClockTime);
        pw.println("mLastSystemClockTimeSendNetworkBroadcast=" + this.mLastSystemClockTimeSendNetworkBroadcast);
    }

    private void adjustAndSetDeviceSystemClock(TimestampedValue<Long> newTime, boolean sendNetworkBroadcast, long elapsedRealtimeMillis, long actualSystemClockMillis, String reason) {
        long systemClockUpdateThreshold;
        long newSystemClockMillis = TimeDetectorStrategy.getTimeAt(newTime, elapsedRealtimeMillis);
        long absTimeDifference = Math.abs(newSystemClockMillis - actualSystemClockMillis);
        if (absTimeDifference < (systemClockUpdateThreshold = (long)this.mCallback.systemClockUpdateThresholdMillis())) {
            Slog.d(TAG, "adjustAndSetDeviceSystemClock: Not setting system clock. New time and system clock are close enough. elapsedRealtimeMillis=" + elapsedRealtimeMillis + " newTime=" + newTime + " reason=" + reason + " systemClockUpdateThreshold=" + systemClockUpdateThreshold + " absTimeDifference=" + absTimeDifference);
            return;
        }
        Slog.d(TAG, "Setting system clock using time=" + newTime + " reason=" + reason + " elapsedRealtimeMillis=" + elapsedRealtimeMillis + " newTimeMillis=" + newSystemClockMillis);
        this.mCallback.setSystemClock(newSystemClockMillis);
        this.mLastSystemClockTimeSet = newTime;
        if (sendNetworkBroadcast) {
            Intent intent = new Intent("android.intent.action.NETWORK_SET_TIME");
            intent.addFlags(0x20000000);
            intent.putExtra("time", newSystemClockMillis);
            this.mCallback.sendStickyBroadcast(intent);
        }
    }
}

