/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.timedetector;

import android.app.timedetector.ITimeDetectorService;
import android.app.timedetector.TimeSignal;
import android.content.ContentResolver;
import android.content.Context;
import android.database.ContentObserver;
import android.os.Binder;
import android.provider.Settings;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.util.DumpUtils;
import com.android.server.FgThread;
import com.android.server.SystemService;
import com.android.server.timedetector.SimpleTimeDetectorStrategy;
import com.android.server.timedetector.TimeDetectorStrategy;
import com.android.server.timedetector.TimeDetectorStrategyCallbackImpl;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.Objects;

public final class TimeDetectorService
extends ITimeDetectorService.Stub {
    private static final String TAG = "timedetector.TimeDetectorService";
    private final Context mContext;
    private final TimeDetectorStrategy.Callback mCallback;
    private final Object mStrategyLock = new Object();
    @GuardedBy(value={"mStrategyLock"})
    private final TimeDetectorStrategy mTimeDetectorStrategy;

    private static TimeDetectorService create(Context context) {
        SimpleTimeDetectorStrategy timeDetector = new SimpleTimeDetectorStrategy();
        TimeDetectorStrategyCallbackImpl callback = new TimeDetectorStrategyCallbackImpl(context);
        timeDetector.initialize(callback);
        final TimeDetectorService timeDetectorService = new TimeDetectorService(context, callback, timeDetector);
        ContentResolver contentResolver = context.getContentResolver();
        contentResolver.registerContentObserver(Settings.Global.getUriFor("auto_time"), true, new ContentObserver(FgThread.getHandler()){

            @Override
            public void onChange(boolean selfChange) {
                timeDetectorService.handleAutoTimeDetectionToggle();
            }
        });
        return timeDetectorService;
    }

    @VisibleForTesting
    public TimeDetectorService(Context context, TimeDetectorStrategy.Callback callback, TimeDetectorStrategy timeDetectorStrategy) {
        this.mContext = Objects.requireNonNull(context);
        this.mCallback = Objects.requireNonNull(callback);
        this.mTimeDetectorStrategy = Objects.requireNonNull(timeDetectorStrategy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void suggestTime(TimeSignal timeSignal) {
        this.enforceSetTimePermission();
        Objects.requireNonNull(timeSignal);
        long idToken = Binder.clearCallingIdentity();
        try {
            Object object = this.mStrategyLock;
            synchronized (object) {
                this.mTimeDetectorStrategy.suggestTime(timeSignal);
            }
        }
        finally {
            Binder.restoreCallingIdentity(idToken);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public void handleAutoTimeDetectionToggle() {
        Object object = this.mStrategyLock;
        synchronized (object) {
            boolean timeDetectionEnabled = this.mCallback.isTimeDetectionEnabled();
            this.mTimeDetectorStrategy.handleAutoTimeDetectionToggle(timeDetectionEnabled);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        if (!DumpUtils.checkDumpPermission(this.mContext, TAG, pw)) {
            return;
        }
        Object object = this.mStrategyLock;
        synchronized (object) {
            this.mTimeDetectorStrategy.dump(pw, args);
        }
    }

    private void enforceSetTimePermission() {
        this.mContext.enforceCallingPermission("android.permission.SET_TIME", "set time");
    }

    public static class Lifecycle
    extends SystemService {
        public Lifecycle(Context context) {
            super(context);
        }

        @Override
        public void onStart() {
            TimeDetectorService service = TimeDetectorService.create(this.getContext());
            this.publishBinderService("time_detector", service);
        }
    }
}

