/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.timedetector;

import android.app.timedetector.TimeSignal;
import android.content.Intent;
import android.util.TimestampedValue;
import java.io.PrintWriter;

public interface TimeDetectorStrategy {
    public void initialize(Callback var1);

    public void suggestTime(TimeSignal var1);

    public void handleAutoTimeDetectionToggle(boolean var1);

    public void dump(PrintWriter var1, String[] var2);

    public static long getTimeAt(TimestampedValue<Long> timeValue, long referenceClockMillisNow) {
        return referenceClockMillisNow - timeValue.getReferenceTimeMillis() + timeValue.getValue();
    }

    public static interface Callback {
        public int systemClockUpdateThresholdMillis();

        public boolean isTimeDetectionEnabled();

        public void acquireWakeLock();

        public long elapsedRealtimeMillis();

        public long systemClockMillis();

        public void setSystemClock(long var1);

        public void releaseWakeLock();

        public void sendStickyBroadcast(Intent var1);
    }
}

