/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.timedetector;

import android.app.AlarmManager;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.os.PowerManager;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.os.UserHandle;
import android.provider.Settings;
import android.util.Slog;
import com.android.server.timedetector.TimeDetectorStrategy;
import java.util.Objects;

public final class TimeDetectorStrategyCallbackImpl
implements TimeDetectorStrategy.Callback {
    private static final String TAG = "timedetector.TimeDetectorStrategyCallbackImpl";
    private static final int SYSTEM_CLOCK_UPDATE_THRESHOLD_MILLIS_DEFAULT = 2000;
    private final int mSystemClockUpdateThresholdMillis;
    private final Context mContext;
    private final ContentResolver mContentResolver;
    private final PowerManager.WakeLock mWakeLock;
    private final AlarmManager mAlarmManager;

    public TimeDetectorStrategyCallbackImpl(Context context) {
        this.mContext = Objects.requireNonNull(context);
        this.mContentResolver = Objects.requireNonNull(context.getContentResolver());
        PowerManager powerManager = context.getSystemService(PowerManager.class);
        this.mWakeLock = Objects.requireNonNull(powerManager.newWakeLock(1, TAG));
        this.mAlarmManager = Objects.requireNonNull(context.getSystemService(AlarmManager.class));
        this.mSystemClockUpdateThresholdMillis = SystemProperties.getInt("ro.sys.time_detector_update_diff", 2000);
    }

    @Override
    public int systemClockUpdateThresholdMillis() {
        return this.mSystemClockUpdateThresholdMillis;
    }

    @Override
    public boolean isTimeDetectionEnabled() {
        try {
            return Settings.Global.getInt(this.mContentResolver, "auto_time") != 0;
        }
        catch (Settings.SettingNotFoundException snfe) {
            return true;
        }
    }

    @Override
    public void acquireWakeLock() {
        if (this.mWakeLock.isHeld()) {
            Slog.wtf(TAG, "WakeLock " + this.mWakeLock + " already held");
        }
        this.mWakeLock.acquire();
    }

    @Override
    public long elapsedRealtimeMillis() {
        this.checkWakeLockHeld();
        return SystemClock.elapsedRealtime();
    }

    @Override
    public long systemClockMillis() {
        this.checkWakeLockHeld();
        return System.currentTimeMillis();
    }

    @Override
    public void setSystemClock(long newTimeMillis) {
        this.checkWakeLockHeld();
        this.mAlarmManager.setTime(newTimeMillis);
    }

    @Override
    public void releaseWakeLock() {
        this.checkWakeLockHeld();
        this.mWakeLock.release();
    }

    @Override
    public void sendStickyBroadcast(Intent intent) {
        this.mContext.sendStickyBroadcastAsUser(intent, UserHandle.ALL);
    }

    private void checkWakeLockHeld() {
        if (!this.mWakeLock.isHeld()) {
            Slog.wtf(TAG, "WakeLock " + this.mWakeLock + " not held");
        }
    }
}

