/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.timezone;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ProviderInfo;
import android.content.pm.ResolveInfo;
import android.content.res.Resources;
import android.os.UserHandle;
import android.util.Slog;
import com.android.server.timezone.ConfigHelper;
import com.android.server.timezone.PackageManagerHelper;
import java.util.List;

final class PackageTrackerHelperImpl
implements ConfigHelper,
PackageManagerHelper {
    private static final String TAG = "PackageTrackerHelperImpl";
    private final Context mContext;
    private final PackageManager mPackageManager;

    PackageTrackerHelperImpl(Context context) {
        this.mContext = context;
        this.mPackageManager = context.getPackageManager();
    }

    @Override
    public boolean isTrackingEnabled() {
        return this.mContext.getResources().getBoolean(17891550);
    }

    @Override
    public String getUpdateAppPackageName() {
        return this.mContext.getResources().getString(17039770);
    }

    @Override
    public String getDataAppPackageName() {
        Resources resources = this.mContext.getResources();
        return resources.getString(17039769);
    }

    @Override
    public int getCheckTimeAllowedMillis() {
        return this.mContext.getResources().getInteger(17694898);
    }

    @Override
    public int getFailedCheckRetryCount() {
        return this.mContext.getResources().getInteger(17694897);
    }

    @Override
    public long getInstalledPackageVersion(String packageName) throws PackageManager.NameNotFoundException {
        int flags = 32768;
        PackageInfo packageInfo = this.mPackageManager.getPackageInfo(packageName, flags);
        return packageInfo.getLongVersionCode();
    }

    @Override
    public boolean isPrivilegedApp(String packageName) throws PackageManager.NameNotFoundException {
        int flags = 32768;
        PackageInfo packageInfo = this.mPackageManager.getPackageInfo(packageName, flags);
        return packageInfo.applicationInfo.isPrivilegedApp();
    }

    @Override
    public boolean usesPermission(String packageName, String requiredPermissionName) throws PackageManager.NameNotFoundException {
        int flags = 36864;
        PackageInfo packageInfo = this.mPackageManager.getPackageInfo(packageName, flags);
        if (packageInfo.requestedPermissions == null) {
            return false;
        }
        for (String requestedPermission : packageInfo.requestedPermissions) {
            if (!requiredPermissionName.equals(requestedPermission)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean contentProviderRegistered(String authority, String requiredPackageName) {
        int flags = 32768;
        ProviderInfo providerInfo = this.mPackageManager.resolveContentProviderAsUser(authority, flags, UserHandle.SYSTEM.getIdentifier());
        if (providerInfo == null) {
            Slog.i(TAG, "contentProviderRegistered: No content provider registered with authority=" + authority);
            return false;
        }
        boolean packageMatches = requiredPackageName.equals(providerInfo.applicationInfo.packageName);
        if (!packageMatches) {
            Slog.i(TAG, "contentProviderRegistered: App with packageName=" + requiredPackageName + " does not expose the a content provider with authority=" + authority);
            return false;
        }
        return true;
    }

    @Override
    public boolean receiverRegistered(Intent intent, String requiredPermissionName) throws PackageManager.NameNotFoundException {
        int flags = 32768;
        List<ResolveInfo> resolveInfo = this.mPackageManager.queryBroadcastReceiversAsUser(intent, flags, UserHandle.SYSTEM);
        if (resolveInfo.size() != 1) {
            Slog.i(TAG, "receiverRegistered: Zero or multiple broadcast receiver registered for intent=" + intent + ", found=" + resolveInfo);
            return false;
        }
        ResolveInfo matched = resolveInfo.get(0);
        boolean requiresPermission = requiredPermissionName.equals(matched.activityInfo.permission);
        if (!requiresPermission) {
            Slog.i(TAG, "receiverRegistered: Broadcast receiver registered for intent=" + intent + " must require permission " + requiredPermissionName);
        }
        return requiresPermission;
    }
}

