/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.timezone;

import android.content.Context;
import android.content.Intent;
import android.os.AsyncTask;
import android.os.UserHandle;
import com.android.internal.util.DumpUtils;
import com.android.server.timezone.PermissionHelper;
import com.android.server.timezone.RulesManagerIntentHelper;
import java.io.PrintWriter;
import java.util.concurrent.Executor;

final class RulesManagerServiceHelperImpl
implements PermissionHelper,
Executor,
RulesManagerIntentHelper {
    private final Context mContext;

    RulesManagerServiceHelperImpl(Context context) {
        this.mContext = context;
    }

    @Override
    public void enforceCallerHasPermission(String requiredPermission) {
        this.mContext.enforceCallingPermission(requiredPermission, null);
    }

    @Override
    public boolean checkDumpPermission(String tag, PrintWriter pw) {
        return DumpUtils.checkDumpPermission(this.mContext, tag, pw);
    }

    @Override
    public void execute(Runnable runnable) {
        AsyncTask.execute(runnable);
    }

    @Override
    public void sendTimeZoneOperationStaged() {
        this.sendOperationIntent(true);
    }

    @Override
    public void sendTimeZoneOperationUnstaged() {
        this.sendOperationIntent(false);
    }

    private void sendOperationIntent(boolean staged) {
        Intent intent = new Intent("com.android.intent.action.timezone.RULES_UPDATE_OPERATION");
        intent.addFlags(0x1000000);
        intent.putExtra("staged", staged);
        this.mContext.sendBroadcastAsUser(intent, UserHandle.SYSTEM);
    }
}

