/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.tv;

import android.content.Context;
import android.content.Intent;
import android.media.tv.TvContentRating;
import android.os.Environment;
import android.os.Handler;
import android.os.UserHandle;
import android.text.TextUtils;
import android.util.AtomicFile;
import android.util.Slog;
import android.util.Xml;
import com.android.internal.util.FastXmlSerializer;
import com.android.internal.util.XmlUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import libcore.io.IoUtils;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

final class PersistentDataStore {
    private static final String TAG = "TvInputManagerService";
    private final Context mContext;
    private final Handler mHandler = new Handler();
    private final AtomicFile mAtomicFile;
    private final List<TvContentRating> mBlockedRatings = Collections.synchronizedList(new ArrayList());
    private boolean mBlockedRatingsChanged;
    private boolean mParentalControlsEnabled;
    private boolean mParentalControlsEnabledChanged;
    private boolean mLoaded;
    private final Runnable mSaveRunnable = new Runnable(){

        @Override
        public void run() {
            PersistentDataStore.this.save();
        }
    };
    private static final String TAG_TV_INPUT_MANAGER_STATE = "tv-input-manager-state";
    private static final String TAG_BLOCKED_RATINGS = "blocked-ratings";
    private static final String TAG_RATING = "rating";
    private static final String TAG_PARENTAL_CONTROLS = "parental-controls";
    private static final String ATTR_STRING = "string";
    private static final String ATTR_ENABLED = "enabled";

    public PersistentDataStore(Context context, int userId) {
        this.mContext = context;
        File userDir = Environment.getUserSystemDirectory(userId);
        if (!userDir.exists() && !userDir.mkdirs()) {
            throw new IllegalStateException("User dir cannot be created: " + userDir);
        }
        this.mAtomicFile = new AtomicFile(new File(userDir, "tv-input-manager-state.xml"), "tv-input-state");
    }

    public boolean isParentalControlsEnabled() {
        this.loadIfNeeded();
        return this.mParentalControlsEnabled;
    }

    public void setParentalControlsEnabled(boolean enabled) {
        this.loadIfNeeded();
        if (this.mParentalControlsEnabled != enabled) {
            this.mParentalControlsEnabled = enabled;
            this.mParentalControlsEnabledChanged = true;
            this.postSave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isRatingBlocked(TvContentRating rating) {
        this.loadIfNeeded();
        List<TvContentRating> list = this.mBlockedRatings;
        synchronized (list) {
            TvContentRating blockedRating;
            Iterator<TvContentRating> iterator = this.mBlockedRatings.iterator();
            do {
                if (!iterator.hasNext()) return false;
            } while (!rating.contains(blockedRating = iterator.next()));
            return true;
        }
    }

    public TvContentRating[] getBlockedRatings() {
        this.loadIfNeeded();
        return this.mBlockedRatings.toArray(new TvContentRating[this.mBlockedRatings.size()]);
    }

    public void addBlockedRating(TvContentRating rating) {
        this.loadIfNeeded();
        if (rating != null && !this.mBlockedRatings.contains(rating)) {
            this.mBlockedRatings.add(rating);
            this.mBlockedRatingsChanged = true;
            this.postSave();
        }
    }

    public void removeBlockedRating(TvContentRating rating) {
        this.loadIfNeeded();
        if (rating != null && this.mBlockedRatings.contains(rating)) {
            this.mBlockedRatings.remove(rating);
            this.mBlockedRatingsChanged = true;
            this.postSave();
        }
    }

    private void loadIfNeeded() {
        if (!this.mLoaded) {
            this.load();
            this.mLoaded = true;
        }
    }

    private void clearState() {
        this.mBlockedRatings.clear();
        this.mParentalControlsEnabled = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load() {
        FileInputStream is;
        this.clearState();
        try {
            is = this.mAtomicFile.openRead();
        }
        catch (FileNotFoundException ex) {
            return;
        }
        try {
            XmlPullParser parser = Xml.newPullParser();
            parser.setInput(new BufferedInputStream(is), StandardCharsets.UTF_8.name());
            this.loadFromXml(parser);
        }
        catch (IOException | XmlPullParserException ex) {
            Slog.w(TAG, "Failed to load tv input manager persistent store data.", ex);
            this.clearState();
        }
        finally {
            IoUtils.closeQuietly(is);
        }
    }

    private void postSave() {
        this.mHandler.removeCallbacks(this.mSaveRunnable);
        this.mHandler.post(this.mSaveRunnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void save() {
        try {
            FileOutputStream os = this.mAtomicFile.startWrite();
            boolean success = false;
            try {
                FastXmlSerializer serializer = new FastXmlSerializer();
                serializer.setOutput(new BufferedOutputStream(os), StandardCharsets.UTF_8.name());
                this.saveToXml(serializer);
                serializer.flush();
                success = true;
            }
            finally {
                if (success) {
                    this.mAtomicFile.finishWrite(os);
                    this.broadcastChangesIfNeeded();
                } else {
                    this.mAtomicFile.failWrite(os);
                }
            }
        }
        catch (IOException ex) {
            Slog.w(TAG, "Failed to save tv input manager persistent store data.", ex);
        }
    }

    private void broadcastChangesIfNeeded() {
        if (this.mParentalControlsEnabledChanged) {
            this.mParentalControlsEnabledChanged = false;
            this.mContext.sendBroadcastAsUser(new Intent("android.media.tv.action.PARENTAL_CONTROLS_ENABLED_CHANGED"), UserHandle.ALL);
        }
        if (this.mBlockedRatingsChanged) {
            this.mBlockedRatingsChanged = false;
            this.mContext.sendBroadcastAsUser(new Intent("android.media.tv.action.BLOCKED_RATINGS_CHANGED"), UserHandle.ALL);
        }
    }

    private void loadFromXml(XmlPullParser parser) throws IOException, XmlPullParserException {
        XmlUtils.beginDocument(parser, TAG_TV_INPUT_MANAGER_STATE);
        int outerDepth = parser.getDepth();
        while (XmlUtils.nextElementWithin(parser, outerDepth)) {
            if (parser.getName().equals(TAG_BLOCKED_RATINGS)) {
                this.loadBlockedRatingsFromXml(parser);
                continue;
            }
            if (!parser.getName().equals(TAG_PARENTAL_CONTROLS)) continue;
            String enabled = parser.getAttributeValue(null, ATTR_ENABLED);
            if (TextUtils.isEmpty(enabled)) {
                throw new XmlPullParserException("Missing enabled attribute on parental-controls");
            }
            this.mParentalControlsEnabled = Boolean.parseBoolean(enabled);
        }
    }

    private void loadBlockedRatingsFromXml(XmlPullParser parser) throws IOException, XmlPullParserException {
        int outerDepth = parser.getDepth();
        while (XmlUtils.nextElementWithin(parser, outerDepth)) {
            if (!parser.getName().equals(TAG_RATING)) continue;
            String ratingString = parser.getAttributeValue(null, ATTR_STRING);
            if (TextUtils.isEmpty(ratingString)) {
                throw new XmlPullParserException("Missing string attribute on rating");
            }
            this.mBlockedRatings.add(TvContentRating.unflattenFromString(ratingString));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveToXml(XmlSerializer serializer) throws IOException {
        serializer.startDocument(null, true);
        serializer.setFeature("http://xmlpull.org/v1/doc/features.html#indent-output", true);
        serializer.startTag(null, TAG_TV_INPUT_MANAGER_STATE);
        serializer.startTag(null, TAG_BLOCKED_RATINGS);
        List<TvContentRating> list = this.mBlockedRatings;
        synchronized (list) {
            for (TvContentRating rating : this.mBlockedRatings) {
                serializer.startTag(null, TAG_RATING);
                serializer.attribute(null, ATTR_STRING, rating.flattenToString());
                serializer.endTag(null, TAG_RATING);
            }
        }
        serializer.endTag(null, TAG_BLOCKED_RATINGS);
        serializer.startTag(null, TAG_PARENTAL_CONTROLS);
        serializer.attribute(null, ATTR_ENABLED, Boolean.toString(this.mParentalControlsEnabled));
        serializer.endTag(null, TAG_PARENTAL_CONTROLS);
        serializer.endTag(null, TAG_TV_INPUT_MANAGER_STATE);
        serializer.endDocument();
    }
}

