/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.tv;

import android.content.Context;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.util.ArrayMap;
import android.util.Slog;
import com.android.server.SystemService;
import com.android.server.Watchdog;
import com.android.server.tv.TvRemoteProviderProxy;
import com.android.server.tv.TvRemoteProviderWatcher;
import com.android.server.tv.UinputBridge;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;

public class TvRemoteService
extends SystemService
implements Watchdog.Monitor {
    private static final String TAG = "TvRemoteService";
    private static final boolean DEBUG = false;
    private static final boolean DEBUG_KEYS = false;
    private Map<IBinder, UinputBridge> mBridgeMap = new ArrayMap<IBinder, UinputBridge>();
    private Map<IBinder, TvRemoteProviderProxy> mProviderMap = new ArrayMap<IBinder, TvRemoteProviderProxy>();
    private ArrayList<TvRemoteProviderProxy> mProviderList = new ArrayList();
    private final Object mLock = new Object();
    public final UserHandler mHandler;

    public TvRemoteService(Context context) {
        super(context);
        this.mHandler = new UserHandler(new UserProvider(this), context);
        Watchdog.getInstance().addMonitor(this);
    }

    @Override
    public void onStart() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void monitor() {
        Object object = this.mLock;
        synchronized (object) {
        }
    }

    @Override
    public void onBootPhase(int phase) {
        if (phase == 600) {
            this.mHandler.sendEmptyMessage(1);
        }
    }

    private void informInputBridgeConnected(IBinder token) {
        this.mHandler.obtainMessage(2, 0, 0, token).sendToTarget();
    }

    private void openInputBridgeInternalLocked(TvRemoteProviderProxy provider, IBinder token, String name, int width, int height, int maxPointers) {
        try {
            if (this.mBridgeMap.containsKey(token)) {
                this.informInputBridgeConnected(token);
                return;
            }
            UinputBridge inputBridge = new UinputBridge(token, name, width, height, maxPointers);
            this.mBridgeMap.put(token, inputBridge);
            this.mProviderMap.put(token, provider);
            this.informInputBridgeConnected(token);
        }
        catch (IOException ioe) {
            Slog.e(TAG, "Cannot create device for " + name);
        }
    }

    private void closeInputBridgeInternalLocked(IBinder token) {
        UinputBridge inputBridge = this.mBridgeMap.get(token);
        if (inputBridge != null) {
            inputBridge.close(token);
        }
        this.mBridgeMap.remove(token);
    }

    private void clearInputBridgeInternalLocked(IBinder token) {
        UinputBridge inputBridge = this.mBridgeMap.get(token);
        if (inputBridge != null) {
            inputBridge.clear(token);
        }
    }

    private void sendTimeStampInternalLocked(IBinder token, long timestamp) {
        UinputBridge inputBridge = this.mBridgeMap.get(token);
        if (inputBridge != null) {
            inputBridge.sendTimestamp(token, timestamp);
        }
    }

    private void sendKeyDownInternalLocked(IBinder token, int keyCode) {
        UinputBridge inputBridge = this.mBridgeMap.get(token);
        if (inputBridge != null) {
            inputBridge.sendKeyDown(token, keyCode);
        }
    }

    private void sendKeyUpInternalLocked(IBinder token, int keyCode) {
        UinputBridge inputBridge = this.mBridgeMap.get(token);
        if (inputBridge != null) {
            inputBridge.sendKeyUp(token, keyCode);
        }
    }

    private void sendPointerDownInternalLocked(IBinder token, int pointerId, int x, int y) {
        UinputBridge inputBridge = this.mBridgeMap.get(token);
        if (inputBridge != null) {
            inputBridge.sendPointerDown(token, pointerId, x, y);
        }
    }

    private void sendPointerUpInternalLocked(IBinder token, int pointerId) {
        UinputBridge inputBridge = this.mBridgeMap.get(token);
        if (inputBridge != null) {
            inputBridge.sendPointerUp(token, pointerId);
        }
    }

    private void sendPointerSyncInternalLocked(IBinder token) {
        UinputBridge inputBridge = this.mBridgeMap.get(token);
        if (inputBridge != null) {
            inputBridge.sendPointerSync(token);
        }
    }

    private final class UserProvider
    implements TvRemoteProviderWatcher.ProviderMethods,
    TvRemoteProviderProxy.ProviderMethods {
        private final TvRemoteService mService;

        public UserProvider(TvRemoteService service) {
            this.mService = service;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void openInputBridge(TvRemoteProviderProxy provider, IBinder token, String name, int width, int height, int maxPointers) {
            Object object = TvRemoteService.this.mLock;
            synchronized (object) {
                if (TvRemoteService.this.mProviderList.contains(provider)) {
                    this.mService.openInputBridgeInternalLocked(provider, token, name, width, height, maxPointers);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void closeInputBridge(TvRemoteProviderProxy provider, IBinder token) {
            Object object = TvRemoteService.this.mLock;
            synchronized (object) {
                if (TvRemoteService.this.mProviderList.contains(provider)) {
                    this.mService.closeInputBridgeInternalLocked(token);
                    TvRemoteService.this.mProviderMap.remove(token);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clearInputBridge(TvRemoteProviderProxy provider, IBinder token) {
            Object object = TvRemoteService.this.mLock;
            synchronized (object) {
                if (TvRemoteService.this.mProviderList.contains(provider)) {
                    this.mService.clearInputBridgeInternalLocked(token);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void sendTimeStamp(TvRemoteProviderProxy provider, IBinder token, long timestamp) {
            Object object = TvRemoteService.this.mLock;
            synchronized (object) {
                if (TvRemoteService.this.mProviderList.contains(provider)) {
                    this.mService.sendTimeStampInternalLocked(token, timestamp);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void sendKeyDown(TvRemoteProviderProxy provider, IBinder token, int keyCode) {
            Object object = TvRemoteService.this.mLock;
            synchronized (object) {
                if (TvRemoteService.this.mProviderList.contains(provider)) {
                    this.mService.sendKeyDownInternalLocked(token, keyCode);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void sendKeyUp(TvRemoteProviderProxy provider, IBinder token, int keyCode) {
            Object object = TvRemoteService.this.mLock;
            synchronized (object) {
                if (TvRemoteService.this.mProviderList.contains(provider)) {
                    this.mService.sendKeyUpInternalLocked(token, keyCode);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void sendPointerDown(TvRemoteProviderProxy provider, IBinder token, int pointerId, int x, int y) {
            Object object = TvRemoteService.this.mLock;
            synchronized (object) {
                if (TvRemoteService.this.mProviderList.contains(provider)) {
                    this.mService.sendPointerDownInternalLocked(token, pointerId, x, y);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void sendPointerUp(TvRemoteProviderProxy provider, IBinder token, int pointerId) {
            Object object = TvRemoteService.this.mLock;
            synchronized (object) {
                if (TvRemoteService.this.mProviderList.contains(provider)) {
                    this.mService.sendPointerUpInternalLocked(token, pointerId);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void sendPointerSync(TvRemoteProviderProxy provider, IBinder token) {
            Object object = TvRemoteService.this.mLock;
            synchronized (object) {
                if (TvRemoteService.this.mProviderList.contains(provider)) {
                    this.mService.sendPointerSyncInternalLocked(token);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addProvider(TvRemoteProviderProxy provider) {
            Object object = TvRemoteService.this.mLock;
            synchronized (object) {
                provider.setProviderSink(this);
                TvRemoteService.this.mProviderList.add(provider);
                Slog.d(TvRemoteService.TAG, "provider: " + provider.toString());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeProvider(TvRemoteProviderProxy provider) {
            Object object = TvRemoteService.this.mLock;
            synchronized (object) {
                if (!TvRemoteService.this.mProviderList.remove(provider)) {
                    Slog.e(TvRemoteService.TAG, "Unknown provider " + provider);
                }
            }
        }
    }

    private final class UserHandler
    extends Handler {
        public static final int MSG_START = 1;
        public static final int MSG_INPUT_BRIDGE_CONNECTED = 2;
        private final TvRemoteProviderWatcher mWatcher;
        private boolean mRunning;

        public UserHandler(UserProvider provider, Context context) {
            super(Looper.getMainLooper(), null, true);
            this.mWatcher = new TvRemoteProviderWatcher(context, provider, this);
        }

        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    this.start();
                    break;
                }
                case 2: {
                    IBinder token = (IBinder)msg.obj;
                    TvRemoteProviderProxy provider = (TvRemoteProviderProxy)TvRemoteService.this.mProviderMap.get(token);
                    if (provider == null) break;
                    provider.inputBridgeConnected(token);
                    break;
                }
            }
        }

        private void start() {
            if (!this.mRunning) {
                this.mRunning = true;
                this.mWatcher.start();
            }
        }
    }
}

