/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.tv;

import android.os.IBinder;
import dalvik.system.CloseGuard;
import java.io.IOException;

public final class UinputBridge {
    private final CloseGuard mCloseGuard = CloseGuard.get();
    private long mPtr;
    private IBinder mToken = null;

    private static native long nativeOpen(String var0, String var1, int var2, int var3, int var4);

    private static native void nativeClose(long var0);

    private static native void nativeClear(long var0);

    private static native void nativeSendTimestamp(long var0, long var2);

    private static native void nativeSendKey(long var0, int var2, boolean var3);

    private static native void nativeSendPointerDown(long var0, int var2, int var3, int var4);

    private static native void nativeSendPointerUp(long var0, int var2);

    private static native void nativeSendPointerSync(long var0);

    public UinputBridge(IBinder token, String name, int width, int height, int maxPointers) throws IOException {
        if (width < 1 || height < 1) {
            throw new IllegalArgumentException("Touchpad must be at least 1x1.");
        }
        if (maxPointers < 1 || maxPointers > 32) {
            throw new IllegalArgumentException("Touchpad must support between 1 and 32 pointers.");
        }
        if (token == null) {
            throw new IllegalArgumentException("Token cannot be null");
        }
        this.mPtr = UinputBridge.nativeOpen(name, token.toString(), width, height, maxPointers);
        if (this.mPtr == 0L) {
            throw new IOException("Could not open uinput device " + name);
        }
        this.mToken = token;
        this.mCloseGuard.open("close");
    }

    protected void finalize() throws Throwable {
        try {
            if (this.mCloseGuard != null) {
                this.mCloseGuard.warnIfOpen();
            }
            this.close(this.mToken);
        }
        finally {
            this.mToken = null;
            super.finalize();
        }
    }

    public void close(IBinder token) {
        if (this.isTokenValid(token) && this.mPtr != 0L) {
            this.clear(token);
            UinputBridge.nativeClose(this.mPtr);
            this.mPtr = 0L;
            this.mCloseGuard.close();
        }
    }

    public IBinder getToken() {
        return this.mToken;
    }

    protected boolean isTokenValid(IBinder token) {
        return this.mToken.equals(token);
    }

    public void sendTimestamp(IBinder token, long timestamp) {
        if (this.isTokenValid(token)) {
            UinputBridge.nativeSendTimestamp(this.mPtr, timestamp);
        }
    }

    public void sendKeyDown(IBinder token, int keyCode) {
        if (this.isTokenValid(token)) {
            UinputBridge.nativeSendKey(this.mPtr, keyCode, true);
        }
    }

    public void sendKeyUp(IBinder token, int keyCode) {
        if (this.isTokenValid(token)) {
            UinputBridge.nativeSendKey(this.mPtr, keyCode, false);
        }
    }

    public void sendPointerDown(IBinder token, int pointerId, int x, int y) {
        if (this.isTokenValid(token)) {
            UinputBridge.nativeSendPointerDown(this.mPtr, pointerId, x, y);
        }
    }

    public void sendPointerUp(IBinder token, int pointerId) {
        if (this.isTokenValid(token)) {
            UinputBridge.nativeSendPointerUp(this.mPtr, pointerId);
        }
    }

    public void sendPointerSync(IBinder token) {
        if (this.isTokenValid(token)) {
            UinputBridge.nativeSendPointerSync(this.mPtr);
        }
    }

    public void clear(IBinder token) {
        if (this.isTokenValid(token)) {
            UinputBridge.nativeClear(this.mPtr);
        }
    }
}

