/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.twilight;

import android.app.AlarmManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.icu.impl.CalendarAstronomer;
import android.icu.util.Calendar;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.util.ArrayMap;
import android.util.Slog;
import com.android.internal.annotations.GuardedBy;
import com.android.server.SystemService;
import com.android.server.twilight.TwilightListener;
import com.android.server.twilight.TwilightManager;
import com.android.server.twilight.TwilightState;
import java.util.Objects;

public final class TwilightService
extends SystemService
implements AlarmManager.OnAlarmListener,
Handler.Callback,
LocationListener {
    private static final String TAG = "TwilightService";
    private static final boolean DEBUG = false;
    private static final int MSG_START_LISTENING = 1;
    private static final int MSG_STOP_LISTENING = 2;
    @GuardedBy(value={"mListeners"})
    private final ArrayMap<TwilightListener, Handler> mListeners = new ArrayMap();
    private final Handler mHandler = new Handler(Looper.getMainLooper(), this);
    protected AlarmManager mAlarmManager;
    private LocationManager mLocationManager;
    private boolean mBootCompleted;
    private boolean mHasListeners;
    private BroadcastReceiver mTimeChangedReceiver;
    protected Location mLastLocation;
    @GuardedBy(value={"mListeners"})
    protected TwilightState mLastTwilightState;

    public TwilightService(Context context) {
        super(context);
    }

    @Override
    public void onStart() {
        this.publishLocalService(TwilightManager.class, new TwilightManager(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerListener(TwilightListener listener, Handler handler) {
                ArrayMap arrayMap = TwilightService.this.mListeners;
                synchronized (arrayMap) {
                    boolean wasEmpty = TwilightService.this.mListeners.isEmpty();
                    TwilightService.this.mListeners.put(listener, handler);
                    if (wasEmpty && !TwilightService.this.mListeners.isEmpty()) {
                        TwilightService.this.mHandler.sendEmptyMessage(1);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterListener(TwilightListener listener) {
                ArrayMap arrayMap = TwilightService.this.mListeners;
                synchronized (arrayMap) {
                    boolean wasEmpty = TwilightService.this.mListeners.isEmpty();
                    TwilightService.this.mListeners.remove(listener);
                    if (!wasEmpty && TwilightService.this.mListeners.isEmpty()) {
                        TwilightService.this.mHandler.sendEmptyMessage(2);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public TwilightState getLastTwilightState() {
                ArrayMap arrayMap = TwilightService.this.mListeners;
                synchronized (arrayMap) {
                    return TwilightService.this.mLastTwilightState;
                }
            }
        });
    }

    @Override
    public void onBootPhase(int phase) {
        if (phase == 1000) {
            Context c = this.getContext();
            this.mAlarmManager = (AlarmManager)c.getSystemService("alarm");
            this.mLocationManager = (LocationManager)c.getSystemService("location");
            this.mBootCompleted = true;
            if (this.mHasListeners) {
                this.startListening();
            }
        }
    }

    @Override
    public boolean handleMessage(Message msg) {
        switch (msg.what) {
            case 1: {
                if (!this.mHasListeners) {
                    this.mHasListeners = true;
                    if (this.mBootCompleted) {
                        this.startListening();
                    }
                }
                return true;
            }
            case 2: {
                if (this.mHasListeners) {
                    this.mHasListeners = false;
                    if (this.mBootCompleted) {
                        this.stopListening();
                    }
                }
                return true;
            }
        }
        return false;
    }

    private void startListening() {
        Slog.d(TAG, "startListening");
        this.mLocationManager.requestLocationUpdates(null, this, Looper.getMainLooper());
        if (this.mLocationManager.getLastLocation() == null && this.mLocationManager.isProviderEnabled("network")) {
            this.mLocationManager.requestSingleUpdate("network", (LocationListener)this, Looper.getMainLooper());
        }
        if (this.mTimeChangedReceiver == null) {
            this.mTimeChangedReceiver = new BroadcastReceiver(){

                @Override
                public void onReceive(Context context, Intent intent) {
                    Slog.d(TwilightService.TAG, "onReceive: " + intent);
                    TwilightService.this.updateTwilightState();
                }
            };
            IntentFilter intentFilter = new IntentFilter("android.intent.action.TIME_SET");
            intentFilter.addAction("android.intent.action.TIMEZONE_CHANGED");
            this.getContext().registerReceiver(this.mTimeChangedReceiver, intentFilter);
        }
        this.updateTwilightState();
    }

    private void stopListening() {
        Slog.d(TAG, "stopListening");
        if (this.mTimeChangedReceiver != null) {
            this.getContext().unregisterReceiver(this.mTimeChangedReceiver);
            this.mTimeChangedReceiver = null;
        }
        if (this.mLastTwilightState != null) {
            this.mAlarmManager.cancel(this);
        }
        this.mLocationManager.removeUpdates(this);
        this.mLastLocation = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateTwilightState() {
        long currentTimeMillis = System.currentTimeMillis();
        Location location = this.mLastLocation != null ? this.mLastLocation : this.mLocationManager.getLastLocation();
        final TwilightState state = TwilightService.calculateTwilightState(location, currentTimeMillis);
        ArrayMap<TwilightListener, Handler> arrayMap = this.mListeners;
        synchronized (arrayMap) {
            if (!Objects.equals(this.mLastTwilightState, state)) {
                this.mLastTwilightState = state;
                for (int i = this.mListeners.size() - 1; i >= 0; --i) {
                    final TwilightListener listener = this.mListeners.keyAt(i);
                    Handler handler = this.mListeners.valueAt(i);
                    handler.post(new Runnable(){

                        @Override
                        public void run() {
                            listener.onTwilightStateChanged(state);
                        }
                    });
                }
            }
        }
        if (state != null) {
            long triggerAtMillis = state.isNight() ? state.sunriseTimeMillis() : state.sunsetTimeMillis();
            this.mAlarmManager.setExact(1, triggerAtMillis, TAG, this, this.mHandler);
        }
    }

    @Override
    public void onAlarm() {
        Slog.d(TAG, "onAlarm");
        this.updateTwilightState();
    }

    @Override
    public void onLocationChanged(Location location) {
        if (location != null && (location.getLongitude() != 0.0 || location.getLatitude() != 0.0)) {
            Slog.d(TAG, "onLocationChanged: provider=" + location.getProvider() + " accuracy=" + location.getAccuracy() + " time=" + location.getTime());
            this.mLastLocation = location;
            this.updateTwilightState();
        }
    }

    @Override
    public void onStatusChanged(String provider, int status, Bundle extras) {
    }

    @Override
    public void onProviderEnabled(String provider) {
    }

    @Override
    public void onProviderDisabled(String provider) {
    }

    private static TwilightState calculateTwilightState(Location location, long timeMillis) {
        if (location == null) {
            return null;
        }
        CalendarAstronomer ca = new CalendarAstronomer(location.getLongitude(), location.getLatitude());
        Calendar noon = Calendar.getInstance();
        noon.setTimeInMillis(timeMillis);
        noon.set(11, 12);
        noon.set(12, 0);
        noon.set(13, 0);
        noon.set(14, 0);
        ca.setTime(noon.getTimeInMillis());
        long sunriseTimeMillis = ca.getSunRiseSet(true);
        long sunsetTimeMillis = ca.getSunRiseSet(false);
        if (sunsetTimeMillis < timeMillis) {
            noon.add(5, 1);
            ca.setTime(noon.getTimeInMillis());
            sunriseTimeMillis = ca.getSunRiseSet(true);
        } else if (sunriseTimeMillis > timeMillis) {
            noon.add(5, -1);
            ca.setTime(noon.getTimeInMillis());
            sunsetTimeMillis = ca.getSunRiseSet(false);
        }
        return new TwilightState(sunriseTimeMillis, sunsetTimeMillis);
    }
}

