/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.uri;

import android.content.ContentProvider;
import android.net.Uri;
import android.util.proto.ProtoOutputStream;

public class GrantUri {
    public final int sourceUserId;
    public final Uri uri;
    public boolean prefix;

    public GrantUri(int sourceUserId, Uri uri, boolean prefix) {
        this.sourceUserId = sourceUserId;
        this.uri = uri;
        this.prefix = prefix;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + this.sourceUserId;
        hashCode = 31 * hashCode + this.uri.hashCode();
        hashCode = 31 * hashCode + (this.prefix ? 1231 : 1237);
        return hashCode;
    }

    public boolean equals(Object o) {
        if (o instanceof GrantUri) {
            GrantUri other = (GrantUri)o;
            return this.uri.equals(other.uri) && this.sourceUserId == other.sourceUserId && this.prefix == other.prefix;
        }
        return false;
    }

    public String toString() {
        String result = this.uri.toString() + " [user " + this.sourceUserId + "]";
        if (this.prefix) {
            result = result + " [prefix]";
        }
        return result;
    }

    public String toSafeString() {
        String result = this.uri.toSafeString() + " [user " + this.sourceUserId + "]";
        if (this.prefix) {
            result = result + " [prefix]";
        }
        return result;
    }

    public void writeToProto(ProtoOutputStream proto, long fieldId) {
        long token = proto.start(fieldId);
        proto.write(1138166333442L, this.uri.toString());
        proto.write(0x10500000001L, this.sourceUserId);
        proto.end(token);
    }

    public static GrantUri resolve(int defaultSourceUserHandle, Uri uri) {
        if ("content".equals(uri.getScheme())) {
            return new GrantUri(ContentProvider.getUserIdFromUri(uri, defaultSourceUserHandle), ContentProvider.getUriWithoutUserId(uri), false);
        }
        return new GrantUri(defaultSourceUserHandle, uri, false);
    }
}

