/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.uri;

import android.app.ActivityManager;
import android.app.ActivityManagerInternal;
import android.app.AppGlobals;
import android.app.GrantedUriPermission;
import android.app.IUriGrantsManager;
import android.content.ClipData;
import android.content.Context;
import android.content.Intent;
import android.content.pm.IPackageManager;
import android.content.pm.PackageManager;
import android.content.pm.PackageManagerInternal;
import android.content.pm.ParceledListSlice;
import android.content.pm.PathPermission;
import android.content.pm.ProviderInfo;
import android.net.Uri;
import android.os.Binder;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.Process;
import android.os.RemoteException;
import android.os.SystemClock;
import android.os.UserHandle;
import android.util.ArrayMap;
import android.util.AtomicFile;
import android.util.Slog;
import android.util.SparseArray;
import android.util.Xml;
import com.android.internal.util.FastXmlSerializer;
import com.android.internal.util.Preconditions;
import com.android.internal.util.XmlUtils;
import com.android.server.IoThread;
import com.android.server.LocalServices;
import com.android.server.SystemService;
import com.android.server.SystemServiceManager;
import com.android.server.uri.GrantUri;
import com.android.server.uri.NeededUriGrants;
import com.android.server.uri.UriGrantsManagerInternal;
import com.android.server.uri.UriPermission;
import com.android.server.uri.UriPermissionOwner;
import com.google.android.collect.Lists;
import com.google.android.collect.Maps;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import libcore.io.IoUtils;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class UriGrantsManagerService
extends IUriGrantsManager.Stub {
    private static final boolean DEBUG = false;
    private static final String TAG = "UriGrantsManagerService";
    private static final int MAX_PERSISTED_URI_GRANTS = 128;
    private final Object mLock = new Object();
    private final Context mContext;
    private final H mH;
    ActivityManagerInternal mAmInternal;
    PackageManagerInternal mPmInternal;
    private final AtomicFile mGrantFile;
    private static final String TAG_URI_GRANTS = "uri-grants";
    private static final String TAG_URI_GRANT = "uri-grant";
    private static final String ATTR_USER_HANDLE = "userHandle";
    private static final String ATTR_SOURCE_USER_ID = "sourceUserId";
    private static final String ATTR_TARGET_USER_ID = "targetUserId";
    private static final String ATTR_SOURCE_PKG = "sourcePkg";
    private static final String ATTR_TARGET_PKG = "targetPkg";
    private static final String ATTR_URI = "uri";
    private static final String ATTR_MODE_FLAGS = "modeFlags";
    private static final String ATTR_CREATED_TIME = "createdTime";
    private static final String ATTR_PREFIX = "prefix";
    private final SparseArray<ArrayMap<GrantUri, UriPermission>> mGrantedUriPermissions = new SparseArray();

    private UriGrantsManagerService(Context context) {
        this.mContext = context;
        this.mH = new H(IoThread.get().getLooper());
        File systemDir = SystemServiceManager.ensureSystemDir();
        this.mGrantFile = new AtomicFile(new File(systemDir, "urigrants.xml"), TAG_URI_GRANTS);
    }

    private void start() {
        LocalServices.addService(UriGrantsManagerInternal.class, new LocalService());
    }

    void onActivityManagerInternalAdded() {
        this.mAmInternal = LocalServices.getService(ActivityManagerInternal.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void grantUriPermissionFromOwner(IBinder token, int fromUid, String targetPkg, Uri uri, int modeFlags, int sourceUserId, int targetUserId) {
        targetUserId = this.mAmInternal.handleIncomingUser(Binder.getCallingPid(), Binder.getCallingUid(), targetUserId, false, 2, "grantUriPermissionFromOwner", null);
        Object object = this.mLock;
        synchronized (object) {
            UriPermissionOwner owner = UriPermissionOwner.fromExternalToken(token);
            if (owner == null) {
                throw new IllegalArgumentException("Unknown owner: " + token);
            }
            if (fromUid != Binder.getCallingUid() && Binder.getCallingUid() != Process.myUid()) {
                throw new SecurityException("nice try");
            }
            if (targetPkg == null) {
                throw new IllegalArgumentException("null target");
            }
            if (uri == null) {
                throw new IllegalArgumentException("null uri");
            }
            this.grantUriPermission(fromUid, targetPkg, new GrantUri(sourceUserId, uri, false), modeFlags, owner, targetUserId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ParceledListSlice<android.content.UriPermission> getUriPermissions(String packageName, boolean incoming, boolean persistedOnly) {
        this.enforceNotIsolatedCaller("getUriPermissions");
        Preconditions.checkNotNull(packageName, "packageName");
        int callingUid = Binder.getCallingUid();
        int callingUserId = UserHandle.getUserId(callingUid);
        IPackageManager pm = AppGlobals.getPackageManager();
        try {
            int packageUid = pm.getPackageUid(packageName, 786432, callingUserId);
            if (packageUid != callingUid) {
                throw new SecurityException("Package " + packageName + " does not belong to calling UID " + callingUid);
            }
        }
        catch (RemoteException e) {
            throw new SecurityException("Failed to verify package name ownership");
        }
        ArrayList<android.content.UriPermission> result = Lists.newArrayList();
        Object object = this.mLock;
        synchronized (object) {
            if (incoming) {
                ArrayMap<GrantUri, UriPermission> perms = this.mGrantedUriPermissions.get(callingUid);
                if (perms == null) {
                    Slog.w(TAG, "No permission grants found for " + packageName);
                } else {
                    for (int j = 0; j < perms.size(); ++j) {
                        UriPermission perm = perms.valueAt(j);
                        if (!packageName.equals(perm.targetPkg) || persistedOnly && perm.persistedModeFlags == 0) continue;
                        result.add(perm.buildPersistedPublicApiObject());
                    }
                }
            } else {
                int size = this.mGrantedUriPermissions.size();
                for (int i = 0; i < size; ++i) {
                    ArrayMap<GrantUri, UriPermission> perms = this.mGrantedUriPermissions.valueAt(i);
                    for (int j = 0; j < perms.size(); ++j) {
                        UriPermission perm = perms.valueAt(j);
                        if (!packageName.equals(perm.sourcePkg) || persistedOnly && perm.persistedModeFlags == 0) continue;
                        result.add(perm.buildPersistedPublicApiObject());
                    }
                }
            }
        }
        return new ParceledListSlice<android.content.UriPermission>(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ParceledListSlice<GrantedUriPermission> getGrantedUriPermissions(String packageName, int userId) {
        this.mAmInternal.enforceCallingPermission("android.permission.GET_APP_GRANTED_URI_PERMISSIONS", "getGrantedUriPermissions");
        ArrayList<GrantedUriPermission> result = new ArrayList<GrantedUriPermission>();
        Object object = this.mLock;
        synchronized (object) {
            int size = this.mGrantedUriPermissions.size();
            for (int i = 0; i < size; ++i) {
                ArrayMap<GrantUri, UriPermission> perms = this.mGrantedUriPermissions.valueAt(i);
                for (int j = 0; j < perms.size(); ++j) {
                    UriPermission perm = perms.valueAt(j);
                    if (packageName != null && !packageName.equals(perm.targetPkg) || perm.targetUserId != userId || perm.persistedModeFlags == 0) continue;
                    result.add(perm.buildGrantedUriPermission());
                }
            }
        }
        return new ParceledListSlice<GrantedUriPermission>(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void takePersistableUriPermission(Uri uri, int modeFlags, String toPackage, int userId) {
        int uid;
        if (toPackage != null) {
            this.mAmInternal.enforceCallingPermission("android.permission.FORCE_PERSISTABLE_URI_PERMISSIONS", "takePersistableUriPermission");
            uid = this.getPmInternal().getPackageUid(toPackage, 0, userId);
        } else {
            this.enforceNotIsolatedCaller("takePersistableUriPermission");
            uid = Binder.getCallingUid();
        }
        Preconditions.checkFlagsArgument(modeFlags, 3);
        Object object = this.mLock;
        synchronized (object) {
            boolean prefixValid;
            boolean persistChanged = false;
            GrantUri grantUri = new GrantUri(userId, uri, false);
            UriPermission exactPerm = this.findUriPermissionLocked(uid, grantUri);
            UriPermission prefixPerm = this.findUriPermissionLocked(uid, new GrantUri(userId, uri, true));
            boolean exactValid = exactPerm != null && (modeFlags & exactPerm.persistableModeFlags) == modeFlags;
            boolean bl = prefixValid = prefixPerm != null && (modeFlags & prefixPerm.persistableModeFlags) == modeFlags;
            if (!exactValid && !prefixValid) {
                throw new SecurityException("No persistable permission grants found for UID " + uid + " and Uri " + grantUri.toSafeString());
            }
            if (exactValid) {
                persistChanged |= exactPerm.takePersistableModes(modeFlags);
            }
            if (prefixValid) {
                persistChanged |= prefixPerm.takePersistableModes(modeFlags);
            }
            if (persistChanged |= this.maybePrunePersistedUriGrants(uid)) {
                this.schedulePersistUriGrants();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearGrantedUriPermissions(String packageName, int userId) {
        this.mAmInternal.enforceCallingPermission("android.permission.CLEAR_APP_GRANTED_URI_PERMISSIONS", "clearGrantedUriPermissions");
        Object object = this.mLock;
        synchronized (object) {
            this.removeUriPermissionsForPackage(packageName, userId, true, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releasePersistableUriPermission(Uri uri, int modeFlags, String toPackage, int userId) {
        int uid;
        if (toPackage != null) {
            this.mAmInternal.enforceCallingPermission("android.permission.FORCE_PERSISTABLE_URI_PERMISSIONS", "releasePersistableUriPermission");
            uid = this.getPmInternal().getPackageUid(toPackage, 0, userId);
        } else {
            this.enforceNotIsolatedCaller("releasePersistableUriPermission");
            uid = Binder.getCallingUid();
        }
        Preconditions.checkFlagsArgument(modeFlags, 3);
        Object object = this.mLock;
        synchronized (object) {
            boolean persistChanged = false;
            UriPermission exactPerm = this.findUriPermissionLocked(uid, new GrantUri(userId, uri, false));
            UriPermission prefixPerm = this.findUriPermissionLocked(uid, new GrantUri(userId, uri, true));
            if (exactPerm == null && prefixPerm == null && toPackage == null) {
                throw new SecurityException("No permission grants found for UID " + uid + " and Uri " + uri.toSafeString());
            }
            if (exactPerm != null) {
                persistChanged |= exactPerm.releasePersistableModes(modeFlags);
                this.removeUriPermissionIfNeeded(exactPerm);
            }
            if (prefixPerm != null) {
                persistChanged |= prefixPerm.releasePersistableModes(modeFlags);
                this.removeUriPermissionIfNeeded(prefixPerm);
            }
            if (persistChanged) {
                this.schedulePersistUriGrants();
            }
        }
    }

    void removeUriPermissionsForPackage(String packageName, int userHandle, boolean persistable, boolean targetOnly) {
        if (userHandle == -1 && packageName == null) {
            throw new IllegalArgumentException("Must narrow by either package or user");
        }
        boolean persistChanged = false;
        int N = this.mGrantedUriPermissions.size();
        for (int i = 0; i < N; ++i) {
            int targetUid = this.mGrantedUriPermissions.keyAt(i);
            ArrayMap<GrantUri, UriPermission> perms = this.mGrantedUriPermissions.valueAt(i);
            if (userHandle != -1 && userHandle != UserHandle.getUserId(targetUid)) continue;
            Iterator<UriPermission> it = perms.values().iterator();
            while (it.hasNext()) {
                UriPermission perm = it.next();
                if (packageName != null && (targetOnly || !perm.sourcePkg.equals(packageName)) && !perm.targetPkg.equals(packageName) || "downloads".equals(perm.uri.uri.getAuthority()) && !persistable) continue;
                persistChanged |= perm.revokeModes(persistable ? -1 : -65, true);
                if (perm.modeFlags != 0) continue;
                it.remove();
            }
            if (!perms.isEmpty()) continue;
            this.mGrantedUriPermissions.remove(targetUid);
            --N;
            --i;
        }
        if (persistChanged) {
            this.schedulePersistUriGrants();
        }
    }

    boolean checkAuthorityGrants(int callingUid, ProviderInfo cpi, int userId, boolean checkUser) {
        ArrayMap<GrantUri, UriPermission> perms = this.mGrantedUriPermissions.get(callingUid);
        if (perms != null) {
            for (int i = perms.size() - 1; i >= 0; --i) {
                GrantUri grantUri = perms.keyAt(i);
                if (grantUri.sourceUserId != userId && checkUser || !this.matchesProvider(grantUri.uri, cpi)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean matchesProvider(Uri uri, ProviderInfo cpi) {
        String uriAuth = uri.getAuthority();
        String cpiAuth = cpi.authority;
        if (cpiAuth.indexOf(59) == -1) {
            return cpiAuth.equals(uriAuth);
        }
        String[] cpiAuths = cpiAuth.split(";");
        int length = cpiAuths.length;
        for (int i = 0; i < length; ++i) {
            if (!cpiAuths[i].equals(uriAuth)) continue;
            return true;
        }
        return false;
    }

    private boolean maybePrunePersistedUriGrants(int uid) {
        ArrayMap<GrantUri, UriPermission> perms = this.mGrantedUriPermissions.get(uid);
        if (perms == null) {
            return false;
        }
        if (perms.size() < 128) {
            return false;
        }
        ArrayList<UriPermission> persisted = Lists.newArrayList();
        for (UriPermission perm : perms.values()) {
            if (perm.persistedModeFlags == 0) continue;
            persisted.add(perm);
        }
        int trimCount = persisted.size() - 128;
        if (trimCount <= 0) {
            return false;
        }
        Collections.sort(persisted, new UriPermission.PersistedTimeComparator());
        for (int i = 0; i < trimCount; ++i) {
            UriPermission perm = (UriPermission)persisted.get(i);
            perm.releasePersistableModes(-1);
            this.removeUriPermissionIfNeeded(perm);
        }
        return true;
    }

    NeededUriGrants checkGrantUriPermissionFromIntent(int callingUid, String targetPkg, Intent intent, int mode, NeededUriGrants needed, int targetUserId) {
        GrantUri grantUri;
        int targetUid;
        if (targetPkg == null) {
            throw new NullPointerException(ATTR_TARGET_PKG);
        }
        if (intent == null) {
            return null;
        }
        Uri data = intent.getData();
        ClipData clip = intent.getClipData();
        if (data == null && clip == null) {
            return null;
        }
        int contentUserHint = intent.getContentUserHint();
        if (contentUserHint == -2) {
            contentUserHint = UserHandle.getUserId(callingUid);
        }
        IPackageManager pm = AppGlobals.getPackageManager();
        if (needed != null) {
            targetUid = needed.targetUid;
        } else {
            try {
                targetUid = pm.getPackageUid(targetPkg, 0x10000000, targetUserId);
            }
            catch (RemoteException ex) {
                return null;
            }
            if (targetUid < 0) {
                return null;
            }
        }
        if (data != null && (targetUid = this.checkGrantUriPermission(callingUid, targetPkg, grantUri = GrantUri.resolve(contentUserHint, data), mode, targetUid)) > 0) {
            if (needed == null) {
                needed = new NeededUriGrants(targetPkg, targetUid, mode);
            }
            needed.add(grantUri);
        }
        if (clip != null) {
            for (int i = 0; i < clip.getItemCount(); ++i) {
                NeededUriGrants newNeeded;
                Uri uri = clip.getItemAt(i).getUri();
                if (uri != null) {
                    GrantUri grantUri2 = GrantUri.resolve(contentUserHint, uri);
                    targetUid = this.checkGrantUriPermission(callingUid, targetPkg, grantUri2, mode, targetUid);
                    if (targetUid <= 0) continue;
                    if (needed == null) {
                        needed = new NeededUriGrants(targetPkg, targetUid, mode);
                    }
                    needed.add(grantUri2);
                    continue;
                }
                Intent clipIntent = clip.getItemAt(i).getIntent();
                if (clipIntent == null || (newNeeded = this.checkGrantUriPermissionFromIntent(callingUid, targetPkg, clipIntent, mode, needed, targetUserId)) == null) continue;
                needed = newNeeded;
            }
        }
        return needed;
    }

    void grantUriPermissionFromIntent(int callingUid, String targetPkg, Intent intent, UriPermissionOwner owner, int targetUserId) {
        NeededUriGrants needed = this.checkGrantUriPermissionFromIntent(callingUid, targetPkg, intent, intent != null ? intent.getFlags() : 0, null, targetUserId);
        if (needed == null) {
            return;
        }
        this.grantUriPermissionUncheckedFromIntent(needed, owner);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void readGrantedUriPermissions() {
        long now = System.currentTimeMillis();
        FileInputStream fis = null;
        try {
            int type;
            fis = this.mGrantFile.openRead();
            XmlPullParser in = Xml.newPullParser();
            in.setInput(fis, StandardCharsets.UTF_8.name());
            while ((type = in.next()) != 1) {
                int targetUserId;
                int sourceUserId;
                String tag = in.getName();
                if (type != 2 || !TAG_URI_GRANT.equals(tag)) continue;
                int userHandle = XmlUtils.readIntAttribute(in, ATTR_USER_HANDLE, -10000);
                if (userHandle != -10000) {
                    sourceUserId = userHandle;
                    targetUserId = userHandle;
                } else {
                    sourceUserId = XmlUtils.readIntAttribute(in, ATTR_SOURCE_USER_ID);
                    targetUserId = XmlUtils.readIntAttribute(in, ATTR_TARGET_USER_ID);
                }
                String sourcePkg = in.getAttributeValue(null, ATTR_SOURCE_PKG);
                String targetPkg = in.getAttributeValue(null, ATTR_TARGET_PKG);
                Uri uri = Uri.parse(in.getAttributeValue(null, ATTR_URI));
                boolean prefix = XmlUtils.readBooleanAttribute(in, ATTR_PREFIX);
                int modeFlags = XmlUtils.readIntAttribute(in, ATTR_MODE_FLAGS);
                long createdTime = XmlUtils.readLongAttribute(in, ATTR_CREATED_TIME, now);
                ProviderInfo pi = this.getProviderInfo(uri.getAuthority(), sourceUserId, 786432);
                if (pi != null && sourcePkg.equals(pi.packageName)) {
                    int targetUid = -1;
                    try {
                        targetUid = AppGlobals.getPackageManager().getPackageUid(targetPkg, 8192, targetUserId);
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                    if (targetUid == -1) continue;
                    UriPermission perm = this.findOrCreateUriPermission(sourcePkg, targetPkg, targetUid, new GrantUri(sourceUserId, uri, prefix));
                    perm.initPersistedModes(modeFlags, createdTime);
                    continue;
                }
                Slog.w(TAG, "Persisted grant for " + uri + " had source " + sourcePkg + " but instead found " + pi);
            }
        }
        catch (FileNotFoundException in) {
        }
        catch (IOException e) {
            Slog.wtf(TAG, "Failed reading Uri grants", e);
        }
        catch (XmlPullParserException e) {
            Slog.wtf(TAG, "Failed reading Uri grants", e);
        }
        finally {
            IoUtils.closeQuietly(fis);
        }
    }

    private UriPermission findOrCreateUriPermission(String sourcePkg, String targetPkg, int targetUid, GrantUri grantUri) {
        UriPermission perm;
        ArrayMap<GrantUri, UriPermission> targetUris = this.mGrantedUriPermissions.get(targetUid);
        if (targetUris == null) {
            targetUris = Maps.newArrayMap();
            this.mGrantedUriPermissions.put(targetUid, targetUris);
        }
        if ((perm = targetUris.get(grantUri)) == null) {
            perm = new UriPermission(sourcePkg, targetPkg, targetUid, grantUri);
            targetUris.put(grantUri, perm);
        }
        return perm;
    }

    private void grantUriPermissionUnchecked(int targetUid, String targetPkg, GrantUri grantUri, int modeFlags, UriPermissionOwner owner) {
        if (!Intent.isAccessUriMode(modeFlags)) {
            return;
        }
        String authority = grantUri.uri.getAuthority();
        ProviderInfo pi = this.getProviderInfo(authority, grantUri.sourceUserId, 0x10000000);
        if (pi == null) {
            Slog.w(TAG, "No content provider found for grant: " + grantUri.toSafeString());
            return;
        }
        if ((modeFlags & 0x80) != 0) {
            grantUri.prefix = true;
        }
        UriPermission perm = this.findOrCreateUriPermission(pi.packageName, targetPkg, targetUid, grantUri);
        perm.grantModes(modeFlags, owner);
    }

    void grantUriPermissionUncheckedFromIntent(NeededUriGrants needed, UriPermissionOwner owner) {
        if (needed == null) {
            return;
        }
        for (int i = 0; i < needed.size(); ++i) {
            GrantUri grantUri = (GrantUri)needed.get(i);
            this.grantUriPermissionUnchecked(needed.targetUid, needed.targetPkg, grantUri, needed.flags, owner);
        }
    }

    void grantUriPermission(int callingUid, String targetPkg, GrantUri grantUri, int modeFlags, UriPermissionOwner owner, int targetUserId) {
        int targetUid;
        if (targetPkg == null) {
            throw new NullPointerException(ATTR_TARGET_PKG);
        }
        IPackageManager pm = AppGlobals.getPackageManager();
        try {
            targetUid = pm.getPackageUid(targetPkg, 0x10000000, targetUserId);
        }
        catch (RemoteException ex) {
            return;
        }
        targetUid = this.checkGrantUriPermission(callingUid, targetPkg, grantUri, modeFlags, targetUid);
        if (targetUid < 0) {
            return;
        }
        this.grantUriPermissionUnchecked(targetUid, targetPkg, grantUri, modeFlags, owner);
    }

    void revokeUriPermission(String targetPackage, int callingUid, GrantUri grantUri, int modeFlags) {
        IPackageManager pm = AppGlobals.getPackageManager();
        String authority = grantUri.uri.getAuthority();
        ProviderInfo pi = this.getProviderInfo(authority, grantUri.sourceUserId, 786432);
        if (pi == null) {
            Slog.w(TAG, "No content provider found for permission revoke: " + grantUri.toSafeString());
            return;
        }
        if (!this.checkHoldingPermissions(pm, pi, grantUri, callingUid, modeFlags)) {
            ArrayMap<GrantUri, UriPermission> perms = this.mGrantedUriPermissions.get(callingUid);
            if (perms != null) {
                boolean persistChanged = false;
                for (int i = perms.size() - 1; i >= 0; --i) {
                    UriPermission perm = perms.valueAt(i);
                    if (targetPackage != null && !targetPackage.equals(perm.targetPkg) || perm.uri.sourceUserId != grantUri.sourceUserId || !perm.uri.uri.isPathPrefixMatch(grantUri.uri)) continue;
                    persistChanged |= perm.revokeModes(modeFlags | 0x40, false);
                    if (perm.modeFlags != 0) continue;
                    perms.removeAt(i);
                }
                if (perms.isEmpty()) {
                    this.mGrantedUriPermissions.remove(callingUid);
                }
                if (persistChanged) {
                    this.schedulePersistUriGrants();
                }
            }
            return;
        }
        boolean persistChanged = false;
        for (int i = this.mGrantedUriPermissions.size() - 1; i >= 0; --i) {
            int targetUid = this.mGrantedUriPermissions.keyAt(i);
            ArrayMap<GrantUri, UriPermission> perms = this.mGrantedUriPermissions.valueAt(i);
            for (int j = perms.size() - 1; j >= 0; --j) {
                UriPermission perm = perms.valueAt(j);
                if (targetPackage != null && !targetPackage.equals(perm.targetPkg) || perm.uri.sourceUserId != grantUri.sourceUserId || !perm.uri.uri.isPathPrefixMatch(grantUri.uri)) continue;
                persistChanged |= perm.revokeModes(modeFlags | 0x40, targetPackage == null);
                if (perm.modeFlags != 0) continue;
                perms.removeAt(j);
            }
            if (!perms.isEmpty()) continue;
            this.mGrantedUriPermissions.removeAt(i);
        }
        if (persistChanged) {
            this.schedulePersistUriGrants();
        }
    }

    private boolean checkHoldingPermissions(IPackageManager pm, ProviderInfo pi, GrantUri grantUri, int uid, int modeFlags) {
        if (UserHandle.getUserId(uid) != grantUri.sourceUserId && ActivityManager.checkComponentPermission("android.permission.INTERACT_ACROSS_USERS", uid, -1, true) != 0) {
            return false;
        }
        return this.checkHoldingPermissionsInternal(pm, pi, grantUri, uid, modeFlags, true);
    }

    private boolean checkHoldingPermissionsInternal(IPackageManager pm, ProviderInfo pi, GrantUri grantUri, int uid, int modeFlags, boolean considerUidPermissions) {
        if (pi.applicationInfo.uid == uid) {
            return true;
        }
        if (!pi.exported) {
            return false;
        }
        boolean readMet = (modeFlags & 1) == 0;
        boolean writeMet = (modeFlags & 2) == 0;
        try {
            if (!readMet && pi.readPermission != null && considerUidPermissions && pm.checkUidPermission(pi.readPermission, uid) == 0) {
                readMet = true;
            }
            if (!writeMet && pi.writePermission != null && considerUidPermissions && pm.checkUidPermission(pi.writePermission, uid) == 0) {
                writeMet = true;
            }
            boolean allowDefaultRead = pi.readPermission == null;
            boolean allowDefaultWrite = pi.writePermission == null;
            PathPermission[] pps = pi.pathPermissions;
            if (pps != null) {
                String path = grantUri.uri.getPath();
                int i = pps.length;
                while (!(i <= 0 || readMet && writeMet)) {
                    String ppwperm;
                    String pprperm;
                    PathPermission pp;
                    if (!(pp = pps[--i]).match(path)) continue;
                    if (!readMet && (pprperm = pp.getReadPermission()) != null) {
                        if (considerUidPermissions && pm.checkUidPermission(pprperm, uid) == 0) {
                            readMet = true;
                        } else {
                            allowDefaultRead = false;
                        }
                    }
                    if (writeMet || (ppwperm = pp.getWritePermission()) == null) continue;
                    if (considerUidPermissions && pm.checkUidPermission(ppwperm, uid) == 0) {
                        writeMet = true;
                        continue;
                    }
                    allowDefaultWrite = false;
                }
            }
            if (allowDefaultRead) {
                readMet = true;
            }
            if (allowDefaultWrite) {
                writeMet = true;
            }
        }
        catch (RemoteException e) {
            return false;
        }
        return readMet && writeMet;
    }

    private void removeUriPermissionIfNeeded(UriPermission perm) {
        if (perm.modeFlags != 0) {
            return;
        }
        ArrayMap<GrantUri, UriPermission> perms = this.mGrantedUriPermissions.get(perm.targetUid);
        if (perms == null) {
            return;
        }
        perms.remove(perm.uri);
        if (perms.isEmpty()) {
            this.mGrantedUriPermissions.remove(perm.targetUid);
        }
    }

    private UriPermission findUriPermissionLocked(int targetUid, GrantUri grantUri) {
        ArrayMap<GrantUri, UriPermission> targetUris = this.mGrantedUriPermissions.get(targetUid);
        if (targetUris != null) {
            return targetUris.get(grantUri);
        }
        return null;
    }

    private void schedulePersistUriGrants() {
        if (!this.mH.hasMessages(1)) {
            this.mH.sendMessageDelayed(this.mH.obtainMessage(1), 10000L);
        }
    }

    private void enforceNotIsolatedCaller(String caller) {
        if (UserHandle.isIsolated(Binder.getCallingUid())) {
            throw new SecurityException("Isolated process not allowed to call " + caller);
        }
    }

    private ProviderInfo getProviderInfo(String authority, int userHandle, int pmFlags) {
        ProviderInfo pi = null;
        try {
            pi = AppGlobals.getPackageManager().resolveContentProvider(authority, 0x800 | pmFlags, userHandle);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return pi;
    }

    int checkGrantUriPermission(int callingUid, String targetPkg, GrantUri grantUri, int modeFlags, int lastTargetUid) {
        boolean specialCrossUserGrant;
        int N;
        if (!Intent.isAccessUriMode(modeFlags)) {
            return -1;
        }
        if (targetPkg != null) {
            // empty if block
        }
        IPackageManager pm = AppGlobals.getPackageManager();
        if (!"content".equals(grantUri.uri.getScheme())) {
            return -1;
        }
        int callingAppId = UserHandle.getAppId(callingUid);
        if (!(callingAppId != 1000 && callingAppId != 0 || "com.android.settings.files".equals(grantUri.uri.getAuthority()) || "com.android.settings.module_licenses".equals(grantUri.uri.getAuthority()))) {
            Slog.w(TAG, "For security reasons, the system cannot issue a Uri permission grant to " + grantUri + "; use startActivityAsCaller() instead");
            return -1;
        }
        String authority = grantUri.uri.getAuthority();
        ProviderInfo pi = this.getProviderInfo(authority, grantUri.sourceUserId, 0x10000000);
        if (pi == null) {
            Slog.w(TAG, "No content provider found for permission check: " + grantUri.uri.toSafeString());
            return -1;
        }
        int targetUid = lastTargetUid;
        if (targetUid < 0 && targetPkg != null) {
            try {
                targetUid = pm.getPackageUid(targetPkg, 0x10000000, UserHandle.getUserId(callingUid));
                if (targetUid < 0) {
                    return -1;
                }
            }
            catch (RemoteException ex) {
                return -1;
            }
        }
        int allowedResult = (modeFlags & 0x40) != 0 || pi.forceUriPermissions ? targetUid : -1;
        if (targetUid >= 0) {
            if (this.checkHoldingPermissions(pm, pi, grantUri, targetUid, modeFlags)) {
                return allowedResult;
            }
        } else {
            boolean allowed = pi.exported;
            if ((modeFlags & 1) != 0 && pi.readPermission != null) {
                allowed = false;
            }
            if ((modeFlags & 2) != 0 && pi.writePermission != null) {
                allowed = false;
            }
            if (pi.pathPermissions != null) {
                N = pi.pathPermissions.length;
                for (int i = 0; i < N; ++i) {
                    if (pi.pathPermissions[i] == null || !pi.pathPermissions[i].match(grantUri.uri.getPath())) continue;
                    if ((modeFlags & 1) != 0 && pi.pathPermissions[i].getReadPermission() != null) {
                        allowed = false;
                    }
                    if ((modeFlags & 2) == 0 || pi.pathPermissions[i].getWritePermission() == null) break;
                    allowed = false;
                    break;
                }
            }
            if (allowed) {
                return allowedResult;
            }
        }
        boolean bl = specialCrossUserGrant = targetUid >= 0 && UserHandle.getUserId(targetUid) != grantUri.sourceUserId && this.checkHoldingPermissionsInternal(pm, pi, grantUri, callingUid, modeFlags, false);
        if (!specialCrossUserGrant) {
            if (!pi.grantUriPermissions) {
                throw new SecurityException("Provider " + pi.packageName + "/" + pi.name + " does not allow granting of Uri permissions (uri " + grantUri + ")");
            }
            if (pi.uriPermissionPatterns != null) {
                N = pi.uriPermissionPatterns.length;
                boolean allowed = false;
                for (int i = 0; i < N; ++i) {
                    if (pi.uriPermissionPatterns[i] == null || !pi.uriPermissionPatterns[i].match(grantUri.uri.getPath())) continue;
                    allowed = true;
                    break;
                }
                if (!allowed) {
                    throw new SecurityException("Provider " + pi.packageName + "/" + pi.name + " does not allow granting of permission to path of Uri " + grantUri);
                }
            }
        }
        if (!this.checkHoldingPermissions(pm, pi, grantUri, callingUid, modeFlags) && !this.checkUriPermission(grantUri, callingUid, modeFlags)) {
            if ("android.permission.MANAGE_DOCUMENTS".equals(pi.readPermission)) {
                throw new SecurityException("UID " + callingUid + " does not have permission to " + grantUri + "; you could obtain access using ACTION_OPEN_DOCUMENT or related APIs");
            }
            throw new SecurityException("UID " + callingUid + " does not have permission to " + grantUri);
        }
        return targetUid;
    }

    int checkGrantUriPermission(int callingUid, String targetPkg, Uri uri, int modeFlags, int userId) {
        return this.checkGrantUriPermission(callingUid, targetPkg, new GrantUri(userId, uri, false), modeFlags, -1);
    }

    boolean checkUriPermission(GrantUri grantUri, int uid, int modeFlags) {
        int minStrength;
        boolean persistable = (modeFlags & 0x40) != 0;
        int n = minStrength = persistable ? 3 : 1;
        if (uid == 0) {
            return true;
        }
        ArrayMap<GrantUri, UriPermission> perms = this.mGrantedUriPermissions.get(uid);
        if (perms == null) {
            return false;
        }
        UriPermission exactPerm = perms.get(grantUri);
        if (exactPerm != null && exactPerm.getStrength(modeFlags) >= minStrength) {
            return true;
        }
        int N = perms.size();
        for (int i = 0; i < N; ++i) {
            UriPermission perm = perms.valueAt(i);
            if (!perm.uri.prefix || !grantUri.uri.isPathPrefixMatch(perm.uri.uri) || perm.getStrength(modeFlags) < minStrength) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeGrantedUriPermissions() {
        block8: {
            long startTime = SystemClock.uptimeMillis();
            ArrayList<UriPermission.Snapshot> persist = Lists.newArrayList();
            UriGrantsManagerService uriGrantsManagerService = this;
            synchronized (uriGrantsManagerService) {
                int size = this.mGrantedUriPermissions.size();
                for (int i = 0; i < size; ++i) {
                    ArrayMap<GrantUri, UriPermission> perms = this.mGrantedUriPermissions.valueAt(i);
                    for (UriPermission perm : perms.values()) {
                        if (perm.persistedModeFlags == 0) continue;
                        persist.add(perm.snapshot());
                    }
                }
            }
            FileOutputStream fos = null;
            try {
                fos = this.mGrantFile.startWrite(startTime);
                FastXmlSerializer out = new FastXmlSerializer();
                out.setOutput(fos, StandardCharsets.UTF_8.name());
                out.startDocument(null, true);
                out.startTag(null, TAG_URI_GRANTS);
                for (UriPermission.Snapshot perm : persist) {
                    out.startTag(null, TAG_URI_GRANT);
                    XmlUtils.writeIntAttribute(out, ATTR_SOURCE_USER_ID, perm.uri.sourceUserId);
                    XmlUtils.writeIntAttribute(out, ATTR_TARGET_USER_ID, perm.targetUserId);
                    out.attribute(null, ATTR_SOURCE_PKG, perm.sourcePkg);
                    out.attribute(null, ATTR_TARGET_PKG, perm.targetPkg);
                    out.attribute(null, ATTR_URI, String.valueOf(perm.uri.uri));
                    XmlUtils.writeBooleanAttribute(out, ATTR_PREFIX, perm.uri.prefix);
                    XmlUtils.writeIntAttribute(out, ATTR_MODE_FLAGS, perm.persistedModeFlags);
                    XmlUtils.writeLongAttribute(out, ATTR_CREATED_TIME, perm.persistedCreateTime);
                    out.endTag(null, TAG_URI_GRANT);
                }
                out.endTag(null, TAG_URI_GRANTS);
                out.endDocument();
                this.mGrantFile.finishWrite(fos);
            }
            catch (IOException e) {
                if (fos == null) break block8;
                this.mGrantFile.failWrite(fos);
            }
        }
    }

    private PackageManagerInternal getPmInternal() {
        if (this.mPmInternal == null) {
            this.mPmInternal = LocalServices.getService(PackageManagerInternal.class);
        }
        return this.mPmInternal;
    }

    final class LocalService
    implements UriGrantsManagerInternal {
        LocalService() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeUriPermissionIfNeeded(UriPermission perm) {
            Object object = UriGrantsManagerService.this.mLock;
            synchronized (object) {
                UriGrantsManagerService.this.removeUriPermissionIfNeeded(perm);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void grantUriPermission(int callingUid, String targetPkg, GrantUri grantUri, int modeFlags, UriPermissionOwner owner, int targetUserId) {
            Object object = UriGrantsManagerService.this.mLock;
            synchronized (object) {
                UriGrantsManagerService.this.grantUriPermission(callingUid, targetPkg, grantUri, modeFlags, owner, targetUserId);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void revokeUriPermission(String targetPackage, int callingUid, GrantUri grantUri, int modeFlags) {
            Object object = UriGrantsManagerService.this.mLock;
            synchronized (object) {
                UriGrantsManagerService.this.revokeUriPermission(targetPackage, callingUid, grantUri, modeFlags);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean checkUriPermission(GrantUri grantUri, int uid, int modeFlags) {
            Object object = UriGrantsManagerService.this.mLock;
            synchronized (object) {
                return UriGrantsManagerService.this.checkUriPermission(grantUri, uid, modeFlags);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int checkGrantUriPermission(int callingUid, String targetPkg, GrantUri uri, int modeFlags, int userId) {
            Object object = UriGrantsManagerService.this.mLock;
            synchronized (object) {
                return UriGrantsManagerService.this.checkGrantUriPermission(callingUid, targetPkg, uri, modeFlags, userId);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int checkGrantUriPermission(int callingUid, String targetPkg, Uri uri, int modeFlags, int userId) {
            UriGrantsManagerService.this.enforceNotIsolatedCaller("checkGrantUriPermission");
            Object object = UriGrantsManagerService.this.mLock;
            synchronized (object) {
                return UriGrantsManagerService.this.checkGrantUriPermission(callingUid, targetPkg, uri, modeFlags, userId);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public NeededUriGrants checkGrantUriPermissionFromIntent(int callingUid, String targetPkg, Intent intent, int mode, NeededUriGrants needed, int targetUserId) {
            Object object = UriGrantsManagerService.this.mLock;
            synchronized (object) {
                return UriGrantsManagerService.this.checkGrantUriPermissionFromIntent(callingUid, targetPkg, intent, mode, needed, targetUserId);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void grantUriPermissionFromIntent(int callingUid, String targetPkg, Intent intent, int targetUserId) {
            Object object = UriGrantsManagerService.this.mLock;
            synchronized (object) {
                UriGrantsManagerService.this.grantUriPermissionFromIntent(callingUid, targetPkg, intent, null, targetUserId);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void grantUriPermissionFromIntent(int callingUid, String targetPkg, Intent intent, UriPermissionOwner owner, int targetUserId) {
            Object object = UriGrantsManagerService.this.mLock;
            synchronized (object) {
                UriGrantsManagerService.this.grantUriPermissionFromIntent(callingUid, targetPkg, intent, owner, targetUserId);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void grantUriPermissionUncheckedFromIntent(NeededUriGrants needed, UriPermissionOwner owner) {
            Object object = UriGrantsManagerService.this.mLock;
            synchronized (object) {
                UriGrantsManagerService.this.grantUriPermissionUncheckedFromIntent(needed, owner);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onSystemReady() {
            Object object = UriGrantsManagerService.this.mLock;
            synchronized (object) {
                UriGrantsManagerService.this.readGrantedUriPermissions();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onActivityManagerInternalAdded() {
            Object object = UriGrantsManagerService.this.mLock;
            synchronized (object) {
                UriGrantsManagerService.this.onActivityManagerInternalAdded();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IBinder newUriPermissionOwner(String name) {
            UriGrantsManagerService.this.enforceNotIsolatedCaller("newUriPermissionOwner");
            Object object = UriGrantsManagerService.this.mLock;
            synchronized (object) {
                UriPermissionOwner owner = new UriPermissionOwner(this, name);
                return owner.getExternalToken();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeUriPermissionsForPackage(String packageName, int userHandle, boolean persistable, boolean targetOnly) {
            Object object = UriGrantsManagerService.this.mLock;
            synchronized (object) {
                UriGrantsManagerService.this.removeUriPermissionsForPackage(packageName, userHandle, persistable, targetOnly);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void revokeUriPermissionFromOwner(IBinder token, Uri uri, int mode, int userId) {
            Object object = UriGrantsManagerService.this.mLock;
            synchronized (object) {
                UriPermissionOwner owner = UriPermissionOwner.fromExternalToken(token);
                if (owner == null) {
                    throw new IllegalArgumentException("Unknown owner: " + token);
                }
                if (uri == null) {
                    owner.removeUriPermissions(mode);
                } else {
                    boolean prefix = (mode & 0x80) != 0;
                    owner.removeUriPermission(new GrantUri(userId, uri, prefix), mode);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean checkAuthorityGrants(int callingUid, ProviderInfo cpi, int userId, boolean checkUser) {
            Object object = UriGrantsManagerService.this.mLock;
            synchronized (object) {
                return UriGrantsManagerService.this.checkAuthorityGrants(callingUid, cpi, userId, checkUser);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void dump(PrintWriter pw, boolean dumpAll, String dumpPackage) {
            Object object = UriGrantsManagerService.this.mLock;
            synchronized (object) {
                boolean needSep = false;
                boolean printedAnything = false;
                if (UriGrantsManagerService.this.mGrantedUriPermissions.size() > 0) {
                    boolean printed = false;
                    int dumpUid = -2;
                    if (dumpPackage != null) {
                        try {
                            dumpUid = UriGrantsManagerService.this.mContext.getPackageManager().getPackageUidAsUser(dumpPackage, 0x400000, 0);
                        }
                        catch (PackageManager.NameNotFoundException e) {
                            dumpUid = -1;
                        }
                    }
                    for (int i = 0; i < UriGrantsManagerService.this.mGrantedUriPermissions.size(); ++i) {
                        int uid = UriGrantsManagerService.this.mGrantedUriPermissions.keyAt(i);
                        if (dumpUid >= -1 && UserHandle.getAppId(uid) != dumpUid) continue;
                        ArrayMap perms = (ArrayMap)UriGrantsManagerService.this.mGrantedUriPermissions.valueAt(i);
                        if (!printed) {
                            if (needSep) {
                                pw.println();
                            }
                            needSep = true;
                            pw.println("  Granted Uri Permissions:");
                            printed = true;
                            printedAnything = true;
                        }
                        pw.print("  * UID ");
                        pw.print(uid);
                        pw.println(" holds:");
                        for (UriPermission perm : perms.values()) {
                            pw.print("    ");
                            pw.println(perm);
                            if (!dumpAll) continue;
                            perm.dump(pw, "      ");
                        }
                    }
                }
                if (!printedAnything) {
                    pw.println("  (nothing)");
                }
            }
        }
    }

    final class H
    extends Handler {
        static final int PERSIST_URI_GRANTS_MSG = 1;

        public H(Looper looper) {
            super(looper, null, true);
        }

        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    UriGrantsManagerService.this.writeGrantedUriPermissions();
                }
            }
        }
    }

    public static final class Lifecycle
    extends SystemService {
        private final UriGrantsManagerService mService;

        public Lifecycle(Context context) {
            super(context);
            this.mService = new UriGrantsManagerService(context);
        }

        @Override
        public void onStart() {
            this.publishBinderService("uri_grants", this.mService);
            this.mService.start();
        }

        public UriGrantsManagerService getService() {
            return this.mService;
        }
    }
}

