/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.uri;

import android.os.Binder;
import android.os.IBinder;
import android.util.ArraySet;
import android.util.proto.ProtoOutputStream;
import com.android.server.uri.GrantUri;
import com.android.server.uri.UriGrantsManagerInternal;
import com.android.server.uri.UriPermission;
import com.google.android.collect.Sets;
import java.io.PrintWriter;
import java.util.Iterator;

public class UriPermissionOwner {
    private final UriGrantsManagerInternal mService;
    private final Object mOwner;
    private Binder externalToken;
    private ArraySet<UriPermission> mReadPerms;
    private ArraySet<UriPermission> mWritePerms;

    public UriPermissionOwner(UriGrantsManagerInternal service, Object owner) {
        this.mService = service;
        this.mOwner = owner;
    }

    public Binder getExternalToken() {
        if (this.externalToken == null) {
            this.externalToken = new ExternalToken();
        }
        return this.externalToken;
    }

    static UriPermissionOwner fromExternalToken(IBinder token) {
        if (token instanceof ExternalToken) {
            return ((ExternalToken)token).getOwner();
        }
        return null;
    }

    public void removeUriPermissions() {
        this.removeUriPermissions(3);
    }

    void removeUriPermissions(int mode) {
        this.removeUriPermission(null, mode);
    }

    void removeUriPermission(GrantUri grantUri, int mode) {
        UriPermission perm;
        Iterator<UriPermission> it;
        if ((mode & 1) != 0 && this.mReadPerms != null) {
            it = this.mReadPerms.iterator();
            while (it.hasNext()) {
                perm = it.next();
                if (grantUri != null && !grantUri.equals(perm.uri)) continue;
                perm.removeReadOwner(this);
                this.mService.removeUriPermissionIfNeeded(perm);
                it.remove();
            }
            if (this.mReadPerms.isEmpty()) {
                this.mReadPerms = null;
            }
        }
        if ((mode & 2) != 0 && this.mWritePerms != null) {
            it = this.mWritePerms.iterator();
            while (it.hasNext()) {
                perm = it.next();
                if (grantUri != null && !grantUri.equals(perm.uri)) continue;
                perm.removeWriteOwner(this);
                this.mService.removeUriPermissionIfNeeded(perm);
                it.remove();
            }
            if (this.mWritePerms.isEmpty()) {
                this.mWritePerms = null;
            }
        }
    }

    public void addReadPermission(UriPermission perm) {
        if (this.mReadPerms == null) {
            this.mReadPerms = Sets.newArraySet();
        }
        this.mReadPerms.add(perm);
    }

    public void addWritePermission(UriPermission perm) {
        if (this.mWritePerms == null) {
            this.mWritePerms = Sets.newArraySet();
        }
        this.mWritePerms.add(perm);
    }

    public void removeReadPermission(UriPermission perm) {
        this.mReadPerms.remove(perm);
        if (this.mReadPerms.isEmpty()) {
            this.mReadPerms = null;
        }
    }

    public void removeWritePermission(UriPermission perm) {
        this.mWritePerms.remove(perm);
        if (this.mWritePerms.isEmpty()) {
            this.mWritePerms = null;
        }
    }

    public void dump(PrintWriter pw, String prefix) {
        if (this.mReadPerms != null) {
            pw.print(prefix);
            pw.print("readUriPermissions=");
            pw.println(this.mReadPerms);
        }
        if (this.mWritePerms != null) {
            pw.print(prefix);
            pw.print("writeUriPermissions=");
            pw.println(this.mWritePerms);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeToProto(ProtoOutputStream proto, long fieldId) {
        ArraySet<UriPermission> arraySet;
        long token = proto.start(fieldId);
        proto.write(0x10900000001L, this.mOwner.toString());
        if (this.mReadPerms != null) {
            arraySet = this.mReadPerms;
            synchronized (arraySet) {
                for (UriPermission p : this.mReadPerms) {
                    p.uri.writeToProto(proto, 0x20B00000002L);
                }
            }
        }
        if (this.mWritePerms != null) {
            arraySet = this.mWritePerms;
            synchronized (arraySet) {
                for (UriPermission p : this.mWritePerms) {
                    p.uri.writeToProto(proto, 2246267895811L);
                }
            }
        }
        proto.end(token);
    }

    public String toString() {
        return this.mOwner.toString();
    }

    class ExternalToken
    extends Binder {
        ExternalToken() {
        }

        UriPermissionOwner getOwner() {
            return UriPermissionOwner.this;
        }
    }
}

