/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.usage;

import android.app.ActivityManager;
import android.app.AppGlobals;
import android.app.usage.AppStandbyInfo;
import android.app.usage.UsageEvents;
import android.app.usage.UsageStatsManagerInternal;
import android.appwidget.AppWidgetManager;
import android.content.BroadcastReceiver;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.PackageManagerInternal;
import android.content.pm.ParceledListSlice;
import android.database.ContentObserver;
import android.hardware.display.DisplayManager;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkInfo;
import android.net.NetworkRequest;
import android.net.NetworkScoreManager;
import android.os.BatteryManager;
import android.os.Environment;
import android.os.Handler;
import android.os.IDeviceIdleController;
import android.os.Looper;
import android.os.Message;
import android.os.PowerManager;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemClock;
import android.os.UserHandle;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import android.util.ArraySet;
import android.util.KeyValueListParser;
import android.util.Slog;
import android.util.SparseArray;
import android.util.SparseIntArray;
import android.util.TimeUtils;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.app.IBatteryStats;
import com.android.internal.os.SomeArgs;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.ConcurrentUtils;
import com.android.internal.util.IndentingPrintWriter;
import com.android.server.LocalServices;
import com.android.server.usage.AppIdleHistory;
import java.io.File;
import java.io.PrintWriter;
import java.time.Duration;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CountDownLatch;

public class AppStandbyController {
    private static final String TAG = "AppStandbyController";
    static final boolean DEBUG = false;
    static final boolean COMPRESS_TIME = false;
    private static final long ONE_MINUTE = 60000L;
    private static final long ONE_HOUR = 3600000L;
    private static final long ONE_DAY = 86400000L;
    static final long[] SCREEN_TIME_THRESHOLDS = new long[]{0L, 0L, 3600000L, 0x6DDD00L};
    static final long[] ELAPSED_TIME_THRESHOLDS = new long[]{0L, 43200000L, 86400000L, 172800000L};
    static final int[] THRESHOLD_BUCKETS = new int[]{10, 20, 30, 40};
    private static final long DEFAULT_PREDICTION_TIMEOUT = 43200000L;
    private static final long WAIT_FOR_ADMIN_DATA_TIMEOUT_MS = 10000L;
    private final Object mAppIdleLock = new Lock();
    @GuardedBy(value={"mAppIdleLock"})
    private AppIdleHistory mAppIdleHistory;
    @GuardedBy(value={"mPackageAccessListeners"})
    private ArrayList<UsageStatsManagerInternal.AppIdleStateChangeListener> mPackageAccessListeners = new ArrayList();
    @GuardedBy(value={"mAppIdleLock"})
    private boolean mHaveCarrierPrivilegedApps;
    @GuardedBy(value={"mAppIdleLock"})
    private List<String> mCarrierPrivilegedApps;
    @GuardedBy(value={"mActiveAdminApps"})
    private final SparseArray<Set<String>> mActiveAdminApps = new SparseArray();
    private final CountDownLatch mAdminDataAvailableLatch = new CountDownLatch(1);
    static final int MSG_INFORM_LISTENERS = 3;
    static final int MSG_FORCE_IDLE_STATE = 4;
    static final int MSG_CHECK_IDLE_STATES = 5;
    static final int MSG_CHECK_PAROLE_TIMEOUT = 6;
    static final int MSG_PAROLE_END_TIMEOUT = 7;
    static final int MSG_REPORT_CONTENT_PROVIDER_USAGE = 8;
    static final int MSG_PAROLE_STATE_CHANGED = 9;
    static final int MSG_ONE_TIME_CHECK_IDLE_STATES = 10;
    static final int MSG_CHECK_PACKAGE_IDLE_STATE = 11;
    static final int MSG_REPORT_SYNC_SCHEDULED = 12;
    static final int MSG_REPORT_EXEMPTED_SYNC_START = 13;
    static final int MSG_UPDATE_STABLE_CHARGING = 14;
    long mCheckIdleIntervalMillis;
    long mAppIdleParoleIntervalMillis;
    long mAppIdleParoleWindowMillis;
    long mAppIdleParoleDurationMillis;
    long[] mAppStandbyScreenThresholds = SCREEN_TIME_THRESHOLDS;
    long[] mAppStandbyElapsedThresholds = ELAPSED_TIME_THRESHOLDS;
    long mStrongUsageTimeoutMillis;
    long mNotificationSeenTimeoutMillis;
    long mSystemUpdateUsageTimeoutMillis;
    long mPredictionTimeoutMillis;
    long mSyncAdapterTimeoutMillis;
    long mExemptedSyncScheduledNonDozeTimeoutMillis;
    long mExemptedSyncScheduledDozeTimeoutMillis;
    long mExemptedSyncStartTimeoutMillis;
    long mUnexemptedSyncScheduledTimeoutMillis;
    long mSystemInteractionTimeoutMillis;
    long mInitialForegroundServiceStartTimeoutMillis;
    long mStableChargingThresholdMillis;
    volatile boolean mAppIdleEnabled;
    boolean mAppIdleTempParoled;
    boolean mCharging;
    boolean mChargingStable;
    private long mLastAppIdleParoledTime;
    private boolean mSystemServicesReady = false;
    private boolean mPendingInitializeDefaults;
    private final DeviceStateReceiver mDeviceStateReceiver;
    private volatile boolean mPendingOneTimeCheckIdleStates;
    private final AppStandbyHandler mHandler;
    private final Context mContext;
    private AppWidgetManager mAppWidgetManager;
    private ConnectivityManager mConnectivityManager;
    private PowerManager mPowerManager;
    private PackageManager mPackageManager;
    Injector mInjector;
    static final ArrayList<StandbyUpdateRecord> sStandbyUpdatePool = new ArrayList(4);
    private final NetworkRequest mNetworkRequest = new NetworkRequest.Builder().build();
    private final ConnectivityManager.NetworkCallback mNetworkCallback = new ConnectivityManager.NetworkCallback(){

        @Override
        public void onAvailable(Network network) {
            AppStandbyController.this.mConnectivityManager.unregisterNetworkCallback(this);
            AppStandbyController.this.checkParoleTimeout();
        }
    };
    private final DisplayManager.DisplayListener mDisplayListener = new DisplayManager.DisplayListener(){

        @Override
        public void onDisplayAdded(int displayId) {
        }

        @Override
        public void onDisplayRemoved(int displayId) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onDisplayChanged(int displayId) {
            if (displayId == 0) {
                boolean displayOn = AppStandbyController.this.isDisplayOn();
                Object object = AppStandbyController.this.mAppIdleLock;
                synchronized (object) {
                    AppStandbyController.this.mAppIdleHistory.updateDisplay(displayOn, AppStandbyController.this.mInjector.elapsedRealtime());
                }
            }
        }
    };

    AppStandbyController(Context context, Looper looper) {
        this(new Injector(context, looper));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AppStandbyController(Injector injector) {
        this.mInjector = injector;
        this.mContext = this.mInjector.getContext();
        this.mHandler = new AppStandbyHandler(this.mInjector.getLooper());
        this.mPackageManager = this.mContext.getPackageManager();
        this.mDeviceStateReceiver = new DeviceStateReceiver();
        IntentFilter deviceStates = new IntentFilter("android.os.action.CHARGING");
        deviceStates.addAction("android.os.action.DISCHARGING");
        deviceStates.addAction("android.os.action.DEVICE_IDLE_MODE_CHANGED");
        this.mContext.registerReceiver(this.mDeviceStateReceiver, deviceStates);
        Object object = this.mAppIdleLock;
        synchronized (object) {
            this.mAppIdleHistory = new AppIdleHistory(this.mInjector.getDataSystemDirectory(), this.mInjector.elapsedRealtime());
        }
        IntentFilter packageFilter = new IntentFilter();
        packageFilter.addAction("android.intent.action.PACKAGE_ADDED");
        packageFilter.addAction("android.intent.action.PACKAGE_CHANGED");
        packageFilter.addAction("android.intent.action.PACKAGE_REMOVED");
        packageFilter.addDataScheme("package");
        this.mContext.registerReceiverAsUser(new PackageReceiver(), UserHandle.ALL, packageFilter, null, this.mHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setAppIdleEnabled(boolean enabled) {
        Object object = this.mAppIdleLock;
        synchronized (object) {
            if (this.mAppIdleEnabled != enabled) {
                boolean oldParoleState = this.isParoledOrCharging();
                this.mAppIdleEnabled = enabled;
                if (this.isParoledOrCharging() != oldParoleState) {
                    this.postParoleStateChanged();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onBootPhase(int phase) {
        this.mInjector.onBootPhase(phase);
        if (phase == 500) {
            boolean userFileExists;
            Slog.d(TAG, "Setting app idle enabled state");
            SettingsObserver settingsObserver = new SettingsObserver(this.mHandler);
            settingsObserver.registerObserver();
            settingsObserver.updateSettings();
            this.mAppWidgetManager = this.mContext.getSystemService(AppWidgetManager.class);
            this.mConnectivityManager = this.mContext.getSystemService(ConnectivityManager.class);
            this.mPowerManager = this.mContext.getSystemService(PowerManager.class);
            this.mInjector.registerDisplayListener(this.mDisplayListener, this.mHandler);
            Object object = this.mAppIdleLock;
            synchronized (object) {
                this.mAppIdleHistory.updateDisplay(this.isDisplayOn(), this.mInjector.elapsedRealtime());
            }
            this.mSystemServicesReady = true;
            Object object2 = this.mAppIdleLock;
            synchronized (object2) {
                userFileExists = this.mAppIdleHistory.userFileExists(0);
            }
            if (this.mPendingInitializeDefaults || !userFileExists) {
                this.initializeDefaultsForSystemApps(0);
            }
            if (this.mPendingOneTimeCheckIdleStates) {
                this.postOneTimeCheckIdleStates();
            }
        } else if (phase == 1000) {
            this.setChargingState(this.mInjector.isCharging());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reportContentProviderUsage(String authority, String providerPkgName, int userId) {
        if (!this.mAppIdleEnabled) {
            return;
        }
        String[] packages = ContentResolver.getSyncAdapterPackagesForAuthorityAsUser(authority, userId);
        long elapsedRealtime = this.mInjector.elapsedRealtime();
        for (String packageName : packages) {
            try {
                PackageInfo pi = this.mPackageManager.getPackageInfoAsUser(packageName, 0x100000, userId);
                if (pi == null || pi.applicationInfo == null || packageName.equals(providerPkgName)) continue;
                Object object = this.mAppIdleLock;
                synchronized (object) {
                    AppIdleHistory.AppUsageHistory appUsage = this.mAppIdleHistory.reportUsage(packageName, userId, 10, 8, 0L, elapsedRealtime + this.mSyncAdapterTimeoutMillis);
                    this.maybeInformListeners(packageName, userId, elapsedRealtime, appUsage.currentBucket, appUsage.bucketingReason, false);
                }
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reportExemptedSyncScheduled(String packageName, int userId) {
        long durationMillis;
        int usageReason;
        int bucketToPromote;
        if (!this.mAppIdleEnabled) {
            return;
        }
        if (!this.mInjector.isDeviceIdleMode()) {
            bucketToPromote = 10;
            usageReason = 11;
            durationMillis = this.mExemptedSyncScheduledNonDozeTimeoutMillis;
        } else {
            bucketToPromote = 20;
            usageReason = 12;
            durationMillis = this.mExemptedSyncScheduledDozeTimeoutMillis;
        }
        long elapsedRealtime = this.mInjector.elapsedRealtime();
        Object object = this.mAppIdleLock;
        synchronized (object) {
            AppIdleHistory.AppUsageHistory appUsage = this.mAppIdleHistory.reportUsage(packageName, userId, bucketToPromote, usageReason, 0L, elapsedRealtime + durationMillis);
            this.maybeInformListeners(packageName, userId, elapsedRealtime, appUsage.currentBucket, appUsage.bucketingReason, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reportUnexemptedSyncScheduled(String packageName, int userId) {
        if (!this.mAppIdleEnabled) {
            return;
        }
        long elapsedRealtime = this.mInjector.elapsedRealtime();
        Object object = this.mAppIdleLock;
        synchronized (object) {
            int currentBucket = this.mAppIdleHistory.getAppStandbyBucket(packageName, userId, elapsedRealtime);
            if (currentBucket == 50) {
                AppIdleHistory.AppUsageHistory appUsage = this.mAppIdleHistory.reportUsage(packageName, userId, 20, 14, 0L, elapsedRealtime + this.mUnexemptedSyncScheduledTimeoutMillis);
                this.maybeInformListeners(packageName, userId, elapsedRealtime, appUsage.currentBucket, appUsage.bucketingReason, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reportExemptedSyncStart(String packageName, int userId) {
        if (!this.mAppIdleEnabled) {
            return;
        }
        long elapsedRealtime = this.mInjector.elapsedRealtime();
        Object object = this.mAppIdleLock;
        synchronized (object) {
            AppIdleHistory.AppUsageHistory appUsage = this.mAppIdleHistory.reportUsage(packageName, userId, 10, 13, 0L, elapsedRealtime + this.mExemptedSyncStartTimeoutMillis);
            this.maybeInformListeners(packageName, userId, elapsedRealtime, appUsage.currentBucket, appUsage.bucketingReason, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setChargingState(boolean charging) {
        Object object = this.mAppIdleLock;
        synchronized (object) {
            if (this.mCharging != charging) {
                this.mCharging = charging;
                if (charging) {
                    this.mHandler.sendEmptyMessageDelayed(14, this.mStableChargingThresholdMillis);
                } else {
                    this.mHandler.removeMessages(14);
                    this.updateChargingStableState();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateChargingStableState() {
        Object object = this.mAppIdleLock;
        synchronized (object) {
            if (this.mChargingStable != this.mCharging) {
                this.mChargingStable = this.mCharging;
                this.postParoleStateChanged();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setAppIdleParoled(boolean paroled) {
        Object object = this.mAppIdleLock;
        synchronized (object) {
            long now = this.mInjector.currentTimeMillis();
            if (this.mAppIdleTempParoled != paroled) {
                this.mAppIdleTempParoled = paroled;
                if (paroled) {
                    this.postParoleEndTimeout();
                } else {
                    this.mLastAppIdleParoledTime = now;
                    this.postNextParoleTimeout(now, false);
                }
                this.postParoleStateChanged();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isParoledOrCharging() {
        if (!this.mAppIdleEnabled) {
            return true;
        }
        Object object = this.mAppIdleLock;
        synchronized (object) {
            return this.mAppIdleTempParoled || this.mChargingStable;
        }
    }

    private void postNextParoleTimeout(long now, boolean forced) {
        this.mHandler.removeMessages(6);
        long timeLeft = this.mLastAppIdleParoledTime + this.mAppIdleParoleIntervalMillis - now;
        if (forced) {
            timeLeft += this.mAppIdleParoleWindowMillis;
        }
        if (timeLeft < 0L) {
            timeLeft = 0L;
        }
        this.mHandler.sendEmptyMessageDelayed(6, timeLeft);
    }

    private void postParoleEndTimeout() {
        this.mHandler.removeMessages(7);
        this.mHandler.sendEmptyMessageDelayed(7, this.mAppIdleParoleDurationMillis);
    }

    private void postParoleStateChanged() {
        this.mHandler.removeMessages(9);
        this.mHandler.sendEmptyMessage(9);
    }

    void postCheckIdleStates(int userId) {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(5, userId, 0));
    }

    void postOneTimeCheckIdleStates() {
        if (this.mInjector.getBootPhase() < 500) {
            this.mPendingOneTimeCheckIdleStates = true;
        } else {
            this.mHandler.sendEmptyMessage(10);
            this.mPendingOneTimeCheckIdleStates = false;
        }
    }

    boolean checkIdleStates(int checkUserId) {
        int[] runningUserIds;
        if (!this.mAppIdleEnabled) {
            return false;
        }
        try {
            runningUserIds = this.mInjector.getRunningUserIds();
            if (checkUserId != -1 && !ArrayUtils.contains(runningUserIds, checkUserId)) {
                return false;
            }
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
        long elapsedRealtime = this.mInjector.elapsedRealtime();
        for (int i = 0; i < runningUserIds.length; ++i) {
            int userId = runningUserIds[i];
            if (checkUserId != -1 && checkUserId != userId) continue;
            List<PackageInfo> packages = this.mPackageManager.getInstalledPackagesAsUser(512, userId);
            int packageCount = packages.size();
            for (int p = 0; p < packageCount; ++p) {
                PackageInfo pi = packages.get(p);
                String packageName = pi.packageName;
                this.checkAndUpdateStandbyState(packageName, userId, pi.applicationInfo.uid, elapsedRealtime);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkAndUpdateStandbyState(String packageName, int userId, int uid, long elapsedRealtime) {
        boolean isSpecial;
        if (uid <= 0) {
            try {
                uid = this.mPackageManager.getPackageUidAsUser(packageName, userId);
            }
            catch (PackageManager.NameNotFoundException e) {
                return;
            }
        }
        if (isSpecial = this.isAppSpecial(packageName, UserHandle.getAppId(uid), userId)) {
            Object object = this.mAppIdleLock;
            synchronized (object) {
                this.mAppIdleHistory.setAppStandbyBucket(packageName, userId, elapsedRealtime, 5, 256);
            }
            this.maybeInformListeners(packageName, userId, elapsedRealtime, 5, 256, false);
        } else {
            Object object = this.mAppIdleLock;
            synchronized (object) {
                AppIdleHistory.AppUsageHistory app = this.mAppIdleHistory.getAppUsageHistory(packageName, userId, elapsedRealtime);
                int reason = app.bucketingReason;
                int oldMainReason = reason & 0xFF00;
                if (oldMainReason == 1024) {
                    return;
                }
                int oldBucket = app.currentBucket;
                int newBucket = Math.max(oldBucket, 10);
                boolean predictionLate = this.predictionTimedOut(app, elapsedRealtime);
                if (oldMainReason == 256 || oldMainReason == 768 || oldMainReason == 512 || predictionLate) {
                    if (!predictionLate && app.lastPredictedBucket >= 10 && app.lastPredictedBucket <= 40) {
                        newBucket = app.lastPredictedBucket;
                        reason = 1281;
                    } else {
                        newBucket = this.getBucketForLocked(packageName, userId, elapsedRealtime);
                        reason = 512;
                    }
                }
                long elapsedTimeAdjusted = this.mAppIdleHistory.getElapsedTime(elapsedRealtime);
                if (newBucket >= 10 && app.bucketActiveTimeoutTime > elapsedTimeAdjusted) {
                    newBucket = 10;
                    reason = app.bucketingReason;
                } else if (newBucket >= 20 && app.bucketWorkingSetTimeoutTime > elapsedTimeAdjusted) {
                    newBucket = 20;
                    int n = reason = newBucket == oldBucket ? app.bucketingReason : 775;
                }
                if (oldBucket < newBucket || predictionLate) {
                    this.mAppIdleHistory.setAppStandbyBucket(packageName, userId, elapsedRealtime, newBucket, reason);
                    this.maybeInformListeners(packageName, userId, elapsedRealtime, newBucket, reason, false);
                }
            }
        }
    }

    private boolean predictionTimedOut(AppIdleHistory.AppUsageHistory app, long elapsedRealtime) {
        return app.lastPredictedTime > 0L && this.mAppIdleHistory.getElapsedTime(elapsedRealtime) - app.lastPredictedTime > this.mPredictionTimeoutMillis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maybeInformListeners(String packageName, int userId, long elapsedRealtime, int bucket, int reason, boolean userStartedInteracting) {
        Object object = this.mAppIdleLock;
        synchronized (object) {
            if (this.mAppIdleHistory.shouldInformListeners(packageName, userId, elapsedRealtime, bucket)) {
                StandbyUpdateRecord r = StandbyUpdateRecord.obtain(packageName, userId, bucket, reason, userStartedInteracting);
                this.mHandler.sendMessage(this.mHandler.obtainMessage(3, r));
            }
        }
    }

    @GuardedBy(value={"mAppIdleLock"})
    int getBucketForLocked(String packageName, int userId, long elapsedRealtime) {
        int bucketIndex = this.mAppIdleHistory.getThresholdIndex(packageName, userId, elapsedRealtime, this.mAppStandbyScreenThresholds, this.mAppStandbyElapsedThresholds);
        return THRESHOLD_BUCKETS[bucketIndex];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkParoleTimeout() {
        boolean setParoled = false;
        boolean waitForNetwork = false;
        NetworkInfo activeNetwork = this.mConnectivityManager.getActiveNetworkInfo();
        boolean networkActive = activeNetwork != null && activeNetwork.isConnected();
        Object object = this.mAppIdleLock;
        synchronized (object) {
            long now = this.mInjector.currentTimeMillis();
            if (!this.mAppIdleTempParoled) {
                long timeSinceLastParole = now - this.mLastAppIdleParoledTime;
                if (timeSinceLastParole > this.mAppIdleParoleIntervalMillis) {
                    if (networkActive) {
                        setParoled = true;
                    } else if (timeSinceLastParole > this.mAppIdleParoleIntervalMillis + this.mAppIdleParoleWindowMillis) {
                        setParoled = true;
                    } else {
                        waitForNetwork = true;
                        this.postNextParoleTimeout(now, true);
                    }
                } else {
                    this.postNextParoleTimeout(now, false);
                }
            }
        }
        if (waitForNetwork) {
            this.mConnectivityManager.registerNetworkCallback(this.mNetworkRequest, this.mNetworkCallback);
        }
        if (setParoled) {
            this.setAppIdleParoled(true);
        }
    }

    private void notifyBatteryStats(String packageName, int userId, boolean idle) {
        try {
            int uid = this.mPackageManager.getPackageUidAsUser(packageName, 8192, userId);
            if (idle) {
                this.mInjector.noteEvent(15, packageName, uid);
            } else {
                this.mInjector.noteEvent(16, packageName, uid);
            }
        }
        catch (PackageManager.NameNotFoundException | RemoteException androidException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onDeviceIdleModeChanged() {
        boolean deviceIdle = this.mPowerManager.isDeviceIdleMode();
        boolean paroled = false;
        Object object = this.mAppIdleLock;
        synchronized (object) {
            long timeSinceLastParole = this.mInjector.currentTimeMillis() - this.mLastAppIdleParoledTime;
            if (!deviceIdle && timeSinceLastParole >= this.mAppIdleParoleIntervalMillis) {
                paroled = true;
            } else if (deviceIdle) {
                paroled = false;
            } else {
                return;
            }
        }
        this.setAppIdleParoled(paroled);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reportEvent(UsageEvents.Event event, long elapsedRealtime, int userId) {
        if (!this.mAppIdleEnabled) {
            return;
        }
        Object object = this.mAppIdleLock;
        synchronized (object) {
            boolean previouslyIdle = this.mAppIdleHistory.isIdle(event.mPackage, userId, elapsedRealtime);
            if (event.mEventType == 1 || event.mEventType == 2 || event.mEventType == 6 || event.mEventType == 7 || event.mEventType == 10 || event.mEventType == 14 || event.mEventType == 13 || event.mEventType == 19) {
                long nextCheckTime;
                AppIdleHistory.AppUsageHistory appHistory = this.mAppIdleHistory.getAppUsageHistory(event.mPackage, userId, elapsedRealtime);
                int prevBucket = appHistory.currentBucket;
                int prevBucketReason = appHistory.bucketingReason;
                int subReason = this.usageEventToSubReason(event.mEventType);
                int reason = 0x300 | subReason;
                if (event.mEventType == 10 || event.mEventType == 14) {
                    this.mAppIdleHistory.reportUsage(appHistory, event.mPackage, 20, subReason, 0L, elapsedRealtime + this.mNotificationSeenTimeoutMillis);
                    nextCheckTime = this.mNotificationSeenTimeoutMillis;
                } else if (event.mEventType == 6) {
                    this.mAppIdleHistory.reportUsage(appHistory, event.mPackage, 10, subReason, 0L, elapsedRealtime + this.mSystemInteractionTimeoutMillis);
                    nextCheckTime = this.mSystemInteractionTimeoutMillis;
                } else if (event.mEventType == 19) {
                    if (prevBucket != 50) {
                        return;
                    }
                    this.mAppIdleHistory.reportUsage(appHistory, event.mPackage, 10, subReason, 0L, elapsedRealtime + this.mInitialForegroundServiceStartTimeoutMillis);
                    nextCheckTime = this.mInitialForegroundServiceStartTimeoutMillis;
                } else {
                    this.mAppIdleHistory.reportUsage(appHistory, event.mPackage, 10, subReason, elapsedRealtime, elapsedRealtime + this.mStrongUsageTimeoutMillis);
                    nextCheckTime = this.mStrongUsageTimeoutMillis;
                }
                this.mHandler.sendMessageDelayed(this.mHandler.obtainMessage(11, userId, -1, event.mPackage), nextCheckTime);
                boolean userStartedInteracting = appHistory.currentBucket == 10 && prevBucket != appHistory.currentBucket && (prevBucketReason & 0xFF00) != 768;
                this.maybeInformListeners(event.mPackage, userId, elapsedRealtime, appHistory.currentBucket, reason, userStartedInteracting);
                if (previouslyIdle) {
                    this.notifyBatteryStats(event.mPackage, userId, false);
                }
            }
        }
    }

    private int usageEventToSubReason(int eventType) {
        switch (eventType) {
            case 1: {
                return 4;
            }
            case 2: {
                return 5;
            }
            case 6: {
                return 1;
            }
            case 7: {
                return 3;
            }
            case 10: {
                return 2;
            }
            case 14: {
                return 9;
            }
            case 13: {
                return 10;
            }
            case 19: {
                return 15;
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void forceIdleState(String packageName, int userId, boolean idle) {
        int standbyBucket;
        if (!this.mAppIdleEnabled) {
            return;
        }
        int appId = this.getAppId(packageName);
        if (appId < 0) {
            return;
        }
        long elapsedRealtime = this.mInjector.elapsedRealtime();
        boolean previouslyIdle = this.isAppIdleFiltered(packageName, appId, userId, elapsedRealtime);
        Object object = this.mAppIdleLock;
        synchronized (object) {
            standbyBucket = this.mAppIdleHistory.setIdle(packageName, userId, idle, elapsedRealtime);
        }
        boolean stillIdle = this.isAppIdleFiltered(packageName, appId, userId, elapsedRealtime);
        if (previouslyIdle != stillIdle) {
            this.maybeInformListeners(packageName, userId, elapsedRealtime, standbyBucket, 1024, false);
            if (!stillIdle) {
                this.notifyBatteryStats(packageName, userId, idle);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLastJobRunTime(String packageName, int userId, long elapsedRealtime) {
        Object object = this.mAppIdleLock;
        synchronized (object) {
            this.mAppIdleHistory.setLastJobRunTime(packageName, userId, elapsedRealtime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getTimeSinceLastJobRun(String packageName, int userId) {
        long elapsedRealtime = this.mInjector.elapsedRealtime();
        Object object = this.mAppIdleLock;
        synchronized (object) {
            return this.mAppIdleHistory.getTimeSinceLastJobRun(packageName, userId, elapsedRealtime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onUserRemoved(int userId) {
        Object object = this.mAppIdleLock;
        synchronized (object) {
            this.mAppIdleHistory.onUserRemoved(userId);
            SparseArray<Set<String>> sparseArray = this.mActiveAdminApps;
            synchronized (sparseArray) {
                this.mActiveAdminApps.remove(userId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isAppIdleUnfiltered(String packageName, int userId, long elapsedRealtime) {
        Object object = this.mAppIdleLock;
        synchronized (object) {
            return this.mAppIdleHistory.isIdle(packageName, userId, elapsedRealtime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addListener(UsageStatsManagerInternal.AppIdleStateChangeListener listener) {
        ArrayList<UsageStatsManagerInternal.AppIdleStateChangeListener> arrayList = this.mPackageAccessListeners;
        synchronized (arrayList) {
            if (!this.mPackageAccessListeners.contains(listener)) {
                this.mPackageAccessListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeListener(UsageStatsManagerInternal.AppIdleStateChangeListener listener) {
        ArrayList<UsageStatsManagerInternal.AppIdleStateChangeListener> arrayList = this.mPackageAccessListeners;
        synchronized (arrayList) {
            this.mPackageAccessListeners.remove(listener);
        }
    }

    int getAppId(String packageName) {
        try {
            ApplicationInfo ai = this.mPackageManager.getApplicationInfo(packageName, 0x400200);
            return ai.uid;
        }
        catch (PackageManager.NameNotFoundException re) {
            return -1;
        }
    }

    boolean isAppIdleFilteredOrParoled(String packageName, int userId, long elapsedRealtime, boolean shouldObfuscateInstantApps) {
        if (this.isParoledOrCharging()) {
            return false;
        }
        if (shouldObfuscateInstantApps && this.mInjector.isPackageEphemeral(userId, packageName)) {
            return false;
        }
        return this.isAppIdleFiltered(packageName, this.getAppId(packageName), userId, elapsedRealtime);
    }

    boolean isAppSpecial(String packageName, int appId, int userId) {
        if (packageName == null) {
            return false;
        }
        if (!this.mAppIdleEnabled) {
            return true;
        }
        if (appId < 10000) {
            return true;
        }
        if (packageName.equals("android")) {
            return true;
        }
        if (this.mSystemServicesReady) {
            try {
                if (this.mInjector.isPowerSaveWhitelistExceptIdleApp(packageName)) {
                    return true;
                }
            }
            catch (RemoteException re) {
                throw re.rethrowFromSystemServer();
            }
            if (this.isActiveDeviceAdmin(packageName, userId)) {
                return true;
            }
            if (this.isActiveNetworkScorer(packageName)) {
                return true;
            }
            if (this.mAppWidgetManager != null && this.mInjector.isBoundWidgetPackage(this.mAppWidgetManager, packageName, userId)) {
                return true;
            }
            if (this.isDeviceProvisioningPackage(packageName)) {
                return true;
            }
        }
        return this.isCarrierApp(packageName);
    }

    boolean isAppIdleFiltered(String packageName, int appId, int userId, long elapsedRealtime) {
        if (this.isAppSpecial(packageName, appId, userId)) {
            return false;
        }
        return this.isAppIdleUnfiltered(packageName, userId, elapsedRealtime);
    }

    int[] getIdleUidsForUser(int userId) {
        List apps;
        if (!this.mAppIdleEnabled) {
            return new int[0];
        }
        long elapsedRealtime = this.mInjector.elapsedRealtime();
        try {
            ParceledListSlice slice = AppGlobals.getPackageManager().getInstalledApplications(0, userId);
            if (slice == null) {
                return new int[0];
            }
            apps = slice.getList();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        SparseIntArray uidStates = new SparseIntArray();
        for (int i = apps.size() - 1; i >= 0; --i) {
            ApplicationInfo ai = (ApplicationInfo)apps.get(i);
            boolean idle = this.isAppIdleFiltered(ai.packageName, UserHandle.getAppId(ai.uid), userId, elapsedRealtime);
            int index = uidStates.indexOfKey(ai.uid);
            if (index < 0) {
                uidStates.put(ai.uid, 1 + (idle ? 65536 : 0));
                continue;
            }
            int value = uidStates.valueAt(index);
            uidStates.setValueAt(index, value + 1 + (idle ? 65536 : 0));
        }
        int numIdle = 0;
        for (int i = uidStates.size() - 1; i >= 0; --i) {
            int value = uidStates.valueAt(i);
            if ((value & Short.MAX_VALUE) != value >> 16) continue;
            ++numIdle;
        }
        int[] res = new int[numIdle];
        numIdle = 0;
        for (int i = uidStates.size() - 1; i >= 0; --i) {
            int value = uidStates.valueAt(i);
            if ((value & Short.MAX_VALUE) != value >> 16) continue;
            res[numIdle] = uidStates.keyAt(i);
            ++numIdle;
        }
        return res;
    }

    void setAppIdleAsync(String packageName, boolean idle, int userId) {
        if (packageName == null || !this.mAppIdleEnabled) {
            return;
        }
        this.mHandler.obtainMessage(4, userId, idle ? 1 : 0, packageName).sendToTarget();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getAppStandbyBucket(String packageName, int userId, long elapsedRealtime, boolean shouldObfuscateInstantApps) {
        if (!this.mAppIdleEnabled || shouldObfuscateInstantApps && this.mInjector.isPackageEphemeral(userId, packageName)) {
            return 10;
        }
        Object object = this.mAppIdleLock;
        synchronized (object) {
            return this.mAppIdleHistory.getAppStandbyBucket(packageName, userId, elapsedRealtime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AppStandbyInfo> getAppStandbyBuckets(int userId) {
        Object object = this.mAppIdleLock;
        synchronized (object) {
            return this.mAppIdleHistory.getAppStandbyBuckets(userId, this.mAppIdleEnabled);
        }
    }

    void setAppStandbyBucket(String packageName, int userId, int newBucket, int reason, long elapsedRealtime) {
        this.setAppStandbyBucket(packageName, userId, newBucket, reason, elapsedRealtime, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setAppStandbyBucket(String packageName, int userId, int newBucket, int reason, long elapsedRealtime, boolean resetTimeout) {
        Object object = this.mAppIdleLock;
        synchronized (object) {
            boolean predicted;
            if (!this.mInjector.isPackageInstalled(packageName, 0, userId)) {
                return;
            }
            AppIdleHistory.AppUsageHistory app = this.mAppIdleHistory.getAppUsageHistory(packageName, userId, elapsedRealtime);
            boolean bl = predicted = (reason & 0xFF00) == 1280;
            if (app.currentBucket < 10) {
                return;
            }
            if ((app.currentBucket == 50 || newBucket == 50) && predicted) {
                return;
            }
            if ((app.bucketingReason & 0xFF00) == 1024 && predicted) {
                return;
            }
            if (predicted) {
                long elapsedTimeAdjusted = this.mAppIdleHistory.getElapsedTime(elapsedRealtime);
                this.mAppIdleHistory.updateLastPrediction(app, elapsedTimeAdjusted, newBucket);
                if (newBucket > 10 && app.bucketActiveTimeoutTime > elapsedTimeAdjusted) {
                    newBucket = 10;
                    reason = app.bucketingReason;
                } else if (newBucket > 20 && app.bucketWorkingSetTimeoutTime > elapsedTimeAdjusted) {
                    newBucket = 20;
                    reason = app.currentBucket != newBucket ? 775 : app.bucketingReason;
                }
            }
            this.mAppIdleHistory.setAppStandbyBucket(packageName, userId, elapsedRealtime, newBucket, reason, resetTimeout);
        }
        this.maybeInformListeners(packageName, userId, elapsedRealtime, newBucket, reason, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    boolean isActiveDeviceAdmin(String packageName, int userId) {
        SparseArray<Set<String>> sparseArray = this.mActiveAdminApps;
        synchronized (sparseArray) {
            Set<String> adminPkgs = this.mActiveAdminApps.get(userId);
            return adminPkgs != null && adminPkgs.contains(packageName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addActiveDeviceAdmin(String adminPkg, int userId) {
        SparseArray<Set<String>> sparseArray = this.mActiveAdminApps;
        synchronized (sparseArray) {
            Set<String> adminPkgs = this.mActiveAdminApps.get(userId);
            if (adminPkgs == null) {
                adminPkgs = new ArraySet<String>();
                this.mActiveAdminApps.put(userId, adminPkgs);
            }
            adminPkgs.add(adminPkg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setActiveAdminApps(Set<String> adminPkgs, int userId) {
        SparseArray<Set<String>> sparseArray = this.mActiveAdminApps;
        synchronized (sparseArray) {
            if (adminPkgs == null) {
                this.mActiveAdminApps.remove(userId);
            } else {
                this.mActiveAdminApps.put(userId, adminPkgs);
            }
        }
    }

    public void onAdminDataAvailable() {
        this.mAdminDataAvailableLatch.countDown();
    }

    private void waitForAdminData() {
        if (this.mContext.getPackageManager().hasSystemFeature("android.software.device_admin")) {
            ConcurrentUtils.waitForCountDownNoInterrupt(this.mAdminDataAvailableLatch, 10000L, "Wait for admin data");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Set<String> getActiveAdminAppsForTest(int userId) {
        SparseArray<Set<String>> sparseArray = this.mActiveAdminApps;
        synchronized (sparseArray) {
            return this.mActiveAdminApps.get(userId);
        }
    }

    private boolean isDeviceProvisioningPackage(String packageName) {
        String deviceProvisioningPackage = this.mContext.getResources().getString(17039717);
        return deviceProvisioningPackage != null && deviceProvisioningPackage.equals(packageName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isCarrierApp(String packageName) {
        Object object = this.mAppIdleLock;
        synchronized (object) {
            if (!this.mHaveCarrierPrivilegedApps) {
                this.fetchCarrierPrivilegedAppsLocked();
            }
            if (this.mCarrierPrivilegedApps != null) {
                return this.mCarrierPrivilegedApps.contains(packageName);
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearCarrierPrivilegedApps() {
        Object object = this.mAppIdleLock;
        synchronized (object) {
            this.mHaveCarrierPrivilegedApps = false;
            this.mCarrierPrivilegedApps = null;
        }
    }

    @GuardedBy(value={"mAppIdleLock"})
    private void fetchCarrierPrivilegedAppsLocked() {
        TelephonyManager telephonyManager = this.mContext.getSystemService(TelephonyManager.class);
        this.mCarrierPrivilegedApps = telephonyManager.getPackagesWithCarrierPrivilegesForAllPhones();
        this.mHaveCarrierPrivilegedApps = true;
    }

    private boolean isActiveNetworkScorer(String packageName) {
        String activeScorer = this.mInjector.getActiveNetworkScorer();
        return packageName != null && packageName.equals(activeScorer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void informListeners(String packageName, int userId, int bucket, int reason, boolean userInteraction) {
        boolean idle = bucket >= 40;
        ArrayList<UsageStatsManagerInternal.AppIdleStateChangeListener> arrayList = this.mPackageAccessListeners;
        synchronized (arrayList) {
            for (UsageStatsManagerInternal.AppIdleStateChangeListener listener : this.mPackageAccessListeners) {
                listener.onAppIdleStateChanged(packageName, userId, idle, bucket, reason);
                if (!userInteraction) continue;
                listener.onUserInteractionStarted(packageName, userId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void informParoleStateChanged() {
        boolean paroled = this.isParoledOrCharging();
        ArrayList<UsageStatsManagerInternal.AppIdleStateChangeListener> arrayList = this.mPackageAccessListeners;
        synchronized (arrayList) {
            for (UsageStatsManagerInternal.AppIdleStateChangeListener listener : this.mPackageAccessListeners) {
                listener.onParoleStateChanged(paroled);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void flushToDisk(int userId) {
        Object object = this.mAppIdleLock;
        synchronized (object) {
            this.mAppIdleHistory.writeAppIdleTimes(userId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void flushDurationsToDisk() {
        Object object = this.mAppIdleLock;
        synchronized (object) {
            this.mAppIdleHistory.writeAppIdleDurations();
        }
    }

    boolean isDisplayOn() {
        return this.mInjector.isDefaultDisplayOn();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearAppIdleForPackage(String packageName, int userId) {
        Object object = this.mAppIdleLock;
        synchronized (object) {
            this.mAppIdleHistory.clearUsage(packageName, userId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initializeDefaultsForSystemApps(int userId) {
        if (!this.mSystemServicesReady) {
            this.mPendingInitializeDefaults = true;
            return;
        }
        Slog.d(TAG, "Initializing defaults for system apps on user " + userId + ", appIdleEnabled=" + this.mAppIdleEnabled);
        long elapsedRealtime = this.mInjector.elapsedRealtime();
        List<PackageInfo> packages = this.mPackageManager.getInstalledPackagesAsUser(512, userId);
        int packageCount = packages.size();
        Object object = this.mAppIdleLock;
        synchronized (object) {
            for (int i = 0; i < packageCount; ++i) {
                PackageInfo pi = packages.get(i);
                String packageName = pi.packageName;
                if (pi.applicationInfo == null || !pi.applicationInfo.isSystemApp()) continue;
                this.mAppIdleHistory.reportUsage(packageName, userId, 10, 6, 0L, elapsedRealtime + this.mSystemUpdateUsageTimeoutMillis);
            }
            this.mAppIdleHistory.writeAppIdleTimes(userId);
        }
    }

    void postReportContentProviderUsage(String name, String packageName, int userId) {
        SomeArgs args = SomeArgs.obtain();
        args.arg1 = name;
        args.arg2 = packageName;
        args.arg3 = userId;
        this.mHandler.obtainMessage(8, args).sendToTarget();
    }

    void postReportSyncScheduled(String packageName, int userId, boolean exempted) {
        this.mHandler.obtainMessage(12, userId, exempted ? 1 : 0, packageName).sendToTarget();
    }

    void postReportExemptedSyncStart(String packageName, int userId) {
        this.mHandler.obtainMessage(13, userId, 0, packageName).sendToTarget();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dumpUser(IndentingPrintWriter idpw, int userId, String pkg) {
        Object object = this.mAppIdleLock;
        synchronized (object) {
            this.mAppIdleHistory.dump(idpw, userId, pkg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dumpState(String[] args, PrintWriter pw) {
        Object object = this.mAppIdleLock;
        synchronized (object) {
            pw.println("Carrier privileged apps (have=" + this.mHaveCarrierPrivilegedApps + "): " + this.mCarrierPrivilegedApps);
        }
        long now = System.currentTimeMillis();
        pw.println();
        pw.println("Settings:");
        pw.print("  mCheckIdleIntervalMillis=");
        TimeUtils.formatDuration(this.mCheckIdleIntervalMillis, pw);
        pw.println();
        pw.print("  mAppIdleParoleIntervalMillis=");
        TimeUtils.formatDuration(this.mAppIdleParoleIntervalMillis, pw);
        pw.println();
        pw.print("  mAppIdleParoleWindowMillis=");
        TimeUtils.formatDuration(this.mAppIdleParoleWindowMillis, pw);
        pw.println();
        pw.print("  mAppIdleParoleDurationMillis=");
        TimeUtils.formatDuration(this.mAppIdleParoleDurationMillis, pw);
        pw.println();
        pw.print("  mStrongUsageTimeoutMillis=");
        TimeUtils.formatDuration(this.mStrongUsageTimeoutMillis, pw);
        pw.println();
        pw.print("  mNotificationSeenTimeoutMillis=");
        TimeUtils.formatDuration(this.mNotificationSeenTimeoutMillis, pw);
        pw.println();
        pw.print("  mSyncAdapterTimeoutMillis=");
        TimeUtils.formatDuration(this.mSyncAdapterTimeoutMillis, pw);
        pw.println();
        pw.print("  mSystemInteractionTimeoutMillis=");
        TimeUtils.formatDuration(this.mSystemInteractionTimeoutMillis, pw);
        pw.println();
        pw.print("  mInitialForegroundServiceStartTimeoutMillis=");
        TimeUtils.formatDuration(this.mInitialForegroundServiceStartTimeoutMillis, pw);
        pw.println();
        pw.print("  mPredictionTimeoutMillis=");
        TimeUtils.formatDuration(this.mPredictionTimeoutMillis, pw);
        pw.println();
        pw.print("  mExemptedSyncScheduledNonDozeTimeoutMillis=");
        TimeUtils.formatDuration(this.mExemptedSyncScheduledNonDozeTimeoutMillis, pw);
        pw.println();
        pw.print("  mExemptedSyncScheduledDozeTimeoutMillis=");
        TimeUtils.formatDuration(this.mExemptedSyncScheduledDozeTimeoutMillis, pw);
        pw.println();
        pw.print("  mExemptedSyncStartTimeoutMillis=");
        TimeUtils.formatDuration(this.mExemptedSyncStartTimeoutMillis, pw);
        pw.println();
        pw.print("  mUnexemptedSyncScheduledTimeoutMillis=");
        TimeUtils.formatDuration(this.mUnexemptedSyncScheduledTimeoutMillis, pw);
        pw.println();
        pw.print("  mSystemUpdateUsageTimeoutMillis=");
        TimeUtils.formatDuration(this.mSystemUpdateUsageTimeoutMillis, pw);
        pw.println();
        pw.print("  mStableChargingThresholdMillis=");
        TimeUtils.formatDuration(this.mStableChargingThresholdMillis, pw);
        pw.println();
        pw.println();
        pw.print("mAppIdleEnabled=");
        pw.print(this.mAppIdleEnabled);
        pw.print(" mAppIdleTempParoled=");
        pw.print(this.mAppIdleTempParoled);
        pw.print(" mCharging=");
        pw.print(this.mCharging);
        pw.print(" mChargingStable=");
        pw.print(this.mChargingStable);
        pw.print(" mLastAppIdleParoledTime=");
        TimeUtils.formatDuration(now - this.mLastAppIdleParoledTime, pw);
        pw.println();
        pw.print("mScreenThresholds=");
        pw.println(Arrays.toString(this.mAppStandbyScreenThresholds));
        pw.print("mElapsedThresholds=");
        pw.println(Arrays.toString(this.mAppStandbyElapsedThresholds));
        pw.print("mStableChargingThresholdMillis=");
        TimeUtils.formatDuration(this.mStableChargingThresholdMillis, pw);
        pw.println();
    }

    private class SettingsObserver
    extends ContentObserver {
        @Deprecated
        private static final String KEY_IDLE_DURATION_OLD = "idle_duration";
        @Deprecated
        private static final String KEY_IDLE_DURATION = "idle_duration2";
        @Deprecated
        private static final String KEY_WALLCLOCK_THRESHOLD = "wallclock_threshold";
        private static final String KEY_PAROLE_INTERVAL = "parole_interval";
        private static final String KEY_PAROLE_WINDOW = "parole_window";
        private static final String KEY_PAROLE_DURATION = "parole_duration";
        private static final String KEY_SCREEN_TIME_THRESHOLDS = "screen_thresholds";
        private static final String KEY_ELAPSED_TIME_THRESHOLDS = "elapsed_thresholds";
        private static final String KEY_STRONG_USAGE_HOLD_DURATION = "strong_usage_duration";
        private static final String KEY_NOTIFICATION_SEEN_HOLD_DURATION = "notification_seen_duration";
        private static final String KEY_SYSTEM_UPDATE_HOLD_DURATION = "system_update_usage_duration";
        private static final String KEY_PREDICTION_TIMEOUT = "prediction_timeout";
        private static final String KEY_SYNC_ADAPTER_HOLD_DURATION = "sync_adapter_duration";
        private static final String KEY_EXEMPTED_SYNC_SCHEDULED_NON_DOZE_HOLD_DURATION = "exempted_sync_scheduled_nd_duration";
        private static final String KEY_EXEMPTED_SYNC_SCHEDULED_DOZE_HOLD_DURATION = "exempted_sync_scheduled_d_duration";
        private static final String KEY_EXEMPTED_SYNC_START_HOLD_DURATION = "exempted_sync_start_duration";
        private static final String KEY_UNEXEMPTED_SYNC_SCHEDULED_HOLD_DURATION = "unexempted_sync_scheduled_duration";
        private static final String KEY_SYSTEM_INTERACTION_HOLD_DURATION = "system_interaction_duration";
        private static final String KEY_INITIAL_FOREGROUND_SERVICE_START_HOLD_DURATION = "initial_foreground_service_start_duration";
        private static final String KEY_STABLE_CHARGING_THRESHOLD = "stable_charging_threshold";
        public static final long DEFAULT_STRONG_USAGE_TIMEOUT = 3600000L;
        public static final long DEFAULT_NOTIFICATION_TIMEOUT = 43200000L;
        public static final long DEFAULT_SYSTEM_UPDATE_TIMEOUT = 0x6DDD00L;
        public static final long DEFAULT_SYSTEM_INTERACTION_TIMEOUT = 600000L;
        public static final long DEFAULT_SYNC_ADAPTER_TIMEOUT = 600000L;
        public static final long DEFAULT_EXEMPTED_SYNC_SCHEDULED_NON_DOZE_TIMEOUT = 600000L;
        public static final long DEFAULT_EXEMPTED_SYNC_SCHEDULED_DOZE_TIMEOUT = 14400000L;
        public static final long DEFAULT_EXEMPTED_SYNC_START_TIMEOUT = 600000L;
        public static final long DEFAULT_UNEXEMPTED_SYNC_SCHEDULED_TIMEOUT = 600000L;
        public static final long DEFAULT_STABLE_CHARGING_THRESHOLD = 600000L;
        public static final long DEFAULT_INITIAL_FOREGROUND_SERVICE_START_TIMEOUT = 1800000L;
        private final KeyValueListParser mParser;

        SettingsObserver(Handler handler) {
            super(handler);
            this.mParser = new KeyValueListParser(',');
        }

        void registerObserver() {
            ContentResolver cr = AppStandbyController.this.mContext.getContentResolver();
            cr.registerContentObserver(Settings.Global.getUriFor("app_idle_constants"), false, this);
            cr.registerContentObserver(Settings.Global.getUriFor("app_standby_enabled"), false, this);
            cr.registerContentObserver(Settings.Global.getUriFor("adaptive_battery_management_enabled"), false, this);
        }

        @Override
        public void onChange(boolean selfChange) {
            this.updateSettings();
            AppStandbyController.this.postOneTimeCheckIdleStates();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void updateSettings() {
            try {
                this.mParser.setString(AppStandbyController.this.mInjector.getAppIdleSettings());
            }
            catch (IllegalArgumentException e) {
                Slog.e(AppStandbyController.TAG, "Bad value for app idle settings: " + e.getMessage());
            }
            Object object = AppStandbyController.this.mAppIdleLock;
            synchronized (object) {
                AppStandbyController.this.mAppIdleParoleIntervalMillis = this.mParser.getDurationMillis(KEY_PAROLE_INTERVAL, 86400000L);
                AppStandbyController.this.mAppIdleParoleWindowMillis = this.mParser.getDurationMillis(KEY_PAROLE_WINDOW, 0x6DDD00L);
                AppStandbyController.this.mAppIdleParoleDurationMillis = this.mParser.getDurationMillis(KEY_PAROLE_DURATION, 600000L);
                String screenThresholdsValue = this.mParser.getString(KEY_SCREEN_TIME_THRESHOLDS, null);
                AppStandbyController.this.mAppStandbyScreenThresholds = this.parseLongArray(screenThresholdsValue, SCREEN_TIME_THRESHOLDS);
                String elapsedThresholdsValue = this.mParser.getString(KEY_ELAPSED_TIME_THRESHOLDS, null);
                AppStandbyController.this.mAppStandbyElapsedThresholds = this.parseLongArray(elapsedThresholdsValue, ELAPSED_TIME_THRESHOLDS);
                AppStandbyController.this.mCheckIdleIntervalMillis = Math.min(AppStandbyController.this.mAppStandbyElapsedThresholds[1] / 4L, 14400000L);
                AppStandbyController.this.mStrongUsageTimeoutMillis = this.mParser.getDurationMillis(KEY_STRONG_USAGE_HOLD_DURATION, 3600000L);
                AppStandbyController.this.mNotificationSeenTimeoutMillis = this.mParser.getDurationMillis(KEY_NOTIFICATION_SEEN_HOLD_DURATION, 43200000L);
                AppStandbyController.this.mSystemUpdateUsageTimeoutMillis = this.mParser.getDurationMillis(KEY_SYSTEM_UPDATE_HOLD_DURATION, 0x6DDD00L);
                AppStandbyController.this.mPredictionTimeoutMillis = this.mParser.getDurationMillis(KEY_PREDICTION_TIMEOUT, 43200000L);
                AppStandbyController.this.mSyncAdapterTimeoutMillis = this.mParser.getDurationMillis(KEY_SYNC_ADAPTER_HOLD_DURATION, 600000L);
                AppStandbyController.this.mExemptedSyncScheduledNonDozeTimeoutMillis = this.mParser.getDurationMillis(KEY_EXEMPTED_SYNC_SCHEDULED_NON_DOZE_HOLD_DURATION, 600000L);
                AppStandbyController.this.mExemptedSyncScheduledDozeTimeoutMillis = this.mParser.getDurationMillis(KEY_EXEMPTED_SYNC_SCHEDULED_DOZE_HOLD_DURATION, 14400000L);
                AppStandbyController.this.mExemptedSyncStartTimeoutMillis = this.mParser.getDurationMillis(KEY_EXEMPTED_SYNC_START_HOLD_DURATION, 600000L);
                AppStandbyController.this.mUnexemptedSyncScheduledTimeoutMillis = this.mParser.getDurationMillis(KEY_EXEMPTED_SYNC_SCHEDULED_DOZE_HOLD_DURATION, 600000L);
                AppStandbyController.this.mSystemInteractionTimeoutMillis = this.mParser.getDurationMillis(KEY_SYSTEM_INTERACTION_HOLD_DURATION, 600000L);
                AppStandbyController.this.mInitialForegroundServiceStartTimeoutMillis = this.mParser.getDurationMillis(KEY_INITIAL_FOREGROUND_SERVICE_START_HOLD_DURATION, 1800000L);
                AppStandbyController.this.mStableChargingThresholdMillis = this.mParser.getDurationMillis(KEY_STABLE_CHARGING_THRESHOLD, 600000L);
            }
            AppStandbyController.this.setAppIdleEnabled(AppStandbyController.this.mInjector.isAppIdleEnabled());
        }

        long[] parseLongArray(String values, long[] defaults) {
            if (values == null) {
                return defaults;
            }
            if (values.isEmpty()) {
                return defaults;
            }
            String[] thresholds = values.split("/");
            if (thresholds.length == THRESHOLD_BUCKETS.length) {
                long[] array2 = new long[THRESHOLD_BUCKETS.length];
                for (int i = 0; i < THRESHOLD_BUCKETS.length; ++i) {
                    try {
                        if (thresholds[i].startsWith("P") || thresholds[i].startsWith("p")) {
                            array2[i] = Duration.parse(thresholds[i]).toMillis();
                            continue;
                        }
                        array2[i] = Long.parseLong(thresholds[i]);
                        continue;
                    }
                    catch (NumberFormatException | DateTimeParseException e) {
                        return defaults;
                    }
                }
                return array2;
            }
            return defaults;
        }
    }

    private class DeviceStateReceiver
    extends BroadcastReceiver {
        private DeviceStateReceiver() {
        }

        @Override
        public void onReceive(Context context, Intent intent) {
            switch (intent.getAction()) {
                case "android.os.action.CHARGING": {
                    AppStandbyController.this.setChargingState(true);
                    break;
                }
                case "android.os.action.DISCHARGING": {
                    AppStandbyController.this.setChargingState(false);
                    break;
                }
                case "android.os.action.DEVICE_IDLE_MODE_CHANGED": {
                    AppStandbyController.this.onDeviceIdleModeChanged();
                }
            }
        }
    }

    class AppStandbyHandler
    extends Handler {
        AppStandbyHandler(Looper looper) {
            super(looper);
        }

        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 3: {
                    StandbyUpdateRecord r = (StandbyUpdateRecord)msg.obj;
                    AppStandbyController.this.informListeners(r.packageName, r.userId, r.bucket, r.reason, r.isUserInteraction);
                    r.recycle();
                    break;
                }
                case 4: {
                    AppStandbyController.this.forceIdleState((String)msg.obj, msg.arg1, msg.arg2 == 1);
                    break;
                }
                case 5: {
                    if (!AppStandbyController.this.checkIdleStates(msg.arg1) || !AppStandbyController.this.mAppIdleEnabled) break;
                    AppStandbyController.this.mHandler.sendMessageDelayed(AppStandbyController.this.mHandler.obtainMessage(5, msg.arg1, 0), AppStandbyController.this.mCheckIdleIntervalMillis);
                    break;
                }
                case 10: {
                    AppStandbyController.this.mHandler.removeMessages(10);
                    AppStandbyController.this.waitForAdminData();
                    AppStandbyController.this.checkIdleStates(-1);
                    break;
                }
                case 6: {
                    AppStandbyController.this.checkParoleTimeout();
                    break;
                }
                case 7: {
                    AppStandbyController.this.setAppIdleParoled(false);
                    break;
                }
                case 8: {
                    SomeArgs args = (SomeArgs)msg.obj;
                    AppStandbyController.this.reportContentProviderUsage((String)args.arg1, (String)args.arg2, (Integer)args.arg3);
                    args.recycle();
                    break;
                }
                case 9: {
                    AppStandbyController.this.informParoleStateChanged();
                    break;
                }
                case 11: {
                    AppStandbyController.this.checkAndUpdateStandbyState((String)msg.obj, msg.arg1, msg.arg2, AppStandbyController.this.mInjector.elapsedRealtime());
                    break;
                }
                case 12: {
                    boolean exempted;
                    boolean bl = exempted = msg.arg1 > 0;
                    if (exempted) {
                        AppStandbyController.this.reportExemptedSyncScheduled((String)msg.obj, msg.arg1);
                        break;
                    }
                    AppStandbyController.this.reportUnexemptedSyncScheduled((String)msg.obj, msg.arg1);
                    break;
                }
                case 13: {
                    AppStandbyController.this.reportExemptedSyncStart((String)msg.obj, msg.arg1);
                    break;
                }
                case 14: {
                    AppStandbyController.this.updateChargingStableState();
                    break;
                }
                default: {
                    super.handleMessage(msg);
                }
            }
        }
    }

    static class Injector {
        private final Context mContext;
        private final Looper mLooper;
        private IDeviceIdleController mDeviceIdleController;
        private IBatteryStats mBatteryStats;
        private PackageManagerInternal mPackageManagerInternal;
        private DisplayManager mDisplayManager;
        private PowerManager mPowerManager;
        int mBootPhase;

        Injector(Context context, Looper looper) {
            this.mContext = context;
            this.mLooper = looper;
        }

        Context getContext() {
            return this.mContext;
        }

        Looper getLooper() {
            return this.mLooper;
        }

        void onBootPhase(int phase) {
            if (phase == 500) {
                this.mDeviceIdleController = IDeviceIdleController.Stub.asInterface(ServiceManager.getService("deviceidle"));
                this.mBatteryStats = IBatteryStats.Stub.asInterface(ServiceManager.getService("batterystats"));
                this.mPackageManagerInternal = LocalServices.getService(PackageManagerInternal.class);
                this.mDisplayManager = (DisplayManager)this.mContext.getSystemService("display");
                this.mPowerManager = this.mContext.getSystemService(PowerManager.class);
            }
            this.mBootPhase = phase;
        }

        int getBootPhase() {
            return this.mBootPhase;
        }

        long elapsedRealtime() {
            return SystemClock.elapsedRealtime();
        }

        long currentTimeMillis() {
            return System.currentTimeMillis();
        }

        boolean isAppIdleEnabled() {
            boolean buildFlag = this.mContext.getResources().getBoolean(17891432);
            boolean runtimeFlag = Settings.Global.getInt(this.mContext.getContentResolver(), "app_standby_enabled", 1) == 1 && Settings.Global.getInt(this.mContext.getContentResolver(), "adaptive_battery_management_enabled", 1) == 1;
            return buildFlag && runtimeFlag;
        }

        boolean isCharging() {
            return this.mContext.getSystemService(BatteryManager.class).isCharging();
        }

        boolean isPowerSaveWhitelistExceptIdleApp(String packageName) throws RemoteException {
            return this.mDeviceIdleController.isPowerSaveWhitelistExceptIdleApp(packageName);
        }

        File getDataSystemDirectory() {
            return Environment.getDataSystemDirectory();
        }

        void noteEvent(int event, String packageName, int uid) throws RemoteException {
            this.mBatteryStats.noteEvent(event, packageName, uid);
        }

        boolean isPackageEphemeral(int userId, String packageName) {
            return this.mPackageManagerInternal.isPackageEphemeral(userId, packageName);
        }

        boolean isPackageInstalled(String packageName, int flags, int userId) {
            return this.mPackageManagerInternal.getPackageUid(packageName, flags, userId) >= 0;
        }

        int[] getRunningUserIds() throws RemoteException {
            return ActivityManager.getService().getRunningUserIds();
        }

        boolean isDefaultDisplayOn() {
            return this.mDisplayManager.getDisplay(0).getState() == 2;
        }

        void registerDisplayListener(DisplayManager.DisplayListener listener, Handler handler) {
            this.mDisplayManager.registerDisplayListener(listener, handler);
        }

        String getActiveNetworkScorer() {
            NetworkScoreManager nsm = (NetworkScoreManager)this.mContext.getSystemService("network_score");
            return nsm.getActiveScorerPackage();
        }

        public boolean isBoundWidgetPackage(AppWidgetManager appWidgetManager, String packageName, int userId) {
            return appWidgetManager.isBoundWidgetPackage(packageName, userId);
        }

        String getAppIdleSettings() {
            return Settings.Global.getString(this.mContext.getContentResolver(), "app_idle_constants");
        }

        public boolean isDeviceIdleMode() {
            return this.mPowerManager.isDeviceIdleMode();
        }
    }

    private class PackageReceiver
    extends BroadcastReceiver {
        private PackageReceiver() {
        }

        @Override
        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if ("android.intent.action.PACKAGE_ADDED".equals(action) || "android.intent.action.PACKAGE_CHANGED".equals(action)) {
                AppStandbyController.this.clearCarrierPrivilegedApps();
            }
            if (("android.intent.action.PACKAGE_REMOVED".equals(action) || "android.intent.action.PACKAGE_ADDED".equals(action)) && !intent.getBooleanExtra("android.intent.extra.REPLACING", false)) {
                AppStandbyController.this.clearAppIdleForPackage(intent.getData().getSchemeSpecificPart(), this.getSendingUserId());
            }
        }
    }

    public static class StandbyUpdateRecord {
        String packageName;
        int userId;
        int bucket;
        boolean isUserInteraction;
        int reason;

        StandbyUpdateRecord(String pkgName, int userId, int bucket, int reason, boolean isInteraction) {
            this.packageName = pkgName;
            this.userId = userId;
            this.bucket = bucket;
            this.reason = reason;
            this.isUserInteraction = isInteraction;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static StandbyUpdateRecord obtain(String pkgName, int userId, int bucket, int reason, boolean isInteraction) {
            ArrayList<StandbyUpdateRecord> arrayList = sStandbyUpdatePool;
            synchronized (arrayList) {
                int size = sStandbyUpdatePool.size();
                if (size < 1) {
                    return new StandbyUpdateRecord(pkgName, userId, bucket, reason, isInteraction);
                }
                StandbyUpdateRecord r = sStandbyUpdatePool.remove(size - 1);
                r.packageName = pkgName;
                r.userId = userId;
                r.bucket = bucket;
                r.reason = reason;
                r.isUserInteraction = isInteraction;
                return r;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void recycle() {
            ArrayList<StandbyUpdateRecord> arrayList = sStandbyUpdatePool;
            synchronized (arrayList) {
                sStandbyUpdatePool.add(this);
            }
        }
    }

    static class Lock {
        Lock() {
        }
    }
}

