/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.usage;

import android.app.PendingIntent;
import android.app.usage.UsageStatsManagerInternal;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.SystemClock;
import android.os.UserHandle;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.Slog;
import android.util.SparseArray;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import java.io.PrintWriter;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;

public class AppTimeLimitController {
    private static final String TAG = "AppTimeLimitController";
    private static final boolean DEBUG = false;
    private final Lock mLock = new Lock();
    private final MyHandler mHandler;
    private TimeLimitCallbackListener mListener;
    private static final long MAX_OBSERVER_PER_UID = 1000L;
    private static final long ONE_MINUTE = 60000L;
    private static final Integer ONE = new Integer(1);
    @GuardedBy(value={"mLock"})
    private final SparseArray<UserData> mUsers = new SparseArray();
    @GuardedBy(value={"mLock"})
    private final SparseArray<ObserverAppData> mObserverApps = new SparseArray();

    public AppTimeLimitController(TimeLimitCallbackListener listener, Looper looper) {
        this.mHandler = new MyHandler(looper);
        this.mListener = listener;
    }

    @VisibleForTesting
    protected long getUptimeMillis() {
        return SystemClock.uptimeMillis();
    }

    @VisibleForTesting
    protected long getAppUsageObserverPerUidLimit() {
        return 1000L;
    }

    @VisibleForTesting
    protected long getUsageSessionObserverPerUidLimit() {
        return 1000L;
    }

    @VisibleForTesting
    protected long getAppUsageLimitObserverPerUidLimit() {
        return 1000L;
    }

    @VisibleForTesting
    protected long getMinTimeLimit() {
        return 60000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    AppUsageGroup getAppUsageGroup(int observerAppUid, int observerId) {
        Lock lock = this.mLock;
        synchronized (lock) {
            return this.getOrCreateObserverAppDataLocked((int)observerAppUid).appUsageGroups.get(observerId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    SessionUsageGroup getSessionUsageGroup(int observerAppUid, int observerId) {
        Lock lock = this.mLock;
        synchronized (lock) {
            return this.getOrCreateObserverAppDataLocked((int)observerAppUid).sessionUsageGroups.get(observerId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    AppUsageLimitGroup getAppUsageLimitGroup(int observerAppUid, int observerId) {
        Lock lock = this.mLock;
        synchronized (lock) {
            return this.getOrCreateObserverAppDataLocked((int)observerAppUid).appUsageLimitGroups.get(observerId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UsageStatsManagerInternal.AppUsageLimitData getAppUsageLimit(String packageName, UserHandle user) {
        Lock lock = this.mLock;
        synchronized (lock) {
            UserData userData = this.getOrCreateUserDataLocked(user.getIdentifier());
            if (userData == null) {
                return null;
            }
            ArrayList<UsageGroup> usageGroups = userData.observedMap.get(packageName);
            if (usageGroups == null || usageGroups.isEmpty()) {
                return null;
            }
            ArraySet<AppUsageLimitGroup> usageLimitGroups = new ArraySet<AppUsageLimitGroup>();
            block3: for (int i = 0; i < usageGroups.size(); ++i) {
                if (!(usageGroups.get(i) instanceof AppUsageLimitGroup)) continue;
                AppUsageLimitGroup group = (AppUsageLimitGroup)usageGroups.get(i);
                for (int j = 0; j < group.mObserved.length; ++j) {
                    if (!group.mObserved[j].equals(packageName)) continue;
                    usageLimitGroups.add(group);
                    continue block3;
                }
            }
            if (usageLimitGroups.isEmpty()) {
                return null;
            }
            AppUsageLimitGroup smallestGroup = (AppUsageLimitGroup)usageLimitGroups.valueAt(0);
            for (int i = 1; i < usageLimitGroups.size(); ++i) {
                AppUsageLimitGroup otherGroup = (AppUsageLimitGroup)usageLimitGroups.valueAt(i);
                if (otherGroup.getUsageRemaining() >= smallestGroup.getUsageRemaining()) continue;
                smallestGroup = otherGroup;
            }
            return new UsageStatsManagerInternal.AppUsageLimitData(smallestGroup.getTotaUsageLimit(), smallestGroup.getUsageRemaining());
        }
    }

    @GuardedBy(value={"mLock"})
    private UserData getOrCreateUserDataLocked(int userId) {
        UserData userData = this.mUsers.get(userId);
        if (userData == null) {
            userData = new UserData(userId);
            this.mUsers.put(userId, userData);
        }
        return userData;
    }

    @GuardedBy(value={"mLock"})
    private ObserverAppData getOrCreateObserverAppDataLocked(int uid) {
        ObserverAppData appData = this.mObserverApps.get(uid);
        if (appData == null) {
            appData = new ObserverAppData(uid);
            this.mObserverApps.put(uid, appData);
        }
        return appData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onUserRemoved(int userId) {
        Lock lock = this.mLock;
        synchronized (lock) {
            this.mUsers.remove(userId);
        }
    }

    @GuardedBy(value={"mLock"})
    private void noteActiveLocked(UserData user, UsageGroup group, long currentTimeMs) {
        int size = group.mObserved.length;
        for (int i = 0; i < size; ++i) {
            if (!user.currentlyActive.containsKey(group.mObserved[i])) continue;
            group.noteUsageStart(currentTimeMs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAppUsageObserver(int requestingUid, int observerId, String[] observed, long timeLimit, PendingIntent callbackIntent, int userId) {
        if (timeLimit < this.getMinTimeLimit()) {
            throw new IllegalArgumentException("Time limit must be >= " + this.getMinTimeLimit());
        }
        Lock lock = this.mLock;
        synchronized (lock) {
            int observerIdCount;
            UserData user = this.getOrCreateUserDataLocked(userId);
            ObserverAppData observerApp = this.getOrCreateObserverAppDataLocked(requestingUid);
            AppUsageGroup group = observerApp.appUsageGroups.get(observerId);
            if (group != null) {
                group.remove();
            }
            if ((long)(observerIdCount = observerApp.appUsageGroups.size()) >= this.getAppUsageObserverPerUidLimit()) {
                throw new IllegalStateException("Too many app usage observers added by uid " + requestingUid);
            }
            group = new AppUsageGroup(user, observerApp, observerId, observed, timeLimit, callbackIntent);
            observerApp.appUsageGroups.append(observerId, group);
            user.addUsageGroup(group);
            this.noteActiveLocked(user, group, this.getUptimeMillis());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAppUsageObserver(int requestingUid, int observerId, int userId) {
        Lock lock = this.mLock;
        synchronized (lock) {
            ObserverAppData observerApp = this.getOrCreateObserverAppDataLocked(requestingUid);
            AppUsageGroup group = observerApp.appUsageGroups.get(observerId);
            if (group != null) {
                group.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addUsageSessionObserver(int requestingUid, int observerId, String[] observed, long timeLimit, long sessionThresholdTime, PendingIntent limitReachedCallbackIntent, PendingIntent sessionEndCallbackIntent, int userId) {
        if (timeLimit < this.getMinTimeLimit()) {
            throw new IllegalArgumentException("Time limit must be >= " + this.getMinTimeLimit());
        }
        Lock lock = this.mLock;
        synchronized (lock) {
            int observerIdCount;
            UserData user = this.getOrCreateUserDataLocked(userId);
            ObserverAppData observerApp = this.getOrCreateObserverAppDataLocked(requestingUid);
            SessionUsageGroup group = observerApp.sessionUsageGroups.get(observerId);
            if (group != null) {
                group.remove();
            }
            if ((long)(observerIdCount = observerApp.sessionUsageGroups.size()) >= this.getUsageSessionObserverPerUidLimit()) {
                throw new IllegalStateException("Too many app usage observers added by uid " + requestingUid);
            }
            group = new SessionUsageGroup(user, observerApp, observerId, observed, timeLimit, limitReachedCallbackIntent, sessionThresholdTime, sessionEndCallbackIntent);
            observerApp.sessionUsageGroups.append(observerId, group);
            user.addUsageGroup(group);
            this.noteActiveLocked(user, group, this.getUptimeMillis());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeUsageSessionObserver(int requestingUid, int observerId, int userId) {
        Lock lock = this.mLock;
        synchronized (lock) {
            ObserverAppData observerApp = this.getOrCreateObserverAppDataLocked(requestingUid);
            SessionUsageGroup group = observerApp.sessionUsageGroups.get(observerId);
            if (group != null) {
                group.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAppUsageLimitObserver(int requestingUid, int observerId, String[] observed, long timeLimit, long timeUsed, PendingIntent callbackIntent, int userId) {
        if (timeLimit < this.getMinTimeLimit()) {
            throw new IllegalArgumentException("Time limit must be >= " + this.getMinTimeLimit());
        }
        Lock lock = this.mLock;
        synchronized (lock) {
            int observerIdCount;
            UserData user = this.getOrCreateUserDataLocked(userId);
            ObserverAppData observerApp = this.getOrCreateObserverAppDataLocked(requestingUid);
            AppUsageLimitGroup group = observerApp.appUsageLimitGroups.get(observerId);
            if (group != null) {
                group.remove();
            }
            if ((long)(observerIdCount = observerApp.appUsageLimitGroups.size()) >= this.getAppUsageLimitObserverPerUidLimit()) {
                throw new IllegalStateException("Too many app usage observers added by uid " + requestingUid);
            }
            group = new AppUsageLimitGroup(user, observerApp, observerId, observed, timeLimit, timeUsed, timeUsed >= timeLimit ? null : callbackIntent);
            observerApp.appUsageLimitGroups.append(observerId, group);
            user.addUsageGroup(group);
            this.noteActiveLocked(user, group, this.getUptimeMillis());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAppUsageLimitObserver(int requestingUid, int observerId, int userId) {
        Lock lock = this.mLock;
        synchronized (lock) {
            ObserverAppData observerApp = this.getOrCreateObserverAppDataLocked(requestingUid);
            AppUsageLimitGroup group = observerApp.appUsageLimitGroups.get(observerId);
            if (group != null) {
                group.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void noteUsageStart(String name, int userId, long timeAgoMs) throws IllegalArgumentException {
        Lock lock = this.mLock;
        synchronized (lock) {
            Integer count;
            UserData user = this.getOrCreateUserDataLocked(userId);
            int index = user.currentlyActive.indexOfKey(name);
            if (index >= 0 && (count = user.currentlyActive.valueAt(index)) != null) {
                user.currentlyActive.setValueAt(index, count + 1);
                return;
            }
            long currentTime = this.getUptimeMillis();
            user.currentlyActive.put(name, ONE);
            ArrayList<UsageGroup> groups = user.observedMap.get(name);
            if (groups == null) {
                return;
            }
            int size = groups.size();
            for (int i = 0; i < size; ++i) {
                UsageGroup group = groups.get(i);
                group.noteUsageStart(currentTime - timeAgoMs, currentTime);
            }
        }
    }

    public void noteUsageStart(String name, int userId) throws IllegalArgumentException {
        this.noteUsageStart(name, userId, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void noteUsageStop(String name, int userId) throws IllegalArgumentException {
        Lock lock = this.mLock;
        synchronized (lock) {
            UserData user = this.getOrCreateUserDataLocked(userId);
            int index = user.currentlyActive.indexOfKey(name);
            if (index < 0) {
                throw new IllegalArgumentException("Unable to stop usage for " + name + ", not in use");
            }
            Integer count = user.currentlyActive.valueAt(index);
            if (!count.equals(ONE)) {
                user.currentlyActive.setValueAt(index, count - 1);
                return;
            }
            user.currentlyActive.removeAt(index);
            long currentTime = this.getUptimeMillis();
            ArrayList<UsageGroup> groups = user.observedMap.get(name);
            if (groups == null) {
                return;
            }
            int size = groups.size();
            for (int i = 0; i < size; ++i) {
                UsageGroup group = groups.get(i);
                group.noteUsageStop(currentTime);
            }
        }
    }

    @GuardedBy(value={"mLock"})
    private void postInformLimitReachedListenerLocked(UsageGroup group) {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(2, group));
    }

    @GuardedBy(value={"mLock"})
    private void postInformSessionEndListenerLocked(SessionUsageGroup group, long timeout) {
        this.mHandler.sendMessageDelayed(this.mHandler.obtainMessage(3, group), timeout);
    }

    @GuardedBy(value={"mLock"})
    private void cancelInformSessionEndListener(SessionUsageGroup group) {
        this.mHandler.removeMessages(3, group);
    }

    @GuardedBy(value={"mLock"})
    private void postCheckTimeoutLocked(UsageGroup group, long timeout) {
        this.mHandler.sendMessageDelayed(this.mHandler.obtainMessage(1, group), timeout);
    }

    @GuardedBy(value={"mLock"})
    private void cancelCheckTimeoutLocked(UsageGroup group) {
        this.mHandler.removeMessages(1, group);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dump(String[] args, PrintWriter pw) {
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                String arg = args[i];
                if (!"actives".equals(arg)) continue;
                Lock lock = this.mLock;
                synchronized (lock) {
                    int nUsers = this.mUsers.size();
                    for (int user = 0; user < nUsers; ++user) {
                        ArrayMap<String, Integer> actives = this.mUsers.valueAt((int)user).currentlyActive;
                        int nActive = actives.size();
                        for (int active = 0; active < nActive; ++active) {
                            pw.println(actives.keyAt(active));
                        }
                    }
                }
                return;
            }
        }
        Lock lock = this.mLock;
        synchronized (lock) {
            pw.println("\n  App Time Limits");
            int nUsers = this.mUsers.size();
            for (int i = 0; i < nUsers; ++i) {
                pw.print("   User ");
                this.mUsers.valueAt(i).dump(pw);
            }
            pw.println();
            int nObserverApps = this.mObserverApps.size();
            for (int i = 0; i < nObserverApps; ++i) {
                pw.print("   Observer App ");
                this.mObserverApps.valueAt(i).dump(pw);
            }
        }
    }

    private class MyHandler
    extends Handler {
        static final int MSG_CHECK_TIMEOUT = 1;
        static final int MSG_INFORM_LIMIT_REACHED_LISTENER = 2;
        static final int MSG_INFORM_SESSION_END = 3;

        MyHandler(Looper looper) {
            super(looper);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    Lock lock = AppTimeLimitController.this.mLock;
                    synchronized (lock) {
                        ((UsageGroup)msg.obj).checkTimeout(AppTimeLimitController.this.getUptimeMillis());
                        break;
                    }
                }
                case 2: {
                    Lock lock = AppTimeLimitController.this.mLock;
                    synchronized (lock) {
                        ((UsageGroup)msg.obj).onLimitReached();
                        break;
                    }
                }
                case 3: {
                    Lock lock = AppTimeLimitController.this.mLock;
                    synchronized (lock) {
                        ((SessionUsageGroup)msg.obj).onSessionEnd();
                        break;
                    }
                }
                default: {
                    super.handleMessage(msg);
                }
            }
        }
    }

    class AppUsageLimitGroup
    extends UsageGroup {
        public AppUsageLimitGroup(UserData user, ObserverAppData observerApp, int observerId, String[] observed, long timeLimitMs, long timeUsedMs, PendingIntent limitReachedCallback) {
            super(user, observerApp, observerId, observed, timeLimitMs, limitReachedCallback);
            this.mUsageTimeMs = timeUsedMs;
        }

        @Override
        @GuardedBy(value={"mLock"})
        public void remove() {
            super.remove();
            ObserverAppData observerApp = (ObserverAppData)this.mObserverAppRef.get();
            if (observerApp != null) {
                observerApp.removeAppUsageLimitGroup(this.mObserverId);
            }
        }

        @GuardedBy(value={"mLock"})
        long getTotaUsageLimit() {
            return this.mTimeLimitMs;
        }

        @GuardedBy(value={"mLock"})
        long getUsageRemaining() {
            if (this.mActives > 0) {
                return this.mTimeLimitMs - this.mUsageTimeMs - (AppTimeLimitController.this.getUptimeMillis() - this.mLastKnownUsageTimeMs);
            }
            return this.mTimeLimitMs - this.mUsageTimeMs;
        }
    }

    class SessionUsageGroup
    extends UsageGroup {
        private long mNewSessionThresholdMs;
        private PendingIntent mSessionEndCallback;

        public SessionUsageGroup(UserData user, ObserverAppData observerApp, int observerId, String[] observed, long timeLimitMs, PendingIntent limitReachedCallback, long newSessionThresholdMs, PendingIntent sessionEndCallback) {
            super(user, observerApp, observerId, observed, timeLimitMs, limitReachedCallback);
            this.mNewSessionThresholdMs = newSessionThresholdMs;
            this.mSessionEndCallback = sessionEndCallback;
        }

        @Override
        @GuardedBy(value={"mLock"})
        public void remove() {
            super.remove();
            ObserverAppData observerApp = (ObserverAppData)this.mObserverAppRef.get();
            if (observerApp != null) {
                observerApp.removeSessionUsageGroup(this.mObserverId);
            }
            this.mSessionEndCallback = null;
        }

        @Override
        @GuardedBy(value={"mLock"})
        public void noteUsageStart(long startTimeMs, long currentTimeMs) {
            if (this.mActives == 0) {
                if (startTimeMs - this.mLastUsageEndTimeMs > this.mNewSessionThresholdMs) {
                    this.mUsageTimeMs = 0L;
                }
                AppTimeLimitController.this.cancelInformSessionEndListener(this);
            }
            super.noteUsageStart(startTimeMs, currentTimeMs);
        }

        @Override
        @GuardedBy(value={"mLock"})
        public void noteUsageStop(long stopTimeMs) {
            super.noteUsageStop(stopTimeMs);
            if (this.mActives == 0 && this.mUsageTimeMs >= this.mTimeLimitMs) {
                AppTimeLimitController.this.postInformSessionEndListenerLocked(this, this.mNewSessionThresholdMs);
            }
        }

        @GuardedBy(value={"mLock"})
        public void onSessionEnd() {
            UserData user = (UserData)this.mUserRef.get();
            if (user == null) {
                return;
            }
            if (AppTimeLimitController.this.mListener != null) {
                AppTimeLimitController.this.mListener.onSessionEnd(this.mObserverId, user.userId, this.mUsageTimeMs, this.mSessionEndCallback);
            }
        }

        @Override
        @GuardedBy(value={"mLock"})
        void dump(PrintWriter pw) {
            super.dump(pw);
            pw.print(" lastUsageEndTime=");
            pw.print(this.mLastUsageEndTimeMs);
            pw.print(" newSessionThreshold=");
            pw.print(this.mNewSessionThresholdMs);
        }
    }

    class AppUsageGroup
    extends UsageGroup {
        public AppUsageGroup(UserData user, ObserverAppData observerApp, int observerId, String[] observed, long timeLimitMs, PendingIntent limitReachedCallback) {
            super(user, observerApp, observerId, observed, timeLimitMs, limitReachedCallback);
        }

        @Override
        @GuardedBy(value={"mLock"})
        public void remove() {
            super.remove();
            ObserverAppData observerApp = (ObserverAppData)this.mObserverAppRef.get();
            if (observerApp != null) {
                observerApp.removeAppUsageGroup(this.mObserverId);
            }
        }

        @Override
        @GuardedBy(value={"mLock"})
        public void onLimitReached() {
            super.onLimitReached();
            this.remove();
        }
    }

    abstract class UsageGroup {
        protected int mObserverId;
        protected String[] mObserved;
        protected long mTimeLimitMs;
        protected long mUsageTimeMs;
        protected int mActives;
        protected long mLastKnownUsageTimeMs;
        protected long mLastUsageEndTimeMs;
        protected WeakReference<UserData> mUserRef;
        protected WeakReference<ObserverAppData> mObserverAppRef;
        protected PendingIntent mLimitReachedCallback;

        UsageGroup(UserData user, ObserverAppData observerApp, int observerId, String[] observed, long timeLimitMs, PendingIntent limitReachedCallback) {
            this.mUserRef = new WeakReference<UserData>(user);
            this.mObserverAppRef = new WeakReference<ObserverAppData>(observerApp);
            this.mObserverId = observerId;
            this.mObserved = observed;
            this.mTimeLimitMs = timeLimitMs;
            this.mLimitReachedCallback = limitReachedCallback;
        }

        @GuardedBy(value={"mLock"})
        public long getTimeLimitMs() {
            return this.mTimeLimitMs;
        }

        @GuardedBy(value={"mLock"})
        public long getUsageTimeMs() {
            return this.mUsageTimeMs;
        }

        @GuardedBy(value={"mLock"})
        public void remove() {
            UserData user = (UserData)this.mUserRef.get();
            if (user != null) {
                user.removeUsageGroup(this);
            }
            this.mLimitReachedCallback = null;
        }

        @GuardedBy(value={"mLock"})
        void noteUsageStart(long startTimeMs) {
            this.noteUsageStart(startTimeMs, startTimeMs);
        }

        @GuardedBy(value={"mLock"})
        void noteUsageStart(long startTimeMs, long currentTimeMs) {
            if (this.mActives++ == 0) {
                this.mLastKnownUsageTimeMs = startTimeMs = this.mLastUsageEndTimeMs > startTimeMs ? this.mLastUsageEndTimeMs : startTimeMs;
                long timeRemaining = this.mTimeLimitMs - this.mUsageTimeMs - currentTimeMs + startTimeMs;
                if (timeRemaining > 0L) {
                    AppTimeLimitController.this.postCheckTimeoutLocked(this, timeRemaining);
                }
            } else if (this.mActives > this.mObserved.length) {
                this.mActives = this.mObserved.length;
                UserData user = (UserData)this.mUserRef.get();
                if (user == null) {
                    return;
                }
                Object[] array2 = user.currentlyActive.keySet().toArray();
                Slog.e(AppTimeLimitController.TAG, "Too many noted usage starts! Observed entities: " + Arrays.toString(this.mObserved) + "   Active Entities: " + Arrays.toString(array2));
            }
        }

        @GuardedBy(value={"mLock"})
        void noteUsageStop(long stopTimeMs) {
            if (--this.mActives == 0) {
                boolean limitNotCrossed = this.mUsageTimeMs < this.mTimeLimitMs;
                this.mUsageTimeMs += stopTimeMs - this.mLastKnownUsageTimeMs;
                this.mLastUsageEndTimeMs = stopTimeMs;
                if (limitNotCrossed && this.mUsageTimeMs >= this.mTimeLimitMs) {
                    AppTimeLimitController.this.postInformLimitReachedListenerLocked(this);
                }
                AppTimeLimitController.this.cancelCheckTimeoutLocked(this);
            } else if (this.mActives < 0) {
                this.mActives = 0;
                UserData user = (UserData)this.mUserRef.get();
                if (user == null) {
                    return;
                }
                Object[] array2 = user.currentlyActive.keySet().toArray();
                Slog.e(AppTimeLimitController.TAG, "Too many noted usage stops! Observed entities: " + Arrays.toString(this.mObserved) + "   Active Entities: " + Arrays.toString(array2));
            }
        }

        @GuardedBy(value={"mLock"})
        void checkTimeout(long currentTimeMs) {
            UserData user = (UserData)this.mUserRef.get();
            if (user == null) {
                return;
            }
            long timeRemainingMs = this.mTimeLimitMs - this.mUsageTimeMs;
            if (timeRemainingMs <= 0L) {
                return;
            }
            if (user.isActive(this.mObserved)) {
                long timeUsedMs = currentTimeMs - this.mLastKnownUsageTimeMs;
                if (timeRemainingMs <= timeUsedMs) {
                    this.mUsageTimeMs += timeUsedMs;
                    this.mLastKnownUsageTimeMs = currentTimeMs;
                    AppTimeLimitController.this.postInformLimitReachedListenerLocked(this);
                } else {
                    AppTimeLimitController.this.postCheckTimeoutLocked(this, timeRemainingMs - timeUsedMs);
                }
            }
        }

        @GuardedBy(value={"mLock"})
        public void onLimitReached() {
            UserData user = (UserData)this.mUserRef.get();
            if (user == null) {
                return;
            }
            if (AppTimeLimitController.this.mListener != null) {
                AppTimeLimitController.this.mListener.onLimitReached(this.mObserverId, user.userId, this.mTimeLimitMs, this.mUsageTimeMs, this.mLimitReachedCallback);
            }
        }

        @GuardedBy(value={"mLock"})
        void dump(PrintWriter pw) {
            pw.print("        Group id=");
            pw.print(this.mObserverId);
            pw.print(" timeLimit=");
            pw.print(this.mTimeLimitMs);
            pw.print(" used=");
            pw.print(this.mUsageTimeMs);
            pw.print(" lastKnownUsage=");
            pw.print(this.mLastKnownUsageTimeMs);
            pw.print(" mActives=");
            pw.print(this.mActives);
            pw.print(" observed=");
            pw.print(Arrays.toString(this.mObserved));
        }
    }

    public static interface TimeLimitCallbackListener {
        public void onLimitReached(int var1, int var2, long var3, long var5, PendingIntent var7);

        public void onSessionEnd(int var1, int var2, long var3, PendingIntent var5);
    }

    private class ObserverAppData {
        private int uid;
        SparseArray<AppUsageGroup> appUsageGroups = new SparseArray();
        SparseArray<SessionUsageGroup> sessionUsageGroups = new SparseArray();
        SparseArray<AppUsageLimitGroup> appUsageLimitGroups = new SparseArray();

        private ObserverAppData(int uid) {
            this.uid = uid;
        }

        @GuardedBy(value={"mLock"})
        void removeAppUsageGroup(int observerId) {
            this.appUsageGroups.remove(observerId);
        }

        @GuardedBy(value={"mLock"})
        void removeSessionUsageGroup(int observerId) {
            this.sessionUsageGroups.remove(observerId);
        }

        @GuardedBy(value={"mLock"})
        void removeAppUsageLimitGroup(int observerId) {
            this.appUsageLimitGroups.remove(observerId);
        }

        @GuardedBy(value={"mLock"})
        void dump(PrintWriter pw) {
            pw.print(" uid=");
            pw.println(this.uid);
            pw.println("    App Usage Groups:");
            int nAppUsageGroups = this.appUsageGroups.size();
            for (int i = 0; i < nAppUsageGroups; ++i) {
                this.appUsageGroups.valueAt(i).dump(pw);
                pw.println();
            }
            pw.println("    Session Usage Groups:");
            int nSessionUsageGroups = this.sessionUsageGroups.size();
            for (int i = 0; i < nSessionUsageGroups; ++i) {
                this.sessionUsageGroups.valueAt(i).dump(pw);
                pw.println();
            }
            pw.println("    App Usage Limit Groups:");
            int nAppUsageLimitGroups = this.appUsageLimitGroups.size();
            for (int i = 0; i < nAppUsageLimitGroups; ++i) {
                this.appUsageLimitGroups.valueAt(i).dump(pw);
                pw.println();
            }
        }
    }

    private class UserData {
        private int userId;
        public final ArrayMap<String, Integer> currentlyActive = new ArrayMap();
        public final ArrayMap<String, ArrayList<UsageGroup>> observedMap = new ArrayMap();

        private UserData(int userId) {
            this.userId = userId;
        }

        @GuardedBy(value={"mLock"})
        boolean isActive(String[] entities) {
            int size = entities.length;
            for (int i = 0; i < size; ++i) {
                if (!this.currentlyActive.containsKey(entities[i])) continue;
                return true;
            }
            return false;
        }

        @GuardedBy(value={"mLock"})
        void addUsageGroup(UsageGroup group) {
            int size = group.mObserved.length;
            for (int i = 0; i < size; ++i) {
                ArrayList<UsageGroup> list = this.observedMap.get(group.mObserved[i]);
                if (list == null) {
                    list = new ArrayList();
                    this.observedMap.put(group.mObserved[i], list);
                }
                list.add(group);
            }
        }

        @GuardedBy(value={"mLock"})
        void removeUsageGroup(UsageGroup group) {
            for (String observed : group.mObserved) {
                ArrayList<UsageGroup> list = this.observedMap.get(observed);
                if (list == null) continue;
                list.remove(group);
                if (!list.isEmpty()) continue;
                this.observedMap.remove(observed);
            }
        }

        @GuardedBy(value={"mLock"})
        void dump(PrintWriter pw) {
            pw.print(" userId=");
            pw.println(this.userId);
            pw.print(" Currently Active:");
            int nActive = this.currentlyActive.size();
            for (int i = 0; i < nActive; ++i) {
                pw.print(this.currentlyActive.keyAt(i));
                pw.print(", ");
            }
            pw.println();
            pw.print(" Observed Entities:");
            int nEntities = this.observedMap.size();
            for (int i = 0; i < nEntities; ++i) {
                pw.print(this.observedMap.keyAt(i));
                pw.print(", ");
            }
            pw.println();
        }
    }

    private static class Lock {
        private Lock() {
        }
    }
}

