/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.usage;

import android.app.usage.ConfigurationStats;
import android.app.usage.EventList;
import android.app.usage.EventStats;
import android.app.usage.UsageEvents;
import android.app.usage.UsageStats;
import android.content.res.Configuration;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.proto.ProtoInputStream;
import com.android.internal.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.List;

public class IntervalStats {
    public static final int CURRENT_MAJOR_VERSION = 1;
    public static final int CURRENT_MINOR_VERSION = 1;
    public int majorVersion = 1;
    public int minorVersion = 1;
    public long beginTime;
    public long endTime;
    public long lastTimeSaved;
    public final EventTracker interactiveTracker = new EventTracker();
    public final EventTracker nonInteractiveTracker = new EventTracker();
    public final EventTracker keyguardShownTracker = new EventTracker();
    public final EventTracker keyguardHiddenTracker = new EventTracker();
    public final ArrayMap<String, UsageStats> packageStats = new ArrayMap();
    public final ArrayMap<Configuration, ConfigurationStats> configurations = new ArrayMap();
    public Configuration activeConfiguration;
    public final EventList events = new EventList();
    public final ArraySet<String> mStringCache = new ArraySet();

    UsageStats getOrCreateUsageStats(String packageName) {
        UsageStats usageStats = this.packageStats.get(packageName);
        if (usageStats == null) {
            usageStats = new UsageStats();
            usageStats.mPackageName = this.getCachedStringRef(packageName);
            usageStats.mBeginTimeStamp = this.beginTime;
            usageStats.mEndTimeStamp = this.endTime;
            this.packageStats.put(usageStats.mPackageName, usageStats);
        }
        return usageStats;
    }

    ConfigurationStats getOrCreateConfigurationStats(Configuration config) {
        ConfigurationStats configStats = this.configurations.get(config);
        if (configStats == null) {
            configStats = new ConfigurationStats();
            configStats.mBeginTimeStamp = this.beginTime;
            configStats.mEndTimeStamp = this.endTime;
            configStats.mConfiguration = config;
            this.configurations.put(config, configStats);
        }
        return configStats;
    }

    UsageEvents.Event buildEvent(String packageName, String className) {
        UsageEvents.Event event = new UsageEvents.Event();
        event.mPackage = this.getCachedStringRef(packageName);
        if (className != null) {
            event.mClass = this.getCachedStringRef(className);
        }
        return event;
    }

    UsageEvents.Event buildEvent(ProtoInputStream parser, List<String> stringPool) throws IOException {
        UsageEvents.Event event = new UsageEvents.Event();
        while (true) {
            switch (parser.nextField()) {
                case 1: {
                    event.mPackage = this.getCachedStringRef(parser.readString(0x10900000001L));
                    break;
                }
                case 2: {
                    event.mPackage = this.getCachedStringRef(stringPool.get(parser.readInt(1120986464258L) - 1));
                    break;
                }
                case 3: {
                    event.mClass = this.getCachedStringRef(parser.readString(1138166333443L));
                    break;
                }
                case 4: {
                    event.mClass = this.getCachedStringRef(stringPool.get(parser.readInt(1120986464260L) - 1));
                    break;
                }
                case 5: {
                    event.mTimeStamp = this.beginTime + parser.readLong(1112396529669L);
                    break;
                }
                case 6: {
                    event.mFlags = parser.readInt(1120986464262L);
                    break;
                }
                case 7: {
                    event.mEventType = parser.readInt(1120986464263L);
                    break;
                }
                case 8: {
                    event.mConfiguration = new Configuration();
                    event.mConfiguration.readFromProto(parser, 1146756268040L);
                    break;
                }
                case 9: {
                    event.mShortcutId = parser.readString(0x10900000009L).intern();
                    break;
                }
                case 11: {
                    event.mBucketAndReason = parser.readInt(1120986464267L);
                    break;
                }
                case 12: {
                    event.mNotificationChannelId = parser.readString(1138166333452L);
                    break;
                }
                case 13: {
                    event.mNotificationChannelId = this.getCachedStringRef(stringPool.get(parser.readInt(1120986464269L) - 1));
                    break;
                }
                case 14: {
                    event.mInstanceId = parser.readInt(1120986464270L);
                    break;
                }
                case 15: {
                    event.mTaskRootPackage = this.getCachedStringRef(stringPool.get(parser.readInt(1120986464271L) - 1));
                    break;
                }
                case 16: {
                    event.mTaskRootClass = this.getCachedStringRef(stringPool.get(parser.readInt(0x10500000010L) - 1));
                    break;
                }
                case -1: {
                    switch (event.mEventType) {
                        case 5: {
                            if (event.mConfiguration != null) break;
                            event.mConfiguration = new Configuration();
                            break;
                        }
                        case 8: {
                            if (event.mShortcutId != null) break;
                            event.mShortcutId = "";
                            break;
                        }
                        case 12: {
                            if (event.mNotificationChannelId != null) break;
                            event.mNotificationChannelId = "";
                        }
                    }
                    if (event.mTimeStamp == 0L) {
                        event.mTimeStamp = this.beginTime;
                    }
                    return event;
                }
            }
        }
    }

    private boolean isStatefulEvent(int eventType) {
        switch (eventType) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 26: {
                return true;
            }
        }
        return false;
    }

    private boolean isUserVisibleEvent(int eventType) {
        return eventType != 6 && eventType != 11;
    }

    @VisibleForTesting
    public void update(String packageName, String className, long timeStamp, int eventType, int instanceId) {
        if (eventType == 26 || eventType == 25) {
            int size = this.packageStats.size();
            for (int i = 0; i < size; ++i) {
                UsageStats usageStats = this.packageStats.valueAt(i);
                usageStats.update(null, timeStamp, eventType, instanceId);
            }
        } else {
            UsageStats usageStats = this.getOrCreateUsageStats(packageName);
            usageStats.update(className, timeStamp, eventType, instanceId);
        }
        if (timeStamp > this.endTime) {
            this.endTime = timeStamp;
        }
    }

    @VisibleForTesting
    public void addEvent(UsageEvents.Event event) {
        event.mPackage = this.getCachedStringRef(event.mPackage);
        if (event.mClass != null) {
            event.mClass = this.getCachedStringRef(event.mClass);
        }
        if (event.mTaskRootPackage != null) {
            event.mTaskRootPackage = this.getCachedStringRef(event.mTaskRootPackage);
        }
        if (event.mTaskRootClass != null) {
            event.mTaskRootClass = this.getCachedStringRef(event.mTaskRootClass);
        }
        if (event.mEventType == 12) {
            event.mNotificationChannelId = this.getCachedStringRef(event.mNotificationChannelId);
        }
        this.events.insert(event);
        if (event.mTimeStamp > this.endTime) {
            this.endTime = event.mTimeStamp;
        }
    }

    void updateChooserCounts(String packageName, String category, String action) {
        ArrayMap<Object, Object> chooserCounts;
        int idx;
        UsageStats usageStats = this.getOrCreateUsageStats(packageName);
        if (usageStats.mChooserCounts == null) {
            usageStats.mChooserCounts = new ArrayMap();
        }
        if ((idx = usageStats.mChooserCounts.indexOfKey(action)) < 0) {
            chooserCounts = new ArrayMap();
            usageStats.mChooserCounts.put(action, chooserCounts);
        } else {
            chooserCounts = usageStats.mChooserCounts.valueAt(idx);
        }
        int currentCount = chooserCounts.getOrDefault(category, 0);
        chooserCounts.put(category, currentCount + 1);
    }

    void updateConfigurationStats(Configuration config, long timeStamp) {
        if (this.activeConfiguration != null) {
            ConfigurationStats activeStats = this.configurations.get(this.activeConfiguration);
            activeStats.mTotalTimeActive += timeStamp - activeStats.mLastTimeActive;
            activeStats.mLastTimeActive = timeStamp - 1L;
        }
        if (config != null) {
            ConfigurationStats configStats = this.getOrCreateConfigurationStats(config);
            configStats.mLastTimeActive = timeStamp;
            ++configStats.mActivationCount;
            this.activeConfiguration = configStats.mConfiguration;
        }
        if (timeStamp > this.endTime) {
            this.endTime = timeStamp;
        }
    }

    void incrementAppLaunchCount(String packageName) {
        UsageStats usageStats = this.getOrCreateUsageStats(packageName);
        ++usageStats.mAppLaunchCount;
    }

    void commitTime(long timeStamp) {
        this.interactiveTracker.commitTime(timeStamp);
        this.nonInteractiveTracker.commitTime(timeStamp);
        this.keyguardShownTracker.commitTime(timeStamp);
        this.keyguardHiddenTracker.commitTime(timeStamp);
    }

    void updateScreenInteractive(long timeStamp) {
        this.interactiveTracker.update(timeStamp);
        this.nonInteractiveTracker.commitTime(timeStamp);
    }

    void updateScreenNonInteractive(long timeStamp) {
        this.nonInteractiveTracker.update(timeStamp);
        this.interactiveTracker.commitTime(timeStamp);
    }

    void updateKeyguardShown(long timeStamp) {
        this.keyguardShownTracker.update(timeStamp);
        this.keyguardHiddenTracker.commitTime(timeStamp);
    }

    void updateKeyguardHidden(long timeStamp) {
        this.keyguardHiddenTracker.update(timeStamp);
        this.keyguardShownTracker.commitTime(timeStamp);
    }

    void addEventStatsTo(List<EventStats> out) {
        this.interactiveTracker.addToEventStats(out, 15, this.beginTime, this.endTime);
        this.nonInteractiveTracker.addToEventStats(out, 16, this.beginTime, this.endTime);
        this.keyguardShownTracker.addToEventStats(out, 17, this.beginTime, this.endTime);
        this.keyguardHiddenTracker.addToEventStats(out, 18, this.beginTime, this.endTime);
    }

    private String getCachedStringRef(String str) {
        int index = this.mStringCache.indexOf(str);
        if (index < 0) {
            this.mStringCache.add(str);
            return str;
        }
        return this.mStringCache.valueAt(index);
    }

    void upgradeIfNeeded() {
        if (this.majorVersion >= 1) {
            return;
        }
        this.majorVersion = 1;
    }

    public static final class EventTracker {
        public long curStartTime;
        public long lastEventTime;
        public long duration;
        public int count;

        public void commitTime(long timeStamp) {
            if (this.curStartTime != 0L) {
                this.duration += timeStamp - this.curStartTime;
                this.curStartTime = 0L;
            }
        }

        public void update(long timeStamp) {
            if (this.curStartTime == 0L) {
                ++this.count;
            }
            this.commitTime(timeStamp);
            this.curStartTime = timeStamp;
            this.lastEventTime = timeStamp;
        }

        void addToEventStats(List<EventStats> out, int event, long beginTime, long endTime) {
            if (this.count != 0 || this.duration != 0L) {
                EventStats ev = new EventStats();
                ev.mEventType = event;
                ev.mCount = this.count;
                ev.mTotalTime = this.duration;
                ev.mLastEventTime = this.lastEventTime;
                ev.mBeginTimeStamp = beginTime;
                ev.mEndTimeStamp = endTime;
                out.add(ev);
            }
        }
    }
}

