/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.usage;

import android.app.usage.TimeSparseArray;
import android.app.usage.UsageStats;
import android.os.Build;
import android.os.SystemProperties;
import android.util.AtomicFile;
import android.util.Slog;
import android.util.TimeUtils;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.util.IndentingPrintWriter;
import com.android.server.usage.IntervalStats;
import com.android.server.usage.UnixCalendar;
import com.android.server.usage.UsageStatsProto;
import com.android.server.usage.UsageStatsXml;
import com.android.server.usage.UserUsageStatsService;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.List;
import libcore.io.IoUtils;

public class UsageStatsDatabase {
    private static final int DEFAULT_CURRENT_VERSION = 4;
    @VisibleForTesting
    public static final int BACKUP_VERSION = 4;
    @VisibleForTesting
    static final int[] MAX_FILES_PER_INTERVAL_TYPE = new int[]{100, 50, 12, 10};
    static final String KEY_USAGE_STATS = "usage_stats";
    static final boolean KEEP_BACKUP_DIR = false;
    private static final String TAG = "UsageStatsDatabase";
    private static final boolean DEBUG = false;
    private static final String BAK_SUFFIX = ".bak";
    private static final String CHECKED_IN_SUFFIX = "-c";
    private static final String RETENTION_LEN_KEY = "ro.usagestats.chooser.retention";
    private static final int SELECTION_LOG_RETENTION_LEN = SystemProperties.getInt("ro.usagestats.chooser.retention", 14);
    private final Object mLock = new Object();
    private final File[] mIntervalDirs;
    @VisibleForTesting
    final TimeSparseArray<AtomicFile>[] mSortedStatFiles;
    private final UnixCalendar mCal;
    private final File mVersionFile;
    private final File mBackupsDir;
    private final File mUpdateBreadcrumb;
    private int mCurrentVersion;
    private boolean mFirstUpdate;
    private boolean mNewUpdate;

    @VisibleForTesting
    public UsageStatsDatabase(File dir, int version) {
        this.mIntervalDirs = new File[]{new File(dir, "daily"), new File(dir, "weekly"), new File(dir, "monthly"), new File(dir, "yearly")};
        this.mCurrentVersion = version;
        this.mVersionFile = new File(dir, "version");
        this.mBackupsDir = new File(dir, "backups");
        this.mUpdateBreadcrumb = new File(dir, "breadcrumb");
        this.mSortedStatFiles = new TimeSparseArray[this.mIntervalDirs.length];
        this.mCal = new UnixCalendar(0L);
    }

    public UsageStatsDatabase(File dir) {
        this(dir, 4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(long currentTimeMillis) {
        Object object = this.mLock;
        synchronized (object) {
            for (File f : this.mIntervalDirs) {
                f.mkdirs();
                if (f.exists()) continue;
                throw new IllegalStateException("Failed to create directory " + f.getAbsolutePath());
            }
            this.checkVersionAndBuildLocked();
            this.indexFilesLocked();
            for (TimeSparseArray<AtomicFile> files : this.mSortedStatFiles) {
                int i;
                int startIndex = files.closestIndexOnOrAfter(currentTimeMillis);
                if (startIndex < 0) continue;
                int fileCount = files.size();
                for (i = startIndex; i < fileCount; ++i) {
                    ((AtomicFile)files.valueAt(i)).delete();
                }
                for (i = startIndex; i < fileCount; ++i) {
                    files.removeAt(i);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkinDailyFiles(CheckinAction checkinAction) {
        Object object = this.mLock;
        synchronized (object) {
            TimeSparseArray<AtomicFile> files = this.mSortedStatFiles[0];
            int fileCount = files.size();
            int lastCheckin = -1;
            for (int i = 0; i < fileCount - 1; ++i) {
                if (!((AtomicFile)files.valueAt(i)).getBaseFile().getPath().endsWith(CHECKED_IN_SUFFIX)) continue;
                lastCheckin = i;
            }
            int start = lastCheckin + 1;
            if (start == fileCount - 1) {
                return true;
            }
            try {
                IntervalStats stats = new IntervalStats();
                for (int i = start; i < fileCount - 1; ++i) {
                    this.readLocked((AtomicFile)files.valueAt(i), stats);
                    if (checkinAction.checkin(stats)) continue;
                    return false;
                }
            }
            catch (IOException e) {
                Slog.e(TAG, "Failed to check-in", e);
                return false;
            }
            for (int i = start; i < fileCount - 1; ++i) {
                AtomicFile file = (AtomicFile)files.valueAt(i);
                File checkedInFile = new File(file.getBaseFile().getPath() + CHECKED_IN_SUFFIX);
                if (!file.getBaseFile().renameTo(checkedInFile)) {
                    Slog.e(TAG, "Failed to mark file " + file.getBaseFile().getPath() + " as checked-in");
                    return true;
                }
                files.setValueAt(i, new AtomicFile(checkedInFile));
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void forceIndexFiles() {
        Object object = this.mLock;
        synchronized (object) {
            this.indexFilesLocked();
        }
    }

    private void indexFilesLocked() {
        FilenameFilter backupFileFilter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return !name.endsWith(UsageStatsDatabase.BAK_SUFFIX);
            }
        };
        for (int i = 0; i < this.mSortedStatFiles.length; ++i) {
            if (this.mSortedStatFiles[i] == null) {
                this.mSortedStatFiles[i] = new TimeSparseArray();
            } else {
                this.mSortedStatFiles[i].clear();
            }
            File[] files = this.mIntervalDirs[i].listFiles(backupFileFilter);
            if (files == null) continue;
            for (File f : files) {
                AtomicFile af = new AtomicFile(f);
                try {
                    this.mSortedStatFiles[i].put(UsageStatsDatabase.parseBeginTime(af), af);
                }
                catch (IOException e) {
                    Slog.e(TAG, "failed to index file: " + f, e);
                }
            }
            int toDelete = this.mSortedStatFiles[i].size() - MAX_FILES_PER_INTERVAL_TYPE[i];
            if (toDelete <= 0) continue;
            for (int j = 0; j < toDelete; ++j) {
                ((AtomicFile)this.mSortedStatFiles[i].valueAt(0)).delete();
                this.mSortedStatFiles[i].removeAt(0);
            }
            Slog.d(TAG, "Deleted " + toDelete + " stat files for interval " + i);
        }
    }

    boolean isFirstUpdate() {
        return this.mFirstUpdate;
    }

    boolean isNewUpdate() {
        return this.mNewUpdate;
    }

    private void checkVersionAndBuildLocked() {
        int version;
        String currentFingerprint = this.getBuildFingerprint();
        this.mFirstUpdate = true;
        this.mNewUpdate = true;
        try (BufferedReader reader = new BufferedReader(new FileReader(this.mVersionFile));){
            version = Integer.parseInt(reader.readLine());
            String buildFingerprint = reader.readLine();
            if (buildFingerprint != null) {
                this.mFirstUpdate = false;
            }
            if (currentFingerprint.equals(buildFingerprint)) {
                this.mNewUpdate = false;
            }
        }
        catch (IOException | NumberFormatException e) {
            version = 0;
        }
        if (version != this.mCurrentVersion) {
            Slog.i(TAG, "Upgrading from version " + version + " to " + this.mCurrentVersion);
            if (!this.mUpdateBreadcrumb.exists()) {
                try {
                    this.doUpgradeLocked(version);
                }
                catch (Exception e) {
                    Slog.e(TAG, "Failed to upgrade from version " + version + " to " + this.mCurrentVersion, e);
                    this.mCurrentVersion = version;
                    return;
                }
            } else {
                Slog.i(TAG, "Version upgrade breadcrumb found on disk! Continuing version upgrade");
            }
        }
        if (this.mUpdateBreadcrumb.exists()) {
            int previousVersion;
            long token;
            try (BufferedReader reader = new BufferedReader(new FileReader(this.mUpdateBreadcrumb));){
                token = Long.parseLong(reader.readLine());
                previousVersion = Integer.parseInt(reader.readLine());
            }
            catch (IOException | NumberFormatException e) {
                Slog.e(TAG, "Failed read version upgrade breadcrumb");
                throw new RuntimeException(e);
            }
            this.continueUpgradeLocked(previousVersion, token);
        }
        if (version != this.mCurrentVersion || this.mNewUpdate) {
            try (BufferedWriter writer = new BufferedWriter(new FileWriter(this.mVersionFile));){
                writer.write(Integer.toString(this.mCurrentVersion));
                writer.write("\n");
                writer.write(currentFingerprint);
                writer.write("\n");
                writer.flush();
            }
            catch (IOException e) {
                Slog.e(TAG, "Failed to write new version");
                throw new RuntimeException(e);
            }
        }
        if (this.mUpdateBreadcrumb.exists()) {
            this.mUpdateBreadcrumb.delete();
        }
        if (this.mBackupsDir.exists()) {
            UsageStatsDatabase.deleteDirectory(this.mBackupsDir);
        }
    }

    private String getBuildFingerprint() {
        return Build.VERSION.RELEASE + ";" + Build.VERSION.CODENAME + ";" + Build.VERSION.INCREMENTAL;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void doUpgradeLocked(int thisVersion) {
        if (thisVersion < 2) {
            Slog.i(TAG, "Deleting all usage stats files");
            for (int i = 0; i < this.mIntervalDirs.length; ++i) {
                File[] files = this.mIntervalDirs[i].listFiles();
                if (files == null) continue;
                for (File f : files) {
                    f.delete();
                }
            }
            return;
        }
        long token = System.currentTimeMillis();
        File backupDir = new File(this.mBackupsDir, Long.toString(token));
        backupDir.mkdirs();
        if (!backupDir.exists()) {
            throw new IllegalStateException("Failed to create backup directory " + backupDir.getAbsolutePath());
        }
        try {
            Files.copy(this.mVersionFile.toPath(), new File(backupDir, this.mVersionFile.getName()).toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            Slog.e(TAG, "Failed to back up version file : " + this.mVersionFile.toString());
            throw new RuntimeException(e);
        }
        for (int i = 0; i < this.mIntervalDirs.length; ++i) {
            File backupIntervalDir = new File(backupDir, this.mIntervalDirs[i].getName());
            backupIntervalDir.mkdir();
            if (!backupIntervalDir.exists()) {
                throw new IllegalStateException("Failed to create interval backup directory " + backupIntervalDir.getAbsolutePath());
            }
            File[] files = this.mIntervalDirs[i].listFiles();
            if (files == null) continue;
            for (int j = 0; j < files.length; ++j) {
                File backupFile = new File(backupIntervalDir, files[j].getName());
                try {
                    Files.move(files[j].toPath(), backupFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                    continue;
                }
                catch (IOException e) {
                    Slog.e(TAG, "Failed to back up file : " + files[j].toString());
                    throw new RuntimeException(e);
                }
            }
        }
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new FileWriter(this.mUpdateBreadcrumb));
            writer.write(Long.toString(token));
            writer.write("\n");
            writer.write(Integer.toString(thisVersion));
            writer.write("\n");
            writer.flush();
        }
        catch (IOException e) {
            try {
                Slog.e(TAG, "Failed to write new version upgrade breadcrumb");
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                IoUtils.closeQuietly(writer);
                throw throwable;
            }
        }
        IoUtils.closeQuietly(writer);
        return;
    }

    private void continueUpgradeLocked(int version, long token) {
        File backupDir = new File(this.mBackupsDir, Long.toString(token));
        for (int i = 0; i < this.mIntervalDirs.length; ++i) {
            File backedUpInterval = new File(backupDir, this.mIntervalDirs[i].getName());
            File[] files = backedUpInterval.listFiles();
            if (files == null) continue;
            for (int j = 0; j < files.length; ++j) {
                try {
                    IntervalStats stats = new IntervalStats();
                    UsageStatsDatabase.readLocked(new AtomicFile(files[j]), stats, version);
                    UsageStatsDatabase.writeLocked(new AtomicFile(new File(this.mIntervalDirs[i], Long.toString(stats.beginTime))), stats, this.mCurrentVersion);
                    continue;
                }
                catch (Exception e) {
                    Slog.e(TAG, "Failed to upgrade backup file : " + files[j].toString());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onTimeChanged(long timeDiffMillis) {
        Object object = this.mLock;
        synchronized (object) {
            StringBuilder logBuilder = new StringBuilder();
            logBuilder.append("Time changed by ");
            TimeUtils.formatDuration(timeDiffMillis, logBuilder);
            logBuilder.append(".");
            int filesDeleted = 0;
            int filesMoved = 0;
            for (TimeSparseArray<AtomicFile> files : this.mSortedStatFiles) {
                int fileCount = files.size();
                for (int i = 0; i < fileCount; ++i) {
                    AtomicFile file = (AtomicFile)files.valueAt(i);
                    long newTime = files.keyAt(i) + timeDiffMillis;
                    if (newTime < 0L) {
                        ++filesDeleted;
                        file.delete();
                        continue;
                    }
                    try {
                        file.openRead().close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    String newName = Long.toString(newTime);
                    if (file.getBaseFile().getName().endsWith(CHECKED_IN_SUFFIX)) {
                        newName = newName + CHECKED_IN_SUFFIX;
                    }
                    File newFile = new File(file.getBaseFile().getParentFile(), newName);
                    ++filesMoved;
                    file.getBaseFile().renameTo(newFile);
                }
                files.clear();
            }
            logBuilder.append(" files deleted: ").append(filesDeleted);
            logBuilder.append(" files moved: ").append(filesMoved);
            Slog.i(TAG, logBuilder.toString());
            this.indexFilesLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IntervalStats getLatestUsageStats(int intervalType) {
        Object object = this.mLock;
        synchronized (object) {
            if (intervalType < 0 || intervalType >= this.mIntervalDirs.length) {
                throw new IllegalArgumentException("Bad interval type " + intervalType);
            }
            int fileCount = this.mSortedStatFiles[intervalType].size();
            if (fileCount == 0) {
                return null;
            }
            try {
                AtomicFile f = (AtomicFile)this.mSortedStatFiles[intervalType].valueAt(fileCount - 1);
                IntervalStats stats = new IntervalStats();
                this.readLocked(f, stats);
                return stats;
            }
            catch (IOException e) {
                Slog.e(TAG, "Failed to read usage stats file", e);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> List<T> queryUsageStats(int intervalType, long beginTime, long endTime, StatCombiner<T> combiner) {
        Object object = this.mLock;
        synchronized (object) {
            int endIndex;
            if (intervalType < 0 || intervalType >= this.mIntervalDirs.length) {
                throw new IllegalArgumentException("Bad interval type " + intervalType);
            }
            TimeSparseArray<AtomicFile> intervalStats = this.mSortedStatFiles[intervalType];
            if (endTime <= beginTime) {
                return null;
            }
            int startIndex = intervalStats.closestIndexOnOrBefore(beginTime);
            if (startIndex < 0) {
                startIndex = 0;
            }
            if ((endIndex = intervalStats.closestIndexOnOrBefore(endTime)) < 0) {
                return null;
            }
            if (intervalStats.keyAt(endIndex) == endTime && --endIndex < 0) {
                return null;
            }
            IntervalStats stats = new IntervalStats();
            ArrayList results = new ArrayList();
            for (int i = startIndex; i <= endIndex; ++i) {
                AtomicFile f = (AtomicFile)intervalStats.valueAt(i);
                try {
                    this.readLocked(f, stats);
                    if (beginTime >= stats.endTime) continue;
                    combiner.combine(stats, false, results);
                    continue;
                }
                catch (IOException e) {
                    Slog.e(TAG, "Failed to read usage stats file", e);
                }
            }
            return results;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int findBestFitBucket(long beginTimeStamp, long endTimeStamp) {
        Object object = this.mLock;
        synchronized (object) {
            int bestBucket = -1;
            long smallestDiff = Long.MAX_VALUE;
            for (int i = this.mSortedStatFiles.length - 1; i >= 0; --i) {
                long diff;
                int index = this.mSortedStatFiles[i].closestIndexOnOrBefore(beginTimeStamp);
                int size = this.mSortedStatFiles[i].size();
                if (index < 0 || index >= size || (diff = Math.abs(this.mSortedStatFiles[i].keyAt(index) - beginTimeStamp)) >= smallestDiff) continue;
                smallestDiff = diff;
                bestBucket = i;
            }
            return bestBucket;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prune(long currentTimeMillis) {
        Object object = this.mLock;
        synchronized (object) {
            this.mCal.setTimeInMillis(currentTimeMillis);
            this.mCal.addYears(-3);
            UsageStatsDatabase.pruneFilesOlderThan(this.mIntervalDirs[3], this.mCal.getTimeInMillis());
            this.mCal.setTimeInMillis(currentTimeMillis);
            this.mCal.addMonths(-6);
            UsageStatsDatabase.pruneFilesOlderThan(this.mIntervalDirs[2], this.mCal.getTimeInMillis());
            this.mCal.setTimeInMillis(currentTimeMillis);
            this.mCal.addWeeks(-4);
            UsageStatsDatabase.pruneFilesOlderThan(this.mIntervalDirs[1], this.mCal.getTimeInMillis());
            this.mCal.setTimeInMillis(currentTimeMillis);
            this.mCal.addDays(-10);
            UsageStatsDatabase.pruneFilesOlderThan(this.mIntervalDirs[0], this.mCal.getTimeInMillis());
            this.mCal.setTimeInMillis(currentTimeMillis);
            this.mCal.addDays(-SELECTION_LOG_RETENTION_LEN);
            for (int i = 0; i < this.mIntervalDirs.length; ++i) {
                this.pruneChooserCountsOlderThan(this.mIntervalDirs[i], this.mCal.getTimeInMillis());
            }
            this.indexFilesLocked();
        }
    }

    private static void pruneFilesOlderThan(File dir, long expiryTime) {
        File[] files = dir.listFiles();
        if (files != null) {
            for (File f : files) {
                long beginTime;
                try {
                    beginTime = UsageStatsDatabase.parseBeginTime(f);
                }
                catch (IOException e) {
                    beginTime = 0L;
                }
                if (beginTime >= expiryTime) continue;
                new AtomicFile(f).delete();
            }
        }
    }

    private void pruneChooserCountsOlderThan(File dir, long expiryTime) {
        File[] files = dir.listFiles();
        if (files != null) {
            for (File f : files) {
                long beginTime;
                try {
                    beginTime = UsageStatsDatabase.parseBeginTime(f);
                }
                catch (IOException e) {
                    beginTime = 0L;
                }
                if (beginTime >= expiryTime) continue;
                try {
                    AtomicFile af = new AtomicFile(f);
                    IntervalStats stats = new IntervalStats();
                    this.readLocked(af, stats);
                    int pkgCount = stats.packageStats.size();
                    for (int i = 0; i < pkgCount; ++i) {
                        UsageStats pkgStats = stats.packageStats.valueAt(i);
                        if (pkgStats.mChooserCounts == null) continue;
                        pkgStats.mChooserCounts.clear();
                    }
                    this.writeLocked(af, stats);
                }
                catch (Exception e) {
                    Slog.e(TAG, "Failed to delete chooser counts from usage stats file", e);
                }
            }
        }
    }

    private static long parseBeginTime(AtomicFile file) throws IOException {
        return UsageStatsDatabase.parseBeginTime(file.getBaseFile());
    }

    private static long parseBeginTime(File file) throws IOException {
        String name = file.getName();
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (c >= '0' && c <= '9') continue;
            name = name.substring(0, i);
            break;
        }
        try {
            return Long.parseLong(name);
        }
        catch (NumberFormatException e) {
            throw new IOException(e);
        }
    }

    private void writeLocked(AtomicFile file, IntervalStats stats) throws IOException {
        UsageStatsDatabase.writeLocked(file, stats, this.mCurrentVersion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeLocked(AtomicFile file, IntervalStats stats, int version) throws IOException {
        FileOutputStream fos = file.startWrite();
        try {
            UsageStatsDatabase.writeLocked(fos, stats, version);
            file.finishWrite(fos);
            fos = null;
        }
        finally {
            file.failWrite(fos);
        }
    }

    private void writeLocked(OutputStream out, IntervalStats stats) throws IOException {
        UsageStatsDatabase.writeLocked(out, stats, this.mCurrentVersion);
    }

    private static void writeLocked(OutputStream out, IntervalStats stats, int version) throws IOException {
        switch (version) {
            case 1: 
            case 2: 
            case 3: {
                UsageStatsXml.write(out, stats);
                break;
            }
            case 4: {
                UsageStatsProto.write(out, stats);
                break;
            }
            default: {
                throw new RuntimeException("Unhandled UsageStatsDatabase version: " + Integer.toString(version) + " on write.");
            }
        }
    }

    private void readLocked(AtomicFile file, IntervalStats statsOut) throws IOException {
        UsageStatsDatabase.readLocked(file, statsOut, this.mCurrentVersion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void readLocked(AtomicFile file, IntervalStats statsOut, int version) throws IOException {
        try {
            FileInputStream in = file.openRead();
            try {
                statsOut.beginTime = UsageStatsDatabase.parseBeginTime(file);
                UsageStatsDatabase.readLocked(in, statsOut, version);
                statsOut.lastTimeSaved = file.getLastModifiedTime();
            }
            finally {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
        catch (FileNotFoundException e) {
            Slog.e(TAG, TAG, e);
            throw e;
        }
    }

    private void readLocked(InputStream in, IntervalStats statsOut) throws IOException {
        UsageStatsDatabase.readLocked(in, statsOut, this.mCurrentVersion);
    }

    private static void readLocked(InputStream in, IntervalStats statsOut, int version) throws IOException {
        switch (version) {
            case 1: 
            case 2: 
            case 3: {
                UsageStatsXml.read(in, statsOut);
                break;
            }
            case 4: {
                UsageStatsProto.read(in, statsOut);
                break;
            }
            default: {
                throw new RuntimeException("Unhandled UsageStatsDatabase version: " + Integer.toString(version) + " on read.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putUsageStats(int intervalType, IntervalStats stats) throws IOException {
        if (stats == null) {
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            if (intervalType < 0 || intervalType >= this.mIntervalDirs.length) {
                throw new IllegalArgumentException("Bad interval type " + intervalType);
            }
            AtomicFile f = (AtomicFile)this.mSortedStatFiles[intervalType].get(stats.beginTime);
            if (f == null) {
                f = new AtomicFile(new File(this.mIntervalDirs[intervalType], Long.toString(stats.beginTime)));
                this.mSortedStatFiles[intervalType].put(stats.beginTime, f);
            }
            this.writeLocked(f, stats);
            stats.lastTimeSaved = f.getLastModifiedTime();
        }
    }

    byte[] getBackupPayload(String key) {
        return this.getBackupPayload(key, 4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public byte[] getBackupPayload(String key, int version) {
        Object object = this.mLock;
        synchronized (object) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            if (KEY_USAGE_STATS.equals(key)) {
                this.prune(System.currentTimeMillis());
                DataOutputStream out = new DataOutputStream(baos);
                try {
                    int i;
                    out.writeInt(version);
                    out.writeInt(this.mSortedStatFiles[0].size());
                    for (i = 0; i < this.mSortedStatFiles[0].size(); ++i) {
                        this.writeIntervalStatsToStream(out, (AtomicFile)this.mSortedStatFiles[0].valueAt(i), version);
                    }
                    out.writeInt(this.mSortedStatFiles[1].size());
                    for (i = 0; i < this.mSortedStatFiles[1].size(); ++i) {
                        this.writeIntervalStatsToStream(out, (AtomicFile)this.mSortedStatFiles[1].valueAt(i), version);
                    }
                    out.writeInt(this.mSortedStatFiles[2].size());
                    for (i = 0; i < this.mSortedStatFiles[2].size(); ++i) {
                        this.writeIntervalStatsToStream(out, (AtomicFile)this.mSortedStatFiles[2].valueAt(i), version);
                    }
                    out.writeInt(this.mSortedStatFiles[3].size());
                    for (i = 0; i < this.mSortedStatFiles[3].size(); ++i) {
                        this.writeIntervalStatsToStream(out, (AtomicFile)this.mSortedStatFiles[3].valueAt(i), version);
                    }
                }
                catch (IOException ioe) {
                    Slog.d(TAG, "Failed to write data to output stream", ioe);
                    baos.reset();
                }
            }
            return baos.toByteArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public void applyRestoredPayload(String key, byte[] payload) {
        Object object = this.mLock;
        synchronized (object) {
            if (KEY_USAGE_STATS.equals(key)) {
                IntervalStats dailyConfigSource = this.getLatestUsageStats(0);
                IntervalStats weeklyConfigSource = this.getLatestUsageStats(1);
                IntervalStats monthlyConfigSource = this.getLatestUsageStats(2);
                IntervalStats yearlyConfigSource = this.getLatestUsageStats(3);
                try {
                    IntervalStats stats;
                    int i;
                    DataInputStream in = new DataInputStream(new ByteArrayInputStream(payload));
                    int backupDataVersion = in.readInt();
                    if (backupDataVersion < 1 || backupDataVersion > 4) {
                        return;
                    }
                    for (int i2 = 0; i2 < this.mIntervalDirs.length; ++i2) {
                        UsageStatsDatabase.deleteDirectoryContents(this.mIntervalDirs[i2]);
                    }
                    int fileCount = in.readInt();
                    for (i = 0; i < fileCount; ++i) {
                        stats = this.deserializeIntervalStats(UsageStatsDatabase.getIntervalStatsBytes(in), backupDataVersion);
                        stats = this.mergeStats(stats, dailyConfigSource);
                        this.putUsageStats(0, stats);
                    }
                    fileCount = in.readInt();
                    for (i = 0; i < fileCount; ++i) {
                        stats = this.deserializeIntervalStats(UsageStatsDatabase.getIntervalStatsBytes(in), backupDataVersion);
                        stats = this.mergeStats(stats, weeklyConfigSource);
                        this.putUsageStats(1, stats);
                    }
                    fileCount = in.readInt();
                    for (i = 0; i < fileCount; ++i) {
                        stats = this.deserializeIntervalStats(UsageStatsDatabase.getIntervalStatsBytes(in), backupDataVersion);
                        stats = this.mergeStats(stats, monthlyConfigSource);
                        this.putUsageStats(2, stats);
                    }
                    fileCount = in.readInt();
                    for (i = 0; i < fileCount; ++i) {
                        stats = this.deserializeIntervalStats(UsageStatsDatabase.getIntervalStatsBytes(in), backupDataVersion);
                        stats = this.mergeStats(stats, yearlyConfigSource);
                        this.putUsageStats(3, stats);
                    }
                }
                catch (IOException ioe) {
                    Slog.d(TAG, "Failed to read data from input stream", ioe);
                }
                finally {
                    this.indexFilesLocked();
                }
            }
        }
    }

    private IntervalStats mergeStats(IntervalStats beingRestored, IntervalStats onDevice) {
        if (onDevice == null) {
            return beingRestored;
        }
        if (beingRestored == null) {
            return null;
        }
        beingRestored.activeConfiguration = onDevice.activeConfiguration;
        beingRestored.configurations.putAll(onDevice.configurations);
        beingRestored.events.clear();
        beingRestored.events.merge(onDevice.events);
        return beingRestored;
    }

    private void writeIntervalStatsToStream(DataOutputStream out, AtomicFile statsFile, int version) throws IOException {
        IntervalStats stats = new IntervalStats();
        try {
            this.readLocked(statsFile, stats);
        }
        catch (IOException e) {
            Slog.e(TAG, "Failed to read usage stats file", e);
            out.writeInt(0);
            return;
        }
        UsageStatsDatabase.sanitizeIntervalStatsForBackup(stats);
        byte[] data = this.serializeIntervalStats(stats, version);
        out.writeInt(data.length);
        out.write(data);
    }

    private static byte[] getIntervalStatsBytes(DataInputStream in) throws IOException {
        int length = in.readInt();
        byte[] buffer = new byte[length];
        in.read(buffer, 0, length);
        return buffer;
    }

    private static void sanitizeIntervalStatsForBackup(IntervalStats stats) {
        if (stats == null) {
            return;
        }
        stats.activeConfiguration = null;
        stats.configurations.clear();
        stats.events.clear();
    }

    private byte[] serializeIntervalStats(IntervalStats stats, int version) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(baos);
        try {
            out.writeLong(stats.beginTime);
            UsageStatsDatabase.writeLocked(out, stats, version);
        }
        catch (Exception ioe) {
            Slog.d(TAG, "Serializing IntervalStats Failed", ioe);
            baos.reset();
        }
        return baos.toByteArray();
    }

    private IntervalStats deserializeIntervalStats(byte[] data, int version) {
        ByteArrayInputStream bais = new ByteArrayInputStream(data);
        DataInputStream in = new DataInputStream(bais);
        IntervalStats stats = new IntervalStats();
        try {
            stats.beginTime = in.readLong();
            UsageStatsDatabase.readLocked(in, stats, version);
        }
        catch (IOException ioe) {
            Slog.d(TAG, "DeSerializing IntervalStats Failed", ioe);
            stats = null;
        }
        return stats;
    }

    private static void deleteDirectoryContents(File directory) {
        File[] files;
        for (File file : files = directory.listFiles()) {
            UsageStatsDatabase.deleteDirectory(file);
        }
    }

    private static void deleteDirectory(File directory) {
        File[] files = directory.listFiles();
        if (files != null) {
            for (File file : files) {
                if (!file.isDirectory()) {
                    file.delete();
                    continue;
                }
                UsageStatsDatabase.deleteDirectory(file);
            }
        }
        directory.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump(IndentingPrintWriter pw, boolean compact) {
        Object object = this.mLock;
        synchronized (object) {
            pw.println("UsageStatsDatabase:");
            pw.increaseIndent();
            for (int i = 0; i < this.mSortedStatFiles.length; ++i) {
                TimeSparseArray<AtomicFile> files = this.mSortedStatFiles[i];
                int size = files.size();
                pw.print(UserUsageStatsService.intervalToString(i));
                pw.print(" stats files: ");
                pw.print(size);
                pw.println(", sorted list of files:");
                pw.increaseIndent();
                for (int f = 0; f < size; ++f) {
                    long fileName = files.keyAt(f);
                    if (compact) {
                        pw.print(UserUsageStatsService.formatDateTime(fileName, false));
                    } else {
                        pw.printPair(Long.toString(fileName), UserUsageStatsService.formatDateTime(fileName, true));
                    }
                    pw.println();
                }
                pw.decreaseIndent();
            }
            pw.decreaseIndent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IntervalStats readIntervalStatsForFile(int interval, long fileName) {
        Object object = this.mLock;
        synchronized (object) {
            IntervalStats stats = new IntervalStats();
            try {
                this.readLocked((AtomicFile)this.mSortedStatFiles[interval].get(fileName, null), stats);
                return stats;
            }
            catch (Exception e) {
                return null;
            }
        }
    }

    public static interface StatCombiner<T> {
        public void combine(IntervalStats var1, boolean var2, List<T> var3);
    }

    public static interface CheckinAction {
        public boolean checkin(IntervalStats var1);
    }
}

