/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.usage;

import android.app.usage.ConfigurationStats;
import android.app.usage.UsageEvents;
import android.app.usage.UsageStats;
import android.content.res.Configuration;
import android.util.ArrayMap;
import android.util.Slog;
import android.util.proto.ProtoInputStream;
import android.util.proto.ProtoOutputStream;
import com.android.server.usage.IntervalStats;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ProtocolException;
import java.util.ArrayList;
import java.util.List;

final class UsageStatsProto {
    private static String TAG = "UsageStatsProto";

    private UsageStatsProto() {
    }

    private static List<String> readStringPool(ProtoInputStream proto) throws IOException {
        long token = proto.start(1146756268034L);
        ArrayList<String> stringPool = proto.isNextField(0x10500000001L) ? new ArrayList(proto.readInt(0x10500000001L)) : new ArrayList<String>();
        while (proto.nextField() != -1) {
            switch (proto.getFieldNumber()) {
                case 2: {
                    stringPool.add(proto.readString(0x20900000002L));
                }
            }
        }
        proto.end(token);
        return stringPool;
    }

    private static void loadUsageStats(ProtoInputStream proto, long fieldId, IntervalStats statsOut, List<String> stringPool) throws IOException {
        long token = proto.start(fieldId);
        UsageStats stats = proto.isNextField(1120986464258L) ? statsOut.getOrCreateUsageStats(stringPool.get(proto.readInt(1120986464258L) - 1)) : (proto.isNextField(0x10900000001L) ? statsOut.getOrCreateUsageStats(proto.readString(0x10900000001L)) : new UsageStats());
        while (proto.nextField() != -1) {
            switch (proto.getFieldNumber()) {
                case 1: {
                    UsageStats tempPackage = statsOut.getOrCreateUsageStats(proto.readString(0x10900000001L));
                    tempPackage.mLastTimeUsed = stats.mLastTimeUsed;
                    tempPackage.mTotalTimeInForeground = stats.mTotalTimeInForeground;
                    tempPackage.mLastEvent = stats.mLastEvent;
                    tempPackage.mAppLaunchCount = stats.mAppLaunchCount;
                    stats = tempPackage;
                    break;
                }
                case 2: {
                    UsageStats tempPackageIndex = statsOut.getOrCreateUsageStats(stringPool.get(proto.readInt(1120986464258L) - 1));
                    tempPackageIndex.mLastTimeUsed = stats.mLastTimeUsed;
                    tempPackageIndex.mTotalTimeInForeground = stats.mTotalTimeInForeground;
                    tempPackageIndex.mLastEvent = stats.mLastEvent;
                    tempPackageIndex.mAppLaunchCount = stats.mAppLaunchCount;
                    stats = tempPackageIndex;
                    break;
                }
                case 3: {
                    stats.mLastTimeUsed = statsOut.beginTime + proto.readLong(0x10300000003L);
                    break;
                }
                case 4: {
                    stats.mTotalTimeInForeground = proto.readLong(1112396529668L);
                    break;
                }
                case 5: {
                    stats.mLastEvent = proto.readInt(0x10500000005L);
                    break;
                }
                case 6: {
                    stats.mAppLaunchCount = proto.readInt(1120986464262L);
                    break;
                }
                case 7: {
                    long chooserToken = proto.start(2246267895815L);
                    UsageStatsProto.loadChooserCounts(proto, stats);
                    proto.end(chooserToken);
                    break;
                }
                case 8: {
                    stats.mLastTimeForegroundServiceUsed = statsOut.beginTime + proto.readLong(1112396529672L);
                    break;
                }
                case 9: {
                    stats.mTotalTimeForegroundServiceUsed = proto.readLong(1112396529673L);
                    break;
                }
                case 10: {
                    stats.mLastTimeVisible = statsOut.beginTime + proto.readLong(1112396529674L);
                    break;
                }
                case 11: {
                    stats.mTotalTimeVisible = proto.readLong(1112396529675L);
                }
            }
        }
        if (stats.mLastTimeUsed == 0L) {
            stats.mLastTimeUsed = statsOut.beginTime;
        }
        proto.end(token);
    }

    private static void loadCountAndTime(ProtoInputStream proto, long fieldId, IntervalStats.EventTracker tracker) throws IOException {
        long token = proto.start(fieldId);
        while (true) {
            switch (proto.nextField()) {
                case 1: {
                    tracker.count = proto.readInt(0x10500000001L);
                    break;
                }
                case 2: {
                    tracker.duration = proto.readLong(1112396529666L);
                    break;
                }
                case -1: {
                    proto.end(token);
                    return;
                }
            }
        }
    }

    private static void loadChooserCounts(ProtoInputStream proto, UsageStats usageStats) throws IOException {
        ArrayMap<Object, Object> counts;
        if (usageStats.mChooserCounts == null) {
            usageStats.mChooserCounts = new ArrayMap();
        }
        String action = null;
        if (proto.isNextField(0x10900000001L)) {
            action = proto.readString(0x10900000001L);
            counts = usageStats.mChooserCounts.get(action);
            if (counts == null) {
                counts = new ArrayMap();
                usageStats.mChooserCounts.put(action, counts);
            }
        } else {
            counts = new ArrayMap();
        }
        while (true) {
            switch (proto.nextField()) {
                case 1: {
                    action = proto.readString(0x10900000001L);
                    usageStats.mChooserCounts.put(action, counts);
                    break;
                }
                case 3: {
                    long token = proto.start(2246267895811L);
                    UsageStatsProto.loadCountsForAction(proto, counts);
                    proto.end(token);
                }
                case -1: {
                    if (action == null) {
                        usageStats.mChooserCounts.put("", counts);
                    }
                    return;
                }
            }
        }
    }

    private static void loadCountsForAction(ProtoInputStream proto, ArrayMap<String, Integer> counts) throws IOException {
        String category = null;
        int count = 0;
        while (true) {
            switch (proto.nextField()) {
                case 1: {
                    category = proto.readString(0x10900000001L);
                    break;
                }
                case 3: {
                    count = proto.readInt(1120986464259L);
                    break;
                }
                case -1: {
                    if (category == null) {
                        counts.put("", count);
                    } else {
                        counts.put(category, count);
                    }
                    return;
                }
            }
        }
    }

    private static void loadConfigStats(ProtoInputStream proto, long fieldId, IntervalStats statsOut) throws IOException {
        ConfigurationStats configStats;
        long token = proto.start(fieldId);
        boolean configActive = false;
        Configuration config = new Configuration();
        if (proto.isNextField(0x10B00000001L)) {
            config.readFromProto(proto, 0x10B00000001L);
            configStats = statsOut.getOrCreateConfigurationStats(config);
        } else {
            configStats = new ConfigurationStats();
        }
        while (true) {
            switch (proto.nextField()) {
                case 1: {
                    config.readFromProto(proto, 0x10B00000001L);
                    ConfigurationStats temp = statsOut.getOrCreateConfigurationStats(config);
                    temp.mLastTimeActive = configStats.mLastTimeActive;
                    temp.mTotalTimeActive = configStats.mTotalTimeActive;
                    temp.mActivationCount = configStats.mActivationCount;
                    configStats = temp;
                    break;
                }
                case 2: {
                    configStats.mLastTimeActive = statsOut.beginTime + proto.readLong(1112396529666L);
                    break;
                }
                case 3: {
                    configStats.mTotalTimeActive = proto.readLong(0x10300000003L);
                    break;
                }
                case 4: {
                    configStats.mActivationCount = proto.readInt(1120986464260L);
                    break;
                }
                case 5: {
                    configActive = proto.readBoolean(1133871366149L);
                    break;
                }
                case -1: {
                    if (configStats.mLastTimeActive == 0L) {
                        configStats.mLastTimeActive = statsOut.beginTime;
                    }
                    if (configActive) {
                        statsOut.activeConfiguration = configStats.mConfiguration;
                    }
                    proto.end(token);
                    return;
                }
            }
        }
    }

    private static void loadEvent(ProtoInputStream proto, long fieldId, IntervalStats statsOut, List<String> stringPool) throws IOException {
        long token = proto.start(fieldId);
        UsageEvents.Event event = statsOut.buildEvent(proto, stringPool);
        proto.end(token);
        if (event.mPackage == null) {
            throw new ProtocolException("no package field present");
        }
        statsOut.events.insert(event);
    }

    private static void writeStringPool(ProtoOutputStream proto, IntervalStats stats) throws IOException {
        long token = proto.start(1146756268034L);
        int size = stats.mStringCache.size();
        proto.write(0x10500000001L, size);
        for (int i = 0; i < size; ++i) {
            proto.write(0x20900000002L, stats.mStringCache.valueAt(i));
        }
        proto.end(token);
    }

    private static void writeUsageStats(ProtoOutputStream proto, long fieldId, IntervalStats stats, UsageStats usageStats) throws IOException {
        long token = proto.start(fieldId);
        int packageIndex = stats.mStringCache.indexOf(usageStats.mPackageName);
        if (packageIndex >= 0) {
            proto.write(1120986464258L, packageIndex + 1);
        } else {
            Slog.w(TAG, "UsageStats package name (" + usageStats.mPackageName + ") not found in IntervalStats string cache");
            proto.write(0x10900000001L, usageStats.mPackageName);
        }
        proto.write(0x10300000003L, usageStats.mLastTimeUsed - stats.beginTime);
        proto.write(1112396529668L, usageStats.mTotalTimeInForeground);
        proto.write(0x10500000005L, usageStats.mLastEvent);
        proto.write(1112396529672L, usageStats.mLastTimeForegroundServiceUsed - stats.beginTime);
        proto.write(1112396529673L, usageStats.mTotalTimeForegroundServiceUsed);
        proto.write(1112396529674L, usageStats.mLastTimeVisible - stats.beginTime);
        proto.write(1112396529675L, usageStats.mTotalTimeVisible);
        proto.write(1120986464262L, usageStats.mAppLaunchCount);
        UsageStatsProto.writeChooserCounts(proto, usageStats);
        proto.end(token);
    }

    private static void writeCountAndTime(ProtoOutputStream proto, long fieldId, int count, long time) throws IOException {
        long token = proto.start(fieldId);
        proto.write(0x10500000001L, count);
        proto.write(1112396529666L, time);
        proto.end(token);
    }

    private static void writeChooserCounts(ProtoOutputStream proto, UsageStats usageStats) throws IOException {
        if (usageStats == null || usageStats.mChooserCounts == null || usageStats.mChooserCounts.keySet().isEmpty()) {
            return;
        }
        int chooserCountSize = usageStats.mChooserCounts.size();
        for (int i = 0; i < chooserCountSize; ++i) {
            String action = usageStats.mChooserCounts.keyAt(i);
            ArrayMap<String, Integer> counts = usageStats.mChooserCounts.valueAt(i);
            if (action == null || counts == null || counts.isEmpty()) continue;
            long token = proto.start(2246267895815L);
            proto.write(0x10900000001L, action);
            UsageStatsProto.writeCountsForAction(proto, counts);
            proto.end(token);
        }
    }

    private static void writeCountsForAction(ProtoOutputStream proto, ArrayMap<String, Integer> counts) throws IOException {
        int countsSize = counts.size();
        for (int i = 0; i < countsSize; ++i) {
            String key = counts.keyAt(i);
            int count = counts.valueAt(i);
            if (count <= 0) continue;
            long token = proto.start(2246267895811L);
            proto.write(0x10900000001L, key);
            proto.write(1120986464259L, count);
            proto.end(token);
        }
    }

    private static void writeConfigStats(ProtoOutputStream proto, long fieldId, IntervalStats stats, ConfigurationStats configStats, boolean isActive) throws IOException {
        long token = proto.start(fieldId);
        configStats.mConfiguration.writeToProto(proto, 0x10B00000001L);
        proto.write(1112396529666L, configStats.mLastTimeActive - stats.beginTime);
        proto.write(0x10300000003L, configStats.mTotalTimeActive);
        proto.write(1120986464260L, configStats.mActivationCount);
        proto.write(1133871366149L, isActive);
        proto.end(token);
    }

    private static void writeEvent(ProtoOutputStream proto, long fieldId, IntervalStats stats, UsageEvents.Event event) throws IOException {
        long token = proto.start(fieldId);
        int packageIndex = stats.mStringCache.indexOf(event.mPackage);
        if (packageIndex >= 0) {
            proto.write(1120986464258L, packageIndex + 1);
        } else {
            Slog.w(TAG, "Usage event package name (" + event.mPackage + ") not found in IntervalStats string cache");
            proto.write(0x10900000001L, event.mPackage);
        }
        if (event.mClass != null) {
            int classIndex = stats.mStringCache.indexOf(event.mClass);
            if (classIndex >= 0) {
                proto.write(1120986464260L, classIndex + 1);
            } else {
                Slog.w(TAG, "Usage event class name (" + event.mClass + ") not found in IntervalStats string cache");
                proto.write(1138166333443L, event.mClass);
            }
        }
        proto.write(1112396529669L, event.mTimeStamp - stats.beginTime);
        proto.write(1120986464262L, event.mFlags);
        proto.write(1120986464263L, event.mEventType);
        proto.write(1120986464270L, event.mInstanceId);
        if (event.mTaskRootPackage != null) {
            int taskRootPackageIndex = stats.mStringCache.indexOf(event.mTaskRootPackage);
            if (taskRootPackageIndex >= 0) {
                proto.write(1120986464271L, taskRootPackageIndex + 1);
            } else {
                Slog.w(TAG, "Usage event task root package name (" + event.mTaskRootPackage + ") not found in IntervalStats string cache");
            }
        }
        if (event.mTaskRootClass != null) {
            int taskRootClassIndex = stats.mStringCache.indexOf(event.mTaskRootClass);
            if (taskRootClassIndex >= 0) {
                proto.write(0x10500000010L, taskRootClassIndex + 1);
            } else {
                Slog.w(TAG, "Usage event task root class name (" + event.mTaskRootClass + ") not found in IntervalStats string cache");
            }
        }
        switch (event.mEventType) {
            case 5: {
                if (event.mConfiguration == null) break;
                event.mConfiguration.writeToProto(proto, 1146756268040L);
                break;
            }
            case 8: {
                if (event.mShortcutId == null) break;
                proto.write(0x10900000009L, event.mShortcutId);
                break;
            }
            case 11: {
                if (event.mBucketAndReason == 0) break;
                proto.write(1120986464267L, event.mBucketAndReason);
                break;
            }
            case 12: {
                if (event.mNotificationChannelId == null) break;
                int channelIndex = stats.mStringCache.indexOf(event.mNotificationChannelId);
                if (channelIndex >= 0) {
                    proto.write(1120986464269L, channelIndex + 1);
                    break;
                }
                Slog.w(TAG, "Usage event notification channel name (" + event.mNotificationChannelId + ") not found in IntervalStats string cache");
                proto.write(1138166333452L, event.mNotificationChannelId);
            }
        }
        proto.end(token);
    }

    public static void read(InputStream in, IntervalStats statsOut) throws IOException {
        ProtoInputStream proto = new ProtoInputStream(in);
        List<String> stringPool = null;
        statsOut.packageStats.clear();
        statsOut.configurations.clear();
        statsOut.activeConfiguration = null;
        statsOut.events.clear();
        while (true) {
            switch (proto.nextField()) {
                case 1: {
                    statsOut.endTime = statsOut.beginTime + proto.readLong(0x10300000001L);
                    break;
                }
                case 3: {
                    statsOut.majorVersion = proto.readInt(1120986464259L);
                    break;
                }
                case 4: {
                    statsOut.minorVersion = proto.readInt(1120986464260L);
                    break;
                }
                case 10: {
                    UsageStatsProto.loadCountAndTime(proto, 1146756268042L, statsOut.interactiveTracker);
                    break;
                }
                case 11: {
                    UsageStatsProto.loadCountAndTime(proto, 0x10B0000000BL, statsOut.nonInteractiveTracker);
                    break;
                }
                case 12: {
                    UsageStatsProto.loadCountAndTime(proto, 1146756268044L, statsOut.keyguardShownTracker);
                    break;
                }
                case 13: {
                    UsageStatsProto.loadCountAndTime(proto, 1146756268045L, statsOut.keyguardHiddenTracker);
                    break;
                }
                case 2: {
                    stringPool = UsageStatsProto.readStringPool(proto);
                    statsOut.mStringCache.addAll(stringPool);
                    break;
                }
                case 20: {
                    UsageStatsProto.loadUsageStats(proto, 2246267895828L, statsOut, stringPool);
                    break;
                }
                case 21: {
                    UsageStatsProto.loadConfigStats(proto, 2246267895829L, statsOut);
                    break;
                }
                case 22: {
                    UsageStatsProto.loadEvent(proto, 2246267895830L, statsOut, stringPool);
                    break;
                }
                case -1: {
                    if (statsOut.endTime == 0L) {
                        statsOut.endTime = statsOut.beginTime;
                    }
                    statsOut.upgradeIfNeeded();
                    return;
                }
            }
        }
    }

    public static void write(OutputStream out, IntervalStats stats) throws IOException {
        ProtoOutputStream proto = new ProtoOutputStream(out);
        proto.write(0x10300000001L, stats.endTime - stats.beginTime);
        proto.write(1120986464259L, stats.majorVersion);
        proto.write(1120986464260L, stats.minorVersion);
        UsageStatsProto.writeStringPool(proto, stats);
        UsageStatsProto.writeCountAndTime(proto, 1146756268042L, stats.interactiveTracker.count, stats.interactiveTracker.duration);
        UsageStatsProto.writeCountAndTime(proto, 0x10B0000000BL, stats.nonInteractiveTracker.count, stats.nonInteractiveTracker.duration);
        UsageStatsProto.writeCountAndTime(proto, 1146756268044L, stats.keyguardShownTracker.count, stats.keyguardShownTracker.duration);
        UsageStatsProto.writeCountAndTime(proto, 1146756268045L, stats.keyguardHiddenTracker.count, stats.keyguardHiddenTracker.duration);
        int statsCount = stats.packageStats.size();
        for (int i = 0; i < statsCount; ++i) {
            UsageStatsProto.writeUsageStats(proto, 2246267895828L, stats, stats.packageStats.valueAt(i));
        }
        int configCount = stats.configurations.size();
        for (int i = 0; i < configCount; ++i) {
            boolean active = stats.activeConfiguration.equals(stats.configurations.keyAt(i));
            UsageStatsProto.writeConfigStats(proto, 2246267895829L, stats, stats.configurations.valueAt(i), active);
        }
        int eventCount = stats.events.size();
        for (int i = 0; i < eventCount; ++i) {
            UsageStatsProto.writeEvent(proto, 2246267895830L, stats, stats.events.get(i));
        }
        proto.flush();
    }
}

