/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.usage;

import android.app.usage.ConfigurationStats;
import android.app.usage.UsageEvents;
import android.app.usage.UsageStats;
import android.content.res.Configuration;
import android.util.ArrayMap;
import android.util.Log;
import com.android.internal.util.XmlUtils;
import com.android.server.usage.IntervalStats;
import java.io.IOException;
import java.net.ProtocolException;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

final class UsageStatsXmlV1 {
    private static final String TAG = "UsageStatsXmlV1";
    private static final String INTERACTIVE_TAG = "interactive";
    private static final String NON_INTERACTIVE_TAG = "non-interactive";
    private static final String KEYGUARD_SHOWN_TAG = "keyguard-shown";
    private static final String KEYGUARD_HIDDEN_TAG = "keyguard-hidden";
    private static final String PACKAGES_TAG = "packages";
    private static final String PACKAGE_TAG = "package";
    private static final String CHOOSER_COUNT_TAG = "chosen_action";
    private static final String CATEGORY_TAG = "category";
    private static final String NAME = "name";
    private static final String COUNT = "count";
    private static final String CONFIGURATIONS_TAG = "configurations";
    private static final String CONFIG_TAG = "config";
    private static final String EVENT_LOG_TAG = "event-log";
    private static final String EVENT_TAG = "event";
    private static final String PACKAGE_ATTR = "package";
    private static final String FLAGS_ATTR = "flags";
    private static final String CLASS_ATTR = "class";
    private static final String TOTAL_TIME_ACTIVE_ATTR = "timeActive";
    private static final String TOTAL_TIME_VISIBLE_ATTR = "timeVisible";
    private static final String TOTAL_TIME_SERVICE_USED_ATTR = "timeServiceUsed";
    private static final String COUNT_ATTR = "count";
    private static final String ACTIVE_ATTR = "active";
    private static final String LAST_EVENT_ATTR = "lastEvent";
    private static final String TYPE_ATTR = "type";
    private static final String INSTANCE_ID_ATTR = "instanceId";
    private static final String SHORTCUT_ID_ATTR = "shortcutId";
    private static final String STANDBY_BUCKET_ATTR = "standbyBucket";
    private static final String APP_LAUNCH_COUNT_ATTR = "appLaunchCount";
    private static final String NOTIFICATION_CHANNEL_ATTR = "notificationChannel";
    private static final String MAJOR_VERSION_ATTR = "majorVersion";
    private static final String MINOR_VERSION_ATTR = "minorVersion";
    private static final String LAST_TIME_ACTIVE_ATTR = "lastTimeActive";
    private static final String LAST_TIME_VISIBLE_ATTR = "lastTimeVisible";
    private static final String LAST_TIME_SERVICE_USED_ATTR = "lastTimeServiceUsed";
    private static final String END_TIME_ATTR = "endTime";
    private static final String TIME_ATTR = "time";

    private static void loadUsageStats(XmlPullParser parser, IntervalStats statsOut) throws XmlPullParserException, IOException {
        int eventCode;
        String pkg = parser.getAttributeValue(null, "package");
        if (pkg == null) {
            throw new ProtocolException("no package attribute present");
        }
        UsageStats stats = statsOut.getOrCreateUsageStats(pkg);
        stats.mLastTimeUsed = statsOut.beginTime + XmlUtils.readLongAttribute(parser, LAST_TIME_ACTIVE_ATTR);
        try {
            stats.mLastTimeVisible = statsOut.beginTime + XmlUtils.readLongAttribute(parser, LAST_TIME_VISIBLE_ATTR);
        }
        catch (IOException e) {
            Log.i(TAG, "Failed to parse mLastTimeVisible");
        }
        try {
            stats.mLastTimeForegroundServiceUsed = statsOut.beginTime + XmlUtils.readLongAttribute(parser, LAST_TIME_SERVICE_USED_ATTR);
        }
        catch (IOException e) {
            Log.i(TAG, "Failed to parse mLastTimeForegroundServiceUsed");
        }
        stats.mTotalTimeInForeground = XmlUtils.readLongAttribute(parser, TOTAL_TIME_ACTIVE_ATTR);
        try {
            stats.mTotalTimeVisible = XmlUtils.readLongAttribute(parser, TOTAL_TIME_VISIBLE_ATTR);
        }
        catch (IOException e) {
            Log.i(TAG, "Failed to parse mTotalTimeVisible");
        }
        try {
            stats.mTotalTimeForegroundServiceUsed = XmlUtils.readLongAttribute(parser, TOTAL_TIME_SERVICE_USED_ATTR);
        }
        catch (IOException e) {
            Log.i(TAG, "Failed to parse mTotalTimeForegroundServiceUsed");
        }
        stats.mLastEvent = XmlUtils.readIntAttribute(parser, LAST_EVENT_ATTR);
        stats.mAppLaunchCount = XmlUtils.readIntAttribute(parser, APP_LAUNCH_COUNT_ATTR, 0);
        while ((eventCode = parser.next()) != 1) {
            String tag = parser.getName();
            if (eventCode == 3 && tag.equals("package")) break;
            if (eventCode != 2 || !tag.equals(CHOOSER_COUNT_TAG)) continue;
            String action = XmlUtils.readStringAttribute(parser, NAME);
            UsageStatsXmlV1.loadChooserCounts(parser, stats, action);
        }
    }

    private static void loadCountAndTime(XmlPullParser parser, IntervalStats.EventTracker tracker) throws IOException, XmlPullParserException {
        tracker.count = XmlUtils.readIntAttribute(parser, "count", 0);
        tracker.duration = XmlUtils.readLongAttribute(parser, TIME_ATTR, 0L);
        XmlUtils.skipCurrentTag(parser);
    }

    private static void loadChooserCounts(XmlPullParser parser, UsageStats usageStats, String action) throws XmlPullParserException, IOException {
        int eventCode;
        if (action == null) {
            return;
        }
        if (usageStats.mChooserCounts == null) {
            usageStats.mChooserCounts = new ArrayMap();
        }
        if (!usageStats.mChooserCounts.containsKey(action)) {
            ArrayMap counts = new ArrayMap();
            usageStats.mChooserCounts.put(action, counts);
        }
        while ((eventCode = parser.next()) != 1) {
            String tag = parser.getName();
            if (eventCode == 3 && tag.equals(CHOOSER_COUNT_TAG)) break;
            if (eventCode != 2 || !tag.equals(CATEGORY_TAG)) continue;
            String category = XmlUtils.readStringAttribute(parser, NAME);
            int count = XmlUtils.readIntAttribute(parser, "count");
            usageStats.mChooserCounts.get(action).put(category, count);
        }
    }

    private static void loadConfigStats(XmlPullParser parser, IntervalStats statsOut) throws XmlPullParserException, IOException {
        Configuration config = new Configuration();
        Configuration.readXmlAttrs(parser, config);
        ConfigurationStats configStats = statsOut.getOrCreateConfigurationStats(config);
        configStats.mLastTimeActive = statsOut.beginTime + XmlUtils.readLongAttribute(parser, LAST_TIME_ACTIVE_ATTR);
        configStats.mTotalTimeActive = XmlUtils.readLongAttribute(parser, TOTAL_TIME_ACTIVE_ATTR);
        configStats.mActivationCount = XmlUtils.readIntAttribute(parser, "count");
        if (XmlUtils.readBooleanAttribute(parser, ACTIVE_ATTR)) {
            statsOut.activeConfiguration = configStats.mConfiguration;
        }
    }

    private static void loadEvent(XmlPullParser parser, IntervalStats statsOut) throws XmlPullParserException, IOException {
        String packageName = XmlUtils.readStringAttribute(parser, "package");
        if (packageName == null) {
            throw new ProtocolException("no package attribute present");
        }
        String className = XmlUtils.readStringAttribute(parser, CLASS_ATTR);
        UsageEvents.Event event = statsOut.buildEvent(packageName, className);
        event.mFlags = XmlUtils.readIntAttribute(parser, FLAGS_ATTR, 0);
        event.mTimeStamp = statsOut.beginTime + XmlUtils.readLongAttribute(parser, TIME_ATTR);
        event.mEventType = XmlUtils.readIntAttribute(parser, TYPE_ATTR);
        try {
            event.mInstanceId = XmlUtils.readIntAttribute(parser, INSTANCE_ID_ATTR);
        }
        catch (IOException e) {
            Log.e(TAG, "Failed to parse mInstanceId", e);
        }
        switch (event.mEventType) {
            case 5: {
                event.mConfiguration = new Configuration();
                Configuration.readXmlAttrs(parser, event.mConfiguration);
                break;
            }
            case 8: {
                String id2 = XmlUtils.readStringAttribute(parser, SHORTCUT_ID_ATTR);
                event.mShortcutId = id2 != null ? id2.intern() : null;
                break;
            }
            case 11: {
                event.mBucketAndReason = XmlUtils.readIntAttribute(parser, STANDBY_BUCKET_ATTR, 0);
                break;
            }
            case 12: {
                String channelId = XmlUtils.readStringAttribute(parser, NOTIFICATION_CHANNEL_ATTR);
                event.mNotificationChannelId = channelId != null ? channelId.intern() : null;
            }
        }
        statsOut.addEvent(event);
    }

    private static void writeUsageStats(XmlSerializer xml2, IntervalStats stats, UsageStats usageStats) throws IOException {
        xml2.startTag(null, "package");
        XmlUtils.writeLongAttribute(xml2, LAST_TIME_ACTIVE_ATTR, usageStats.mLastTimeUsed - stats.beginTime);
        XmlUtils.writeLongAttribute(xml2, LAST_TIME_VISIBLE_ATTR, usageStats.mLastTimeVisible - stats.beginTime);
        XmlUtils.writeLongAttribute(xml2, LAST_TIME_SERVICE_USED_ATTR, usageStats.mLastTimeForegroundServiceUsed - stats.beginTime);
        XmlUtils.writeStringAttribute(xml2, "package", usageStats.mPackageName);
        XmlUtils.writeLongAttribute(xml2, TOTAL_TIME_ACTIVE_ATTR, usageStats.mTotalTimeInForeground);
        XmlUtils.writeLongAttribute(xml2, TOTAL_TIME_VISIBLE_ATTR, usageStats.mTotalTimeVisible);
        XmlUtils.writeLongAttribute(xml2, TOTAL_TIME_SERVICE_USED_ATTR, usageStats.mTotalTimeForegroundServiceUsed);
        XmlUtils.writeIntAttribute(xml2, LAST_EVENT_ATTR, usageStats.mLastEvent);
        if (usageStats.mAppLaunchCount > 0) {
            XmlUtils.writeIntAttribute(xml2, APP_LAUNCH_COUNT_ATTR, usageStats.mAppLaunchCount);
        }
        UsageStatsXmlV1.writeChooserCounts(xml2, usageStats);
        xml2.endTag(null, "package");
    }

    private static void writeCountAndTime(XmlSerializer xml2, String tag, int count, long time) throws IOException {
        xml2.startTag(null, tag);
        XmlUtils.writeIntAttribute(xml2, "count", count);
        XmlUtils.writeLongAttribute(xml2, TIME_ATTR, time);
        xml2.endTag(null, tag);
    }

    private static void writeChooserCounts(XmlSerializer xml2, UsageStats usageStats) throws IOException {
        if (usageStats == null || usageStats.mChooserCounts == null || usageStats.mChooserCounts.keySet().isEmpty()) {
            return;
        }
        int chooserCountSize = usageStats.mChooserCounts.size();
        for (int i = 0; i < chooserCountSize; ++i) {
            String action = usageStats.mChooserCounts.keyAt(i);
            ArrayMap<String, Integer> counts = usageStats.mChooserCounts.valueAt(i);
            if (action == null || counts == null || counts.isEmpty()) continue;
            xml2.startTag(null, CHOOSER_COUNT_TAG);
            XmlUtils.writeStringAttribute(xml2, NAME, action);
            UsageStatsXmlV1.writeCountsForAction(xml2, counts);
            xml2.endTag(null, CHOOSER_COUNT_TAG);
        }
    }

    private static void writeCountsForAction(XmlSerializer xml2, ArrayMap<String, Integer> counts) throws IOException {
        int countsSize = counts.size();
        for (int i = 0; i < countsSize; ++i) {
            String key = counts.keyAt(i);
            int count = counts.valueAt(i);
            if (count <= 0) continue;
            xml2.startTag(null, CATEGORY_TAG);
            XmlUtils.writeStringAttribute(xml2, NAME, key);
            XmlUtils.writeIntAttribute(xml2, "count", count);
            xml2.endTag(null, CATEGORY_TAG);
        }
    }

    private static void writeConfigStats(XmlSerializer xml2, IntervalStats stats, ConfigurationStats configStats, boolean isActive) throws IOException {
        xml2.startTag(null, CONFIG_TAG);
        XmlUtils.writeLongAttribute(xml2, LAST_TIME_ACTIVE_ATTR, configStats.mLastTimeActive - stats.beginTime);
        XmlUtils.writeLongAttribute(xml2, TOTAL_TIME_ACTIVE_ATTR, configStats.mTotalTimeActive);
        XmlUtils.writeIntAttribute(xml2, "count", configStats.mActivationCount);
        if (isActive) {
            XmlUtils.writeBooleanAttribute(xml2, ACTIVE_ATTR, true);
        }
        Configuration.writeXmlAttrs(xml2, configStats.mConfiguration);
        xml2.endTag(null, CONFIG_TAG);
    }

    private static void writeEvent(XmlSerializer xml2, IntervalStats stats, UsageEvents.Event event) throws IOException {
        xml2.startTag(null, EVENT_TAG);
        XmlUtils.writeLongAttribute(xml2, TIME_ATTR, event.mTimeStamp - stats.beginTime);
        XmlUtils.writeStringAttribute(xml2, "package", event.mPackage);
        if (event.mClass != null) {
            XmlUtils.writeStringAttribute(xml2, CLASS_ATTR, event.mClass);
        }
        XmlUtils.writeIntAttribute(xml2, FLAGS_ATTR, event.mFlags);
        XmlUtils.writeIntAttribute(xml2, TYPE_ATTR, event.mEventType);
        XmlUtils.writeIntAttribute(xml2, INSTANCE_ID_ATTR, event.mInstanceId);
        switch (event.mEventType) {
            case 5: {
                if (event.mConfiguration == null) break;
                Configuration.writeXmlAttrs(xml2, event.mConfiguration);
                break;
            }
            case 8: {
                if (event.mShortcutId == null) break;
                XmlUtils.writeStringAttribute(xml2, SHORTCUT_ID_ATTR, event.mShortcutId);
                break;
            }
            case 11: {
                if (event.mBucketAndReason == 0) break;
                XmlUtils.writeIntAttribute(xml2, STANDBY_BUCKET_ATTR, event.mBucketAndReason);
                break;
            }
            case 12: {
                if (event.mNotificationChannelId == null) break;
                XmlUtils.writeStringAttribute(xml2, NOTIFICATION_CHANNEL_ATTR, event.mNotificationChannelId);
            }
        }
        xml2.endTag(null, EVENT_TAG);
    }

    public static void read(XmlPullParser parser, IntervalStats statsOut) throws XmlPullParserException, IOException {
        int eventCode;
        statsOut.packageStats.clear();
        statsOut.configurations.clear();
        statsOut.activeConfiguration = null;
        statsOut.events.clear();
        statsOut.endTime = statsOut.beginTime + XmlUtils.readLongAttribute(parser, END_TIME_ATTR);
        try {
            statsOut.majorVersion = XmlUtils.readIntAttribute(parser, MAJOR_VERSION_ATTR);
        }
        catch (IOException e) {
            Log.e(TAG, "Failed to parse majorVersion", e);
        }
        try {
            statsOut.minorVersion = XmlUtils.readIntAttribute(parser, MINOR_VERSION_ATTR);
        }
        catch (IOException e) {
            Log.e(TAG, "Failed to parse minorVersion", e);
        }
        int outerDepth = parser.getDepth();
        while ((eventCode = parser.next()) != 1 && (eventCode != 3 || parser.getDepth() > outerDepth)) {
            String tag;
            if (eventCode != 2) continue;
            switch (tag = parser.getName()) {
                case "interactive": {
                    UsageStatsXmlV1.loadCountAndTime(parser, statsOut.interactiveTracker);
                    break;
                }
                case "non-interactive": {
                    UsageStatsXmlV1.loadCountAndTime(parser, statsOut.nonInteractiveTracker);
                    break;
                }
                case "keyguard-shown": {
                    UsageStatsXmlV1.loadCountAndTime(parser, statsOut.keyguardShownTracker);
                    break;
                }
                case "keyguard-hidden": {
                    UsageStatsXmlV1.loadCountAndTime(parser, statsOut.keyguardHiddenTracker);
                    break;
                }
                case "package": {
                    UsageStatsXmlV1.loadUsageStats(parser, statsOut);
                    break;
                }
                case "config": {
                    UsageStatsXmlV1.loadConfigStats(parser, statsOut);
                    break;
                }
                case "event": {
                    UsageStatsXmlV1.loadEvent(parser, statsOut);
                }
            }
        }
    }

    public static void write(XmlSerializer xml2, IntervalStats stats) throws IOException {
        XmlUtils.writeLongAttribute(xml2, END_TIME_ATTR, stats.endTime - stats.beginTime);
        XmlUtils.writeIntAttribute(xml2, MAJOR_VERSION_ATTR, stats.majorVersion);
        XmlUtils.writeIntAttribute(xml2, MINOR_VERSION_ATTR, stats.minorVersion);
        UsageStatsXmlV1.writeCountAndTime(xml2, INTERACTIVE_TAG, stats.interactiveTracker.count, stats.interactiveTracker.duration);
        UsageStatsXmlV1.writeCountAndTime(xml2, NON_INTERACTIVE_TAG, stats.nonInteractiveTracker.count, stats.nonInteractiveTracker.duration);
        UsageStatsXmlV1.writeCountAndTime(xml2, KEYGUARD_SHOWN_TAG, stats.keyguardShownTracker.count, stats.keyguardShownTracker.duration);
        UsageStatsXmlV1.writeCountAndTime(xml2, KEYGUARD_HIDDEN_TAG, stats.keyguardHiddenTracker.count, stats.keyguardHiddenTracker.duration);
        xml2.startTag(null, PACKAGES_TAG);
        int statsCount = stats.packageStats.size();
        for (int i = 0; i < statsCount; ++i) {
            UsageStatsXmlV1.writeUsageStats(xml2, stats, stats.packageStats.valueAt(i));
        }
        xml2.endTag(null, PACKAGES_TAG);
        xml2.startTag(null, CONFIGURATIONS_TAG);
        int configCount = stats.configurations.size();
        for (int i = 0; i < configCount; ++i) {
            boolean active = stats.activeConfiguration.equals(stats.configurations.keyAt(i));
            UsageStatsXmlV1.writeConfigStats(xml2, stats, stats.configurations.valueAt(i), active);
        }
        xml2.endTag(null, CONFIGURATIONS_TAG);
        xml2.startTag(null, EVENT_LOG_TAG);
        int eventCount = stats.events.size();
        for (int i = 0; i < eventCount; ++i) {
            UsageStatsXmlV1.writeEvent(xml2, stats, stats.events.get(i));
        }
        xml2.endTag(null, EVENT_LOG_TAG);
    }

    private UsageStatsXmlV1() {
    }
}

