/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.usage;

import android.app.usage.ConfigurationStats;
import android.app.usage.EventList;
import android.app.usage.EventStats;
import android.app.usage.TimeSparseArray;
import android.app.usage.UsageEvents;
import android.app.usage.UsageStats;
import android.app.usage.UsageStatsManager;
import android.content.Context;
import android.content.res.Configuration;
import android.os.SystemClock;
import android.text.format.DateUtils;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.AtomicFile;
import android.util.Slog;
import android.util.SparseIntArray;
import com.android.internal.util.IndentingPrintWriter;
import com.android.server.usage.IntervalStats;
import com.android.server.usage.UnixCalendar;
import com.android.server.usage.UsageStatsDatabase;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

class UserUsageStatsService {
    private static final String TAG = "UsageStatsService";
    private static final boolean DEBUG = false;
    private static final SimpleDateFormat sDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static final int sDateFormatFlags = 131093;
    private final Context mContext;
    private final UsageStatsDatabase mDatabase;
    private final IntervalStats[] mCurrentStats;
    private boolean mStatsChanged = false;
    private final UnixCalendar mDailyExpiryDate;
    private final StatsUpdatedListener mListener;
    private final String mLogPrefix;
    private String mLastBackgroundedPackage;
    private final int mUserId;
    private static final long[] INTERVAL_LENGTH = new long[]{86400000L, 604800000L, 2592000000L, 31536000000L};
    private static final UsageStatsDatabase.StatCombiner<UsageStats> sUsageStatsCombiner = new UsageStatsDatabase.StatCombiner<UsageStats>(){

        @Override
        public void combine(IntervalStats stats, boolean mutable, List<UsageStats> accResult) {
            if (!mutable) {
                accResult.addAll(stats.packageStats.values());
                return;
            }
            int statCount = stats.packageStats.size();
            for (int i = 0; i < statCount; ++i) {
                accResult.add(new UsageStats(stats.packageStats.valueAt(i)));
            }
        }
    };
    private static final UsageStatsDatabase.StatCombiner<ConfigurationStats> sConfigStatsCombiner = new UsageStatsDatabase.StatCombiner<ConfigurationStats>(){

        @Override
        public void combine(IntervalStats stats, boolean mutable, List<ConfigurationStats> accResult) {
            if (!mutable) {
                accResult.addAll(stats.configurations.values());
                return;
            }
            int configCount = stats.configurations.size();
            for (int i = 0; i < configCount; ++i) {
                accResult.add(new ConfigurationStats(stats.configurations.valueAt(i)));
            }
        }
    };
    private static final UsageStatsDatabase.StatCombiner<EventStats> sEventStatsCombiner = new UsageStatsDatabase.StatCombiner<EventStats>(){

        @Override
        public void combine(IntervalStats stats, boolean mutable, List<EventStats> accResult) {
            stats.addEventStatsTo(accResult);
        }
    };

    UserUsageStatsService(Context context, int userId, File usageStatsDir, StatsUpdatedListener listener) {
        this.mContext = context;
        this.mDailyExpiryDate = new UnixCalendar(0L);
        this.mDatabase = new UsageStatsDatabase(usageStatsDir);
        this.mCurrentStats = new IntervalStats[4];
        this.mListener = listener;
        this.mLogPrefix = "User[" + Integer.toString(userId) + "] ";
        this.mUserId = userId;
    }

    void init(long currentTimeMillis) {
        this.mDatabase.init(currentTimeMillis);
        int nullCount = 0;
        for (int i = 0; i < this.mCurrentStats.length; ++i) {
            this.mCurrentStats[i] = this.mDatabase.getLatestUsageStats(i);
            if (this.mCurrentStats[i] != null) continue;
            ++nullCount;
        }
        if (nullCount > 0) {
            if (nullCount != this.mCurrentStats.length) {
                Slog.w(TAG, this.mLogPrefix + "Some stats have no latest available");
            }
            this.loadActiveStats(currentTimeMillis);
        } else {
            this.updateRolloverDeadline();
        }
        IntervalStats currentDailyStats = this.mCurrentStats[0];
        if (currentDailyStats != null) {
            UsageEvents.Event shutdownEvent = new UsageEvents.Event(26, currentDailyStats.lastTimeSaved + 1000L);
            shutdownEvent.mPackage = "android";
            currentDailyStats.addEvent(shutdownEvent);
            UsageEvents.Event startupEvent = new UsageEvents.Event(27, currentTimeMillis);
            startupEvent.mPackage = "android";
            currentDailyStats.addEvent(startupEvent);
        }
        if (this.mDatabase.isNewUpdate()) {
            this.notifyNewUpdate();
        }
    }

    void onTimeChanged(long oldTime, long newTime) {
        this.persistActiveStats();
        this.mDatabase.onTimeChanged(newTime - oldTime);
        this.loadActiveStats(newTime);
    }

    void reportEvent(UsageEvents.Event event) {
        if (event.mTimeStamp >= this.mDailyExpiryDate.getTimeInMillis()) {
            this.rolloverStats(event.mTimeStamp);
        }
        IntervalStats currentDailyStats = this.mCurrentStats[0];
        Configuration newFullConfig = event.mConfiguration;
        if (event.mEventType == 5 && currentDailyStats.activeConfiguration != null) {
            event.mConfiguration = Configuration.generateDelta(currentDailyStats.activeConfiguration, newFullConfig);
        }
        if (event.mEventType != 6 && event.mEventType != 24 && event.mEventType != 25 && event.mEventType != 26) {
            currentDailyStats.addEvent(event);
        }
        boolean incrementAppLaunch = false;
        if (event.mEventType == 1) {
            if (event.mPackage != null && !event.mPackage.equals(this.mLastBackgroundedPackage)) {
                incrementAppLaunch = true;
            }
        } else if (event.mEventType == 2 && event.mPackage != null) {
            this.mLastBackgroundedPackage = event.mPackage;
        }
        block8: for (IntervalStats stats : this.mCurrentStats) {
            switch (event.mEventType) {
                case 5: {
                    stats.updateConfigurationStats(newFullConfig, event.mTimeStamp);
                    continue block8;
                }
                case 9: {
                    stats.updateChooserCounts(event.mPackage, event.mContentType, event.mAction);
                    String[] annotations = event.mContentAnnotations;
                    if (annotations == null) continue block8;
                    for (String annotation : annotations) {
                        stats.updateChooserCounts(event.mPackage, annotation, event.mAction);
                    }
                    continue block8;
                }
                case 15: {
                    stats.updateScreenInteractive(event.mTimeStamp);
                    continue block8;
                }
                case 16: {
                    stats.updateScreenNonInteractive(event.mTimeStamp);
                    continue block8;
                }
                case 17: {
                    stats.updateKeyguardShown(event.mTimeStamp);
                    continue block8;
                }
                case 18: {
                    stats.updateKeyguardHidden(event.mTimeStamp);
                    continue block8;
                }
                default: {
                    stats.update(event.mPackage, event.getClassName(), event.mTimeStamp, event.mEventType, event.mInstanceId);
                    if (!incrementAppLaunch) continue block8;
                    stats.incrementAppLaunchCount(event.mPackage);
                }
            }
        }
        this.notifyStatsChanged();
    }

    private <T> List<T> queryStats(int intervalType, long beginTime, long endTime, UsageStatsDatabase.StatCombiner<T> combiner) {
        if (intervalType == 4 && (intervalType = this.mDatabase.findBestFitBucket(beginTime, endTime)) < 0) {
            intervalType = 0;
        }
        if (intervalType < 0 || intervalType >= this.mCurrentStats.length) {
            return null;
        }
        IntervalStats currentStats = this.mCurrentStats[intervalType];
        if (beginTime >= currentStats.endTime) {
            return null;
        }
        long truncatedEndTime = Math.min(currentStats.beginTime, endTime);
        List<T> results = this.mDatabase.queryUsageStats(intervalType, beginTime, truncatedEndTime, combiner);
        if (beginTime < currentStats.endTime && endTime > currentStats.beginTime) {
            if (results == null) {
                results = new ArrayList<T>();
            }
            combiner.combine(currentStats, true, results);
        }
        return results;
    }

    List<UsageStats> queryUsageStats(int bucketType, long beginTime, long endTime) {
        return this.queryStats(bucketType, beginTime, endTime, sUsageStatsCombiner);
    }

    List<ConfigurationStats> queryConfigurationStats(int bucketType, long beginTime, long endTime) {
        return this.queryStats(bucketType, beginTime, endTime, sConfigStatsCombiner);
    }

    List<EventStats> queryEventStats(int bucketType, long beginTime, long endTime) {
        return this.queryStats(bucketType, beginTime, endTime, sEventStatsCombiner);
    }

    UsageEvents queryEvents(final long beginTime, final long endTime, final boolean obfuscateInstantApps) {
        final ArraySet names = new ArraySet();
        List<UsageEvents.Event> results = this.queryStats(0, beginTime, endTime, new UsageStatsDatabase.StatCombiner<UsageEvents.Event>(){

            @Override
            public void combine(IntervalStats stats, boolean mutable, List<UsageEvents.Event> accumulatedResult) {
                int startIndex = stats.events.firstIndexOnOrAfter(beginTime);
                int size = stats.events.size();
                for (int i = startIndex; i < size; ++i) {
                    if (stats.events.get((int)i).mTimeStamp >= endTime) {
                        return;
                    }
                    UsageEvents.Event event = stats.events.get(i);
                    if (obfuscateInstantApps) {
                        event = event.getObfuscatedIfInstantApp();
                    }
                    if (event.mPackage != null) {
                        names.add(event.mPackage);
                    }
                    if (event.mClass != null) {
                        names.add(event.mClass);
                    }
                    if (event.mTaskRootPackage != null) {
                        names.add(event.mTaskRootPackage);
                    }
                    if (event.mTaskRootClass != null) {
                        names.add(event.mTaskRootClass);
                    }
                    accumulatedResult.add(event);
                }
            }
        });
        if (results == null || results.isEmpty()) {
            return null;
        }
        Object[] table = names.toArray(new String[names.size()]);
        Arrays.sort(table);
        return new UsageEvents(results, (String[])table, true);
    }

    UsageEvents queryEventsForPackage(long beginTime, long endTime, String packageName, boolean includeTaskRoot) {
        ArraySet<String> names = new ArraySet<String>();
        names.add(packageName);
        List<UsageEvents.Event> results = this.queryStats(0, beginTime, endTime, (stats, mutable, accumulatedResult) -> {
            int startIndex = stats.events.firstIndexOnOrAfter(beginTime);
            int size = stats.events.size();
            for (int i = startIndex; i < size; ++i) {
                if (stats.events.get((int)i).mTimeStamp >= endTime) {
                    return;
                }
                UsageEvents.Event event = stats.events.get(i);
                if (!packageName.equals(event.mPackage)) continue;
                if (event.mClass != null) {
                    names.add(event.mClass);
                }
                if (includeTaskRoot && event.mTaskRootPackage != null) {
                    names.add(event.mTaskRootPackage);
                }
                if (includeTaskRoot && event.mTaskRootClass != null) {
                    names.add(event.mTaskRootClass);
                }
                accumulatedResult.add(event);
            }
        });
        if (results == null || results.isEmpty()) {
            return null;
        }
        Object[] table = names.toArray(new String[names.size()]);
        Arrays.sort(table);
        return new UsageEvents(results, (String[])table, includeTaskRoot);
    }

    void persistActiveStats() {
        if (this.mStatsChanged) {
            Slog.i(TAG, this.mLogPrefix + "Flushing usage stats to disk");
            try {
                for (int i = 0; i < this.mCurrentStats.length; ++i) {
                    this.mDatabase.putUsageStats(i, this.mCurrentStats[i]);
                }
                this.mStatsChanged = false;
            }
            catch (IOException e) {
                Slog.e(TAG, this.mLogPrefix + "Failed to persist active stats", e);
            }
        }
    }

    private void rolloverStats(long currentTimeMillis) {
        long startTime = SystemClock.elapsedRealtime();
        Slog.i(TAG, this.mLogPrefix + "Rolling over usage stats");
        Configuration previousConfig = this.mCurrentStats[0].activeConfiguration;
        ArraySet<String> continuePkgs = new ArraySet<String>();
        ArrayMap<String, SparseIntArray> continueActivity = new ArrayMap<String, SparseIntArray>();
        ArrayMap<String, ArrayMap<String, Integer>> continueForegroundService = new ArrayMap<String, ArrayMap<String, Integer>>();
        for (IntervalStats stat : this.mCurrentStats) {
            int pkgCount = stat.packageStats.size();
            for (int i = 0; i < pkgCount; ++i) {
                UsageStats pkgStats = stat.packageStats.valueAt(i);
                if (pkgStats.mActivities.size() <= 0 && pkgStats.mForegroundServices.isEmpty()) continue;
                if (pkgStats.mActivities.size() > 0) {
                    continueActivity.put(pkgStats.mPackageName, pkgStats.mActivities);
                    stat.update(pkgStats.mPackageName, null, this.mDailyExpiryDate.getTimeInMillis() - 1L, 3, 0);
                }
                if (!pkgStats.mForegroundServices.isEmpty()) {
                    continueForegroundService.put(pkgStats.mPackageName, pkgStats.mForegroundServices);
                    stat.update(pkgStats.mPackageName, null, this.mDailyExpiryDate.getTimeInMillis() - 1L, 22, 0);
                }
                continuePkgs.add(pkgStats.mPackageName);
                this.notifyStatsChanged();
            }
            stat.updateConfigurationStats(null, this.mDailyExpiryDate.getTimeInMillis() - 1L);
            stat.commitTime(this.mDailyExpiryDate.getTimeInMillis() - 1L);
        }
        this.persistActiveStats();
        this.mDatabase.prune(currentTimeMillis);
        this.loadActiveStats(currentTimeMillis);
        int continueCount = continuePkgs.size();
        for (int i = 0; i < continueCount; ++i) {
            String pkgName = (String)continuePkgs.valueAt(i);
            long beginTime = this.mCurrentStats[0].beginTime;
            for (IntervalStats stat : this.mCurrentStats) {
                int j;
                int size;
                Object eventMap;
                if (continueActivity.containsKey(pkgName)) {
                    eventMap = (SparseIntArray)continueActivity.get(pkgName);
                    size = ((SparseIntArray)eventMap).size();
                    for (j = 0; j < size; ++j) {
                        stat.update(pkgName, null, beginTime, ((SparseIntArray)eventMap).valueAt(j), ((SparseIntArray)eventMap).keyAt(j));
                    }
                }
                if (continueForegroundService.containsKey(pkgName)) {
                    eventMap = (ArrayMap)continueForegroundService.get(pkgName);
                    size = ((ArrayMap)eventMap).size();
                    for (j = 0; j < size; ++j) {
                        stat.update(pkgName, (String)((ArrayMap)eventMap).keyAt(j), beginTime, (Integer)((ArrayMap)eventMap).valueAt(j), 0);
                    }
                }
                stat.updateConfigurationStats(previousConfig, beginTime);
                this.notifyStatsChanged();
            }
        }
        this.persistActiveStats();
        long totalTime = SystemClock.elapsedRealtime() - startTime;
        Slog.i(TAG, this.mLogPrefix + "Rolling over usage stats complete. Took " + totalTime + " milliseconds");
    }

    private void notifyStatsChanged() {
        if (!this.mStatsChanged) {
            this.mStatsChanged = true;
            this.mListener.onStatsUpdated();
        }
    }

    private void notifyNewUpdate() {
        this.mListener.onNewUpdate(this.mUserId);
    }

    private void loadActiveStats(long currentTimeMillis) {
        for (int intervalType = 0; intervalType < this.mCurrentStats.length; ++intervalType) {
            IntervalStats stats = this.mDatabase.getLatestUsageStats(intervalType);
            if (stats != null && currentTimeMillis < stats.beginTime + INTERVAL_LENGTH[intervalType]) {
                this.mCurrentStats[intervalType] = stats;
                continue;
            }
            this.mCurrentStats[intervalType] = new IntervalStats();
            this.mCurrentStats[intervalType].beginTime = currentTimeMillis;
            this.mCurrentStats[intervalType].endTime = currentTimeMillis + 1L;
        }
        this.mStatsChanged = false;
        this.updateRolloverDeadline();
        this.mListener.onStatsReloaded();
    }

    private void updateRolloverDeadline() {
        this.mDailyExpiryDate.setTimeInMillis(this.mCurrentStats[0].beginTime);
        this.mDailyExpiryDate.addDays(1);
        Slog.i(TAG, this.mLogPrefix + "Rollover scheduled @ " + sDateFormat.format(this.mDailyExpiryDate.getTimeInMillis()) + "(" + this.mDailyExpiryDate.getTimeInMillis() + ")");
    }

    void checkin(final IndentingPrintWriter pw) {
        this.mDatabase.checkinDailyFiles(new UsageStatsDatabase.CheckinAction(){

            @Override
            public boolean checkin(IntervalStats stats) {
                UserUsageStatsService.this.printIntervalStats(pw, stats, false, false, null);
                return true;
            }
        });
    }

    void dump(IndentingPrintWriter pw, String pkg) {
        this.dump(pw, pkg, false);
    }

    void dump(IndentingPrintWriter pw, String pkg, boolean compact) {
        this.printLast24HrEvents(pw, !compact, pkg);
        for (int interval = 0; interval < this.mCurrentStats.length; ++interval) {
            pw.print("In-memory ");
            pw.print(UserUsageStatsService.intervalToString(interval));
            pw.println(" stats");
            this.printIntervalStats(pw, this.mCurrentStats[interval], !compact, true, pkg);
        }
        this.mDatabase.dump(pw, compact);
    }

    void dumpDatabaseInfo(IndentingPrintWriter ipw) {
        this.mDatabase.dump(ipw, false);
    }

    void dumpFile(IndentingPrintWriter ipw, String[] args) {
        if (args == null || args.length == 0) {
            int numIntervals = this.mDatabase.mSortedStatFiles.length;
            for (int interval = 0; interval < numIntervals; ++interval) {
                ipw.println("interval=" + UserUsageStatsService.intervalToString(interval));
                ipw.increaseIndent();
                this.dumpFileDetailsForInterval(ipw, interval);
                ipw.decreaseIndent();
            }
        } else {
            int interval;
            try {
                int intervalValue = UserUsageStatsService.stringToInterval(args[0]);
                interval = intervalValue == -1 ? Integer.valueOf(args[0]) : intervalValue;
            }
            catch (NumberFormatException nfe) {
                ipw.println("invalid interval specified.");
                return;
            }
            if (interval < 0 || interval >= this.mDatabase.mSortedStatFiles.length) {
                ipw.println("the specified interval does not exist.");
                return;
            }
            if (args.length == 1) {
                this.dumpFileDetailsForInterval(ipw, interval);
            } else {
                long filename;
                try {
                    filename = Long.valueOf(args[1]);
                }
                catch (NumberFormatException nfe) {
                    ipw.println("invalid filename specified.");
                    return;
                }
                IntervalStats stats = this.mDatabase.readIntervalStatsForFile(interval, filename);
                if (stats == null) {
                    ipw.println("the specified filename does not exist.");
                    return;
                }
                this.dumpFileDetails(ipw, stats, Long.valueOf(args[1]));
            }
        }
    }

    private void dumpFileDetailsForInterval(IndentingPrintWriter ipw, int interval) {
        TimeSparseArray<AtomicFile> files = this.mDatabase.mSortedStatFiles[interval];
        int numFiles = files.size();
        for (int i = 0; i < numFiles; ++i) {
            long filename = files.keyAt(i);
            IntervalStats stats = this.mDatabase.readIntervalStatsForFile(interval, filename);
            this.dumpFileDetails(ipw, stats, filename);
            ipw.println();
        }
    }

    private void dumpFileDetails(IndentingPrintWriter ipw, IntervalStats stats, long filename) {
        ipw.println("file=" + filename);
        ipw.increaseIndent();
        this.printIntervalStats(ipw, stats, false, false, null);
        ipw.decreaseIndent();
    }

    static String formatDateTime(long dateTime, boolean pretty) {
        if (pretty) {
            return "\"" + sDateFormat.format(dateTime) + "\"";
        }
        return Long.toString(dateTime);
    }

    private String formatElapsedTime(long elapsedTime, boolean pretty) {
        if (pretty) {
            return "\"" + DateUtils.formatElapsedTime(elapsedTime / 1000L) + "\"";
        }
        return Long.toString(elapsedTime);
    }

    void printEvent(IndentingPrintWriter pw, UsageEvents.Event event, boolean prettyDates) {
        pw.printPair("time", UserUsageStatsService.formatDateTime(event.mTimeStamp, prettyDates));
        pw.printPair("type", UserUsageStatsService.eventToString(event.mEventType));
        pw.printPair("package", event.mPackage);
        if (event.mClass != null) {
            pw.printPair("class", event.mClass);
        }
        if (event.mConfiguration != null) {
            pw.printPair("config", Configuration.resourceQualifierString(event.mConfiguration));
        }
        if (event.mShortcutId != null) {
            pw.printPair("shortcutId", event.mShortcutId);
        }
        if (event.mEventType == 11) {
            pw.printPair("standbyBucket", event.getStandbyBucket());
            pw.printPair("reason", UsageStatsManager.reasonToString(event.getStandbyReason()));
        } else if (event.mEventType == 1 || event.mEventType == 2 || event.mEventType == 23) {
            pw.printPair("instanceId", event.getInstanceId());
        }
        if (event.getTaskRootPackageName() != null) {
            pw.printPair("taskRootPackage", event.getTaskRootPackageName());
        }
        if (event.getTaskRootClassName() != null) {
            pw.printPair("taskRootClass", event.getTaskRootClassName());
        }
        if (event.mNotificationChannelId != null) {
            pw.printPair("channelId", event.mNotificationChannelId);
        }
        pw.printHexPair("flags", event.mFlags);
        pw.println();
    }

    void printLast24HrEvents(IndentingPrintWriter pw, boolean prettyDates, final String pkg) {
        final long endTime = System.currentTimeMillis();
        UnixCalendar yesterday = new UnixCalendar(endTime);
        yesterday.addDays(-1);
        final long beginTime = yesterday.getTimeInMillis();
        List<UsageEvents.Event> events = this.queryStats(0, beginTime, endTime, new UsageStatsDatabase.StatCombiner<UsageEvents.Event>(){

            @Override
            public void combine(IntervalStats stats, boolean mutable, List<UsageEvents.Event> accumulatedResult) {
                int startIndex = stats.events.firstIndexOnOrAfter(beginTime);
                int size = stats.events.size();
                for (int i = startIndex; i < size; ++i) {
                    if (stats.events.get((int)i).mTimeStamp >= endTime) {
                        return;
                    }
                    UsageEvents.Event event = stats.events.get(i);
                    if (pkg != null && !pkg.equals(event.mPackage)) continue;
                    accumulatedResult.add(event);
                }
            }
        });
        pw.print("Last 24 hour events (");
        if (prettyDates) {
            pw.printPair("timeRange", "\"" + DateUtils.formatDateRange(this.mContext, beginTime, endTime, 131093) + "\"");
        } else {
            pw.printPair("beginTime", beginTime);
            pw.printPair("endTime", endTime);
        }
        pw.println(")");
        if (events != null) {
            pw.increaseIndent();
            for (UsageEvents.Event event : events) {
                this.printEvent(pw, event, prettyDates);
            }
            pw.decreaseIndent();
        }
    }

    void printEventAggregation(IndentingPrintWriter pw, String label, IntervalStats.EventTracker tracker, boolean prettyDates) {
        if (tracker.count != 0 || tracker.duration != 0L) {
            pw.print(label);
            pw.print(": ");
            pw.print(tracker.count);
            pw.print("x for ");
            pw.print(this.formatElapsedTime(tracker.duration, prettyDates));
            if (tracker.curStartTime != 0L) {
                pw.print(" (now running, started at ");
                UserUsageStatsService.formatDateTime(tracker.curStartTime, prettyDates);
                pw.print(")");
            }
            pw.println();
        }
    }

    void printIntervalStats(IndentingPrintWriter pw, IntervalStats stats, boolean prettyDates, boolean skipEvents, String pkg) {
        int i;
        if (prettyDates) {
            pw.printPair("timeRange", "\"" + DateUtils.formatDateRange(this.mContext, stats.beginTime, stats.endTime, 131093) + "\"");
        } else {
            pw.printPair("beginTime", stats.beginTime);
            pw.printPair("endTime", stats.endTime);
        }
        pw.println();
        pw.increaseIndent();
        pw.println("packages");
        pw.increaseIndent();
        ArrayMap<String, UsageStats> pkgStats = stats.packageStats;
        int pkgCount = pkgStats.size();
        for (int i2 = 0; i2 < pkgCount; ++i2) {
            UsageStats usageStats = pkgStats.valueAt(i2);
            if (pkg != null && !pkg.equals(usageStats.mPackageName)) continue;
            pw.printPair("package", usageStats.mPackageName);
            pw.printPair("totalTimeUsed", this.formatElapsedTime(usageStats.mTotalTimeInForeground, prettyDates));
            pw.printPair("lastTimeUsed", UserUsageStatsService.formatDateTime(usageStats.mLastTimeUsed, prettyDates));
            pw.printPair("totalTimeVisible", this.formatElapsedTime(usageStats.mTotalTimeVisible, prettyDates));
            pw.printPair("lastTimeVisible", UserUsageStatsService.formatDateTime(usageStats.mLastTimeVisible, prettyDates));
            pw.printPair("totalTimeFS", this.formatElapsedTime(usageStats.mTotalTimeForegroundServiceUsed, prettyDates));
            pw.printPair("lastTimeFS", UserUsageStatsService.formatDateTime(usageStats.mLastTimeForegroundServiceUsed, prettyDates));
            pw.printPair("appLaunchCount", usageStats.mAppLaunchCount);
            pw.println();
        }
        pw.decreaseIndent();
        pw.println();
        pw.println("ChooserCounts");
        pw.increaseIndent();
        for (UsageStats usageStats : pkgStats.values()) {
            if (pkg != null && !pkg.equals(usageStats.mPackageName)) continue;
            pw.printPair("package", usageStats.mPackageName);
            if (usageStats.mChooserCounts != null) {
                int chooserCountSize = usageStats.mChooserCounts.size();
                for (int i3 = 0; i3 < chooserCountSize; ++i3) {
                    String action = usageStats.mChooserCounts.keyAt(i3);
                    ArrayMap<String, Integer> counts = usageStats.mChooserCounts.valueAt(i3);
                    int annotationSize = counts.size();
                    for (int j = 0; j < annotationSize; ++j) {
                        String key = counts.keyAt(j);
                        int count = counts.valueAt(j);
                        if (count == 0) continue;
                        pw.printPair("ChooserCounts", action + ":" + key + " is " + Integer.toString(count));
                        pw.println();
                    }
                }
            }
            pw.println();
        }
        pw.decreaseIndent();
        if (pkg == null) {
            pw.println("configurations");
            pw.increaseIndent();
            ArrayMap<Configuration, ConfigurationStats> configStats = stats.configurations;
            int configCount = configStats.size();
            for (i = 0; i < configCount; ++i) {
                ConfigurationStats config = configStats.valueAt(i);
                pw.printPair("config", Configuration.resourceQualifierString(config.mConfiguration));
                pw.printPair("totalTime", this.formatElapsedTime(config.mTotalTimeActive, prettyDates));
                pw.printPair("lastTime", UserUsageStatsService.formatDateTime(config.mLastTimeActive, prettyDates));
                pw.printPair("count", config.mActivationCount);
                pw.println();
            }
            pw.decreaseIndent();
            pw.println("event aggregations");
            pw.increaseIndent();
            this.printEventAggregation(pw, "screen-interactive", stats.interactiveTracker, prettyDates);
            this.printEventAggregation(pw, "screen-non-interactive", stats.nonInteractiveTracker, prettyDates);
            this.printEventAggregation(pw, "keyguard-shown", stats.keyguardShownTracker, prettyDates);
            this.printEventAggregation(pw, "keyguard-hidden", stats.keyguardHiddenTracker, prettyDates);
            pw.decreaseIndent();
        }
        if (!skipEvents) {
            pw.println("events");
            pw.increaseIndent();
            EventList events = stats.events;
            int eventCount = events != null ? events.size() : 0;
            for (i = 0; i < eventCount; ++i) {
                UsageEvents.Event event = events.get(i);
                if (pkg != null && !pkg.equals(event.mPackage)) continue;
                this.printEvent(pw, event, prettyDates);
            }
            pw.decreaseIndent();
        }
        pw.decreaseIndent();
    }

    public static String intervalToString(int interval) {
        switch (interval) {
            case 0: {
                return "daily";
            }
            case 1: {
                return "weekly";
            }
            case 2: {
                return "monthly";
            }
            case 3: {
                return "yearly";
            }
        }
        return "?";
    }

    private static int stringToInterval(String interval) {
        switch (interval.toLowerCase()) {
            case "daily": {
                return 0;
            }
            case "weekly": {
                return 1;
            }
            case "monthly": {
                return 2;
            }
            case "yearly": {
                return 3;
            }
        }
        return -1;
    }

    private static String eventToString(int eventType) {
        switch (eventType) {
            case 0: {
                return "NONE";
            }
            case 2: {
                return "ACTIVITY_PAUSED";
            }
            case 1: {
                return "ACTIVITY_RESUMED";
            }
            case 19: {
                return "FOREGROUND_SERVICE_START";
            }
            case 20: {
                return "FOREGROUND_SERVICE_STOP";
            }
            case 23: {
                return "ACTIVITY_STOPPED";
            }
            case 3: {
                return "END_OF_DAY";
            }
            case 22: {
                return "ROLLOVER_FOREGROUND_SERVICE";
            }
            case 4: {
                return "CONTINUE_PREVIOUS_DAY";
            }
            case 21: {
                return "CONTINUING_FOREGROUND_SERVICE";
            }
            case 5: {
                return "CONFIGURATION_CHANGE";
            }
            case 6: {
                return "SYSTEM_INTERACTION";
            }
            case 7: {
                return "USER_INTERACTION";
            }
            case 8: {
                return "SHORTCUT_INVOCATION";
            }
            case 9: {
                return "CHOOSER_ACTION";
            }
            case 10: {
                return "NOTIFICATION_SEEN";
            }
            case 11: {
                return "STANDBY_BUCKET_CHANGED";
            }
            case 12: {
                return "NOTIFICATION_INTERRUPTION";
            }
            case 14: {
                return "SLICE_PINNED";
            }
            case 13: {
                return "SLICE_PINNED_PRIV";
            }
            case 15: {
                return "SCREEN_INTERACTIVE";
            }
            case 16: {
                return "SCREEN_NON_INTERACTIVE";
            }
            case 17: {
                return "KEYGUARD_SHOWN";
            }
            case 18: {
                return "KEYGUARD_HIDDEN";
            }
            case 26: {
                return "DEVICE_SHUTDOWN";
            }
            case 27: {
                return "DEVICE_STARTUP";
            }
        }
        return "UNKNOWN_TYPE_" + eventType;
    }

    byte[] getBackupPayload(String key) {
        return this.mDatabase.getBackupPayload(key);
    }

    void applyRestoredPayload(String key, byte[] payload) {
        this.mDatabase.applyRestoredPayload(key, payload);
    }

    static interface StatsUpdatedListener {
        public void onStatsUpdated();

        public void onStatsReloaded();

        public void onNewUpdate(int var1);
    }
}

