/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.usb;

import android.app.ActivityManager;
import android.app.KeyguardManager;
import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.debug.AdbManagerInternal;
import android.debug.IAdbTransport;
import android.hardware.usb.ParcelableUsbPort;
import android.hardware.usb.UsbAccessory;
import android.hardware.usb.UsbConfiguration;
import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbInterface;
import android.hardware.usb.UsbManager;
import android.hardware.usb.UsbPort;
import android.hardware.usb.UsbPortStatus;
import android.hardware.usb.gadget.V1_0.GadgetFunction;
import android.hardware.usb.gadget.V1_0.IUsbGadget;
import android.hardware.usb.gadget.V1_0.IUsbGadgetCallback;
import android.hidl.manager.V1_0.IServiceManager;
import android.hidl.manager.V1_0.IServiceNotification;
import android.os.Environment;
import android.os.FileUtils;
import android.os.Handler;
import android.os.IHwBinder;
import android.os.Looper;
import android.os.Message;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.os.UEventObserver;
import android.os.UserHandle;
import android.os.UserManager;
import android.os.storage.StorageManager;
import android.os.storage.StorageVolume;
import android.provider.Settings;
import android.util.Pair;
import android.util.Slog;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.logging.MetricsLogger;
import com.android.internal.notification.SystemNotificationChannels;
import com.android.internal.os.SomeArgs;
import com.android.internal.util.dump.DualDumpOutputStream;
import com.android.internal.util.dump.DumpUtils;
import com.android.server.FgThread;
import com.android.server.LocalServices;
import com.android.server.usb.UsbAlsaManager;
import com.android.server.usb.UsbProfileGroupSettingsManager;
import com.android.server.usb.UsbSerialReader;
import com.android.server.usb.UsbSettingsManager;
import com.android.server.usb.UsbUserSettingsManager;
import com.android.server.wm.ActivityTaskManagerInternal;
import java.io.File;
import java.io.FileDescriptor;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Scanner;
import java.util.Set;

public class UsbDeviceManager
implements ActivityTaskManagerInternal.ScreenObserver {
    private static final String TAG = UsbDeviceManager.class.getSimpleName();
    private static final boolean DEBUG = false;
    private static final String USB_PREFS_XML = "UsbDeviceManagerPrefs.xml";
    static final String UNLOCKED_CONFIG_PREF = "usb-screen-unlocked-config-%d";
    private static final String NORMAL_BOOT = "normal";
    private static final String USB_STATE_MATCH = "DEVPATH=/devices/virtual/android_usb/android0";
    private static final String ACCESSORY_START_MATCH = "DEVPATH=/devices/virtual/misc/usb_accessory";
    private static final String FUNCTIONS_PATH = "/sys/class/android_usb/android0/functions";
    private static final String STATE_PATH = "/sys/class/android_usb/android0/state";
    private static final String RNDIS_ETH_ADDR_PATH = "/sys/class/android_usb/android0/f_rndis/ethaddr";
    private static final String AUDIO_SOURCE_PCM_PATH = "/sys/class/android_usb/android0/f_audio_source/pcm";
    private static final String MIDI_ALSA_PATH = "/sys/class/android_usb/android0/f_midi/alsa";
    private static final int MSG_UPDATE_STATE = 0;
    private static final int MSG_ENABLE_ADB = 1;
    private static final int MSG_SET_CURRENT_FUNCTIONS = 2;
    private static final int MSG_SYSTEM_READY = 3;
    private static final int MSG_BOOT_COMPLETED = 4;
    private static final int MSG_USER_SWITCHED = 5;
    private static final int MSG_UPDATE_USER_RESTRICTIONS = 6;
    private static final int MSG_UPDATE_PORT_STATE = 7;
    private static final int MSG_ACCESSORY_MODE_ENTER_TIMEOUT = 8;
    private static final int MSG_UPDATE_CHARGING_STATE = 9;
    private static final int MSG_UPDATE_HOST_STATE = 10;
    private static final int MSG_LOCALE_CHANGED = 11;
    private static final int MSG_SET_SCREEN_UNLOCKED_FUNCTIONS = 12;
    private static final int MSG_UPDATE_SCREEN_LOCK = 13;
    private static final int MSG_SET_CHARGING_FUNCTIONS = 14;
    private static final int MSG_SET_FUNCTIONS_TIMEOUT = 15;
    private static final int MSG_GET_CURRENT_USB_FUNCTIONS = 16;
    private static final int MSG_FUNCTION_SWITCH_TIMEOUT = 17;
    private static final int MSG_GADGET_HAL_REGISTERED = 18;
    private static final int AUDIO_MODE_SOURCE = 1;
    private static final int UPDATE_DELAY = 1000;
    private static final int ACCESSORY_REQUEST_TIMEOUT = 10000;
    private static final String BOOT_MODE_PROPERTY = "ro.bootmode";
    private static final String ADB_NOTIFICATION_CHANNEL_ID_TV = "usbdevicemanager.adb.tv";
    private UsbHandler mHandler;
    private final Object mLock = new Object();
    private final Context mContext;
    private final ContentResolver mContentResolver;
    @GuardedBy(value={"mLock"})
    private UsbProfileGroupSettingsManager mCurrentSettings;
    private final boolean mHasUsbAccessory;
    @GuardedBy(value={"mLock"})
    private String[] mAccessoryStrings;
    private final UEventObserver mUEventObserver;
    private static Set<Integer> sBlackListedInterfaces = new HashSet<Integer>();
    private HashMap<Long, FileDescriptor> mControlFds;

    @Override
    public void onKeyguardStateChanged(boolean isShowing) {
        int userHandle = ActivityManager.getCurrentUser();
        boolean secure = this.mContext.getSystemService(KeyguardManager.class).isDeviceSecure(userHandle);
        this.mHandler.sendMessage(13, isShowing && secure);
    }

    @Override
    public void onAwakeStateChanged(boolean isAwake) {
    }

    public void onUnlockUser(int userHandle) {
        this.onKeyguardStateChanged(false);
    }

    public UsbDeviceManager(Context context, UsbAlsaManager alsaManager, UsbSettingsManager settingsManager) {
        this.mContext = context;
        this.mContentResolver = context.getContentResolver();
        PackageManager pm = this.mContext.getPackageManager();
        this.mHasUsbAccessory = pm.hasSystemFeature("android.hardware.usb.accessory");
        UsbDeviceManager.initRndisAddress();
        boolean halNotPresent = false;
        try {
            IUsbGadget.getService(true);
        }
        catch (RemoteException e) {
            Slog.e(TAG, "USB GADGET HAL present but exception thrown", e);
        }
        catch (NoSuchElementException e) {
            halNotPresent = true;
            Slog.i(TAG, "USB GADGET HAL not present in the device", e);
        }
        this.mControlFds = new HashMap();
        FileDescriptor mtpFd = this.nativeOpenControl("mtp");
        if (mtpFd == null) {
            Slog.e(TAG, "Failed to open control for mtp");
        }
        this.mControlFds.put(4L, mtpFd);
        FileDescriptor ptpFd = this.nativeOpenControl("ptp");
        if (ptpFd == null) {
            Slog.e(TAG, "Failed to open control for ptp");
        }
        this.mControlFds.put(16L, ptpFd);
        this.mHandler = halNotPresent ? new UsbHandlerLegacy(FgThread.get().getLooper(), this.mContext, this, alsaManager, settingsManager) : new UsbHandlerHal(FgThread.get().getLooper(), this.mContext, this, alsaManager, settingsManager);
        if (this.nativeIsStartRequested()) {
            this.startAccessoryMode();
        }
        BroadcastReceiver portReceiver = new BroadcastReceiver(){

            @Override
            public void onReceive(Context context, Intent intent) {
                ParcelableUsbPort port = (ParcelableUsbPort)intent.getParcelableExtra("port");
                UsbPortStatus status = (UsbPortStatus)intent.getParcelableExtra("portStatus");
                UsbDeviceManager.this.mHandler.updateHostState(port.getUsbPort(context.getSystemService(UsbManager.class)), status);
            }
        };
        BroadcastReceiver chargingReceiver = new BroadcastReceiver(){

            @Override
            public void onReceive(Context context, Intent intent) {
                int chargePlug = intent.getIntExtra("plugged", -1);
                boolean usbCharging = chargePlug == 2;
                UsbDeviceManager.this.mHandler.sendMessage(9, usbCharging);
            }
        };
        BroadcastReceiver hostReceiver = new BroadcastReceiver(){

            @Override
            public void onReceive(Context context, Intent intent) {
                Iterator<Map.Entry<String, UsbDevice>> devices = ((UsbManager)context.getSystemService("usb")).getDeviceList().entrySet().iterator();
                if (intent.getAction().equals("android.hardware.usb.action.USB_DEVICE_ATTACHED")) {
                    UsbDeviceManager.this.mHandler.sendMessage(10, devices, true);
                } else {
                    UsbDeviceManager.this.mHandler.sendMessage(10, devices, false);
                }
            }
        };
        BroadcastReceiver languageChangedReceiver = new BroadcastReceiver(){

            @Override
            public void onReceive(Context context, Intent intent) {
                UsbDeviceManager.this.mHandler.sendEmptyMessage(11);
            }
        };
        this.mContext.registerReceiver(portReceiver, new IntentFilter("android.hardware.usb.action.USB_PORT_CHANGED"));
        this.mContext.registerReceiver(chargingReceiver, new IntentFilter("android.intent.action.BATTERY_CHANGED"));
        IntentFilter filter = new IntentFilter("android.hardware.usb.action.USB_DEVICE_ATTACHED");
        filter.addAction("android.hardware.usb.action.USB_DEVICE_DETACHED");
        this.mContext.registerReceiver(hostReceiver, filter);
        this.mContext.registerReceiver(languageChangedReceiver, new IntentFilter("android.intent.action.LOCALE_CHANGED"));
        this.mUEventObserver = new UsbUEventObserver();
        this.mUEventObserver.startObserving(USB_STATE_MATCH);
        this.mUEventObserver.startObserving(ACCESSORY_START_MATCH);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    UsbProfileGroupSettingsManager getCurrentSettings() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mCurrentSettings;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String[] getAccessoryStrings() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mAccessoryStrings;
        }
    }

    public void systemReady() {
        LocalServices.getService(ActivityTaskManagerInternal.class).registerScreenObserver(this);
        this.mHandler.sendEmptyMessage(3);
    }

    public void bootCompleted() {
        this.mHandler.sendEmptyMessage(4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCurrentUser(int newCurrentUserId, UsbProfileGroupSettingsManager settings) {
        Object object = this.mLock;
        synchronized (object) {
            this.mCurrentSettings = settings;
            this.mHandler.obtainMessage(5, newCurrentUserId, 0).sendToTarget();
        }
    }

    public void updateUserRestrictions() {
        this.mHandler.sendEmptyMessage(6);
    }

    private void startAccessoryMode() {
        if (!this.mHasUsbAccessory) {
            return;
        }
        this.mAccessoryStrings = this.nativeGetAccessoryStrings();
        boolean enableAudio = this.nativeGetAudioMode() == 1;
        boolean enableAccessory = this.mAccessoryStrings != null && this.mAccessoryStrings[0] != null && this.mAccessoryStrings[1] != null;
        long functions = 0L;
        if (enableAccessory) {
            functions |= 2L;
        }
        if (enableAudio) {
            functions |= 0x40L;
        }
        if (functions != 0L) {
            this.mHandler.sendMessageDelayed(this.mHandler.obtainMessage(8), 10000L);
            this.setCurrentFunctions(functions);
        }
    }

    private static void initRndisAddress() {
        int ETH_ALEN = 6;
        int[] address = new int[6];
        address[0] = 2;
        String serial = SystemProperties.get("ro.serialno", "1234567890ABCDEF");
        int serialLength = serial.length();
        for (int i = 0; i < serialLength; ++i) {
            int n = i % 5 + 1;
            address[n] = address[n] ^ serial.charAt(i);
        }
        String addrString = String.format(Locale.US, "%02X:%02X:%02X:%02X:%02X:%02X", address[0], address[1], address[2], address[3], address[4], address[5]);
        try {
            FileUtils.stringToFile(RNDIS_ETH_ADDR_PATH, addrString);
        }
        catch (IOException e) {
            Slog.e(TAG, "failed to write to /sys/class/android_usb/android0/f_rndis/ethaddr");
        }
    }

    public UsbAccessory getCurrentAccessory() {
        return this.mHandler.getCurrentAccessory();
    }

    public ParcelFileDescriptor openAccessory(UsbAccessory accessory, UsbUserSettingsManager settings, int uid) {
        UsbAccessory currentAccessory = this.mHandler.getCurrentAccessory();
        if (currentAccessory == null) {
            throw new IllegalArgumentException("no accessory attached");
        }
        if (!currentAccessory.equals(accessory)) {
            String error = accessory.toString() + " does not match current accessory " + currentAccessory;
            throw new IllegalArgumentException(error);
        }
        settings.checkPermission(accessory, uid);
        return this.nativeOpenAccessory();
    }

    public long getCurrentFunctions() {
        return this.mHandler.getEnabledFunctions();
    }

    public ParcelFileDescriptor getControlFd(long usbFunction) {
        FileDescriptor fd = this.mControlFds.get(usbFunction);
        if (fd == null) {
            return null;
        }
        try {
            return ParcelFileDescriptor.dup(fd);
        }
        catch (IOException e) {
            Slog.e(TAG, "Could not dup fd for " + usbFunction);
            return null;
        }
    }

    public long getScreenUnlockedFunctions() {
        return this.mHandler.getScreenUnlockedFunctions();
    }

    public void setCurrentFunctions(long functions) {
        if (functions == 0L) {
            MetricsLogger.action(this.mContext, 1275);
        } else if (functions == 4L) {
            MetricsLogger.action(this.mContext, 1276);
        } else if (functions == 16L) {
            MetricsLogger.action(this.mContext, 1277);
        } else if (functions == 8L) {
            MetricsLogger.action(this.mContext, 1279);
        } else if (functions == 32L) {
            MetricsLogger.action(this.mContext, 1278);
        } else if (functions == 2L) {
            MetricsLogger.action(this.mContext, 1280);
        }
        this.mHandler.sendMessage(2, functions);
    }

    public void setScreenUnlockedFunctions(long functions) {
        this.mHandler.sendMessage(12, functions);
    }

    private void onAdbEnabled(boolean enabled) {
        this.mHandler.sendMessage(1, enabled);
    }

    public void dump(DualDumpOutputStream dump, String idName, long id2) {
        long token = dump.start(idName, id2);
        if (this.mHandler != null) {
            this.mHandler.dump(dump, "handler", 0x10B00000001L);
        }
        dump.end(token);
    }

    private native String[] nativeGetAccessoryStrings();

    private native ParcelFileDescriptor nativeOpenAccessory();

    private native FileDescriptor nativeOpenControl(String var1);

    private native boolean nativeIsStartRequested();

    private native int nativeGetAudioMode();

    static {
        sBlackListedInterfaces.add(1);
        sBlackListedInterfaces.add(2);
        sBlackListedInterfaces.add(3);
        sBlackListedInterfaces.add(7);
        sBlackListedInterfaces.add(8);
        sBlackListedInterfaces.add(9);
        sBlackListedInterfaces.add(10);
        sBlackListedInterfaces.add(11);
        sBlackListedInterfaces.add(13);
        sBlackListedInterfaces.add(14);
        sBlackListedInterfaces.add(224);
    }

    private static final class UsbHandlerHal
    extends UsbHandler {
        @GuardedBy(value={"mGadgetProxyLock"})
        private IUsbGadget mGadgetProxy;
        private final Object mGadgetProxyLock = new Object();
        private static final int USB_GADGET_HAL_DEATH_COOKIE = 2000;
        private int mCurrentRequest = 0;
        private static final int SET_FUNCTIONS_TIMEOUT_MS = 3000;
        private static final int SET_FUNCTIONS_LEEWAY_MS = 500;
        private static final int ENUMERATION_TIME_OUT_MS = 2000;
        protected static final String CTL_START = "ctl.start";
        protected static final String CTL_STOP = "ctl.stop";
        protected static final String ADBD = "adbd";
        protected static final String GADGET_HAL_FQ_NAME = "android.hardware.usb.gadget@1.0::IUsbGadget";
        protected boolean mCurrentUsbFunctionsRequested;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        UsbHandlerHal(Looper looper, Context context, UsbDeviceManager deviceManager, UsbAlsaManager alsaManager, UsbSettingsManager settingsManager) {
            super(looper, context, deviceManager, alsaManager, settingsManager);
            try {
                ServiceNotification serviceNotification = new ServiceNotification();
                boolean ret = IServiceManager.getService().registerForNotifications(GADGET_HAL_FQ_NAME, "", serviceNotification);
                if (!ret) {
                    Slog.e(TAG, "Failed to register usb gadget service start notification");
                    return;
                }
                Object object = this.mGadgetProxyLock;
                synchronized (object) {
                    this.mGadgetProxy = IUsbGadget.getService(true);
                    this.mGadgetProxy.linkToDeath(new UsbGadgetDeathRecipient(), 2000L);
                    this.mCurrentFunctions = 0L;
                    this.mCurrentUsbFunctionsRequested = true;
                    this.mGadgetProxy.getCurrentUsbFunctions(new UsbGadgetCallback());
                }
                String state = FileUtils.readTextFile(new File(UsbDeviceManager.STATE_PATH), 0, null).trim();
                this.updateState(state);
            }
            catch (NoSuchElementException e) {
                Slog.e(TAG, "Usb gadget hal not found", e);
            }
            catch (RemoteException e) {
                Slog.e(TAG, "Usb Gadget hal not responding", e);
            }
            catch (Exception e) {
                Slog.e(TAG, "Error initializing UsbHandler", e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 14: {
                    this.setEnabledFunctions(0L, false);
                    break;
                }
                case 15: {
                    Slog.e(TAG, "Set functions timed out! no reply from usb hal");
                    if (msg.arg1 == 1) break;
                    this.setEnabledFunctions(0L, false);
                    break;
                }
                case 16: {
                    Slog.e(TAG, "prcessing MSG_GET_CURRENT_USB_FUNCTIONS");
                    this.mCurrentUsbFunctionsReceived = true;
                    if (this.mCurrentUsbFunctionsRequested) {
                        Slog.e(TAG, "updating mCurrentFunctions");
                        this.mCurrentFunctions = (Long)msg.obj & 0xFFFFFFFFFFFFFFFEL;
                        Slog.e(TAG, "mCurrentFunctions:" + this.mCurrentFunctions + "applied:" + msg.arg1);
                        this.mCurrentFunctionsApplied = msg.arg1 == 1;
                    }
                    this.finishBoot();
                    break;
                }
                case 17: {
                    if (msg.arg1 == 1) break;
                    this.setEnabledFunctions(0L, !this.isAdbEnabled());
                    break;
                }
                case 18: {
                    boolean preexisting = msg.arg1 == 1;
                    Object object = this.mGadgetProxyLock;
                    synchronized (object) {
                        try {
                            this.mGadgetProxy = IUsbGadget.getService();
                            this.mGadgetProxy.linkToDeath(new UsbGadgetDeathRecipient(), 2000L);
                            if (!this.mCurrentFunctionsApplied && !preexisting) {
                                this.setEnabledFunctions(this.mCurrentFunctions, false);
                            }
                        }
                        catch (NoSuchElementException e) {
                            Slog.e(TAG, "Usb gadget hal not found", e);
                        }
                        catch (RemoteException e) {
                            Slog.e(TAG, "Usb Gadget hal not responding", e);
                        }
                        break;
                    }
                }
                default: {
                    super.handleMessage(msg);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void setUsbConfig(long config, boolean chargingFunctions) {
            Slog.d(TAG, "setUsbConfig(" + config + ") request:" + ++this.mCurrentRequest);
            this.removeMessages(17);
            this.removeMessages(15);
            this.removeMessages(14);
            Object object = this.mGadgetProxyLock;
            synchronized (object) {
                if (this.mGadgetProxy == null) {
                    Slog.e(TAG, "setUsbConfig mGadgetProxy is null");
                    return;
                }
                try {
                    if ((config & 1L) != 0L) {
                        this.setSystemProperty(CTL_START, ADBD);
                    } else {
                        this.setSystemProperty(CTL_STOP, ADBD);
                    }
                    UsbGadgetCallback usbGadgetCallback = new UsbGadgetCallback(this.mCurrentRequest, config, chargingFunctions);
                    this.mGadgetProxy.setCurrentUsbFunctions(config, usbGadgetCallback, 2500L);
                    this.sendMessageDelayed(15, chargingFunctions, 3000L);
                    this.sendMessageDelayed(17, chargingFunctions, 5000L);
                }
                catch (RemoteException e) {
                    Slog.e(TAG, "Remoteexception while calling setCurrentUsbFunctions", e);
                }
            }
        }

        @Override
        protected void setEnabledFunctions(long functions, boolean forceRestart) {
            if (this.mCurrentFunctions != functions || !this.mCurrentFunctionsApplied || forceRestart) {
                Slog.i(TAG, "Setting USB config to " + UsbManager.usbFunctionsToString(functions));
                this.mCurrentFunctions = functions;
                this.mCurrentFunctionsApplied = false;
                this.mCurrentUsbFunctionsRequested = false;
                boolean chargingFunctions = functions == 0L;
                functions = this.getAppliedFunctions(functions);
                this.setUsbConfig(functions, chargingFunctions);
                if (this.mBootCompleted && this.isUsbDataTransferActive(functions)) {
                    this.updateUsbStateBroadcastIfNeeded(functions);
                }
            }
        }

        private class UsbGadgetCallback
        extends IUsbGadgetCallback.Stub {
            int mRequest;
            long mFunctions;
            boolean mChargingFunctions;

            UsbGadgetCallback() {
            }

            UsbGadgetCallback(int request, long functions, boolean chargingFunctions) {
                this.mRequest = request;
                this.mFunctions = functions;
                this.mChargingFunctions = chargingFunctions;
            }

            @Override
            public void setCurrentUsbFunctionsCb(long functions, int status) {
                if (UsbHandlerHal.this.mCurrentRequest != this.mRequest || !UsbHandlerHal.this.hasMessages(15) || this.mFunctions != functions) {
                    return;
                }
                UsbHandlerHal.this.removeMessages(15);
                Slog.e(TAG, "notifyCurrentFunction request:" + this.mRequest + " status:" + status);
                if (status == 0) {
                    UsbHandlerHal.this.mCurrentFunctionsApplied = true;
                } else if (!this.mChargingFunctions) {
                    Slog.e(TAG, "Setting default fuctions");
                    UsbHandlerHal.this.sendEmptyMessage(14);
                }
            }

            @Override
            public void getCurrentUsbFunctionsCb(long functions, int status) {
                UsbHandlerHal.this.sendMessage(16, functions, status == 2);
            }
        }

        final class ServiceNotification
        extends IServiceNotification.Stub {
            ServiceNotification() {
            }

            @Override
            public void onRegistration(String fqName, String name, boolean preexisting) {
                Slog.i(TAG, "Usb gadget hal service started " + fqName + " " + name);
                if (!fqName.equals(UsbHandlerHal.GADGET_HAL_FQ_NAME)) {
                    Slog.e(TAG, "fqName does not match");
                    return;
                }
                UsbHandlerHal.this.sendMessage(18, preexisting);
            }
        }

        final class UsbGadgetDeathRecipient
        implements IHwBinder.DeathRecipient {
            UsbGadgetDeathRecipient() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void serviceDied(long cookie) {
                if (cookie == 2000L) {
                    Slog.e(TAG, "Usb Gadget hal service died cookie: " + cookie);
                    Object object = UsbHandlerHal.this.mGadgetProxyLock;
                    synchronized (object) {
                        UsbHandlerHal.this.mGadgetProxy = null;
                    }
                }
            }
        }
    }

    private static final class UsbHandlerLegacy
    extends UsbHandler {
        private static final String USB_CONFIG_PROPERTY = "sys.usb.config";
        private static final String USB_STATE_PROPERTY = "sys.usb.state";
        private HashMap<String, HashMap<String, Pair<String, String>>> mOemModeMap;
        private String mCurrentOemFunctions;
        private String mCurrentFunctionsStr;
        private boolean mUsbDataUnlocked;

        UsbHandlerLegacy(Looper looper, Context context, UsbDeviceManager deviceManager, UsbAlsaManager alsaManager, UsbSettingsManager settingsManager) {
            super(looper, context, deviceManager, alsaManager, settingsManager);
            try {
                this.readOemUsbOverrideConfig(context);
                this.mCurrentOemFunctions = this.getSystemProperty(this.getPersistProp(false), "none");
                if (this.isNormalBoot()) {
                    this.mCurrentFunctionsStr = this.getSystemProperty(USB_CONFIG_PROPERTY, "none");
                    this.mCurrentFunctionsApplied = this.mCurrentFunctionsStr.equals(this.getSystemProperty(USB_STATE_PROPERTY, "none"));
                } else {
                    this.mCurrentFunctionsStr = this.getSystemProperty(this.getPersistProp(true), "none");
                    this.mCurrentFunctionsApplied = this.getSystemProperty(USB_CONFIG_PROPERTY, "none").equals(this.getSystemProperty(USB_STATE_PROPERTY, "none"));
                }
                this.mCurrentFunctions = 0L;
                this.mCurrentUsbFunctionsReceived = true;
                String state = FileUtils.readTextFile(new File(UsbDeviceManager.STATE_PATH), 0, null).trim();
                this.updateState(state);
            }
            catch (Exception e) {
                Slog.e(TAG, "Error initializing UsbHandler", e);
            }
        }

        private void readOemUsbOverrideConfig(Context context) {
            String[] configList = context.getResources().getStringArray(17236047);
            if (configList != null) {
                for (String config : configList) {
                    HashMap<String, Pair<String, String>> overrideMap;
                    String[] items = config.split(":");
                    if (items.length != 3 && items.length != 4) continue;
                    if (this.mOemModeMap == null) {
                        this.mOemModeMap = new HashMap();
                    }
                    if ((overrideMap = this.mOemModeMap.get(items[0])) == null) {
                        overrideMap = new HashMap();
                        this.mOemModeMap.put(items[0], overrideMap);
                    }
                    if (overrideMap.containsKey(items[1])) continue;
                    if (items.length == 3) {
                        overrideMap.put(items[1], new Pair<String, String>(items[2], ""));
                        continue;
                    }
                    overrideMap.put(items[1], new Pair<String, String>(items[2], items[3]));
                }
            }
        }

        private String applyOemOverrideFunction(String usbFunctions) {
            if (usbFunctions == null || this.mOemModeMap == null) {
                return usbFunctions;
            }
            String bootMode = this.getSystemProperty(UsbDeviceManager.BOOT_MODE_PROPERTY, "unknown");
            Slog.d(TAG, "applyOemOverride usbfunctions=" + usbFunctions + " bootmode=" + bootMode);
            Map overridesMap = this.mOemModeMap.get(bootMode);
            if (overridesMap != null && !bootMode.equals(UsbDeviceManager.NORMAL_BOOT) && !bootMode.equals("unknown")) {
                Pair overrideFunctions = (Pair)overridesMap.get(usbFunctions);
                if (overrideFunctions != null) {
                    Slog.d(TAG, "OEM USB override: " + usbFunctions + " ==> " + (String)overrideFunctions.first + " persist across reboot " + (String)overrideFunctions.second);
                    if (!((String)overrideFunctions.second).equals("")) {
                        String newFunction = this.isAdbEnabled() ? UsbHandlerLegacy.addFunction((String)overrideFunctions.second, "adb") : (String)overrideFunctions.second;
                        Slog.d(TAG, "OEM USB override persisting: " + newFunction + "in prop: " + this.getPersistProp(false));
                        this.setSystemProperty(this.getPersistProp(false), newFunction);
                    }
                    return (String)overrideFunctions.first;
                }
                if (this.isAdbEnabled()) {
                    String newFunction = UsbHandlerLegacy.addFunction("none", "adb");
                    this.setSystemProperty(this.getPersistProp(false), newFunction);
                } else {
                    this.setSystemProperty(this.getPersistProp(false), "none");
                }
            }
            return usbFunctions;
        }

        private boolean waitForState(String state) {
            String value = null;
            for (int i = 0; i < 20; ++i) {
                value = this.getSystemProperty(USB_STATE_PROPERTY, "");
                if (state.equals(value)) {
                    return true;
                }
                SystemClock.sleep(50L);
            }
            Slog.e(TAG, "waitForState(" + state + ") FAILED: got " + value);
            return false;
        }

        private void setUsbConfig(String config) {
            this.setSystemProperty(USB_CONFIG_PROPERTY, config);
        }

        @Override
        protected void setEnabledFunctions(long usbFunctions, boolean forceRestart) {
            boolean usbDataUnlocked = this.isUsbDataTransferActive(usbFunctions);
            if (usbDataUnlocked != this.mUsbDataUnlocked) {
                this.mUsbDataUnlocked = usbDataUnlocked;
                this.updateUsbNotification(false);
                forceRestart = true;
            }
            long oldFunctions = this.mCurrentFunctions;
            boolean oldFunctionsApplied = this.mCurrentFunctionsApplied;
            if (this.trySetEnabledFunctions(usbFunctions, forceRestart)) {
                return;
            }
            if (oldFunctionsApplied && oldFunctions != usbFunctions) {
                Slog.e(TAG, "Failsafe 1: Restoring previous USB functions.");
                if (this.trySetEnabledFunctions(oldFunctions, false)) {
                    return;
                }
            }
            Slog.e(TAG, "Failsafe 2: Restoring default USB functions.");
            if (this.trySetEnabledFunctions(0L, false)) {
                return;
            }
            Slog.e(TAG, "Failsafe 3: Restoring empty function list (with ADB if enabled).");
            if (this.trySetEnabledFunctions(0L, false)) {
                return;
            }
            Slog.e(TAG, "Unable to set any USB functions!");
        }

        private boolean isNormalBoot() {
            String bootMode = this.getSystemProperty(UsbDeviceManager.BOOT_MODE_PROPERTY, "unknown");
            return bootMode.equals(UsbDeviceManager.NORMAL_BOOT) || bootMode.equals("unknown");
        }

        protected String applyAdbFunction(String functions) {
            if (functions == null) {
                functions = "";
            }
            functions = this.isAdbEnabled() ? UsbHandlerLegacy.addFunction(functions, "adb") : UsbHandlerLegacy.removeFunction(functions, "adb");
            return functions;
        }

        private boolean trySetEnabledFunctions(long usbFunctions, boolean forceRestart) {
            String functions = null;
            if (usbFunctions != 0L) {
                functions = UsbManager.usbFunctionsToString(usbFunctions);
            }
            this.mCurrentFunctions = usbFunctions;
            if (functions == null || this.applyAdbFunction(functions).equals("none")) {
                functions = UsbManager.usbFunctionsToString(this.getChargingFunctions());
            }
            functions = this.applyAdbFunction(functions);
            String oemFunctions = this.applyOemOverrideFunction(functions);
            if (!this.isNormalBoot() && !this.mCurrentFunctionsStr.equals(functions)) {
                this.setSystemProperty(this.getPersistProp(true), functions);
            }
            if (!functions.equals(oemFunctions) && !this.mCurrentOemFunctions.equals(oemFunctions) || !this.mCurrentFunctionsStr.equals(functions) || !this.mCurrentFunctionsApplied || forceRestart) {
                Slog.i(TAG, "Setting USB config to " + functions);
                this.mCurrentFunctionsStr = functions;
                this.mCurrentOemFunctions = oemFunctions;
                this.mCurrentFunctionsApplied = false;
                this.setUsbConfig("none");
                if (!this.waitForState("none")) {
                    Slog.e(TAG, "Failed to kick USB config");
                    return false;
                }
                this.setUsbConfig(oemFunctions);
                if (this.mBootCompleted && (UsbHandlerLegacy.containsFunction(functions, "mtp") || UsbHandlerLegacy.containsFunction(functions, "ptp"))) {
                    this.updateUsbStateBroadcastIfNeeded(this.getAppliedFunctions(this.mCurrentFunctions));
                }
                if (!this.waitForState(oemFunctions)) {
                    Slog.e(TAG, "Failed to switch USB config to " + functions);
                    return false;
                }
                this.mCurrentFunctionsApplied = true;
            }
            return true;
        }

        private String getPersistProp(boolean functions) {
            String bootMode = this.getSystemProperty(UsbDeviceManager.BOOT_MODE_PROPERTY, "unknown");
            String persistProp = "persist.sys.usb.config";
            if (!bootMode.equals(UsbDeviceManager.NORMAL_BOOT) && !bootMode.equals("unknown")) {
                persistProp = functions ? "persist.sys.usb." + bootMode + ".func" : "persist.sys.usb." + bootMode + ".config";
            }
            return persistProp;
        }

        private static String addFunction(String functions, String function) {
            if ("none".equals(functions)) {
                return function;
            }
            if (!UsbHandlerLegacy.containsFunction(functions, function)) {
                if (functions.length() > 0) {
                    functions = functions + ",";
                }
                functions = functions + function;
            }
            return functions;
        }

        private static String removeFunction(String functions, String function) {
            String[] split = functions.split(",");
            for (int i = 0; i < split.length; ++i) {
                if (!function.equals(split[i])) continue;
                split[i] = null;
            }
            if (split.length == 1 && split[0] == null) {
                return "none";
            }
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < split.length; ++i) {
                String s = split[i];
                if (s == null) continue;
                if (builder.length() > 0) {
                    builder.append(",");
                }
                builder.append(s);
            }
            return builder.toString();
        }

        static boolean containsFunction(String functions, String function) {
            int index = functions.indexOf(function);
            if (index < 0) {
                return false;
            }
            if (index > 0 && functions.charAt(index - 1) != ',') {
                return false;
            }
            int charAfter = index + function.length();
            return charAfter >= functions.length() || functions.charAt(charAfter) == ',';
        }
    }

    static abstract class UsbHandler
    extends Handler {
        private boolean mConnected;
        private boolean mHostConnected;
        private boolean mSourcePower;
        private boolean mSinkPower;
        private boolean mConfigured;
        private boolean mAudioAccessoryConnected;
        private boolean mAudioAccessorySupported;
        private UsbAccessory mCurrentAccessory;
        private int mUsbNotificationId;
        private boolean mAdbNotificationShown;
        private boolean mUsbCharging;
        private boolean mHideUsbNotification;
        private boolean mSupportsAllCombinations;
        private boolean mScreenLocked;
        private boolean mSystemReady;
        private Intent mBroadcastedIntent;
        private boolean mPendingBootBroadcast;
        private boolean mAudioSourceEnabled;
        private boolean mMidiEnabled;
        private int mMidiCard;
        private int mMidiDevice;
        private final Context mContext;
        private final UsbAlsaManager mUsbAlsaManager;
        private final UsbSettingsManager mSettingsManager;
        private NotificationManager mNotificationManager;
        protected long mScreenUnlockedFunctions;
        protected boolean mBootCompleted;
        protected boolean mCurrentFunctionsApplied;
        protected boolean mUseUsbNotification;
        protected long mCurrentFunctions;
        protected final UsbDeviceManager mUsbDeviceManager;
        protected final ContentResolver mContentResolver;
        protected SharedPreferences mSettings;
        protected int mCurrentUser;
        protected boolean mCurrentUsbFunctionsReceived;
        protected static final String USB_PERSISTENT_CONFIG_PROPERTY = "persist.sys.usb.config";

        UsbHandler(Looper looper, Context context, UsbDeviceManager deviceManager, UsbAlsaManager alsaManager, UsbSettingsManager settingsManager) {
            super(looper);
            this.mContext = context;
            this.mUsbDeviceManager = deviceManager;
            this.mUsbAlsaManager = alsaManager;
            this.mSettingsManager = settingsManager;
            this.mContentResolver = context.getContentResolver();
            this.mCurrentUser = ActivityManager.getCurrentUser();
            this.mScreenLocked = true;
            this.mSettings = this.getPinnedSharedPrefs(this.mContext);
            if (this.mSettings == null) {
                Slog.e(TAG, "Couldn't load shared preferences");
            } else {
                this.mScreenUnlockedFunctions = UsbManager.usbFunctionsFromString(this.mSettings.getString(String.format(Locale.ENGLISH, UsbDeviceManager.UNLOCKED_CONFIG_PREF, this.mCurrentUser), ""));
            }
            StorageManager storageManager = StorageManager.from(this.mContext);
            StorageVolume primary = storageManager != null ? storageManager.getPrimaryVolume() : null;
            boolean massStorageSupported = primary != null && primary.allowMassStorage();
            this.mUseUsbNotification = !massStorageSupported && this.mContext.getResources().getBoolean(17891554);
        }

        public void sendMessage(int what, boolean arg) {
            this.removeMessages(what);
            Message m = Message.obtain((Handler)this, what);
            m.arg1 = arg ? 1 : 0;
            this.sendMessage(m);
        }

        public void sendMessage(int what, Object arg) {
            this.removeMessages(what);
            Message m = Message.obtain((Handler)this, what);
            m.obj = arg;
            this.sendMessage(m);
        }

        public void sendMessage(int what, Object arg, boolean arg1) {
            this.removeMessages(what);
            Message m = Message.obtain((Handler)this, what);
            m.obj = arg;
            m.arg1 = arg1 ? 1 : 0;
            this.sendMessage(m);
        }

        public void sendMessage(int what, boolean arg1, boolean arg2) {
            this.removeMessages(what);
            Message m = Message.obtain((Handler)this, what);
            m.arg1 = arg1 ? 1 : 0;
            m.arg2 = arg2 ? 1 : 0;
            this.sendMessage(m);
        }

        public void sendMessageDelayed(int what, boolean arg, long delayMillis) {
            this.removeMessages(what);
            Message m = Message.obtain((Handler)this, what);
            m.arg1 = arg ? 1 : 0;
            this.sendMessageDelayed(m, delayMillis);
        }

        public void updateState(String state) {
            int configured;
            int connected;
            if ("DISCONNECTED".equals(state)) {
                connected = 0;
                configured = 0;
            } else if ("CONNECTED".equals(state)) {
                connected = 1;
                configured = 0;
            } else if ("CONFIGURED".equals(state)) {
                connected = 1;
                configured = 1;
            } else {
                Slog.e(TAG, "unknown state " + state);
                return;
            }
            this.removeMessages(0);
            if (connected == 1) {
                this.removeMessages(17);
            }
            Message msg = Message.obtain((Handler)this, 0);
            msg.arg1 = connected;
            msg.arg2 = configured;
            this.sendMessageDelayed(msg, connected == 0 ? 1000L : 0L);
        }

        public void updateHostState(UsbPort port, UsbPortStatus status) {
            SomeArgs args = SomeArgs.obtain();
            args.arg1 = port;
            args.arg2 = status;
            this.removeMessages(7);
            Message msg = this.obtainMessage(7, args);
            this.sendMessageDelayed(msg, 1000L);
        }

        private void setAdbEnabled(boolean enable) {
            if (enable) {
                this.setSystemProperty(USB_PERSISTENT_CONFIG_PROPERTY, "adb");
            } else {
                this.setSystemProperty(USB_PERSISTENT_CONFIG_PROPERTY, "");
            }
            this.setEnabledFunctions(this.mCurrentFunctions, true);
            this.updateAdbNotification(false);
        }

        protected boolean isUsbTransferAllowed() {
            UserManager userManager = (UserManager)this.mContext.getSystemService("user");
            return !userManager.hasUserRestriction("no_usb_file_transfer");
        }

        private void updateCurrentAccessory() {
            boolean enteringAccessoryMode = this.hasMessages(8);
            if (this.mConfigured && enteringAccessoryMode) {
                String[] accessoryStrings = this.mUsbDeviceManager.getAccessoryStrings();
                if (accessoryStrings != null) {
                    UsbSerialReader serialReader = new UsbSerialReader(this.mContext, this.mSettingsManager, accessoryStrings[5]);
                    this.mCurrentAccessory = new UsbAccessory(accessoryStrings[0], accessoryStrings[1], accessoryStrings[2], accessoryStrings[3], accessoryStrings[4], serialReader);
                    serialReader.setDevice(this.mCurrentAccessory);
                    Slog.d(TAG, "entering USB accessory mode: " + this.mCurrentAccessory);
                    if (this.mBootCompleted) {
                        this.mUsbDeviceManager.getCurrentSettings().accessoryAttached(this.mCurrentAccessory);
                    }
                } else {
                    Slog.e(TAG, "nativeGetAccessoryStrings failed");
                }
            } else if (!enteringAccessoryMode) {
                this.notifyAccessoryModeExit();
            }
        }

        private void notifyAccessoryModeExit() {
            Slog.d(TAG, "exited USB accessory mode");
            this.setEnabledFunctions(0L, false);
            if (this.mCurrentAccessory != null) {
                if (this.mBootCompleted) {
                    this.mSettingsManager.usbAccessoryRemoved(this.mCurrentAccessory);
                }
                this.mCurrentAccessory = null;
            }
        }

        protected SharedPreferences getPinnedSharedPrefs(Context context) {
            File prefsFile = new File(Environment.getDataSystemDeDirectory(0), UsbDeviceManager.USB_PREFS_XML);
            return context.createDeviceProtectedStorageContext().getSharedPreferences(prefsFile, 0);
        }

        private boolean isUsbStateChanged(Intent intent) {
            Set<String> keySet = intent.getExtras().keySet();
            if (this.mBroadcastedIntent == null) {
                for (String key : keySet) {
                    if (!intent.getBooleanExtra(key, false)) continue;
                    return true;
                }
            } else {
                if (!keySet.equals(this.mBroadcastedIntent.getExtras().keySet())) {
                    return true;
                }
                for (String key : keySet) {
                    if (intent.getBooleanExtra(key, false) == this.mBroadcastedIntent.getBooleanExtra(key, false)) continue;
                    return true;
                }
            }
            return false;
        }

        protected void updateUsbStateBroadcastIfNeeded(long functions) {
            Intent intent = new Intent("android.hardware.usb.action.USB_STATE");
            intent.addFlags(0x31000000);
            intent.putExtra("connected", this.mConnected);
            intent.putExtra("host_connected", this.mHostConnected);
            intent.putExtra("configured", this.mConfigured);
            intent.putExtra("unlocked", this.isUsbTransferAllowed() && this.isUsbDataTransferActive(this.mCurrentFunctions));
            for (long remainingFunctions = functions; remainingFunctions != 0L; remainingFunctions -= Long.highestOneBit(remainingFunctions)) {
                intent.putExtra(UsbManager.usbFunctionsToString(Long.highestOneBit(remainingFunctions)), true);
            }
            if (!this.isUsbStateChanged(intent)) {
                return;
            }
            this.sendStickyBroadcast(intent);
            this.mBroadcastedIntent = intent;
        }

        protected void sendStickyBroadcast(Intent intent) {
            this.mContext.sendStickyBroadcastAsUser(intent, UserHandle.ALL);
        }

        private void updateUsbFunctions() {
            this.updateMidiFunction();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateMidiFunction() {
            boolean enabled;
            boolean bl = enabled = (this.mCurrentFunctions & 8L) != 0L;
            if (enabled != this.mMidiEnabled) {
                if (enabled) {
                    try (Scanner scanner = null;){
                        scanner = new Scanner(new File(UsbDeviceManager.MIDI_ALSA_PATH));
                        this.mMidiCard = scanner.nextInt();
                        this.mMidiDevice = scanner.nextInt();
                    }
                }
                this.mMidiEnabled = enabled;
            }
            this.mUsbAlsaManager.setPeripheralMidiState(this.mMidiEnabled && this.mConfigured, this.mMidiCard, this.mMidiDevice);
        }

        private void setScreenUnlockedFunctions() {
            this.setEnabledFunctions(this.mScreenUnlockedFunctions, false);
        }

        long getAppliedFunctions(long functions) {
            if (functions == 0L) {
                return this.getChargingFunctions();
            }
            if (this.isAdbEnabled()) {
                return functions | 1L;
            }
            return functions;
        }

        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 0: {
                    this.mConnected = msg.arg1 == 1;
                    this.mConfigured = msg.arg2 == 1;
                    this.updateUsbNotification(false);
                    this.updateAdbNotification(false);
                    if (this.mBootCompleted) {
                        this.updateUsbStateBroadcastIfNeeded(this.getAppliedFunctions(this.mCurrentFunctions));
                    }
                    if ((this.mCurrentFunctions & 2L) != 0L) {
                        this.updateCurrentAccessory();
                    }
                    if (this.mBootCompleted) {
                        if (!(this.mConnected || this.hasMessages(8) || this.hasMessages(17))) {
                            if (!this.mScreenLocked && this.mScreenUnlockedFunctions != 0L) {
                                this.setScreenUnlockedFunctions();
                            } else {
                                this.setEnabledFunctions(0L, false);
                            }
                        }
                        this.updateUsbFunctions();
                        break;
                    }
                    this.mPendingBootBroadcast = true;
                    break;
                }
                case 7: {
                    SomeArgs args = (SomeArgs)msg.obj;
                    boolean prevHostConnected = this.mHostConnected;
                    UsbPort port = (UsbPort)args.arg1;
                    UsbPortStatus status = (UsbPortStatus)args.arg2;
                    this.mHostConnected = status.getCurrentDataRole() == 1;
                    this.mSourcePower = status.getCurrentPowerRole() == 1;
                    this.mSinkPower = status.getCurrentPowerRole() == 2;
                    this.mAudioAccessoryConnected = status.getCurrentMode() == 4;
                    this.mAudioAccessorySupported = port.isModeSupported(4);
                    this.mSupportsAllCombinations = status.isRoleCombinationSupported(1, 1) && status.isRoleCombinationSupported(2, 1) && status.isRoleCombinationSupported(1, 2) && status.isRoleCombinationSupported(2, 2);
                    args.recycle();
                    this.updateUsbNotification(false);
                    if (this.mBootCompleted) {
                        if (!this.mHostConnected && !prevHostConnected) break;
                        this.updateUsbStateBroadcastIfNeeded(this.getAppliedFunctions(this.mCurrentFunctions));
                        break;
                    }
                    this.mPendingBootBroadcast = true;
                    break;
                }
                case 9: {
                    this.mUsbCharging = msg.arg1 == 1;
                    this.updateUsbNotification(false);
                    break;
                }
                case 10: {
                    Iterator devices = (Iterator)msg.obj;
                    boolean connected = msg.arg1 == 1;
                    this.mHideUsbNotification = false;
                    while (devices.hasNext()) {
                        Map.Entry pair = (Map.Entry)devices.next();
                        UsbDevice device = (UsbDevice)pair.getValue();
                        int configurationCount = device.getConfigurationCount() - 1;
                        block17: while (configurationCount >= 0) {
                            UsbConfiguration config = device.getConfiguration(configurationCount);
                            --configurationCount;
                            for (int interfaceCount = config.getInterfaceCount() - 1; interfaceCount >= 0; --interfaceCount) {
                                UsbInterface intrface = config.getInterface(interfaceCount);
                                if (!sBlackListedInterfaces.contains(intrface.getInterfaceClass())) continue;
                                this.mHideUsbNotification = true;
                                continue block17;
                            }
                        }
                    }
                    this.updateUsbNotification(false);
                    break;
                }
                case 1: {
                    this.setAdbEnabled(msg.arg1 == 1);
                    break;
                }
                case 2: {
                    long functions = (Long)msg.obj;
                    this.setEnabledFunctions(functions, false);
                    break;
                }
                case 12: {
                    this.mScreenUnlockedFunctions = (Long)msg.obj;
                    if (this.mSettings != null) {
                        SharedPreferences.Editor editor = this.mSettings.edit();
                        editor.putString(String.format(Locale.ENGLISH, UsbDeviceManager.UNLOCKED_CONFIG_PREF, this.mCurrentUser), UsbManager.usbFunctionsToString(this.mScreenUnlockedFunctions));
                        editor.commit();
                    }
                    if (this.mScreenLocked || this.mScreenUnlockedFunctions == 0L) break;
                    this.setScreenUnlockedFunctions();
                    break;
                }
                case 13: {
                    if (msg.arg1 == 1 == this.mScreenLocked) break;
                    boolean bl = this.mScreenLocked = msg.arg1 == 1;
                    if (!this.mBootCompleted) break;
                    if (this.mScreenLocked) {
                        if (this.mConnected) break;
                        this.setEnabledFunctions(0L, false);
                        break;
                    }
                    if (this.mScreenUnlockedFunctions == 0L || this.mCurrentFunctions != 0L) break;
                    this.setScreenUnlockedFunctions();
                    break;
                }
                case 6: {
                    if (!this.isUsbDataTransferActive(this.mCurrentFunctions) || this.isUsbTransferAllowed()) break;
                    this.setEnabledFunctions(0L, true);
                    break;
                }
                case 3: {
                    this.mNotificationManager = (NotificationManager)this.mContext.getSystemService("notification");
                    LocalServices.getService(AdbManagerInternal.class).registerTransport(new AdbTransport(this));
                    if (this.isTv()) {
                        this.mNotificationManager.createNotificationChannel(new NotificationChannel(UsbDeviceManager.ADB_NOTIFICATION_CHANNEL_ID_TV, this.mContext.getString(17039462), 4));
                    }
                    this.mSystemReady = true;
                    this.finishBoot();
                    break;
                }
                case 11: {
                    this.updateAdbNotification(true);
                    this.updateUsbNotification(true);
                    break;
                }
                case 4: {
                    this.mBootCompleted = true;
                    this.finishBoot();
                    break;
                }
                case 5: {
                    if (this.mCurrentUser == msg.arg1) break;
                    this.mCurrentUser = msg.arg1;
                    this.mScreenLocked = true;
                    this.mScreenUnlockedFunctions = 0L;
                    if (this.mSettings != null) {
                        this.mScreenUnlockedFunctions = UsbManager.usbFunctionsFromString(this.mSettings.getString(String.format(Locale.ENGLISH, UsbDeviceManager.UNLOCKED_CONFIG_PREF, this.mCurrentUser), ""));
                    }
                    this.setEnabledFunctions(0L, false);
                    break;
                }
                case 8: {
                    if (this.mConnected && (this.mCurrentFunctions & 2L) != 0L) break;
                    this.notifyAccessoryModeExit();
                }
            }
        }

        protected void finishBoot() {
            if (this.mBootCompleted && this.mCurrentUsbFunctionsReceived && this.mSystemReady) {
                if (this.mPendingBootBroadcast) {
                    this.updateUsbStateBroadcastIfNeeded(this.getAppliedFunctions(this.mCurrentFunctions));
                    this.mPendingBootBroadcast = false;
                }
                if (!this.mScreenLocked && this.mScreenUnlockedFunctions != 0L) {
                    this.setScreenUnlockedFunctions();
                } else {
                    this.setEnabledFunctions(0L, false);
                }
                if (this.mCurrentAccessory != null) {
                    this.mUsbDeviceManager.getCurrentSettings().accessoryAttached(this.mCurrentAccessory);
                }
                this.updateUsbNotification(false);
                this.updateAdbNotification(false);
                this.updateUsbFunctions();
            }
        }

        protected boolean isUsbDataTransferActive(long functions) {
            return (functions & 4L) != 0L || (functions & 0x10L) != 0L;
        }

        public UsbAccessory getCurrentAccessory() {
            return this.mCurrentAccessory;
        }

        protected void updateUsbNotification(boolean force) {
            if (this.mNotificationManager == null || !this.mUseUsbNotification || "0".equals(this.getSystemProperty("persist.charging.notify", ""))) {
                return;
            }
            if (this.mHideUsbNotification && !this.mSupportsAllCombinations) {
                if (this.mUsbNotificationId != 0) {
                    this.mNotificationManager.cancelAsUser(null, this.mUsbNotificationId, UserHandle.ALL);
                    this.mUsbNotificationId = 0;
                    Slog.d(TAG, "Clear notification");
                }
                return;
            }
            int id2 = 0;
            int titleRes = 0;
            Resources r = this.mContext.getResources();
            CharSequence message = r.getText(17041172);
            if (this.mAudioAccessoryConnected && !this.mAudioAccessorySupported) {
                titleRes = 17041178;
                id2 = 41;
            } else if (this.mConnected) {
                if (this.mCurrentFunctions == 4L) {
                    titleRes = 17041171;
                    id2 = 27;
                } else if (this.mCurrentFunctions == 16L) {
                    titleRes = 17041174;
                    id2 = 28;
                } else if (this.mCurrentFunctions == 8L) {
                    titleRes = 17041165;
                    id2 = 29;
                } else if (this.mCurrentFunctions == 32L) {
                    titleRes = 17041176;
                    id2 = 47;
                } else if (this.mCurrentFunctions == 2L) {
                    titleRes = 17041159;
                    id2 = 30;
                }
                if (this.mSourcePower) {
                    if (titleRes != 0) {
                        message = r.getText(17041173);
                    } else {
                        titleRes = 17041175;
                        id2 = 31;
                    }
                } else if (titleRes == 0) {
                    titleRes = 17041160;
                    id2 = 32;
                }
            } else if (this.mSourcePower) {
                titleRes = 17041175;
                id2 = 31;
            } else if (this.mHostConnected && this.mSinkPower && this.mUsbCharging) {
                titleRes = 17041160;
                id2 = 32;
            }
            if (id2 != this.mUsbNotificationId || force) {
                if (this.mUsbNotificationId != 0) {
                    this.mNotificationManager.cancelAsUser(null, this.mUsbNotificationId, UserHandle.ALL);
                    Slog.d(TAG, "Clear notification");
                    this.mUsbNotificationId = 0;
                }
                if (this.mContext.getPackageManager().hasSystemFeature("android.hardware.type.automotive") && id2 == 32) {
                    this.mUsbNotificationId = 0;
                    return;
                }
                if (id2 != 0) {
                    String channel;
                    PendingIntent pi;
                    Intent intent;
                    CharSequence title = r.getText(titleRes);
                    if (titleRes != 17041178) {
                        intent = Intent.makeRestartActivityTask(new ComponentName("com.android.settings", "com.android.settings.Settings$UsbDetailsActivity"));
                        pi = PendingIntent.getActivityAsUser(this.mContext, 0, intent, 0, null, UserHandle.CURRENT);
                        channel = SystemNotificationChannels.USB;
                    } else {
                        intent = new Intent();
                        intent.setClassName("com.android.settings", "com.android.settings.HelpTrampoline");
                        intent.putExtra("android.intent.extra.TEXT", "help_url_audio_accessory_not_supported");
                        pi = this.mContext.getPackageManager().resolveActivity(intent, 0) != null ? PendingIntent.getActivity(this.mContext, 0, intent, 0) : null;
                        channel = SystemNotificationChannels.ALERTS;
                        message = r.getText(17041177);
                    }
                    Notification.Builder builder = new Notification.Builder(this.mContext, channel).setSmallIcon(17303519).setWhen(0L).setOngoing(true).setTicker(title).setDefaults(0).setColor(this.mContext.getColor(17170460)).setContentTitle(title).setContentText(message).setContentIntent(pi).setVisibility(1);
                    if (titleRes == 17041178) {
                        builder.setStyle(new Notification.BigTextStyle().bigText(message));
                    }
                    Notification notification = builder.build();
                    this.mNotificationManager.notifyAsUser(null, id2, notification, UserHandle.ALL);
                    Slog.d(TAG, "push notification:" + title);
                    this.mUsbNotificationId = id2;
                }
            }
        }

        protected boolean isAdbEnabled() {
            return LocalServices.getService(AdbManagerInternal.class).isAdbEnabled();
        }

        protected void updateAdbNotification(boolean force) {
            if (this.mNotificationManager == null) {
                return;
            }
            int id2 = 26;
            int titleRes = 17039461;
            if (this.isAdbEnabled() && this.mConnected) {
                if ("0".equals(this.getSystemProperty("persist.adb.notify", ""))) {
                    return;
                }
                if (force && this.mAdbNotificationShown) {
                    this.mAdbNotificationShown = false;
                    this.mNotificationManager.cancelAsUser(null, 26, UserHandle.ALL);
                }
                if (!this.mAdbNotificationShown) {
                    Resources r = this.mContext.getResources();
                    CharSequence title = r.getText(17039461);
                    CharSequence message = r.getText(17039460);
                    Intent intent = new Intent("android.settings.APPLICATION_DEVELOPMENT_SETTINGS");
                    intent.addFlags(0x10008000);
                    PendingIntent pi = PendingIntent.getActivityAsUser(this.mContext, 0, intent, 0, null, UserHandle.CURRENT);
                    Notification notification = new Notification.Builder(this.mContext, SystemNotificationChannels.DEVELOPER).setSmallIcon(17303519).setWhen(0L).setOngoing(true).setTicker(title).setDefaults(0).setColor(this.mContext.getColor(17170460)).setContentTitle(title).setContentText(message).setContentIntent(pi).setVisibility(1).extend(new Notification.TvExtender().setChannelId(UsbDeviceManager.ADB_NOTIFICATION_CHANNEL_ID_TV)).build();
                    this.mAdbNotificationShown = true;
                    this.mNotificationManager.notifyAsUser(null, 26, notification, UserHandle.ALL);
                }
            } else if (this.mAdbNotificationShown) {
                this.mAdbNotificationShown = false;
                this.mNotificationManager.cancelAsUser(null, 26, UserHandle.ALL);
            }
        }

        private boolean isTv() {
            return this.mContext.getPackageManager().hasSystemFeature("android.software.leanback");
        }

        protected long getChargingFunctions() {
            if (this.isAdbEnabled()) {
                return 1L;
            }
            return 4L;
        }

        protected void setSystemProperty(String prop, String val) {
            SystemProperties.set(prop, val);
        }

        protected String getSystemProperty(String prop, String def) {
            return SystemProperties.get(prop, def);
        }

        protected void putGlobalSettings(ContentResolver contentResolver, String setting, int val) {
            Settings.Global.putInt(contentResolver, setting, val);
        }

        public long getEnabledFunctions() {
            return this.mCurrentFunctions;
        }

        public long getScreenUnlockedFunctions() {
            return this.mScreenUnlockedFunctions;
        }

        private void dumpFunctions(DualDumpOutputStream dump, String idName, long id2, long functions) {
            for (int i = 0; i < 63; ++i) {
                if ((functions & 1L << i) == 0L) continue;
                if (dump.isProto()) {
                    dump.write(idName, id2, 1L << i);
                    continue;
                }
                dump.write(idName, id2, GadgetFunction.toString(1L << i));
            }
        }

        public void dump(DualDumpOutputStream dump, String idName, long id2) {
            long token = dump.start(idName, id2);
            this.dumpFunctions(dump, "current_functions", 2259152797697L, this.mCurrentFunctions);
            dump.write("current_functions_applied", 1133871366146L, this.mCurrentFunctionsApplied);
            this.dumpFunctions(dump, "screen_unlocked_functions", 2259152797699L, this.mScreenUnlockedFunctions);
            dump.write("screen_locked", 1133871366148L, this.mScreenLocked);
            dump.write("connected", 1133871366149L, this.mConnected);
            dump.write("configured", 1133871366150L, this.mConfigured);
            if (this.mCurrentAccessory != null) {
                com.android.internal.usb.DumpUtils.writeAccessory(dump, "current_accessory", 1146756268039L, this.mCurrentAccessory);
            }
            dump.write("host_connected", 0x10800000008L, this.mHostConnected);
            dump.write("source_power", 1133871366153L, this.mSourcePower);
            dump.write("sink_power", 1133871366154L, this.mSinkPower);
            dump.write("usb_charging", 1133871366155L, this.mUsbCharging);
            dump.write("hide_usb_notification", 1133871366156L, this.mHideUsbNotification);
            dump.write("audio_accessory_connected", 1133871366157L, this.mAudioAccessoryConnected);
            try {
                DumpUtils.writeStringIfNotNull(dump, "kernel_state", 1138166333455L, FileUtils.readTextFile(new File(UsbDeviceManager.STATE_PATH), 0, null).trim());
            }
            catch (Exception e) {
                Slog.e(TAG, "Could not read kernel state", e);
            }
            try {
                DumpUtils.writeStringIfNotNull(dump, "kernel_function_list", 0x10900000010L, FileUtils.readTextFile(new File(UsbDeviceManager.FUNCTIONS_PATH), 0, null).trim());
            }
            catch (Exception e) {
                Slog.e(TAG, "Could not read kernel function list", e);
            }
            dump.end(token);
        }

        protected abstract void setEnabledFunctions(long var1, boolean var3);

        private static class AdbTransport
        extends IAdbTransport.Stub {
            private final UsbHandler mHandler;

            AdbTransport(UsbHandler handler) {
                this.mHandler = handler;
            }

            @Override
            public void onAdbEnabled(boolean enabled) {
                this.mHandler.sendMessage(1, enabled);
            }
        }
    }

    private final class UsbUEventObserver
    extends UEventObserver {
        private UsbUEventObserver() {
        }

        @Override
        public void onUEvent(UEventObserver.UEvent event) {
            String state = event.get("USB_STATE");
            String accessory = event.get("ACCESSORY");
            if (state != null) {
                UsbDeviceManager.this.mHandler.updateState(state);
            } else if ("START".equals(accessory)) {
                UsbDeviceManager.this.startAccessoryMode();
            }
        }
    }
}

