/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.usb;

import android.content.ComponentName;
import android.content.Context;
import android.hardware.usb.UsbDevice;
import android.os.Bundle;
import android.os.ParcelFileDescriptor;
import android.text.TextUtils;
import android.util.ArrayMap;
import android.util.Slog;
import android.util.StatsLog;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.util.IndentingPrintWriter;
import com.android.internal.util.dump.DualDumpOutputStream;
import com.android.internal.util.dump.DumpUtils;
import com.android.server.usb.UsbAlsaManager;
import com.android.server.usb.UsbProfileGroupSettingsManager;
import com.android.server.usb.UsbSerialReader;
import com.android.server.usb.UsbSettingsManager;
import com.android.server.usb.UsbUserSettingsManager;
import com.android.server.usb.descriptors.UsbDescriptor;
import com.android.server.usb.descriptors.UsbDescriptorParser;
import com.android.server.usb.descriptors.UsbDeviceDescriptor;
import com.android.server.usb.descriptors.UsbInterfaceDescriptor;
import com.android.server.usb.descriptors.report.TextReportCanvas;
import com.android.server.usb.descriptors.tree.UsbDescriptorsTree;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;

public class UsbHostManager {
    private static final String TAG = UsbHostManager.class.getSimpleName();
    private static final boolean DEBUG = false;
    private static final int LINUX_FOUNDATION_VID = 7531;
    private final Context mContext;
    private final String[] mHostBlacklist;
    private final UsbAlsaManager mUsbAlsaManager;
    private final UsbSettingsManager mSettingsManager;
    private final Object mLock = new Object();
    @GuardedBy(value={"mLock"})
    private final HashMap<String, UsbDevice> mDevices = new HashMap();
    private Object mSettingsLock = new Object();
    @GuardedBy(value={"mSettingsLock"})
    private UsbProfileGroupSettingsManager mCurrentSettings;
    private Object mHandlerLock = new Object();
    @GuardedBy(value={"mHandlerLock"})
    private ComponentName mUsbDeviceConnectionHandler;
    static final SimpleDateFormat sFormat = new SimpleDateFormat("MM-dd HH:mm:ss:SSS");
    private static final int MAX_CONNECT_RECORDS = 32;
    private int mNumConnects;
    private final LinkedList<ConnectionRecord> mConnections = new LinkedList();
    private ConnectionRecord mLastConnect;
    private final ArrayMap<String, ConnectionRecord> mConnected = new ArrayMap();

    public UsbHostManager(Context context, UsbAlsaManager alsaManager, UsbSettingsManager settingsManager) {
        this.mContext = context;
        this.mHostBlacklist = context.getResources().getStringArray(17236074);
        this.mUsbAlsaManager = alsaManager;
        this.mSettingsManager = settingsManager;
        String deviceConnectionHandler = context.getResources().getString(17039669);
        if (!TextUtils.isEmpty(deviceConnectionHandler)) {
            this.setUsbDeviceConnectionHandler(ComponentName.unflattenFromString(deviceConnectionHandler));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCurrentUserSettings(UsbProfileGroupSettingsManager settings) {
        Object object = this.mSettingsLock;
        synchronized (object) {
            this.mCurrentSettings = settings;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UsbProfileGroupSettingsManager getCurrentUserSettings() {
        Object object = this.mSettingsLock;
        synchronized (object) {
            return this.mCurrentSettings;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUsbDeviceConnectionHandler(ComponentName usbDeviceConnectionHandler) {
        Object object = this.mHandlerLock;
        synchronized (object) {
            this.mUsbDeviceConnectionHandler = usbDeviceConnectionHandler;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ComponentName getUsbDeviceConnectionHandler() {
        Object object = this.mHandlerLock;
        synchronized (object) {
            return this.mUsbDeviceConnectionHandler;
        }
    }

    private boolean isBlackListed(String deviceAddress) {
        int count = this.mHostBlacklist.length;
        for (int i = 0; i < count; ++i) {
            if (!deviceAddress.startsWith(this.mHostBlacklist[i])) continue;
            return true;
        }
        return false;
    }

    private boolean isBlackListed(int clazz, int subClass) {
        if (clazz == 9) {
            return true;
        }
        return clazz == 3 && subClass == 1;
    }

    private void addConnectionRecord(String deviceAddress, int mode, byte[] rawDescriptors) {
        ++this.mNumConnects;
        while (this.mConnections.size() >= 32) {
            this.mConnections.removeFirst();
        }
        ConnectionRecord rec = new ConnectionRecord(deviceAddress, mode, rawDescriptors);
        this.mConnections.add(rec);
        if (mode != -1) {
            this.mLastConnect = rec;
        }
        if (mode == 0) {
            this.mConnected.put(deviceAddress, rec);
        } else if (mode == -1) {
            this.mConnected.remove(deviceAddress);
        }
    }

    private void logUsbDevice(UsbDescriptorParser descriptorParser) {
        int vid = 0;
        int pid = 0;
        String mfg = "<unknown>";
        String product = "<unknown>";
        String version = "<unknown>";
        String serial = "<unknown>";
        UsbDeviceDescriptor deviceDescriptor = descriptorParser.getDeviceDescriptor();
        if (deviceDescriptor != null) {
            vid = deviceDescriptor.getVendorID();
            pid = deviceDescriptor.getProductID();
            mfg = deviceDescriptor.getMfgString(descriptorParser);
            product = deviceDescriptor.getProductString(descriptorParser);
            version = deviceDescriptor.getDeviceReleaseString();
            serial = deviceDescriptor.getSerialString(descriptorParser);
        }
        if (vid == 7531) {
            return;
        }
        boolean hasAudio = descriptorParser.hasAudioInterface();
        boolean hasHid = descriptorParser.hasHIDInterface();
        boolean hasStorage = descriptorParser.hasStorageInterface();
        String attachedString = "USB device attached: ";
        attachedString = attachedString + String.format("vidpid %04x:%04x", vid, pid);
        attachedString = attachedString + String.format(" mfg/product/ver/serial %s/%s/%s/%s", mfg, product, version, serial);
        attachedString = attachedString + String.format(" hasAudio/HID/Storage: %b/%b/%b", hasAudio, hasHid, hasStorage);
        Slog.d(TAG, attachedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean usbDeviceAdded(String deviceAddress, int deviceClass, int deviceSubclass, byte[] descriptors) {
        if (this.isBlackListed(deviceAddress)) {
            return false;
        }
        if (this.isBlackListed(deviceClass, deviceSubclass)) {
            return false;
        }
        UsbDescriptorParser parser = new UsbDescriptorParser(deviceAddress, descriptors);
        if (deviceClass == 0 && !this.checkUsbInterfacesBlackListed(parser)) {
            return false;
        }
        this.logUsbDevice(parser);
        Object object = this.mLock;
        synchronized (object) {
            if (this.mDevices.get(deviceAddress) != null) {
                Slog.w(TAG, "device already on mDevices list: " + deviceAddress);
                return false;
            }
            UsbDevice.Builder newDeviceBuilder = parser.toAndroidUsbDevice();
            if (newDeviceBuilder == null) {
                Slog.e(TAG, "Couldn't create UsbDevice object.");
                this.addConnectionRecord(deviceAddress, 2, parser.getRawDescriptors());
            } else {
                UsbSerialReader serialNumberReader = new UsbSerialReader(this.mContext, this.mSettingsManager, newDeviceBuilder.serialNumber);
                UsbDevice newDevice = newDeviceBuilder.build(serialNumberReader);
                serialNumberReader.setDevice(newDevice);
                this.mDevices.put(deviceAddress, newDevice);
                Slog.d(TAG, "Added device " + newDevice);
                ComponentName usbDeviceConnectionHandler = this.getUsbDeviceConnectionHandler();
                if (usbDeviceConnectionHandler == null) {
                    this.getCurrentUserSettings().deviceAttached(newDevice);
                } else {
                    this.getCurrentUserSettings().deviceAttachedForFixedHandler(newDevice, usbDeviceConnectionHandler);
                }
                this.mUsbAlsaManager.usbDeviceAdded(deviceAddress, newDevice, parser);
                this.addConnectionRecord(deviceAddress, 0, parser.getRawDescriptors());
                StatsLog.write(77, newDevice.getVendorId(), newDevice.getProductId(), parser.hasAudioInterface(), parser.hasHIDInterface(), parser.hasStorageInterface(), 1, 0L);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void usbDeviceRemoved(String deviceAddress) {
        Object object = this.mLock;
        synchronized (object) {
            UsbDevice device = this.mDevices.remove(deviceAddress);
            if (device != null) {
                Slog.d(TAG, "Removed device at " + deviceAddress + ": " + device.getProductName());
                this.mUsbAlsaManager.usbDeviceRemoved(deviceAddress);
                this.mSettingsManager.usbDeviceRemoved(device);
                this.getCurrentUserSettings().usbDeviceRemoved(device);
                ConnectionRecord current = this.mConnected.get(deviceAddress);
                this.addConnectionRecord(deviceAddress, -1, null);
                if (current != null) {
                    UsbDescriptorParser parser = new UsbDescriptorParser(deviceAddress, current.mDescriptors);
                    StatsLog.write(77, device.getVendorId(), device.getProductId(), parser.hasAudioInterface(), parser.hasHIDInterface(), parser.hasStorageInterface(), 0, System.currentTimeMillis() - current.mTimestamp);
                }
            } else {
                Slog.d(TAG, "Removed device at " + deviceAddress + " was already gone");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void systemReady() {
        Object object = this.mLock;
        synchronized (object) {
            Runnable runnable = this::monitorUsbHostBus;
            new Thread(null, runnable, "UsbService host thread").start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getDeviceList(Bundle devices) {
        Object object = this.mLock;
        synchronized (object) {
            for (String name : this.mDevices.keySet()) {
                devices.putParcelable(name, this.mDevices.get(name));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ParcelFileDescriptor openDevice(String deviceAddress, UsbUserSettingsManager settings, String packageName, int uid) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.isBlackListed(deviceAddress)) {
                throw new SecurityException("USB device is on a restricted bus");
            }
            UsbDevice device = this.mDevices.get(deviceAddress);
            if (device == null) {
                throw new IllegalArgumentException("device " + deviceAddress + " does not exist or is restricted");
            }
            settings.checkPermission(device, packageName, uid);
            return this.nativeOpenDevice(deviceAddress);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump(DualDumpOutputStream dump, String idName, long id2) {
        long token = dump.start(idName, id2);
        Object object = this.mHandlerLock;
        synchronized (object) {
            if (this.mUsbDeviceConnectionHandler != null) {
                DumpUtils.writeComponentName(dump, "default_usb_host_connection_handler", 0x10B00000001L, this.mUsbDeviceConnectionHandler);
            }
        }
        object = this.mLock;
        synchronized (object) {
            for (String name : this.mDevices.keySet()) {
                com.android.internal.usb.DumpUtils.writeDevice(dump, "devices", 0x20B00000002L, this.mDevices.get(name));
            }
            dump.write("num_connects", 1120986464259L, this.mNumConnects);
            for (ConnectionRecord rec : this.mConnections) {
                rec.dump(dump, "connections", 2246267895812L);
            }
        }
        dump.end(token);
    }

    public void dumpDescriptors(IndentingPrintWriter pw, String[] args) {
        if (this.mLastConnect != null) {
            pw.println("Last Connected USB Device:");
            if (args.length <= 1 || args[1].equals("-dump-short")) {
                this.mLastConnect.dumpShort(pw);
            } else if (args[1].equals("-dump-tree")) {
                this.mLastConnect.dumpTree(pw);
            } else if (args[1].equals("-dump-list")) {
                this.mLastConnect.dumpList(pw);
            } else if (args[1].equals("-dump-raw")) {
                this.mLastConnect.dumpRaw(pw);
            }
        } else {
            pw.println("No USB Devices have been connected.");
        }
    }

    private boolean checkUsbInterfacesBlackListed(UsbDescriptorParser parser) {
        boolean shouldIgnoreDevice = false;
        for (UsbDescriptor descriptor : parser.getDescriptors()) {
            UsbInterfaceDescriptor iface;
            if (descriptor instanceof UsbInterfaceDescriptor && !(shouldIgnoreDevice = this.isBlackListed((iface = (UsbInterfaceDescriptor)descriptor).getUsbClass(), iface.getUsbSubclass()))) break;
        }
        return !shouldIgnoreDevice;
    }

    private native void monitorUsbHostBus();

    private native ParcelFileDescriptor nativeOpenDevice(String var1);

    class ConnectionRecord {
        long mTimestamp = System.currentTimeMillis();
        String mDeviceAddress;
        static final int CONNECT = 0;
        static final int CONNECT_BADPARSE = 1;
        static final int CONNECT_BADDEVICE = 2;
        static final int DISCONNECT = -1;
        final int mMode;
        final byte[] mDescriptors;
        private static final int kDumpBytesPerLine = 16;

        ConnectionRecord(String deviceAddress, int mode, byte[] descriptors) {
            this.mDeviceAddress = deviceAddress;
            this.mMode = mode;
            this.mDescriptors = descriptors;
        }

        private String formatTime() {
            return sFormat.format(new Date(this.mTimestamp));
        }

        void dump(DualDumpOutputStream dump, String idName, long id2) {
            long token = dump.start(idName, id2);
            dump.write("device_address", 0x10900000001L, this.mDeviceAddress);
            dump.write("mode", 1159641169922L, this.mMode);
            dump.write("timestamp", 0x10300000003L, this.mTimestamp);
            if (this.mMode != -1) {
                UsbDescriptorParser parser = new UsbDescriptorParser(this.mDeviceAddress, this.mDescriptors);
                UsbDeviceDescriptor deviceDescriptor = parser.getDeviceDescriptor();
                dump.write("manufacturer", 1120986464260L, deviceDescriptor.getVendorID());
                dump.write("product", 0x10500000005L, deviceDescriptor.getProductID());
                long isHeadSetToken = dump.start("is_headset", 1146756268038L);
                dump.write("in", 0x10800000001L, parser.isInputHeadset());
                dump.write("out", 1133871366146L, parser.isOutputHeadset());
                dump.end(isHeadSetToken);
            }
            dump.end(token);
        }

        void dumpShort(IndentingPrintWriter pw) {
            if (this.mMode != -1) {
                pw.println(this.formatTime() + " Connect " + this.mDeviceAddress + " mode:" + this.mMode);
                UsbDescriptorParser parser = new UsbDescriptorParser(this.mDeviceAddress, this.mDescriptors);
                UsbDeviceDescriptor deviceDescriptor = parser.getDeviceDescriptor();
                pw.println("manfacturer:0x" + Integer.toHexString(deviceDescriptor.getVendorID()) + " product:" + Integer.toHexString(deviceDescriptor.getProductID()));
                pw.println("isHeadset[in: " + parser.isInputHeadset() + " , out: " + parser.isOutputHeadset() + "]");
            } else {
                pw.println(this.formatTime() + " Disconnect " + this.mDeviceAddress);
            }
        }

        void dumpTree(IndentingPrintWriter pw) {
            if (this.mMode != -1) {
                pw.println(this.formatTime() + " Connect " + this.mDeviceAddress + " mode:" + this.mMode);
                UsbDescriptorParser parser = new UsbDescriptorParser(this.mDeviceAddress, this.mDescriptors);
                StringBuilder stringBuilder = new StringBuilder();
                UsbDescriptorsTree descriptorTree = new UsbDescriptorsTree();
                descriptorTree.parse(parser);
                descriptorTree.report(new TextReportCanvas(parser, stringBuilder));
                stringBuilder.append("isHeadset[in: " + parser.isInputHeadset() + " , out: " + parser.isOutputHeadset() + "]");
                pw.println(stringBuilder.toString());
            } else {
                pw.println(this.formatTime() + " Disconnect " + this.mDeviceAddress);
            }
        }

        void dumpList(IndentingPrintWriter pw) {
            if (this.mMode != -1) {
                pw.println(this.formatTime() + " Connect " + this.mDeviceAddress + " mode:" + this.mMode);
                UsbDescriptorParser parser = new UsbDescriptorParser(this.mDeviceAddress, this.mDescriptors);
                StringBuilder stringBuilder = new StringBuilder();
                TextReportCanvas canvas = new TextReportCanvas(parser, stringBuilder);
                for (UsbDescriptor descriptor : parser.getDescriptors()) {
                    descriptor.report(canvas);
                }
                pw.println(stringBuilder.toString());
                pw.println("isHeadset[in: " + parser.isInputHeadset() + " , out: " + parser.isOutputHeadset() + "]");
            } else {
                pw.println(this.formatTime() + " Disconnect " + this.mDeviceAddress);
            }
        }

        void dumpRaw(IndentingPrintWriter pw) {
            if (this.mMode != -1) {
                pw.println(this.formatTime() + " Connect " + this.mDeviceAddress + " mode:" + this.mMode);
                int length = this.mDescriptors.length;
                pw.println("Raw Descriptors " + length + " bytes");
                int dataOffset = 0;
                for (int line = 0; line < length / 16; ++line) {
                    StringBuilder sb = new StringBuilder();
                    for (int offset = 0; offset < 16; ++offset) {
                        sb.append("0x").append(String.format("0x%02X", this.mDescriptors[dataOffset++])).append(" ");
                    }
                    pw.println(sb.toString());
                }
                StringBuilder sb = new StringBuilder();
                while (dataOffset < length) {
                    sb.append("0x").append(String.format("0x%02X", this.mDescriptors[dataOffset++])).append(" ");
                }
                pw.println(sb.toString());
            } else {
                pw.println(this.formatTime() + " Disconnect " + this.mDeviceAddress);
            }
        }
    }
}

