/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.usb;

import android.app.PendingIntent;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.hardware.usb.UsbAccessory;
import android.hardware.usb.UsbDevice;
import android.os.Binder;
import android.os.UserHandle;
import android.util.Slog;
import android.util.SparseBooleanArray;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.util.dump.DualDumpOutputStream;
import java.util.HashMap;

class UsbPermissionManager {
    private static final String LOG_TAG = UsbPermissionManager.class.getSimpleName();
    @GuardedBy(value={"mLock"})
    private final HashMap<String, SparseBooleanArray> mDevicePermissionMap = new HashMap();
    @GuardedBy(value={"mLock"})
    private final HashMap<UsbAccessory, SparseBooleanArray> mAccessoryPermissionMap = new HashMap();
    private final UserHandle mUser;
    private final boolean mDisablePermissionDialogs;
    private final Object mLock = new Object();

    UsbPermissionManager(Context context, UserHandle user) {
        this.mUser = user;
        this.mDisablePermissionDialogs = context.getResources().getBoolean(0x1110051);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeAccessoryPermissions(UsbAccessory accessory) {
        Object object = this.mLock;
        synchronized (object) {
            this.mAccessoryPermissionMap.remove(accessory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeDevicePermissions(UsbDevice device) {
        Object object = this.mLock;
        synchronized (object) {
            this.mDevicePermissionMap.remove(device.getDeviceName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void grantDevicePermission(UsbDevice device, int uid) {
        Object object = this.mLock;
        synchronized (object) {
            String deviceName = device.getDeviceName();
            SparseBooleanArray uidList = this.mDevicePermissionMap.get(deviceName);
            if (uidList == null) {
                uidList = new SparseBooleanArray(1);
                this.mDevicePermissionMap.put(deviceName, uidList);
            }
            uidList.put(uid, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void grantAccessoryPermission(UsbAccessory accessory, int uid) {
        Object object = this.mLock;
        synchronized (object) {
            SparseBooleanArray uidList = this.mAccessoryPermissionMap.get(accessory);
            if (uidList == null) {
                uidList = new SparseBooleanArray(1);
                this.mAccessoryPermissionMap.put(accessory, uidList);
            }
            uidList.put(uid, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean hasPermission(UsbDevice device, int uid) {
        Object object = this.mLock;
        synchronized (object) {
            if (uid == 1000 || this.mDisablePermissionDialogs) {
                return true;
            }
            SparseBooleanArray uidList = this.mDevicePermissionMap.get(device.getDeviceName());
            if (uidList == null) {
                return false;
            }
            return uidList.get(uid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean hasPermission(UsbAccessory accessory, int uid) {
        Object object = this.mLock;
        synchronized (object) {
            if (uid == 1000 || this.mDisablePermissionDialogs) {
                return true;
            }
            SparseBooleanArray uidList = this.mAccessoryPermissionMap.get(accessory);
            if (uidList == null) {
                return false;
            }
            return uidList.get(uid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void requestPermissionDialog(UsbDevice device, UsbAccessory accessory, boolean canBeDefault, String packageName, int uid, Context userContext, PendingIntent pi) {
        long identity = Binder.clearCallingIdentity();
        Intent intent = new Intent();
        if (device != null) {
            intent.putExtra("device", device);
        } else {
            intent.putExtra("accessory", accessory);
        }
        intent.putExtra("android.intent.extra.INTENT", pi);
        intent.putExtra("android.intent.extra.UID", uid);
        intent.putExtra("android.hardware.usb.extra.CAN_BE_DEFAULT", canBeDefault);
        intent.putExtra("android.hardware.usb.extra.PACKAGE", packageName);
        intent.setClassName("com.android.systemui", "com.android.systemui.usb.UsbPermissionActivity");
        intent.addFlags(0x10000000);
        try {
            userContext.startActivityAsUser(intent, this.mUser);
        }
        catch (ActivityNotFoundException e) {
            Slog.e(LOG_TAG, "unable to start UsbPermissionActivity");
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dump(DualDumpOutputStream dump) {
        Object object = this.mLock;
        synchronized (object) {
            int i;
            int count;
            SparseBooleanArray uidList;
            for (String deviceName : this.mDevicePermissionMap.keySet()) {
                long devicePermissionToken = dump.start("device_permissions", 0x20B00000002L);
                dump.write("device_name", 0x10900000001L, deviceName);
                uidList = this.mDevicePermissionMap.get(deviceName);
                count = uidList.size();
                for (i = 0; i < count; ++i) {
                    dump.write("uids", 0x20500000002L, uidList.keyAt(i));
                }
                dump.end(devicePermissionToken);
            }
            for (UsbAccessory accessory : this.mAccessoryPermissionMap.keySet()) {
                long accessoryPermissionToken = dump.start("accessory_permissions", 2246267895811L);
                dump.write("accessory_description", 0x10900000001L, accessory.getDescription());
                uidList = this.mAccessoryPermissionMap.get(accessory);
                count = uidList.size();
                for (i = 0; i < count; ++i) {
                    dump.write("uids", 0x20500000002L, uidList.keyAt(i));
                }
                dump.end(accessoryPermissionToken);
            }
        }
    }
}

