/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.usb;

import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.hardware.usb.ParcelableUsbPort;
import android.hardware.usb.UsbManager;
import android.hardware.usb.UsbPort;
import android.hardware.usb.UsbPortStatus;
import android.hardware.usb.V1_0.PortRole;
import android.hardware.usb.V1_1.PortStatus_1_1;
import android.hardware.usb.V1_2.IUsb;
import android.hardware.usb.V1_2.IUsbCallback;
import android.hardware.usb.V1_2.PortStatus;
import android.hidl.manager.V1_0.IServiceManager;
import android.hidl.manager.V1_0.IServiceNotification;
import android.os.Bundle;
import android.os.Handler;
import android.os.IHwBinder;
import android.os.Message;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import android.os.SystemClock;
import android.os.UserHandle;
import android.util.ArrayMap;
import android.util.Slog;
import android.util.StatsLog;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.notification.SystemNotificationChannels;
import com.android.internal.usb.DumpUtils;
import com.android.internal.util.IndentingPrintWriter;
import com.android.internal.util.dump.DualDumpOutputStream;
import com.android.server.FgThread;
import java.util.ArrayList;
import java.util.NoSuchElementException;

public class UsbPortManager {
    private static final String TAG = "UsbPortManager";
    private static final int MSG_UPDATE_PORTS = 1;
    private static final int MSG_SYSTEM_READY = 2;
    private static final int COMBO_SOURCE_HOST = UsbPort.combineRolesAsBit(1, 1);
    private static final int COMBO_SOURCE_DEVICE = UsbPort.combineRolesAsBit(1, 2);
    private static final int COMBO_SINK_HOST = UsbPort.combineRolesAsBit(2, 1);
    private static final int COMBO_SINK_DEVICE = UsbPort.combineRolesAsBit(2, 2);
    private final Context mContext;
    @GuardedBy(value={"mLock"})
    private android.hardware.usb.V1_0.IUsb mProxy = null;
    private HALCallback mHALCallback = new HALCallback(null, this);
    private static final int USB_HAL_DEATH_COOKIE = 1000;
    private static final String PORT_INFO = "port_info";
    private boolean mSystemReady;
    private final Object mLock = new Object();
    private final ArrayMap<String, PortInfo> mPorts = new ArrayMap();
    private final ArrayMap<String, RawPortInfo> mSimulatedPorts = new ArrayMap();
    private final ArrayMap<String, Boolean> mConnected = new ArrayMap();
    private final ArrayMap<String, Integer> mContaminantStatus = new ArrayMap();
    private NotificationManager mNotificationManager;
    private int mIsPortContaminatedNotificationId;
    private final Handler mHandler = new Handler(FgThread.get().getLooper()){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    Bundle b = msg.getData();
                    ArrayList PortInfo2 = b.getParcelableArrayList(UsbPortManager.PORT_INFO);
                    Object object = UsbPortManager.this.mLock;
                    synchronized (object) {
                        UsbPortManager.this.updatePortsLocked(null, PortInfo2);
                        break;
                    }
                }
                case 2: {
                    UsbPortManager.this.mNotificationManager = (NotificationManager)UsbPortManager.this.mContext.getSystemService("notification");
                }
            }
        }
    };

    public UsbPortManager(Context context) {
        this.mContext = context;
        try {
            ServiceNotification serviceNotification = new ServiceNotification();
            boolean ret = IServiceManager.getService().registerForNotifications("android.hardware.usb@1.0::IUsb", "", serviceNotification);
            if (!ret) {
                UsbPortManager.logAndPrint(6, null, "Failed to register service start notification");
            }
        }
        catch (RemoteException e) {
            UsbPortManager.logAndPrintException(null, "Failed to register service start notification", e);
            return;
        }
        this.connectToProxy(null);
    }

    public void systemReady() {
        this.mSystemReady = true;
        if (this.mProxy != null) {
            try {
                this.mProxy.queryPortStatus();
            }
            catch (RemoteException e) {
                UsbPortManager.logAndPrintException(null, "ServiceStart: Failed to query port status", e);
            }
        }
        this.mHandler.sendEmptyMessage(2);
    }

    private void updateContaminantNotification() {
        CharSequence title;
        PortInfo currentPortInfo = null;
        Resources r = this.mContext.getResources();
        int contaminantStatus = 2;
        for (PortInfo portInfo : this.mPorts.values()) {
            contaminantStatus = portInfo.mUsbPortStatus.getContaminantDetectionStatus();
            if (contaminantStatus != 3 && contaminantStatus != 1) continue;
            currentPortInfo = portInfo;
            break;
        }
        if (contaminantStatus == 3 && this.mIsPortContaminatedNotificationId != 52) {
            if (this.mIsPortContaminatedNotificationId == 53) {
                this.mNotificationManager.cancelAsUser(null, this.mIsPortContaminatedNotificationId, UserHandle.ALL);
            }
            this.mIsPortContaminatedNotificationId = 52;
            int titleRes = 17041162;
            title = r.getText(titleRes);
            String channel = SystemNotificationChannels.ALERTS;
            CharSequence message = r.getText(17041161);
            Intent intent = new Intent();
            intent.addFlags(0x10000000);
            intent.setClassName("com.android.systemui", "com.android.systemui.usb.UsbContaminantActivity");
            intent.putExtra("port", ParcelableUsbPort.of(currentPortInfo.mUsbPort));
            PendingIntent pi = PendingIntent.getActivityAsUser(this.mContext, 0, intent, 0, null, UserHandle.CURRENT);
            Notification.Builder builder = new Notification.Builder(this.mContext, channel).setOngoing(true).setTicker(title).setColor(this.mContext.getColor(17170460)).setContentIntent(pi).setContentTitle(title).setContentText(message).setVisibility(1).setSmallIcon(17301642).setStyle(new Notification.BigTextStyle().bigText(message));
            Notification notification = builder.build();
            this.mNotificationManager.notifyAsUser(null, this.mIsPortContaminatedNotificationId, notification, UserHandle.ALL);
        } else if (contaminantStatus != 3 && this.mIsPortContaminatedNotificationId == 52) {
            this.mNotificationManager.cancelAsUser(null, this.mIsPortContaminatedNotificationId, UserHandle.ALL);
            this.mIsPortContaminatedNotificationId = 0;
            if (contaminantStatus == 2) {
                this.mIsPortContaminatedNotificationId = 53;
                int titleRes = 17041164;
                title = r.getText(titleRes);
                String channel = SystemNotificationChannels.ALERTS;
                CharSequence message = r.getText(17041163);
                Notification.Builder builder = new Notification.Builder(this.mContext, channel).setSmallIcon(17302830).setTicker(title).setColor(this.mContext.getColor(17170460)).setContentTitle(title).setContentText(message).setVisibility(1).setStyle(new Notification.BigTextStyle().bigText(message));
                Notification notification = builder.build();
                this.mNotificationManager.notifyAsUser(null, this.mIsPortContaminatedNotificationId, notification, UserHandle.ALL);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UsbPort[] getPorts() {
        Object object = this.mLock;
        synchronized (object) {
            int count = this.mPorts.size();
            UsbPort[] result = new UsbPort[count];
            for (int i = 0; i < count; ++i) {
                result[i] = this.mPorts.valueAt((int)i).mUsbPort;
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UsbPortStatus getPortStatus(String portId) {
        Object object = this.mLock;
        synchronized (object) {
            PortInfo portInfo = this.mPorts.get(portId);
            return portInfo != null ? portInfo.mUsbPortStatus : null;
        }
    }

    public void enableContaminantDetection(String portId, boolean enable, IndentingPrintWriter pw) {
        PortInfo portInfo = this.mPorts.get(portId);
        if (portInfo == null) {
            if (pw != null) {
                pw.println("No such USB port: " + portId);
            }
            return;
        }
        if (!portInfo.mUsbPort.supportsEnableContaminantPresenceDetection()) {
            return;
        }
        if (enable && portInfo.mUsbPortStatus.getContaminantDetectionStatus() != 1 || !enable && portInfo.mUsbPortStatus.getContaminantDetectionStatus() == 1 || portInfo.mUsbPortStatus.getContaminantDetectionStatus() == 0) {
            return;
        }
        try {
            IUsb proxy = IUsb.castFrom(this.mProxy);
            proxy.enableContaminantPresenceDetection(portId, enable);
        }
        catch (RemoteException e) {
            UsbPortManager.logAndPrintException(pw, "Failed to set contaminant detection", e);
        }
        catch (ClassCastException e) {
            UsbPortManager.logAndPrintException(pw, "Method only applicable to V1.2 or above implementation", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setPortRoles(String portId, int newPowerRole, int newDataRole, IndentingPrintWriter pw) {
        Object object = this.mLock;
        synchronized (object) {
            int newMode;
            int currentMode;
            int currentPowerRole;
            int currentDataRole;
            block20: {
                block21: {
                    PortInfo portInfo = this.mPorts.get(portId);
                    if (portInfo == null) {
                        if (pw == null) return;
                        pw.println("No such USB port: " + portId);
                        return;
                    }
                    if (!portInfo.mUsbPortStatus.isRoleCombinationSupported(newPowerRole, newDataRole)) {
                        UsbPortManager.logAndPrint(6, pw, "Attempted to set USB port into unsupported role combination: portId=" + portId + ", newPowerRole=" + UsbPort.powerRoleToString(newPowerRole) + ", newDataRole=" + UsbPort.dataRoleToString(newDataRole));
                        return;
                    }
                    currentDataRole = portInfo.mUsbPortStatus.getCurrentDataRole();
                    currentPowerRole = portInfo.mUsbPortStatus.getCurrentPowerRole();
                    if (currentDataRole == newDataRole && currentPowerRole == newPowerRole) {
                        if (pw == null) return;
                        pw.println("No change.");
                        return;
                    }
                    boolean canChangeMode = portInfo.mCanChangeMode;
                    boolean canChangePowerRole = portInfo.mCanChangePowerRole;
                    boolean canChangeDataRole = portInfo.mCanChangeDataRole;
                    currentMode = portInfo.mUsbPortStatus.getCurrentMode();
                    if ((canChangePowerRole || currentPowerRole == newPowerRole) && (canChangeDataRole || currentDataRole == newDataRole)) break block21;
                    if (canChangeMode && newPowerRole == 1 && newDataRole == 1) {
                        newMode = 2;
                        break block20;
                    } else if (canChangeMode && newPowerRole == 2 && newDataRole == 2) {
                        newMode = 1;
                        break block20;
                    } else {
                        UsbPortManager.logAndPrint(6, pw, "Found mismatch in supported USB role combinations while attempting to change role: " + portInfo + ", newPowerRole=" + UsbPort.powerRoleToString(newPowerRole) + ", newDataRole=" + UsbPort.dataRoleToString(newDataRole));
                        return;
                    }
                }
                newMode = currentMode;
            }
            UsbPortManager.logAndPrint(4, pw, "Setting USB port mode and role: portId=" + portId + ", currentMode=" + UsbPort.modeToString(currentMode) + ", currentPowerRole=" + UsbPort.powerRoleToString(currentPowerRole) + ", currentDataRole=" + UsbPort.dataRoleToString(currentDataRole) + ", newMode=" + UsbPort.modeToString(newMode) + ", newPowerRole=" + UsbPort.powerRoleToString(newPowerRole) + ", newDataRole=" + UsbPort.dataRoleToString(newDataRole));
            RawPortInfo sim = this.mSimulatedPorts.get(portId);
            if (sim != null) {
                sim.currentMode = newMode;
                sim.currentPowerRole = newPowerRole;
                sim.currentDataRole = newDataRole;
                this.updatePortsLocked(pw, null);
            } else {
                if (this.mProxy == null) return;
                if (currentMode != newMode) {
                    UsbPortManager.logAndPrint(6, pw, "Trying to set the USB port mode: portId=" + portId + ", newMode=" + UsbPort.modeToString(newMode));
                    PortRole newRole = new PortRole();
                    newRole.type = 2;
                    newRole.role = newMode;
                    try {
                        this.mProxy.switchRole(portId, newRole);
                    }
                    catch (RemoteException e) {
                        UsbPortManager.logAndPrintException(pw, "Failed to set the USB port mode: portId=" + portId + ", newMode=" + UsbPort.modeToString(newRole.role), e);
                    }
                } else {
                    PortRole newRole;
                    if (currentPowerRole != newPowerRole) {
                        newRole = new PortRole();
                        newRole.type = 1;
                        newRole.role = newPowerRole;
                        try {
                            this.mProxy.switchRole(portId, newRole);
                        }
                        catch (RemoteException e) {
                            UsbPortManager.logAndPrintException(pw, "Failed to set the USB port power role: portId=" + portId + ", newPowerRole=" + UsbPort.powerRoleToString(newRole.role), e);
                            return;
                        }
                    }
                    if (currentDataRole == newDataRole) return;
                    newRole = new PortRole();
                    newRole.type = 0;
                    newRole.role = newDataRole;
                    try {
                        this.mProxy.switchRole(portId, newRole);
                    }
                    catch (RemoteException e) {
                        UsbPortManager.logAndPrintException(pw, "Failed to set the USB port data role: portId=" + portId + ", newDataRole=" + UsbPort.dataRoleToString(newRole.role), e);
                    }
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSimulatedPort(String portId, int supportedModes, IndentingPrintWriter pw) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mSimulatedPorts.containsKey(portId)) {
                pw.println("Port with same name already exists.  Please remove it first.");
                return;
            }
            pw.println("Adding simulated port: portId=" + portId + ", supportedModes=" + UsbPort.modeToString(supportedModes));
            this.mSimulatedPorts.put(portId, new RawPortInfo(portId, supportedModes));
            this.updatePortsLocked(pw, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectSimulatedPort(String portId, int mode, boolean canChangeMode, int powerRole, boolean canChangePowerRole, int dataRole, boolean canChangeDataRole, IndentingPrintWriter pw) {
        Object object = this.mLock;
        synchronized (object) {
            RawPortInfo portInfo = this.mSimulatedPorts.get(portId);
            if (portInfo == null) {
                pw.println("Cannot connect simulated port which does not exist.");
                return;
            }
            if (mode == 0 || powerRole == 0 || dataRole == 0) {
                pw.println("Cannot connect simulated port in null mode, power role, or data role.");
                return;
            }
            if ((portInfo.supportedModes & mode) == 0) {
                pw.println("Simulated port does not support mode: " + UsbPort.modeToString(mode));
                return;
            }
            pw.println("Connecting simulated port: portId=" + portId + ", mode=" + UsbPort.modeToString(mode) + ", canChangeMode=" + canChangeMode + ", powerRole=" + UsbPort.powerRoleToString(powerRole) + ", canChangePowerRole=" + canChangePowerRole + ", dataRole=" + UsbPort.dataRoleToString(dataRole) + ", canChangeDataRole=" + canChangeDataRole);
            portInfo.currentMode = mode;
            portInfo.canChangeMode = canChangeMode;
            portInfo.currentPowerRole = powerRole;
            portInfo.canChangePowerRole = canChangePowerRole;
            portInfo.currentDataRole = dataRole;
            portInfo.canChangeDataRole = canChangeDataRole;
            this.updatePortsLocked(pw, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void simulateContaminantStatus(String portId, boolean detected, IndentingPrintWriter pw) {
        Object object = this.mLock;
        synchronized (object) {
            RawPortInfo portInfo = this.mSimulatedPorts.get(portId);
            if (portInfo == null) {
                pw.println("Simulated port not found.");
                return;
            }
            pw.println("Simulating wet port: portId=" + portId + ", wet=" + detected);
            portInfo.contaminantDetectionStatus = detected ? 3 : 2;
            this.updatePortsLocked(pw, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnectSimulatedPort(String portId, IndentingPrintWriter pw) {
        Object object = this.mLock;
        synchronized (object) {
            RawPortInfo portInfo = this.mSimulatedPorts.get(portId);
            if (portInfo == null) {
                pw.println("Cannot disconnect simulated port which does not exist.");
                return;
            }
            pw.println("Disconnecting simulated port: portId=" + portId);
            portInfo.currentMode = 0;
            portInfo.canChangeMode = false;
            portInfo.currentPowerRole = 0;
            portInfo.canChangePowerRole = false;
            portInfo.currentDataRole = 0;
            portInfo.canChangeDataRole = false;
            this.updatePortsLocked(pw, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSimulatedPort(String portId, IndentingPrintWriter pw) {
        Object object = this.mLock;
        synchronized (object) {
            int index = this.mSimulatedPorts.indexOfKey(portId);
            if (index < 0) {
                pw.println("Cannot remove simulated port which does not exist.");
                return;
            }
            pw.println("Disconnecting simulated port: portId=" + portId);
            this.mSimulatedPorts.removeAt(index);
            this.updatePortsLocked(pw, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetSimulation(IndentingPrintWriter pw) {
        Object object = this.mLock;
        synchronized (object) {
            pw.println("Removing all simulated ports and ending simulation.");
            if (!this.mSimulatedPorts.isEmpty()) {
                this.mSimulatedPorts.clear();
                this.updatePortsLocked(pw, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump(DualDumpOutputStream dump, String idName, long id2) {
        long token = dump.start(idName, id2);
        Object object = this.mLock;
        synchronized (object) {
            dump.write("is_simulation_active", 0x10800000001L, !this.mSimulatedPorts.isEmpty());
            for (PortInfo portInfo : this.mPorts.values()) {
                portInfo.dump(dump, "usb_ports", 0x20B00000002L);
            }
        }
        dump.end(token);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connectToProxy(IndentingPrintWriter pw) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mProxy != null) {
                return;
            }
            try {
                this.mProxy = android.hardware.usb.V1_0.IUsb.getService();
                this.mProxy.linkToDeath(new DeathRecipient(pw), 1000L);
                this.mProxy.setCallback(this.mHALCallback);
                this.mProxy.queryPortStatus();
            }
            catch (NoSuchElementException e) {
                UsbPortManager.logAndPrintException(pw, "connectToProxy: usb hal service not found. Did the service fail to start?", e);
            }
            catch (RemoteException e) {
                UsbPortManager.logAndPrintException(pw, "connectToProxy: usb hal service not responding", e);
            }
        }
    }

    private void updatePortsLocked(IndentingPrintWriter pw, ArrayList<RawPortInfo> newPortInfo) {
        int i = this.mPorts.size();
        while (i-- > 0) {
            this.mPorts.valueAt((int)i).mDisposition = 3;
        }
        if (!this.mSimulatedPorts.isEmpty()) {
            int count = this.mSimulatedPorts.size();
            for (int i2 = 0; i2 < count; ++i2) {
                RawPortInfo portInfo = this.mSimulatedPorts.valueAt(i2);
                this.addOrUpdatePortLocked(portInfo.portId, portInfo.supportedModes, portInfo.supportedContaminantProtectionModes, portInfo.currentMode, portInfo.canChangeMode, portInfo.currentPowerRole, portInfo.canChangePowerRole, portInfo.currentDataRole, portInfo.canChangeDataRole, portInfo.supportsEnableContaminantPresenceProtection, portInfo.contaminantProtectionStatus, portInfo.supportsEnableContaminantPresenceDetection, portInfo.contaminantDetectionStatus, pw);
            }
        } else {
            for (RawPortInfo currentPortInfo : newPortInfo) {
                this.addOrUpdatePortLocked(currentPortInfo.portId, currentPortInfo.supportedModes, currentPortInfo.supportedContaminantProtectionModes, currentPortInfo.currentMode, currentPortInfo.canChangeMode, currentPortInfo.currentPowerRole, currentPortInfo.canChangePowerRole, currentPortInfo.currentDataRole, currentPortInfo.canChangeDataRole, currentPortInfo.supportsEnableContaminantPresenceProtection, currentPortInfo.contaminantProtectionStatus, currentPortInfo.supportsEnableContaminantPresenceDetection, currentPortInfo.contaminantDetectionStatus, pw);
            }
        }
        i = this.mPorts.size();
        while (i-- > 0) {
            PortInfo portInfo = this.mPorts.valueAt(i);
            switch (portInfo.mDisposition) {
                case 0: {
                    this.handlePortAddedLocked(portInfo, pw);
                    portInfo.mDisposition = 2;
                    break;
                }
                case 1: {
                    this.handlePortChangedLocked(portInfo, pw);
                    portInfo.mDisposition = 2;
                    break;
                }
                case 3: {
                    this.mPorts.removeAt(i);
                    portInfo.mUsbPortStatus = null;
                    this.handlePortRemovedLocked(portInfo, pw);
                }
            }
        }
    }

    private void addOrUpdatePortLocked(String portId, int supportedModes, int supportedContaminantProtectionModes, int currentMode, boolean canChangeMode, int currentPowerRole, boolean canChangePowerRole, int currentDataRole, boolean canChangeDataRole, boolean supportsEnableContaminantPresenceProtection, int contaminantProtectionStatus, boolean supportsEnableContaminantPresenceDetection, int contaminantDetectionStatus, IndentingPrintWriter pw) {
        PortInfo portInfo;
        if ((supportedModes & 3) != 3) {
            canChangeMode = false;
            if (currentMode != 0 && currentMode != supportedModes) {
                UsbPortManager.logAndPrint(5, pw, "Ignoring inconsistent current mode from USB port driver: supportedModes=" + UsbPort.modeToString(supportedModes) + ", currentMode=" + UsbPort.modeToString(currentMode));
                currentMode = 0;
            }
        }
        int supportedRoleCombinations = UsbPort.combineRolesAsBit(currentPowerRole, currentDataRole);
        if (currentMode != 0 && currentPowerRole != 0 && currentDataRole != 0) {
            if (canChangePowerRole && canChangeDataRole) {
                supportedRoleCombinations |= COMBO_SOURCE_HOST | COMBO_SOURCE_DEVICE | COMBO_SINK_HOST | COMBO_SINK_DEVICE;
            } else if (canChangePowerRole) {
                supportedRoleCombinations |= UsbPort.combineRolesAsBit(1, currentDataRole);
                supportedRoleCombinations |= UsbPort.combineRolesAsBit(2, currentDataRole);
            } else if (canChangeDataRole) {
                supportedRoleCombinations |= UsbPort.combineRolesAsBit(currentPowerRole, 1);
                supportedRoleCombinations |= UsbPort.combineRolesAsBit(currentPowerRole, 2);
            } else if (canChangeMode) {
                supportedRoleCombinations |= COMBO_SOURCE_HOST | COMBO_SINK_DEVICE;
            }
        }
        if ((portInfo = this.mPorts.get(portId)) == null) {
            portInfo = new PortInfo(this.mContext.getSystemService(UsbManager.class), portId, supportedModes, supportedContaminantProtectionModes, supportsEnableContaminantPresenceProtection, supportsEnableContaminantPresenceDetection);
            portInfo.setStatus(currentMode, canChangeMode, currentPowerRole, canChangePowerRole, currentDataRole, canChangeDataRole, supportedRoleCombinations, contaminantProtectionStatus, contaminantDetectionStatus);
            this.mPorts.put(portId, portInfo);
        } else {
            if (supportedModes != portInfo.mUsbPort.getSupportedModes()) {
                UsbPortManager.logAndPrint(5, pw, "Ignoring inconsistent list of supported modes from USB port driver (should be immutable): previous=" + UsbPort.modeToString(portInfo.mUsbPort.getSupportedModes()) + ", current=" + UsbPort.modeToString(supportedModes));
            }
            if (supportsEnableContaminantPresenceProtection != portInfo.mUsbPort.supportsEnableContaminantPresenceProtection()) {
                UsbPortManager.logAndPrint(5, pw, "Ignoring inconsistent supportsEnableContaminantPresenceProtectionUSB port driver (should be immutable): previous=" + portInfo.mUsbPort.supportsEnableContaminantPresenceProtection() + ", current=" + supportsEnableContaminantPresenceProtection);
            }
            if (supportsEnableContaminantPresenceDetection != portInfo.mUsbPort.supportsEnableContaminantPresenceDetection()) {
                UsbPortManager.logAndPrint(5, pw, "Ignoring inconsistent supportsEnableContaminantPresenceDetection USB port driver (should be immutable): previous=" + portInfo.mUsbPort.supportsEnableContaminantPresenceDetection() + ", current=" + supportsEnableContaminantPresenceDetection);
            }
            portInfo.mDisposition = portInfo.setStatus(currentMode, canChangeMode, currentPowerRole, canChangePowerRole, currentDataRole, canChangeDataRole, supportedRoleCombinations, contaminantProtectionStatus, contaminantDetectionStatus) ? 1 : 2;
        }
    }

    private void handlePortLocked(PortInfo portInfo, IndentingPrintWriter pw) {
        this.sendPortChangedBroadcastLocked(portInfo);
        this.logToStatsd(portInfo, pw);
        this.updateContaminantNotification();
    }

    private void handlePortAddedLocked(PortInfo portInfo, IndentingPrintWriter pw) {
        UsbPortManager.logAndPrint(4, pw, "USB port added: " + portInfo);
        this.handlePortLocked(portInfo, pw);
    }

    private void handlePortChangedLocked(PortInfo portInfo, IndentingPrintWriter pw) {
        UsbPortManager.logAndPrint(4, pw, "USB port changed: " + portInfo);
        this.enableContaminantDetectionIfNeeded(portInfo, pw);
        this.handlePortLocked(portInfo, pw);
    }

    private void handlePortRemovedLocked(PortInfo portInfo, IndentingPrintWriter pw) {
        UsbPortManager.logAndPrint(4, pw, "USB port removed: " + portInfo);
        this.handlePortLocked(portInfo, pw);
    }

    private static int convertContaminantDetectionStatusToProto(int contaminantDetectionStatus) {
        switch (contaminantDetectionStatus) {
            case 0: {
                return 1;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 3;
            }
            case 3: {
                return 4;
            }
        }
        return 0;
    }

    private void sendPortChangedBroadcastLocked(PortInfo portInfo) {
        Intent intent = new Intent("android.hardware.usb.action.USB_PORT_CHANGED");
        intent.addFlags(0x11000000);
        intent.putExtra("port", ParcelableUsbPort.of(portInfo.mUsbPort));
        intent.putExtra("portStatus", portInfo.mUsbPortStatus);
        this.mHandler.post(() -> this.mContext.sendBroadcastAsUser(intent, UserHandle.ALL, "android.permission.MANAGE_USB"));
    }

    private void enableContaminantDetectionIfNeeded(PortInfo portInfo, IndentingPrintWriter pw) {
        if (!this.mConnected.containsKey(portInfo.mUsbPort.getId())) {
            return;
        }
        if (this.mConnected.get(portInfo.mUsbPort.getId()).booleanValue() && !portInfo.mUsbPortStatus.isConnected() && portInfo.mUsbPortStatus.getContaminantDetectionStatus() == 1) {
            this.enableContaminantDetection(portInfo.mUsbPort.getId(), true, pw);
        }
    }

    private void logToStatsd(PortInfo portInfo, IndentingPrintWriter pw) {
        if (portInfo.mUsbPortStatus == null) {
            if (this.mConnected.containsKey(portInfo.mUsbPort.getId())) {
                if (this.mConnected.get(portInfo.mUsbPort.getId()).booleanValue()) {
                    StatsLog.write(70, 0, portInfo.mUsbPort.getId(), portInfo.mLastConnectDurationMillis);
                }
                this.mConnected.remove(portInfo.mUsbPort.getId());
            }
            if (this.mContaminantStatus.containsKey(portInfo.mUsbPort.getId())) {
                if (this.mContaminantStatus.get(portInfo.mUsbPort.getId()) == 3) {
                    StatsLog.write(146, portInfo.mUsbPort.getId(), UsbPortManager.convertContaminantDetectionStatusToProto(2));
                }
                this.mContaminantStatus.remove(portInfo.mUsbPort.getId());
            }
            return;
        }
        if (!this.mConnected.containsKey(portInfo.mUsbPort.getId()) || this.mConnected.get(portInfo.mUsbPort.getId()).booleanValue() != portInfo.mUsbPortStatus.isConnected()) {
            this.mConnected.put(portInfo.mUsbPort.getId(), portInfo.mUsbPortStatus.isConnected());
            StatsLog.write(70, portInfo.mUsbPortStatus.isConnected() ? 1 : 0, portInfo.mUsbPort.getId(), portInfo.mLastConnectDurationMillis);
        }
        if (!this.mContaminantStatus.containsKey(portInfo.mUsbPort.getId()) || this.mContaminantStatus.get(portInfo.mUsbPort.getId()).intValue() != portInfo.mUsbPortStatus.getContaminantDetectionStatus()) {
            this.mContaminantStatus.put(portInfo.mUsbPort.getId(), portInfo.mUsbPortStatus.getContaminantDetectionStatus());
            StatsLog.write(146, portInfo.mUsbPort.getId(), UsbPortManager.convertContaminantDetectionStatusToProto(portInfo.mUsbPortStatus.getContaminantDetectionStatus()));
        }
    }

    private static void logAndPrint(int priority, IndentingPrintWriter pw, String msg) {
        Slog.println(priority, TAG, msg);
        if (pw != null) {
            pw.println(msg);
        }
    }

    private static void logAndPrintException(IndentingPrintWriter pw, String msg, Exception e) {
        Slog.e(TAG, msg, e);
        if (pw != null) {
            pw.println(msg + e);
        }
    }

    private static final class RawPortInfo
    implements Parcelable {
        public final String portId;
        public final int supportedModes;
        public final int supportedContaminantProtectionModes;
        public int currentMode;
        public boolean canChangeMode;
        public int currentPowerRole;
        public boolean canChangePowerRole;
        public int currentDataRole;
        public boolean canChangeDataRole;
        public boolean supportsEnableContaminantPresenceProtection;
        public int contaminantProtectionStatus;
        public boolean supportsEnableContaminantPresenceDetection;
        public int contaminantDetectionStatus;
        public static final Parcelable.Creator<RawPortInfo> CREATOR = new Parcelable.Creator<RawPortInfo>(){

            @Override
            public RawPortInfo createFromParcel(Parcel in) {
                String id2 = in.readString();
                int supportedModes = in.readInt();
                int supportedContaminantProtectionModes = in.readInt();
                int currentMode = in.readInt();
                boolean canChangeMode = in.readByte() != 0;
                int currentPowerRole = in.readInt();
                boolean canChangePowerRole = in.readByte() != 0;
                int currentDataRole = in.readInt();
                boolean canChangeDataRole = in.readByte() != 0;
                boolean supportsEnableContaminantPresenceProtection = in.readBoolean();
                int contaminantProtectionStatus = in.readInt();
                boolean supportsEnableContaminantPresenceDetection = in.readBoolean();
                int contaminantDetectionStatus = in.readInt();
                return new RawPortInfo(id2, supportedModes, supportedContaminantProtectionModes, currentMode, canChangeMode, currentPowerRole, canChangePowerRole, currentDataRole, canChangeDataRole, supportsEnableContaminantPresenceProtection, contaminantProtectionStatus, supportsEnableContaminantPresenceDetection, contaminantDetectionStatus);
            }

            public RawPortInfo[] newArray(int size) {
                return new RawPortInfo[size];
            }
        };

        RawPortInfo(String portId, int supportedModes) {
            this.portId = portId;
            this.supportedModes = supportedModes;
            this.supportedContaminantProtectionModes = 0;
            this.supportsEnableContaminantPresenceProtection = false;
            this.contaminantProtectionStatus = 0;
            this.supportsEnableContaminantPresenceDetection = false;
            this.contaminantDetectionStatus = 0;
        }

        RawPortInfo(String portId, int supportedModes, int supportedContaminantProtectionModes, int currentMode, boolean canChangeMode, int currentPowerRole, boolean canChangePowerRole, int currentDataRole, boolean canChangeDataRole, boolean supportsEnableContaminantPresenceProtection, int contaminantProtectionStatus, boolean supportsEnableContaminantPresenceDetection, int contaminantDetectionStatus) {
            this.portId = portId;
            this.supportedModes = supportedModes;
            this.supportedContaminantProtectionModes = supportedContaminantProtectionModes;
            this.currentMode = currentMode;
            this.canChangeMode = canChangeMode;
            this.currentPowerRole = currentPowerRole;
            this.canChangePowerRole = canChangePowerRole;
            this.currentDataRole = currentDataRole;
            this.canChangeDataRole = canChangeDataRole;
            this.supportsEnableContaminantPresenceProtection = supportsEnableContaminantPresenceProtection;
            this.contaminantProtectionStatus = contaminantProtectionStatus;
            this.supportsEnableContaminantPresenceDetection = supportsEnableContaminantPresenceDetection;
            this.contaminantDetectionStatus = contaminantDetectionStatus;
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeString(this.portId);
            dest.writeInt(this.supportedModes);
            dest.writeInt(this.supportedContaminantProtectionModes);
            dest.writeInt(this.currentMode);
            dest.writeByte((byte)(this.canChangeMode ? 1 : 0));
            dest.writeInt(this.currentPowerRole);
            dest.writeByte((byte)(this.canChangePowerRole ? 1 : 0));
            dest.writeInt(this.currentDataRole);
            dest.writeByte((byte)(this.canChangeDataRole ? 1 : 0));
            dest.writeBoolean(this.supportsEnableContaminantPresenceProtection);
            dest.writeInt(this.contaminantProtectionStatus);
            dest.writeBoolean(this.supportsEnableContaminantPresenceDetection);
            dest.writeInt(this.contaminantDetectionStatus);
        }
    }

    private static final class PortInfo {
        public static final int DISPOSITION_ADDED = 0;
        public static final int DISPOSITION_CHANGED = 1;
        public static final int DISPOSITION_READY = 2;
        public static final int DISPOSITION_REMOVED = 3;
        public final UsbPort mUsbPort;
        public UsbPortStatus mUsbPortStatus;
        public boolean mCanChangeMode;
        public boolean mCanChangePowerRole;
        public boolean mCanChangeDataRole;
        public int mDisposition;
        public long mConnectedAtMillis;
        public long mLastConnectDurationMillis;

        PortInfo(UsbManager usbManager, String portId, int supportedModes, int supportedContaminantProtectionModes, boolean supportsEnableContaminantPresenceDetection, boolean supportsEnableContaminantPresenceProtection) {
            this.mUsbPort = new UsbPort(usbManager, portId, supportedModes, supportedContaminantProtectionModes, supportsEnableContaminantPresenceDetection, supportsEnableContaminantPresenceProtection);
        }

        public boolean setStatus(int currentMode, boolean canChangeMode, int currentPowerRole, boolean canChangePowerRole, int currentDataRole, boolean canChangeDataRole, int supportedRoleCombinations) {
            boolean dispositionChanged = false;
            this.mCanChangeMode = canChangeMode;
            this.mCanChangePowerRole = canChangePowerRole;
            this.mCanChangeDataRole = canChangeDataRole;
            if (this.mUsbPortStatus == null || this.mUsbPortStatus.getCurrentMode() != currentMode || this.mUsbPortStatus.getCurrentPowerRole() != currentPowerRole || this.mUsbPortStatus.getCurrentDataRole() != currentDataRole || this.mUsbPortStatus.getSupportedRoleCombinations() != supportedRoleCombinations) {
                this.mUsbPortStatus = new UsbPortStatus(currentMode, currentPowerRole, currentDataRole, supportedRoleCombinations, 0, 0);
                dispositionChanged = true;
            }
            if (this.mUsbPortStatus.isConnected() && this.mConnectedAtMillis == 0L) {
                this.mConnectedAtMillis = SystemClock.elapsedRealtime();
                this.mLastConnectDurationMillis = 0L;
            } else if (!this.mUsbPortStatus.isConnected() && this.mConnectedAtMillis != 0L) {
                this.mLastConnectDurationMillis = SystemClock.elapsedRealtime() - this.mConnectedAtMillis;
                this.mConnectedAtMillis = 0L;
            }
            return dispositionChanged;
        }

        public boolean setStatus(int currentMode, boolean canChangeMode, int currentPowerRole, boolean canChangePowerRole, int currentDataRole, boolean canChangeDataRole, int supportedRoleCombinations, int contaminantProtectionStatus, int contaminantDetectionStatus) {
            boolean dispositionChanged = false;
            this.mCanChangeMode = canChangeMode;
            this.mCanChangePowerRole = canChangePowerRole;
            this.mCanChangeDataRole = canChangeDataRole;
            if (this.mUsbPortStatus == null || this.mUsbPortStatus.getCurrentMode() != currentMode || this.mUsbPortStatus.getCurrentPowerRole() != currentPowerRole || this.mUsbPortStatus.getCurrentDataRole() != currentDataRole || this.mUsbPortStatus.getSupportedRoleCombinations() != supportedRoleCombinations || this.mUsbPortStatus.getContaminantProtectionStatus() != contaminantProtectionStatus || this.mUsbPortStatus.getContaminantDetectionStatus() != contaminantDetectionStatus) {
                this.mUsbPortStatus = new UsbPortStatus(currentMode, currentPowerRole, currentDataRole, supportedRoleCombinations, contaminantProtectionStatus, contaminantDetectionStatus);
                dispositionChanged = true;
            }
            if (this.mUsbPortStatus.isConnected() && this.mConnectedAtMillis == 0L) {
                this.mConnectedAtMillis = SystemClock.elapsedRealtime();
                this.mLastConnectDurationMillis = 0L;
            } else if (!this.mUsbPortStatus.isConnected() && this.mConnectedAtMillis != 0L) {
                this.mLastConnectDurationMillis = SystemClock.elapsedRealtime() - this.mConnectedAtMillis;
                this.mConnectedAtMillis = 0L;
            }
            return dispositionChanged;
        }

        void dump(DualDumpOutputStream dump, String idName, long id2) {
            long token = dump.start(idName, id2);
            DumpUtils.writePort(dump, "port", 0x10B00000001L, this.mUsbPort);
            DumpUtils.writePortStatus(dump, "status", 1146756268034L, this.mUsbPortStatus);
            dump.write("can_change_mode", 1133871366147L, this.mCanChangeMode);
            dump.write("can_change_power_role", 1133871366148L, this.mCanChangePowerRole);
            dump.write("can_change_data_role", 1133871366149L, this.mCanChangeDataRole);
            dump.write("connected_at_millis", 1112396529670L, this.mConnectedAtMillis);
            dump.write("last_connect_duration_millis", 1112396529671L, this.mLastConnectDurationMillis);
            dump.end(token);
        }

        public String toString() {
            return "port=" + this.mUsbPort + ", status=" + this.mUsbPortStatus + ", canChangeMode=" + this.mCanChangeMode + ", canChangePowerRole=" + this.mCanChangePowerRole + ", canChangeDataRole=" + this.mCanChangeDataRole + ", connectedAtMillis=" + this.mConnectedAtMillis + ", lastConnectDurationMillis=" + this.mLastConnectDurationMillis;
        }
    }

    final class ServiceNotification
    extends IServiceNotification.Stub {
        ServiceNotification() {
        }

        @Override
        public void onRegistration(String fqName, String name, boolean preexisting) {
            UsbPortManager.logAndPrint(4, null, "Usb hal service started " + fqName + " " + name);
            UsbPortManager.this.connectToProxy(null);
        }
    }

    final class DeathRecipient
    implements IHwBinder.DeathRecipient {
        public IndentingPrintWriter pw;

        DeathRecipient(IndentingPrintWriter pw) {
            this.pw = pw;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void serviceDied(long cookie) {
            if (cookie == 1000L) {
                UsbPortManager.logAndPrint(6, this.pw, "Usb hal service died cookie: " + cookie);
                Object object = UsbPortManager.this.mLock;
                synchronized (object) {
                    UsbPortManager.this.mProxy = null;
                }
            }
        }
    }

    private static class HALCallback
    extends IUsbCallback.Stub {
        public IndentingPrintWriter pw;
        public UsbPortManager portManager;

        HALCallback(IndentingPrintWriter pw, UsbPortManager portManager) {
            this.pw = pw;
            this.portManager = portManager;
        }

        @Override
        public void notifyPortStatusChange(ArrayList<android.hardware.usb.V1_0.PortStatus> currentPortStatus, int retval) {
            if (!this.portManager.mSystemReady) {
                return;
            }
            if (retval != 0) {
                UsbPortManager.logAndPrint(6, this.pw, "port status enquiry failed");
                return;
            }
            ArrayList<RawPortInfo> newPortInfo = new ArrayList<RawPortInfo>();
            for (android.hardware.usb.V1_0.PortStatus current : currentPortStatus) {
                RawPortInfo temp = new RawPortInfo(current.portName, current.supportedModes, 0, current.currentMode, current.canChangeMode, current.currentPowerRole, current.canChangePowerRole, current.currentDataRole, current.canChangeDataRole, false, 0, false, 0);
                newPortInfo.add(temp);
                UsbPortManager.logAndPrint(4, this.pw, "ClientCallback V1_0: " + current.portName);
            }
            Message message = this.portManager.mHandler.obtainMessage();
            Bundle bundle = new Bundle();
            bundle.putParcelableArrayList(UsbPortManager.PORT_INFO, newPortInfo);
            message.what = 1;
            message.setData(bundle);
            this.portManager.mHandler.sendMessage(message);
        }

        @Override
        public void notifyPortStatusChange_1_1(ArrayList<PortStatus_1_1> currentPortStatus, int retval) {
            if (!this.portManager.mSystemReady) {
                return;
            }
            if (retval != 0) {
                UsbPortManager.logAndPrint(6, this.pw, "port status enquiry failed");
                return;
            }
            ArrayList<RawPortInfo> newPortInfo = new ArrayList<RawPortInfo>();
            int numStatus = currentPortStatus.size();
            for (int i = 0; i < numStatus; ++i) {
                PortStatus_1_1 current = currentPortStatus.get(i);
                RawPortInfo temp = new RawPortInfo(current.status.portName, current.supportedModes, 0, current.currentMode, current.status.canChangeMode, current.status.currentPowerRole, current.status.canChangePowerRole, current.status.currentDataRole, current.status.canChangeDataRole, false, 0, false, 0);
                newPortInfo.add(temp);
                UsbPortManager.logAndPrint(4, this.pw, "ClientCallback V1_1: " + current.status.portName);
            }
            Message message = this.portManager.mHandler.obtainMessage();
            Bundle bundle = new Bundle();
            bundle.putParcelableArrayList(UsbPortManager.PORT_INFO, newPortInfo);
            message.what = 1;
            message.setData(bundle);
            this.portManager.mHandler.sendMessage(message);
        }

        @Override
        public void notifyPortStatusChange_1_2(ArrayList<PortStatus> currentPortStatus, int retval) {
            if (!this.portManager.mSystemReady) {
                return;
            }
            if (retval != 0) {
                UsbPortManager.logAndPrint(6, this.pw, "port status enquiry failed");
                return;
            }
            ArrayList<RawPortInfo> newPortInfo = new ArrayList<RawPortInfo>();
            int numStatus = currentPortStatus.size();
            for (int i = 0; i < numStatus; ++i) {
                PortStatus current = currentPortStatus.get(i);
                RawPortInfo temp = new RawPortInfo(current.status_1_1.status.portName, current.status_1_1.supportedModes, current.supportedContaminantProtectionModes, current.status_1_1.currentMode, current.status_1_1.status.canChangeMode, current.status_1_1.status.currentPowerRole, current.status_1_1.status.canChangePowerRole, current.status_1_1.status.currentDataRole, current.status_1_1.status.canChangeDataRole, current.supportsEnableContaminantPresenceProtection, current.contaminantProtectionStatus, current.supportsEnableContaminantPresenceDetection, current.contaminantDetectionStatus);
                newPortInfo.add(temp);
                UsbPortManager.logAndPrint(4, this.pw, "ClientCallback V1_2: " + current.status_1_1.status.portName);
            }
            Message message = this.portManager.mHandler.obtainMessage();
            Bundle bundle = new Bundle();
            bundle.putParcelableArrayList(UsbPortManager.PORT_INFO, newPortInfo);
            message.what = 1;
            message.setData(bundle);
            this.portManager.mHandler.sendMessage(message);
        }

        @Override
        public void notifyRoleSwitchStatus(String portName, PortRole role, int retval) {
            if (retval == 0) {
                UsbPortManager.logAndPrint(4, this.pw, portName + " role switch successful");
            } else {
                UsbPortManager.logAndPrint(6, this.pw, portName + " role switch failed");
            }
        }
    }
}

