/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.usb;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.hardware.usb.IUsbSerialReader;
import android.hardware.usb.UsbAccessory;
import android.hardware.usb.UsbDevice;
import android.os.Binder;
import android.os.RemoteException;
import android.os.UserHandle;
import com.android.internal.util.ArrayUtils;
import com.android.server.usb.UsbSettingsManager;
import com.android.server.usb.UsbUserSettingsManager;

class UsbSerialReader
extends IUsbSerialReader.Stub {
    private final String mSerialNumber;
    private final Context mContext;
    private final UsbSettingsManager mSettingsManager;
    private Object mDevice;

    UsbSerialReader(Context context, UsbSettingsManager settingsManager, String serialNumber) {
        this.mContext = context;
        this.mSettingsManager = settingsManager;
        this.mSerialNumber = serialNumber;
    }

    public void setDevice(Object device) {
        this.mDevice = device;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getSerial(String packageName) throws RemoteException {
        int pid = Binder.getCallingPid();
        int uid = Binder.getCallingUid();
        if (uid != 1000) {
            this.enforcePackageBelongsToUid(uid, packageName);
            long token = Binder.clearCallingIdentity();
            try {
                PackageInfo pkg;
                try {
                    pkg = this.mContext.getPackageManager().getPackageInfo(packageName, 0);
                }
                catch (PackageManager.NameNotFoundException e) {
                    throw new RemoteException("package " + packageName + " cannot be found");
                }
                int packageTargetSdkVersion = pkg.applicationInfo.targetSdkVersion;
                if (packageTargetSdkVersion >= 29 && this.mContext.checkPermission("android.permission.MANAGE_USB", pid, uid) == -1) {
                    UsbUserSettingsManager settings = this.mSettingsManager.getSettingsForUser(UserHandle.getUserId(uid));
                    if (this.mDevice instanceof UsbDevice) {
                        settings.checkPermission((UsbDevice)this.mDevice, packageName, uid);
                    } else {
                        settings.checkPermission((UsbAccessory)this.mDevice, uid);
                    }
                }
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }
        return this.mSerialNumber;
    }

    private void enforcePackageBelongsToUid(int uid, String packageName) {
        String[] packages = this.mContext.getPackageManager().getPackagesForUid(uid);
        if (!ArrayUtils.contains(packages, packageName)) {
            throw new IllegalArgumentException(packageName + " does to belong to the " + uid);
        }
    }
}

