/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.usb;

import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.res.XmlResourceParser;
import android.hardware.usb.AccessoryFilter;
import android.hardware.usb.DeviceFilter;
import android.hardware.usb.UsbAccessory;
import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbInterface;
import android.os.UserHandle;
import android.util.Slog;
import com.android.internal.util.XmlUtils;
import com.android.internal.util.dump.DualDumpOutputStream;
import com.android.internal.util.dump.DumpUtils;
import com.android.server.usb.UsbPermissionManager;
import com.android.server.usb.UsbProfileGroupSettingsManager;
import java.util.ArrayList;
import java.util.List;

class UsbUserSettingsManager {
    private static final String TAG = UsbUserSettingsManager.class.getSimpleName();
    private static final boolean DEBUG = false;
    private final UserHandle mUser;
    private final Context mUserContext;
    private final PackageManager mPackageManager;
    private final UsbPermissionManager mUsbPermissionManager;
    private final Object mLock = new Object();

    UsbUserSettingsManager(Context context, UserHandle user, UsbPermissionManager usbPermissionManager) {
        try {
            this.mUserContext = context.createPackageContextAsUser("android", 0, user);
        }
        catch (PackageManager.NameNotFoundException e) {
            throw new RuntimeException("Missing android package");
        }
        this.mPackageManager = this.mUserContext.getPackageManager();
        this.mUser = user;
        this.mUsbPermissionManager = usbPermissionManager;
    }

    void removeDevicePermissions(UsbDevice device) {
        this.mUsbPermissionManager.removeDevicePermissions(device);
    }

    void removeAccessoryPermissions(UsbAccessory accessory) {
        this.mUsbPermissionManager.removeAccessoryPermissions(accessory);
    }

    private boolean isCameraDevicePresent(UsbDevice device) {
        if (device.getDeviceClass() == 14) {
            return true;
        }
        for (int i = 0; i < device.getInterfaceCount(); ++i) {
            UsbInterface iface = device.getInterface(i);
            if (iface.getInterfaceClass() != 14) continue;
            return true;
        }
        return false;
    }

    private boolean isCameraPermissionGranted(String packageName, int uid) {
        int allowed;
        int targetSdkVersion = 28;
        try {
            ApplicationInfo aInfo = this.mPackageManager.getApplicationInfo(packageName, 0);
            if (aInfo.uid != uid) {
                Slog.i(TAG, "Package " + packageName + " does not match caller's uid " + uid);
                return false;
            }
            targetSdkVersion = aInfo.targetSdkVersion;
        }
        catch (PackageManager.NameNotFoundException e) {
            Slog.i(TAG, "Package not found, likely due to invalid package name!");
            return false;
        }
        if (targetSdkVersion >= 28 && -1 == (allowed = this.mUserContext.checkCallingPermission("android.permission.CAMERA"))) {
            Slog.i(TAG, "Camera permission required for USB video class devices");
            return false;
        }
        return true;
    }

    public boolean hasPermission(UsbDevice device, String packageName, int uid) {
        if (this.isCameraDevicePresent(device) && !this.isCameraPermissionGranted(packageName, uid)) {
            return false;
        }
        return this.mUsbPermissionManager.hasPermission(device, uid);
    }

    public boolean hasPermission(UsbAccessory accessory, int uid) {
        return this.mUsbPermissionManager.hasPermission(accessory, uid);
    }

    public void checkPermission(UsbDevice device, String packageName, int uid) {
        if (!this.hasPermission(device, packageName, uid)) {
            throw new SecurityException("User has not given " + uid + "/" + packageName + " permission to access device " + device.getDeviceName());
        }
    }

    public void checkPermission(UsbAccessory accessory, int uid) {
        if (!this.hasPermission(accessory, uid)) {
            throw new SecurityException("User has not given " + uid + " permission to accessory " + accessory);
        }
    }

    private void requestPermissionDialog(UsbDevice device, UsbAccessory accessory, boolean canBeDefault, String packageName, PendingIntent pi, int uid) {
        try {
            ApplicationInfo aInfo = this.mPackageManager.getApplicationInfo(packageName, 0);
            if (aInfo.uid != uid) {
                throw new IllegalArgumentException("package " + packageName + " does not match caller's uid " + uid);
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            throw new IllegalArgumentException("package " + packageName + " not found");
        }
        this.mUsbPermissionManager.requestPermissionDialog(device, accessory, canBeDefault, packageName, uid, this.mUserContext, pi);
    }

    public void requestPermission(UsbDevice device, String packageName, PendingIntent pi, int uid) {
        Intent intent = new Intent();
        if (this.hasPermission(device, packageName, uid)) {
            intent.putExtra("device", device);
            intent.putExtra("permission", true);
            try {
                pi.send(this.mUserContext, 0, intent);
            }
            catch (PendingIntent.CanceledException canceledException) {
                // empty catch block
            }
            return;
        }
        if (this.isCameraDevicePresent(device) && !this.isCameraPermissionGranted(packageName, uid)) {
            intent.putExtra("device", device);
            intent.putExtra("permission", false);
            try {
                pi.send(this.mUserContext, 0, intent);
            }
            catch (PendingIntent.CanceledException canceledException) {
                // empty catch block
            }
            return;
        }
        this.requestPermissionDialog(device, null, this.canBeDefault(device, packageName), packageName, pi, uid);
    }

    public void requestPermission(UsbAccessory accessory, String packageName, PendingIntent pi, int uid) {
        if (this.hasPermission(accessory, uid)) {
            Intent intent = new Intent();
            intent.putExtra("accessory", accessory);
            intent.putExtra("permission", true);
            try {
                pi.send(this.mUserContext, 0, intent);
            }
            catch (PendingIntent.CanceledException canceledException) {
                // empty catch block
            }
            return;
        }
        this.requestPermissionDialog(null, accessory, this.canBeDefault(accessory, packageName), packageName, pi, uid);
    }

    public void grantDevicePermission(UsbDevice device, int uid) {
        this.mUsbPermissionManager.grantDevicePermission(device, uid);
    }

    public void grantAccessoryPermission(UsbAccessory accessory, int uid) {
        this.mUsbPermissionManager.grantAccessoryPermission(accessory, uid);
    }

    List<ResolveInfo> queryIntentActivities(Intent intent) {
        return this.mPackageManager.queryIntentActivitiesAsUser(intent, 128, this.mUser.getIdentifier());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean canBeDefault(UsbDevice device, String packageName) {
        ActivityInfo[] activities = this.getPackageActivities(packageName);
        if (activities == null) return false;
        int numActivities = activities.length;
        int i = 0;
        while (i < numActivities) {
            ActivityInfo activityInfo = activities[i];
            try (XmlResourceParser parser = activityInfo.loadXmlMetaData(this.mPackageManager, "android.hardware.usb.action.USB_DEVICE_ATTACHED");){
                if (parser != null) {
                    XmlUtils.nextElement(parser);
                    while (parser.getEventType() != 1) {
                        DeviceFilter filter;
                        if ("usb-device".equals(parser.getName()) && (filter = DeviceFilter.read(parser)).matches(device)) {
                            boolean bl = true;
                            return bl;
                        }
                        XmlUtils.nextElement(parser);
                    }
                }
            }
            catch (Exception e) {
                Slog.w(TAG, "Unable to load component info " + activityInfo.toString(), e);
            }
            ++i;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean canBeDefault(UsbAccessory accessory, String packageName) {
        ActivityInfo[] activities = this.getPackageActivities(packageName);
        if (activities == null) return false;
        int numActivities = activities.length;
        int i = 0;
        while (i < numActivities) {
            ActivityInfo activityInfo = activities[i];
            try (XmlResourceParser parser = activityInfo.loadXmlMetaData(this.mPackageManager, "android.hardware.usb.action.USB_ACCESSORY_ATTACHED");){
                if (parser != null) {
                    XmlUtils.nextElement(parser);
                    while (parser.getEventType() != 1) {
                        AccessoryFilter filter;
                        if ("usb-accessory".equals(parser.getName()) && (filter = AccessoryFilter.read(parser)).matches(accessory)) {
                            boolean bl = true;
                            return bl;
                        }
                        XmlUtils.nextElement(parser);
                    }
                }
            }
            catch (Exception e) {
                Slog.w(TAG, "Unable to load component info " + activityInfo.toString(), e);
            }
            ++i;
        }
        return false;
    }

    private ActivityInfo[] getPackageActivities(String packageName) {
        try {
            PackageInfo packageInfo = this.mPackageManager.getPackageInfo(packageName, 129);
            return packageInfo.activities;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump(DualDumpOutputStream dump, String idName, long id2) {
        long token = dump.start(idName, id2);
        Object object = this.mLock;
        synchronized (object) {
            dump.write("user_id", 0x10500000001L, this.mUser.getIdentifier());
            this.mUsbPermissionManager.dump(dump);
            List<ResolveInfo> deviceAttachedActivities = this.queryIntentActivities(new Intent("android.hardware.usb.action.USB_DEVICE_ATTACHED"));
            int numDeviceAttachedActivities = deviceAttachedActivities.size();
            for (int activityNum = 0; activityNum < numDeviceAttachedActivities; ++activityNum) {
                ResolveInfo deviceAttachedActivity = deviceAttachedActivities.get(activityNum);
                long deviceAttachedActivityToken = dump.start("device_attached_activities", 2246267895812L);
                DumpUtils.writeComponentName(dump, "activity", 0x10B00000001L, new ComponentName(deviceAttachedActivity.activityInfo.packageName, deviceAttachedActivity.activityInfo.name));
                ArrayList<DeviceFilter> deviceFilters = UsbProfileGroupSettingsManager.getDeviceFilters(this.mPackageManager, deviceAttachedActivity);
                if (deviceFilters != null) {
                    int numDeviceFilters = deviceFilters.size();
                    for (int filterNum = 0; filterNum < numDeviceFilters; ++filterNum) {
                        deviceFilters.get(filterNum).dump(dump, "filters", 0x20B00000002L);
                    }
                }
                dump.end(deviceAttachedActivityToken);
            }
            List<ResolveInfo> accessoryAttachedActivities = this.queryIntentActivities(new Intent("android.hardware.usb.action.USB_ACCESSORY_ATTACHED"));
            int numAccessoryAttachedActivities = accessoryAttachedActivities.size();
            for (int activityNum = 0; activityNum < numAccessoryAttachedActivities; ++activityNum) {
                ResolveInfo accessoryAttachedActivity = accessoryAttachedActivities.get(activityNum);
                long accessoryAttachedActivityToken = dump.start("accessory_attached_activities", 2246267895813L);
                DumpUtils.writeComponentName(dump, "activity", 0x10B00000001L, new ComponentName(accessoryAttachedActivity.activityInfo.packageName, accessoryAttachedActivity.activityInfo.name));
                ArrayList<AccessoryFilter> accessoryFilters = UsbProfileGroupSettingsManager.getAccessoryFilters(this.mPackageManager, accessoryAttachedActivity);
                if (accessoryFilters != null) {
                    int numAccessoryFilters = accessoryFilters.size();
                    for (int filterNum = 0; filterNum < numAccessoryFilters; ++filterNum) {
                        accessoryFilters.get(filterNum).dump(dump, "filters", 0x20B00000002L);
                    }
                }
                dump.end(accessoryAttachedActivityToken);
            }
        }
        dump.end(token);
    }
}

