/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.usb.descriptors;

import com.android.server.usb.descriptors.ByteStream;
import com.android.server.usb.descriptors.Usb10ASFormatI;
import com.android.server.usb.descriptors.Usb10ASFormatII;
import com.android.server.usb.descriptors.Usb20ASFormatI;
import com.android.server.usb.descriptors.Usb20ASFormatII;
import com.android.server.usb.descriptors.Usb20ASFormatIII;
import com.android.server.usb.descriptors.UsbACInterface;
import com.android.server.usb.descriptors.UsbDescriptor;
import com.android.server.usb.descriptors.UsbDescriptorParser;
import com.android.server.usb.descriptors.report.ReportCanvas;
import com.android.server.usb.descriptors.report.UsbStrings;

public class UsbASFormat
extends UsbACInterface {
    private static final String TAG = "UsbASFormat";
    private final byte mFormatType;
    public static final byte FORMAT_TYPE_I = 1;
    public static final byte FORMAT_TYPE_II = 2;
    public static final byte FORMAT_TYPE_III = 3;
    public static final byte FORMAT_TYPE_IV = 4;
    public static final byte EXT_FORMAT_TYPE_I = -127;
    public static final byte EXT_FORMAT_TYPE_II = -126;
    public static final byte EXT_FORMAT_TYPE_III = -125;

    public UsbASFormat(int length, byte type, byte subtype, byte formatType, int mSubclass) {
        super(length, type, subtype, mSubclass);
        this.mFormatType = formatType;
    }

    public byte getFormatType() {
        return this.mFormatType;
    }

    public int[] getSampleRates() {
        return null;
    }

    public int[] getBitDepths() {
        return null;
    }

    public int[] getChannelCounts() {
        return null;
    }

    public static UsbDescriptor allocDescriptor(UsbDescriptorParser parser, ByteStream stream, int length, byte type, byte subtype, int subclass) {
        byte formatType = stream.getByte();
        int acInterfaceSpec = parser.getACInterfaceSpec();
        switch (formatType) {
            case 1: {
                if (acInterfaceSpec == 512) {
                    return new Usb20ASFormatI(length, type, subtype, formatType, subclass);
                }
                return new Usb10ASFormatI(length, type, subtype, formatType, subclass);
            }
            case 2: {
                if (acInterfaceSpec == 512) {
                    return new Usb20ASFormatII(length, type, subtype, formatType, subclass);
                }
                return new Usb10ASFormatII(length, type, subtype, formatType, subclass);
            }
            case 3: {
                return new Usb20ASFormatIII(length, type, subtype, formatType, subclass);
            }
        }
        return new UsbASFormat(length, type, subtype, formatType, subclass);
    }

    @Override
    public void report(ReportCanvas canvas) {
        super.report(canvas);
        canvas.writeParagraph(UsbStrings.getFormatName(this.getFormatType()), false);
    }
}

