/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.utils;

import android.content.Context;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import android.util.Log;

public class AppInstallerUtil {
    private static final String LOG_TAG = "AppInstallerUtil";

    private static Intent resolveIntent(Context context, Intent i) {
        ResolveInfo result = context.getPackageManager().resolveActivity(i, 0);
        return result != null ? new Intent(i.getAction()).setClassName(result.activityInfo.packageName, result.activityInfo.name) : null;
    }

    public static String getInstallerPackageName(Context context, String packageName) {
        String installerPackageName = null;
        try {
            installerPackageName = context.getPackageManager().getInstallerPackageName(packageName);
        }
        catch (IllegalArgumentException e) {
            Log.e(LOG_TAG, "Exception while retrieving the package installer of " + packageName, e);
        }
        if (installerPackageName == null) {
            return null;
        }
        return installerPackageName;
    }

    public static Intent createIntent(Context context, String installerPackageName, String packageName) {
        Intent intent = new Intent("android.intent.action.SHOW_APP_INFO").setPackage(installerPackageName);
        Intent result = AppInstallerUtil.resolveIntent(context, intent);
        if (result != null) {
            result.putExtra("android.intent.extra.PACKAGE_NAME", packageName);
            result.addFlags(0x10000000);
            return result;
        }
        return null;
    }

    public static Intent createIntent(Context context, String packageName) {
        String installerPackageName = AppInstallerUtil.getInstallerPackageName(context, packageName);
        return AppInstallerUtil.createIntent(context, installerPackageName, packageName);
    }
}

