/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.utils;

import android.provider.DeviceConfig;
import com.android.internal.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class FlagNamespaceUtils {
    public static final String NAMESPACE_NO_PACKAGE = "no_package";
    @VisibleForTesting
    public static final String NAMESPACE_RESCUE_PARTY = "rescue_party_namespace";
    @VisibleForTesting
    public static final String ALL_KNOWN_NAMESPACES_FLAG = "all_known_namespaces";
    @VisibleForTesting
    public static final String RESET_PLATFORM_PACKAGE_FLAG = "reset_platform_package";
    private static final String DELIMITER = ":";
    private static final int MAX_COUNTER_VALUE = 50;
    private static int sKnownResetNamespacesFlagCounter = -1;

    public static void addToKnownResetNamespaces(List<String> namespacesList) {
        if (namespacesList == null) {
            return;
        }
        for (String namespace : namespacesList) {
            FlagNamespaceUtils.addToKnownResetNamespaces(namespace);
        }
    }

    public static void addToKnownResetNamespaces(String namespace) {
        int nextFlagCounter = FlagNamespaceUtils.incrementAndRetrieveResetNamespacesFlagCounter();
        DeviceConfig.setProperty(NAMESPACE_RESCUE_PARTY, RESET_PLATFORM_PACKAGE_FLAG + nextFlagCounter, namespace, true);
    }

    public static void resetDeviceConfig(int resetMode) {
        FlagNamespaceUtils.resetDeviceConfig(resetMode, FlagNamespaceUtils.getAllKnownDeviceConfigNamespacesList());
    }

    public static void resetDeviceConfig(int resetMode, List<String> namespacesList) {
        for (String namespace : namespacesList) {
            DeviceConfig.resetToDefaults(resetMode, namespace);
        }
        FlagNamespaceUtils.addToKnownResetNamespaces(namespacesList);
    }

    @VisibleForTesting
    public static void resetKnownResetNamespacesFlagCounterForTest() {
        sKnownResetNamespacesFlagCounter = -1;
    }

    private static List<String> getAllKnownDeviceConfigNamespacesList() {
        String namespacesStr = DeviceConfig.getProperty(NAMESPACE_RESCUE_PARTY, ALL_KNOWN_NAMESPACES_FLAG);
        List<String> namespacesList = FlagNamespaceUtils.toStringList(namespacesStr);
        namespacesList.remove(NAMESPACE_RESCUE_PARTY);
        return namespacesList;
    }

    private static List<String> toStringList(String serialized) {
        if (serialized == null || serialized.length() == 0) {
            return new ArrayList<String>();
        }
        return Arrays.asList(serialized.split(DELIMITER));
    }

    private static int incrementAndRetrieveResetNamespacesFlagCounter() {
        if (++sKnownResetNamespacesFlagCounter == 50) {
            sKnownResetNamespacesFlagCounter = 0;
        }
        return sKnownResetNamespacesFlagCounter;
    }
}

