/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.utils;

import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Arrays;

public final class PriorityDump {
    public static final String PRIORITY_ARG = "--dump-priority";
    public static final String PROTO_ARG = "--proto";
    public static final String PRIORITY_ARG_CRITICAL = "CRITICAL";
    public static final String PRIORITY_ARG_HIGH = "HIGH";
    public static final String PRIORITY_ARG_NORMAL = "NORMAL";
    private static final int PRIORITY_TYPE_INVALID = 0;
    private static final int PRIORITY_TYPE_CRITICAL = 1;
    private static final int PRIORITY_TYPE_HIGH = 2;
    private static final int PRIORITY_TYPE_NORMAL = 3;

    private PriorityDump() {
        throw new UnsupportedOperationException();
    }

    public static void dump(PriorityDumper dumper, FileDescriptor fd, PrintWriter pw, String[] args) {
        boolean asProto = false;
        int priority = 0;
        if (args == null) {
            dumper.dump(fd, pw, args, asProto);
            return;
        }
        String[] strippedArgs = new String[args.length];
        int strippedCount = 0;
        for (int argIndex = 0; argIndex < args.length; ++argIndex) {
            if (args[argIndex].equals(PROTO_ARG)) {
                asProto = true;
                continue;
            }
            if (args[argIndex].equals(PRIORITY_ARG)) {
                if (argIndex + 1 >= args.length) continue;
                priority = PriorityDump.getPriorityType(args[++argIndex]);
                continue;
            }
            strippedArgs[strippedCount++] = args[argIndex];
        }
        if (strippedCount < args.length) {
            strippedArgs = Arrays.copyOf(strippedArgs, strippedCount);
        }
        switch (priority) {
            case 1: {
                dumper.dumpCritical(fd, pw, strippedArgs, asProto);
                return;
            }
            case 2: {
                dumper.dumpHigh(fd, pw, strippedArgs, asProto);
                return;
            }
            case 3: {
                dumper.dumpNormal(fd, pw, strippedArgs, asProto);
                return;
            }
        }
        dumper.dump(fd, pw, strippedArgs, asProto);
    }

    private static int getPriorityType(String arg) {
        switch (arg) {
            case "CRITICAL": {
                return 1;
            }
            case "HIGH": {
                return 2;
            }
            case "NORMAL": {
                return 3;
            }
        }
        return 0;
    }

    public static interface PriorityDumper {
        default public void dumpCritical(FileDescriptor fd, PrintWriter pw, String[] args, boolean asProto) {
        }

        default public void dumpHigh(FileDescriptor fd, PrintWriter pw, String[] args, boolean asProto) {
        }

        default public void dumpNormal(FileDescriptor fd, PrintWriter pw, String[] args, boolean asProto) {
        }

        default public void dump(FileDescriptor fd, PrintWriter pw, String[] args, boolean asProto) {
            this.dumpCritical(fd, pw, args, asProto);
            this.dumpHigh(fd, pw, args, asProto);
            this.dumpNormal(fd, pw, args, asProto);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    private static @interface PriorityType {
    }
}

