/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.utils;

import android.os.Handler;
import android.os.IBinder;
import android.os.TokenWatcher;
import android.util.SparseArray;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.util.IndentingPrintWriter;
import java.io.PrintWriter;
import java.io.Writer;

public final class UserTokenWatcher {
    private final Callback mCallback;
    private final Handler mHandler;
    private final String mTag;
    @GuardedBy(value={"mWatchers"})
    private final SparseArray<TokenWatcher> mWatchers = new SparseArray(1);

    public UserTokenWatcher(Callback callback, Handler handler, String tag) {
        this.mCallback = callback;
        this.mHandler = handler;
        this.mTag = tag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acquire(IBinder token, String tag, int userId) {
        SparseArray<TokenWatcher> sparseArray = this.mWatchers;
        synchronized (sparseArray) {
            TokenWatcher watcher = this.mWatchers.get(userId);
            if (watcher == null) {
                watcher = new InnerTokenWatcher(userId, this.mHandler, this.mTag);
                this.mWatchers.put(userId, watcher);
            }
            watcher.acquire(token, tag);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(IBinder token, int userId) {
        SparseArray<TokenWatcher> sparseArray = this.mWatchers;
        synchronized (sparseArray) {
            TokenWatcher watcher = this.mWatchers.get(userId);
            if (watcher != null) {
                watcher.release(token);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAcquired(int userId) {
        SparseArray<TokenWatcher> sparseArray = this.mWatchers;
        synchronized (sparseArray) {
            TokenWatcher watcher = this.mWatchers.get(userId);
            return watcher != null && watcher.isAcquired();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump(PrintWriter pw) {
        SparseArray<TokenWatcher> sparseArray = this.mWatchers;
        synchronized (sparseArray) {
            for (int i = 0; i < this.mWatchers.size(); ++i) {
                int userId = this.mWatchers.keyAt(i);
                TokenWatcher watcher = this.mWatchers.valueAt(i);
                if (!watcher.isAcquired()) continue;
                pw.print("User ");
                pw.print(userId);
                pw.println(":");
                watcher.dump(new IndentingPrintWriter((Writer)pw, " "));
            }
        }
    }

    private final class InnerTokenWatcher
    extends TokenWatcher {
        private final int mUserId;

        private InnerTokenWatcher(int userId, Handler handler, String tag) {
            super(handler, tag);
            this.mUserId = userId;
        }

        @Override
        public void acquired() {
            UserTokenWatcher.this.mCallback.acquired(this.mUserId);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void released() {
            UserTokenWatcher.this.mCallback.released(this.mUserId);
            SparseArray sparseArray = UserTokenWatcher.this.mWatchers;
            synchronized (sparseArray) {
                TokenWatcher watcher = (TokenWatcher)UserTokenWatcher.this.mWatchers.get(this.mUserId);
                if (watcher != null && !watcher.isAcquired()) {
                    UserTokenWatcher.this.mWatchers.remove(this.mUserId);
                }
            }
        }
    }

    public static interface Callback {
        public void acquired(int var1);

        public void released(int var1);
    }
}

