/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wifi.nano;

import com.android.framework.protobuf.nano.CodedInputByteBufferNano;
import com.android.framework.protobuf.nano.CodedOutputByteBufferNano;
import com.android.framework.protobuf.nano.InternalNano;
import com.android.framework.protobuf.nano.InvalidProtocolBufferNanoException;
import com.android.framework.protobuf.nano.MessageNano;
import com.android.framework.protobuf.nano.WireFormatNano;
import java.io.IOException;

public interface WifiMetricsProto {

    public static final class PasspointProvisionStats
    extends MessageNano {
        public static final int OSU_FAILURE_UNKNOWN = 0;
        public static final int OSU_FAILURE_AP_CONNECTION = 1;
        public static final int OSU_FAILURE_SERVER_URL_INVALID = 2;
        public static final int OSU_FAILURE_SERVER_CONNECTION = 3;
        public static final int OSU_FAILURE_SERVER_VALIDATION = 4;
        public static final int OSU_FAILURE_SERVICE_PROVIDER_VERIFICATION = 5;
        public static final int OSU_FAILURE_PROVISIONING_ABORTED = 6;
        public static final int OSU_FAILURE_PROVISIONING_NOT_AVAILABLE = 7;
        public static final int OSU_FAILURE_INVALID_URL_FORMAT_FOR_OSU = 8;
        public static final int OSU_FAILURE_UNEXPECTED_COMMAND_TYPE = 9;
        public static final int OSU_FAILURE_UNEXPECTED_SOAP_MESSAGE_TYPE = 10;
        public static final int OSU_FAILURE_SOAP_MESSAGE_EXCHANGE = 11;
        public static final int OSU_FAILURE_START_REDIRECT_LISTENER = 12;
        public static final int OSU_FAILURE_TIMED_OUT_REDIRECT_LISTENER = 13;
        public static final int OSU_FAILURE_NO_OSU_ACTIVITY_FOUND = 14;
        public static final int OSU_FAILURE_UNEXPECTED_SOAP_MESSAGE_STATUS = 15;
        public static final int OSU_FAILURE_NO_PPS_MO = 16;
        public static final int OSU_FAILURE_NO_AAA_SERVER_TRUST_ROOT_NODE = 17;
        public static final int OSU_FAILURE_NO_REMEDIATION_SERVER_TRUST_ROOT_NODE = 18;
        public static final int OSU_FAILURE_NO_POLICY_SERVER_TRUST_ROOT_NODE = 19;
        public static final int OSU_FAILURE_RETRIEVE_TRUST_ROOT_CERTIFICATES = 20;
        public static final int OSU_FAILURE_NO_AAA_TRUST_ROOT_CERTIFICATE = 21;
        public static final int OSU_FAILURE_ADD_PASSPOINT_CONFIGURATION = 22;
        public static final int OSU_FAILURE_OSU_PROVIDER_NOT_FOUND = 23;
        private static volatile PasspointProvisionStats[] _emptyArray;
        public int numProvisionSuccess;
        public ProvisionFailureCount[] provisionFailureCount;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static PasspointProvisionStats[] emptyArray() {
            if (_emptyArray == null) {
                Object object = InternalNano.LAZY_INIT_LOCK;
                synchronized (object) {
                    if (_emptyArray == null) {
                        _emptyArray = new PasspointProvisionStats[0];
                    }
                }
            }
            return _emptyArray;
        }

        public PasspointProvisionStats() {
            this.clear();
        }

        public PasspointProvisionStats clear() {
            this.numProvisionSuccess = 0;
            this.provisionFailureCount = ProvisionFailureCount.emptyArray();
            this.cachedSize = -1;
            return this;
        }

        @Override
        public void writeTo(CodedOutputByteBufferNano output) throws IOException {
            if (this.numProvisionSuccess != 0) {
                output.writeInt32(1, this.numProvisionSuccess);
            }
            if (this.provisionFailureCount != null && this.provisionFailureCount.length > 0) {
                for (int i = 0; i < this.provisionFailureCount.length; ++i) {
                    ProvisionFailureCount element = this.provisionFailureCount[i];
                    if (element == null) continue;
                    output.writeMessage(2, element);
                }
            }
            super.writeTo(output);
        }

        @Override
        protected int computeSerializedSize() {
            int size = super.computeSerializedSize();
            if (this.numProvisionSuccess != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(1, this.numProvisionSuccess);
            }
            if (this.provisionFailureCount != null && this.provisionFailureCount.length > 0) {
                for (int i = 0; i < this.provisionFailureCount.length; ++i) {
                    ProvisionFailureCount element = this.provisionFailureCount[i];
                    if (element == null) continue;
                    size += CodedOutputByteBufferNano.computeMessageSize(2, element);
                }
            }
            return size;
        }

        @Override
        public PasspointProvisionStats mergeFrom(CodedInputByteBufferNano input) throws IOException {
            block5: while (true) {
                int tag = input.readTag();
                switch (tag) {
                    case 0: {
                        return this;
                    }
                    default: {
                        if (WireFormatNano.parseUnknownField(input, tag)) continue block5;
                        return this;
                    }
                    case 8: {
                        this.numProvisionSuccess = input.readInt32();
                        continue block5;
                    }
                    case 18: 
                }
                int arrayLength = WireFormatNano.getRepeatedFieldArrayLength(input, 18);
                int i = this.provisionFailureCount == null ? 0 : this.provisionFailureCount.length;
                ProvisionFailureCount[] newArray = new ProvisionFailureCount[i + arrayLength];
                if (i != 0) {
                    System.arraycopy(this.provisionFailureCount, 0, newArray, 0, i);
                }
                while (i < newArray.length - 1) {
                    newArray[i] = new ProvisionFailureCount();
                    input.readMessage(newArray[i]);
                    input.readTag();
                    ++i;
                }
                newArray[i] = new ProvisionFailureCount();
                input.readMessage(newArray[i]);
                this.provisionFailureCount = newArray;
            }
        }

        public static PasspointProvisionStats parseFrom(byte[] data) throws InvalidProtocolBufferNanoException {
            return MessageNano.mergeFrom(new PasspointProvisionStats(), data);
        }

        public static PasspointProvisionStats parseFrom(CodedInputByteBufferNano input) throws IOException {
            return new PasspointProvisionStats().mergeFrom(input);
        }

        public static final class ProvisionFailureCount
        extends MessageNano {
            private static volatile ProvisionFailureCount[] _emptyArray;
            public int failureCode;
            public int count;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public static ProvisionFailureCount[] emptyArray() {
                if (_emptyArray == null) {
                    Object object = InternalNano.LAZY_INIT_LOCK;
                    synchronized (object) {
                        if (_emptyArray == null) {
                            _emptyArray = new ProvisionFailureCount[0];
                        }
                    }
                }
                return _emptyArray;
            }

            public ProvisionFailureCount() {
                this.clear();
            }

            public ProvisionFailureCount clear() {
                this.failureCode = 0;
                this.count = 0;
                this.cachedSize = -1;
                return this;
            }

            @Override
            public void writeTo(CodedOutputByteBufferNano output) throws IOException {
                if (this.failureCode != 0) {
                    output.writeInt32(1, this.failureCode);
                }
                if (this.count != 0) {
                    output.writeInt32(2, this.count);
                }
                super.writeTo(output);
            }

            @Override
            protected int computeSerializedSize() {
                int size = super.computeSerializedSize();
                if (this.failureCode != 0) {
                    size += CodedOutputByteBufferNano.computeInt32Size(1, this.failureCode);
                }
                if (this.count != 0) {
                    size += CodedOutputByteBufferNano.computeInt32Size(2, this.count);
                }
                return size;
            }

            @Override
            public ProvisionFailureCount mergeFrom(CodedInputByteBufferNano input) throws IOException {
                block8: while (true) {
                    int tag = input.readTag();
                    switch (tag) {
                        case 0: {
                            return this;
                        }
                        default: {
                            if (WireFormatNano.parseUnknownField(input, tag)) continue block8;
                            return this;
                        }
                        case 8: {
                            int value = input.readInt32();
                            switch (value) {
                                case 0: 
                                case 1: 
                                case 2: 
                                case 3: 
                                case 4: 
                                case 5: 
                                case 6: 
                                case 7: 
                                case 8: 
                                case 9: 
                                case 10: 
                                case 11: 
                                case 12: 
                                case 13: 
                                case 14: 
                                case 15: 
                                case 16: 
                                case 17: 
                                case 18: 
                                case 19: 
                                case 20: 
                                case 21: 
                                case 22: 
                                case 23: {
                                    this.failureCode = value;
                                }
                            }
                            continue block8;
                        }
                        case 16: 
                    }
                    this.count = input.readInt32();
                }
            }

            public static ProvisionFailureCount parseFrom(byte[] data) throws InvalidProtocolBufferNanoException {
                return MessageNano.mergeFrom(new ProvisionFailureCount(), data);
            }

            public static ProvisionFailureCount parseFrom(CodedInputByteBufferNano input) throws IOException {
                return new ProvisionFailureCount().mergeFrom(input);
            }
        }
    }

    public static final class WifiToggleStats
    extends MessageNano {
        private static volatile WifiToggleStats[] _emptyArray;
        public int numToggleOnPrivileged;
        public int numToggleOffPrivileged;
        public int numToggleOnNormal;
        public int numToggleOffNormal;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static WifiToggleStats[] emptyArray() {
            if (_emptyArray == null) {
                Object object = InternalNano.LAZY_INIT_LOCK;
                synchronized (object) {
                    if (_emptyArray == null) {
                        _emptyArray = new WifiToggleStats[0];
                    }
                }
            }
            return _emptyArray;
        }

        public WifiToggleStats() {
            this.clear();
        }

        public WifiToggleStats clear() {
            this.numToggleOnPrivileged = 0;
            this.numToggleOffPrivileged = 0;
            this.numToggleOnNormal = 0;
            this.numToggleOffNormal = 0;
            this.cachedSize = -1;
            return this;
        }

        @Override
        public void writeTo(CodedOutputByteBufferNano output) throws IOException {
            if (this.numToggleOnPrivileged != 0) {
                output.writeInt32(1, this.numToggleOnPrivileged);
            }
            if (this.numToggleOffPrivileged != 0) {
                output.writeInt32(2, this.numToggleOffPrivileged);
            }
            if (this.numToggleOnNormal != 0) {
                output.writeInt32(3, this.numToggleOnNormal);
            }
            if (this.numToggleOffNormal != 0) {
                output.writeInt32(4, this.numToggleOffNormal);
            }
            super.writeTo(output);
        }

        @Override
        protected int computeSerializedSize() {
            int size = super.computeSerializedSize();
            if (this.numToggleOnPrivileged != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(1, this.numToggleOnPrivileged);
            }
            if (this.numToggleOffPrivileged != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(2, this.numToggleOffPrivileged);
            }
            if (this.numToggleOnNormal != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(3, this.numToggleOnNormal);
            }
            if (this.numToggleOffNormal != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(4, this.numToggleOffNormal);
            }
            return size;
        }

        @Override
        public WifiToggleStats mergeFrom(CodedInputByteBufferNano input) throws IOException {
            block7: while (true) {
                int tag = input.readTag();
                switch (tag) {
                    case 0: {
                        return this;
                    }
                    default: {
                        if (WireFormatNano.parseUnknownField(input, tag)) continue block7;
                        return this;
                    }
                    case 8: {
                        this.numToggleOnPrivileged = input.readInt32();
                        continue block7;
                    }
                    case 16: {
                        this.numToggleOffPrivileged = input.readInt32();
                        continue block7;
                    }
                    case 24: {
                        this.numToggleOnNormal = input.readInt32();
                        continue block7;
                    }
                    case 32: 
                }
                this.numToggleOffNormal = input.readInt32();
            }
        }

        public static WifiToggleStats parseFrom(byte[] data) throws InvalidProtocolBufferNanoException {
            return MessageNano.mergeFrom(new WifiToggleStats(), data);
        }

        public static WifiToggleStats parseFrom(CodedInputByteBufferNano input) throws IOException {
            return new WifiToggleStats().mergeFrom(input);
        }
    }

    public static final class WifiLockStats
    extends MessageNano {
        private static volatile WifiLockStats[] _emptyArray;
        public long highPerfActiveTimeMs;
        public long lowLatencyActiveTimeMs;
        public HistogramBucketInt32[] highPerfLockAcqDurationSecHistogram;
        public HistogramBucketInt32[] lowLatencyLockAcqDurationSecHistogram;
        public HistogramBucketInt32[] highPerfActiveSessionDurationSecHistogram;
        public HistogramBucketInt32[] lowLatencyActiveSessionDurationSecHistogram;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static WifiLockStats[] emptyArray() {
            if (_emptyArray == null) {
                Object object = InternalNano.LAZY_INIT_LOCK;
                synchronized (object) {
                    if (_emptyArray == null) {
                        _emptyArray = new WifiLockStats[0];
                    }
                }
            }
            return _emptyArray;
        }

        public WifiLockStats() {
            this.clear();
        }

        public WifiLockStats clear() {
            this.highPerfActiveTimeMs = 0L;
            this.lowLatencyActiveTimeMs = 0L;
            this.highPerfLockAcqDurationSecHistogram = HistogramBucketInt32.emptyArray();
            this.lowLatencyLockAcqDurationSecHistogram = HistogramBucketInt32.emptyArray();
            this.highPerfActiveSessionDurationSecHistogram = HistogramBucketInt32.emptyArray();
            this.lowLatencyActiveSessionDurationSecHistogram = HistogramBucketInt32.emptyArray();
            this.cachedSize = -1;
            return this;
        }

        @Override
        public void writeTo(CodedOutputByteBufferNano output) throws IOException {
            HistogramBucketInt32 element;
            int i;
            if (this.highPerfActiveTimeMs != 0L) {
                output.writeInt64(1, this.highPerfActiveTimeMs);
            }
            if (this.lowLatencyActiveTimeMs != 0L) {
                output.writeInt64(2, this.lowLatencyActiveTimeMs);
            }
            if (this.highPerfLockAcqDurationSecHistogram != null && this.highPerfLockAcqDurationSecHistogram.length > 0) {
                for (i = 0; i < this.highPerfLockAcqDurationSecHistogram.length; ++i) {
                    element = this.highPerfLockAcqDurationSecHistogram[i];
                    if (element == null) continue;
                    output.writeMessage(3, element);
                }
            }
            if (this.lowLatencyLockAcqDurationSecHistogram != null && this.lowLatencyLockAcqDurationSecHistogram.length > 0) {
                for (i = 0; i < this.lowLatencyLockAcqDurationSecHistogram.length; ++i) {
                    element = this.lowLatencyLockAcqDurationSecHistogram[i];
                    if (element == null) continue;
                    output.writeMessage(4, element);
                }
            }
            if (this.highPerfActiveSessionDurationSecHistogram != null && this.highPerfActiveSessionDurationSecHistogram.length > 0) {
                for (i = 0; i < this.highPerfActiveSessionDurationSecHistogram.length; ++i) {
                    element = this.highPerfActiveSessionDurationSecHistogram[i];
                    if (element == null) continue;
                    output.writeMessage(5, element);
                }
            }
            if (this.lowLatencyActiveSessionDurationSecHistogram != null && this.lowLatencyActiveSessionDurationSecHistogram.length > 0) {
                for (i = 0; i < this.lowLatencyActiveSessionDurationSecHistogram.length; ++i) {
                    element = this.lowLatencyActiveSessionDurationSecHistogram[i];
                    if (element == null) continue;
                    output.writeMessage(6, element);
                }
            }
            super.writeTo(output);
        }

        @Override
        protected int computeSerializedSize() {
            HistogramBucketInt32 element;
            int i;
            int size = super.computeSerializedSize();
            if (this.highPerfActiveTimeMs != 0L) {
                size += CodedOutputByteBufferNano.computeInt64Size(1, this.highPerfActiveTimeMs);
            }
            if (this.lowLatencyActiveTimeMs != 0L) {
                size += CodedOutputByteBufferNano.computeInt64Size(2, this.lowLatencyActiveTimeMs);
            }
            if (this.highPerfLockAcqDurationSecHistogram != null && this.highPerfLockAcqDurationSecHistogram.length > 0) {
                for (i = 0; i < this.highPerfLockAcqDurationSecHistogram.length; ++i) {
                    element = this.highPerfLockAcqDurationSecHistogram[i];
                    if (element == null) continue;
                    size += CodedOutputByteBufferNano.computeMessageSize(3, element);
                }
            }
            if (this.lowLatencyLockAcqDurationSecHistogram != null && this.lowLatencyLockAcqDurationSecHistogram.length > 0) {
                for (i = 0; i < this.lowLatencyLockAcqDurationSecHistogram.length; ++i) {
                    element = this.lowLatencyLockAcqDurationSecHistogram[i];
                    if (element == null) continue;
                    size += CodedOutputByteBufferNano.computeMessageSize(4, element);
                }
            }
            if (this.highPerfActiveSessionDurationSecHistogram != null && this.highPerfActiveSessionDurationSecHistogram.length > 0) {
                for (i = 0; i < this.highPerfActiveSessionDurationSecHistogram.length; ++i) {
                    element = this.highPerfActiveSessionDurationSecHistogram[i];
                    if (element == null) continue;
                    size += CodedOutputByteBufferNano.computeMessageSize(5, element);
                }
            }
            if (this.lowLatencyActiveSessionDurationSecHistogram != null && this.lowLatencyActiveSessionDurationSecHistogram.length > 0) {
                for (i = 0; i < this.lowLatencyActiveSessionDurationSecHistogram.length; ++i) {
                    element = this.lowLatencyActiveSessionDurationSecHistogram[i];
                    if (element == null) continue;
                    size += CodedOutputByteBufferNano.computeMessageSize(6, element);
                }
            }
            return size;
        }

        @Override
        public WifiLockStats mergeFrom(CodedInputByteBufferNano input) throws IOException {
            block9: while (true) {
                HistogramBucketInt32[] newArray;
                int i;
                int arrayLength;
                int tag = input.readTag();
                switch (tag) {
                    case 0: {
                        return this;
                    }
                    default: {
                        if (WireFormatNano.parseUnknownField(input, tag)) continue block9;
                        return this;
                    }
                    case 8: {
                        this.highPerfActiveTimeMs = input.readInt64();
                        continue block9;
                    }
                    case 16: {
                        this.lowLatencyActiveTimeMs = input.readInt64();
                        continue block9;
                    }
                    case 26: {
                        arrayLength = WireFormatNano.getRepeatedFieldArrayLength(input, 26);
                        i = this.highPerfLockAcqDurationSecHistogram == null ? 0 : this.highPerfLockAcqDurationSecHistogram.length;
                        newArray = new HistogramBucketInt32[i + arrayLength];
                        if (i != 0) {
                            System.arraycopy(this.highPerfLockAcqDurationSecHistogram, 0, newArray, 0, i);
                        }
                        while (i < newArray.length - 1) {
                            newArray[i] = new HistogramBucketInt32();
                            input.readMessage(newArray[i]);
                            input.readTag();
                            ++i;
                        }
                        newArray[i] = new HistogramBucketInt32();
                        input.readMessage(newArray[i]);
                        this.highPerfLockAcqDurationSecHistogram = newArray;
                        continue block9;
                    }
                    case 34: {
                        arrayLength = WireFormatNano.getRepeatedFieldArrayLength(input, 34);
                        i = this.lowLatencyLockAcqDurationSecHistogram == null ? 0 : this.lowLatencyLockAcqDurationSecHistogram.length;
                        newArray = new HistogramBucketInt32[i + arrayLength];
                        if (i != 0) {
                            System.arraycopy(this.lowLatencyLockAcqDurationSecHistogram, 0, newArray, 0, i);
                        }
                        while (i < newArray.length - 1) {
                            newArray[i] = new HistogramBucketInt32();
                            input.readMessage(newArray[i]);
                            input.readTag();
                            ++i;
                        }
                        newArray[i] = new HistogramBucketInt32();
                        input.readMessage(newArray[i]);
                        this.lowLatencyLockAcqDurationSecHistogram = newArray;
                        continue block9;
                    }
                    case 42: {
                        arrayLength = WireFormatNano.getRepeatedFieldArrayLength(input, 42);
                        i = this.highPerfActiveSessionDurationSecHistogram == null ? 0 : this.highPerfActiveSessionDurationSecHistogram.length;
                        newArray = new HistogramBucketInt32[i + arrayLength];
                        if (i != 0) {
                            System.arraycopy(this.highPerfActiveSessionDurationSecHistogram, 0, newArray, 0, i);
                        }
                        while (i < newArray.length - 1) {
                            newArray[i] = new HistogramBucketInt32();
                            input.readMessage(newArray[i]);
                            input.readTag();
                            ++i;
                        }
                        newArray[i] = new HistogramBucketInt32();
                        input.readMessage(newArray[i]);
                        this.highPerfActiveSessionDurationSecHistogram = newArray;
                        continue block9;
                    }
                    case 50: 
                }
                arrayLength = WireFormatNano.getRepeatedFieldArrayLength(input, 50);
                i = this.lowLatencyActiveSessionDurationSecHistogram == null ? 0 : this.lowLatencyActiveSessionDurationSecHistogram.length;
                newArray = new HistogramBucketInt32[i + arrayLength];
                if (i != 0) {
                    System.arraycopy(this.lowLatencyActiveSessionDurationSecHistogram, 0, newArray, 0, i);
                }
                while (i < newArray.length - 1) {
                    newArray[i] = new HistogramBucketInt32();
                    input.readMessage(newArray[i]);
                    input.readTag();
                    ++i;
                }
                newArray[i] = new HistogramBucketInt32();
                input.readMessage(newArray[i]);
                this.lowLatencyActiveSessionDurationSecHistogram = newArray;
            }
        }

        public static WifiLockStats parseFrom(byte[] data) throws InvalidProtocolBufferNanoException {
            return MessageNano.mergeFrom(new WifiLockStats(), data);
        }

        public static WifiLockStats parseFrom(CodedInputByteBufferNano input) throws IOException {
            return new WifiLockStats().mergeFrom(input);
        }
    }

    public static final class WifiNetworkSuggestionApiLog
    extends MessageNano {
        private static volatile WifiNetworkSuggestionApiLog[] _emptyArray;
        public int numModification;
        public int numConnectSuccess;
        public int numConnectFailure;
        public HistogramBucketInt32[] networkListSizeHistogram;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static WifiNetworkSuggestionApiLog[] emptyArray() {
            if (_emptyArray == null) {
                Object object = InternalNano.LAZY_INIT_LOCK;
                synchronized (object) {
                    if (_emptyArray == null) {
                        _emptyArray = new WifiNetworkSuggestionApiLog[0];
                    }
                }
            }
            return _emptyArray;
        }

        public WifiNetworkSuggestionApiLog() {
            this.clear();
        }

        public WifiNetworkSuggestionApiLog clear() {
            this.numModification = 0;
            this.numConnectSuccess = 0;
            this.numConnectFailure = 0;
            this.networkListSizeHistogram = HistogramBucketInt32.emptyArray();
            this.cachedSize = -1;
            return this;
        }

        @Override
        public void writeTo(CodedOutputByteBufferNano output) throws IOException {
            if (this.numModification != 0) {
                output.writeInt32(1, this.numModification);
            }
            if (this.numConnectSuccess != 0) {
                output.writeInt32(2, this.numConnectSuccess);
            }
            if (this.numConnectFailure != 0) {
                output.writeInt32(3, this.numConnectFailure);
            }
            if (this.networkListSizeHistogram != null && this.networkListSizeHistogram.length > 0) {
                for (int i = 0; i < this.networkListSizeHistogram.length; ++i) {
                    HistogramBucketInt32 element = this.networkListSizeHistogram[i];
                    if (element == null) continue;
                    output.writeMessage(4, element);
                }
            }
            super.writeTo(output);
        }

        @Override
        protected int computeSerializedSize() {
            int size = super.computeSerializedSize();
            if (this.numModification != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(1, this.numModification);
            }
            if (this.numConnectSuccess != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(2, this.numConnectSuccess);
            }
            if (this.numConnectFailure != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(3, this.numConnectFailure);
            }
            if (this.networkListSizeHistogram != null && this.networkListSizeHistogram.length > 0) {
                for (int i = 0; i < this.networkListSizeHistogram.length; ++i) {
                    HistogramBucketInt32 element = this.networkListSizeHistogram[i];
                    if (element == null) continue;
                    size += CodedOutputByteBufferNano.computeMessageSize(4, element);
                }
            }
            return size;
        }

        @Override
        public WifiNetworkSuggestionApiLog mergeFrom(CodedInputByteBufferNano input) throws IOException {
            block7: while (true) {
                int tag = input.readTag();
                switch (tag) {
                    case 0: {
                        return this;
                    }
                    default: {
                        if (WireFormatNano.parseUnknownField(input, tag)) continue block7;
                        return this;
                    }
                    case 8: {
                        this.numModification = input.readInt32();
                        continue block7;
                    }
                    case 16: {
                        this.numConnectSuccess = input.readInt32();
                        continue block7;
                    }
                    case 24: {
                        this.numConnectFailure = input.readInt32();
                        continue block7;
                    }
                    case 34: 
                }
                int arrayLength = WireFormatNano.getRepeatedFieldArrayLength(input, 34);
                int i = this.networkListSizeHistogram == null ? 0 : this.networkListSizeHistogram.length;
                HistogramBucketInt32[] newArray = new HistogramBucketInt32[i + arrayLength];
                if (i != 0) {
                    System.arraycopy(this.networkListSizeHistogram, 0, newArray, 0, i);
                }
                while (i < newArray.length - 1) {
                    newArray[i] = new HistogramBucketInt32();
                    input.readMessage(newArray[i]);
                    input.readTag();
                    ++i;
                }
                newArray[i] = new HistogramBucketInt32();
                input.readMessage(newArray[i]);
                this.networkListSizeHistogram = newArray;
            }
        }

        public static WifiNetworkSuggestionApiLog parseFrom(byte[] data) throws InvalidProtocolBufferNanoException {
            return MessageNano.mergeFrom(new WifiNetworkSuggestionApiLog(), data);
        }

        public static WifiNetworkSuggestionApiLog parseFrom(CodedInputByteBufferNano input) throws IOException {
            return new WifiNetworkSuggestionApiLog().mergeFrom(input);
        }
    }

    public static final class WifiNetworkRequestApiLog
    extends MessageNano {
        private static volatile WifiNetworkRequestApiLog[] _emptyArray;
        public int numRequest;
        public HistogramBucketInt32[] networkMatchSizeHistogram;
        public int numConnectSuccess;
        public int numUserApprovalBypass;
        public int numUserReject;
        public int numApps;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static WifiNetworkRequestApiLog[] emptyArray() {
            if (_emptyArray == null) {
                Object object = InternalNano.LAZY_INIT_LOCK;
                synchronized (object) {
                    if (_emptyArray == null) {
                        _emptyArray = new WifiNetworkRequestApiLog[0];
                    }
                }
            }
            return _emptyArray;
        }

        public WifiNetworkRequestApiLog() {
            this.clear();
        }

        public WifiNetworkRequestApiLog clear() {
            this.numRequest = 0;
            this.networkMatchSizeHistogram = HistogramBucketInt32.emptyArray();
            this.numConnectSuccess = 0;
            this.numUserApprovalBypass = 0;
            this.numUserReject = 0;
            this.numApps = 0;
            this.cachedSize = -1;
            return this;
        }

        @Override
        public void writeTo(CodedOutputByteBufferNano output) throws IOException {
            if (this.numRequest != 0) {
                output.writeInt32(1, this.numRequest);
            }
            if (this.networkMatchSizeHistogram != null && this.networkMatchSizeHistogram.length > 0) {
                for (int i = 0; i < this.networkMatchSizeHistogram.length; ++i) {
                    HistogramBucketInt32 element = this.networkMatchSizeHistogram[i];
                    if (element == null) continue;
                    output.writeMessage(2, element);
                }
            }
            if (this.numConnectSuccess != 0) {
                output.writeInt32(3, this.numConnectSuccess);
            }
            if (this.numUserApprovalBypass != 0) {
                output.writeInt32(4, this.numUserApprovalBypass);
            }
            if (this.numUserReject != 0) {
                output.writeInt32(5, this.numUserReject);
            }
            if (this.numApps != 0) {
                output.writeInt32(6, this.numApps);
            }
            super.writeTo(output);
        }

        @Override
        protected int computeSerializedSize() {
            int size = super.computeSerializedSize();
            if (this.numRequest != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(1, this.numRequest);
            }
            if (this.networkMatchSizeHistogram != null && this.networkMatchSizeHistogram.length > 0) {
                for (int i = 0; i < this.networkMatchSizeHistogram.length; ++i) {
                    HistogramBucketInt32 element = this.networkMatchSizeHistogram[i];
                    if (element == null) continue;
                    size += CodedOutputByteBufferNano.computeMessageSize(2, element);
                }
            }
            if (this.numConnectSuccess != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(3, this.numConnectSuccess);
            }
            if (this.numUserApprovalBypass != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(4, this.numUserApprovalBypass);
            }
            if (this.numUserReject != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(5, this.numUserReject);
            }
            if (this.numApps != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(6, this.numApps);
            }
            return size;
        }

        @Override
        public WifiNetworkRequestApiLog mergeFrom(CodedInputByteBufferNano input) throws IOException {
            block9: while (true) {
                int tag = input.readTag();
                switch (tag) {
                    case 0: {
                        return this;
                    }
                    default: {
                        if (WireFormatNano.parseUnknownField(input, tag)) continue block9;
                        return this;
                    }
                    case 8: {
                        this.numRequest = input.readInt32();
                        continue block9;
                    }
                    case 18: {
                        int arrayLength = WireFormatNano.getRepeatedFieldArrayLength(input, 18);
                        int i = this.networkMatchSizeHistogram == null ? 0 : this.networkMatchSizeHistogram.length;
                        HistogramBucketInt32[] newArray = new HistogramBucketInt32[i + arrayLength];
                        if (i != 0) {
                            System.arraycopy(this.networkMatchSizeHistogram, 0, newArray, 0, i);
                        }
                        while (i < newArray.length - 1) {
                            newArray[i] = new HistogramBucketInt32();
                            input.readMessage(newArray[i]);
                            input.readTag();
                            ++i;
                        }
                        newArray[i] = new HistogramBucketInt32();
                        input.readMessage(newArray[i]);
                        this.networkMatchSizeHistogram = newArray;
                        continue block9;
                    }
                    case 24: {
                        this.numConnectSuccess = input.readInt32();
                        continue block9;
                    }
                    case 32: {
                        this.numUserApprovalBypass = input.readInt32();
                        continue block9;
                    }
                    case 40: {
                        this.numUserReject = input.readInt32();
                        continue block9;
                    }
                    case 48: 
                }
                this.numApps = input.readInt32();
            }
        }

        public static WifiNetworkRequestApiLog parseFrom(byte[] data) throws InvalidProtocolBufferNanoException {
            return MessageNano.mergeFrom(new WifiNetworkRequestApiLog(), data);
        }

        public static WifiNetworkRequestApiLog parseFrom(CodedInputByteBufferNano input) throws IOException {
            return new WifiNetworkRequestApiLog().mergeFrom(input);
        }
    }

    public static final class NetworkSelectionExperimentDecisions
    extends MessageNano {
        private static volatile NetworkSelectionExperimentDecisions[] _emptyArray;
        public int experiment1Id;
        public int experiment2Id;
        public Int32Count[] sameSelectionNumChoicesCounter;
        public Int32Count[] differentSelectionNumChoicesCounter;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static NetworkSelectionExperimentDecisions[] emptyArray() {
            if (_emptyArray == null) {
                Object object = InternalNano.LAZY_INIT_LOCK;
                synchronized (object) {
                    if (_emptyArray == null) {
                        _emptyArray = new NetworkSelectionExperimentDecisions[0];
                    }
                }
            }
            return _emptyArray;
        }

        public NetworkSelectionExperimentDecisions() {
            this.clear();
        }

        public NetworkSelectionExperimentDecisions clear() {
            this.experiment1Id = 0;
            this.experiment2Id = 0;
            this.sameSelectionNumChoicesCounter = Int32Count.emptyArray();
            this.differentSelectionNumChoicesCounter = Int32Count.emptyArray();
            this.cachedSize = -1;
            return this;
        }

        @Override
        public void writeTo(CodedOutputByteBufferNano output) throws IOException {
            Int32Count element;
            int i;
            if (this.experiment1Id != 0) {
                output.writeInt32(1, this.experiment1Id);
            }
            if (this.experiment2Id != 0) {
                output.writeInt32(2, this.experiment2Id);
            }
            if (this.sameSelectionNumChoicesCounter != null && this.sameSelectionNumChoicesCounter.length > 0) {
                for (i = 0; i < this.sameSelectionNumChoicesCounter.length; ++i) {
                    element = this.sameSelectionNumChoicesCounter[i];
                    if (element == null) continue;
                    output.writeMessage(3, element);
                }
            }
            if (this.differentSelectionNumChoicesCounter != null && this.differentSelectionNumChoicesCounter.length > 0) {
                for (i = 0; i < this.differentSelectionNumChoicesCounter.length; ++i) {
                    element = this.differentSelectionNumChoicesCounter[i];
                    if (element == null) continue;
                    output.writeMessage(4, element);
                }
            }
            super.writeTo(output);
        }

        @Override
        protected int computeSerializedSize() {
            Int32Count element;
            int i;
            int size = super.computeSerializedSize();
            if (this.experiment1Id != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(1, this.experiment1Id);
            }
            if (this.experiment2Id != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(2, this.experiment2Id);
            }
            if (this.sameSelectionNumChoicesCounter != null && this.sameSelectionNumChoicesCounter.length > 0) {
                for (i = 0; i < this.sameSelectionNumChoicesCounter.length; ++i) {
                    element = this.sameSelectionNumChoicesCounter[i];
                    if (element == null) continue;
                    size += CodedOutputByteBufferNano.computeMessageSize(3, element);
                }
            }
            if (this.differentSelectionNumChoicesCounter != null && this.differentSelectionNumChoicesCounter.length > 0) {
                for (i = 0; i < this.differentSelectionNumChoicesCounter.length; ++i) {
                    element = this.differentSelectionNumChoicesCounter[i];
                    if (element == null) continue;
                    size += CodedOutputByteBufferNano.computeMessageSize(4, element);
                }
            }
            return size;
        }

        @Override
        public NetworkSelectionExperimentDecisions mergeFrom(CodedInputByteBufferNano input) throws IOException {
            block7: while (true) {
                Int32Count[] newArray;
                int i;
                int arrayLength;
                int tag = input.readTag();
                switch (tag) {
                    case 0: {
                        return this;
                    }
                    default: {
                        if (WireFormatNano.parseUnknownField(input, tag)) continue block7;
                        return this;
                    }
                    case 8: {
                        this.experiment1Id = input.readInt32();
                        continue block7;
                    }
                    case 16: {
                        this.experiment2Id = input.readInt32();
                        continue block7;
                    }
                    case 26: {
                        arrayLength = WireFormatNano.getRepeatedFieldArrayLength(input, 26);
                        i = this.sameSelectionNumChoicesCounter == null ? 0 : this.sameSelectionNumChoicesCounter.length;
                        newArray = new Int32Count[i + arrayLength];
                        if (i != 0) {
                            System.arraycopy(this.sameSelectionNumChoicesCounter, 0, newArray, 0, i);
                        }
                        while (i < newArray.length - 1) {
                            newArray[i] = new Int32Count();
                            input.readMessage(newArray[i]);
                            input.readTag();
                            ++i;
                        }
                        newArray[i] = new Int32Count();
                        input.readMessage(newArray[i]);
                        this.sameSelectionNumChoicesCounter = newArray;
                        continue block7;
                    }
                    case 34: 
                }
                arrayLength = WireFormatNano.getRepeatedFieldArrayLength(input, 34);
                i = this.differentSelectionNumChoicesCounter == null ? 0 : this.differentSelectionNumChoicesCounter.length;
                newArray = new Int32Count[i + arrayLength];
                if (i != 0) {
                    System.arraycopy(this.differentSelectionNumChoicesCounter, 0, newArray, 0, i);
                }
                while (i < newArray.length - 1) {
                    newArray[i] = new Int32Count();
                    input.readMessage(newArray[i]);
                    input.readTag();
                    ++i;
                }
                newArray[i] = new Int32Count();
                input.readMessage(newArray[i]);
                this.differentSelectionNumChoicesCounter = newArray;
            }
        }

        public static NetworkSelectionExperimentDecisions parseFrom(byte[] data) throws InvalidProtocolBufferNanoException {
            return MessageNano.mergeFrom(new NetworkSelectionExperimentDecisions(), data);
        }

        public static NetworkSelectionExperimentDecisions parseFrom(CodedInputByteBufferNano input) throws IOException {
            return new NetworkSelectionExperimentDecisions().mergeFrom(input);
        }
    }

    public static final class LinkProbeStats
    extends MessageNano {
        public static final int LINK_PROBE_FAILURE_REASON_UNKNOWN = 0;
        public static final int LINK_PROBE_FAILURE_REASON_MCS_UNSUPPORTED = 1;
        public static final int LINK_PROBE_FAILURE_REASON_NO_ACK = 2;
        public static final int LINK_PROBE_FAILURE_REASON_TIMEOUT = 3;
        public static final int LINK_PROBE_FAILURE_REASON_ALREADY_STARTED = 4;
        private static volatile LinkProbeStats[] _emptyArray;
        public Int32Count[] successRssiCounts;
        public Int32Count[] failureRssiCounts;
        public Int32Count[] successLinkSpeedCounts;
        public Int32Count[] failureLinkSpeedCounts;
        public HistogramBucketInt32[] successSecondsSinceLastTxSuccessHistogram;
        public HistogramBucketInt32[] failureSecondsSinceLastTxSuccessHistogram;
        public HistogramBucketInt32[] successElapsedTimeMsHistogram;
        public LinkProbeFailureReasonCount[] failureReasonCounts;
        public ExperimentProbeCounts[] experimentProbeCounts;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static LinkProbeStats[] emptyArray() {
            if (_emptyArray == null) {
                Object object = InternalNano.LAZY_INIT_LOCK;
                synchronized (object) {
                    if (_emptyArray == null) {
                        _emptyArray = new LinkProbeStats[0];
                    }
                }
            }
            return _emptyArray;
        }

        public LinkProbeStats() {
            this.clear();
        }

        public LinkProbeStats clear() {
            this.successRssiCounts = Int32Count.emptyArray();
            this.failureRssiCounts = Int32Count.emptyArray();
            this.successLinkSpeedCounts = Int32Count.emptyArray();
            this.failureLinkSpeedCounts = Int32Count.emptyArray();
            this.successSecondsSinceLastTxSuccessHistogram = HistogramBucketInt32.emptyArray();
            this.failureSecondsSinceLastTxSuccessHistogram = HistogramBucketInt32.emptyArray();
            this.successElapsedTimeMsHistogram = HistogramBucketInt32.emptyArray();
            this.failureReasonCounts = LinkProbeFailureReasonCount.emptyArray();
            this.experimentProbeCounts = ExperimentProbeCounts.emptyArray();
            this.cachedSize = -1;
            return this;
        }

        @Override
        public void writeTo(CodedOutputByteBufferNano output) throws IOException {
            MessageNano element;
            int i;
            if (this.successRssiCounts != null && this.successRssiCounts.length > 0) {
                for (i = 0; i < this.successRssiCounts.length; ++i) {
                    element = this.successRssiCounts[i];
                    if (element == null) continue;
                    output.writeMessage(1, element);
                }
            }
            if (this.failureRssiCounts != null && this.failureRssiCounts.length > 0) {
                for (i = 0; i < this.failureRssiCounts.length; ++i) {
                    element = this.failureRssiCounts[i];
                    if (element == null) continue;
                    output.writeMessage(2, element);
                }
            }
            if (this.successLinkSpeedCounts != null && this.successLinkSpeedCounts.length > 0) {
                for (i = 0; i < this.successLinkSpeedCounts.length; ++i) {
                    element = this.successLinkSpeedCounts[i];
                    if (element == null) continue;
                    output.writeMessage(3, element);
                }
            }
            if (this.failureLinkSpeedCounts != null && this.failureLinkSpeedCounts.length > 0) {
                for (i = 0; i < this.failureLinkSpeedCounts.length; ++i) {
                    element = this.failureLinkSpeedCounts[i];
                    if (element == null) continue;
                    output.writeMessage(4, element);
                }
            }
            if (this.successSecondsSinceLastTxSuccessHistogram != null && this.successSecondsSinceLastTxSuccessHistogram.length > 0) {
                for (i = 0; i < this.successSecondsSinceLastTxSuccessHistogram.length; ++i) {
                    element = this.successSecondsSinceLastTxSuccessHistogram[i];
                    if (element == null) continue;
                    output.writeMessage(5, element);
                }
            }
            if (this.failureSecondsSinceLastTxSuccessHistogram != null && this.failureSecondsSinceLastTxSuccessHistogram.length > 0) {
                for (i = 0; i < this.failureSecondsSinceLastTxSuccessHistogram.length; ++i) {
                    element = this.failureSecondsSinceLastTxSuccessHistogram[i];
                    if (element == null) continue;
                    output.writeMessage(6, element);
                }
            }
            if (this.successElapsedTimeMsHistogram != null && this.successElapsedTimeMsHistogram.length > 0) {
                for (i = 0; i < this.successElapsedTimeMsHistogram.length; ++i) {
                    element = this.successElapsedTimeMsHistogram[i];
                    if (element == null) continue;
                    output.writeMessage(7, element);
                }
            }
            if (this.failureReasonCounts != null && this.failureReasonCounts.length > 0) {
                for (i = 0; i < this.failureReasonCounts.length; ++i) {
                    element = this.failureReasonCounts[i];
                    if (element == null) continue;
                    output.writeMessage(8, element);
                }
            }
            if (this.experimentProbeCounts != null && this.experimentProbeCounts.length > 0) {
                for (i = 0; i < this.experimentProbeCounts.length; ++i) {
                    element = this.experimentProbeCounts[i];
                    if (element == null) continue;
                    output.writeMessage(9, element);
                }
            }
            super.writeTo(output);
        }

        @Override
        protected int computeSerializedSize() {
            MessageNano element;
            int i;
            int size = super.computeSerializedSize();
            if (this.successRssiCounts != null && this.successRssiCounts.length > 0) {
                for (i = 0; i < this.successRssiCounts.length; ++i) {
                    element = this.successRssiCounts[i];
                    if (element == null) continue;
                    size += CodedOutputByteBufferNano.computeMessageSize(1, element);
                }
            }
            if (this.failureRssiCounts != null && this.failureRssiCounts.length > 0) {
                for (i = 0; i < this.failureRssiCounts.length; ++i) {
                    element = this.failureRssiCounts[i];
                    if (element == null) continue;
                    size += CodedOutputByteBufferNano.computeMessageSize(2, element);
                }
            }
            if (this.successLinkSpeedCounts != null && this.successLinkSpeedCounts.length > 0) {
                for (i = 0; i < this.successLinkSpeedCounts.length; ++i) {
                    element = this.successLinkSpeedCounts[i];
                    if (element == null) continue;
                    size += CodedOutputByteBufferNano.computeMessageSize(3, element);
                }
            }
            if (this.failureLinkSpeedCounts != null && this.failureLinkSpeedCounts.length > 0) {
                for (i = 0; i < this.failureLinkSpeedCounts.length; ++i) {
                    element = this.failureLinkSpeedCounts[i];
                    if (element == null) continue;
                    size += CodedOutputByteBufferNano.computeMessageSize(4, element);
                }
            }
            if (this.successSecondsSinceLastTxSuccessHistogram != null && this.successSecondsSinceLastTxSuccessHistogram.length > 0) {
                for (i = 0; i < this.successSecondsSinceLastTxSuccessHistogram.length; ++i) {
                    element = this.successSecondsSinceLastTxSuccessHistogram[i];
                    if (element == null) continue;
                    size += CodedOutputByteBufferNano.computeMessageSize(5, element);
                }
            }
            if (this.failureSecondsSinceLastTxSuccessHistogram != null && this.failureSecondsSinceLastTxSuccessHistogram.length > 0) {
                for (i = 0; i < this.failureSecondsSinceLastTxSuccessHistogram.length; ++i) {
                    element = this.failureSecondsSinceLastTxSuccessHistogram[i];
                    if (element == null) continue;
                    size += CodedOutputByteBufferNano.computeMessageSize(6, element);
                }
            }
            if (this.successElapsedTimeMsHistogram != null && this.successElapsedTimeMsHistogram.length > 0) {
                for (i = 0; i < this.successElapsedTimeMsHistogram.length; ++i) {
                    element = this.successElapsedTimeMsHistogram[i];
                    if (element == null) continue;
                    size += CodedOutputByteBufferNano.computeMessageSize(7, element);
                }
            }
            if (this.failureReasonCounts != null && this.failureReasonCounts.length > 0) {
                for (i = 0; i < this.failureReasonCounts.length; ++i) {
                    element = this.failureReasonCounts[i];
                    if (element == null) continue;
                    size += CodedOutputByteBufferNano.computeMessageSize(8, element);
                }
            }
            if (this.experimentProbeCounts != null && this.experimentProbeCounts.length > 0) {
                for (i = 0; i < this.experimentProbeCounts.length; ++i) {
                    element = this.experimentProbeCounts[i];
                    if (element == null) continue;
                    size += CodedOutputByteBufferNano.computeMessageSize(9, element);
                }
            }
            return size;
        }

        @Override
        public LinkProbeStats mergeFrom(CodedInputByteBufferNano input) throws IOException {
            block12: while (true) {
                MessageNano[] newArray;
                int i;
                int arrayLength;
                int tag = input.readTag();
                switch (tag) {
                    case 0: {
                        return this;
                    }
                    default: {
                        if (WireFormatNano.parseUnknownField(input, tag)) continue block12;
                        return this;
                    }
                    case 10: {
                        arrayLength = WireFormatNano.getRepeatedFieldArrayLength(input, 10);
                        i = this.successRssiCounts == null ? 0 : this.successRssiCounts.length;
                        newArray = new Int32Count[i + arrayLength];
                        if (i != 0) {
                            System.arraycopy(this.successRssiCounts, 0, newArray, 0, i);
                        }
                        while (i < newArray.length - 1) {
                            newArray[i] = new Int32Count();
                            input.readMessage(newArray[i]);
                            input.readTag();
                            ++i;
                        }
                        newArray[i] = new Int32Count();
                        input.readMessage(newArray[i]);
                        this.successRssiCounts = newArray;
                        continue block12;
                    }
                    case 18: {
                        arrayLength = WireFormatNano.getRepeatedFieldArrayLength(input, 18);
                        i = this.failureRssiCounts == null ? 0 : this.failureRssiCounts.length;
                        newArray = new Int32Count[i + arrayLength];
                        if (i != 0) {
                            System.arraycopy(this.failureRssiCounts, 0, newArray, 0, i);
                        }
                        while (i < newArray.length - 1) {
                            newArray[i] = new Int32Count();
                            input.readMessage(newArray[i]);
                            input.readTag();
                            ++i;
                        }
                        newArray[i] = new Int32Count();
                        input.readMessage(newArray[i]);
                        this.failureRssiCounts = newArray;
                        continue block12;
                    }
                    case 26: {
                        arrayLength = WireFormatNano.getRepeatedFieldArrayLength(input, 26);
                        i = this.successLinkSpeedCounts == null ? 0 : this.successLinkSpeedCounts.length;
                        newArray = new Int32Count[i + arrayLength];
                        if (i != 0) {
                            System.arraycopy(this.successLinkSpeedCounts, 0, newArray, 0, i);
                        }
                        while (i < newArray.length - 1) {
                            newArray[i] = new Int32Count();
                            input.readMessage(newArray[i]);
                            input.readTag();
                            ++i;
                        }
                        newArray[i] = new Int32Count();
                        input.readMessage(newArray[i]);
                        this.successLinkSpeedCounts = newArray;
                        continue block12;
                    }
                    case 34: {
                        arrayLength = WireFormatNano.getRepeatedFieldArrayLength(input, 34);
                        i = this.failureLinkSpeedCounts == null ? 0 : this.failureLinkSpeedCounts.length;
                        newArray = new Int32Count[i + arrayLength];
                        if (i != 0) {
                            System.arraycopy(this.failureLinkSpeedCounts, 0, newArray, 0, i);
                        }
                        while (i < newArray.length - 1) {
                            newArray[i] = new Int32Count();
                            input.readMessage(newArray[i]);
                            input.readTag();
                            ++i;
                        }
                        newArray[i] = new Int32Count();
                        input.readMessage(newArray[i]);
                        this.failureLinkSpeedCounts = newArray;
                        continue block12;
                    }
                    case 42: {
                        arrayLength = WireFormatNano.getRepeatedFieldArrayLength(input, 42);
                        i = this.successSecondsSinceLastTxSuccessHistogram == null ? 0 : this.successSecondsSinceLastTxSuccessHistogram.length;
                        newArray = new HistogramBucketInt32[i + arrayLength];
                        if (i != 0) {
                            System.arraycopy(this.successSecondsSinceLastTxSuccessHistogram, 0, newArray, 0, i);
                        }
                        while (i < newArray.length - 1) {
                            newArray[i] = new HistogramBucketInt32();
                            input.readMessage(newArray[i]);
                            input.readTag();
                            ++i;
                        }
                        newArray[i] = new HistogramBucketInt32();
                        input.readMessage(newArray[i]);
                        this.successSecondsSinceLastTxSuccessHistogram = newArray;
                        continue block12;
                    }
                    case 50: {
                        arrayLength = WireFormatNano.getRepeatedFieldArrayLength(input, 50);
                        i = this.failureSecondsSinceLastTxSuccessHistogram == null ? 0 : this.failureSecondsSinceLastTxSuccessHistogram.length;
                        newArray = new HistogramBucketInt32[i + arrayLength];
                        if (i != 0) {
                            System.arraycopy(this.failureSecondsSinceLastTxSuccessHistogram, 0, newArray, 0, i);
                        }
                        while (i < newArray.length - 1) {
                            newArray[i] = new HistogramBucketInt32();
                            input.readMessage(newArray[i]);
                            input.readTag();
                            ++i;
                        }
                        newArray[i] = new HistogramBucketInt32();
                        input.readMessage(newArray[i]);
                        this.failureSecondsSinceLastTxSuccessHistogram = newArray;
                        continue block12;
                    }
                    case 58: {
                        arrayLength = WireFormatNano.getRepeatedFieldArrayLength(input, 58);
                        i = this.successElapsedTimeMsHistogram == null ? 0 : this.successElapsedTimeMsHistogram.length;
                        newArray = new HistogramBucketInt32[i + arrayLength];
                        if (i != 0) {
                            System.arraycopy(this.successElapsedTimeMsHistogram, 0, newArray, 0, i);
                        }
                        while (i < newArray.length - 1) {
                            newArray[i] = new HistogramBucketInt32();
                            input.readMessage(newArray[i]);
                            input.readTag();
                            ++i;
                        }
                        newArray[i] = new HistogramBucketInt32();
                        input.readMessage(newArray[i]);
                        this.successElapsedTimeMsHistogram = newArray;
                        continue block12;
                    }
                    case 66: {
                        arrayLength = WireFormatNano.getRepeatedFieldArrayLength(input, 66);
                        i = this.failureReasonCounts == null ? 0 : this.failureReasonCounts.length;
                        newArray = new LinkProbeFailureReasonCount[i + arrayLength];
                        if (i != 0) {
                            System.arraycopy(this.failureReasonCounts, 0, newArray, 0, i);
                        }
                        while (i < newArray.length - 1) {
                            newArray[i] = new LinkProbeFailureReasonCount();
                            input.readMessage(newArray[i]);
                            input.readTag();
                            ++i;
                        }
                        newArray[i] = new LinkProbeFailureReasonCount();
                        input.readMessage(newArray[i]);
                        this.failureReasonCounts = newArray;
                        continue block12;
                    }
                    case 74: 
                }
                arrayLength = WireFormatNano.getRepeatedFieldArrayLength(input, 74);
                i = this.experimentProbeCounts == null ? 0 : this.experimentProbeCounts.length;
                newArray = new ExperimentProbeCounts[i + arrayLength];
                if (i != 0) {
                    System.arraycopy(this.experimentProbeCounts, 0, newArray, 0, i);
                }
                while (i < newArray.length - 1) {
                    newArray[i] = new ExperimentProbeCounts();
                    input.readMessage(newArray[i]);
                    input.readTag();
                    ++i;
                }
                newArray[i] = new ExperimentProbeCounts();
                input.readMessage(newArray[i]);
                this.experimentProbeCounts = newArray;
            }
        }

        public static LinkProbeStats parseFrom(byte[] data) throws InvalidProtocolBufferNanoException {
            return MessageNano.mergeFrom(new LinkProbeStats(), data);
        }

        public static LinkProbeStats parseFrom(CodedInputByteBufferNano input) throws IOException {
            return new LinkProbeStats().mergeFrom(input);
        }

        public static final class ExperimentProbeCounts
        extends MessageNano {
            private static volatile ExperimentProbeCounts[] _emptyArray;
            public String experimentId;
            public int probeCount;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public static ExperimentProbeCounts[] emptyArray() {
                if (_emptyArray == null) {
                    Object object = InternalNano.LAZY_INIT_LOCK;
                    synchronized (object) {
                        if (_emptyArray == null) {
                            _emptyArray = new ExperimentProbeCounts[0];
                        }
                    }
                }
                return _emptyArray;
            }

            public ExperimentProbeCounts() {
                this.clear();
            }

            public ExperimentProbeCounts clear() {
                this.experimentId = "";
                this.probeCount = 0;
                this.cachedSize = -1;
                return this;
            }

            @Override
            public void writeTo(CodedOutputByteBufferNano output) throws IOException {
                if (!this.experimentId.equals("")) {
                    output.writeString(1, this.experimentId);
                }
                if (this.probeCount != 0) {
                    output.writeInt32(2, this.probeCount);
                }
                super.writeTo(output);
            }

            @Override
            protected int computeSerializedSize() {
                int size = super.computeSerializedSize();
                if (!this.experimentId.equals("")) {
                    size += CodedOutputByteBufferNano.computeStringSize(1, this.experimentId);
                }
                if (this.probeCount != 0) {
                    size += CodedOutputByteBufferNano.computeInt32Size(2, this.probeCount);
                }
                return size;
            }

            @Override
            public ExperimentProbeCounts mergeFrom(CodedInputByteBufferNano input) throws IOException {
                block5: while (true) {
                    int tag = input.readTag();
                    switch (tag) {
                        case 0: {
                            return this;
                        }
                        default: {
                            if (WireFormatNano.parseUnknownField(input, tag)) continue block5;
                            return this;
                        }
                        case 10: {
                            this.experimentId = input.readString();
                            continue block5;
                        }
                        case 16: 
                    }
                    this.probeCount = input.readInt32();
                }
            }

            public static ExperimentProbeCounts parseFrom(byte[] data) throws InvalidProtocolBufferNanoException {
                return MessageNano.mergeFrom(new ExperimentProbeCounts(), data);
            }

            public static ExperimentProbeCounts parseFrom(CodedInputByteBufferNano input) throws IOException {
                return new ExperimentProbeCounts().mergeFrom(input);
            }
        }

        public static final class LinkProbeFailureReasonCount
        extends MessageNano {
            private static volatile LinkProbeFailureReasonCount[] _emptyArray;
            public int failureReason;
            public int count;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public static LinkProbeFailureReasonCount[] emptyArray() {
                if (_emptyArray == null) {
                    Object object = InternalNano.LAZY_INIT_LOCK;
                    synchronized (object) {
                        if (_emptyArray == null) {
                            _emptyArray = new LinkProbeFailureReasonCount[0];
                        }
                    }
                }
                return _emptyArray;
            }

            public LinkProbeFailureReasonCount() {
                this.clear();
            }

            public LinkProbeFailureReasonCount clear() {
                this.failureReason = 0;
                this.count = 0;
                this.cachedSize = -1;
                return this;
            }

            @Override
            public void writeTo(CodedOutputByteBufferNano output) throws IOException {
                if (this.failureReason != 0) {
                    output.writeInt32(1, this.failureReason);
                }
                if (this.count != 0) {
                    output.writeInt32(2, this.count);
                }
                super.writeTo(output);
            }

            @Override
            protected int computeSerializedSize() {
                int size = super.computeSerializedSize();
                if (this.failureReason != 0) {
                    size += CodedOutputByteBufferNano.computeInt32Size(1, this.failureReason);
                }
                if (this.count != 0) {
                    size += CodedOutputByteBufferNano.computeInt32Size(2, this.count);
                }
                return size;
            }

            @Override
            public LinkProbeFailureReasonCount mergeFrom(CodedInputByteBufferNano input) throws IOException {
                block8: while (true) {
                    int tag = input.readTag();
                    switch (tag) {
                        case 0: {
                            return this;
                        }
                        default: {
                            if (WireFormatNano.parseUnknownField(input, tag)) continue block8;
                            return this;
                        }
                        case 8: {
                            int value = input.readInt32();
                            switch (value) {
                                case 0: 
                                case 1: 
                                case 2: 
                                case 3: 
                                case 4: {
                                    this.failureReason = value;
                                }
                            }
                            continue block8;
                        }
                        case 16: 
                    }
                    this.count = input.readInt32();
                }
            }

            public static LinkProbeFailureReasonCount parseFrom(byte[] data) throws InvalidProtocolBufferNanoException {
                return MessageNano.mergeFrom(new LinkProbeFailureReasonCount(), data);
            }

            public static LinkProbeFailureReasonCount parseFrom(CodedInputByteBufferNano input) throws IOException {
                return new LinkProbeFailureReasonCount().mergeFrom(input);
            }
        }
    }

    public static final class Int32Count
    extends MessageNano {
        private static volatile Int32Count[] _emptyArray;
        public int key;
        public int count;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static Int32Count[] emptyArray() {
            if (_emptyArray == null) {
                Object object = InternalNano.LAZY_INIT_LOCK;
                synchronized (object) {
                    if (_emptyArray == null) {
                        _emptyArray = new Int32Count[0];
                    }
                }
            }
            return _emptyArray;
        }

        public Int32Count() {
            this.clear();
        }

        public Int32Count clear() {
            this.key = 0;
            this.count = 0;
            this.cachedSize = -1;
            return this;
        }

        @Override
        public void writeTo(CodedOutputByteBufferNano output) throws IOException {
            if (this.key != 0) {
                output.writeInt32(1, this.key);
            }
            if (this.count != 0) {
                output.writeInt32(2, this.count);
            }
            super.writeTo(output);
        }

        @Override
        protected int computeSerializedSize() {
            int size = super.computeSerializedSize();
            if (this.key != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(1, this.key);
            }
            if (this.count != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(2, this.count);
            }
            return size;
        }

        @Override
        public Int32Count mergeFrom(CodedInputByteBufferNano input) throws IOException {
            block5: while (true) {
                int tag = input.readTag();
                switch (tag) {
                    case 0: {
                        return this;
                    }
                    default: {
                        if (WireFormatNano.parseUnknownField(input, tag)) continue block5;
                        return this;
                    }
                    case 8: {
                        this.key = input.readInt32();
                        continue block5;
                    }
                    case 16: 
                }
                this.count = input.readInt32();
            }
        }

        public static Int32Count parseFrom(byte[] data) throws InvalidProtocolBufferNanoException {
            return MessageNano.mergeFrom(new Int32Count(), data);
        }

        public static Int32Count parseFrom(CodedInputByteBufferNano input) throws IOException {
            return new Int32Count().mergeFrom(input);
        }
    }

    public static final class HistogramBucketInt32
    extends MessageNano {
        private static volatile HistogramBucketInt32[] _emptyArray;
        public int start;
        public int end;
        public int count;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static HistogramBucketInt32[] emptyArray() {
            if (_emptyArray == null) {
                Object object = InternalNano.LAZY_INIT_LOCK;
                synchronized (object) {
                    if (_emptyArray == null) {
                        _emptyArray = new HistogramBucketInt32[0];
                    }
                }
            }
            return _emptyArray;
        }

        public HistogramBucketInt32() {
            this.clear();
        }

        public HistogramBucketInt32 clear() {
            this.start = 0;
            this.end = 0;
            this.count = 0;
            this.cachedSize = -1;
            return this;
        }

        @Override
        public void writeTo(CodedOutputByteBufferNano output) throws IOException {
            if (this.start != 0) {
                output.writeInt32(1, this.start);
            }
            if (this.end != 0) {
                output.writeInt32(2, this.end);
            }
            if (this.count != 0) {
                output.writeInt32(3, this.count);
            }
            super.writeTo(output);
        }

        @Override
        protected int computeSerializedSize() {
            int size = super.computeSerializedSize();
            if (this.start != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(1, this.start);
            }
            if (this.end != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(2, this.end);
            }
            if (this.count != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(3, this.count);
            }
            return size;
        }

        @Override
        public HistogramBucketInt32 mergeFrom(CodedInputByteBufferNano input) throws IOException {
            block6: while (true) {
                int tag = input.readTag();
                switch (tag) {
                    case 0: {
                        return this;
                    }
                    default: {
                        if (WireFormatNano.parseUnknownField(input, tag)) continue block6;
                        return this;
                    }
                    case 8: {
                        this.start = input.readInt32();
                        continue block6;
                    }
                    case 16: {
                        this.end = input.readInt32();
                        continue block6;
                    }
                    case 24: 
                }
                this.count = input.readInt32();
            }
        }

        public static HistogramBucketInt32 parseFrom(byte[] data) throws InvalidProtocolBufferNanoException {
            return MessageNano.mergeFrom(new HistogramBucketInt32(), data);
        }

        public static HistogramBucketInt32 parseFrom(CodedInputByteBufferNano input) throws IOException {
            return new HistogramBucketInt32().mergeFrom(input);
        }
    }

    public static final class WifiConfigStoreIO
    extends MessageNano {
        private static volatile WifiConfigStoreIO[] _emptyArray;
        public DurationBucket[] readDurations;
        public DurationBucket[] writeDurations;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static WifiConfigStoreIO[] emptyArray() {
            if (_emptyArray == null) {
                Object object = InternalNano.LAZY_INIT_LOCK;
                synchronized (object) {
                    if (_emptyArray == null) {
                        _emptyArray = new WifiConfigStoreIO[0];
                    }
                }
            }
            return _emptyArray;
        }

        public WifiConfigStoreIO() {
            this.clear();
        }

        public WifiConfigStoreIO clear() {
            this.readDurations = DurationBucket.emptyArray();
            this.writeDurations = DurationBucket.emptyArray();
            this.cachedSize = -1;
            return this;
        }

        @Override
        public void writeTo(CodedOutputByteBufferNano output) throws IOException {
            DurationBucket element;
            int i;
            if (this.readDurations != null && this.readDurations.length > 0) {
                for (i = 0; i < this.readDurations.length; ++i) {
                    element = this.readDurations[i];
                    if (element == null) continue;
                    output.writeMessage(1, element);
                }
            }
            if (this.writeDurations != null && this.writeDurations.length > 0) {
                for (i = 0; i < this.writeDurations.length; ++i) {
                    element = this.writeDurations[i];
                    if (element == null) continue;
                    output.writeMessage(2, element);
                }
            }
            super.writeTo(output);
        }

        @Override
        protected int computeSerializedSize() {
            DurationBucket element;
            int i;
            int size = super.computeSerializedSize();
            if (this.readDurations != null && this.readDurations.length > 0) {
                for (i = 0; i < this.readDurations.length; ++i) {
                    element = this.readDurations[i];
                    if (element == null) continue;
                    size += CodedOutputByteBufferNano.computeMessageSize(1, element);
                }
            }
            if (this.writeDurations != null && this.writeDurations.length > 0) {
                for (i = 0; i < this.writeDurations.length; ++i) {
                    element = this.writeDurations[i];
                    if (element == null) continue;
                    size += CodedOutputByteBufferNano.computeMessageSize(2, element);
                }
            }
            return size;
        }

        @Override
        public WifiConfigStoreIO mergeFrom(CodedInputByteBufferNano input) throws IOException {
            block5: while (true) {
                DurationBucket[] newArray;
                int i;
                int arrayLength;
                int tag = input.readTag();
                switch (tag) {
                    case 0: {
                        return this;
                    }
                    default: {
                        if (WireFormatNano.parseUnknownField(input, tag)) continue block5;
                        return this;
                    }
                    case 10: {
                        arrayLength = WireFormatNano.getRepeatedFieldArrayLength(input, 10);
                        i = this.readDurations == null ? 0 : this.readDurations.length;
                        newArray = new DurationBucket[i + arrayLength];
                        if (i != 0) {
                            System.arraycopy(this.readDurations, 0, newArray, 0, i);
                        }
                        while (i < newArray.length - 1) {
                            newArray[i] = new DurationBucket();
                            input.readMessage(newArray[i]);
                            input.readTag();
                            ++i;
                        }
                        newArray[i] = new DurationBucket();
                        input.readMessage(newArray[i]);
                        this.readDurations = newArray;
                        continue block5;
                    }
                    case 18: 
                }
                arrayLength = WireFormatNano.getRepeatedFieldArrayLength(input, 18);
                i = this.writeDurations == null ? 0 : this.writeDurations.length;
                newArray = new DurationBucket[i + arrayLength];
                if (i != 0) {
                    System.arraycopy(this.writeDurations, 0, newArray, 0, i);
                }
                while (i < newArray.length - 1) {
                    newArray[i] = new DurationBucket();
                    input.readMessage(newArray[i]);
                    input.readTag();
                    ++i;
                }
                newArray[i] = new DurationBucket();
                input.readMessage(newArray[i]);
                this.writeDurations = newArray;
            }
        }

        public static WifiConfigStoreIO parseFrom(byte[] data) throws InvalidProtocolBufferNanoException {
            return MessageNano.mergeFrom(new WifiConfigStoreIO(), data);
        }

        public static WifiConfigStoreIO parseFrom(CodedInputByteBufferNano input) throws IOException {
            return new WifiConfigStoreIO().mergeFrom(input);
        }

        public static final class DurationBucket
        extends MessageNano {
            private static volatile DurationBucket[] _emptyArray;
            public int rangeStartMs;
            public int rangeEndMs;
            public int count;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public static DurationBucket[] emptyArray() {
                if (_emptyArray == null) {
                    Object object = InternalNano.LAZY_INIT_LOCK;
                    synchronized (object) {
                        if (_emptyArray == null) {
                            _emptyArray = new DurationBucket[0];
                        }
                    }
                }
                return _emptyArray;
            }

            public DurationBucket() {
                this.clear();
            }

            public DurationBucket clear() {
                this.rangeStartMs = 0;
                this.rangeEndMs = 0;
                this.count = 0;
                this.cachedSize = -1;
                return this;
            }

            @Override
            public void writeTo(CodedOutputByteBufferNano output) throws IOException {
                if (this.rangeStartMs != 0) {
                    output.writeInt32(1, this.rangeStartMs);
                }
                if (this.rangeEndMs != 0) {
                    output.writeInt32(2, this.rangeEndMs);
                }
                if (this.count != 0) {
                    output.writeInt32(3, this.count);
                }
                super.writeTo(output);
            }

            @Override
            protected int computeSerializedSize() {
                int size = super.computeSerializedSize();
                if (this.rangeStartMs != 0) {
                    size += CodedOutputByteBufferNano.computeInt32Size(1, this.rangeStartMs);
                }
                if (this.rangeEndMs != 0) {
                    size += CodedOutputByteBufferNano.computeInt32Size(2, this.rangeEndMs);
                }
                if (this.count != 0) {
                    size += CodedOutputByteBufferNano.computeInt32Size(3, this.count);
                }
                return size;
            }

            @Override
            public DurationBucket mergeFrom(CodedInputByteBufferNano input) throws IOException {
                block6: while (true) {
                    int tag = input.readTag();
                    switch (tag) {
                        case 0: {
                            return this;
                        }
                        default: {
                            if (WireFormatNano.parseUnknownField(input, tag)) continue block6;
                            return this;
                        }
                        case 8: {
                            this.rangeStartMs = input.readInt32();
                            continue block6;
                        }
                        case 16: {
                            this.rangeEndMs = input.readInt32();
                            continue block6;
                        }
                        case 24: 
                    }
                    this.count = input.readInt32();
                }
            }

            public static DurationBucket parseFrom(byte[] data) throws InvalidProtocolBufferNanoException {
                return MessageNano.mergeFrom(new DurationBucket(), data);
            }

            public static DurationBucket parseFrom(CodedInputByteBufferNano input) throws IOException {
                return new DurationBucket().mergeFrom(input);
            }
        }
    }

    public static final class WifiDppLog
    extends MessageNano {
        public static final int EASY_CONNECT_EVENT_SUCCESS_UNKNOWN = 0;
        public static final int EASY_CONNECT_EVENT_SUCCESS_CONFIGURATION_SENT = 1;
        public static final int EASY_CONNECT_EVENT_FAILURE_UNKNOWN = 0;
        public static final int EASY_CONNECT_EVENT_FAILURE_INVALID_URI = 1;
        public static final int EASY_CONNECT_EVENT_FAILURE_AUTHENTICATION = 2;
        public static final int EASY_CONNECT_EVENT_FAILURE_NOT_COMPATIBLE = 3;
        public static final int EASY_CONNECT_EVENT_FAILURE_CONFIGURATION = 4;
        public static final int EASY_CONNECT_EVENT_FAILURE_BUSY = 5;
        public static final int EASY_CONNECT_EVENT_FAILURE_TIMEOUT = 6;
        public static final int EASY_CONNECT_EVENT_FAILURE_GENERIC = 7;
        public static final int EASY_CONNECT_EVENT_FAILURE_NOT_SUPPORTED = 8;
        public static final int EASY_CONNECT_EVENT_FAILURE_INVALID_NETWORK = 9;
        private static volatile WifiDppLog[] _emptyArray;
        public int numDppConfiguratorInitiatorRequests;
        public int numDppEnrolleeInitiatorRequests;
        public int numDppEnrolleeSuccess;
        public DppConfiguratorSuccessStatusHistogramBucket[] dppConfiguratorSuccessCode;
        public DppFailureStatusHistogramBucket[] dppFailureCode;
        public HistogramBucketInt32[] dppOperationTime;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static WifiDppLog[] emptyArray() {
            if (_emptyArray == null) {
                Object object = InternalNano.LAZY_INIT_LOCK;
                synchronized (object) {
                    if (_emptyArray == null) {
                        _emptyArray = new WifiDppLog[0];
                    }
                }
            }
            return _emptyArray;
        }

        public WifiDppLog() {
            this.clear();
        }

        public WifiDppLog clear() {
            this.numDppConfiguratorInitiatorRequests = 0;
            this.numDppEnrolleeInitiatorRequests = 0;
            this.numDppEnrolleeSuccess = 0;
            this.dppConfiguratorSuccessCode = DppConfiguratorSuccessStatusHistogramBucket.emptyArray();
            this.dppFailureCode = DppFailureStatusHistogramBucket.emptyArray();
            this.dppOperationTime = HistogramBucketInt32.emptyArray();
            this.cachedSize = -1;
            return this;
        }

        @Override
        public void writeTo(CodedOutputByteBufferNano output) throws IOException {
            MessageNano element;
            int i;
            if (this.numDppConfiguratorInitiatorRequests != 0) {
                output.writeInt32(1, this.numDppConfiguratorInitiatorRequests);
            }
            if (this.numDppEnrolleeInitiatorRequests != 0) {
                output.writeInt32(2, this.numDppEnrolleeInitiatorRequests);
            }
            if (this.numDppEnrolleeSuccess != 0) {
                output.writeInt32(3, this.numDppEnrolleeSuccess);
            }
            if (this.dppConfiguratorSuccessCode != null && this.dppConfiguratorSuccessCode.length > 0) {
                for (i = 0; i < this.dppConfiguratorSuccessCode.length; ++i) {
                    element = this.dppConfiguratorSuccessCode[i];
                    if (element == null) continue;
                    output.writeMessage(4, element);
                }
            }
            if (this.dppFailureCode != null && this.dppFailureCode.length > 0) {
                for (i = 0; i < this.dppFailureCode.length; ++i) {
                    element = this.dppFailureCode[i];
                    if (element == null) continue;
                    output.writeMessage(5, element);
                }
            }
            if (this.dppOperationTime != null && this.dppOperationTime.length > 0) {
                for (i = 0; i < this.dppOperationTime.length; ++i) {
                    element = this.dppOperationTime[i];
                    if (element == null) continue;
                    output.writeMessage(7, element);
                }
            }
            super.writeTo(output);
        }

        @Override
        protected int computeSerializedSize() {
            MessageNano element;
            int i;
            int size = super.computeSerializedSize();
            if (this.numDppConfiguratorInitiatorRequests != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(1, this.numDppConfiguratorInitiatorRequests);
            }
            if (this.numDppEnrolleeInitiatorRequests != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(2, this.numDppEnrolleeInitiatorRequests);
            }
            if (this.numDppEnrolleeSuccess != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(3, this.numDppEnrolleeSuccess);
            }
            if (this.dppConfiguratorSuccessCode != null && this.dppConfiguratorSuccessCode.length > 0) {
                for (i = 0; i < this.dppConfiguratorSuccessCode.length; ++i) {
                    element = this.dppConfiguratorSuccessCode[i];
                    if (element == null) continue;
                    size += CodedOutputByteBufferNano.computeMessageSize(4, element);
                }
            }
            if (this.dppFailureCode != null && this.dppFailureCode.length > 0) {
                for (i = 0; i < this.dppFailureCode.length; ++i) {
                    element = this.dppFailureCode[i];
                    if (element == null) continue;
                    size += CodedOutputByteBufferNano.computeMessageSize(5, element);
                }
            }
            if (this.dppOperationTime != null && this.dppOperationTime.length > 0) {
                for (i = 0; i < this.dppOperationTime.length; ++i) {
                    element = this.dppOperationTime[i];
                    if (element == null) continue;
                    size += CodedOutputByteBufferNano.computeMessageSize(7, element);
                }
            }
            return size;
        }

        @Override
        public WifiDppLog mergeFrom(CodedInputByteBufferNano input) throws IOException {
            block9: while (true) {
                MessageNano[] newArray;
                int i;
                int arrayLength;
                int tag = input.readTag();
                switch (tag) {
                    case 0: {
                        return this;
                    }
                    default: {
                        if (WireFormatNano.parseUnknownField(input, tag)) continue block9;
                        return this;
                    }
                    case 8: {
                        this.numDppConfiguratorInitiatorRequests = input.readInt32();
                        continue block9;
                    }
                    case 16: {
                        this.numDppEnrolleeInitiatorRequests = input.readInt32();
                        continue block9;
                    }
                    case 24: {
                        this.numDppEnrolleeSuccess = input.readInt32();
                        continue block9;
                    }
                    case 34: {
                        arrayLength = WireFormatNano.getRepeatedFieldArrayLength(input, 34);
                        i = this.dppConfiguratorSuccessCode == null ? 0 : this.dppConfiguratorSuccessCode.length;
                        newArray = new DppConfiguratorSuccessStatusHistogramBucket[i + arrayLength];
                        if (i != 0) {
                            System.arraycopy(this.dppConfiguratorSuccessCode, 0, newArray, 0, i);
                        }
                        while (i < newArray.length - 1) {
                            newArray[i] = new DppConfiguratorSuccessStatusHistogramBucket();
                            input.readMessage(newArray[i]);
                            input.readTag();
                            ++i;
                        }
                        newArray[i] = new DppConfiguratorSuccessStatusHistogramBucket();
                        input.readMessage(newArray[i]);
                        this.dppConfiguratorSuccessCode = newArray;
                        continue block9;
                    }
                    case 42: {
                        arrayLength = WireFormatNano.getRepeatedFieldArrayLength(input, 42);
                        i = this.dppFailureCode == null ? 0 : this.dppFailureCode.length;
                        newArray = new DppFailureStatusHistogramBucket[i + arrayLength];
                        if (i != 0) {
                            System.arraycopy(this.dppFailureCode, 0, newArray, 0, i);
                        }
                        while (i < newArray.length - 1) {
                            newArray[i] = new DppFailureStatusHistogramBucket();
                            input.readMessage(newArray[i]);
                            input.readTag();
                            ++i;
                        }
                        newArray[i] = new DppFailureStatusHistogramBucket();
                        input.readMessage(newArray[i]);
                        this.dppFailureCode = newArray;
                        continue block9;
                    }
                    case 58: 
                }
                arrayLength = WireFormatNano.getRepeatedFieldArrayLength(input, 58);
                i = this.dppOperationTime == null ? 0 : this.dppOperationTime.length;
                newArray = new HistogramBucketInt32[i + arrayLength];
                if (i != 0) {
                    System.arraycopy(this.dppOperationTime, 0, newArray, 0, i);
                }
                while (i < newArray.length - 1) {
                    newArray[i] = new HistogramBucketInt32();
                    input.readMessage(newArray[i]);
                    input.readTag();
                    ++i;
                }
                newArray[i] = new HistogramBucketInt32();
                input.readMessage(newArray[i]);
                this.dppOperationTime = newArray;
            }
        }

        public static WifiDppLog parseFrom(byte[] data) throws InvalidProtocolBufferNanoException {
            return MessageNano.mergeFrom(new WifiDppLog(), data);
        }

        public static WifiDppLog parseFrom(CodedInputByteBufferNano input) throws IOException {
            return new WifiDppLog().mergeFrom(input);
        }

        public static final class DppFailureStatusHistogramBucket
        extends MessageNano {
            private static volatile DppFailureStatusHistogramBucket[] _emptyArray;
            public int dppStatusType;
            public int count;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public static DppFailureStatusHistogramBucket[] emptyArray() {
                if (_emptyArray == null) {
                    Object object = InternalNano.LAZY_INIT_LOCK;
                    synchronized (object) {
                        if (_emptyArray == null) {
                            _emptyArray = new DppFailureStatusHistogramBucket[0];
                        }
                    }
                }
                return _emptyArray;
            }

            public DppFailureStatusHistogramBucket() {
                this.clear();
            }

            public DppFailureStatusHistogramBucket clear() {
                this.dppStatusType = 0;
                this.count = 0;
                this.cachedSize = -1;
                return this;
            }

            @Override
            public void writeTo(CodedOutputByteBufferNano output) throws IOException {
                if (this.dppStatusType != 0) {
                    output.writeInt32(1, this.dppStatusType);
                }
                if (this.count != 0) {
                    output.writeInt32(2, this.count);
                }
                super.writeTo(output);
            }

            @Override
            protected int computeSerializedSize() {
                int size = super.computeSerializedSize();
                if (this.dppStatusType != 0) {
                    size += CodedOutputByteBufferNano.computeInt32Size(1, this.dppStatusType);
                }
                if (this.count != 0) {
                    size += CodedOutputByteBufferNano.computeInt32Size(2, this.count);
                }
                return size;
            }

            @Override
            public DppFailureStatusHistogramBucket mergeFrom(CodedInputByteBufferNano input) throws IOException {
                block8: while (true) {
                    int tag = input.readTag();
                    switch (tag) {
                        case 0: {
                            return this;
                        }
                        default: {
                            if (WireFormatNano.parseUnknownField(input, tag)) continue block8;
                            return this;
                        }
                        case 8: {
                            int value = input.readInt32();
                            switch (value) {
                                case 0: 
                                case 1: 
                                case 2: 
                                case 3: 
                                case 4: 
                                case 5: 
                                case 6: 
                                case 7: 
                                case 8: 
                                case 9: {
                                    this.dppStatusType = value;
                                }
                            }
                            continue block8;
                        }
                        case 16: 
                    }
                    this.count = input.readInt32();
                }
            }

            public static DppFailureStatusHistogramBucket parseFrom(byte[] data) throws InvalidProtocolBufferNanoException {
                return MessageNano.mergeFrom(new DppFailureStatusHistogramBucket(), data);
            }

            public static DppFailureStatusHistogramBucket parseFrom(CodedInputByteBufferNano input) throws IOException {
                return new DppFailureStatusHistogramBucket().mergeFrom(input);
            }
        }

        public static final class DppConfiguratorSuccessStatusHistogramBucket
        extends MessageNano {
            private static volatile DppConfiguratorSuccessStatusHistogramBucket[] _emptyArray;
            public int dppStatusType;
            public int count;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public static DppConfiguratorSuccessStatusHistogramBucket[] emptyArray() {
                if (_emptyArray == null) {
                    Object object = InternalNano.LAZY_INIT_LOCK;
                    synchronized (object) {
                        if (_emptyArray == null) {
                            _emptyArray = new DppConfiguratorSuccessStatusHistogramBucket[0];
                        }
                    }
                }
                return _emptyArray;
            }

            public DppConfiguratorSuccessStatusHistogramBucket() {
                this.clear();
            }

            public DppConfiguratorSuccessStatusHistogramBucket clear() {
                this.dppStatusType = 0;
                this.count = 0;
                this.cachedSize = -1;
                return this;
            }

            @Override
            public void writeTo(CodedOutputByteBufferNano output) throws IOException {
                if (this.dppStatusType != 0) {
                    output.writeInt32(1, this.dppStatusType);
                }
                if (this.count != 0) {
                    output.writeInt32(2, this.count);
                }
                super.writeTo(output);
            }

            @Override
            protected int computeSerializedSize() {
                int size = super.computeSerializedSize();
                if (this.dppStatusType != 0) {
                    size += CodedOutputByteBufferNano.computeInt32Size(1, this.dppStatusType);
                }
                if (this.count != 0) {
                    size += CodedOutputByteBufferNano.computeInt32Size(2, this.count);
                }
                return size;
            }

            @Override
            public DppConfiguratorSuccessStatusHistogramBucket mergeFrom(CodedInputByteBufferNano input) throws IOException {
                block8: while (true) {
                    int tag = input.readTag();
                    switch (tag) {
                        case 0: {
                            return this;
                        }
                        default: {
                            if (WireFormatNano.parseUnknownField(input, tag)) continue block8;
                            return this;
                        }
                        case 8: {
                            int value = input.readInt32();
                            switch (value) {
                                case 0: 
                                case 1: {
                                    this.dppStatusType = value;
                                }
                            }
                            continue block8;
                        }
                        case 16: 
                    }
                    this.count = input.readInt32();
                }
            }

            public static DppConfiguratorSuccessStatusHistogramBucket parseFrom(byte[] data) throws InvalidProtocolBufferNanoException {
                return MessageNano.mergeFrom(new DppConfiguratorSuccessStatusHistogramBucket(), data);
            }

            public static DppConfiguratorSuccessStatusHistogramBucket parseFrom(CodedInputByteBufferNano input) throws IOException {
                return new DppConfiguratorSuccessStatusHistogramBucket().mergeFrom(input);
            }
        }
    }

    public static final class GroupEvent
    extends MessageNano {
        public static final int GROUP_OWNER = 0;
        public static final int GROUP_CLIENT = 1;
        private static volatile GroupEvent[] _emptyArray;
        public int netId;
        public long startTimeMillis;
        public int channelFrequency;
        public int groupRole;
        public int numConnectedClients;
        public int numCumulativeClients;
        public int sessionDurationMillis;
        public int idleDurationMillis;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static GroupEvent[] emptyArray() {
            if (_emptyArray == null) {
                Object object = InternalNano.LAZY_INIT_LOCK;
                synchronized (object) {
                    if (_emptyArray == null) {
                        _emptyArray = new GroupEvent[0];
                    }
                }
            }
            return _emptyArray;
        }

        public GroupEvent() {
            this.clear();
        }

        public GroupEvent clear() {
            this.netId = 0;
            this.startTimeMillis = 0L;
            this.channelFrequency = 0;
            this.groupRole = 0;
            this.numConnectedClients = 0;
            this.numCumulativeClients = 0;
            this.sessionDurationMillis = 0;
            this.idleDurationMillis = 0;
            this.cachedSize = -1;
            return this;
        }

        @Override
        public void writeTo(CodedOutputByteBufferNano output) throws IOException {
            if (this.netId != 0) {
                output.writeInt32(1, this.netId);
            }
            if (this.startTimeMillis != 0L) {
                output.writeInt64(2, this.startTimeMillis);
            }
            if (this.channelFrequency != 0) {
                output.writeInt32(3, this.channelFrequency);
            }
            if (this.groupRole != 0) {
                output.writeInt32(5, this.groupRole);
            }
            if (this.numConnectedClients != 0) {
                output.writeInt32(6, this.numConnectedClients);
            }
            if (this.numCumulativeClients != 0) {
                output.writeInt32(7, this.numCumulativeClients);
            }
            if (this.sessionDurationMillis != 0) {
                output.writeInt32(8, this.sessionDurationMillis);
            }
            if (this.idleDurationMillis != 0) {
                output.writeInt32(9, this.idleDurationMillis);
            }
            super.writeTo(output);
        }

        @Override
        protected int computeSerializedSize() {
            int size = super.computeSerializedSize();
            if (this.netId != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(1, this.netId);
            }
            if (this.startTimeMillis != 0L) {
                size += CodedOutputByteBufferNano.computeInt64Size(2, this.startTimeMillis);
            }
            if (this.channelFrequency != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(3, this.channelFrequency);
            }
            if (this.groupRole != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(5, this.groupRole);
            }
            if (this.numConnectedClients != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(6, this.numConnectedClients);
            }
            if (this.numCumulativeClients != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(7, this.numCumulativeClients);
            }
            if (this.sessionDurationMillis != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(8, this.sessionDurationMillis);
            }
            if (this.idleDurationMillis != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(9, this.idleDurationMillis);
            }
            return size;
        }

        @Override
        public GroupEvent mergeFrom(CodedInputByteBufferNano input) throws IOException {
            block14: while (true) {
                int tag = input.readTag();
                switch (tag) {
                    case 0: {
                        return this;
                    }
                    default: {
                        if (WireFormatNano.parseUnknownField(input, tag)) continue block14;
                        return this;
                    }
                    case 8: {
                        this.netId = input.readInt32();
                        continue block14;
                    }
                    case 16: {
                        this.startTimeMillis = input.readInt64();
                        continue block14;
                    }
                    case 24: {
                        this.channelFrequency = input.readInt32();
                        continue block14;
                    }
                    case 40: {
                        int value = input.readInt32();
                        switch (value) {
                            case 0: 
                            case 1: {
                                this.groupRole = value;
                            }
                        }
                        continue block14;
                    }
                    case 48: {
                        this.numConnectedClients = input.readInt32();
                        continue block14;
                    }
                    case 56: {
                        this.numCumulativeClients = input.readInt32();
                        continue block14;
                    }
                    case 64: {
                        this.sessionDurationMillis = input.readInt32();
                        continue block14;
                    }
                    case 72: 
                }
                this.idleDurationMillis = input.readInt32();
            }
        }

        public static GroupEvent parseFrom(byte[] data) throws InvalidProtocolBufferNanoException {
            return MessageNano.mergeFrom(new GroupEvent(), data);
        }

        public static GroupEvent parseFrom(CodedInputByteBufferNano input) throws IOException {
            return new GroupEvent().mergeFrom(input);
        }
    }

    public static final class P2pConnectionEvent
    extends MessageNano {
        public static final int CONNECTION_FRESH = 0;
        public static final int CONNECTION_REINVOKE = 1;
        public static final int CONNECTION_LOCAL = 2;
        public static final int CONNECTION_FAST = 3;
        public static final int CLF_UNKNOWN = 0;
        public static final int CLF_NONE = 1;
        public static final int CLF_TIMEOUT = 2;
        public static final int CLF_CANCEL = 3;
        public static final int CLF_PROV_DISC_FAIL = 4;
        public static final int CLF_INVITATION_FAIL = 5;
        public static final int CLF_USER_REJECT = 6;
        public static final int CLF_NEW_CONNECTION_ATTEMPT = 7;
        public static final int WPS_NA = -1;
        public static final int WPS_PBC = 0;
        public static final int WPS_DISPLAY = 1;
        public static final int WPS_KEYPAD = 2;
        public static final int WPS_LABEL = 3;
        private static volatile P2pConnectionEvent[] _emptyArray;
        public long startTimeMillis;
        public int connectionType;
        public int wpsMethod;
        public int durationTakenToConnectMillis;
        public int connectivityLevelFailureCode;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static P2pConnectionEvent[] emptyArray() {
            if (_emptyArray == null) {
                Object object = InternalNano.LAZY_INIT_LOCK;
                synchronized (object) {
                    if (_emptyArray == null) {
                        _emptyArray = new P2pConnectionEvent[0];
                    }
                }
            }
            return _emptyArray;
        }

        public P2pConnectionEvent() {
            this.clear();
        }

        public P2pConnectionEvent clear() {
            this.startTimeMillis = 0L;
            this.connectionType = 0;
            this.wpsMethod = -1;
            this.durationTakenToConnectMillis = 0;
            this.connectivityLevelFailureCode = 0;
            this.cachedSize = -1;
            return this;
        }

        @Override
        public void writeTo(CodedOutputByteBufferNano output) throws IOException {
            if (this.startTimeMillis != 0L) {
                output.writeInt64(1, this.startTimeMillis);
            }
            if (this.connectionType != 0) {
                output.writeInt32(2, this.connectionType);
            }
            if (this.wpsMethod != -1) {
                output.writeInt32(3, this.wpsMethod);
            }
            if (this.durationTakenToConnectMillis != 0) {
                output.writeInt32(4, this.durationTakenToConnectMillis);
            }
            if (this.connectivityLevelFailureCode != 0) {
                output.writeInt32(5, this.connectivityLevelFailureCode);
            }
            super.writeTo(output);
        }

        @Override
        protected int computeSerializedSize() {
            int size = super.computeSerializedSize();
            if (this.startTimeMillis != 0L) {
                size += CodedOutputByteBufferNano.computeInt64Size(1, this.startTimeMillis);
            }
            if (this.connectionType != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(2, this.connectionType);
            }
            if (this.wpsMethod != -1) {
                size += CodedOutputByteBufferNano.computeInt32Size(3, this.wpsMethod);
            }
            if (this.durationTakenToConnectMillis != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(4, this.durationTakenToConnectMillis);
            }
            if (this.connectivityLevelFailureCode != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(5, this.connectivityLevelFailureCode);
            }
            return size;
        }

        @Override
        public P2pConnectionEvent mergeFrom(CodedInputByteBufferNano input) throws IOException {
            block17: while (true) {
                int value;
                int tag = input.readTag();
                switch (tag) {
                    case 0: {
                        return this;
                    }
                    default: {
                        if (WireFormatNano.parseUnknownField(input, tag)) continue block17;
                        return this;
                    }
                    case 8: {
                        this.startTimeMillis = input.readInt64();
                        continue block17;
                    }
                    case 16: {
                        value = input.readInt32();
                        switch (value) {
                            case 0: 
                            case 1: 
                            case 2: 
                            case 3: {
                                this.connectionType = value;
                            }
                        }
                        continue block17;
                    }
                    case 24: {
                        value = input.readInt32();
                        switch (value) {
                            case -1: 
                            case 0: 
                            case 1: 
                            case 2: 
                            case 3: {
                                this.wpsMethod = value;
                            }
                        }
                        continue block17;
                    }
                    case 32: {
                        this.durationTakenToConnectMillis = input.readInt32();
                        continue block17;
                    }
                    case 40: 
                }
                value = input.readInt32();
                switch (value) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: {
                        this.connectivityLevelFailureCode = value;
                    }
                }
            }
        }

        public static P2pConnectionEvent parseFrom(byte[] data) throws InvalidProtocolBufferNanoException {
            return MessageNano.mergeFrom(new P2pConnectionEvent(), data);
        }

        public static P2pConnectionEvent parseFrom(CodedInputByteBufferNano input) throws IOException {
            return new P2pConnectionEvent().mergeFrom(input);
        }
    }

    public static final class WifiP2pStats
    extends MessageNano {
        private static volatile WifiP2pStats[] _emptyArray;
        public GroupEvent[] groupEvent;
        public P2pConnectionEvent[] connectionEvent;
        public int numPersistentGroup;
        public int numTotalPeerScans;
        public int numTotalServiceScans;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static WifiP2pStats[] emptyArray() {
            if (_emptyArray == null) {
                Object object = InternalNano.LAZY_INIT_LOCK;
                synchronized (object) {
                    if (_emptyArray == null) {
                        _emptyArray = new WifiP2pStats[0];
                    }
                }
            }
            return _emptyArray;
        }

        public WifiP2pStats() {
            this.clear();
        }

        public WifiP2pStats clear() {
            this.groupEvent = GroupEvent.emptyArray();
            this.connectionEvent = P2pConnectionEvent.emptyArray();
            this.numPersistentGroup = 0;
            this.numTotalPeerScans = 0;
            this.numTotalServiceScans = 0;
            this.cachedSize = -1;
            return this;
        }

        @Override
        public void writeTo(CodedOutputByteBufferNano output) throws IOException {
            MessageNano element;
            int i;
            if (this.groupEvent != null && this.groupEvent.length > 0) {
                for (i = 0; i < this.groupEvent.length; ++i) {
                    element = this.groupEvent[i];
                    if (element == null) continue;
                    output.writeMessage(1, element);
                }
            }
            if (this.connectionEvent != null && this.connectionEvent.length > 0) {
                for (i = 0; i < this.connectionEvent.length; ++i) {
                    element = this.connectionEvent[i];
                    if (element == null) continue;
                    output.writeMessage(2, element);
                }
            }
            if (this.numPersistentGroup != 0) {
                output.writeInt32(3, this.numPersistentGroup);
            }
            if (this.numTotalPeerScans != 0) {
                output.writeInt32(4, this.numTotalPeerScans);
            }
            if (this.numTotalServiceScans != 0) {
                output.writeInt32(5, this.numTotalServiceScans);
            }
            super.writeTo(output);
        }

        @Override
        protected int computeSerializedSize() {
            MessageNano element;
            int i;
            int size = super.computeSerializedSize();
            if (this.groupEvent != null && this.groupEvent.length > 0) {
                for (i = 0; i < this.groupEvent.length; ++i) {
                    element = this.groupEvent[i];
                    if (element == null) continue;
                    size += CodedOutputByteBufferNano.computeMessageSize(1, element);
                }
            }
            if (this.connectionEvent != null && this.connectionEvent.length > 0) {
                for (i = 0; i < this.connectionEvent.length; ++i) {
                    element = this.connectionEvent[i];
                    if (element == null) continue;
                    size += CodedOutputByteBufferNano.computeMessageSize(2, element);
                }
            }
            if (this.numPersistentGroup != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(3, this.numPersistentGroup);
            }
            if (this.numTotalPeerScans != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(4, this.numTotalPeerScans);
            }
            if (this.numTotalServiceScans != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(5, this.numTotalServiceScans);
            }
            return size;
        }

        @Override
        public WifiP2pStats mergeFrom(CodedInputByteBufferNano input) throws IOException {
            block8: while (true) {
                int tag = input.readTag();
                switch (tag) {
                    case 0: {
                        return this;
                    }
                    default: {
                        if (WireFormatNano.parseUnknownField(input, tag)) continue block8;
                        return this;
                    }
                    case 10: {
                        int arrayLength = WireFormatNano.getRepeatedFieldArrayLength(input, 10);
                        int i = this.groupEvent == null ? 0 : this.groupEvent.length;
                        MessageNano[] newArray = new GroupEvent[i + arrayLength];
                        if (i != 0) {
                            System.arraycopy(this.groupEvent, 0, newArray, 0, i);
                        }
                        while (i < newArray.length - 1) {
                            newArray[i] = new GroupEvent();
                            input.readMessage(newArray[i]);
                            input.readTag();
                            ++i;
                        }
                        newArray[i] = new GroupEvent();
                        input.readMessage(newArray[i]);
                        this.groupEvent = newArray;
                        continue block8;
                    }
                    case 18: {
                        int arrayLength = WireFormatNano.getRepeatedFieldArrayLength(input, 18);
                        int i = this.connectionEvent == null ? 0 : this.connectionEvent.length;
                        MessageNano[] newArray = new P2pConnectionEvent[i + arrayLength];
                        if (i != 0) {
                            System.arraycopy(this.connectionEvent, 0, newArray, 0, i);
                        }
                        while (i < newArray.length - 1) {
                            newArray[i] = new P2pConnectionEvent();
                            input.readMessage(newArray[i]);
                            input.readTag();
                            ++i;
                        }
                        newArray[i] = new P2pConnectionEvent();
                        input.readMessage(newArray[i]);
                        this.connectionEvent = newArray;
                        continue block8;
                    }
                    case 24: {
                        this.numPersistentGroup = input.readInt32();
                        continue block8;
                    }
                    case 32: {
                        this.numTotalPeerScans = input.readInt32();
                        continue block8;
                    }
                    case 40: 
                }
                this.numTotalServiceScans = input.readInt32();
            }
        }

        public static WifiP2pStats parseFrom(byte[] data) throws InvalidProtocolBufferNanoException {
            return MessageNano.mergeFrom(new WifiP2pStats(), data);
        }

        public static WifiP2pStats parseFrom(CodedInputByteBufferNano input) throws IOException {
            return new WifiP2pStats().mergeFrom(input);
        }
    }

    public static final class DeviceMobilityStatePnoScanStats
    extends MessageNano {
        public static final int UNKNOWN = 0;
        public static final int HIGH_MVMT = 1;
        public static final int LOW_MVMT = 2;
        public static final int STATIONARY = 3;
        private static volatile DeviceMobilityStatePnoScanStats[] _emptyArray;
        public int deviceMobilityState;
        public int numTimesEnteredState;
        public long totalDurationMs;
        public long pnoDurationMs;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static DeviceMobilityStatePnoScanStats[] emptyArray() {
            if (_emptyArray == null) {
                Object object = InternalNano.LAZY_INIT_LOCK;
                synchronized (object) {
                    if (_emptyArray == null) {
                        _emptyArray = new DeviceMobilityStatePnoScanStats[0];
                    }
                }
            }
            return _emptyArray;
        }

        public DeviceMobilityStatePnoScanStats() {
            this.clear();
        }

        public DeviceMobilityStatePnoScanStats clear() {
            this.deviceMobilityState = 0;
            this.numTimesEnteredState = 0;
            this.totalDurationMs = 0L;
            this.pnoDurationMs = 0L;
            this.cachedSize = -1;
            return this;
        }

        @Override
        public void writeTo(CodedOutputByteBufferNano output) throws IOException {
            if (this.deviceMobilityState != 0) {
                output.writeInt32(1, this.deviceMobilityState);
            }
            if (this.numTimesEnteredState != 0) {
                output.writeInt32(2, this.numTimesEnteredState);
            }
            if (this.totalDurationMs != 0L) {
                output.writeInt64(3, this.totalDurationMs);
            }
            if (this.pnoDurationMs != 0L) {
                output.writeInt64(4, this.pnoDurationMs);
            }
            super.writeTo(output);
        }

        @Override
        protected int computeSerializedSize() {
            int size = super.computeSerializedSize();
            if (this.deviceMobilityState != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(1, this.deviceMobilityState);
            }
            if (this.numTimesEnteredState != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(2, this.numTimesEnteredState);
            }
            if (this.totalDurationMs != 0L) {
                size += CodedOutputByteBufferNano.computeInt64Size(3, this.totalDurationMs);
            }
            if (this.pnoDurationMs != 0L) {
                size += CodedOutputByteBufferNano.computeInt64Size(4, this.pnoDurationMs);
            }
            return size;
        }

        @Override
        public DeviceMobilityStatePnoScanStats mergeFrom(CodedInputByteBufferNano input) throws IOException {
            block10: while (true) {
                int tag = input.readTag();
                switch (tag) {
                    case 0: {
                        return this;
                    }
                    default: {
                        if (WireFormatNano.parseUnknownField(input, tag)) continue block10;
                        return this;
                    }
                    case 8: {
                        int value = input.readInt32();
                        switch (value) {
                            case 0: 
                            case 1: 
                            case 2: 
                            case 3: {
                                this.deviceMobilityState = value;
                            }
                        }
                        continue block10;
                    }
                    case 16: {
                        this.numTimesEnteredState = input.readInt32();
                        continue block10;
                    }
                    case 24: {
                        this.totalDurationMs = input.readInt64();
                        continue block10;
                    }
                    case 32: 
                }
                this.pnoDurationMs = input.readInt64();
            }
        }

        public static DeviceMobilityStatePnoScanStats parseFrom(byte[] data) throws InvalidProtocolBufferNanoException {
            return MessageNano.mergeFrom(new DeviceMobilityStatePnoScanStats(), data);
        }

        public static DeviceMobilityStatePnoScanStats parseFrom(CodedInputByteBufferNano input) throws IOException {
            return new DeviceMobilityStatePnoScanStats().mergeFrom(input);
        }
    }

    public static final class WifiUsabilityStats
    extends MessageNano {
        public static final int LABEL_UNKNOWN = 0;
        public static final int LABEL_GOOD = 1;
        public static final int LABEL_BAD = 2;
        public static final int TYPE_UNKNOWN = 0;
        public static final int TYPE_DATA_STALL_BAD_TX = 1;
        public static final int TYPE_DATA_STALL_TX_WITHOUT_RX = 2;
        public static final int TYPE_DATA_STALL_BOTH = 3;
        public static final int TYPE_FIRMWARE_ALERT = 4;
        public static final int TYPE_IP_REACHABILITY_LOST = 5;
        private static volatile WifiUsabilityStats[] _emptyArray;
        public int label;
        public WifiUsabilityStatsEntry[] stats;
        public int triggerType;
        public int firmwareAlertCode;
        public long timeStampMs;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static WifiUsabilityStats[] emptyArray() {
            if (_emptyArray == null) {
                Object object = InternalNano.LAZY_INIT_LOCK;
                synchronized (object) {
                    if (_emptyArray == null) {
                        _emptyArray = new WifiUsabilityStats[0];
                    }
                }
            }
            return _emptyArray;
        }

        public WifiUsabilityStats() {
            this.clear();
        }

        public WifiUsabilityStats clear() {
            this.label = 0;
            this.stats = WifiUsabilityStatsEntry.emptyArray();
            this.triggerType = 0;
            this.firmwareAlertCode = -1;
            this.timeStampMs = 0L;
            this.cachedSize = -1;
            return this;
        }

        @Override
        public void writeTo(CodedOutputByteBufferNano output) throws IOException {
            if (this.label != 0) {
                output.writeInt32(1, this.label);
            }
            if (this.stats != null && this.stats.length > 0) {
                for (int i = 0; i < this.stats.length; ++i) {
                    WifiUsabilityStatsEntry element = this.stats[i];
                    if (element == null) continue;
                    output.writeMessage(2, element);
                }
            }
            if (this.triggerType != 0) {
                output.writeInt32(3, this.triggerType);
            }
            if (this.firmwareAlertCode != -1) {
                output.writeInt32(4, this.firmwareAlertCode);
            }
            if (this.timeStampMs != 0L) {
                output.writeInt64(5, this.timeStampMs);
            }
            super.writeTo(output);
        }

        @Override
        protected int computeSerializedSize() {
            int size = super.computeSerializedSize();
            if (this.label != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(1, this.label);
            }
            if (this.stats != null && this.stats.length > 0) {
                for (int i = 0; i < this.stats.length; ++i) {
                    WifiUsabilityStatsEntry element = this.stats[i];
                    if (element == null) continue;
                    size += CodedOutputByteBufferNano.computeMessageSize(2, element);
                }
            }
            if (this.triggerType != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(3, this.triggerType);
            }
            if (this.firmwareAlertCode != -1) {
                size += CodedOutputByteBufferNano.computeInt32Size(4, this.firmwareAlertCode);
            }
            if (this.timeStampMs != 0L) {
                size += CodedOutputByteBufferNano.computeInt64Size(5, this.timeStampMs);
            }
            return size;
        }

        @Override
        public WifiUsabilityStats mergeFrom(CodedInputByteBufferNano input) throws IOException {
            block14: while (true) {
                int tag = input.readTag();
                switch (tag) {
                    case 0: {
                        return this;
                    }
                    default: {
                        if (WireFormatNano.parseUnknownField(input, tag)) continue block14;
                        return this;
                    }
                    case 8: {
                        int value = input.readInt32();
                        switch (value) {
                            case 0: 
                            case 1: 
                            case 2: {
                                this.label = value;
                            }
                        }
                        continue block14;
                    }
                    case 18: {
                        int arrayLength = WireFormatNano.getRepeatedFieldArrayLength(input, 18);
                        int i = this.stats == null ? 0 : this.stats.length;
                        WifiUsabilityStatsEntry[] newArray = new WifiUsabilityStatsEntry[i + arrayLength];
                        if (i != 0) {
                            System.arraycopy(this.stats, 0, newArray, 0, i);
                        }
                        while (i < newArray.length - 1) {
                            newArray[i] = new WifiUsabilityStatsEntry();
                            input.readMessage(newArray[i]);
                            input.readTag();
                            ++i;
                        }
                        newArray[i] = new WifiUsabilityStatsEntry();
                        input.readMessage(newArray[i]);
                        this.stats = newArray;
                        continue block14;
                    }
                    case 24: {
                        int value = input.readInt32();
                        switch (value) {
                            case 0: 
                            case 1: 
                            case 2: 
                            case 3: 
                            case 4: 
                            case 5: {
                                this.triggerType = value;
                            }
                        }
                        continue block14;
                    }
                    case 32: {
                        this.firmwareAlertCode = input.readInt32();
                        continue block14;
                    }
                    case 40: 
                }
                this.timeStampMs = input.readInt64();
            }
        }

        public static WifiUsabilityStats parseFrom(byte[] data) throws InvalidProtocolBufferNanoException {
            return MessageNano.mergeFrom(new WifiUsabilityStats(), data);
        }

        public static WifiUsabilityStats parseFrom(CodedInputByteBufferNano input) throws IOException {
            return new WifiUsabilityStats().mergeFrom(input);
        }
    }

    public static final class WifiUsabilityStatsEntry
    extends MessageNano {
        public static final int PROBE_STATUS_UNKNOWN = 0;
        public static final int PROBE_STATUS_NO_PROBE = 1;
        public static final int PROBE_STATUS_SUCCESS = 2;
        public static final int PROBE_STATUS_FAILURE = 3;
        public static final int NETWORK_TYPE_UNKNOWN = 0;
        public static final int NETWORK_TYPE_GSM = 1;
        public static final int NETWORK_TYPE_CDMA = 2;
        public static final int NETWORK_TYPE_EVDO_0 = 3;
        public static final int NETWORK_TYPE_UMTS = 4;
        public static final int NETWORK_TYPE_TD_SCDMA = 5;
        public static final int NETWORK_TYPE_LTE = 6;
        public static final int NETWORK_TYPE_NR = 7;
        private static volatile WifiUsabilityStatsEntry[] _emptyArray;
        public long timeStampMs;
        public int rssi;
        public int linkSpeedMbps;
        public long totalTxSuccess;
        public long totalTxRetries;
        public long totalTxBad;
        public long totalRxSuccess;
        public long totalRadioOnTimeMs;
        public long totalRadioTxTimeMs;
        public long totalRadioRxTimeMs;
        public long totalScanTimeMs;
        public long totalNanScanTimeMs;
        public long totalBackgroundScanTimeMs;
        public long totalRoamScanTimeMs;
        public long totalPnoScanTimeMs;
        public long totalHotspot2ScanTimeMs;
        public int wifiScore;
        public int wifiUsabilityScore;
        public int seqNumToFramework;
        public long totalCcaBusyFreqTimeMs;
        public long totalRadioOnFreqTimeMs;
        public long totalBeaconRx;
        public int predictionHorizonSec;
        public int probeStatusSinceLastUpdate;
        public int probeElapsedTimeSinceLastUpdateMs;
        public int probeMcsRateSinceLastUpdate;
        public int rxLinkSpeedMbps;
        public int seqNumInsideFramework;
        public boolean isSameBssidAndFreq;
        public int cellularDataNetworkType;
        public int cellularSignalStrengthDbm;
        public int cellularSignalStrengthDb;
        public boolean isSameRegisteredCell;
        public int deviceMobilityState;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static WifiUsabilityStatsEntry[] emptyArray() {
            if (_emptyArray == null) {
                Object object = InternalNano.LAZY_INIT_LOCK;
                synchronized (object) {
                    if (_emptyArray == null) {
                        _emptyArray = new WifiUsabilityStatsEntry[0];
                    }
                }
            }
            return _emptyArray;
        }

        public WifiUsabilityStatsEntry() {
            this.clear();
        }

        public WifiUsabilityStatsEntry clear() {
            this.timeStampMs = 0L;
            this.rssi = 0;
            this.linkSpeedMbps = 0;
            this.totalTxSuccess = 0L;
            this.totalTxRetries = 0L;
            this.totalTxBad = 0L;
            this.totalRxSuccess = 0L;
            this.totalRadioOnTimeMs = 0L;
            this.totalRadioTxTimeMs = 0L;
            this.totalRadioRxTimeMs = 0L;
            this.totalScanTimeMs = 0L;
            this.totalNanScanTimeMs = 0L;
            this.totalBackgroundScanTimeMs = 0L;
            this.totalRoamScanTimeMs = 0L;
            this.totalPnoScanTimeMs = 0L;
            this.totalHotspot2ScanTimeMs = 0L;
            this.wifiScore = 0;
            this.wifiUsabilityScore = 0;
            this.seqNumToFramework = 0;
            this.totalCcaBusyFreqTimeMs = 0L;
            this.totalRadioOnFreqTimeMs = 0L;
            this.totalBeaconRx = 0L;
            this.predictionHorizonSec = 0;
            this.probeStatusSinceLastUpdate = 0;
            this.probeElapsedTimeSinceLastUpdateMs = 0;
            this.probeMcsRateSinceLastUpdate = 0;
            this.rxLinkSpeedMbps = 0;
            this.seqNumInsideFramework = 0;
            this.isSameBssidAndFreq = false;
            this.cellularDataNetworkType = 0;
            this.cellularSignalStrengthDbm = 0;
            this.cellularSignalStrengthDb = 0;
            this.isSameRegisteredCell = false;
            this.deviceMobilityState = 0;
            this.cachedSize = -1;
            return this;
        }

        @Override
        public void writeTo(CodedOutputByteBufferNano output) throws IOException {
            if (this.timeStampMs != 0L) {
                output.writeInt64(1, this.timeStampMs);
            }
            if (this.rssi != 0) {
                output.writeInt32(2, this.rssi);
            }
            if (this.linkSpeedMbps != 0) {
                output.writeInt32(3, this.linkSpeedMbps);
            }
            if (this.totalTxSuccess != 0L) {
                output.writeInt64(4, this.totalTxSuccess);
            }
            if (this.totalTxRetries != 0L) {
                output.writeInt64(5, this.totalTxRetries);
            }
            if (this.totalTxBad != 0L) {
                output.writeInt64(6, this.totalTxBad);
            }
            if (this.totalRxSuccess != 0L) {
                output.writeInt64(7, this.totalRxSuccess);
            }
            if (this.totalRadioOnTimeMs != 0L) {
                output.writeInt64(8, this.totalRadioOnTimeMs);
            }
            if (this.totalRadioTxTimeMs != 0L) {
                output.writeInt64(9, this.totalRadioTxTimeMs);
            }
            if (this.totalRadioRxTimeMs != 0L) {
                output.writeInt64(10, this.totalRadioRxTimeMs);
            }
            if (this.totalScanTimeMs != 0L) {
                output.writeInt64(11, this.totalScanTimeMs);
            }
            if (this.totalNanScanTimeMs != 0L) {
                output.writeInt64(12, this.totalNanScanTimeMs);
            }
            if (this.totalBackgroundScanTimeMs != 0L) {
                output.writeInt64(13, this.totalBackgroundScanTimeMs);
            }
            if (this.totalRoamScanTimeMs != 0L) {
                output.writeInt64(14, this.totalRoamScanTimeMs);
            }
            if (this.totalPnoScanTimeMs != 0L) {
                output.writeInt64(15, this.totalPnoScanTimeMs);
            }
            if (this.totalHotspot2ScanTimeMs != 0L) {
                output.writeInt64(16, this.totalHotspot2ScanTimeMs);
            }
            if (this.wifiScore != 0) {
                output.writeInt32(17, this.wifiScore);
            }
            if (this.wifiUsabilityScore != 0) {
                output.writeInt32(18, this.wifiUsabilityScore);
            }
            if (this.seqNumToFramework != 0) {
                output.writeInt32(19, this.seqNumToFramework);
            }
            if (this.totalCcaBusyFreqTimeMs != 0L) {
                output.writeInt64(20, this.totalCcaBusyFreqTimeMs);
            }
            if (this.totalRadioOnFreqTimeMs != 0L) {
                output.writeInt64(21, this.totalRadioOnFreqTimeMs);
            }
            if (this.totalBeaconRx != 0L) {
                output.writeInt64(22, this.totalBeaconRx);
            }
            if (this.predictionHorizonSec != 0) {
                output.writeInt32(23, this.predictionHorizonSec);
            }
            if (this.probeStatusSinceLastUpdate != 0) {
                output.writeInt32(24, this.probeStatusSinceLastUpdate);
            }
            if (this.probeElapsedTimeSinceLastUpdateMs != 0) {
                output.writeInt32(25, this.probeElapsedTimeSinceLastUpdateMs);
            }
            if (this.probeMcsRateSinceLastUpdate != 0) {
                output.writeInt32(26, this.probeMcsRateSinceLastUpdate);
            }
            if (this.rxLinkSpeedMbps != 0) {
                output.writeInt32(27, this.rxLinkSpeedMbps);
            }
            if (this.seqNumInsideFramework != 0) {
                output.writeInt32(28, this.seqNumInsideFramework);
            }
            if (this.isSameBssidAndFreq) {
                output.writeBool(29, this.isSameBssidAndFreq);
            }
            if (this.cellularDataNetworkType != 0) {
                output.writeInt32(30, this.cellularDataNetworkType);
            }
            if (this.cellularSignalStrengthDbm != 0) {
                output.writeInt32(31, this.cellularSignalStrengthDbm);
            }
            if (this.cellularSignalStrengthDb != 0) {
                output.writeInt32(32, this.cellularSignalStrengthDb);
            }
            if (this.isSameRegisteredCell) {
                output.writeBool(33, this.isSameRegisteredCell);
            }
            if (this.deviceMobilityState != 0) {
                output.writeInt32(34, this.deviceMobilityState);
            }
            super.writeTo(output);
        }

        @Override
        protected int computeSerializedSize() {
            int size = super.computeSerializedSize();
            if (this.timeStampMs != 0L) {
                size += CodedOutputByteBufferNano.computeInt64Size(1, this.timeStampMs);
            }
            if (this.rssi != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(2, this.rssi);
            }
            if (this.linkSpeedMbps != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(3, this.linkSpeedMbps);
            }
            if (this.totalTxSuccess != 0L) {
                size += CodedOutputByteBufferNano.computeInt64Size(4, this.totalTxSuccess);
            }
            if (this.totalTxRetries != 0L) {
                size += CodedOutputByteBufferNano.computeInt64Size(5, this.totalTxRetries);
            }
            if (this.totalTxBad != 0L) {
                size += CodedOutputByteBufferNano.computeInt64Size(6, this.totalTxBad);
            }
            if (this.totalRxSuccess != 0L) {
                size += CodedOutputByteBufferNano.computeInt64Size(7, this.totalRxSuccess);
            }
            if (this.totalRadioOnTimeMs != 0L) {
                size += CodedOutputByteBufferNano.computeInt64Size(8, this.totalRadioOnTimeMs);
            }
            if (this.totalRadioTxTimeMs != 0L) {
                size += CodedOutputByteBufferNano.computeInt64Size(9, this.totalRadioTxTimeMs);
            }
            if (this.totalRadioRxTimeMs != 0L) {
                size += CodedOutputByteBufferNano.computeInt64Size(10, this.totalRadioRxTimeMs);
            }
            if (this.totalScanTimeMs != 0L) {
                size += CodedOutputByteBufferNano.computeInt64Size(11, this.totalScanTimeMs);
            }
            if (this.totalNanScanTimeMs != 0L) {
                size += CodedOutputByteBufferNano.computeInt64Size(12, this.totalNanScanTimeMs);
            }
            if (this.totalBackgroundScanTimeMs != 0L) {
                size += CodedOutputByteBufferNano.computeInt64Size(13, this.totalBackgroundScanTimeMs);
            }
            if (this.totalRoamScanTimeMs != 0L) {
                size += CodedOutputByteBufferNano.computeInt64Size(14, this.totalRoamScanTimeMs);
            }
            if (this.totalPnoScanTimeMs != 0L) {
                size += CodedOutputByteBufferNano.computeInt64Size(15, this.totalPnoScanTimeMs);
            }
            if (this.totalHotspot2ScanTimeMs != 0L) {
                size += CodedOutputByteBufferNano.computeInt64Size(16, this.totalHotspot2ScanTimeMs);
            }
            if (this.wifiScore != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(17, this.wifiScore);
            }
            if (this.wifiUsabilityScore != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(18, this.wifiUsabilityScore);
            }
            if (this.seqNumToFramework != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(19, this.seqNumToFramework);
            }
            if (this.totalCcaBusyFreqTimeMs != 0L) {
                size += CodedOutputByteBufferNano.computeInt64Size(20, this.totalCcaBusyFreqTimeMs);
            }
            if (this.totalRadioOnFreqTimeMs != 0L) {
                size += CodedOutputByteBufferNano.computeInt64Size(21, this.totalRadioOnFreqTimeMs);
            }
            if (this.totalBeaconRx != 0L) {
                size += CodedOutputByteBufferNano.computeInt64Size(22, this.totalBeaconRx);
            }
            if (this.predictionHorizonSec != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(23, this.predictionHorizonSec);
            }
            if (this.probeStatusSinceLastUpdate != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(24, this.probeStatusSinceLastUpdate);
            }
            if (this.probeElapsedTimeSinceLastUpdateMs != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(25, this.probeElapsedTimeSinceLastUpdateMs);
            }
            if (this.probeMcsRateSinceLastUpdate != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(26, this.probeMcsRateSinceLastUpdate);
            }
            if (this.rxLinkSpeedMbps != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(27, this.rxLinkSpeedMbps);
            }
            if (this.seqNumInsideFramework != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(28, this.seqNumInsideFramework);
            }
            if (this.isSameBssidAndFreq) {
                size += CodedOutputByteBufferNano.computeBoolSize(29, this.isSameBssidAndFreq);
            }
            if (this.cellularDataNetworkType != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(30, this.cellularDataNetworkType);
            }
            if (this.cellularSignalStrengthDbm != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(31, this.cellularSignalStrengthDbm);
            }
            if (this.cellularSignalStrengthDb != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(32, this.cellularSignalStrengthDb);
            }
            if (this.isSameRegisteredCell) {
                size += CodedOutputByteBufferNano.computeBoolSize(33, this.isSameRegisteredCell);
            }
            if (this.deviceMobilityState != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(34, this.deviceMobilityState);
            }
            return size;
        }

        @Override
        public WifiUsabilityStatsEntry mergeFrom(CodedInputByteBufferNano input) throws IOException {
            block46: while (true) {
                int value;
                int tag = input.readTag();
                switch (tag) {
                    case 0: {
                        return this;
                    }
                    default: {
                        if (WireFormatNano.parseUnknownField(input, tag)) continue block46;
                        return this;
                    }
                    case 8: {
                        this.timeStampMs = input.readInt64();
                        continue block46;
                    }
                    case 16: {
                        this.rssi = input.readInt32();
                        continue block46;
                    }
                    case 24: {
                        this.linkSpeedMbps = input.readInt32();
                        continue block46;
                    }
                    case 32: {
                        this.totalTxSuccess = input.readInt64();
                        continue block46;
                    }
                    case 40: {
                        this.totalTxRetries = input.readInt64();
                        continue block46;
                    }
                    case 48: {
                        this.totalTxBad = input.readInt64();
                        continue block46;
                    }
                    case 56: {
                        this.totalRxSuccess = input.readInt64();
                        continue block46;
                    }
                    case 64: {
                        this.totalRadioOnTimeMs = input.readInt64();
                        continue block46;
                    }
                    case 72: {
                        this.totalRadioTxTimeMs = input.readInt64();
                        continue block46;
                    }
                    case 80: {
                        this.totalRadioRxTimeMs = input.readInt64();
                        continue block46;
                    }
                    case 88: {
                        this.totalScanTimeMs = input.readInt64();
                        continue block46;
                    }
                    case 96: {
                        this.totalNanScanTimeMs = input.readInt64();
                        continue block46;
                    }
                    case 104: {
                        this.totalBackgroundScanTimeMs = input.readInt64();
                        continue block46;
                    }
                    case 112: {
                        this.totalRoamScanTimeMs = input.readInt64();
                        continue block46;
                    }
                    case 120: {
                        this.totalPnoScanTimeMs = input.readInt64();
                        continue block46;
                    }
                    case 128: {
                        this.totalHotspot2ScanTimeMs = input.readInt64();
                        continue block46;
                    }
                    case 136: {
                        this.wifiScore = input.readInt32();
                        continue block46;
                    }
                    case 144: {
                        this.wifiUsabilityScore = input.readInt32();
                        continue block46;
                    }
                    case 152: {
                        this.seqNumToFramework = input.readInt32();
                        continue block46;
                    }
                    case 160: {
                        this.totalCcaBusyFreqTimeMs = input.readInt64();
                        continue block46;
                    }
                    case 168: {
                        this.totalRadioOnFreqTimeMs = input.readInt64();
                        continue block46;
                    }
                    case 176: {
                        this.totalBeaconRx = input.readInt64();
                        continue block46;
                    }
                    case 184: {
                        this.predictionHorizonSec = input.readInt32();
                        continue block46;
                    }
                    case 192: {
                        value = input.readInt32();
                        switch (value) {
                            case 0: 
                            case 1: 
                            case 2: 
                            case 3: {
                                this.probeStatusSinceLastUpdate = value;
                            }
                        }
                        continue block46;
                    }
                    case 200: {
                        this.probeElapsedTimeSinceLastUpdateMs = input.readInt32();
                        continue block46;
                    }
                    case 208: {
                        this.probeMcsRateSinceLastUpdate = input.readInt32();
                        continue block46;
                    }
                    case 216: {
                        this.rxLinkSpeedMbps = input.readInt32();
                        continue block46;
                    }
                    case 224: {
                        this.seqNumInsideFramework = input.readInt32();
                        continue block46;
                    }
                    case 232: {
                        this.isSameBssidAndFreq = input.readBool();
                        continue block46;
                    }
                    case 240: {
                        value = input.readInt32();
                        switch (value) {
                            case 0: 
                            case 1: 
                            case 2: 
                            case 3: 
                            case 4: 
                            case 5: 
                            case 6: 
                            case 7: {
                                this.cellularDataNetworkType = value;
                            }
                        }
                        continue block46;
                    }
                    case 248: {
                        this.cellularSignalStrengthDbm = input.readInt32();
                        continue block46;
                    }
                    case 256: {
                        this.cellularSignalStrengthDb = input.readInt32();
                        continue block46;
                    }
                    case 264: {
                        this.isSameRegisteredCell = input.readBool();
                        continue block46;
                    }
                    case 272: 
                }
                value = input.readInt32();
                switch (value) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: {
                        this.deviceMobilityState = value;
                    }
                }
            }
        }

        public static WifiUsabilityStatsEntry parseFrom(byte[] data) throws InvalidProtocolBufferNanoException {
            return MessageNano.mergeFrom(new WifiUsabilityStatsEntry(), data);
        }

        public static WifiUsabilityStatsEntry parseFrom(CodedInputByteBufferNano input) throws IOException {
            return new WifiUsabilityStatsEntry().mergeFrom(input);
        }
    }

    public static final class WifiLinkLayerUsageStats
    extends MessageNano {
        private static volatile WifiLinkLayerUsageStats[] _emptyArray;
        public long loggingDurationMs;
        public long radioOnTimeMs;
        public long radioTxTimeMs;
        public long radioRxTimeMs;
        public long radioScanTimeMs;
        public long radioNanScanTimeMs;
        public long radioBackgroundScanTimeMs;
        public long radioRoamScanTimeMs;
        public long radioPnoScanTimeMs;
        public long radioHs20ScanTimeMs;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static WifiLinkLayerUsageStats[] emptyArray() {
            if (_emptyArray == null) {
                Object object = InternalNano.LAZY_INIT_LOCK;
                synchronized (object) {
                    if (_emptyArray == null) {
                        _emptyArray = new WifiLinkLayerUsageStats[0];
                    }
                }
            }
            return _emptyArray;
        }

        public WifiLinkLayerUsageStats() {
            this.clear();
        }

        public WifiLinkLayerUsageStats clear() {
            this.loggingDurationMs = 0L;
            this.radioOnTimeMs = 0L;
            this.radioTxTimeMs = 0L;
            this.radioRxTimeMs = 0L;
            this.radioScanTimeMs = 0L;
            this.radioNanScanTimeMs = 0L;
            this.radioBackgroundScanTimeMs = 0L;
            this.radioRoamScanTimeMs = 0L;
            this.radioPnoScanTimeMs = 0L;
            this.radioHs20ScanTimeMs = 0L;
            this.cachedSize = -1;
            return this;
        }

        @Override
        public void writeTo(CodedOutputByteBufferNano output) throws IOException {
            if (this.loggingDurationMs != 0L) {
                output.writeInt64(1, this.loggingDurationMs);
            }
            if (this.radioOnTimeMs != 0L) {
                output.writeInt64(2, this.radioOnTimeMs);
            }
            if (this.radioTxTimeMs != 0L) {
                output.writeInt64(3, this.radioTxTimeMs);
            }
            if (this.radioRxTimeMs != 0L) {
                output.writeInt64(4, this.radioRxTimeMs);
            }
            if (this.radioScanTimeMs != 0L) {
                output.writeInt64(5, this.radioScanTimeMs);
            }
            if (this.radioNanScanTimeMs != 0L) {
                output.writeInt64(6, this.radioNanScanTimeMs);
            }
            if (this.radioBackgroundScanTimeMs != 0L) {
                output.writeInt64(7, this.radioBackgroundScanTimeMs);
            }
            if (this.radioRoamScanTimeMs != 0L) {
                output.writeInt64(8, this.radioRoamScanTimeMs);
            }
            if (this.radioPnoScanTimeMs != 0L) {
                output.writeInt64(9, this.radioPnoScanTimeMs);
            }
            if (this.radioHs20ScanTimeMs != 0L) {
                output.writeInt64(10, this.radioHs20ScanTimeMs);
            }
            super.writeTo(output);
        }

        @Override
        protected int computeSerializedSize() {
            int size = super.computeSerializedSize();
            if (this.loggingDurationMs != 0L) {
                size += CodedOutputByteBufferNano.computeInt64Size(1, this.loggingDurationMs);
            }
            if (this.radioOnTimeMs != 0L) {
                size += CodedOutputByteBufferNano.computeInt64Size(2, this.radioOnTimeMs);
            }
            if (this.radioTxTimeMs != 0L) {
                size += CodedOutputByteBufferNano.computeInt64Size(3, this.radioTxTimeMs);
            }
            if (this.radioRxTimeMs != 0L) {
                size += CodedOutputByteBufferNano.computeInt64Size(4, this.radioRxTimeMs);
            }
            if (this.radioScanTimeMs != 0L) {
                size += CodedOutputByteBufferNano.computeInt64Size(5, this.radioScanTimeMs);
            }
            if (this.radioNanScanTimeMs != 0L) {
                size += CodedOutputByteBufferNano.computeInt64Size(6, this.radioNanScanTimeMs);
            }
            if (this.radioBackgroundScanTimeMs != 0L) {
                size += CodedOutputByteBufferNano.computeInt64Size(7, this.radioBackgroundScanTimeMs);
            }
            if (this.radioRoamScanTimeMs != 0L) {
                size += CodedOutputByteBufferNano.computeInt64Size(8, this.radioRoamScanTimeMs);
            }
            if (this.radioPnoScanTimeMs != 0L) {
                size += CodedOutputByteBufferNano.computeInt64Size(9, this.radioPnoScanTimeMs);
            }
            if (this.radioHs20ScanTimeMs != 0L) {
                size += CodedOutputByteBufferNano.computeInt64Size(10, this.radioHs20ScanTimeMs);
            }
            return size;
        }

        @Override
        public WifiLinkLayerUsageStats mergeFrom(CodedInputByteBufferNano input) throws IOException {
            block13: while (true) {
                int tag = input.readTag();
                switch (tag) {
                    case 0: {
                        return this;
                    }
                    default: {
                        if (WireFormatNano.parseUnknownField(input, tag)) continue block13;
                        return this;
                    }
                    case 8: {
                        this.loggingDurationMs = input.readInt64();
                        continue block13;
                    }
                    case 16: {
                        this.radioOnTimeMs = input.readInt64();
                        continue block13;
                    }
                    case 24: {
                        this.radioTxTimeMs = input.readInt64();
                        continue block13;
                    }
                    case 32: {
                        this.radioRxTimeMs = input.readInt64();
                        continue block13;
                    }
                    case 40: {
                        this.radioScanTimeMs = input.readInt64();
                        continue block13;
                    }
                    case 48: {
                        this.radioNanScanTimeMs = input.readInt64();
                        continue block13;
                    }
                    case 56: {
                        this.radioBackgroundScanTimeMs = input.readInt64();
                        continue block13;
                    }
                    case 64: {
                        this.radioRoamScanTimeMs = input.readInt64();
                        continue block13;
                    }
                    case 72: {
                        this.radioPnoScanTimeMs = input.readInt64();
                        continue block13;
                    }
                    case 80: 
                }
                this.radioHs20ScanTimeMs = input.readInt64();
            }
        }

        public static WifiLinkLayerUsageStats parseFrom(byte[] data) throws InvalidProtocolBufferNanoException {
            return MessageNano.mergeFrom(new WifiLinkLayerUsageStats(), data);
        }

        public static WifiLinkLayerUsageStats parseFrom(CodedInputByteBufferNano input) throws IOException {
            return new WifiLinkLayerUsageStats().mergeFrom(input);
        }
    }

    public static final class PasspointProfileTypeCount
    extends MessageNano {
        public static final int TYPE_UNKNOWN = 0;
        public static final int TYPE_EAP_TLS = 1;
        public static final int TYPE_EAP_TTLS = 2;
        public static final int TYPE_EAP_SIM = 3;
        public static final int TYPE_EAP_AKA = 4;
        public static final int TYPE_EAP_AKA_PRIME = 5;
        private static volatile PasspointProfileTypeCount[] _emptyArray;
        public int eapMethodType;
        public int count;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static PasspointProfileTypeCount[] emptyArray() {
            if (_emptyArray == null) {
                Object object = InternalNano.LAZY_INIT_LOCK;
                synchronized (object) {
                    if (_emptyArray == null) {
                        _emptyArray = new PasspointProfileTypeCount[0];
                    }
                }
            }
            return _emptyArray;
        }

        public PasspointProfileTypeCount() {
            this.clear();
        }

        public PasspointProfileTypeCount clear() {
            this.eapMethodType = 0;
            this.count = 0;
            this.cachedSize = -1;
            return this;
        }

        @Override
        public void writeTo(CodedOutputByteBufferNano output) throws IOException {
            if (this.eapMethodType != 0) {
                output.writeInt32(1, this.eapMethodType);
            }
            if (this.count != 0) {
                output.writeInt32(2, this.count);
            }
            super.writeTo(output);
        }

        @Override
        protected int computeSerializedSize() {
            int size = super.computeSerializedSize();
            if (this.eapMethodType != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(1, this.eapMethodType);
            }
            if (this.count != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(2, this.count);
            }
            return size;
        }

        @Override
        public PasspointProfileTypeCount mergeFrom(CodedInputByteBufferNano input) throws IOException {
            block8: while (true) {
                int tag = input.readTag();
                switch (tag) {
                    case 0: {
                        return this;
                    }
                    default: {
                        if (WireFormatNano.parseUnknownField(input, tag)) continue block8;
                        return this;
                    }
                    case 8: {
                        int value = input.readInt32();
                        switch (value) {
                            case 0: 
                            case 1: 
                            case 2: 
                            case 3: 
                            case 4: 
                            case 5: {
                                this.eapMethodType = value;
                            }
                        }
                        continue block8;
                    }
                    case 16: 
                }
                this.count = input.readInt32();
            }
        }

        public static PasspointProfileTypeCount parseFrom(byte[] data) throws InvalidProtocolBufferNanoException {
            return MessageNano.mergeFrom(new PasspointProfileTypeCount(), data);
        }

        public static PasspointProfileTypeCount parseFrom(CodedInputByteBufferNano input) throws IOException {
            return new PasspointProfileTypeCount().mergeFrom(input);
        }
    }

    public static final class WifiIsUnusableEvent
    extends MessageNano {
        public static final int TYPE_UNKNOWN = 0;
        public static final int TYPE_DATA_STALL_BAD_TX = 1;
        public static final int TYPE_DATA_STALL_TX_WITHOUT_RX = 2;
        public static final int TYPE_DATA_STALL_BOTH = 3;
        public static final int TYPE_FIRMWARE_ALERT = 4;
        public static final int TYPE_IP_REACHABILITY_LOST = 5;
        private static volatile WifiIsUnusableEvent[] _emptyArray;
        public int type;
        public long startTimeMillis;
        public int lastScore;
        public long txSuccessDelta;
        public long txRetriesDelta;
        public long txBadDelta;
        public long rxSuccessDelta;
        public long packetUpdateTimeDelta;
        public long lastLinkLayerStatsUpdateTime;
        public int firmwareAlertCode;
        public int lastWifiUsabilityScore;
        public int lastPredictionHorizonSec;
        public boolean screenOn;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static WifiIsUnusableEvent[] emptyArray() {
            if (_emptyArray == null) {
                Object object = InternalNano.LAZY_INIT_LOCK;
                synchronized (object) {
                    if (_emptyArray == null) {
                        _emptyArray = new WifiIsUnusableEvent[0];
                    }
                }
            }
            return _emptyArray;
        }

        public WifiIsUnusableEvent() {
            this.clear();
        }

        public WifiIsUnusableEvent clear() {
            this.type = 0;
            this.startTimeMillis = 0L;
            this.lastScore = -1;
            this.txSuccessDelta = 0L;
            this.txRetriesDelta = 0L;
            this.txBadDelta = 0L;
            this.rxSuccessDelta = 0L;
            this.packetUpdateTimeDelta = 0L;
            this.lastLinkLayerStatsUpdateTime = 0L;
            this.firmwareAlertCode = -1;
            this.lastWifiUsabilityScore = -1;
            this.lastPredictionHorizonSec = -1;
            this.screenOn = false;
            this.cachedSize = -1;
            return this;
        }

        @Override
        public void writeTo(CodedOutputByteBufferNano output) throws IOException {
            if (this.type != 0) {
                output.writeInt32(1, this.type);
            }
            if (this.startTimeMillis != 0L) {
                output.writeInt64(2, this.startTimeMillis);
            }
            if (this.lastScore != -1) {
                output.writeInt32(3, this.lastScore);
            }
            if (this.txSuccessDelta != 0L) {
                output.writeInt64(4, this.txSuccessDelta);
            }
            if (this.txRetriesDelta != 0L) {
                output.writeInt64(5, this.txRetriesDelta);
            }
            if (this.txBadDelta != 0L) {
                output.writeInt64(6, this.txBadDelta);
            }
            if (this.rxSuccessDelta != 0L) {
                output.writeInt64(7, this.rxSuccessDelta);
            }
            if (this.packetUpdateTimeDelta != 0L) {
                output.writeInt64(8, this.packetUpdateTimeDelta);
            }
            if (this.lastLinkLayerStatsUpdateTime != 0L) {
                output.writeInt64(9, this.lastLinkLayerStatsUpdateTime);
            }
            if (this.firmwareAlertCode != -1) {
                output.writeInt32(10, this.firmwareAlertCode);
            }
            if (this.lastWifiUsabilityScore != -1) {
                output.writeInt32(11, this.lastWifiUsabilityScore);
            }
            if (this.lastPredictionHorizonSec != -1) {
                output.writeInt32(12, this.lastPredictionHorizonSec);
            }
            if (this.screenOn) {
                output.writeBool(13, this.screenOn);
            }
            super.writeTo(output);
        }

        @Override
        protected int computeSerializedSize() {
            int size = super.computeSerializedSize();
            if (this.type != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(1, this.type);
            }
            if (this.startTimeMillis != 0L) {
                size += CodedOutputByteBufferNano.computeInt64Size(2, this.startTimeMillis);
            }
            if (this.lastScore != -1) {
                size += CodedOutputByteBufferNano.computeInt32Size(3, this.lastScore);
            }
            if (this.txSuccessDelta != 0L) {
                size += CodedOutputByteBufferNano.computeInt64Size(4, this.txSuccessDelta);
            }
            if (this.txRetriesDelta != 0L) {
                size += CodedOutputByteBufferNano.computeInt64Size(5, this.txRetriesDelta);
            }
            if (this.txBadDelta != 0L) {
                size += CodedOutputByteBufferNano.computeInt64Size(6, this.txBadDelta);
            }
            if (this.rxSuccessDelta != 0L) {
                size += CodedOutputByteBufferNano.computeInt64Size(7, this.rxSuccessDelta);
            }
            if (this.packetUpdateTimeDelta != 0L) {
                size += CodedOutputByteBufferNano.computeInt64Size(8, this.packetUpdateTimeDelta);
            }
            if (this.lastLinkLayerStatsUpdateTime != 0L) {
                size += CodedOutputByteBufferNano.computeInt64Size(9, this.lastLinkLayerStatsUpdateTime);
            }
            if (this.firmwareAlertCode != -1) {
                size += CodedOutputByteBufferNano.computeInt32Size(10, this.firmwareAlertCode);
            }
            if (this.lastWifiUsabilityScore != -1) {
                size += CodedOutputByteBufferNano.computeInt32Size(11, this.lastWifiUsabilityScore);
            }
            if (this.lastPredictionHorizonSec != -1) {
                size += CodedOutputByteBufferNano.computeInt32Size(12, this.lastPredictionHorizonSec);
            }
            if (this.screenOn) {
                size += CodedOutputByteBufferNano.computeBoolSize(13, this.screenOn);
            }
            return size;
        }

        @Override
        public WifiIsUnusableEvent mergeFrom(CodedInputByteBufferNano input) throws IOException {
            block19: while (true) {
                int tag = input.readTag();
                switch (tag) {
                    case 0: {
                        return this;
                    }
                    default: {
                        if (WireFormatNano.parseUnknownField(input, tag)) continue block19;
                        return this;
                    }
                    case 8: {
                        int value = input.readInt32();
                        switch (value) {
                            case 0: 
                            case 1: 
                            case 2: 
                            case 3: 
                            case 4: 
                            case 5: {
                                this.type = value;
                            }
                        }
                        continue block19;
                    }
                    case 16: {
                        this.startTimeMillis = input.readInt64();
                        continue block19;
                    }
                    case 24: {
                        this.lastScore = input.readInt32();
                        continue block19;
                    }
                    case 32: {
                        this.txSuccessDelta = input.readInt64();
                        continue block19;
                    }
                    case 40: {
                        this.txRetriesDelta = input.readInt64();
                        continue block19;
                    }
                    case 48: {
                        this.txBadDelta = input.readInt64();
                        continue block19;
                    }
                    case 56: {
                        this.rxSuccessDelta = input.readInt64();
                        continue block19;
                    }
                    case 64: {
                        this.packetUpdateTimeDelta = input.readInt64();
                        continue block19;
                    }
                    case 72: {
                        this.lastLinkLayerStatsUpdateTime = input.readInt64();
                        continue block19;
                    }
                    case 80: {
                        this.firmwareAlertCode = input.readInt32();
                        continue block19;
                    }
                    case 88: {
                        this.lastWifiUsabilityScore = input.readInt32();
                        continue block19;
                    }
                    case 96: {
                        this.lastPredictionHorizonSec = input.readInt32();
                        continue block19;
                    }
                    case 104: 
                }
                this.screenOn = input.readBool();
            }
        }

        public static WifiIsUnusableEvent parseFrom(byte[] data) throws InvalidProtocolBufferNanoException {
            return MessageNano.mergeFrom(new WifiIsUnusableEvent(), data);
        }

        public static WifiIsUnusableEvent parseFrom(CodedInputByteBufferNano input) throws IOException {
            return new WifiIsUnusableEvent().mergeFrom(input);
        }
    }

    public static final class ExperimentValues
    extends MessageNano {
        private static volatile ExperimentValues[] _emptyArray;
        public boolean wifiIsUnusableLoggingEnabled;
        public int wifiDataStallMinTxBad;
        public int wifiDataStallMinTxSuccessWithoutRx;
        public boolean linkSpeedCountsLoggingEnabled;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static ExperimentValues[] emptyArray() {
            if (_emptyArray == null) {
                Object object = InternalNano.LAZY_INIT_LOCK;
                synchronized (object) {
                    if (_emptyArray == null) {
                        _emptyArray = new ExperimentValues[0];
                    }
                }
            }
            return _emptyArray;
        }

        public ExperimentValues() {
            this.clear();
        }

        public ExperimentValues clear() {
            this.wifiIsUnusableLoggingEnabled = false;
            this.wifiDataStallMinTxBad = 0;
            this.wifiDataStallMinTxSuccessWithoutRx = 0;
            this.linkSpeedCountsLoggingEnabled = false;
            this.cachedSize = -1;
            return this;
        }

        @Override
        public void writeTo(CodedOutputByteBufferNano output) throws IOException {
            if (this.wifiIsUnusableLoggingEnabled) {
                output.writeBool(1, this.wifiIsUnusableLoggingEnabled);
            }
            if (this.wifiDataStallMinTxBad != 0) {
                output.writeInt32(2, this.wifiDataStallMinTxBad);
            }
            if (this.wifiDataStallMinTxSuccessWithoutRx != 0) {
                output.writeInt32(3, this.wifiDataStallMinTxSuccessWithoutRx);
            }
            if (this.linkSpeedCountsLoggingEnabled) {
                output.writeBool(4, this.linkSpeedCountsLoggingEnabled);
            }
            super.writeTo(output);
        }

        @Override
        protected int computeSerializedSize() {
            int size = super.computeSerializedSize();
            if (this.wifiIsUnusableLoggingEnabled) {
                size += CodedOutputByteBufferNano.computeBoolSize(1, this.wifiIsUnusableLoggingEnabled);
            }
            if (this.wifiDataStallMinTxBad != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(2, this.wifiDataStallMinTxBad);
            }
            if (this.wifiDataStallMinTxSuccessWithoutRx != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(3, this.wifiDataStallMinTxSuccessWithoutRx);
            }
            if (this.linkSpeedCountsLoggingEnabled) {
                size += CodedOutputByteBufferNano.computeBoolSize(4, this.linkSpeedCountsLoggingEnabled);
            }
            return size;
        }

        @Override
        public ExperimentValues mergeFrom(CodedInputByteBufferNano input) throws IOException {
            block7: while (true) {
                int tag = input.readTag();
                switch (tag) {
                    case 0: {
                        return this;
                    }
                    default: {
                        if (WireFormatNano.parseUnknownField(input, tag)) continue block7;
                        return this;
                    }
                    case 8: {
                        this.wifiIsUnusableLoggingEnabled = input.readBool();
                        continue block7;
                    }
                    case 16: {
                        this.wifiDataStallMinTxBad = input.readInt32();
                        continue block7;
                    }
                    case 24: {
                        this.wifiDataStallMinTxSuccessWithoutRx = input.readInt32();
                        continue block7;
                    }
                    case 32: 
                }
                this.linkSpeedCountsLoggingEnabled = input.readBool();
            }
        }

        public static ExperimentValues parseFrom(byte[] data) throws InvalidProtocolBufferNanoException {
            return MessageNano.mergeFrom(new ExperimentValues(), data);
        }

        public static ExperimentValues parseFrom(CodedInputByteBufferNano input) throws IOException {
            return new ExperimentValues().mergeFrom(input);
        }
    }

    public static final class WifiRadioUsage
    extends MessageNano {
        private static volatile WifiRadioUsage[] _emptyArray;
        public long loggingDurationMs;
        public long scanTimeMs;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static WifiRadioUsage[] emptyArray() {
            if (_emptyArray == null) {
                Object object = InternalNano.LAZY_INIT_LOCK;
                synchronized (object) {
                    if (_emptyArray == null) {
                        _emptyArray = new WifiRadioUsage[0];
                    }
                }
            }
            return _emptyArray;
        }

        public WifiRadioUsage() {
            this.clear();
        }

        public WifiRadioUsage clear() {
            this.loggingDurationMs = 0L;
            this.scanTimeMs = 0L;
            this.cachedSize = -1;
            return this;
        }

        @Override
        public void writeTo(CodedOutputByteBufferNano output) throws IOException {
            if (this.loggingDurationMs != 0L) {
                output.writeInt64(1, this.loggingDurationMs);
            }
            if (this.scanTimeMs != 0L) {
                output.writeInt64(2, this.scanTimeMs);
            }
            super.writeTo(output);
        }

        @Override
        protected int computeSerializedSize() {
            int size = super.computeSerializedSize();
            if (this.loggingDurationMs != 0L) {
                size += CodedOutputByteBufferNano.computeInt64Size(1, this.loggingDurationMs);
            }
            if (this.scanTimeMs != 0L) {
                size += CodedOutputByteBufferNano.computeInt64Size(2, this.scanTimeMs);
            }
            return size;
        }

        @Override
        public WifiRadioUsage mergeFrom(CodedInputByteBufferNano input) throws IOException {
            block5: while (true) {
                int tag = input.readTag();
                switch (tag) {
                    case 0: {
                        return this;
                    }
                    default: {
                        if (WireFormatNano.parseUnknownField(input, tag)) continue block5;
                        return this;
                    }
                    case 8: {
                        this.loggingDurationMs = input.readInt64();
                        continue block5;
                    }
                    case 16: 
                }
                this.scanTimeMs = input.readInt64();
            }
        }

        public static WifiRadioUsage parseFrom(byte[] data) throws InvalidProtocolBufferNanoException {
            return MessageNano.mergeFrom(new WifiRadioUsage(), data);
        }

        public static WifiRadioUsage parseFrom(CodedInputByteBufferNano input) throws IOException {
            return new WifiRadioUsage().mergeFrom(input);
        }
    }

    public static final class WifiRttLog
    extends MessageNano {
        public static final int OVERALL_UNKNOWN = 0;
        public static final int OVERALL_SUCCESS = 1;
        public static final int OVERALL_FAIL = 2;
        public static final int OVERALL_RTT_NOT_AVAILABLE = 3;
        public static final int OVERALL_TIMEOUT = 4;
        public static final int OVERALL_THROTTLE = 5;
        public static final int OVERALL_HAL_FAILURE = 6;
        public static final int OVERALL_AWARE_TRANSLATION_FAILURE = 7;
        public static final int OVERALL_LOCATION_PERMISSION_MISSING = 8;
        public static final int UNKNOWN = 0;
        public static final int SUCCESS = 1;
        public static final int FAILURE = 2;
        public static final int FAIL_NO_RSP = 3;
        public static final int FAIL_REJECTED = 4;
        public static final int FAIL_NOT_SCHEDULED_YET = 5;
        public static final int FAIL_TM_TIMEOUT = 6;
        public static final int FAIL_AP_ON_DIFF_CHANNEL = 7;
        public static final int FAIL_NO_CAPABILITY = 8;
        public static final int ABORTED = 9;
        public static final int FAIL_INVALID_TS = 10;
        public static final int FAIL_PROTOCOL = 11;
        public static final int FAIL_SCHEDULE = 12;
        public static final int FAIL_BUSY_TRY_LATER = 13;
        public static final int INVALID_REQ = 14;
        public static final int NO_WIFI = 15;
        public static final int FAIL_FTM_PARAM_OVERRIDE = 16;
        public static final int MISSING_RESULT = 17;
        private static volatile WifiRttLog[] _emptyArray;
        public int numRequests;
        public RttOverallStatusHistogramBucket[] histogramOverallStatus;
        public RttToPeerLog rttToAp;
        public RttToPeerLog rttToAware;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static WifiRttLog[] emptyArray() {
            if (_emptyArray == null) {
                Object object = InternalNano.LAZY_INIT_LOCK;
                synchronized (object) {
                    if (_emptyArray == null) {
                        _emptyArray = new WifiRttLog[0];
                    }
                }
            }
            return _emptyArray;
        }

        public WifiRttLog() {
            this.clear();
        }

        public WifiRttLog clear() {
            this.numRequests = 0;
            this.histogramOverallStatus = RttOverallStatusHistogramBucket.emptyArray();
            this.rttToAp = null;
            this.rttToAware = null;
            this.cachedSize = -1;
            return this;
        }

        @Override
        public void writeTo(CodedOutputByteBufferNano output) throws IOException {
            if (this.numRequests != 0) {
                output.writeInt32(1, this.numRequests);
            }
            if (this.histogramOverallStatus != null && this.histogramOverallStatus.length > 0) {
                for (int i = 0; i < this.histogramOverallStatus.length; ++i) {
                    RttOverallStatusHistogramBucket element = this.histogramOverallStatus[i];
                    if (element == null) continue;
                    output.writeMessage(2, element);
                }
            }
            if (this.rttToAp != null) {
                output.writeMessage(3, this.rttToAp);
            }
            if (this.rttToAware != null) {
                output.writeMessage(4, this.rttToAware);
            }
            super.writeTo(output);
        }

        @Override
        protected int computeSerializedSize() {
            int size = super.computeSerializedSize();
            if (this.numRequests != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(1, this.numRequests);
            }
            if (this.histogramOverallStatus != null && this.histogramOverallStatus.length > 0) {
                for (int i = 0; i < this.histogramOverallStatus.length; ++i) {
                    RttOverallStatusHistogramBucket element = this.histogramOverallStatus[i];
                    if (element == null) continue;
                    size += CodedOutputByteBufferNano.computeMessageSize(2, element);
                }
            }
            if (this.rttToAp != null) {
                size += CodedOutputByteBufferNano.computeMessageSize(3, this.rttToAp);
            }
            if (this.rttToAware != null) {
                size += CodedOutputByteBufferNano.computeMessageSize(4, this.rttToAware);
            }
            return size;
        }

        @Override
        public WifiRttLog mergeFrom(CodedInputByteBufferNano input) throws IOException {
            block7: while (true) {
                int tag = input.readTag();
                switch (tag) {
                    case 0: {
                        return this;
                    }
                    default: {
                        if (WireFormatNano.parseUnknownField(input, tag)) continue block7;
                        return this;
                    }
                    case 8: {
                        this.numRequests = input.readInt32();
                        continue block7;
                    }
                    case 18: {
                        int arrayLength = WireFormatNano.getRepeatedFieldArrayLength(input, 18);
                        int i = this.histogramOverallStatus == null ? 0 : this.histogramOverallStatus.length;
                        RttOverallStatusHistogramBucket[] newArray = new RttOverallStatusHistogramBucket[i + arrayLength];
                        if (i != 0) {
                            System.arraycopy(this.histogramOverallStatus, 0, newArray, 0, i);
                        }
                        while (i < newArray.length - 1) {
                            newArray[i] = new RttOverallStatusHistogramBucket();
                            input.readMessage(newArray[i]);
                            input.readTag();
                            ++i;
                        }
                        newArray[i] = new RttOverallStatusHistogramBucket();
                        input.readMessage(newArray[i]);
                        this.histogramOverallStatus = newArray;
                        continue block7;
                    }
                    case 26: {
                        if (this.rttToAp == null) {
                            this.rttToAp = new RttToPeerLog();
                        }
                        input.readMessage(this.rttToAp);
                        continue block7;
                    }
                    case 34: 
                }
                if (this.rttToAware == null) {
                    this.rttToAware = new RttToPeerLog();
                }
                input.readMessage(this.rttToAware);
            }
        }

        public static WifiRttLog parseFrom(byte[] data) throws InvalidProtocolBufferNanoException {
            return MessageNano.mergeFrom(new WifiRttLog(), data);
        }

        public static WifiRttLog parseFrom(CodedInputByteBufferNano input) throws IOException {
            return new WifiRttLog().mergeFrom(input);
        }

        public static final class RttIndividualStatusHistogramBucket
        extends MessageNano {
            private static volatile RttIndividualStatusHistogramBucket[] _emptyArray;
            public int statusType;
            public int count;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public static RttIndividualStatusHistogramBucket[] emptyArray() {
                if (_emptyArray == null) {
                    Object object = InternalNano.LAZY_INIT_LOCK;
                    synchronized (object) {
                        if (_emptyArray == null) {
                            _emptyArray = new RttIndividualStatusHistogramBucket[0];
                        }
                    }
                }
                return _emptyArray;
            }

            public RttIndividualStatusHistogramBucket() {
                this.clear();
            }

            public RttIndividualStatusHistogramBucket clear() {
                this.statusType = 0;
                this.count = 0;
                this.cachedSize = -1;
                return this;
            }

            @Override
            public void writeTo(CodedOutputByteBufferNano output) throws IOException {
                if (this.statusType != 0) {
                    output.writeInt32(1, this.statusType);
                }
                if (this.count != 0) {
                    output.writeInt32(2, this.count);
                }
                super.writeTo(output);
            }

            @Override
            protected int computeSerializedSize() {
                int size = super.computeSerializedSize();
                if (this.statusType != 0) {
                    size += CodedOutputByteBufferNano.computeInt32Size(1, this.statusType);
                }
                if (this.count != 0) {
                    size += CodedOutputByteBufferNano.computeInt32Size(2, this.count);
                }
                return size;
            }

            @Override
            public RttIndividualStatusHistogramBucket mergeFrom(CodedInputByteBufferNano input) throws IOException {
                block8: while (true) {
                    int tag = input.readTag();
                    switch (tag) {
                        case 0: {
                            return this;
                        }
                        default: {
                            if (WireFormatNano.parseUnknownField(input, tag)) continue block8;
                            return this;
                        }
                        case 8: {
                            int value = input.readInt32();
                            switch (value) {
                                case 0: 
                                case 1: 
                                case 2: 
                                case 3: 
                                case 4: 
                                case 5: 
                                case 6: 
                                case 7: 
                                case 8: 
                                case 9: 
                                case 10: 
                                case 11: 
                                case 12: 
                                case 13: 
                                case 14: 
                                case 15: 
                                case 16: 
                                case 17: {
                                    this.statusType = value;
                                }
                            }
                            continue block8;
                        }
                        case 16: 
                    }
                    this.count = input.readInt32();
                }
            }

            public static RttIndividualStatusHistogramBucket parseFrom(byte[] data) throws InvalidProtocolBufferNanoException {
                return MessageNano.mergeFrom(new RttIndividualStatusHistogramBucket(), data);
            }

            public static RttIndividualStatusHistogramBucket parseFrom(CodedInputByteBufferNano input) throws IOException {
                return new RttIndividualStatusHistogramBucket().mergeFrom(input);
            }
        }

        public static final class RttOverallStatusHistogramBucket
        extends MessageNano {
            private static volatile RttOverallStatusHistogramBucket[] _emptyArray;
            public int statusType;
            public int count;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public static RttOverallStatusHistogramBucket[] emptyArray() {
                if (_emptyArray == null) {
                    Object object = InternalNano.LAZY_INIT_LOCK;
                    synchronized (object) {
                        if (_emptyArray == null) {
                            _emptyArray = new RttOverallStatusHistogramBucket[0];
                        }
                    }
                }
                return _emptyArray;
            }

            public RttOverallStatusHistogramBucket() {
                this.clear();
            }

            public RttOverallStatusHistogramBucket clear() {
                this.statusType = 0;
                this.count = 0;
                this.cachedSize = -1;
                return this;
            }

            @Override
            public void writeTo(CodedOutputByteBufferNano output) throws IOException {
                if (this.statusType != 0) {
                    output.writeInt32(1, this.statusType);
                }
                if (this.count != 0) {
                    output.writeInt32(2, this.count);
                }
                super.writeTo(output);
            }

            @Override
            protected int computeSerializedSize() {
                int size = super.computeSerializedSize();
                if (this.statusType != 0) {
                    size += CodedOutputByteBufferNano.computeInt32Size(1, this.statusType);
                }
                if (this.count != 0) {
                    size += CodedOutputByteBufferNano.computeInt32Size(2, this.count);
                }
                return size;
            }

            @Override
            public RttOverallStatusHistogramBucket mergeFrom(CodedInputByteBufferNano input) throws IOException {
                block8: while (true) {
                    int tag = input.readTag();
                    switch (tag) {
                        case 0: {
                            return this;
                        }
                        default: {
                            if (WireFormatNano.parseUnknownField(input, tag)) continue block8;
                            return this;
                        }
                        case 8: {
                            int value = input.readInt32();
                            switch (value) {
                                case 0: 
                                case 1: 
                                case 2: 
                                case 3: 
                                case 4: 
                                case 5: 
                                case 6: 
                                case 7: 
                                case 8: {
                                    this.statusType = value;
                                }
                            }
                            continue block8;
                        }
                        case 16: 
                    }
                    this.count = input.readInt32();
                }
            }

            public static RttOverallStatusHistogramBucket parseFrom(byte[] data) throws InvalidProtocolBufferNanoException {
                return MessageNano.mergeFrom(new RttOverallStatusHistogramBucket(), data);
            }

            public static RttOverallStatusHistogramBucket parseFrom(CodedInputByteBufferNano input) throws IOException {
                return new RttOverallStatusHistogramBucket().mergeFrom(input);
            }
        }

        public static final class HistogramBucket
        extends MessageNano {
            private static volatile HistogramBucket[] _emptyArray;
            public long start;
            public long end;
            public int count;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public static HistogramBucket[] emptyArray() {
                if (_emptyArray == null) {
                    Object object = InternalNano.LAZY_INIT_LOCK;
                    synchronized (object) {
                        if (_emptyArray == null) {
                            _emptyArray = new HistogramBucket[0];
                        }
                    }
                }
                return _emptyArray;
            }

            public HistogramBucket() {
                this.clear();
            }

            public HistogramBucket clear() {
                this.start = 0L;
                this.end = 0L;
                this.count = 0;
                this.cachedSize = -1;
                return this;
            }

            @Override
            public void writeTo(CodedOutputByteBufferNano output) throws IOException {
                if (this.start != 0L) {
                    output.writeInt64(1, this.start);
                }
                if (this.end != 0L) {
                    output.writeInt64(2, this.end);
                }
                if (this.count != 0) {
                    output.writeInt32(3, this.count);
                }
                super.writeTo(output);
            }

            @Override
            protected int computeSerializedSize() {
                int size = super.computeSerializedSize();
                if (this.start != 0L) {
                    size += CodedOutputByteBufferNano.computeInt64Size(1, this.start);
                }
                if (this.end != 0L) {
                    size += CodedOutputByteBufferNano.computeInt64Size(2, this.end);
                }
                if (this.count != 0) {
                    size += CodedOutputByteBufferNano.computeInt32Size(3, this.count);
                }
                return size;
            }

            @Override
            public HistogramBucket mergeFrom(CodedInputByteBufferNano input) throws IOException {
                block6: while (true) {
                    int tag = input.readTag();
                    switch (tag) {
                        case 0: {
                            return this;
                        }
                        default: {
                            if (WireFormatNano.parseUnknownField(input, tag)) continue block6;
                            return this;
                        }
                        case 8: {
                            this.start = input.readInt64();
                            continue block6;
                        }
                        case 16: {
                            this.end = input.readInt64();
                            continue block6;
                        }
                        case 24: 
                    }
                    this.count = input.readInt32();
                }
            }

            public static HistogramBucket parseFrom(byte[] data) throws InvalidProtocolBufferNanoException {
                return MessageNano.mergeFrom(new HistogramBucket(), data);
            }

            public static HistogramBucket parseFrom(CodedInputByteBufferNano input) throws IOException {
                return new HistogramBucket().mergeFrom(input);
            }
        }

        public static final class RttToPeerLog
        extends MessageNano {
            private static volatile RttToPeerLog[] _emptyArray;
            public int numRequests;
            public int numIndividualRequests;
            public int numApps;
            public HistogramBucket[] histogramNumRequestsPerApp;
            public HistogramBucket[] histogramNumPeersPerRequest;
            public RttIndividualStatusHistogramBucket[] histogramIndividualStatus;
            public HistogramBucket[] histogramDistance;
            public HistogramBucket[] histogramRequestIntervalMs;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public static RttToPeerLog[] emptyArray() {
                if (_emptyArray == null) {
                    Object object = InternalNano.LAZY_INIT_LOCK;
                    synchronized (object) {
                        if (_emptyArray == null) {
                            _emptyArray = new RttToPeerLog[0];
                        }
                    }
                }
                return _emptyArray;
            }

            public RttToPeerLog() {
                this.clear();
            }

            public RttToPeerLog clear() {
                this.numRequests = 0;
                this.numIndividualRequests = 0;
                this.numApps = 0;
                this.histogramNumRequestsPerApp = HistogramBucket.emptyArray();
                this.histogramNumPeersPerRequest = HistogramBucket.emptyArray();
                this.histogramIndividualStatus = RttIndividualStatusHistogramBucket.emptyArray();
                this.histogramDistance = HistogramBucket.emptyArray();
                this.histogramRequestIntervalMs = HistogramBucket.emptyArray();
                this.cachedSize = -1;
                return this;
            }

            @Override
            public void writeTo(CodedOutputByteBufferNano output) throws IOException {
                MessageNano element;
                int i;
                if (this.numRequests != 0) {
                    output.writeInt32(1, this.numRequests);
                }
                if (this.numIndividualRequests != 0) {
                    output.writeInt32(2, this.numIndividualRequests);
                }
                if (this.numApps != 0) {
                    output.writeInt32(3, this.numApps);
                }
                if (this.histogramNumRequestsPerApp != null && this.histogramNumRequestsPerApp.length > 0) {
                    for (i = 0; i < this.histogramNumRequestsPerApp.length; ++i) {
                        element = this.histogramNumRequestsPerApp[i];
                        if (element == null) continue;
                        output.writeMessage(4, element);
                    }
                }
                if (this.histogramNumPeersPerRequest != null && this.histogramNumPeersPerRequest.length > 0) {
                    for (i = 0; i < this.histogramNumPeersPerRequest.length; ++i) {
                        element = this.histogramNumPeersPerRequest[i];
                        if (element == null) continue;
                        output.writeMessage(5, element);
                    }
                }
                if (this.histogramIndividualStatus != null && this.histogramIndividualStatus.length > 0) {
                    for (i = 0; i < this.histogramIndividualStatus.length; ++i) {
                        element = this.histogramIndividualStatus[i];
                        if (element == null) continue;
                        output.writeMessage(6, element);
                    }
                }
                if (this.histogramDistance != null && this.histogramDistance.length > 0) {
                    for (i = 0; i < this.histogramDistance.length; ++i) {
                        element = this.histogramDistance[i];
                        if (element == null) continue;
                        output.writeMessage(7, element);
                    }
                }
                if (this.histogramRequestIntervalMs != null && this.histogramRequestIntervalMs.length > 0) {
                    for (i = 0; i < this.histogramRequestIntervalMs.length; ++i) {
                        element = this.histogramRequestIntervalMs[i];
                        if (element == null) continue;
                        output.writeMessage(8, element);
                    }
                }
                super.writeTo(output);
            }

            @Override
            protected int computeSerializedSize() {
                MessageNano element;
                int i;
                int size = super.computeSerializedSize();
                if (this.numRequests != 0) {
                    size += CodedOutputByteBufferNano.computeInt32Size(1, this.numRequests);
                }
                if (this.numIndividualRequests != 0) {
                    size += CodedOutputByteBufferNano.computeInt32Size(2, this.numIndividualRequests);
                }
                if (this.numApps != 0) {
                    size += CodedOutputByteBufferNano.computeInt32Size(3, this.numApps);
                }
                if (this.histogramNumRequestsPerApp != null && this.histogramNumRequestsPerApp.length > 0) {
                    for (i = 0; i < this.histogramNumRequestsPerApp.length; ++i) {
                        element = this.histogramNumRequestsPerApp[i];
                        if (element == null) continue;
                        size += CodedOutputByteBufferNano.computeMessageSize(4, element);
                    }
                }
                if (this.histogramNumPeersPerRequest != null && this.histogramNumPeersPerRequest.length > 0) {
                    for (i = 0; i < this.histogramNumPeersPerRequest.length; ++i) {
                        element = this.histogramNumPeersPerRequest[i];
                        if (element == null) continue;
                        size += CodedOutputByteBufferNano.computeMessageSize(5, element);
                    }
                }
                if (this.histogramIndividualStatus != null && this.histogramIndividualStatus.length > 0) {
                    for (i = 0; i < this.histogramIndividualStatus.length; ++i) {
                        element = this.histogramIndividualStatus[i];
                        if (element == null) continue;
                        size += CodedOutputByteBufferNano.computeMessageSize(6, element);
                    }
                }
                if (this.histogramDistance != null && this.histogramDistance.length > 0) {
                    for (i = 0; i < this.histogramDistance.length; ++i) {
                        element = this.histogramDistance[i];
                        if (element == null) continue;
                        size += CodedOutputByteBufferNano.computeMessageSize(7, element);
                    }
                }
                if (this.histogramRequestIntervalMs != null && this.histogramRequestIntervalMs.length > 0) {
                    for (i = 0; i < this.histogramRequestIntervalMs.length; ++i) {
                        element = this.histogramRequestIntervalMs[i];
                        if (element == null) continue;
                        size += CodedOutputByteBufferNano.computeMessageSize(8, element);
                    }
                }
                return size;
            }

            @Override
            public RttToPeerLog mergeFrom(CodedInputByteBufferNano input) throws IOException {
                block11: while (true) {
                    MessageNano[] newArray;
                    int i;
                    int arrayLength;
                    int tag = input.readTag();
                    switch (tag) {
                        case 0: {
                            return this;
                        }
                        default: {
                            if (WireFormatNano.parseUnknownField(input, tag)) continue block11;
                            return this;
                        }
                        case 8: {
                            this.numRequests = input.readInt32();
                            continue block11;
                        }
                        case 16: {
                            this.numIndividualRequests = input.readInt32();
                            continue block11;
                        }
                        case 24: {
                            this.numApps = input.readInt32();
                            continue block11;
                        }
                        case 34: {
                            arrayLength = WireFormatNano.getRepeatedFieldArrayLength(input, 34);
                            i = this.histogramNumRequestsPerApp == null ? 0 : this.histogramNumRequestsPerApp.length;
                            newArray = new HistogramBucket[i + arrayLength];
                            if (i != 0) {
                                System.arraycopy(this.histogramNumRequestsPerApp, 0, newArray, 0, i);
                            }
                            while (i < newArray.length - 1) {
                                newArray[i] = new HistogramBucket();
                                input.readMessage(newArray[i]);
                                input.readTag();
                                ++i;
                            }
                            newArray[i] = new HistogramBucket();
                            input.readMessage(newArray[i]);
                            this.histogramNumRequestsPerApp = newArray;
                            continue block11;
                        }
                        case 42: {
                            arrayLength = WireFormatNano.getRepeatedFieldArrayLength(input, 42);
                            i = this.histogramNumPeersPerRequest == null ? 0 : this.histogramNumPeersPerRequest.length;
                            newArray = new HistogramBucket[i + arrayLength];
                            if (i != 0) {
                                System.arraycopy(this.histogramNumPeersPerRequest, 0, newArray, 0, i);
                            }
                            while (i < newArray.length - 1) {
                                newArray[i] = new HistogramBucket();
                                input.readMessage(newArray[i]);
                                input.readTag();
                                ++i;
                            }
                            newArray[i] = new HistogramBucket();
                            input.readMessage(newArray[i]);
                            this.histogramNumPeersPerRequest = newArray;
                            continue block11;
                        }
                        case 50: {
                            arrayLength = WireFormatNano.getRepeatedFieldArrayLength(input, 50);
                            i = this.histogramIndividualStatus == null ? 0 : this.histogramIndividualStatus.length;
                            newArray = new RttIndividualStatusHistogramBucket[i + arrayLength];
                            if (i != 0) {
                                System.arraycopy(this.histogramIndividualStatus, 0, newArray, 0, i);
                            }
                            while (i < newArray.length - 1) {
                                newArray[i] = new RttIndividualStatusHistogramBucket();
                                input.readMessage(newArray[i]);
                                input.readTag();
                                ++i;
                            }
                            newArray[i] = new RttIndividualStatusHistogramBucket();
                            input.readMessage(newArray[i]);
                            this.histogramIndividualStatus = newArray;
                            continue block11;
                        }
                        case 58: {
                            arrayLength = WireFormatNano.getRepeatedFieldArrayLength(input, 58);
                            i = this.histogramDistance == null ? 0 : this.histogramDistance.length;
                            newArray = new HistogramBucket[i + arrayLength];
                            if (i != 0) {
                                System.arraycopy(this.histogramDistance, 0, newArray, 0, i);
                            }
                            while (i < newArray.length - 1) {
                                newArray[i] = new HistogramBucket();
                                input.readMessage(newArray[i]);
                                input.readTag();
                                ++i;
                            }
                            newArray[i] = new HistogramBucket();
                            input.readMessage(newArray[i]);
                            this.histogramDistance = newArray;
                            continue block11;
                        }
                        case 66: 
                    }
                    arrayLength = WireFormatNano.getRepeatedFieldArrayLength(input, 66);
                    i = this.histogramRequestIntervalMs == null ? 0 : this.histogramRequestIntervalMs.length;
                    newArray = new HistogramBucket[i + arrayLength];
                    if (i != 0) {
                        System.arraycopy(this.histogramRequestIntervalMs, 0, newArray, 0, i);
                    }
                    while (i < newArray.length - 1) {
                        newArray[i] = new HistogramBucket();
                        input.readMessage(newArray[i]);
                        input.readTag();
                        ++i;
                    }
                    newArray[i] = new HistogramBucket();
                    input.readMessage(newArray[i]);
                    this.histogramRequestIntervalMs = newArray;
                }
            }

            public static RttToPeerLog parseFrom(byte[] data) throws InvalidProtocolBufferNanoException {
                return MessageNano.mergeFrom(new RttToPeerLog(), data);
            }

            public static RttToPeerLog parseFrom(CodedInputByteBufferNano input) throws IOException {
                return new RttToPeerLog().mergeFrom(input);
            }
        }
    }

    public static final class WifiWakeStats
    extends MessageNano {
        private static volatile WifiWakeStats[] _emptyArray;
        public int numSessions;
        public Session[] sessions;
        public int numIgnoredStarts;
        public int numWakeups;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static WifiWakeStats[] emptyArray() {
            if (_emptyArray == null) {
                Object object = InternalNano.LAZY_INIT_LOCK;
                synchronized (object) {
                    if (_emptyArray == null) {
                        _emptyArray = new WifiWakeStats[0];
                    }
                }
            }
            return _emptyArray;
        }

        public WifiWakeStats() {
            this.clear();
        }

        public WifiWakeStats clear() {
            this.numSessions = 0;
            this.sessions = Session.emptyArray();
            this.numIgnoredStarts = 0;
            this.numWakeups = 0;
            this.cachedSize = -1;
            return this;
        }

        @Override
        public void writeTo(CodedOutputByteBufferNano output) throws IOException {
            if (this.numSessions != 0) {
                output.writeInt32(1, this.numSessions);
            }
            if (this.sessions != null && this.sessions.length > 0) {
                for (int i = 0; i < this.sessions.length; ++i) {
                    Session element = this.sessions[i];
                    if (element == null) continue;
                    output.writeMessage(2, element);
                }
            }
            if (this.numIgnoredStarts != 0) {
                output.writeInt32(3, this.numIgnoredStarts);
            }
            if (this.numWakeups != 0) {
                output.writeInt32(4, this.numWakeups);
            }
            super.writeTo(output);
        }

        @Override
        protected int computeSerializedSize() {
            int size = super.computeSerializedSize();
            if (this.numSessions != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(1, this.numSessions);
            }
            if (this.sessions != null && this.sessions.length > 0) {
                for (int i = 0; i < this.sessions.length; ++i) {
                    Session element = this.sessions[i];
                    if (element == null) continue;
                    size += CodedOutputByteBufferNano.computeMessageSize(2, element);
                }
            }
            if (this.numIgnoredStarts != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(3, this.numIgnoredStarts);
            }
            if (this.numWakeups != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(4, this.numWakeups);
            }
            return size;
        }

        @Override
        public WifiWakeStats mergeFrom(CodedInputByteBufferNano input) throws IOException {
            block7: while (true) {
                int tag = input.readTag();
                switch (tag) {
                    case 0: {
                        return this;
                    }
                    default: {
                        if (WireFormatNano.parseUnknownField(input, tag)) continue block7;
                        return this;
                    }
                    case 8: {
                        this.numSessions = input.readInt32();
                        continue block7;
                    }
                    case 18: {
                        int arrayLength = WireFormatNano.getRepeatedFieldArrayLength(input, 18);
                        int i = this.sessions == null ? 0 : this.sessions.length;
                        Session[] newArray = new Session[i + arrayLength];
                        if (i != 0) {
                            System.arraycopy(this.sessions, 0, newArray, 0, i);
                        }
                        while (i < newArray.length - 1) {
                            newArray[i] = new Session();
                            input.readMessage(newArray[i]);
                            input.readTag();
                            ++i;
                        }
                        newArray[i] = new Session();
                        input.readMessage(newArray[i]);
                        this.sessions = newArray;
                        continue block7;
                    }
                    case 24: {
                        this.numIgnoredStarts = input.readInt32();
                        continue block7;
                    }
                    case 32: 
                }
                this.numWakeups = input.readInt32();
            }
        }

        public static WifiWakeStats parseFrom(byte[] data) throws InvalidProtocolBufferNanoException {
            return MessageNano.mergeFrom(new WifiWakeStats(), data);
        }

        public static WifiWakeStats parseFrom(CodedInputByteBufferNano input) throws IOException {
            return new WifiWakeStats().mergeFrom(input);
        }

        public static final class Session
        extends MessageNano {
            private static volatile Session[] _emptyArray;
            public long startTimeMillis;
            public int lockedNetworksAtStart;
            public int lockedNetworksAtInitialize;
            public Event initializeEvent;
            public Event unlockEvent;
            public Event wakeupEvent;
            public Event resetEvent;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public static Session[] emptyArray() {
                if (_emptyArray == null) {
                    Object object = InternalNano.LAZY_INIT_LOCK;
                    synchronized (object) {
                        if (_emptyArray == null) {
                            _emptyArray = new Session[0];
                        }
                    }
                }
                return _emptyArray;
            }

            public Session() {
                this.clear();
            }

            public Session clear() {
                this.startTimeMillis = 0L;
                this.lockedNetworksAtStart = 0;
                this.lockedNetworksAtInitialize = 0;
                this.initializeEvent = null;
                this.unlockEvent = null;
                this.wakeupEvent = null;
                this.resetEvent = null;
                this.cachedSize = -1;
                return this;
            }

            @Override
            public void writeTo(CodedOutputByteBufferNano output) throws IOException {
                if (this.startTimeMillis != 0L) {
                    output.writeInt64(1, this.startTimeMillis);
                }
                if (this.lockedNetworksAtStart != 0) {
                    output.writeInt32(2, this.lockedNetworksAtStart);
                }
                if (this.unlockEvent != null) {
                    output.writeMessage(3, this.unlockEvent);
                }
                if (this.wakeupEvent != null) {
                    output.writeMessage(4, this.wakeupEvent);
                }
                if (this.resetEvent != null) {
                    output.writeMessage(5, this.resetEvent);
                }
                if (this.lockedNetworksAtInitialize != 0) {
                    output.writeInt32(6, this.lockedNetworksAtInitialize);
                }
                if (this.initializeEvent != null) {
                    output.writeMessage(7, this.initializeEvent);
                }
                super.writeTo(output);
            }

            @Override
            protected int computeSerializedSize() {
                int size = super.computeSerializedSize();
                if (this.startTimeMillis != 0L) {
                    size += CodedOutputByteBufferNano.computeInt64Size(1, this.startTimeMillis);
                }
                if (this.lockedNetworksAtStart != 0) {
                    size += CodedOutputByteBufferNano.computeInt32Size(2, this.lockedNetworksAtStart);
                }
                if (this.unlockEvent != null) {
                    size += CodedOutputByteBufferNano.computeMessageSize(3, this.unlockEvent);
                }
                if (this.wakeupEvent != null) {
                    size += CodedOutputByteBufferNano.computeMessageSize(4, this.wakeupEvent);
                }
                if (this.resetEvent != null) {
                    size += CodedOutputByteBufferNano.computeMessageSize(5, this.resetEvent);
                }
                if (this.lockedNetworksAtInitialize != 0) {
                    size += CodedOutputByteBufferNano.computeInt32Size(6, this.lockedNetworksAtInitialize);
                }
                if (this.initializeEvent != null) {
                    size += CodedOutputByteBufferNano.computeMessageSize(7, this.initializeEvent);
                }
                return size;
            }

            @Override
            public Session mergeFrom(CodedInputByteBufferNano input) throws IOException {
                block10: while (true) {
                    int tag = input.readTag();
                    switch (tag) {
                        case 0: {
                            return this;
                        }
                        default: {
                            if (WireFormatNano.parseUnknownField(input, tag)) continue block10;
                            return this;
                        }
                        case 8: {
                            this.startTimeMillis = input.readInt64();
                            continue block10;
                        }
                        case 16: {
                            this.lockedNetworksAtStart = input.readInt32();
                            continue block10;
                        }
                        case 26: {
                            if (this.unlockEvent == null) {
                                this.unlockEvent = new Event();
                            }
                            input.readMessage(this.unlockEvent);
                            continue block10;
                        }
                        case 34: {
                            if (this.wakeupEvent == null) {
                                this.wakeupEvent = new Event();
                            }
                            input.readMessage(this.wakeupEvent);
                            continue block10;
                        }
                        case 42: {
                            if (this.resetEvent == null) {
                                this.resetEvent = new Event();
                            }
                            input.readMessage(this.resetEvent);
                            continue block10;
                        }
                        case 48: {
                            this.lockedNetworksAtInitialize = input.readInt32();
                            continue block10;
                        }
                        case 58: 
                    }
                    if (this.initializeEvent == null) {
                        this.initializeEvent = new Event();
                    }
                    input.readMessage(this.initializeEvent);
                }
            }

            public static Session parseFrom(byte[] data) throws InvalidProtocolBufferNanoException {
                return MessageNano.mergeFrom(new Session(), data);
            }

            public static Session parseFrom(CodedInputByteBufferNano input) throws IOException {
                return new Session().mergeFrom(input);
            }

            public static final class Event
            extends MessageNano {
                private static volatile Event[] _emptyArray;
                public long elapsedTimeMillis;
                public int elapsedScans;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public static Event[] emptyArray() {
                    if (_emptyArray == null) {
                        Object object = InternalNano.LAZY_INIT_LOCK;
                        synchronized (object) {
                            if (_emptyArray == null) {
                                _emptyArray = new Event[0];
                            }
                        }
                    }
                    return _emptyArray;
                }

                public Event() {
                    this.clear();
                }

                public Event clear() {
                    this.elapsedTimeMillis = 0L;
                    this.elapsedScans = 0;
                    this.cachedSize = -1;
                    return this;
                }

                @Override
                public void writeTo(CodedOutputByteBufferNano output) throws IOException {
                    if (this.elapsedTimeMillis != 0L) {
                        output.writeInt64(1, this.elapsedTimeMillis);
                    }
                    if (this.elapsedScans != 0) {
                        output.writeInt32(2, this.elapsedScans);
                    }
                    super.writeTo(output);
                }

                @Override
                protected int computeSerializedSize() {
                    int size = super.computeSerializedSize();
                    if (this.elapsedTimeMillis != 0L) {
                        size += CodedOutputByteBufferNano.computeInt64Size(1, this.elapsedTimeMillis);
                    }
                    if (this.elapsedScans != 0) {
                        size += CodedOutputByteBufferNano.computeInt32Size(2, this.elapsedScans);
                    }
                    return size;
                }

                @Override
                public Event mergeFrom(CodedInputByteBufferNano input) throws IOException {
                    block5: while (true) {
                        int tag = input.readTag();
                        switch (tag) {
                            case 0: {
                                return this;
                            }
                            default: {
                                if (WireFormatNano.parseUnknownField(input, tag)) continue block5;
                                return this;
                            }
                            case 8: {
                                this.elapsedTimeMillis = input.readInt64();
                                continue block5;
                            }
                            case 16: 
                        }
                        this.elapsedScans = input.readInt32();
                    }
                }

                public static Event parseFrom(byte[] data) throws InvalidProtocolBufferNanoException {
                    return MessageNano.mergeFrom(new Event(), data);
                }

                public static Event parseFrom(CodedInputByteBufferNano input) throws IOException {
                    return new Event().mergeFrom(input);
                }
            }
        }
    }

    public static final class WifiPowerStats
    extends MessageNano {
        private static volatile WifiPowerStats[] _emptyArray;
        public long loggingDurationMs;
        public double energyConsumedMah;
        public long idleTimeMs;
        public long rxTimeMs;
        public long txTimeMs;
        public long wifiKernelActiveTimeMs;
        public long numPacketsTx;
        public long numBytesTx;
        public long numPacketsRx;
        public long numBytesRx;
        public long sleepTimeMs;
        public long scanTimeMs;
        public double monitoredRailEnergyConsumedMah;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static WifiPowerStats[] emptyArray() {
            if (_emptyArray == null) {
                Object object = InternalNano.LAZY_INIT_LOCK;
                synchronized (object) {
                    if (_emptyArray == null) {
                        _emptyArray = new WifiPowerStats[0];
                    }
                }
            }
            return _emptyArray;
        }

        public WifiPowerStats() {
            this.clear();
        }

        public WifiPowerStats clear() {
            this.loggingDurationMs = 0L;
            this.energyConsumedMah = 0.0;
            this.idleTimeMs = 0L;
            this.rxTimeMs = 0L;
            this.txTimeMs = 0L;
            this.wifiKernelActiveTimeMs = 0L;
            this.numPacketsTx = 0L;
            this.numBytesTx = 0L;
            this.numPacketsRx = 0L;
            this.numBytesRx = 0L;
            this.sleepTimeMs = 0L;
            this.scanTimeMs = 0L;
            this.monitoredRailEnergyConsumedMah = 0.0;
            this.cachedSize = -1;
            return this;
        }

        @Override
        public void writeTo(CodedOutputByteBufferNano output) throws IOException {
            if (this.loggingDurationMs != 0L) {
                output.writeInt64(1, this.loggingDurationMs);
            }
            if (Double.doubleToLongBits(this.energyConsumedMah) != Double.doubleToLongBits(0.0)) {
                output.writeDouble(2, this.energyConsumedMah);
            }
            if (this.idleTimeMs != 0L) {
                output.writeInt64(3, this.idleTimeMs);
            }
            if (this.rxTimeMs != 0L) {
                output.writeInt64(4, this.rxTimeMs);
            }
            if (this.txTimeMs != 0L) {
                output.writeInt64(5, this.txTimeMs);
            }
            if (this.wifiKernelActiveTimeMs != 0L) {
                output.writeInt64(6, this.wifiKernelActiveTimeMs);
            }
            if (this.numPacketsTx != 0L) {
                output.writeInt64(7, this.numPacketsTx);
            }
            if (this.numBytesTx != 0L) {
                output.writeInt64(8, this.numBytesTx);
            }
            if (this.numPacketsRx != 0L) {
                output.writeInt64(9, this.numPacketsRx);
            }
            if (this.numBytesRx != 0L) {
                output.writeInt64(10, this.numBytesRx);
            }
            if (this.sleepTimeMs != 0L) {
                output.writeInt64(11, this.sleepTimeMs);
            }
            if (this.scanTimeMs != 0L) {
                output.writeInt64(12, this.scanTimeMs);
            }
            if (Double.doubleToLongBits(this.monitoredRailEnergyConsumedMah) != Double.doubleToLongBits(0.0)) {
                output.writeDouble(13, this.monitoredRailEnergyConsumedMah);
            }
            super.writeTo(output);
        }

        @Override
        protected int computeSerializedSize() {
            int size = super.computeSerializedSize();
            if (this.loggingDurationMs != 0L) {
                size += CodedOutputByteBufferNano.computeInt64Size(1, this.loggingDurationMs);
            }
            if (Double.doubleToLongBits(this.energyConsumedMah) != Double.doubleToLongBits(0.0)) {
                size += CodedOutputByteBufferNano.computeDoubleSize(2, this.energyConsumedMah);
            }
            if (this.idleTimeMs != 0L) {
                size += CodedOutputByteBufferNano.computeInt64Size(3, this.idleTimeMs);
            }
            if (this.rxTimeMs != 0L) {
                size += CodedOutputByteBufferNano.computeInt64Size(4, this.rxTimeMs);
            }
            if (this.txTimeMs != 0L) {
                size += CodedOutputByteBufferNano.computeInt64Size(5, this.txTimeMs);
            }
            if (this.wifiKernelActiveTimeMs != 0L) {
                size += CodedOutputByteBufferNano.computeInt64Size(6, this.wifiKernelActiveTimeMs);
            }
            if (this.numPacketsTx != 0L) {
                size += CodedOutputByteBufferNano.computeInt64Size(7, this.numPacketsTx);
            }
            if (this.numBytesTx != 0L) {
                size += CodedOutputByteBufferNano.computeInt64Size(8, this.numBytesTx);
            }
            if (this.numPacketsRx != 0L) {
                size += CodedOutputByteBufferNano.computeInt64Size(9, this.numPacketsRx);
            }
            if (this.numBytesRx != 0L) {
                size += CodedOutputByteBufferNano.computeInt64Size(10, this.numBytesRx);
            }
            if (this.sleepTimeMs != 0L) {
                size += CodedOutputByteBufferNano.computeInt64Size(11, this.sleepTimeMs);
            }
            if (this.scanTimeMs != 0L) {
                size += CodedOutputByteBufferNano.computeInt64Size(12, this.scanTimeMs);
            }
            if (Double.doubleToLongBits(this.monitoredRailEnergyConsumedMah) != Double.doubleToLongBits(0.0)) {
                size += CodedOutputByteBufferNano.computeDoubleSize(13, this.monitoredRailEnergyConsumedMah);
            }
            return size;
        }

        @Override
        public WifiPowerStats mergeFrom(CodedInputByteBufferNano input) throws IOException {
            block16: while (true) {
                int tag = input.readTag();
                switch (tag) {
                    case 0: {
                        return this;
                    }
                    default: {
                        if (WireFormatNano.parseUnknownField(input, tag)) continue block16;
                        return this;
                    }
                    case 8: {
                        this.loggingDurationMs = input.readInt64();
                        continue block16;
                    }
                    case 17: {
                        this.energyConsumedMah = input.readDouble();
                        continue block16;
                    }
                    case 24: {
                        this.idleTimeMs = input.readInt64();
                        continue block16;
                    }
                    case 32: {
                        this.rxTimeMs = input.readInt64();
                        continue block16;
                    }
                    case 40: {
                        this.txTimeMs = input.readInt64();
                        continue block16;
                    }
                    case 48: {
                        this.wifiKernelActiveTimeMs = input.readInt64();
                        continue block16;
                    }
                    case 56: {
                        this.numPacketsTx = input.readInt64();
                        continue block16;
                    }
                    case 64: {
                        this.numBytesTx = input.readInt64();
                        continue block16;
                    }
                    case 72: {
                        this.numPacketsRx = input.readInt64();
                        continue block16;
                    }
                    case 80: {
                        this.numBytesRx = input.readInt64();
                        continue block16;
                    }
                    case 88: {
                        this.sleepTimeMs = input.readInt64();
                        continue block16;
                    }
                    case 96: {
                        this.scanTimeMs = input.readInt64();
                        continue block16;
                    }
                    case 105: 
                }
                this.monitoredRailEnergyConsumedMah = input.readDouble();
            }
        }

        public static WifiPowerStats parseFrom(byte[] data) throws InvalidProtocolBufferNanoException {
            return MessageNano.mergeFrom(new WifiPowerStats(), data);
        }

        public static WifiPowerStats parseFrom(CodedInputByteBufferNano input) throws IOException {
            return new WifiPowerStats().mergeFrom(input);
        }
    }

    public static final class WpsMetrics
    extends MessageNano {
        private static volatile WpsMetrics[] _emptyArray;
        public int numWpsAttempts;
        public int numWpsSuccess;
        public int numWpsStartFailure;
        public int numWpsOverlapFailure;
        public int numWpsTimeoutFailure;
        public int numWpsOtherConnectionFailure;
        public int numWpsSupplicantFailure;
        public int numWpsCancellation;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static WpsMetrics[] emptyArray() {
            if (_emptyArray == null) {
                Object object = InternalNano.LAZY_INIT_LOCK;
                synchronized (object) {
                    if (_emptyArray == null) {
                        _emptyArray = new WpsMetrics[0];
                    }
                }
            }
            return _emptyArray;
        }

        public WpsMetrics() {
            this.clear();
        }

        public WpsMetrics clear() {
            this.numWpsAttempts = 0;
            this.numWpsSuccess = 0;
            this.numWpsStartFailure = 0;
            this.numWpsOverlapFailure = 0;
            this.numWpsTimeoutFailure = 0;
            this.numWpsOtherConnectionFailure = 0;
            this.numWpsSupplicantFailure = 0;
            this.numWpsCancellation = 0;
            this.cachedSize = -1;
            return this;
        }

        @Override
        public void writeTo(CodedOutputByteBufferNano output) throws IOException {
            if (this.numWpsAttempts != 0) {
                output.writeInt32(1, this.numWpsAttempts);
            }
            if (this.numWpsSuccess != 0) {
                output.writeInt32(2, this.numWpsSuccess);
            }
            if (this.numWpsStartFailure != 0) {
                output.writeInt32(3, this.numWpsStartFailure);
            }
            if (this.numWpsOverlapFailure != 0) {
                output.writeInt32(4, this.numWpsOverlapFailure);
            }
            if (this.numWpsTimeoutFailure != 0) {
                output.writeInt32(5, this.numWpsTimeoutFailure);
            }
            if (this.numWpsOtherConnectionFailure != 0) {
                output.writeInt32(6, this.numWpsOtherConnectionFailure);
            }
            if (this.numWpsSupplicantFailure != 0) {
                output.writeInt32(7, this.numWpsSupplicantFailure);
            }
            if (this.numWpsCancellation != 0) {
                output.writeInt32(8, this.numWpsCancellation);
            }
            super.writeTo(output);
        }

        @Override
        protected int computeSerializedSize() {
            int size = super.computeSerializedSize();
            if (this.numWpsAttempts != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(1, this.numWpsAttempts);
            }
            if (this.numWpsSuccess != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(2, this.numWpsSuccess);
            }
            if (this.numWpsStartFailure != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(3, this.numWpsStartFailure);
            }
            if (this.numWpsOverlapFailure != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(4, this.numWpsOverlapFailure);
            }
            if (this.numWpsTimeoutFailure != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(5, this.numWpsTimeoutFailure);
            }
            if (this.numWpsOtherConnectionFailure != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(6, this.numWpsOtherConnectionFailure);
            }
            if (this.numWpsSupplicantFailure != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(7, this.numWpsSupplicantFailure);
            }
            if (this.numWpsCancellation != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(8, this.numWpsCancellation);
            }
            return size;
        }

        @Override
        public WpsMetrics mergeFrom(CodedInputByteBufferNano input) throws IOException {
            block11: while (true) {
                int tag = input.readTag();
                switch (tag) {
                    case 0: {
                        return this;
                    }
                    default: {
                        if (WireFormatNano.parseUnknownField(input, tag)) continue block11;
                        return this;
                    }
                    case 8: {
                        this.numWpsAttempts = input.readInt32();
                        continue block11;
                    }
                    case 16: {
                        this.numWpsSuccess = input.readInt32();
                        continue block11;
                    }
                    case 24: {
                        this.numWpsStartFailure = input.readInt32();
                        continue block11;
                    }
                    case 32: {
                        this.numWpsOverlapFailure = input.readInt32();
                        continue block11;
                    }
                    case 40: {
                        this.numWpsTimeoutFailure = input.readInt32();
                        continue block11;
                    }
                    case 48: {
                        this.numWpsOtherConnectionFailure = input.readInt32();
                        continue block11;
                    }
                    case 56: {
                        this.numWpsSupplicantFailure = input.readInt32();
                        continue block11;
                    }
                    case 64: 
                }
                this.numWpsCancellation = input.readInt32();
            }
        }

        public static WpsMetrics parseFrom(byte[] data) throws InvalidProtocolBufferNanoException {
            return MessageNano.mergeFrom(new WpsMetrics(), data);
        }

        public static WpsMetrics parseFrom(CodedInputByteBufferNano input) throws IOException {
            return new WpsMetrics().mergeFrom(input);
        }
    }

    public static final class SoftApConnectedClientsEvent
    extends MessageNano {
        public static final int SOFT_AP_UP = 0;
        public static final int SOFT_AP_DOWN = 1;
        public static final int NUM_CLIENTS_CHANGED = 2;
        public static final int BANDWIDTH_INVALID = 0;
        public static final int BANDWIDTH_20_NOHT = 1;
        public static final int BANDWIDTH_20 = 2;
        public static final int BANDWIDTH_40 = 3;
        public static final int BANDWIDTH_80 = 4;
        public static final int BANDWIDTH_80P80 = 5;
        public static final int BANDWIDTH_160 = 6;
        private static volatile SoftApConnectedClientsEvent[] _emptyArray;
        public int eventType;
        public long timeStampMillis;
        public int numConnectedClients;
        public int channelFrequency;
        public int channelBandwidth;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static SoftApConnectedClientsEvent[] emptyArray() {
            if (_emptyArray == null) {
                Object object = InternalNano.LAZY_INIT_LOCK;
                synchronized (object) {
                    if (_emptyArray == null) {
                        _emptyArray = new SoftApConnectedClientsEvent[0];
                    }
                }
            }
            return _emptyArray;
        }

        public SoftApConnectedClientsEvent() {
            this.clear();
        }

        public SoftApConnectedClientsEvent clear() {
            this.eventType = 0;
            this.timeStampMillis = 0L;
            this.numConnectedClients = 0;
            this.channelFrequency = 0;
            this.channelBandwidth = 0;
            this.cachedSize = -1;
            return this;
        }

        @Override
        public void writeTo(CodedOutputByteBufferNano output) throws IOException {
            if (this.eventType != 0) {
                output.writeInt32(1, this.eventType);
            }
            if (this.timeStampMillis != 0L) {
                output.writeInt64(2, this.timeStampMillis);
            }
            if (this.numConnectedClients != 0) {
                output.writeInt32(3, this.numConnectedClients);
            }
            if (this.channelFrequency != 0) {
                output.writeInt32(4, this.channelFrequency);
            }
            if (this.channelBandwidth != 0) {
                output.writeInt32(5, this.channelBandwidth);
            }
            super.writeTo(output);
        }

        @Override
        protected int computeSerializedSize() {
            int size = super.computeSerializedSize();
            if (this.eventType != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(1, this.eventType);
            }
            if (this.timeStampMillis != 0L) {
                size += CodedOutputByteBufferNano.computeInt64Size(2, this.timeStampMillis);
            }
            if (this.numConnectedClients != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(3, this.numConnectedClients);
            }
            if (this.channelFrequency != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(4, this.channelFrequency);
            }
            if (this.channelBandwidth != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(5, this.channelBandwidth);
            }
            return size;
        }

        @Override
        public SoftApConnectedClientsEvent mergeFrom(CodedInputByteBufferNano input) throws IOException {
            block14: while (true) {
                int value;
                int tag = input.readTag();
                switch (tag) {
                    case 0: {
                        return this;
                    }
                    default: {
                        if (WireFormatNano.parseUnknownField(input, tag)) continue block14;
                        return this;
                    }
                    case 8: {
                        value = input.readInt32();
                        switch (value) {
                            case 0: 
                            case 1: 
                            case 2: {
                                this.eventType = value;
                            }
                        }
                        continue block14;
                    }
                    case 16: {
                        this.timeStampMillis = input.readInt64();
                        continue block14;
                    }
                    case 24: {
                        this.numConnectedClients = input.readInt32();
                        continue block14;
                    }
                    case 32: {
                        this.channelFrequency = input.readInt32();
                        continue block14;
                    }
                    case 40: 
                }
                value = input.readInt32();
                switch (value) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        this.channelBandwidth = value;
                    }
                }
            }
        }

        public static SoftApConnectedClientsEvent parseFrom(byte[] data) throws InvalidProtocolBufferNanoException {
            return MessageNano.mergeFrom(new SoftApConnectedClientsEvent(), data);
        }

        public static SoftApConnectedClientsEvent parseFrom(CodedInputByteBufferNano input) throws IOException {
            return new SoftApConnectedClientsEvent().mergeFrom(input);
        }
    }

    public static final class ConnectToNetworkNotificationAndActionCount
    extends MessageNano {
        public static final int NOTIFICATION_UNKNOWN = 0;
        public static final int NOTIFICATION_RECOMMEND_NETWORK = 1;
        public static final int NOTIFICATION_CONNECTING_TO_NETWORK = 2;
        public static final int NOTIFICATION_CONNECTED_TO_NETWORK = 3;
        public static final int NOTIFICATION_FAILED_TO_CONNECT = 4;
        public static final int ACTION_UNKNOWN = 0;
        public static final int ACTION_USER_DISMISSED_NOTIFICATION = 1;
        public static final int ACTION_CONNECT_TO_NETWORK = 2;
        public static final int ACTION_PICK_WIFI_NETWORK = 3;
        public static final int ACTION_PICK_WIFI_NETWORK_AFTER_CONNECT_FAILURE = 4;
        public static final int RECOMMENDER_UNKNOWN = 0;
        public static final int RECOMMENDER_OPEN = 1;
        private static volatile ConnectToNetworkNotificationAndActionCount[] _emptyArray;
        public int notification;
        public int action;
        public int recommender;
        public int count;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static ConnectToNetworkNotificationAndActionCount[] emptyArray() {
            if (_emptyArray == null) {
                Object object = InternalNano.LAZY_INIT_LOCK;
                synchronized (object) {
                    if (_emptyArray == null) {
                        _emptyArray = new ConnectToNetworkNotificationAndActionCount[0];
                    }
                }
            }
            return _emptyArray;
        }

        public ConnectToNetworkNotificationAndActionCount() {
            this.clear();
        }

        public ConnectToNetworkNotificationAndActionCount clear() {
            this.notification = 0;
            this.action = 0;
            this.recommender = 0;
            this.count = 0;
            this.cachedSize = -1;
            return this;
        }

        @Override
        public void writeTo(CodedOutputByteBufferNano output) throws IOException {
            if (this.notification != 0) {
                output.writeInt32(1, this.notification);
            }
            if (this.action != 0) {
                output.writeInt32(2, this.action);
            }
            if (this.recommender != 0) {
                output.writeInt32(3, this.recommender);
            }
            if (this.count != 0) {
                output.writeInt32(4, this.count);
            }
            super.writeTo(output);
        }

        @Override
        protected int computeSerializedSize() {
            int size = super.computeSerializedSize();
            if (this.notification != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(1, this.notification);
            }
            if (this.action != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(2, this.action);
            }
            if (this.recommender != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(3, this.recommender);
            }
            if (this.count != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(4, this.count);
            }
            return size;
        }

        @Override
        public ConnectToNetworkNotificationAndActionCount mergeFrom(CodedInputByteBufferNano input) throws IOException {
            block16: while (true) {
                int tag = input.readTag();
                switch (tag) {
                    case 0: {
                        return this;
                    }
                    default: {
                        if (WireFormatNano.parseUnknownField(input, tag)) continue block16;
                        return this;
                    }
                    case 8: {
                        int value = input.readInt32();
                        switch (value) {
                            case 0: 
                            case 1: 
                            case 2: 
                            case 3: 
                            case 4: {
                                this.notification = value;
                            }
                        }
                        continue block16;
                    }
                    case 16: {
                        int value = input.readInt32();
                        switch (value) {
                            case 0: 
                            case 1: 
                            case 2: 
                            case 3: 
                            case 4: {
                                this.action = value;
                            }
                        }
                        continue block16;
                    }
                    case 24: {
                        int value = input.readInt32();
                        switch (value) {
                            case 0: 
                            case 1: {
                                this.recommender = value;
                            }
                        }
                        continue block16;
                    }
                    case 32: 
                }
                this.count = input.readInt32();
            }
        }

        public static ConnectToNetworkNotificationAndActionCount parseFrom(byte[] data) throws InvalidProtocolBufferNanoException {
            return MessageNano.mergeFrom(new ConnectToNetworkNotificationAndActionCount(), data);
        }

        public static ConnectToNetworkNotificationAndActionCount parseFrom(CodedInputByteBufferNano input) throws IOException {
            return new ConnectToNetworkNotificationAndActionCount().mergeFrom(input);
        }
    }

    public static final class PnoScanMetrics
    extends MessageNano {
        private static volatile PnoScanMetrics[] _emptyArray;
        public int numPnoScanAttempts;
        public int numPnoScanFailed;
        public int numPnoScanStartedOverOffload;
        public int numPnoScanFailedOverOffload;
        public int numPnoFoundNetworkEvents;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static PnoScanMetrics[] emptyArray() {
            if (_emptyArray == null) {
                Object object = InternalNano.LAZY_INIT_LOCK;
                synchronized (object) {
                    if (_emptyArray == null) {
                        _emptyArray = new PnoScanMetrics[0];
                    }
                }
            }
            return _emptyArray;
        }

        public PnoScanMetrics() {
            this.clear();
        }

        public PnoScanMetrics clear() {
            this.numPnoScanAttempts = 0;
            this.numPnoScanFailed = 0;
            this.numPnoScanStartedOverOffload = 0;
            this.numPnoScanFailedOverOffload = 0;
            this.numPnoFoundNetworkEvents = 0;
            this.cachedSize = -1;
            return this;
        }

        @Override
        public void writeTo(CodedOutputByteBufferNano output) throws IOException {
            if (this.numPnoScanAttempts != 0) {
                output.writeInt32(1, this.numPnoScanAttempts);
            }
            if (this.numPnoScanFailed != 0) {
                output.writeInt32(2, this.numPnoScanFailed);
            }
            if (this.numPnoScanStartedOverOffload != 0) {
                output.writeInt32(3, this.numPnoScanStartedOverOffload);
            }
            if (this.numPnoScanFailedOverOffload != 0) {
                output.writeInt32(4, this.numPnoScanFailedOverOffload);
            }
            if (this.numPnoFoundNetworkEvents != 0) {
                output.writeInt32(5, this.numPnoFoundNetworkEvents);
            }
            super.writeTo(output);
        }

        @Override
        protected int computeSerializedSize() {
            int size = super.computeSerializedSize();
            if (this.numPnoScanAttempts != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(1, this.numPnoScanAttempts);
            }
            if (this.numPnoScanFailed != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(2, this.numPnoScanFailed);
            }
            if (this.numPnoScanStartedOverOffload != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(3, this.numPnoScanStartedOverOffload);
            }
            if (this.numPnoScanFailedOverOffload != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(4, this.numPnoScanFailedOverOffload);
            }
            if (this.numPnoFoundNetworkEvents != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(5, this.numPnoFoundNetworkEvents);
            }
            return size;
        }

        @Override
        public PnoScanMetrics mergeFrom(CodedInputByteBufferNano input) throws IOException {
            block8: while (true) {
                int tag = input.readTag();
                switch (tag) {
                    case 0: {
                        return this;
                    }
                    default: {
                        if (WireFormatNano.parseUnknownField(input, tag)) continue block8;
                        return this;
                    }
                    case 8: {
                        this.numPnoScanAttempts = input.readInt32();
                        continue block8;
                    }
                    case 16: {
                        this.numPnoScanFailed = input.readInt32();
                        continue block8;
                    }
                    case 24: {
                        this.numPnoScanStartedOverOffload = input.readInt32();
                        continue block8;
                    }
                    case 32: {
                        this.numPnoScanFailedOverOffload = input.readInt32();
                        continue block8;
                    }
                    case 40: 
                }
                this.numPnoFoundNetworkEvents = input.readInt32();
            }
        }

        public static PnoScanMetrics parseFrom(byte[] data) throws InvalidProtocolBufferNanoException {
            return MessageNano.mergeFrom(new PnoScanMetrics(), data);
        }

        public static PnoScanMetrics parseFrom(CodedInputByteBufferNano input) throws IOException {
            return new PnoScanMetrics().mergeFrom(input);
        }
    }

    public static final class NumConnectableNetworksBucket
    extends MessageNano {
        private static volatile NumConnectableNetworksBucket[] _emptyArray;
        public int numConnectableNetworks;
        public int count;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static NumConnectableNetworksBucket[] emptyArray() {
            if (_emptyArray == null) {
                Object object = InternalNano.LAZY_INIT_LOCK;
                synchronized (object) {
                    if (_emptyArray == null) {
                        _emptyArray = new NumConnectableNetworksBucket[0];
                    }
                }
            }
            return _emptyArray;
        }

        public NumConnectableNetworksBucket() {
            this.clear();
        }

        public NumConnectableNetworksBucket clear() {
            this.numConnectableNetworks = 0;
            this.count = 0;
            this.cachedSize = -1;
            return this;
        }

        @Override
        public void writeTo(CodedOutputByteBufferNano output) throws IOException {
            if (this.numConnectableNetworks != 0) {
                output.writeInt32(1, this.numConnectableNetworks);
            }
            if (this.count != 0) {
                output.writeInt32(2, this.count);
            }
            super.writeTo(output);
        }

        @Override
        protected int computeSerializedSize() {
            int size = super.computeSerializedSize();
            if (this.numConnectableNetworks != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(1, this.numConnectableNetworks);
            }
            if (this.count != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(2, this.count);
            }
            return size;
        }

        @Override
        public NumConnectableNetworksBucket mergeFrom(CodedInputByteBufferNano input) throws IOException {
            block5: while (true) {
                int tag = input.readTag();
                switch (tag) {
                    case 0: {
                        return this;
                    }
                    default: {
                        if (WireFormatNano.parseUnknownField(input, tag)) continue block5;
                        return this;
                    }
                    case 8: {
                        this.numConnectableNetworks = input.readInt32();
                        continue block5;
                    }
                    case 16: 
                }
                this.count = input.readInt32();
            }
        }

        public static NumConnectableNetworksBucket parseFrom(byte[] data) throws InvalidProtocolBufferNanoException {
            return MessageNano.mergeFrom(new NumConnectableNetworksBucket(), data);
        }

        public static NumConnectableNetworksBucket parseFrom(CodedInputByteBufferNano input) throws IOException {
            return new NumConnectableNetworksBucket().mergeFrom(input);
        }
    }

    public static final class WifiAwareLog
    extends MessageNano {
        public static final int UNKNOWN = 0;
        public static final int SUCCESS = 1;
        public static final int INTERNAL_FAILURE = 2;
        public static final int PROTOCOL_FAILURE = 3;
        public static final int INVALID_SESSION_ID = 4;
        public static final int NO_RESOURCES_AVAILABLE = 5;
        public static final int INVALID_ARGS = 6;
        public static final int INVALID_PEER_ID = 7;
        public static final int INVALID_NDP_ID = 8;
        public static final int NAN_NOT_ALLOWED = 9;
        public static final int NO_OTA_ACK = 10;
        public static final int ALREADY_ENABLED = 11;
        public static final int FOLLOWUP_TX_QUEUE_FULL = 12;
        public static final int UNSUPPORTED_CONCURRENCY_NAN_DISABLED = 13;
        public static final int UNKNOWN_HAL_STATUS = 14;
        private static volatile WifiAwareLog[] _emptyArray;
        public int numApps;
        public int numAppsUsingIdentityCallback;
        public int maxConcurrentAttachSessionsInApp;
        public NanStatusHistogramBucket[] histogramAttachSessionStatus;
        public int maxConcurrentPublishInApp;
        public int maxConcurrentSubscribeInApp;
        public int maxConcurrentDiscoverySessionsInApp;
        public int maxConcurrentPublishInSystem;
        public int maxConcurrentSubscribeInSystem;
        public int maxConcurrentDiscoverySessionsInSystem;
        public NanStatusHistogramBucket[] histogramPublishStatus;
        public NanStatusHistogramBucket[] histogramSubscribeStatus;
        public int numAppsWithDiscoverySessionFailureOutOfResources;
        public NanStatusHistogramBucket[] histogramRequestNdpStatus;
        public NanStatusHistogramBucket[] histogramRequestNdpOobStatus;
        public int maxConcurrentNdiInApp;
        public int maxConcurrentNdiInSystem;
        public int maxConcurrentNdpInApp;
        public int maxConcurrentNdpInSystem;
        public int maxConcurrentSecureNdpInApp;
        public int maxConcurrentSecureNdpInSystem;
        public int maxConcurrentNdpPerNdi;
        public HistogramBucket[] histogramAwareAvailableDurationMs;
        public HistogramBucket[] histogramAwareEnabledDurationMs;
        public HistogramBucket[] histogramAttachDurationMs;
        public HistogramBucket[] histogramPublishSessionDurationMs;
        public HistogramBucket[] histogramSubscribeSessionDurationMs;
        public HistogramBucket[] histogramNdpSessionDurationMs;
        public HistogramBucket[] histogramNdpSessionDataUsageMb;
        public HistogramBucket[] histogramNdpCreationTimeMs;
        public long ndpCreationTimeMsMin;
        public long ndpCreationTimeMsMax;
        public long ndpCreationTimeMsSum;
        public long ndpCreationTimeMsSumOfSq;
        public long ndpCreationTimeMsNumSamples;
        public long availableTimeMs;
        public long enabledTimeMs;
        public int maxConcurrentPublishWithRangingInApp;
        public int maxConcurrentSubscribeWithRangingInApp;
        public int maxConcurrentPublishWithRangingInSystem;
        public int maxConcurrentSubscribeWithRangingInSystem;
        public HistogramBucket[] histogramSubscribeGeofenceMin;
        public HistogramBucket[] histogramSubscribeGeofenceMax;
        public int numSubscribesWithRanging;
        public int numMatchesWithRanging;
        public int numMatchesWithoutRangingForRangingEnabledSubscribes;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static WifiAwareLog[] emptyArray() {
            if (_emptyArray == null) {
                Object object = InternalNano.LAZY_INIT_LOCK;
                synchronized (object) {
                    if (_emptyArray == null) {
                        _emptyArray = new WifiAwareLog[0];
                    }
                }
            }
            return _emptyArray;
        }

        public WifiAwareLog() {
            this.clear();
        }

        public WifiAwareLog clear() {
            this.numApps = 0;
            this.numAppsUsingIdentityCallback = 0;
            this.maxConcurrentAttachSessionsInApp = 0;
            this.histogramAttachSessionStatus = NanStatusHistogramBucket.emptyArray();
            this.maxConcurrentPublishInApp = 0;
            this.maxConcurrentSubscribeInApp = 0;
            this.maxConcurrentDiscoverySessionsInApp = 0;
            this.maxConcurrentPublishInSystem = 0;
            this.maxConcurrentSubscribeInSystem = 0;
            this.maxConcurrentDiscoverySessionsInSystem = 0;
            this.histogramPublishStatus = NanStatusHistogramBucket.emptyArray();
            this.histogramSubscribeStatus = NanStatusHistogramBucket.emptyArray();
            this.numAppsWithDiscoverySessionFailureOutOfResources = 0;
            this.histogramRequestNdpStatus = NanStatusHistogramBucket.emptyArray();
            this.histogramRequestNdpOobStatus = NanStatusHistogramBucket.emptyArray();
            this.maxConcurrentNdiInApp = 0;
            this.maxConcurrentNdiInSystem = 0;
            this.maxConcurrentNdpInApp = 0;
            this.maxConcurrentNdpInSystem = 0;
            this.maxConcurrentSecureNdpInApp = 0;
            this.maxConcurrentSecureNdpInSystem = 0;
            this.maxConcurrentNdpPerNdi = 0;
            this.histogramAwareAvailableDurationMs = HistogramBucket.emptyArray();
            this.histogramAwareEnabledDurationMs = HistogramBucket.emptyArray();
            this.histogramAttachDurationMs = HistogramBucket.emptyArray();
            this.histogramPublishSessionDurationMs = HistogramBucket.emptyArray();
            this.histogramSubscribeSessionDurationMs = HistogramBucket.emptyArray();
            this.histogramNdpSessionDurationMs = HistogramBucket.emptyArray();
            this.histogramNdpSessionDataUsageMb = HistogramBucket.emptyArray();
            this.histogramNdpCreationTimeMs = HistogramBucket.emptyArray();
            this.ndpCreationTimeMsMin = 0L;
            this.ndpCreationTimeMsMax = 0L;
            this.ndpCreationTimeMsSum = 0L;
            this.ndpCreationTimeMsSumOfSq = 0L;
            this.ndpCreationTimeMsNumSamples = 0L;
            this.availableTimeMs = 0L;
            this.enabledTimeMs = 0L;
            this.maxConcurrentPublishWithRangingInApp = 0;
            this.maxConcurrentSubscribeWithRangingInApp = 0;
            this.maxConcurrentPublishWithRangingInSystem = 0;
            this.maxConcurrentSubscribeWithRangingInSystem = 0;
            this.histogramSubscribeGeofenceMin = HistogramBucket.emptyArray();
            this.histogramSubscribeGeofenceMax = HistogramBucket.emptyArray();
            this.numSubscribesWithRanging = 0;
            this.numMatchesWithRanging = 0;
            this.numMatchesWithoutRangingForRangingEnabledSubscribes = 0;
            this.cachedSize = -1;
            return this;
        }

        @Override
        public void writeTo(CodedOutputByteBufferNano output) throws IOException {
            MessageNano element;
            int i;
            if (this.numApps != 0) {
                output.writeInt32(1, this.numApps);
            }
            if (this.numAppsUsingIdentityCallback != 0) {
                output.writeInt32(2, this.numAppsUsingIdentityCallback);
            }
            if (this.maxConcurrentAttachSessionsInApp != 0) {
                output.writeInt32(3, this.maxConcurrentAttachSessionsInApp);
            }
            if (this.histogramAttachSessionStatus != null && this.histogramAttachSessionStatus.length > 0) {
                for (i = 0; i < this.histogramAttachSessionStatus.length; ++i) {
                    element = this.histogramAttachSessionStatus[i];
                    if (element == null) continue;
                    output.writeMessage(4, element);
                }
            }
            if (this.maxConcurrentPublishInApp != 0) {
                output.writeInt32(5, this.maxConcurrentPublishInApp);
            }
            if (this.maxConcurrentSubscribeInApp != 0) {
                output.writeInt32(6, this.maxConcurrentSubscribeInApp);
            }
            if (this.maxConcurrentDiscoverySessionsInApp != 0) {
                output.writeInt32(7, this.maxConcurrentDiscoverySessionsInApp);
            }
            if (this.maxConcurrentPublishInSystem != 0) {
                output.writeInt32(8, this.maxConcurrentPublishInSystem);
            }
            if (this.maxConcurrentSubscribeInSystem != 0) {
                output.writeInt32(9, this.maxConcurrentSubscribeInSystem);
            }
            if (this.maxConcurrentDiscoverySessionsInSystem != 0) {
                output.writeInt32(10, this.maxConcurrentDiscoverySessionsInSystem);
            }
            if (this.histogramPublishStatus != null && this.histogramPublishStatus.length > 0) {
                for (i = 0; i < this.histogramPublishStatus.length; ++i) {
                    element = this.histogramPublishStatus[i];
                    if (element == null) continue;
                    output.writeMessage(11, element);
                }
            }
            if (this.histogramSubscribeStatus != null && this.histogramSubscribeStatus.length > 0) {
                for (i = 0; i < this.histogramSubscribeStatus.length; ++i) {
                    element = this.histogramSubscribeStatus[i];
                    if (element == null) continue;
                    output.writeMessage(12, element);
                }
            }
            if (this.numAppsWithDiscoverySessionFailureOutOfResources != 0) {
                output.writeInt32(13, this.numAppsWithDiscoverySessionFailureOutOfResources);
            }
            if (this.histogramRequestNdpStatus != null && this.histogramRequestNdpStatus.length > 0) {
                for (i = 0; i < this.histogramRequestNdpStatus.length; ++i) {
                    element = this.histogramRequestNdpStatus[i];
                    if (element == null) continue;
                    output.writeMessage(14, element);
                }
            }
            if (this.histogramRequestNdpOobStatus != null && this.histogramRequestNdpOobStatus.length > 0) {
                for (i = 0; i < this.histogramRequestNdpOobStatus.length; ++i) {
                    element = this.histogramRequestNdpOobStatus[i];
                    if (element == null) continue;
                    output.writeMessage(15, element);
                }
            }
            if (this.maxConcurrentNdiInApp != 0) {
                output.writeInt32(19, this.maxConcurrentNdiInApp);
            }
            if (this.maxConcurrentNdiInSystem != 0) {
                output.writeInt32(20, this.maxConcurrentNdiInSystem);
            }
            if (this.maxConcurrentNdpInApp != 0) {
                output.writeInt32(21, this.maxConcurrentNdpInApp);
            }
            if (this.maxConcurrentNdpInSystem != 0) {
                output.writeInt32(22, this.maxConcurrentNdpInSystem);
            }
            if (this.maxConcurrentSecureNdpInApp != 0) {
                output.writeInt32(23, this.maxConcurrentSecureNdpInApp);
            }
            if (this.maxConcurrentSecureNdpInSystem != 0) {
                output.writeInt32(24, this.maxConcurrentSecureNdpInSystem);
            }
            if (this.maxConcurrentNdpPerNdi != 0) {
                output.writeInt32(25, this.maxConcurrentNdpPerNdi);
            }
            if (this.histogramAwareAvailableDurationMs != null && this.histogramAwareAvailableDurationMs.length > 0) {
                for (i = 0; i < this.histogramAwareAvailableDurationMs.length; ++i) {
                    element = this.histogramAwareAvailableDurationMs[i];
                    if (element == null) continue;
                    output.writeMessage(26, element);
                }
            }
            if (this.histogramAwareEnabledDurationMs != null && this.histogramAwareEnabledDurationMs.length > 0) {
                for (i = 0; i < this.histogramAwareEnabledDurationMs.length; ++i) {
                    element = this.histogramAwareEnabledDurationMs[i];
                    if (element == null) continue;
                    output.writeMessage(27, element);
                }
            }
            if (this.histogramAttachDurationMs != null && this.histogramAttachDurationMs.length > 0) {
                for (i = 0; i < this.histogramAttachDurationMs.length; ++i) {
                    element = this.histogramAttachDurationMs[i];
                    if (element == null) continue;
                    output.writeMessage(28, element);
                }
            }
            if (this.histogramPublishSessionDurationMs != null && this.histogramPublishSessionDurationMs.length > 0) {
                for (i = 0; i < this.histogramPublishSessionDurationMs.length; ++i) {
                    element = this.histogramPublishSessionDurationMs[i];
                    if (element == null) continue;
                    output.writeMessage(29, element);
                }
            }
            if (this.histogramSubscribeSessionDurationMs != null && this.histogramSubscribeSessionDurationMs.length > 0) {
                for (i = 0; i < this.histogramSubscribeSessionDurationMs.length; ++i) {
                    element = this.histogramSubscribeSessionDurationMs[i];
                    if (element == null) continue;
                    output.writeMessage(30, element);
                }
            }
            if (this.histogramNdpSessionDurationMs != null && this.histogramNdpSessionDurationMs.length > 0) {
                for (i = 0; i < this.histogramNdpSessionDurationMs.length; ++i) {
                    element = this.histogramNdpSessionDurationMs[i];
                    if (element == null) continue;
                    output.writeMessage(31, element);
                }
            }
            if (this.histogramNdpSessionDataUsageMb != null && this.histogramNdpSessionDataUsageMb.length > 0) {
                for (i = 0; i < this.histogramNdpSessionDataUsageMb.length; ++i) {
                    element = this.histogramNdpSessionDataUsageMb[i];
                    if (element == null) continue;
                    output.writeMessage(32, element);
                }
            }
            if (this.histogramNdpCreationTimeMs != null && this.histogramNdpCreationTimeMs.length > 0) {
                for (i = 0; i < this.histogramNdpCreationTimeMs.length; ++i) {
                    element = this.histogramNdpCreationTimeMs[i];
                    if (element == null) continue;
                    output.writeMessage(33, element);
                }
            }
            if (this.ndpCreationTimeMsMin != 0L) {
                output.writeInt64(34, this.ndpCreationTimeMsMin);
            }
            if (this.ndpCreationTimeMsMax != 0L) {
                output.writeInt64(35, this.ndpCreationTimeMsMax);
            }
            if (this.ndpCreationTimeMsSum != 0L) {
                output.writeInt64(36, this.ndpCreationTimeMsSum);
            }
            if (this.ndpCreationTimeMsSumOfSq != 0L) {
                output.writeInt64(37, this.ndpCreationTimeMsSumOfSq);
            }
            if (this.ndpCreationTimeMsNumSamples != 0L) {
                output.writeInt64(38, this.ndpCreationTimeMsNumSamples);
            }
            if (this.availableTimeMs != 0L) {
                output.writeInt64(39, this.availableTimeMs);
            }
            if (this.enabledTimeMs != 0L) {
                output.writeInt64(40, this.enabledTimeMs);
            }
            if (this.maxConcurrentPublishWithRangingInApp != 0) {
                output.writeInt32(41, this.maxConcurrentPublishWithRangingInApp);
            }
            if (this.maxConcurrentSubscribeWithRangingInApp != 0) {
                output.writeInt32(42, this.maxConcurrentSubscribeWithRangingInApp);
            }
            if (this.maxConcurrentPublishWithRangingInSystem != 0) {
                output.writeInt32(43, this.maxConcurrentPublishWithRangingInSystem);
            }
            if (this.maxConcurrentSubscribeWithRangingInSystem != 0) {
                output.writeInt32(44, this.maxConcurrentSubscribeWithRangingInSystem);
            }
            if (this.histogramSubscribeGeofenceMin != null && this.histogramSubscribeGeofenceMin.length > 0) {
                for (i = 0; i < this.histogramSubscribeGeofenceMin.length; ++i) {
                    element = this.histogramSubscribeGeofenceMin[i];
                    if (element == null) continue;
                    output.writeMessage(45, element);
                }
            }
            if (this.histogramSubscribeGeofenceMax != null && this.histogramSubscribeGeofenceMax.length > 0) {
                for (i = 0; i < this.histogramSubscribeGeofenceMax.length; ++i) {
                    element = this.histogramSubscribeGeofenceMax[i];
                    if (element == null) continue;
                    output.writeMessage(46, element);
                }
            }
            if (this.numSubscribesWithRanging != 0) {
                output.writeInt32(47, this.numSubscribesWithRanging);
            }
            if (this.numMatchesWithRanging != 0) {
                output.writeInt32(48, this.numMatchesWithRanging);
            }
            if (this.numMatchesWithoutRangingForRangingEnabledSubscribes != 0) {
                output.writeInt32(49, this.numMatchesWithoutRangingForRangingEnabledSubscribes);
            }
            super.writeTo(output);
        }

        @Override
        protected int computeSerializedSize() {
            MessageNano element;
            int i;
            int size = super.computeSerializedSize();
            if (this.numApps != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(1, this.numApps);
            }
            if (this.numAppsUsingIdentityCallback != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(2, this.numAppsUsingIdentityCallback);
            }
            if (this.maxConcurrentAttachSessionsInApp != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(3, this.maxConcurrentAttachSessionsInApp);
            }
            if (this.histogramAttachSessionStatus != null && this.histogramAttachSessionStatus.length > 0) {
                for (i = 0; i < this.histogramAttachSessionStatus.length; ++i) {
                    element = this.histogramAttachSessionStatus[i];
                    if (element == null) continue;
                    size += CodedOutputByteBufferNano.computeMessageSize(4, element);
                }
            }
            if (this.maxConcurrentPublishInApp != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(5, this.maxConcurrentPublishInApp);
            }
            if (this.maxConcurrentSubscribeInApp != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(6, this.maxConcurrentSubscribeInApp);
            }
            if (this.maxConcurrentDiscoverySessionsInApp != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(7, this.maxConcurrentDiscoverySessionsInApp);
            }
            if (this.maxConcurrentPublishInSystem != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(8, this.maxConcurrentPublishInSystem);
            }
            if (this.maxConcurrentSubscribeInSystem != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(9, this.maxConcurrentSubscribeInSystem);
            }
            if (this.maxConcurrentDiscoverySessionsInSystem != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(10, this.maxConcurrentDiscoverySessionsInSystem);
            }
            if (this.histogramPublishStatus != null && this.histogramPublishStatus.length > 0) {
                for (i = 0; i < this.histogramPublishStatus.length; ++i) {
                    element = this.histogramPublishStatus[i];
                    if (element == null) continue;
                    size += CodedOutputByteBufferNano.computeMessageSize(11, element);
                }
            }
            if (this.histogramSubscribeStatus != null && this.histogramSubscribeStatus.length > 0) {
                for (i = 0; i < this.histogramSubscribeStatus.length; ++i) {
                    element = this.histogramSubscribeStatus[i];
                    if (element == null) continue;
                    size += CodedOutputByteBufferNano.computeMessageSize(12, element);
                }
            }
            if (this.numAppsWithDiscoverySessionFailureOutOfResources != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(13, this.numAppsWithDiscoverySessionFailureOutOfResources);
            }
            if (this.histogramRequestNdpStatus != null && this.histogramRequestNdpStatus.length > 0) {
                for (i = 0; i < this.histogramRequestNdpStatus.length; ++i) {
                    element = this.histogramRequestNdpStatus[i];
                    if (element == null) continue;
                    size += CodedOutputByteBufferNano.computeMessageSize(14, element);
                }
            }
            if (this.histogramRequestNdpOobStatus != null && this.histogramRequestNdpOobStatus.length > 0) {
                for (i = 0; i < this.histogramRequestNdpOobStatus.length; ++i) {
                    element = this.histogramRequestNdpOobStatus[i];
                    if (element == null) continue;
                    size += CodedOutputByteBufferNano.computeMessageSize(15, element);
                }
            }
            if (this.maxConcurrentNdiInApp != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(19, this.maxConcurrentNdiInApp);
            }
            if (this.maxConcurrentNdiInSystem != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(20, this.maxConcurrentNdiInSystem);
            }
            if (this.maxConcurrentNdpInApp != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(21, this.maxConcurrentNdpInApp);
            }
            if (this.maxConcurrentNdpInSystem != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(22, this.maxConcurrentNdpInSystem);
            }
            if (this.maxConcurrentSecureNdpInApp != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(23, this.maxConcurrentSecureNdpInApp);
            }
            if (this.maxConcurrentSecureNdpInSystem != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(24, this.maxConcurrentSecureNdpInSystem);
            }
            if (this.maxConcurrentNdpPerNdi != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(25, this.maxConcurrentNdpPerNdi);
            }
            if (this.histogramAwareAvailableDurationMs != null && this.histogramAwareAvailableDurationMs.length > 0) {
                for (i = 0; i < this.histogramAwareAvailableDurationMs.length; ++i) {
                    element = this.histogramAwareAvailableDurationMs[i];
                    if (element == null) continue;
                    size += CodedOutputByteBufferNano.computeMessageSize(26, element);
                }
            }
            if (this.histogramAwareEnabledDurationMs != null && this.histogramAwareEnabledDurationMs.length > 0) {
                for (i = 0; i < this.histogramAwareEnabledDurationMs.length; ++i) {
                    element = this.histogramAwareEnabledDurationMs[i];
                    if (element == null) continue;
                    size += CodedOutputByteBufferNano.computeMessageSize(27, element);
                }
            }
            if (this.histogramAttachDurationMs != null && this.histogramAttachDurationMs.length > 0) {
                for (i = 0; i < this.histogramAttachDurationMs.length; ++i) {
                    element = this.histogramAttachDurationMs[i];
                    if (element == null) continue;
                    size += CodedOutputByteBufferNano.computeMessageSize(28, element);
                }
            }
            if (this.histogramPublishSessionDurationMs != null && this.histogramPublishSessionDurationMs.length > 0) {
                for (i = 0; i < this.histogramPublishSessionDurationMs.length; ++i) {
                    element = this.histogramPublishSessionDurationMs[i];
                    if (element == null) continue;
                    size += CodedOutputByteBufferNano.computeMessageSize(29, element);
                }
            }
            if (this.histogramSubscribeSessionDurationMs != null && this.histogramSubscribeSessionDurationMs.length > 0) {
                for (i = 0; i < this.histogramSubscribeSessionDurationMs.length; ++i) {
                    element = this.histogramSubscribeSessionDurationMs[i];
                    if (element == null) continue;
                    size += CodedOutputByteBufferNano.computeMessageSize(30, element);
                }
            }
            if (this.histogramNdpSessionDurationMs != null && this.histogramNdpSessionDurationMs.length > 0) {
                for (i = 0; i < this.histogramNdpSessionDurationMs.length; ++i) {
                    element = this.histogramNdpSessionDurationMs[i];
                    if (element == null) continue;
                    size += CodedOutputByteBufferNano.computeMessageSize(31, element);
                }
            }
            if (this.histogramNdpSessionDataUsageMb != null && this.histogramNdpSessionDataUsageMb.length > 0) {
                for (i = 0; i < this.histogramNdpSessionDataUsageMb.length; ++i) {
                    element = this.histogramNdpSessionDataUsageMb[i];
                    if (element == null) continue;
                    size += CodedOutputByteBufferNano.computeMessageSize(32, element);
                }
            }
            if (this.histogramNdpCreationTimeMs != null && this.histogramNdpCreationTimeMs.length > 0) {
                for (i = 0; i < this.histogramNdpCreationTimeMs.length; ++i) {
                    element = this.histogramNdpCreationTimeMs[i];
                    if (element == null) continue;
                    size += CodedOutputByteBufferNano.computeMessageSize(33, element);
                }
            }
            if (this.ndpCreationTimeMsMin != 0L) {
                size += CodedOutputByteBufferNano.computeInt64Size(34, this.ndpCreationTimeMsMin);
            }
            if (this.ndpCreationTimeMsMax != 0L) {
                size += CodedOutputByteBufferNano.computeInt64Size(35, this.ndpCreationTimeMsMax);
            }
            if (this.ndpCreationTimeMsSum != 0L) {
                size += CodedOutputByteBufferNano.computeInt64Size(36, this.ndpCreationTimeMsSum);
            }
            if (this.ndpCreationTimeMsSumOfSq != 0L) {
                size += CodedOutputByteBufferNano.computeInt64Size(37, this.ndpCreationTimeMsSumOfSq);
            }
            if (this.ndpCreationTimeMsNumSamples != 0L) {
                size += CodedOutputByteBufferNano.computeInt64Size(38, this.ndpCreationTimeMsNumSamples);
            }
            if (this.availableTimeMs != 0L) {
                size += CodedOutputByteBufferNano.computeInt64Size(39, this.availableTimeMs);
            }
            if (this.enabledTimeMs != 0L) {
                size += CodedOutputByteBufferNano.computeInt64Size(40, this.enabledTimeMs);
            }
            if (this.maxConcurrentPublishWithRangingInApp != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(41, this.maxConcurrentPublishWithRangingInApp);
            }
            if (this.maxConcurrentSubscribeWithRangingInApp != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(42, this.maxConcurrentSubscribeWithRangingInApp);
            }
            if (this.maxConcurrentPublishWithRangingInSystem != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(43, this.maxConcurrentPublishWithRangingInSystem);
            }
            if (this.maxConcurrentSubscribeWithRangingInSystem != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(44, this.maxConcurrentSubscribeWithRangingInSystem);
            }
            if (this.histogramSubscribeGeofenceMin != null && this.histogramSubscribeGeofenceMin.length > 0) {
                for (i = 0; i < this.histogramSubscribeGeofenceMin.length; ++i) {
                    element = this.histogramSubscribeGeofenceMin[i];
                    if (element == null) continue;
                    size += CodedOutputByteBufferNano.computeMessageSize(45, element);
                }
            }
            if (this.histogramSubscribeGeofenceMax != null && this.histogramSubscribeGeofenceMax.length > 0) {
                for (i = 0; i < this.histogramSubscribeGeofenceMax.length; ++i) {
                    element = this.histogramSubscribeGeofenceMax[i];
                    if (element == null) continue;
                    size += CodedOutputByteBufferNano.computeMessageSize(46, element);
                }
            }
            if (this.numSubscribesWithRanging != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(47, this.numSubscribesWithRanging);
            }
            if (this.numMatchesWithRanging != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(48, this.numMatchesWithRanging);
            }
            if (this.numMatchesWithoutRangingForRangingEnabledSubscribes != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(49, this.numMatchesWithoutRangingForRangingEnabledSubscribes);
            }
            return size;
        }

        @Override
        public WifiAwareLog mergeFrom(CodedInputByteBufferNano input) throws IOException {
            block49: while (true) {
                int tag = input.readTag();
                switch (tag) {
                    case 0: {
                        return this;
                    }
                    default: {
                        if (WireFormatNano.parseUnknownField(input, tag)) continue block49;
                        return this;
                    }
                    case 8: {
                        this.numApps = input.readInt32();
                        continue block49;
                    }
                    case 16: {
                        this.numAppsUsingIdentityCallback = input.readInt32();
                        continue block49;
                    }
                    case 24: {
                        this.maxConcurrentAttachSessionsInApp = input.readInt32();
                        continue block49;
                    }
                    case 34: {
                        int arrayLength = WireFormatNano.getRepeatedFieldArrayLength(input, 34);
                        int i = this.histogramAttachSessionStatus == null ? 0 : this.histogramAttachSessionStatus.length;
                        MessageNano[] newArray = new NanStatusHistogramBucket[i + arrayLength];
                        if (i != 0) {
                            System.arraycopy(this.histogramAttachSessionStatus, 0, newArray, 0, i);
                        }
                        while (i < newArray.length - 1) {
                            newArray[i] = new NanStatusHistogramBucket();
                            input.readMessage(newArray[i]);
                            input.readTag();
                            ++i;
                        }
                        newArray[i] = new NanStatusHistogramBucket();
                        input.readMessage(newArray[i]);
                        this.histogramAttachSessionStatus = newArray;
                        continue block49;
                    }
                    case 40: {
                        this.maxConcurrentPublishInApp = input.readInt32();
                        continue block49;
                    }
                    case 48: {
                        this.maxConcurrentSubscribeInApp = input.readInt32();
                        continue block49;
                    }
                    case 56: {
                        this.maxConcurrentDiscoverySessionsInApp = input.readInt32();
                        continue block49;
                    }
                    case 64: {
                        this.maxConcurrentPublishInSystem = input.readInt32();
                        continue block49;
                    }
                    case 72: {
                        this.maxConcurrentSubscribeInSystem = input.readInt32();
                        continue block49;
                    }
                    case 80: {
                        this.maxConcurrentDiscoverySessionsInSystem = input.readInt32();
                        continue block49;
                    }
                    case 90: {
                        int arrayLength = WireFormatNano.getRepeatedFieldArrayLength(input, 90);
                        int i = this.histogramPublishStatus == null ? 0 : this.histogramPublishStatus.length;
                        MessageNano[] newArray = new NanStatusHistogramBucket[i + arrayLength];
                        if (i != 0) {
                            System.arraycopy(this.histogramPublishStatus, 0, newArray, 0, i);
                        }
                        while (i < newArray.length - 1) {
                            newArray[i] = new NanStatusHistogramBucket();
                            input.readMessage(newArray[i]);
                            input.readTag();
                            ++i;
                        }
                        newArray[i] = new NanStatusHistogramBucket();
                        input.readMessage(newArray[i]);
                        this.histogramPublishStatus = newArray;
                        continue block49;
                    }
                    case 98: {
                        int arrayLength = WireFormatNano.getRepeatedFieldArrayLength(input, 98);
                        int i = this.histogramSubscribeStatus == null ? 0 : this.histogramSubscribeStatus.length;
                        MessageNano[] newArray = new NanStatusHistogramBucket[i + arrayLength];
                        if (i != 0) {
                            System.arraycopy(this.histogramSubscribeStatus, 0, newArray, 0, i);
                        }
                        while (i < newArray.length - 1) {
                            newArray[i] = new NanStatusHistogramBucket();
                            input.readMessage(newArray[i]);
                            input.readTag();
                            ++i;
                        }
                        newArray[i] = new NanStatusHistogramBucket();
                        input.readMessage(newArray[i]);
                        this.histogramSubscribeStatus = newArray;
                        continue block49;
                    }
                    case 104: {
                        this.numAppsWithDiscoverySessionFailureOutOfResources = input.readInt32();
                        continue block49;
                    }
                    case 114: {
                        int arrayLength = WireFormatNano.getRepeatedFieldArrayLength(input, 114);
                        int i = this.histogramRequestNdpStatus == null ? 0 : this.histogramRequestNdpStatus.length;
                        MessageNano[] newArray = new NanStatusHistogramBucket[i + arrayLength];
                        if (i != 0) {
                            System.arraycopy(this.histogramRequestNdpStatus, 0, newArray, 0, i);
                        }
                        while (i < newArray.length - 1) {
                            newArray[i] = new NanStatusHistogramBucket();
                            input.readMessage(newArray[i]);
                            input.readTag();
                            ++i;
                        }
                        newArray[i] = new NanStatusHistogramBucket();
                        input.readMessage(newArray[i]);
                        this.histogramRequestNdpStatus = newArray;
                        continue block49;
                    }
                    case 122: {
                        int arrayLength = WireFormatNano.getRepeatedFieldArrayLength(input, 122);
                        int i = this.histogramRequestNdpOobStatus == null ? 0 : this.histogramRequestNdpOobStatus.length;
                        MessageNano[] newArray = new NanStatusHistogramBucket[i + arrayLength];
                        if (i != 0) {
                            System.arraycopy(this.histogramRequestNdpOobStatus, 0, newArray, 0, i);
                        }
                        while (i < newArray.length - 1) {
                            newArray[i] = new NanStatusHistogramBucket();
                            input.readMessage(newArray[i]);
                            input.readTag();
                            ++i;
                        }
                        newArray[i] = new NanStatusHistogramBucket();
                        input.readMessage(newArray[i]);
                        this.histogramRequestNdpOobStatus = newArray;
                        continue block49;
                    }
                    case 152: {
                        this.maxConcurrentNdiInApp = input.readInt32();
                        continue block49;
                    }
                    case 160: {
                        this.maxConcurrentNdiInSystem = input.readInt32();
                        continue block49;
                    }
                    case 168: {
                        this.maxConcurrentNdpInApp = input.readInt32();
                        continue block49;
                    }
                    case 176: {
                        this.maxConcurrentNdpInSystem = input.readInt32();
                        continue block49;
                    }
                    case 184: {
                        this.maxConcurrentSecureNdpInApp = input.readInt32();
                        continue block49;
                    }
                    case 192: {
                        this.maxConcurrentSecureNdpInSystem = input.readInt32();
                        continue block49;
                    }
                    case 200: {
                        this.maxConcurrentNdpPerNdi = input.readInt32();
                        continue block49;
                    }
                    case 210: {
                        int arrayLength = WireFormatNano.getRepeatedFieldArrayLength(input, 210);
                        int i = this.histogramAwareAvailableDurationMs == null ? 0 : this.histogramAwareAvailableDurationMs.length;
                        MessageNano[] newArray = new HistogramBucket[i + arrayLength];
                        if (i != 0) {
                            System.arraycopy(this.histogramAwareAvailableDurationMs, 0, newArray, 0, i);
                        }
                        while (i < newArray.length - 1) {
                            newArray[i] = new HistogramBucket();
                            input.readMessage(newArray[i]);
                            input.readTag();
                            ++i;
                        }
                        newArray[i] = new HistogramBucket();
                        input.readMessage(newArray[i]);
                        this.histogramAwareAvailableDurationMs = newArray;
                        continue block49;
                    }
                    case 218: {
                        int arrayLength = WireFormatNano.getRepeatedFieldArrayLength(input, 218);
                        int i = this.histogramAwareEnabledDurationMs == null ? 0 : this.histogramAwareEnabledDurationMs.length;
                        MessageNano[] newArray = new HistogramBucket[i + arrayLength];
                        if (i != 0) {
                            System.arraycopy(this.histogramAwareEnabledDurationMs, 0, newArray, 0, i);
                        }
                        while (i < newArray.length - 1) {
                            newArray[i] = new HistogramBucket();
                            input.readMessage(newArray[i]);
                            input.readTag();
                            ++i;
                        }
                        newArray[i] = new HistogramBucket();
                        input.readMessage(newArray[i]);
                        this.histogramAwareEnabledDurationMs = newArray;
                        continue block49;
                    }
                    case 226: {
                        int arrayLength = WireFormatNano.getRepeatedFieldArrayLength(input, 226);
                        int i = this.histogramAttachDurationMs == null ? 0 : this.histogramAttachDurationMs.length;
                        MessageNano[] newArray = new HistogramBucket[i + arrayLength];
                        if (i != 0) {
                            System.arraycopy(this.histogramAttachDurationMs, 0, newArray, 0, i);
                        }
                        while (i < newArray.length - 1) {
                            newArray[i] = new HistogramBucket();
                            input.readMessage(newArray[i]);
                            input.readTag();
                            ++i;
                        }
                        newArray[i] = new HistogramBucket();
                        input.readMessage(newArray[i]);
                        this.histogramAttachDurationMs = newArray;
                        continue block49;
                    }
                    case 234: {
                        int arrayLength = WireFormatNano.getRepeatedFieldArrayLength(input, 234);
                        int i = this.histogramPublishSessionDurationMs == null ? 0 : this.histogramPublishSessionDurationMs.length;
                        MessageNano[] newArray = new HistogramBucket[i + arrayLength];
                        if (i != 0) {
                            System.arraycopy(this.histogramPublishSessionDurationMs, 0, newArray, 0, i);
                        }
                        while (i < newArray.length - 1) {
                            newArray[i] = new HistogramBucket();
                            input.readMessage(newArray[i]);
                            input.readTag();
                            ++i;
                        }
                        newArray[i] = new HistogramBucket();
                        input.readMessage(newArray[i]);
                        this.histogramPublishSessionDurationMs = newArray;
                        continue block49;
                    }
                    case 242: {
                        int arrayLength = WireFormatNano.getRepeatedFieldArrayLength(input, 242);
                        int i = this.histogramSubscribeSessionDurationMs == null ? 0 : this.histogramSubscribeSessionDurationMs.length;
                        MessageNano[] newArray = new HistogramBucket[i + arrayLength];
                        if (i != 0) {
                            System.arraycopy(this.histogramSubscribeSessionDurationMs, 0, newArray, 0, i);
                        }
                        while (i < newArray.length - 1) {
                            newArray[i] = new HistogramBucket();
                            input.readMessage(newArray[i]);
                            input.readTag();
                            ++i;
                        }
                        newArray[i] = new HistogramBucket();
                        input.readMessage(newArray[i]);
                        this.histogramSubscribeSessionDurationMs = newArray;
                        continue block49;
                    }
                    case 250: {
                        int arrayLength = WireFormatNano.getRepeatedFieldArrayLength(input, 250);
                        int i = this.histogramNdpSessionDurationMs == null ? 0 : this.histogramNdpSessionDurationMs.length;
                        MessageNano[] newArray = new HistogramBucket[i + arrayLength];
                        if (i != 0) {
                            System.arraycopy(this.histogramNdpSessionDurationMs, 0, newArray, 0, i);
                        }
                        while (i < newArray.length - 1) {
                            newArray[i] = new HistogramBucket();
                            input.readMessage(newArray[i]);
                            input.readTag();
                            ++i;
                        }
                        newArray[i] = new HistogramBucket();
                        input.readMessage(newArray[i]);
                        this.histogramNdpSessionDurationMs = newArray;
                        continue block49;
                    }
                    case 258: {
                        int arrayLength = WireFormatNano.getRepeatedFieldArrayLength(input, 258);
                        int i = this.histogramNdpSessionDataUsageMb == null ? 0 : this.histogramNdpSessionDataUsageMb.length;
                        MessageNano[] newArray = new HistogramBucket[i + arrayLength];
                        if (i != 0) {
                            System.arraycopy(this.histogramNdpSessionDataUsageMb, 0, newArray, 0, i);
                        }
                        while (i < newArray.length - 1) {
                            newArray[i] = new HistogramBucket();
                            input.readMessage(newArray[i]);
                            input.readTag();
                            ++i;
                        }
                        newArray[i] = new HistogramBucket();
                        input.readMessage(newArray[i]);
                        this.histogramNdpSessionDataUsageMb = newArray;
                        continue block49;
                    }
                    case 266: {
                        int arrayLength = WireFormatNano.getRepeatedFieldArrayLength(input, 266);
                        int i = this.histogramNdpCreationTimeMs == null ? 0 : this.histogramNdpCreationTimeMs.length;
                        MessageNano[] newArray = new HistogramBucket[i + arrayLength];
                        if (i != 0) {
                            System.arraycopy(this.histogramNdpCreationTimeMs, 0, newArray, 0, i);
                        }
                        while (i < newArray.length - 1) {
                            newArray[i] = new HistogramBucket();
                            input.readMessage(newArray[i]);
                            input.readTag();
                            ++i;
                        }
                        newArray[i] = new HistogramBucket();
                        input.readMessage(newArray[i]);
                        this.histogramNdpCreationTimeMs = newArray;
                        continue block49;
                    }
                    case 272: {
                        this.ndpCreationTimeMsMin = input.readInt64();
                        continue block49;
                    }
                    case 280: {
                        this.ndpCreationTimeMsMax = input.readInt64();
                        continue block49;
                    }
                    case 288: {
                        this.ndpCreationTimeMsSum = input.readInt64();
                        continue block49;
                    }
                    case 296: {
                        this.ndpCreationTimeMsSumOfSq = input.readInt64();
                        continue block49;
                    }
                    case 304: {
                        this.ndpCreationTimeMsNumSamples = input.readInt64();
                        continue block49;
                    }
                    case 312: {
                        this.availableTimeMs = input.readInt64();
                        continue block49;
                    }
                    case 320: {
                        this.enabledTimeMs = input.readInt64();
                        continue block49;
                    }
                    case 328: {
                        this.maxConcurrentPublishWithRangingInApp = input.readInt32();
                        continue block49;
                    }
                    case 336: {
                        this.maxConcurrentSubscribeWithRangingInApp = input.readInt32();
                        continue block49;
                    }
                    case 344: {
                        this.maxConcurrentPublishWithRangingInSystem = input.readInt32();
                        continue block49;
                    }
                    case 352: {
                        this.maxConcurrentSubscribeWithRangingInSystem = input.readInt32();
                        continue block49;
                    }
                    case 362: {
                        int arrayLength = WireFormatNano.getRepeatedFieldArrayLength(input, 362);
                        int i = this.histogramSubscribeGeofenceMin == null ? 0 : this.histogramSubscribeGeofenceMin.length;
                        MessageNano[] newArray = new HistogramBucket[i + arrayLength];
                        if (i != 0) {
                            System.arraycopy(this.histogramSubscribeGeofenceMin, 0, newArray, 0, i);
                        }
                        while (i < newArray.length - 1) {
                            newArray[i] = new HistogramBucket();
                            input.readMessage(newArray[i]);
                            input.readTag();
                            ++i;
                        }
                        newArray[i] = new HistogramBucket();
                        input.readMessage(newArray[i]);
                        this.histogramSubscribeGeofenceMin = newArray;
                        continue block49;
                    }
                    case 370: {
                        int arrayLength = WireFormatNano.getRepeatedFieldArrayLength(input, 370);
                        int i = this.histogramSubscribeGeofenceMax == null ? 0 : this.histogramSubscribeGeofenceMax.length;
                        MessageNano[] newArray = new HistogramBucket[i + arrayLength];
                        if (i != 0) {
                            System.arraycopy(this.histogramSubscribeGeofenceMax, 0, newArray, 0, i);
                        }
                        while (i < newArray.length - 1) {
                            newArray[i] = new HistogramBucket();
                            input.readMessage(newArray[i]);
                            input.readTag();
                            ++i;
                        }
                        newArray[i] = new HistogramBucket();
                        input.readMessage(newArray[i]);
                        this.histogramSubscribeGeofenceMax = newArray;
                        continue block49;
                    }
                    case 376: {
                        this.numSubscribesWithRanging = input.readInt32();
                        continue block49;
                    }
                    case 384: {
                        this.numMatchesWithRanging = input.readInt32();
                        continue block49;
                    }
                    case 392: 
                }
                this.numMatchesWithoutRangingForRangingEnabledSubscribes = input.readInt32();
            }
        }

        public static WifiAwareLog parseFrom(byte[] data) throws InvalidProtocolBufferNanoException {
            return MessageNano.mergeFrom(new WifiAwareLog(), data);
        }

        public static WifiAwareLog parseFrom(CodedInputByteBufferNano input) throws IOException {
            return new WifiAwareLog().mergeFrom(input);
        }

        public static final class NanStatusHistogramBucket
        extends MessageNano {
            private static volatile NanStatusHistogramBucket[] _emptyArray;
            public int nanStatusType;
            public int count;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public static NanStatusHistogramBucket[] emptyArray() {
                if (_emptyArray == null) {
                    Object object = InternalNano.LAZY_INIT_LOCK;
                    synchronized (object) {
                        if (_emptyArray == null) {
                            _emptyArray = new NanStatusHistogramBucket[0];
                        }
                    }
                }
                return _emptyArray;
            }

            public NanStatusHistogramBucket() {
                this.clear();
            }

            public NanStatusHistogramBucket clear() {
                this.nanStatusType = 0;
                this.count = 0;
                this.cachedSize = -1;
                return this;
            }

            @Override
            public void writeTo(CodedOutputByteBufferNano output) throws IOException {
                if (this.nanStatusType != 0) {
                    output.writeInt32(1, this.nanStatusType);
                }
                if (this.count != 0) {
                    output.writeInt32(2, this.count);
                }
                super.writeTo(output);
            }

            @Override
            protected int computeSerializedSize() {
                int size = super.computeSerializedSize();
                if (this.nanStatusType != 0) {
                    size += CodedOutputByteBufferNano.computeInt32Size(1, this.nanStatusType);
                }
                if (this.count != 0) {
                    size += CodedOutputByteBufferNano.computeInt32Size(2, this.count);
                }
                return size;
            }

            @Override
            public NanStatusHistogramBucket mergeFrom(CodedInputByteBufferNano input) throws IOException {
                block8: while (true) {
                    int tag = input.readTag();
                    switch (tag) {
                        case 0: {
                            return this;
                        }
                        default: {
                            if (WireFormatNano.parseUnknownField(input, tag)) continue block8;
                            return this;
                        }
                        case 8: {
                            int value = input.readInt32();
                            switch (value) {
                                case 0: 
                                case 1: 
                                case 2: 
                                case 3: 
                                case 4: 
                                case 5: 
                                case 6: 
                                case 7: 
                                case 8: 
                                case 9: 
                                case 10: 
                                case 11: 
                                case 12: 
                                case 13: 
                                case 14: {
                                    this.nanStatusType = value;
                                }
                            }
                            continue block8;
                        }
                        case 16: 
                    }
                    this.count = input.readInt32();
                }
            }

            public static NanStatusHistogramBucket parseFrom(byte[] data) throws InvalidProtocolBufferNanoException {
                return MessageNano.mergeFrom(new NanStatusHistogramBucket(), data);
            }

            public static NanStatusHistogramBucket parseFrom(CodedInputByteBufferNano input) throws IOException {
                return new NanStatusHistogramBucket().mergeFrom(input);
            }
        }

        public static final class HistogramBucket
        extends MessageNano {
            private static volatile HistogramBucket[] _emptyArray;
            public long start;
            public long end;
            public int count;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public static HistogramBucket[] emptyArray() {
                if (_emptyArray == null) {
                    Object object = InternalNano.LAZY_INIT_LOCK;
                    synchronized (object) {
                        if (_emptyArray == null) {
                            _emptyArray = new HistogramBucket[0];
                        }
                    }
                }
                return _emptyArray;
            }

            public HistogramBucket() {
                this.clear();
            }

            public HistogramBucket clear() {
                this.start = 0L;
                this.end = 0L;
                this.count = 0;
                this.cachedSize = -1;
                return this;
            }

            @Override
            public void writeTo(CodedOutputByteBufferNano output) throws IOException {
                if (this.start != 0L) {
                    output.writeInt64(1, this.start);
                }
                if (this.end != 0L) {
                    output.writeInt64(2, this.end);
                }
                if (this.count != 0) {
                    output.writeInt32(3, this.count);
                }
                super.writeTo(output);
            }

            @Override
            protected int computeSerializedSize() {
                int size = super.computeSerializedSize();
                if (this.start != 0L) {
                    size += CodedOutputByteBufferNano.computeInt64Size(1, this.start);
                }
                if (this.end != 0L) {
                    size += CodedOutputByteBufferNano.computeInt64Size(2, this.end);
                }
                if (this.count != 0) {
                    size += CodedOutputByteBufferNano.computeInt32Size(3, this.count);
                }
                return size;
            }

            @Override
            public HistogramBucket mergeFrom(CodedInputByteBufferNano input) throws IOException {
                block6: while (true) {
                    int tag = input.readTag();
                    switch (tag) {
                        case 0: {
                            return this;
                        }
                        default: {
                            if (WireFormatNano.parseUnknownField(input, tag)) continue block6;
                            return this;
                        }
                        case 8: {
                            this.start = input.readInt64();
                            continue block6;
                        }
                        case 16: {
                            this.end = input.readInt64();
                            continue block6;
                        }
                        case 24: 
                    }
                    this.count = input.readInt32();
                }
            }

            public static HistogramBucket parseFrom(byte[] data) throws InvalidProtocolBufferNanoException {
                return MessageNano.mergeFrom(new HistogramBucket(), data);
            }

            public static HistogramBucket parseFrom(CodedInputByteBufferNano input) throws IOException {
                return new HistogramBucket().mergeFrom(input);
            }
        }
    }

    public static final class StaEvent
    extends MessageNano {
        public static final int TYPE_UNKNOWN = 0;
        public static final int TYPE_ASSOCIATION_REJECTION_EVENT = 1;
        public static final int TYPE_AUTHENTICATION_FAILURE_EVENT = 2;
        public static final int TYPE_NETWORK_CONNECTION_EVENT = 3;
        public static final int TYPE_NETWORK_DISCONNECTION_EVENT = 4;
        public static final int TYPE_SUPPLICANT_STATE_CHANGE_EVENT = 5;
        public static final int TYPE_CMD_ASSOCIATED_BSSID = 6;
        public static final int TYPE_CMD_IP_CONFIGURATION_SUCCESSFUL = 7;
        public static final int TYPE_CMD_IP_CONFIGURATION_LOST = 8;
        public static final int TYPE_CMD_IP_REACHABILITY_LOST = 9;
        public static final int TYPE_CMD_TARGET_BSSID = 10;
        public static final int TYPE_CMD_START_CONNECT = 11;
        public static final int TYPE_CMD_START_ROAM = 12;
        public static final int TYPE_CONNECT_NETWORK = 13;
        public static final int TYPE_NETWORK_AGENT_VALID_NETWORK = 14;
        public static final int TYPE_FRAMEWORK_DISCONNECT = 15;
        public static final int TYPE_SCORE_BREACH = 16;
        public static final int TYPE_MAC_CHANGE = 17;
        public static final int TYPE_WIFI_ENABLED = 18;
        public static final int TYPE_WIFI_DISABLED = 19;
        public static final int TYPE_WIFI_USABILITY_SCORE_BREACH = 20;
        public static final int TYPE_LINK_PROBE = 21;
        public static final int DISCONNECT_UNKNOWN = 0;
        public static final int DISCONNECT_API = 1;
        public static final int DISCONNECT_GENERIC = 2;
        public static final int DISCONNECT_UNWANTED = 3;
        public static final int DISCONNECT_ROAM_WATCHDOG_TIMER = 4;
        public static final int DISCONNECT_P2P_DISCONNECT_WIFI_REQUEST = 5;
        public static final int DISCONNECT_RESET_SIM_NETWORKS = 6;
        public static final int AUTH_FAILURE_UNKNOWN = 0;
        public static final int AUTH_FAILURE_NONE = 1;
        public static final int AUTH_FAILURE_TIMEOUT = 2;
        public static final int AUTH_FAILURE_WRONG_PSWD = 3;
        public static final int AUTH_FAILURE_EAP_FAILURE = 4;
        public static final int STATE_DISCONNECTED = 0;
        public static final int STATE_INTERFACE_DISABLED = 1;
        public static final int STATE_INACTIVE = 2;
        public static final int STATE_SCANNING = 3;
        public static final int STATE_AUTHENTICATING = 4;
        public static final int STATE_ASSOCIATING = 5;
        public static final int STATE_ASSOCIATED = 6;
        public static final int STATE_FOUR_WAY_HANDSHAKE = 7;
        public static final int STATE_GROUP_HANDSHAKE = 8;
        public static final int STATE_COMPLETED = 9;
        public static final int STATE_DORMANT = 10;
        public static final int STATE_UNINITIALIZED = 11;
        public static final int STATE_INVALID = 12;
        private static volatile StaEvent[] _emptyArray;
        public int type;
        public int reason;
        public int status;
        public boolean localGen;
        public ConfigInfo configInfo;
        public int lastRssi;
        public int lastLinkSpeed;
        public int lastFreq;
        public int supplicantStateChangesBitmask;
        public long startTimeMillis;
        public int frameworkDisconnectReason;
        public boolean associationTimedOut;
        public int authFailureReason;
        public int lastScore;
        public int lastWifiUsabilityScore;
        public int lastPredictionHorizonSec;
        public boolean linkProbeWasSuccess;
        public int linkProbeSuccessElapsedTimeMs;
        public int linkProbeFailureReason;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static StaEvent[] emptyArray() {
            if (_emptyArray == null) {
                Object object = InternalNano.LAZY_INIT_LOCK;
                synchronized (object) {
                    if (_emptyArray == null) {
                        _emptyArray = new StaEvent[0];
                    }
                }
            }
            return _emptyArray;
        }

        public StaEvent() {
            this.clear();
        }

        public StaEvent clear() {
            this.type = 0;
            this.reason = -1;
            this.status = -1;
            this.localGen = false;
            this.configInfo = null;
            this.lastRssi = -127;
            this.lastLinkSpeed = -1;
            this.lastFreq = -1;
            this.supplicantStateChangesBitmask = 0;
            this.startTimeMillis = 0L;
            this.frameworkDisconnectReason = 0;
            this.associationTimedOut = false;
            this.authFailureReason = 0;
            this.lastScore = -1;
            this.lastWifiUsabilityScore = -1;
            this.lastPredictionHorizonSec = -1;
            this.linkProbeWasSuccess = false;
            this.linkProbeSuccessElapsedTimeMs = 0;
            this.linkProbeFailureReason = 0;
            this.cachedSize = -1;
            return this;
        }

        @Override
        public void writeTo(CodedOutputByteBufferNano output) throws IOException {
            if (this.type != 0) {
                output.writeInt32(1, this.type);
            }
            if (this.reason != -1) {
                output.writeInt32(2, this.reason);
            }
            if (this.status != -1) {
                output.writeInt32(3, this.status);
            }
            if (this.localGen) {
                output.writeBool(4, this.localGen);
            }
            if (this.configInfo != null) {
                output.writeMessage(5, this.configInfo);
            }
            if (this.lastRssi != -127) {
                output.writeInt32(6, this.lastRssi);
            }
            if (this.lastLinkSpeed != -1) {
                output.writeInt32(7, this.lastLinkSpeed);
            }
            if (this.lastFreq != -1) {
                output.writeInt32(8, this.lastFreq);
            }
            if (this.supplicantStateChangesBitmask != 0) {
                output.writeUInt32(9, this.supplicantStateChangesBitmask);
            }
            if (this.startTimeMillis != 0L) {
                output.writeInt64(10, this.startTimeMillis);
            }
            if (this.frameworkDisconnectReason != 0) {
                output.writeInt32(11, this.frameworkDisconnectReason);
            }
            if (this.associationTimedOut) {
                output.writeBool(12, this.associationTimedOut);
            }
            if (this.authFailureReason != 0) {
                output.writeInt32(13, this.authFailureReason);
            }
            if (this.lastScore != -1) {
                output.writeInt32(14, this.lastScore);
            }
            if (this.lastWifiUsabilityScore != -1) {
                output.writeInt32(15, this.lastWifiUsabilityScore);
            }
            if (this.lastPredictionHorizonSec != -1) {
                output.writeInt32(16, this.lastPredictionHorizonSec);
            }
            if (this.linkProbeWasSuccess) {
                output.writeBool(17, this.linkProbeWasSuccess);
            }
            if (this.linkProbeSuccessElapsedTimeMs != 0) {
                output.writeInt32(18, this.linkProbeSuccessElapsedTimeMs);
            }
            if (this.linkProbeFailureReason != 0) {
                output.writeInt32(19, this.linkProbeFailureReason);
            }
            super.writeTo(output);
        }

        @Override
        protected int computeSerializedSize() {
            int size = super.computeSerializedSize();
            if (this.type != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(1, this.type);
            }
            if (this.reason != -1) {
                size += CodedOutputByteBufferNano.computeInt32Size(2, this.reason);
            }
            if (this.status != -1) {
                size += CodedOutputByteBufferNano.computeInt32Size(3, this.status);
            }
            if (this.localGen) {
                size += CodedOutputByteBufferNano.computeBoolSize(4, this.localGen);
            }
            if (this.configInfo != null) {
                size += CodedOutputByteBufferNano.computeMessageSize(5, this.configInfo);
            }
            if (this.lastRssi != -127) {
                size += CodedOutputByteBufferNano.computeInt32Size(6, this.lastRssi);
            }
            if (this.lastLinkSpeed != -1) {
                size += CodedOutputByteBufferNano.computeInt32Size(7, this.lastLinkSpeed);
            }
            if (this.lastFreq != -1) {
                size += CodedOutputByteBufferNano.computeInt32Size(8, this.lastFreq);
            }
            if (this.supplicantStateChangesBitmask != 0) {
                size += CodedOutputByteBufferNano.computeUInt32Size(9, this.supplicantStateChangesBitmask);
            }
            if (this.startTimeMillis != 0L) {
                size += CodedOutputByteBufferNano.computeInt64Size(10, this.startTimeMillis);
            }
            if (this.frameworkDisconnectReason != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(11, this.frameworkDisconnectReason);
            }
            if (this.associationTimedOut) {
                size += CodedOutputByteBufferNano.computeBoolSize(12, this.associationTimedOut);
            }
            if (this.authFailureReason != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(13, this.authFailureReason);
            }
            if (this.lastScore != -1) {
                size += CodedOutputByteBufferNano.computeInt32Size(14, this.lastScore);
            }
            if (this.lastWifiUsabilityScore != -1) {
                size += CodedOutputByteBufferNano.computeInt32Size(15, this.lastWifiUsabilityScore);
            }
            if (this.lastPredictionHorizonSec != -1) {
                size += CodedOutputByteBufferNano.computeInt32Size(16, this.lastPredictionHorizonSec);
            }
            if (this.linkProbeWasSuccess) {
                size += CodedOutputByteBufferNano.computeBoolSize(17, this.linkProbeWasSuccess);
            }
            if (this.linkProbeSuccessElapsedTimeMs != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(18, this.linkProbeSuccessElapsedTimeMs);
            }
            if (this.linkProbeFailureReason != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(19, this.linkProbeFailureReason);
            }
            return size;
        }

        @Override
        public StaEvent mergeFrom(CodedInputByteBufferNano input) throws IOException {
            block34: while (true) {
                int value;
                int tag = input.readTag();
                switch (tag) {
                    case 0: {
                        return this;
                    }
                    default: {
                        if (WireFormatNano.parseUnknownField(input, tag)) continue block34;
                        return this;
                    }
                    case 8: {
                        value = input.readInt32();
                        switch (value) {
                            case 0: 
                            case 1: 
                            case 2: 
                            case 3: 
                            case 4: 
                            case 5: 
                            case 6: 
                            case 7: 
                            case 8: 
                            case 9: 
                            case 10: 
                            case 11: 
                            case 12: 
                            case 13: 
                            case 14: 
                            case 15: 
                            case 16: 
                            case 17: 
                            case 18: 
                            case 19: 
                            case 20: 
                            case 21: {
                                this.type = value;
                            }
                        }
                        continue block34;
                    }
                    case 16: {
                        this.reason = input.readInt32();
                        continue block34;
                    }
                    case 24: {
                        this.status = input.readInt32();
                        continue block34;
                    }
                    case 32: {
                        this.localGen = input.readBool();
                        continue block34;
                    }
                    case 42: {
                        if (this.configInfo == null) {
                            this.configInfo = new ConfigInfo();
                        }
                        input.readMessage(this.configInfo);
                        continue block34;
                    }
                    case 48: {
                        this.lastRssi = input.readInt32();
                        continue block34;
                    }
                    case 56: {
                        this.lastLinkSpeed = input.readInt32();
                        continue block34;
                    }
                    case 64: {
                        this.lastFreq = input.readInt32();
                        continue block34;
                    }
                    case 72: {
                        this.supplicantStateChangesBitmask = input.readUInt32();
                        continue block34;
                    }
                    case 80: {
                        this.startTimeMillis = input.readInt64();
                        continue block34;
                    }
                    case 88: {
                        value = input.readInt32();
                        switch (value) {
                            case 0: 
                            case 1: 
                            case 2: 
                            case 3: 
                            case 4: 
                            case 5: 
                            case 6: {
                                this.frameworkDisconnectReason = value;
                            }
                        }
                        continue block34;
                    }
                    case 96: {
                        this.associationTimedOut = input.readBool();
                        continue block34;
                    }
                    case 104: {
                        value = input.readInt32();
                        switch (value) {
                            case 0: 
                            case 1: 
                            case 2: 
                            case 3: 
                            case 4: {
                                this.authFailureReason = value;
                            }
                        }
                        continue block34;
                    }
                    case 112: {
                        this.lastScore = input.readInt32();
                        continue block34;
                    }
                    case 120: {
                        this.lastWifiUsabilityScore = input.readInt32();
                        continue block34;
                    }
                    case 128: {
                        this.lastPredictionHorizonSec = input.readInt32();
                        continue block34;
                    }
                    case 136: {
                        this.linkProbeWasSuccess = input.readBool();
                        continue block34;
                    }
                    case 144: {
                        this.linkProbeSuccessElapsedTimeMs = input.readInt32();
                        continue block34;
                    }
                    case 152: 
                }
                value = input.readInt32();
                switch (value) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        this.linkProbeFailureReason = value;
                    }
                }
            }
        }

        public static StaEvent parseFrom(byte[] data) throws InvalidProtocolBufferNanoException {
            return MessageNano.mergeFrom(new StaEvent(), data);
        }

        public static StaEvent parseFrom(CodedInputByteBufferNano input) throws IOException {
            return new StaEvent().mergeFrom(input);
        }

        public static final class ConfigInfo
        extends MessageNano {
            private static volatile ConfigInfo[] _emptyArray;
            public int allowedKeyManagement;
            public int allowedProtocols;
            public int allowedAuthAlgorithms;
            public int allowedPairwiseCiphers;
            public int allowedGroupCiphers;
            public boolean hiddenSsid;
            public boolean isPasspoint;
            public boolean isEphemeral;
            public boolean hasEverConnected;
            public int scanRssi;
            public int scanFreq;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public static ConfigInfo[] emptyArray() {
                if (_emptyArray == null) {
                    Object object = InternalNano.LAZY_INIT_LOCK;
                    synchronized (object) {
                        if (_emptyArray == null) {
                            _emptyArray = new ConfigInfo[0];
                        }
                    }
                }
                return _emptyArray;
            }

            public ConfigInfo() {
                this.clear();
            }

            public ConfigInfo clear() {
                this.allowedKeyManagement = 0;
                this.allowedProtocols = 0;
                this.allowedAuthAlgorithms = 0;
                this.allowedPairwiseCiphers = 0;
                this.allowedGroupCiphers = 0;
                this.hiddenSsid = false;
                this.isPasspoint = false;
                this.isEphemeral = false;
                this.hasEverConnected = false;
                this.scanRssi = -127;
                this.scanFreq = -1;
                this.cachedSize = -1;
                return this;
            }

            @Override
            public void writeTo(CodedOutputByteBufferNano output) throws IOException {
                if (this.allowedKeyManagement != 0) {
                    output.writeUInt32(1, this.allowedKeyManagement);
                }
                if (this.allowedProtocols != 0) {
                    output.writeUInt32(2, this.allowedProtocols);
                }
                if (this.allowedAuthAlgorithms != 0) {
                    output.writeUInt32(3, this.allowedAuthAlgorithms);
                }
                if (this.allowedPairwiseCiphers != 0) {
                    output.writeUInt32(4, this.allowedPairwiseCiphers);
                }
                if (this.allowedGroupCiphers != 0) {
                    output.writeUInt32(5, this.allowedGroupCiphers);
                }
                if (this.hiddenSsid) {
                    output.writeBool(6, this.hiddenSsid);
                }
                if (this.isPasspoint) {
                    output.writeBool(7, this.isPasspoint);
                }
                if (this.isEphemeral) {
                    output.writeBool(8, this.isEphemeral);
                }
                if (this.hasEverConnected) {
                    output.writeBool(9, this.hasEverConnected);
                }
                if (this.scanRssi != -127) {
                    output.writeInt32(10, this.scanRssi);
                }
                if (this.scanFreq != -1) {
                    output.writeInt32(11, this.scanFreq);
                }
                super.writeTo(output);
            }

            @Override
            protected int computeSerializedSize() {
                int size = super.computeSerializedSize();
                if (this.allowedKeyManagement != 0) {
                    size += CodedOutputByteBufferNano.computeUInt32Size(1, this.allowedKeyManagement);
                }
                if (this.allowedProtocols != 0) {
                    size += CodedOutputByteBufferNano.computeUInt32Size(2, this.allowedProtocols);
                }
                if (this.allowedAuthAlgorithms != 0) {
                    size += CodedOutputByteBufferNano.computeUInt32Size(3, this.allowedAuthAlgorithms);
                }
                if (this.allowedPairwiseCiphers != 0) {
                    size += CodedOutputByteBufferNano.computeUInt32Size(4, this.allowedPairwiseCiphers);
                }
                if (this.allowedGroupCiphers != 0) {
                    size += CodedOutputByteBufferNano.computeUInt32Size(5, this.allowedGroupCiphers);
                }
                if (this.hiddenSsid) {
                    size += CodedOutputByteBufferNano.computeBoolSize(6, this.hiddenSsid);
                }
                if (this.isPasspoint) {
                    size += CodedOutputByteBufferNano.computeBoolSize(7, this.isPasspoint);
                }
                if (this.isEphemeral) {
                    size += CodedOutputByteBufferNano.computeBoolSize(8, this.isEphemeral);
                }
                if (this.hasEverConnected) {
                    size += CodedOutputByteBufferNano.computeBoolSize(9, this.hasEverConnected);
                }
                if (this.scanRssi != -127) {
                    size += CodedOutputByteBufferNano.computeInt32Size(10, this.scanRssi);
                }
                if (this.scanFreq != -1) {
                    size += CodedOutputByteBufferNano.computeInt32Size(11, this.scanFreq);
                }
                return size;
            }

            @Override
            public ConfigInfo mergeFrom(CodedInputByteBufferNano input) throws IOException {
                block14: while (true) {
                    int tag = input.readTag();
                    switch (tag) {
                        case 0: {
                            return this;
                        }
                        default: {
                            if (WireFormatNano.parseUnknownField(input, tag)) continue block14;
                            return this;
                        }
                        case 8: {
                            this.allowedKeyManagement = input.readUInt32();
                            continue block14;
                        }
                        case 16: {
                            this.allowedProtocols = input.readUInt32();
                            continue block14;
                        }
                        case 24: {
                            this.allowedAuthAlgorithms = input.readUInt32();
                            continue block14;
                        }
                        case 32: {
                            this.allowedPairwiseCiphers = input.readUInt32();
                            continue block14;
                        }
                        case 40: {
                            this.allowedGroupCiphers = input.readUInt32();
                            continue block14;
                        }
                        case 48: {
                            this.hiddenSsid = input.readBool();
                            continue block14;
                        }
                        case 56: {
                            this.isPasspoint = input.readBool();
                            continue block14;
                        }
                        case 64: {
                            this.isEphemeral = input.readBool();
                            continue block14;
                        }
                        case 72: {
                            this.hasEverConnected = input.readBool();
                            continue block14;
                        }
                        case 80: {
                            this.scanRssi = input.readInt32();
                            continue block14;
                        }
                        case 88: 
                    }
                    this.scanFreq = input.readInt32();
                }
            }

            public static ConfigInfo parseFrom(byte[] data) throws InvalidProtocolBufferNanoException {
                return MessageNano.mergeFrom(new ConfigInfo(), data);
            }

            public static ConfigInfo parseFrom(CodedInputByteBufferNano input) throws IOException {
                return new ConfigInfo().mergeFrom(input);
            }
        }
    }

    public static final class SoftApReturnCodeCount
    extends MessageNano {
        public static final int SOFT_AP_RETURN_CODE_UNKNOWN = 0;
        public static final int SOFT_AP_STARTED_SUCCESSFULLY = 1;
        public static final int SOFT_AP_FAILED_GENERAL_ERROR = 2;
        public static final int SOFT_AP_FAILED_NO_CHANNEL = 3;
        private static volatile SoftApReturnCodeCount[] _emptyArray;
        public int returnCode;
        public int count;
        public int startResult;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static SoftApReturnCodeCount[] emptyArray() {
            if (_emptyArray == null) {
                Object object = InternalNano.LAZY_INIT_LOCK;
                synchronized (object) {
                    if (_emptyArray == null) {
                        _emptyArray = new SoftApReturnCodeCount[0];
                    }
                }
            }
            return _emptyArray;
        }

        public SoftApReturnCodeCount() {
            this.clear();
        }

        public SoftApReturnCodeCount clear() {
            this.returnCode = 0;
            this.count = 0;
            this.startResult = 0;
            this.cachedSize = -1;
            return this;
        }

        @Override
        public void writeTo(CodedOutputByteBufferNano output) throws IOException {
            if (this.returnCode != 0) {
                output.writeInt32(1, this.returnCode);
            }
            if (this.count != 0) {
                output.writeInt32(2, this.count);
            }
            if (this.startResult != 0) {
                output.writeInt32(3, this.startResult);
            }
            super.writeTo(output);
        }

        @Override
        protected int computeSerializedSize() {
            int size = super.computeSerializedSize();
            if (this.returnCode != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(1, this.returnCode);
            }
            if (this.count != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(2, this.count);
            }
            if (this.startResult != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(3, this.startResult);
            }
            return size;
        }

        @Override
        public SoftApReturnCodeCount mergeFrom(CodedInputByteBufferNano input) throws IOException {
            block9: while (true) {
                int tag = input.readTag();
                switch (tag) {
                    case 0: {
                        return this;
                    }
                    default: {
                        if (WireFormatNano.parseUnknownField(input, tag)) continue block9;
                        return this;
                    }
                    case 8: {
                        this.returnCode = input.readInt32();
                        continue block9;
                    }
                    case 16: {
                        this.count = input.readInt32();
                        continue block9;
                    }
                    case 24: 
                }
                int value = input.readInt32();
                switch (value) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: {
                        this.startResult = value;
                    }
                }
            }
        }

        public static SoftApReturnCodeCount parseFrom(byte[] data) throws InvalidProtocolBufferNanoException {
            return MessageNano.mergeFrom(new SoftApReturnCodeCount(), data);
        }

        public static SoftApReturnCodeCount parseFrom(CodedInputByteBufferNano input) throws IOException {
            return new SoftApReturnCodeCount().mergeFrom(input);
        }
    }

    public static final class SoftApDurationBucket
    extends MessageNano {
        private static volatile SoftApDurationBucket[] _emptyArray;
        public int durationSec;
        public int bucketSizeSec;
        public int count;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static SoftApDurationBucket[] emptyArray() {
            if (_emptyArray == null) {
                Object object = InternalNano.LAZY_INIT_LOCK;
                synchronized (object) {
                    if (_emptyArray == null) {
                        _emptyArray = new SoftApDurationBucket[0];
                    }
                }
            }
            return _emptyArray;
        }

        public SoftApDurationBucket() {
            this.clear();
        }

        public SoftApDurationBucket clear() {
            this.durationSec = 0;
            this.bucketSizeSec = 0;
            this.count = 0;
            this.cachedSize = -1;
            return this;
        }

        @Override
        public void writeTo(CodedOutputByteBufferNano output) throws IOException {
            if (this.durationSec != 0) {
                output.writeInt32(1, this.durationSec);
            }
            if (this.bucketSizeSec != 0) {
                output.writeInt32(2, this.bucketSizeSec);
            }
            if (this.count != 0) {
                output.writeInt32(3, this.count);
            }
            super.writeTo(output);
        }

        @Override
        protected int computeSerializedSize() {
            int size = super.computeSerializedSize();
            if (this.durationSec != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(1, this.durationSec);
            }
            if (this.bucketSizeSec != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(2, this.bucketSizeSec);
            }
            if (this.count != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(3, this.count);
            }
            return size;
        }

        @Override
        public SoftApDurationBucket mergeFrom(CodedInputByteBufferNano input) throws IOException {
            block6: while (true) {
                int tag = input.readTag();
                switch (tag) {
                    case 0: {
                        return this;
                    }
                    default: {
                        if (WireFormatNano.parseUnknownField(input, tag)) continue block6;
                        return this;
                    }
                    case 8: {
                        this.durationSec = input.readInt32();
                        continue block6;
                    }
                    case 16: {
                        this.bucketSizeSec = input.readInt32();
                        continue block6;
                    }
                    case 24: 
                }
                this.count = input.readInt32();
            }
        }

        public static SoftApDurationBucket parseFrom(byte[] data) throws InvalidProtocolBufferNanoException {
            return MessageNano.mergeFrom(new SoftApDurationBucket(), data);
        }

        public static SoftApDurationBucket parseFrom(CodedInputByteBufferNano input) throws IOException {
            return new SoftApDurationBucket().mergeFrom(input);
        }
    }

    public static final class LinkSpeedCount
    extends MessageNano {
        private static volatile LinkSpeedCount[] _emptyArray;
        public int linkSpeedMbps;
        public int count;
        public int rssiSumDbm;
        public long rssiSumOfSquaresDbmSq;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static LinkSpeedCount[] emptyArray() {
            if (_emptyArray == null) {
                Object object = InternalNano.LAZY_INIT_LOCK;
                synchronized (object) {
                    if (_emptyArray == null) {
                        _emptyArray = new LinkSpeedCount[0];
                    }
                }
            }
            return _emptyArray;
        }

        public LinkSpeedCount() {
            this.clear();
        }

        public LinkSpeedCount clear() {
            this.linkSpeedMbps = 0;
            this.count = 0;
            this.rssiSumDbm = 0;
            this.rssiSumOfSquaresDbmSq = 0L;
            this.cachedSize = -1;
            return this;
        }

        @Override
        public void writeTo(CodedOutputByteBufferNano output) throws IOException {
            if (this.linkSpeedMbps != 0) {
                output.writeInt32(1, this.linkSpeedMbps);
            }
            if (this.count != 0) {
                output.writeInt32(2, this.count);
            }
            if (this.rssiSumDbm != 0) {
                output.writeInt32(3, this.rssiSumDbm);
            }
            if (this.rssiSumOfSquaresDbmSq != 0L) {
                output.writeInt64(4, this.rssiSumOfSquaresDbmSq);
            }
            super.writeTo(output);
        }

        @Override
        protected int computeSerializedSize() {
            int size = super.computeSerializedSize();
            if (this.linkSpeedMbps != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(1, this.linkSpeedMbps);
            }
            if (this.count != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(2, this.count);
            }
            if (this.rssiSumDbm != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(3, this.rssiSumDbm);
            }
            if (this.rssiSumOfSquaresDbmSq != 0L) {
                size += CodedOutputByteBufferNano.computeInt64Size(4, this.rssiSumOfSquaresDbmSq);
            }
            return size;
        }

        @Override
        public LinkSpeedCount mergeFrom(CodedInputByteBufferNano input) throws IOException {
            block7: while (true) {
                int tag = input.readTag();
                switch (tag) {
                    case 0: {
                        return this;
                    }
                    default: {
                        if (WireFormatNano.parseUnknownField(input, tag)) continue block7;
                        return this;
                    }
                    case 8: {
                        this.linkSpeedMbps = input.readInt32();
                        continue block7;
                    }
                    case 16: {
                        this.count = input.readInt32();
                        continue block7;
                    }
                    case 24: {
                        this.rssiSumDbm = input.readInt32();
                        continue block7;
                    }
                    case 32: 
                }
                this.rssiSumOfSquaresDbmSq = input.readInt64();
            }
        }

        public static LinkSpeedCount parseFrom(byte[] data) throws InvalidProtocolBufferNanoException {
            return MessageNano.mergeFrom(new LinkSpeedCount(), data);
        }

        public static LinkSpeedCount parseFrom(CodedInputByteBufferNano input) throws IOException {
            return new LinkSpeedCount().mergeFrom(input);
        }
    }

    public static final class WifiUsabilityScoreCount
    extends MessageNano {
        private static volatile WifiUsabilityScoreCount[] _emptyArray;
        public int score;
        public int count;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static WifiUsabilityScoreCount[] emptyArray() {
            if (_emptyArray == null) {
                Object object = InternalNano.LAZY_INIT_LOCK;
                synchronized (object) {
                    if (_emptyArray == null) {
                        _emptyArray = new WifiUsabilityScoreCount[0];
                    }
                }
            }
            return _emptyArray;
        }

        public WifiUsabilityScoreCount() {
            this.clear();
        }

        public WifiUsabilityScoreCount clear() {
            this.score = 0;
            this.count = 0;
            this.cachedSize = -1;
            return this;
        }

        @Override
        public void writeTo(CodedOutputByteBufferNano output) throws IOException {
            if (this.score != 0) {
                output.writeInt32(1, this.score);
            }
            if (this.count != 0) {
                output.writeInt32(2, this.count);
            }
            super.writeTo(output);
        }

        @Override
        protected int computeSerializedSize() {
            int size = super.computeSerializedSize();
            if (this.score != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(1, this.score);
            }
            if (this.count != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(2, this.count);
            }
            return size;
        }

        @Override
        public WifiUsabilityScoreCount mergeFrom(CodedInputByteBufferNano input) throws IOException {
            block5: while (true) {
                int tag = input.readTag();
                switch (tag) {
                    case 0: {
                        return this;
                    }
                    default: {
                        if (WireFormatNano.parseUnknownField(input, tag)) continue block5;
                        return this;
                    }
                    case 8: {
                        this.score = input.readInt32();
                        continue block5;
                    }
                    case 16: 
                }
                this.count = input.readInt32();
            }
        }

        public static WifiUsabilityScoreCount parseFrom(byte[] data) throws InvalidProtocolBufferNanoException {
            return MessageNano.mergeFrom(new WifiUsabilityScoreCount(), data);
        }

        public static WifiUsabilityScoreCount parseFrom(CodedInputByteBufferNano input) throws IOException {
            return new WifiUsabilityScoreCount().mergeFrom(input);
        }
    }

    public static final class WifiScoreCount
    extends MessageNano {
        private static volatile WifiScoreCount[] _emptyArray;
        public int score;
        public int count;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static WifiScoreCount[] emptyArray() {
            if (_emptyArray == null) {
                Object object = InternalNano.LAZY_INIT_LOCK;
                synchronized (object) {
                    if (_emptyArray == null) {
                        _emptyArray = new WifiScoreCount[0];
                    }
                }
            }
            return _emptyArray;
        }

        public WifiScoreCount() {
            this.clear();
        }

        public WifiScoreCount clear() {
            this.score = 0;
            this.count = 0;
            this.cachedSize = -1;
            return this;
        }

        @Override
        public void writeTo(CodedOutputByteBufferNano output) throws IOException {
            if (this.score != 0) {
                output.writeInt32(1, this.score);
            }
            if (this.count != 0) {
                output.writeInt32(2, this.count);
            }
            super.writeTo(output);
        }

        @Override
        protected int computeSerializedSize() {
            int size = super.computeSerializedSize();
            if (this.score != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(1, this.score);
            }
            if (this.count != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(2, this.count);
            }
            return size;
        }

        @Override
        public WifiScoreCount mergeFrom(CodedInputByteBufferNano input) throws IOException {
            block5: while (true) {
                int tag = input.readTag();
                switch (tag) {
                    case 0: {
                        return this;
                    }
                    default: {
                        if (WireFormatNano.parseUnknownField(input, tag)) continue block5;
                        return this;
                    }
                    case 8: {
                        this.score = input.readInt32();
                        continue block5;
                    }
                    case 16: 
                }
                this.count = input.readInt32();
            }
        }

        public static WifiScoreCount parseFrom(byte[] data) throws InvalidProtocolBufferNanoException {
            return MessageNano.mergeFrom(new WifiScoreCount(), data);
        }

        public static WifiScoreCount parseFrom(CodedInputByteBufferNano input) throws IOException {
            return new WifiScoreCount().mergeFrom(input);
        }
    }

    public static final class AlertReasonCount
    extends MessageNano {
        private static volatile AlertReasonCount[] _emptyArray;
        public int reason;
        public int count;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static AlertReasonCount[] emptyArray() {
            if (_emptyArray == null) {
                Object object = InternalNano.LAZY_INIT_LOCK;
                synchronized (object) {
                    if (_emptyArray == null) {
                        _emptyArray = new AlertReasonCount[0];
                    }
                }
            }
            return _emptyArray;
        }

        public AlertReasonCount() {
            this.clear();
        }

        public AlertReasonCount clear() {
            this.reason = 0;
            this.count = 0;
            this.cachedSize = -1;
            return this;
        }

        @Override
        public void writeTo(CodedOutputByteBufferNano output) throws IOException {
            if (this.reason != 0) {
                output.writeInt32(1, this.reason);
            }
            if (this.count != 0) {
                output.writeInt32(2, this.count);
            }
            super.writeTo(output);
        }

        @Override
        protected int computeSerializedSize() {
            int size = super.computeSerializedSize();
            if (this.reason != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(1, this.reason);
            }
            if (this.count != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(2, this.count);
            }
            return size;
        }

        @Override
        public AlertReasonCount mergeFrom(CodedInputByteBufferNano input) throws IOException {
            block5: while (true) {
                int tag = input.readTag();
                switch (tag) {
                    case 0: {
                        return this;
                    }
                    default: {
                        if (WireFormatNano.parseUnknownField(input, tag)) continue block5;
                        return this;
                    }
                    case 8: {
                        this.reason = input.readInt32();
                        continue block5;
                    }
                    case 16: 
                }
                this.count = input.readInt32();
            }
        }

        public static AlertReasonCount parseFrom(byte[] data) throws InvalidProtocolBufferNanoException {
            return MessageNano.mergeFrom(new AlertReasonCount(), data);
        }

        public static AlertReasonCount parseFrom(CodedInputByteBufferNano input) throws IOException {
            return new AlertReasonCount().mergeFrom(input);
        }
    }

    public static final class RssiPollCount
    extends MessageNano {
        private static volatile RssiPollCount[] _emptyArray;
        public int rssi;
        public int count;
        public int frequency;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static RssiPollCount[] emptyArray() {
            if (_emptyArray == null) {
                Object object = InternalNano.LAZY_INIT_LOCK;
                synchronized (object) {
                    if (_emptyArray == null) {
                        _emptyArray = new RssiPollCount[0];
                    }
                }
            }
            return _emptyArray;
        }

        public RssiPollCount() {
            this.clear();
        }

        public RssiPollCount clear() {
            this.rssi = 0;
            this.count = 0;
            this.frequency = 0;
            this.cachedSize = -1;
            return this;
        }

        @Override
        public void writeTo(CodedOutputByteBufferNano output) throws IOException {
            if (this.rssi != 0) {
                output.writeInt32(1, this.rssi);
            }
            if (this.count != 0) {
                output.writeInt32(2, this.count);
            }
            if (this.frequency != 0) {
                output.writeInt32(3, this.frequency);
            }
            super.writeTo(output);
        }

        @Override
        protected int computeSerializedSize() {
            int size = super.computeSerializedSize();
            if (this.rssi != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(1, this.rssi);
            }
            if (this.count != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(2, this.count);
            }
            if (this.frequency != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(3, this.frequency);
            }
            return size;
        }

        @Override
        public RssiPollCount mergeFrom(CodedInputByteBufferNano input) throws IOException {
            block6: while (true) {
                int tag = input.readTag();
                switch (tag) {
                    case 0: {
                        return this;
                    }
                    default: {
                        if (WireFormatNano.parseUnknownField(input, tag)) continue block6;
                        return this;
                    }
                    case 8: {
                        this.rssi = input.readInt32();
                        continue block6;
                    }
                    case 16: {
                        this.count = input.readInt32();
                        continue block6;
                    }
                    case 24: 
                }
                this.frequency = input.readInt32();
            }
        }

        public static RssiPollCount parseFrom(byte[] data) throws InvalidProtocolBufferNanoException {
            return MessageNano.mergeFrom(new RssiPollCount(), data);
        }

        public static RssiPollCount parseFrom(CodedInputByteBufferNano input) throws IOException {
            return new RssiPollCount().mergeFrom(input);
        }
    }

    public static final class ConnectionEvent
    extends MessageNano {
        public static final int ROAM_UNKNOWN = 0;
        public static final int ROAM_NONE = 1;
        public static final int ROAM_DBDC = 2;
        public static final int ROAM_ENTERPRISE = 3;
        public static final int ROAM_USER_SELECTED = 4;
        public static final int ROAM_UNRELATED = 5;
        public static final int HLF_UNKNOWN = 0;
        public static final int HLF_NONE = 1;
        public static final int HLF_DHCP = 2;
        public static final int HLF_NO_INTERNET = 3;
        public static final int HLF_UNWANTED = 4;
        public static final int FAILURE_REASON_UNKNOWN = 0;
        public static final int AUTH_FAILURE_NONE = 1;
        public static final int AUTH_FAILURE_TIMEOUT = 2;
        public static final int AUTH_FAILURE_WRONG_PSWD = 3;
        public static final int AUTH_FAILURE_EAP_FAILURE = 4;
        public static final int NOMINATOR_UNKNOWN = 0;
        public static final int NOMINATOR_MANUAL = 1;
        public static final int NOMINATOR_SAVED = 2;
        public static final int NOMINATOR_SUGGESTION = 3;
        public static final int NOMINATOR_PASSPOINT = 4;
        public static final int NOMINATOR_CARRIER = 5;
        public static final int NOMINATOR_EXTERNAL_SCORED = 6;
        public static final int NOMINATOR_SPECIFIER = 7;
        public static final int NOMINATOR_SAVED_USER_CONNECT_CHOICE = 8;
        public static final int NOMINATOR_OPEN_NETWORK_AVAILABLE = 9;
        private static volatile ConnectionEvent[] _emptyArray;
        public long startTimeMillis;
        public int durationTakenToConnectMillis;
        public RouterFingerPrint routerFingerprint;
        public int signalStrength;
        public int roamType;
        public int connectionResult;
        public int level2FailureCode;
        public int connectivityLevelFailureCode;
        public boolean automaticBugReportTaken;
        public boolean useRandomizedMac;
        public int connectionNominator;
        public int networkSelectorExperimentId;
        public int level2FailureReason;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static ConnectionEvent[] emptyArray() {
            if (_emptyArray == null) {
                Object object = InternalNano.LAZY_INIT_LOCK;
                synchronized (object) {
                    if (_emptyArray == null) {
                        _emptyArray = new ConnectionEvent[0];
                    }
                }
            }
            return _emptyArray;
        }

        public ConnectionEvent() {
            this.clear();
        }

        public ConnectionEvent clear() {
            this.startTimeMillis = 0L;
            this.durationTakenToConnectMillis = 0;
            this.routerFingerprint = null;
            this.signalStrength = 0;
            this.roamType = 0;
            this.connectionResult = 0;
            this.level2FailureCode = 0;
            this.connectivityLevelFailureCode = 0;
            this.automaticBugReportTaken = false;
            this.useRandomizedMac = false;
            this.connectionNominator = 0;
            this.networkSelectorExperimentId = 0;
            this.level2FailureReason = 0;
            this.cachedSize = -1;
            return this;
        }

        @Override
        public void writeTo(CodedOutputByteBufferNano output) throws IOException {
            if (this.startTimeMillis != 0L) {
                output.writeInt64(1, this.startTimeMillis);
            }
            if (this.durationTakenToConnectMillis != 0) {
                output.writeInt32(2, this.durationTakenToConnectMillis);
            }
            if (this.routerFingerprint != null) {
                output.writeMessage(3, this.routerFingerprint);
            }
            if (this.signalStrength != 0) {
                output.writeInt32(4, this.signalStrength);
            }
            if (this.roamType != 0) {
                output.writeInt32(5, this.roamType);
            }
            if (this.connectionResult != 0) {
                output.writeInt32(6, this.connectionResult);
            }
            if (this.level2FailureCode != 0) {
                output.writeInt32(7, this.level2FailureCode);
            }
            if (this.connectivityLevelFailureCode != 0) {
                output.writeInt32(8, this.connectivityLevelFailureCode);
            }
            if (this.automaticBugReportTaken) {
                output.writeBool(9, this.automaticBugReportTaken);
            }
            if (this.useRandomizedMac) {
                output.writeBool(10, this.useRandomizedMac);
            }
            if (this.connectionNominator != 0) {
                output.writeInt32(11, this.connectionNominator);
            }
            if (this.networkSelectorExperimentId != 0) {
                output.writeInt32(12, this.networkSelectorExperimentId);
            }
            if (this.level2FailureReason != 0) {
                output.writeInt32(13, this.level2FailureReason);
            }
            super.writeTo(output);
        }

        @Override
        protected int computeSerializedSize() {
            int size = super.computeSerializedSize();
            if (this.startTimeMillis != 0L) {
                size += CodedOutputByteBufferNano.computeInt64Size(1, this.startTimeMillis);
            }
            if (this.durationTakenToConnectMillis != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(2, this.durationTakenToConnectMillis);
            }
            if (this.routerFingerprint != null) {
                size += CodedOutputByteBufferNano.computeMessageSize(3, this.routerFingerprint);
            }
            if (this.signalStrength != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(4, this.signalStrength);
            }
            if (this.roamType != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(5, this.roamType);
            }
            if (this.connectionResult != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(6, this.connectionResult);
            }
            if (this.level2FailureCode != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(7, this.level2FailureCode);
            }
            if (this.connectivityLevelFailureCode != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(8, this.connectivityLevelFailureCode);
            }
            if (this.automaticBugReportTaken) {
                size += CodedOutputByteBufferNano.computeBoolSize(9, this.automaticBugReportTaken);
            }
            if (this.useRandomizedMac) {
                size += CodedOutputByteBufferNano.computeBoolSize(10, this.useRandomizedMac);
            }
            if (this.connectionNominator != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(11, this.connectionNominator);
            }
            if (this.networkSelectorExperimentId != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(12, this.networkSelectorExperimentId);
            }
            if (this.level2FailureReason != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(13, this.level2FailureReason);
            }
            return size;
        }

        @Override
        public ConnectionEvent mergeFrom(CodedInputByteBufferNano input) throws IOException {
            block28: while (true) {
                int value;
                int tag = input.readTag();
                switch (tag) {
                    case 0: {
                        return this;
                    }
                    default: {
                        if (WireFormatNano.parseUnknownField(input, tag)) continue block28;
                        return this;
                    }
                    case 8: {
                        this.startTimeMillis = input.readInt64();
                        continue block28;
                    }
                    case 16: {
                        this.durationTakenToConnectMillis = input.readInt32();
                        continue block28;
                    }
                    case 26: {
                        if (this.routerFingerprint == null) {
                            this.routerFingerprint = new RouterFingerPrint();
                        }
                        input.readMessage(this.routerFingerprint);
                        continue block28;
                    }
                    case 32: {
                        this.signalStrength = input.readInt32();
                        continue block28;
                    }
                    case 40: {
                        value = input.readInt32();
                        switch (value) {
                            case 0: 
                            case 1: 
                            case 2: 
                            case 3: 
                            case 4: 
                            case 5: {
                                this.roamType = value;
                            }
                        }
                        continue block28;
                    }
                    case 48: {
                        this.connectionResult = input.readInt32();
                        continue block28;
                    }
                    case 56: {
                        this.level2FailureCode = input.readInt32();
                        continue block28;
                    }
                    case 64: {
                        value = input.readInt32();
                        switch (value) {
                            case 0: 
                            case 1: 
                            case 2: 
                            case 3: 
                            case 4: {
                                this.connectivityLevelFailureCode = value;
                            }
                        }
                        continue block28;
                    }
                    case 72: {
                        this.automaticBugReportTaken = input.readBool();
                        continue block28;
                    }
                    case 80: {
                        this.useRandomizedMac = input.readBool();
                        continue block28;
                    }
                    case 88: {
                        value = input.readInt32();
                        switch (value) {
                            case 0: 
                            case 1: 
                            case 2: 
                            case 3: 
                            case 4: 
                            case 5: 
                            case 6: 
                            case 7: 
                            case 8: 
                            case 9: {
                                this.connectionNominator = value;
                            }
                        }
                        continue block28;
                    }
                    case 96: {
                        this.networkSelectorExperimentId = input.readInt32();
                        continue block28;
                    }
                    case 104: 
                }
                value = input.readInt32();
                switch (value) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        this.level2FailureReason = value;
                    }
                }
            }
        }

        public static ConnectionEvent parseFrom(byte[] data) throws InvalidProtocolBufferNanoException {
            return MessageNano.mergeFrom(new ConnectionEvent(), data);
        }

        public static ConnectionEvent parseFrom(CodedInputByteBufferNano input) throws IOException {
            return new ConnectionEvent().mergeFrom(input);
        }
    }

    public static final class RouterFingerPrint
    extends MessageNano {
        public static final int ROAM_TYPE_UNKNOWN = 0;
        public static final int ROAM_TYPE_NONE = 1;
        public static final int ROAM_TYPE_ENTERPRISE = 2;
        public static final int ROAM_TYPE_DBDC = 3;
        public static final int AUTH_UNKNOWN = 0;
        public static final int AUTH_OPEN = 1;
        public static final int AUTH_PERSONAL = 2;
        public static final int AUTH_ENTERPRISE = 3;
        public static final int ROUTER_TECH_UNKNOWN = 0;
        public static final int ROUTER_TECH_A = 1;
        public static final int ROUTER_TECH_B = 2;
        public static final int ROUTER_TECH_G = 3;
        public static final int ROUTER_TECH_N = 4;
        public static final int ROUTER_TECH_AC = 5;
        public static final int ROUTER_TECH_OTHER = 6;
        private static volatile RouterFingerPrint[] _emptyArray;
        public int roamType;
        public int channelInfo;
        public int dtim;
        public int authentication;
        public boolean hidden;
        public int routerTechnology;
        public boolean supportsIpv6;
        public boolean passpoint;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static RouterFingerPrint[] emptyArray() {
            if (_emptyArray == null) {
                Object object = InternalNano.LAZY_INIT_LOCK;
                synchronized (object) {
                    if (_emptyArray == null) {
                        _emptyArray = new RouterFingerPrint[0];
                    }
                }
            }
            return _emptyArray;
        }

        public RouterFingerPrint() {
            this.clear();
        }

        public RouterFingerPrint clear() {
            this.roamType = 0;
            this.channelInfo = 0;
            this.dtim = 0;
            this.authentication = 0;
            this.hidden = false;
            this.routerTechnology = 0;
            this.supportsIpv6 = false;
            this.passpoint = false;
            this.cachedSize = -1;
            return this;
        }

        @Override
        public void writeTo(CodedOutputByteBufferNano output) throws IOException {
            if (this.roamType != 0) {
                output.writeInt32(1, this.roamType);
            }
            if (this.channelInfo != 0) {
                output.writeInt32(2, this.channelInfo);
            }
            if (this.dtim != 0) {
                output.writeInt32(3, this.dtim);
            }
            if (this.authentication != 0) {
                output.writeInt32(4, this.authentication);
            }
            if (this.hidden) {
                output.writeBool(5, this.hidden);
            }
            if (this.routerTechnology != 0) {
                output.writeInt32(6, this.routerTechnology);
            }
            if (this.supportsIpv6) {
                output.writeBool(7, this.supportsIpv6);
            }
            if (this.passpoint) {
                output.writeBool(8, this.passpoint);
            }
            super.writeTo(output);
        }

        @Override
        protected int computeSerializedSize() {
            int size = super.computeSerializedSize();
            if (this.roamType != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(1, this.roamType);
            }
            if (this.channelInfo != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(2, this.channelInfo);
            }
            if (this.dtim != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(3, this.dtim);
            }
            if (this.authentication != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(4, this.authentication);
            }
            if (this.hidden) {
                size += CodedOutputByteBufferNano.computeBoolSize(5, this.hidden);
            }
            if (this.routerTechnology != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(6, this.routerTechnology);
            }
            if (this.supportsIpv6) {
                size += CodedOutputByteBufferNano.computeBoolSize(7, this.supportsIpv6);
            }
            if (this.passpoint) {
                size += CodedOutputByteBufferNano.computeBoolSize(8, this.passpoint);
            }
            return size;
        }

        @Override
        public RouterFingerPrint mergeFrom(CodedInputByteBufferNano input) throws IOException {
            block20: while (true) {
                int tag = input.readTag();
                switch (tag) {
                    case 0: {
                        return this;
                    }
                    default: {
                        if (WireFormatNano.parseUnknownField(input, tag)) continue block20;
                        return this;
                    }
                    case 8: {
                        int value = input.readInt32();
                        switch (value) {
                            case 0: 
                            case 1: 
                            case 2: 
                            case 3: {
                                this.roamType = value;
                            }
                        }
                        continue block20;
                    }
                    case 16: {
                        this.channelInfo = input.readInt32();
                        continue block20;
                    }
                    case 24: {
                        this.dtim = input.readInt32();
                        continue block20;
                    }
                    case 32: {
                        int value = input.readInt32();
                        switch (value) {
                            case 0: 
                            case 1: 
                            case 2: 
                            case 3: {
                                this.authentication = value;
                            }
                        }
                        continue block20;
                    }
                    case 40: {
                        this.hidden = input.readBool();
                        continue block20;
                    }
                    case 48: {
                        int value = input.readInt32();
                        switch (value) {
                            case 0: 
                            case 1: 
                            case 2: 
                            case 3: 
                            case 4: 
                            case 5: 
                            case 6: {
                                this.routerTechnology = value;
                            }
                        }
                        continue block20;
                    }
                    case 56: {
                        this.supportsIpv6 = input.readBool();
                        continue block20;
                    }
                    case 64: 
                }
                this.passpoint = input.readBool();
            }
        }

        public static RouterFingerPrint parseFrom(byte[] data) throws InvalidProtocolBufferNanoException {
            return MessageNano.mergeFrom(new RouterFingerPrint(), data);
        }

        public static RouterFingerPrint parseFrom(CodedInputByteBufferNano input) throws IOException {
            return new RouterFingerPrint().mergeFrom(input);
        }
    }

    public static final class WifiLog
    extends MessageNano {
        public static final int SCAN_UNKNOWN = 0;
        public static final int SCAN_SUCCESS = 1;
        public static final int SCAN_FAILURE_INTERRUPTED = 2;
        public static final int SCAN_FAILURE_INVALID_CONFIGURATION = 3;
        public static final int FAILURE_WIFI_DISABLED = 4;
        public static final int WIFI_UNKNOWN = 0;
        public static final int WIFI_DISABLED = 1;
        public static final int WIFI_DISCONNECTED = 2;
        public static final int WIFI_ASSOCIATED = 3;
        private static volatile WifiLog[] _emptyArray;
        public ConnectionEvent[] connectionEvent;
        public int numSavedNetworks;
        public int numOpenNetworks;
        public int numLegacyPersonalNetworks;
        public int numLegacyEnterpriseNetworks;
        public boolean isLocationEnabled;
        public boolean isScanningAlwaysEnabled;
        public int numWifiToggledViaSettings;
        public int numWifiToggledViaAirplane;
        public int numNetworksAddedByUser;
        public int numNetworksAddedByApps;
        public int numEmptyScanResults;
        public int numNonEmptyScanResults;
        public int numOneshotScans;
        public int numBackgroundScans;
        public ScanReturnEntry[] scanReturnEntries;
        public WifiSystemStateEntry[] wifiSystemStateEntries;
        public ScanReturnEntry[] backgroundScanReturnEntries;
        public WifiSystemStateEntry[] backgroundScanRequestState;
        public int numLastResortWatchdogTriggers;
        public int numLastResortWatchdogBadAssociationNetworksTotal;
        public int numLastResortWatchdogBadAuthenticationNetworksTotal;
        public int numLastResortWatchdogBadDhcpNetworksTotal;
        public int numLastResortWatchdogBadOtherNetworksTotal;
        public int numLastResortWatchdogAvailableNetworksTotal;
        public int numLastResortWatchdogTriggersWithBadAssociation;
        public int numLastResortWatchdogTriggersWithBadAuthentication;
        public int numLastResortWatchdogTriggersWithBadDhcp;
        public int numLastResortWatchdogTriggersWithBadOther;
        public int numConnectivityWatchdogPnoGood;
        public int numConnectivityWatchdogPnoBad;
        public int numConnectivityWatchdogBackgroundGood;
        public int numConnectivityWatchdogBackgroundBad;
        public int recordDurationSec;
        public RssiPollCount[] rssiPollRssiCount;
        public int numLastResortWatchdogSuccesses;
        public int numHiddenNetworks;
        public int numPasspointNetworks;
        public int numTotalScanResults;
        public int numOpenNetworkScanResults;
        public int numLegacyPersonalNetworkScanResults;
        public int numLegacyEnterpriseNetworkScanResults;
        public int numHiddenNetworkScanResults;
        public int numHotspot2R1NetworkScanResults;
        public int numHotspot2R2NetworkScanResults;
        public int numScans;
        public AlertReasonCount[] alertReasonCount;
        public WifiScoreCount[] wifiScoreCount;
        public SoftApDurationBucket[] softApDuration;
        public SoftApReturnCodeCount[] softApReturnCode;
        public RssiPollCount[] rssiPollDeltaCount;
        public StaEvent[] staEventList;
        public int numHalCrashes;
        public int numWificondCrashes;
        public int numSetupClientInterfaceFailureDueToHal;
        public int numSetupClientInterfaceFailureDueToWificond;
        public WifiAwareLog wifiAwareLog;
        public int numPasspointProviders;
        public int numPasspointProviderInstallation;
        public int numPasspointProviderInstallSuccess;
        public int numPasspointProviderUninstallation;
        public int numPasspointProviderUninstallSuccess;
        public int numPasspointProvidersSuccessfullyConnected;
        public NumConnectableNetworksBucket[] totalSsidsInScanHistogram;
        public NumConnectableNetworksBucket[] totalBssidsInScanHistogram;
        public NumConnectableNetworksBucket[] availableOpenSsidsInScanHistogram;
        public NumConnectableNetworksBucket[] availableOpenBssidsInScanHistogram;
        public NumConnectableNetworksBucket[] availableSavedSsidsInScanHistogram;
        public NumConnectableNetworksBucket[] availableSavedBssidsInScanHistogram;
        public NumConnectableNetworksBucket[] availableOpenOrSavedSsidsInScanHistogram;
        public NumConnectableNetworksBucket[] availableOpenOrSavedBssidsInScanHistogram;
        public NumConnectableNetworksBucket[] availableSavedPasspointProviderProfilesInScanHistogram;
        public NumConnectableNetworksBucket[] availableSavedPasspointProviderBssidsInScanHistogram;
        public int fullBandAllSingleScanListenerResults;
        public int partialAllSingleScanListenerResults;
        public PnoScanMetrics pnoScanMetrics;
        public ConnectToNetworkNotificationAndActionCount[] connectToNetworkNotificationCount;
        public ConnectToNetworkNotificationAndActionCount[] connectToNetworkNotificationActionCount;
        public int openNetworkRecommenderBlacklistSize;
        public boolean isWifiNetworksAvailableNotificationOn;
        public int numOpenNetworkRecommendationUpdates;
        public int numOpenNetworkConnectMessageFailedToSend;
        public NumConnectableNetworksBucket[] observedHotspotR1ApsInScanHistogram;
        public NumConnectableNetworksBucket[] observedHotspotR2ApsInScanHistogram;
        public NumConnectableNetworksBucket[] observedHotspotR1EssInScanHistogram;
        public NumConnectableNetworksBucket[] observedHotspotR2EssInScanHistogram;
        public NumConnectableNetworksBucket[] observedHotspotR1ApsPerEssInScanHistogram;
        public NumConnectableNetworksBucket[] observedHotspotR2ApsPerEssInScanHistogram;
        public SoftApConnectedClientsEvent[] softApConnectedClientsEventsTethered;
        public SoftApConnectedClientsEvent[] softApConnectedClientsEventsLocalOnly;
        public WpsMetrics wpsMetrics;
        public WifiPowerStats wifiPowerStats;
        public int numConnectivityOneshotScans;
        public WifiWakeStats wifiWakeStats;
        public NumConnectableNetworksBucket[] observed80211McSupportingApsInScanHistogram;
        public int numSupplicantCrashes;
        public int numHostapdCrashes;
        public int numSetupClientInterfaceFailureDueToSupplicant;
        public int numSetupSoftApInterfaceFailureDueToHal;
        public int numSetupSoftApInterfaceFailureDueToWificond;
        public int numSetupSoftApInterfaceFailureDueToHostapd;
        public int numClientInterfaceDown;
        public int numSoftApInterfaceDown;
        public int numExternalAppOneshotScanRequests;
        public int numExternalForegroundAppOneshotScanRequestsThrottled;
        public int numExternalBackgroundAppOneshotScanRequestsThrottled;
        public long watchdogTriggerToConnectionSuccessDurationMs;
        public long watchdogTotalConnectionFailureCountAfterTrigger;
        public int numOneshotHasDfsChannelScans;
        public WifiRttLog wifiRttLog;
        public boolean isMacRandomizationOn;
        public int numRadioModeChangeToMcc;
        public int numRadioModeChangeToScc;
        public int numRadioModeChangeToSbs;
        public int numRadioModeChangeToDbs;
        public int numSoftApUserBandPreferenceUnsatisfied;
        public String scoreExperimentId;
        public WifiRadioUsage wifiRadioUsage;
        public ExperimentValues experimentValues;
        public WifiIsUnusableEvent[] wifiIsUnusableEventList;
        public LinkSpeedCount[] linkSpeedCounts;
        public int numSarSensorRegistrationFailures;
        public String hardwareRevision;
        public WifiLinkLayerUsageStats wifiLinkLayerUsageStats;
        public WifiUsabilityStats[] wifiUsabilityStatsList;
        public WifiUsabilityScoreCount[] wifiUsabilityScoreCount;
        public DeviceMobilityStatePnoScanStats[] mobilityStatePnoStatsList;
        public WifiP2pStats wifiP2PStats;
        public WifiDppLog wifiDppLog;
        public int numEnhancedOpenNetworks;
        public int numWpa3PersonalNetworks;
        public int numWpa3EnterpriseNetworks;
        public int numEnhancedOpenNetworkScanResults;
        public int numWpa3PersonalNetworkScanResults;
        public int numWpa3EnterpriseNetworkScanResults;
        public WifiConfigStoreIO wifiConfigStoreIo;
        public int numSavedNetworksWithMacRandomization;
        public LinkProbeStats linkProbeStats;
        public NetworkSelectionExperimentDecisions[] networkSelectionExperimentDecisionsList;
        public WifiNetworkRequestApiLog wifiNetworkRequestApiLog;
        public WifiNetworkSuggestionApiLog wifiNetworkSuggestionApiLog;
        public WifiLockStats wifiLockStats;
        public WifiToggleStats wifiToggleStats;
        public int numAddOrUpdateNetworkCalls;
        public int numEnableNetworkCalls;
        public PasspointProvisionStats passpointProvisionStats;
        public PasspointProfileTypeCount[] installedPasspointProfileTypeForR1;
        public PasspointProfileTypeCount[] installedPasspointProfileTypeForR2;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static WifiLog[] emptyArray() {
            if (_emptyArray == null) {
                Object object = InternalNano.LAZY_INIT_LOCK;
                synchronized (object) {
                    if (_emptyArray == null) {
                        _emptyArray = new WifiLog[0];
                    }
                }
            }
            return _emptyArray;
        }

        public WifiLog() {
            this.clear();
        }

        public WifiLog clear() {
            this.connectionEvent = ConnectionEvent.emptyArray();
            this.numSavedNetworks = 0;
            this.numOpenNetworks = 0;
            this.numLegacyPersonalNetworks = 0;
            this.numLegacyEnterpriseNetworks = 0;
            this.isLocationEnabled = false;
            this.isScanningAlwaysEnabled = false;
            this.numWifiToggledViaSettings = 0;
            this.numWifiToggledViaAirplane = 0;
            this.numNetworksAddedByUser = 0;
            this.numNetworksAddedByApps = 0;
            this.numEmptyScanResults = 0;
            this.numNonEmptyScanResults = 0;
            this.numOneshotScans = 0;
            this.numBackgroundScans = 0;
            this.scanReturnEntries = ScanReturnEntry.emptyArray();
            this.wifiSystemStateEntries = WifiSystemStateEntry.emptyArray();
            this.backgroundScanReturnEntries = ScanReturnEntry.emptyArray();
            this.backgroundScanRequestState = WifiSystemStateEntry.emptyArray();
            this.numLastResortWatchdogTriggers = 0;
            this.numLastResortWatchdogBadAssociationNetworksTotal = 0;
            this.numLastResortWatchdogBadAuthenticationNetworksTotal = 0;
            this.numLastResortWatchdogBadDhcpNetworksTotal = 0;
            this.numLastResortWatchdogBadOtherNetworksTotal = 0;
            this.numLastResortWatchdogAvailableNetworksTotal = 0;
            this.numLastResortWatchdogTriggersWithBadAssociation = 0;
            this.numLastResortWatchdogTriggersWithBadAuthentication = 0;
            this.numLastResortWatchdogTriggersWithBadDhcp = 0;
            this.numLastResortWatchdogTriggersWithBadOther = 0;
            this.numConnectivityWatchdogPnoGood = 0;
            this.numConnectivityWatchdogPnoBad = 0;
            this.numConnectivityWatchdogBackgroundGood = 0;
            this.numConnectivityWatchdogBackgroundBad = 0;
            this.recordDurationSec = 0;
            this.rssiPollRssiCount = RssiPollCount.emptyArray();
            this.numLastResortWatchdogSuccesses = 0;
            this.numHiddenNetworks = 0;
            this.numPasspointNetworks = 0;
            this.numTotalScanResults = 0;
            this.numOpenNetworkScanResults = 0;
            this.numLegacyPersonalNetworkScanResults = 0;
            this.numLegacyEnterpriseNetworkScanResults = 0;
            this.numHiddenNetworkScanResults = 0;
            this.numHotspot2R1NetworkScanResults = 0;
            this.numHotspot2R2NetworkScanResults = 0;
            this.numScans = 0;
            this.alertReasonCount = AlertReasonCount.emptyArray();
            this.wifiScoreCount = WifiScoreCount.emptyArray();
            this.softApDuration = SoftApDurationBucket.emptyArray();
            this.softApReturnCode = SoftApReturnCodeCount.emptyArray();
            this.rssiPollDeltaCount = RssiPollCount.emptyArray();
            this.staEventList = StaEvent.emptyArray();
            this.numHalCrashes = 0;
            this.numWificondCrashes = 0;
            this.numSetupClientInterfaceFailureDueToHal = 0;
            this.numSetupClientInterfaceFailureDueToWificond = 0;
            this.wifiAwareLog = null;
            this.numPasspointProviders = 0;
            this.numPasspointProviderInstallation = 0;
            this.numPasspointProviderInstallSuccess = 0;
            this.numPasspointProviderUninstallation = 0;
            this.numPasspointProviderUninstallSuccess = 0;
            this.numPasspointProvidersSuccessfullyConnected = 0;
            this.totalSsidsInScanHistogram = NumConnectableNetworksBucket.emptyArray();
            this.totalBssidsInScanHistogram = NumConnectableNetworksBucket.emptyArray();
            this.availableOpenSsidsInScanHistogram = NumConnectableNetworksBucket.emptyArray();
            this.availableOpenBssidsInScanHistogram = NumConnectableNetworksBucket.emptyArray();
            this.availableSavedSsidsInScanHistogram = NumConnectableNetworksBucket.emptyArray();
            this.availableSavedBssidsInScanHistogram = NumConnectableNetworksBucket.emptyArray();
            this.availableOpenOrSavedSsidsInScanHistogram = NumConnectableNetworksBucket.emptyArray();
            this.availableOpenOrSavedBssidsInScanHistogram = NumConnectableNetworksBucket.emptyArray();
            this.availableSavedPasspointProviderProfilesInScanHistogram = NumConnectableNetworksBucket.emptyArray();
            this.availableSavedPasspointProviderBssidsInScanHistogram = NumConnectableNetworksBucket.emptyArray();
            this.fullBandAllSingleScanListenerResults = 0;
            this.partialAllSingleScanListenerResults = 0;
            this.pnoScanMetrics = null;
            this.connectToNetworkNotificationCount = ConnectToNetworkNotificationAndActionCount.emptyArray();
            this.connectToNetworkNotificationActionCount = ConnectToNetworkNotificationAndActionCount.emptyArray();
            this.openNetworkRecommenderBlacklistSize = 0;
            this.isWifiNetworksAvailableNotificationOn = false;
            this.numOpenNetworkRecommendationUpdates = 0;
            this.numOpenNetworkConnectMessageFailedToSend = 0;
            this.observedHotspotR1ApsInScanHistogram = NumConnectableNetworksBucket.emptyArray();
            this.observedHotspotR2ApsInScanHistogram = NumConnectableNetworksBucket.emptyArray();
            this.observedHotspotR1EssInScanHistogram = NumConnectableNetworksBucket.emptyArray();
            this.observedHotspotR2EssInScanHistogram = NumConnectableNetworksBucket.emptyArray();
            this.observedHotspotR1ApsPerEssInScanHistogram = NumConnectableNetworksBucket.emptyArray();
            this.observedHotspotR2ApsPerEssInScanHistogram = NumConnectableNetworksBucket.emptyArray();
            this.softApConnectedClientsEventsTethered = SoftApConnectedClientsEvent.emptyArray();
            this.softApConnectedClientsEventsLocalOnly = SoftApConnectedClientsEvent.emptyArray();
            this.wpsMetrics = null;
            this.wifiPowerStats = null;
            this.numConnectivityOneshotScans = 0;
            this.wifiWakeStats = null;
            this.observed80211McSupportingApsInScanHistogram = NumConnectableNetworksBucket.emptyArray();
            this.numSupplicantCrashes = 0;
            this.numHostapdCrashes = 0;
            this.numSetupClientInterfaceFailureDueToSupplicant = 0;
            this.numSetupSoftApInterfaceFailureDueToHal = 0;
            this.numSetupSoftApInterfaceFailureDueToWificond = 0;
            this.numSetupSoftApInterfaceFailureDueToHostapd = 0;
            this.numClientInterfaceDown = 0;
            this.numSoftApInterfaceDown = 0;
            this.numExternalAppOneshotScanRequests = 0;
            this.numExternalForegroundAppOneshotScanRequestsThrottled = 0;
            this.numExternalBackgroundAppOneshotScanRequestsThrottled = 0;
            this.watchdogTriggerToConnectionSuccessDurationMs = -1L;
            this.watchdogTotalConnectionFailureCountAfterTrigger = 0L;
            this.numOneshotHasDfsChannelScans = 0;
            this.wifiRttLog = null;
            this.isMacRandomizationOn = false;
            this.numRadioModeChangeToMcc = 0;
            this.numRadioModeChangeToScc = 0;
            this.numRadioModeChangeToSbs = 0;
            this.numRadioModeChangeToDbs = 0;
            this.numSoftApUserBandPreferenceUnsatisfied = 0;
            this.scoreExperimentId = "";
            this.wifiRadioUsage = null;
            this.experimentValues = null;
            this.wifiIsUnusableEventList = WifiIsUnusableEvent.emptyArray();
            this.linkSpeedCounts = LinkSpeedCount.emptyArray();
            this.numSarSensorRegistrationFailures = 0;
            this.hardwareRevision = "";
            this.wifiLinkLayerUsageStats = null;
            this.wifiUsabilityStatsList = WifiUsabilityStats.emptyArray();
            this.wifiUsabilityScoreCount = WifiUsabilityScoreCount.emptyArray();
            this.mobilityStatePnoStatsList = DeviceMobilityStatePnoScanStats.emptyArray();
            this.wifiP2PStats = null;
            this.wifiDppLog = null;
            this.numEnhancedOpenNetworks = 0;
            this.numWpa3PersonalNetworks = 0;
            this.numWpa3EnterpriseNetworks = 0;
            this.numEnhancedOpenNetworkScanResults = 0;
            this.numWpa3PersonalNetworkScanResults = 0;
            this.numWpa3EnterpriseNetworkScanResults = 0;
            this.wifiConfigStoreIo = null;
            this.numSavedNetworksWithMacRandomization = 0;
            this.linkProbeStats = null;
            this.networkSelectionExperimentDecisionsList = NetworkSelectionExperimentDecisions.emptyArray();
            this.wifiNetworkRequestApiLog = null;
            this.wifiNetworkSuggestionApiLog = null;
            this.wifiLockStats = null;
            this.wifiToggleStats = null;
            this.numAddOrUpdateNetworkCalls = 0;
            this.numEnableNetworkCalls = 0;
            this.passpointProvisionStats = null;
            this.installedPasspointProfileTypeForR1 = PasspointProfileTypeCount.emptyArray();
            this.installedPasspointProfileTypeForR2 = PasspointProfileTypeCount.emptyArray();
            this.cachedSize = -1;
            return this;
        }

        @Override
        public void writeTo(CodedOutputByteBufferNano output) throws IOException {
            MessageNano element;
            int i;
            if (this.connectionEvent != null && this.connectionEvent.length > 0) {
                for (i = 0; i < this.connectionEvent.length; ++i) {
                    element = this.connectionEvent[i];
                    if (element == null) continue;
                    output.writeMessage(1, element);
                }
            }
            if (this.numSavedNetworks != 0) {
                output.writeInt32(2, this.numSavedNetworks);
            }
            if (this.numOpenNetworks != 0) {
                output.writeInt32(3, this.numOpenNetworks);
            }
            if (this.numLegacyPersonalNetworks != 0) {
                output.writeInt32(4, this.numLegacyPersonalNetworks);
            }
            if (this.numLegacyEnterpriseNetworks != 0) {
                output.writeInt32(5, this.numLegacyEnterpriseNetworks);
            }
            if (this.isLocationEnabled) {
                output.writeBool(6, this.isLocationEnabled);
            }
            if (this.isScanningAlwaysEnabled) {
                output.writeBool(7, this.isScanningAlwaysEnabled);
            }
            if (this.numWifiToggledViaSettings != 0) {
                output.writeInt32(8, this.numWifiToggledViaSettings);
            }
            if (this.numWifiToggledViaAirplane != 0) {
                output.writeInt32(9, this.numWifiToggledViaAirplane);
            }
            if (this.numNetworksAddedByUser != 0) {
                output.writeInt32(10, this.numNetworksAddedByUser);
            }
            if (this.numNetworksAddedByApps != 0) {
                output.writeInt32(11, this.numNetworksAddedByApps);
            }
            if (this.numEmptyScanResults != 0) {
                output.writeInt32(12, this.numEmptyScanResults);
            }
            if (this.numNonEmptyScanResults != 0) {
                output.writeInt32(13, this.numNonEmptyScanResults);
            }
            if (this.numOneshotScans != 0) {
                output.writeInt32(14, this.numOneshotScans);
            }
            if (this.numBackgroundScans != 0) {
                output.writeInt32(15, this.numBackgroundScans);
            }
            if (this.scanReturnEntries != null && this.scanReturnEntries.length > 0) {
                for (i = 0; i < this.scanReturnEntries.length; ++i) {
                    element = this.scanReturnEntries[i];
                    if (element == null) continue;
                    output.writeMessage(16, element);
                }
            }
            if (this.wifiSystemStateEntries != null && this.wifiSystemStateEntries.length > 0) {
                for (i = 0; i < this.wifiSystemStateEntries.length; ++i) {
                    element = this.wifiSystemStateEntries[i];
                    if (element == null) continue;
                    output.writeMessage(17, element);
                }
            }
            if (this.backgroundScanReturnEntries != null && this.backgroundScanReturnEntries.length > 0) {
                for (i = 0; i < this.backgroundScanReturnEntries.length; ++i) {
                    element = this.backgroundScanReturnEntries[i];
                    if (element == null) continue;
                    output.writeMessage(18, element);
                }
            }
            if (this.backgroundScanRequestState != null && this.backgroundScanRequestState.length > 0) {
                for (i = 0; i < this.backgroundScanRequestState.length; ++i) {
                    element = this.backgroundScanRequestState[i];
                    if (element == null) continue;
                    output.writeMessage(19, element);
                }
            }
            if (this.numLastResortWatchdogTriggers != 0) {
                output.writeInt32(20, this.numLastResortWatchdogTriggers);
            }
            if (this.numLastResortWatchdogBadAssociationNetworksTotal != 0) {
                output.writeInt32(21, this.numLastResortWatchdogBadAssociationNetworksTotal);
            }
            if (this.numLastResortWatchdogBadAuthenticationNetworksTotal != 0) {
                output.writeInt32(22, this.numLastResortWatchdogBadAuthenticationNetworksTotal);
            }
            if (this.numLastResortWatchdogBadDhcpNetworksTotal != 0) {
                output.writeInt32(23, this.numLastResortWatchdogBadDhcpNetworksTotal);
            }
            if (this.numLastResortWatchdogBadOtherNetworksTotal != 0) {
                output.writeInt32(24, this.numLastResortWatchdogBadOtherNetworksTotal);
            }
            if (this.numLastResortWatchdogAvailableNetworksTotal != 0) {
                output.writeInt32(25, this.numLastResortWatchdogAvailableNetworksTotal);
            }
            if (this.numLastResortWatchdogTriggersWithBadAssociation != 0) {
                output.writeInt32(26, this.numLastResortWatchdogTriggersWithBadAssociation);
            }
            if (this.numLastResortWatchdogTriggersWithBadAuthentication != 0) {
                output.writeInt32(27, this.numLastResortWatchdogTriggersWithBadAuthentication);
            }
            if (this.numLastResortWatchdogTriggersWithBadDhcp != 0) {
                output.writeInt32(28, this.numLastResortWatchdogTriggersWithBadDhcp);
            }
            if (this.numLastResortWatchdogTriggersWithBadOther != 0) {
                output.writeInt32(29, this.numLastResortWatchdogTriggersWithBadOther);
            }
            if (this.numConnectivityWatchdogPnoGood != 0) {
                output.writeInt32(30, this.numConnectivityWatchdogPnoGood);
            }
            if (this.numConnectivityWatchdogPnoBad != 0) {
                output.writeInt32(31, this.numConnectivityWatchdogPnoBad);
            }
            if (this.numConnectivityWatchdogBackgroundGood != 0) {
                output.writeInt32(32, this.numConnectivityWatchdogBackgroundGood);
            }
            if (this.numConnectivityWatchdogBackgroundBad != 0) {
                output.writeInt32(33, this.numConnectivityWatchdogBackgroundBad);
            }
            if (this.recordDurationSec != 0) {
                output.writeInt32(34, this.recordDurationSec);
            }
            if (this.rssiPollRssiCount != null && this.rssiPollRssiCount.length > 0) {
                for (i = 0; i < this.rssiPollRssiCount.length; ++i) {
                    element = this.rssiPollRssiCount[i];
                    if (element == null) continue;
                    output.writeMessage(35, element);
                }
            }
            if (this.numLastResortWatchdogSuccesses != 0) {
                output.writeInt32(36, this.numLastResortWatchdogSuccesses);
            }
            if (this.numHiddenNetworks != 0) {
                output.writeInt32(37, this.numHiddenNetworks);
            }
            if (this.numPasspointNetworks != 0) {
                output.writeInt32(38, this.numPasspointNetworks);
            }
            if (this.numTotalScanResults != 0) {
                output.writeInt32(39, this.numTotalScanResults);
            }
            if (this.numOpenNetworkScanResults != 0) {
                output.writeInt32(40, this.numOpenNetworkScanResults);
            }
            if (this.numLegacyPersonalNetworkScanResults != 0) {
                output.writeInt32(41, this.numLegacyPersonalNetworkScanResults);
            }
            if (this.numLegacyEnterpriseNetworkScanResults != 0) {
                output.writeInt32(42, this.numLegacyEnterpriseNetworkScanResults);
            }
            if (this.numHiddenNetworkScanResults != 0) {
                output.writeInt32(43, this.numHiddenNetworkScanResults);
            }
            if (this.numHotspot2R1NetworkScanResults != 0) {
                output.writeInt32(44, this.numHotspot2R1NetworkScanResults);
            }
            if (this.numHotspot2R2NetworkScanResults != 0) {
                output.writeInt32(45, this.numHotspot2R2NetworkScanResults);
            }
            if (this.numScans != 0) {
                output.writeInt32(46, this.numScans);
            }
            if (this.alertReasonCount != null && this.alertReasonCount.length > 0) {
                for (i = 0; i < this.alertReasonCount.length; ++i) {
                    element = this.alertReasonCount[i];
                    if (element == null) continue;
                    output.writeMessage(47, element);
                }
            }
            if (this.wifiScoreCount != null && this.wifiScoreCount.length > 0) {
                for (i = 0; i < this.wifiScoreCount.length; ++i) {
                    element = this.wifiScoreCount[i];
                    if (element == null) continue;
                    output.writeMessage(48, element);
                }
            }
            if (this.softApDuration != null && this.softApDuration.length > 0) {
                for (i = 0; i < this.softApDuration.length; ++i) {
                    element = this.softApDuration[i];
                    if (element == null) continue;
                    output.writeMessage(49, element);
                }
            }
            if (this.softApReturnCode != null && this.softApReturnCode.length > 0) {
                for (i = 0; i < this.softApReturnCode.length; ++i) {
                    element = this.softApReturnCode[i];
                    if (element == null) continue;
                    output.writeMessage(50, element);
                }
            }
            if (this.rssiPollDeltaCount != null && this.rssiPollDeltaCount.length > 0) {
                for (i = 0; i < this.rssiPollDeltaCount.length; ++i) {
                    element = this.rssiPollDeltaCount[i];
                    if (element == null) continue;
                    output.writeMessage(51, element);
                }
            }
            if (this.staEventList != null && this.staEventList.length > 0) {
                for (i = 0; i < this.staEventList.length; ++i) {
                    element = this.staEventList[i];
                    if (element == null) continue;
                    output.writeMessage(52, element);
                }
            }
            if (this.numHalCrashes != 0) {
                output.writeInt32(53, this.numHalCrashes);
            }
            if (this.numWificondCrashes != 0) {
                output.writeInt32(54, this.numWificondCrashes);
            }
            if (this.numSetupClientInterfaceFailureDueToHal != 0) {
                output.writeInt32(55, this.numSetupClientInterfaceFailureDueToHal);
            }
            if (this.numSetupClientInterfaceFailureDueToWificond != 0) {
                output.writeInt32(56, this.numSetupClientInterfaceFailureDueToWificond);
            }
            if (this.wifiAwareLog != null) {
                output.writeMessage(57, this.wifiAwareLog);
            }
            if (this.numPasspointProviders != 0) {
                output.writeInt32(58, this.numPasspointProviders);
            }
            if (this.numPasspointProviderInstallation != 0) {
                output.writeInt32(59, this.numPasspointProviderInstallation);
            }
            if (this.numPasspointProviderInstallSuccess != 0) {
                output.writeInt32(60, this.numPasspointProviderInstallSuccess);
            }
            if (this.numPasspointProviderUninstallation != 0) {
                output.writeInt32(61, this.numPasspointProviderUninstallation);
            }
            if (this.numPasspointProviderUninstallSuccess != 0) {
                output.writeInt32(62, this.numPasspointProviderUninstallSuccess);
            }
            if (this.numPasspointProvidersSuccessfullyConnected != 0) {
                output.writeInt32(63, this.numPasspointProvidersSuccessfullyConnected);
            }
            if (this.totalSsidsInScanHistogram != null && this.totalSsidsInScanHistogram.length > 0) {
                for (i = 0; i < this.totalSsidsInScanHistogram.length; ++i) {
                    element = this.totalSsidsInScanHistogram[i];
                    if (element == null) continue;
                    output.writeMessage(64, element);
                }
            }
            if (this.totalBssidsInScanHistogram != null && this.totalBssidsInScanHistogram.length > 0) {
                for (i = 0; i < this.totalBssidsInScanHistogram.length; ++i) {
                    element = this.totalBssidsInScanHistogram[i];
                    if (element == null) continue;
                    output.writeMessage(65, element);
                }
            }
            if (this.availableOpenSsidsInScanHistogram != null && this.availableOpenSsidsInScanHistogram.length > 0) {
                for (i = 0; i < this.availableOpenSsidsInScanHistogram.length; ++i) {
                    element = this.availableOpenSsidsInScanHistogram[i];
                    if (element == null) continue;
                    output.writeMessage(66, element);
                }
            }
            if (this.availableOpenBssidsInScanHistogram != null && this.availableOpenBssidsInScanHistogram.length > 0) {
                for (i = 0; i < this.availableOpenBssidsInScanHistogram.length; ++i) {
                    element = this.availableOpenBssidsInScanHistogram[i];
                    if (element == null) continue;
                    output.writeMessage(67, element);
                }
            }
            if (this.availableSavedSsidsInScanHistogram != null && this.availableSavedSsidsInScanHistogram.length > 0) {
                for (i = 0; i < this.availableSavedSsidsInScanHistogram.length; ++i) {
                    element = this.availableSavedSsidsInScanHistogram[i];
                    if (element == null) continue;
                    output.writeMessage(68, element);
                }
            }
            if (this.availableSavedBssidsInScanHistogram != null && this.availableSavedBssidsInScanHistogram.length > 0) {
                for (i = 0; i < this.availableSavedBssidsInScanHistogram.length; ++i) {
                    element = this.availableSavedBssidsInScanHistogram[i];
                    if (element == null) continue;
                    output.writeMessage(69, element);
                }
            }
            if (this.availableOpenOrSavedSsidsInScanHistogram != null && this.availableOpenOrSavedSsidsInScanHistogram.length > 0) {
                for (i = 0; i < this.availableOpenOrSavedSsidsInScanHistogram.length; ++i) {
                    element = this.availableOpenOrSavedSsidsInScanHistogram[i];
                    if (element == null) continue;
                    output.writeMessage(70, element);
                }
            }
            if (this.availableOpenOrSavedBssidsInScanHistogram != null && this.availableOpenOrSavedBssidsInScanHistogram.length > 0) {
                for (i = 0; i < this.availableOpenOrSavedBssidsInScanHistogram.length; ++i) {
                    element = this.availableOpenOrSavedBssidsInScanHistogram[i];
                    if (element == null) continue;
                    output.writeMessage(71, element);
                }
            }
            if (this.availableSavedPasspointProviderProfilesInScanHistogram != null && this.availableSavedPasspointProviderProfilesInScanHistogram.length > 0) {
                for (i = 0; i < this.availableSavedPasspointProviderProfilesInScanHistogram.length; ++i) {
                    element = this.availableSavedPasspointProviderProfilesInScanHistogram[i];
                    if (element == null) continue;
                    output.writeMessage(72, element);
                }
            }
            if (this.availableSavedPasspointProviderBssidsInScanHistogram != null && this.availableSavedPasspointProviderBssidsInScanHistogram.length > 0) {
                for (i = 0; i < this.availableSavedPasspointProviderBssidsInScanHistogram.length; ++i) {
                    element = this.availableSavedPasspointProviderBssidsInScanHistogram[i];
                    if (element == null) continue;
                    output.writeMessage(73, element);
                }
            }
            if (this.fullBandAllSingleScanListenerResults != 0) {
                output.writeInt32(74, this.fullBandAllSingleScanListenerResults);
            }
            if (this.partialAllSingleScanListenerResults != 0) {
                output.writeInt32(75, this.partialAllSingleScanListenerResults);
            }
            if (this.pnoScanMetrics != null) {
                output.writeMessage(76, this.pnoScanMetrics);
            }
            if (this.connectToNetworkNotificationCount != null && this.connectToNetworkNotificationCount.length > 0) {
                for (i = 0; i < this.connectToNetworkNotificationCount.length; ++i) {
                    element = this.connectToNetworkNotificationCount[i];
                    if (element == null) continue;
                    output.writeMessage(77, element);
                }
            }
            if (this.connectToNetworkNotificationActionCount != null && this.connectToNetworkNotificationActionCount.length > 0) {
                for (i = 0; i < this.connectToNetworkNotificationActionCount.length; ++i) {
                    element = this.connectToNetworkNotificationActionCount[i];
                    if (element == null) continue;
                    output.writeMessage(78, element);
                }
            }
            if (this.openNetworkRecommenderBlacklistSize != 0) {
                output.writeInt32(79, this.openNetworkRecommenderBlacklistSize);
            }
            if (this.isWifiNetworksAvailableNotificationOn) {
                output.writeBool(80, this.isWifiNetworksAvailableNotificationOn);
            }
            if (this.numOpenNetworkRecommendationUpdates != 0) {
                output.writeInt32(81, this.numOpenNetworkRecommendationUpdates);
            }
            if (this.numOpenNetworkConnectMessageFailedToSend != 0) {
                output.writeInt32(82, this.numOpenNetworkConnectMessageFailedToSend);
            }
            if (this.observedHotspotR1ApsInScanHistogram != null && this.observedHotspotR1ApsInScanHistogram.length > 0) {
                for (i = 0; i < this.observedHotspotR1ApsInScanHistogram.length; ++i) {
                    element = this.observedHotspotR1ApsInScanHistogram[i];
                    if (element == null) continue;
                    output.writeMessage(83, element);
                }
            }
            if (this.observedHotspotR2ApsInScanHistogram != null && this.observedHotspotR2ApsInScanHistogram.length > 0) {
                for (i = 0; i < this.observedHotspotR2ApsInScanHistogram.length; ++i) {
                    element = this.observedHotspotR2ApsInScanHistogram[i];
                    if (element == null) continue;
                    output.writeMessage(84, element);
                }
            }
            if (this.observedHotspotR1EssInScanHistogram != null && this.observedHotspotR1EssInScanHistogram.length > 0) {
                for (i = 0; i < this.observedHotspotR1EssInScanHistogram.length; ++i) {
                    element = this.observedHotspotR1EssInScanHistogram[i];
                    if (element == null) continue;
                    output.writeMessage(85, element);
                }
            }
            if (this.observedHotspotR2EssInScanHistogram != null && this.observedHotspotR2EssInScanHistogram.length > 0) {
                for (i = 0; i < this.observedHotspotR2EssInScanHistogram.length; ++i) {
                    element = this.observedHotspotR2EssInScanHistogram[i];
                    if (element == null) continue;
                    output.writeMessage(86, element);
                }
            }
            if (this.observedHotspotR1ApsPerEssInScanHistogram != null && this.observedHotspotR1ApsPerEssInScanHistogram.length > 0) {
                for (i = 0; i < this.observedHotspotR1ApsPerEssInScanHistogram.length; ++i) {
                    element = this.observedHotspotR1ApsPerEssInScanHistogram[i];
                    if (element == null) continue;
                    output.writeMessage(87, element);
                }
            }
            if (this.observedHotspotR2ApsPerEssInScanHistogram != null && this.observedHotspotR2ApsPerEssInScanHistogram.length > 0) {
                for (i = 0; i < this.observedHotspotR2ApsPerEssInScanHistogram.length; ++i) {
                    element = this.observedHotspotR2ApsPerEssInScanHistogram[i];
                    if (element == null) continue;
                    output.writeMessage(88, element);
                }
            }
            if (this.softApConnectedClientsEventsTethered != null && this.softApConnectedClientsEventsTethered.length > 0) {
                for (i = 0; i < this.softApConnectedClientsEventsTethered.length; ++i) {
                    element = this.softApConnectedClientsEventsTethered[i];
                    if (element == null) continue;
                    output.writeMessage(89, element);
                }
            }
            if (this.softApConnectedClientsEventsLocalOnly != null && this.softApConnectedClientsEventsLocalOnly.length > 0) {
                for (i = 0; i < this.softApConnectedClientsEventsLocalOnly.length; ++i) {
                    element = this.softApConnectedClientsEventsLocalOnly[i];
                    if (element == null) continue;
                    output.writeMessage(90, element);
                }
            }
            if (this.wpsMetrics != null) {
                output.writeMessage(91, this.wpsMetrics);
            }
            if (this.wifiPowerStats != null) {
                output.writeMessage(92, this.wifiPowerStats);
            }
            if (this.numConnectivityOneshotScans != 0) {
                output.writeInt32(93, this.numConnectivityOneshotScans);
            }
            if (this.wifiWakeStats != null) {
                output.writeMessage(94, this.wifiWakeStats);
            }
            if (this.observed80211McSupportingApsInScanHistogram != null && this.observed80211McSupportingApsInScanHistogram.length > 0) {
                for (i = 0; i < this.observed80211McSupportingApsInScanHistogram.length; ++i) {
                    element = this.observed80211McSupportingApsInScanHistogram[i];
                    if (element == null) continue;
                    output.writeMessage(95, element);
                }
            }
            if (this.numSupplicantCrashes != 0) {
                output.writeInt32(96, this.numSupplicantCrashes);
            }
            if (this.numHostapdCrashes != 0) {
                output.writeInt32(97, this.numHostapdCrashes);
            }
            if (this.numSetupClientInterfaceFailureDueToSupplicant != 0) {
                output.writeInt32(98, this.numSetupClientInterfaceFailureDueToSupplicant);
            }
            if (this.numSetupSoftApInterfaceFailureDueToHal != 0) {
                output.writeInt32(99, this.numSetupSoftApInterfaceFailureDueToHal);
            }
            if (this.numSetupSoftApInterfaceFailureDueToWificond != 0) {
                output.writeInt32(100, this.numSetupSoftApInterfaceFailureDueToWificond);
            }
            if (this.numSetupSoftApInterfaceFailureDueToHostapd != 0) {
                output.writeInt32(101, this.numSetupSoftApInterfaceFailureDueToHostapd);
            }
            if (this.numClientInterfaceDown != 0) {
                output.writeInt32(102, this.numClientInterfaceDown);
            }
            if (this.numSoftApInterfaceDown != 0) {
                output.writeInt32(103, this.numSoftApInterfaceDown);
            }
            if (this.numExternalAppOneshotScanRequests != 0) {
                output.writeInt32(104, this.numExternalAppOneshotScanRequests);
            }
            if (this.numExternalForegroundAppOneshotScanRequestsThrottled != 0) {
                output.writeInt32(105, this.numExternalForegroundAppOneshotScanRequestsThrottled);
            }
            if (this.numExternalBackgroundAppOneshotScanRequestsThrottled != 0) {
                output.writeInt32(106, this.numExternalBackgroundAppOneshotScanRequestsThrottled);
            }
            if (this.watchdogTriggerToConnectionSuccessDurationMs != -1L) {
                output.writeInt64(107, this.watchdogTriggerToConnectionSuccessDurationMs);
            }
            if (this.watchdogTotalConnectionFailureCountAfterTrigger != 0L) {
                output.writeInt64(108, this.watchdogTotalConnectionFailureCountAfterTrigger);
            }
            if (this.numOneshotHasDfsChannelScans != 0) {
                output.writeInt32(109, this.numOneshotHasDfsChannelScans);
            }
            if (this.wifiRttLog != null) {
                output.writeMessage(110, this.wifiRttLog);
            }
            if (this.isMacRandomizationOn) {
                output.writeBool(111, this.isMacRandomizationOn);
            }
            if (this.numRadioModeChangeToMcc != 0) {
                output.writeInt32(112, this.numRadioModeChangeToMcc);
            }
            if (this.numRadioModeChangeToScc != 0) {
                output.writeInt32(113, this.numRadioModeChangeToScc);
            }
            if (this.numRadioModeChangeToSbs != 0) {
                output.writeInt32(114, this.numRadioModeChangeToSbs);
            }
            if (this.numRadioModeChangeToDbs != 0) {
                output.writeInt32(115, this.numRadioModeChangeToDbs);
            }
            if (this.numSoftApUserBandPreferenceUnsatisfied != 0) {
                output.writeInt32(116, this.numSoftApUserBandPreferenceUnsatisfied);
            }
            if (!this.scoreExperimentId.equals("")) {
                output.writeString(117, this.scoreExperimentId);
            }
            if (this.wifiRadioUsage != null) {
                output.writeMessage(118, this.wifiRadioUsage);
            }
            if (this.experimentValues != null) {
                output.writeMessage(119, this.experimentValues);
            }
            if (this.wifiIsUnusableEventList != null && this.wifiIsUnusableEventList.length > 0) {
                for (i = 0; i < this.wifiIsUnusableEventList.length; ++i) {
                    element = this.wifiIsUnusableEventList[i];
                    if (element == null) continue;
                    output.writeMessage(120, element);
                }
            }
            if (this.linkSpeedCounts != null && this.linkSpeedCounts.length > 0) {
                for (i = 0; i < this.linkSpeedCounts.length; ++i) {
                    element = this.linkSpeedCounts[i];
                    if (element == null) continue;
                    output.writeMessage(121, element);
                }
            }
            if (this.numSarSensorRegistrationFailures != 0) {
                output.writeInt32(122, this.numSarSensorRegistrationFailures);
            }
            if (this.installedPasspointProfileTypeForR1 != null && this.installedPasspointProfileTypeForR1.length > 0) {
                for (i = 0; i < this.installedPasspointProfileTypeForR1.length; ++i) {
                    element = this.installedPasspointProfileTypeForR1[i];
                    if (element == null) continue;
                    output.writeMessage(123, element);
                }
            }
            if (!this.hardwareRevision.equals("")) {
                output.writeString(124, this.hardwareRevision);
            }
            if (this.wifiLinkLayerUsageStats != null) {
                output.writeMessage(125, this.wifiLinkLayerUsageStats);
            }
            if (this.wifiUsabilityStatsList != null && this.wifiUsabilityStatsList.length > 0) {
                for (i = 0; i < this.wifiUsabilityStatsList.length; ++i) {
                    element = this.wifiUsabilityStatsList[i];
                    if (element == null) continue;
                    output.writeMessage(126, element);
                }
            }
            if (this.wifiUsabilityScoreCount != null && this.wifiUsabilityScoreCount.length > 0) {
                for (i = 0; i < this.wifiUsabilityScoreCount.length; ++i) {
                    element = this.wifiUsabilityScoreCount[i];
                    if (element == null) continue;
                    output.writeMessage(127, element);
                }
            }
            if (this.mobilityStatePnoStatsList != null && this.mobilityStatePnoStatsList.length > 0) {
                for (i = 0; i < this.mobilityStatePnoStatsList.length; ++i) {
                    element = this.mobilityStatePnoStatsList[i];
                    if (element == null) continue;
                    output.writeMessage(128, element);
                }
            }
            if (this.wifiP2PStats != null) {
                output.writeMessage(129, this.wifiP2PStats);
            }
            if (this.wifiDppLog != null) {
                output.writeMessage(130, this.wifiDppLog);
            }
            if (this.numEnhancedOpenNetworks != 0) {
                output.writeInt32(131, this.numEnhancedOpenNetworks);
            }
            if (this.numWpa3PersonalNetworks != 0) {
                output.writeInt32(132, this.numWpa3PersonalNetworks);
            }
            if (this.numWpa3EnterpriseNetworks != 0) {
                output.writeInt32(133, this.numWpa3EnterpriseNetworks);
            }
            if (this.numEnhancedOpenNetworkScanResults != 0) {
                output.writeInt32(134, this.numEnhancedOpenNetworkScanResults);
            }
            if (this.numWpa3PersonalNetworkScanResults != 0) {
                output.writeInt32(135, this.numWpa3PersonalNetworkScanResults);
            }
            if (this.numWpa3EnterpriseNetworkScanResults != 0) {
                output.writeInt32(136, this.numWpa3EnterpriseNetworkScanResults);
            }
            if (this.wifiConfigStoreIo != null) {
                output.writeMessage(137, this.wifiConfigStoreIo);
            }
            if (this.numSavedNetworksWithMacRandomization != 0) {
                output.writeInt32(138, this.numSavedNetworksWithMacRandomization);
            }
            if (this.linkProbeStats != null) {
                output.writeMessage(139, this.linkProbeStats);
            }
            if (this.networkSelectionExperimentDecisionsList != null && this.networkSelectionExperimentDecisionsList.length > 0) {
                for (i = 0; i < this.networkSelectionExperimentDecisionsList.length; ++i) {
                    element = this.networkSelectionExperimentDecisionsList[i];
                    if (element == null) continue;
                    output.writeMessage(140, element);
                }
            }
            if (this.wifiNetworkRequestApiLog != null) {
                output.writeMessage(141, this.wifiNetworkRequestApiLog);
            }
            if (this.wifiNetworkSuggestionApiLog != null) {
                output.writeMessage(142, this.wifiNetworkSuggestionApiLog);
            }
            if (this.wifiLockStats != null) {
                output.writeMessage(143, this.wifiLockStats);
            }
            if (this.wifiToggleStats != null) {
                output.writeMessage(144, this.wifiToggleStats);
            }
            if (this.numAddOrUpdateNetworkCalls != 0) {
                output.writeInt32(145, this.numAddOrUpdateNetworkCalls);
            }
            if (this.numEnableNetworkCalls != 0) {
                output.writeInt32(146, this.numEnableNetworkCalls);
            }
            if (this.passpointProvisionStats != null) {
                output.writeMessage(147, this.passpointProvisionStats);
            }
            if (this.installedPasspointProfileTypeForR2 != null && this.installedPasspointProfileTypeForR2.length > 0) {
                for (i = 0; i < this.installedPasspointProfileTypeForR2.length; ++i) {
                    element = this.installedPasspointProfileTypeForR2[i];
                    if (element == null) continue;
                    output.writeMessage(148, element);
                }
            }
            super.writeTo(output);
        }

        @Override
        protected int computeSerializedSize() {
            MessageNano element;
            int i;
            int size = super.computeSerializedSize();
            if (this.connectionEvent != null && this.connectionEvent.length > 0) {
                for (i = 0; i < this.connectionEvent.length; ++i) {
                    element = this.connectionEvent[i];
                    if (element == null) continue;
                    size += CodedOutputByteBufferNano.computeMessageSize(1, element);
                }
            }
            if (this.numSavedNetworks != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(2, this.numSavedNetworks);
            }
            if (this.numOpenNetworks != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(3, this.numOpenNetworks);
            }
            if (this.numLegacyPersonalNetworks != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(4, this.numLegacyPersonalNetworks);
            }
            if (this.numLegacyEnterpriseNetworks != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(5, this.numLegacyEnterpriseNetworks);
            }
            if (this.isLocationEnabled) {
                size += CodedOutputByteBufferNano.computeBoolSize(6, this.isLocationEnabled);
            }
            if (this.isScanningAlwaysEnabled) {
                size += CodedOutputByteBufferNano.computeBoolSize(7, this.isScanningAlwaysEnabled);
            }
            if (this.numWifiToggledViaSettings != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(8, this.numWifiToggledViaSettings);
            }
            if (this.numWifiToggledViaAirplane != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(9, this.numWifiToggledViaAirplane);
            }
            if (this.numNetworksAddedByUser != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(10, this.numNetworksAddedByUser);
            }
            if (this.numNetworksAddedByApps != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(11, this.numNetworksAddedByApps);
            }
            if (this.numEmptyScanResults != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(12, this.numEmptyScanResults);
            }
            if (this.numNonEmptyScanResults != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(13, this.numNonEmptyScanResults);
            }
            if (this.numOneshotScans != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(14, this.numOneshotScans);
            }
            if (this.numBackgroundScans != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(15, this.numBackgroundScans);
            }
            if (this.scanReturnEntries != null && this.scanReturnEntries.length > 0) {
                for (i = 0; i < this.scanReturnEntries.length; ++i) {
                    element = this.scanReturnEntries[i];
                    if (element == null) continue;
                    size += CodedOutputByteBufferNano.computeMessageSize(16, element);
                }
            }
            if (this.wifiSystemStateEntries != null && this.wifiSystemStateEntries.length > 0) {
                for (i = 0; i < this.wifiSystemStateEntries.length; ++i) {
                    element = this.wifiSystemStateEntries[i];
                    if (element == null) continue;
                    size += CodedOutputByteBufferNano.computeMessageSize(17, element);
                }
            }
            if (this.backgroundScanReturnEntries != null && this.backgroundScanReturnEntries.length > 0) {
                for (i = 0; i < this.backgroundScanReturnEntries.length; ++i) {
                    element = this.backgroundScanReturnEntries[i];
                    if (element == null) continue;
                    size += CodedOutputByteBufferNano.computeMessageSize(18, element);
                }
            }
            if (this.backgroundScanRequestState != null && this.backgroundScanRequestState.length > 0) {
                for (i = 0; i < this.backgroundScanRequestState.length; ++i) {
                    element = this.backgroundScanRequestState[i];
                    if (element == null) continue;
                    size += CodedOutputByteBufferNano.computeMessageSize(19, element);
                }
            }
            if (this.numLastResortWatchdogTriggers != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(20, this.numLastResortWatchdogTriggers);
            }
            if (this.numLastResortWatchdogBadAssociationNetworksTotal != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(21, this.numLastResortWatchdogBadAssociationNetworksTotal);
            }
            if (this.numLastResortWatchdogBadAuthenticationNetworksTotal != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(22, this.numLastResortWatchdogBadAuthenticationNetworksTotal);
            }
            if (this.numLastResortWatchdogBadDhcpNetworksTotal != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(23, this.numLastResortWatchdogBadDhcpNetworksTotal);
            }
            if (this.numLastResortWatchdogBadOtherNetworksTotal != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(24, this.numLastResortWatchdogBadOtherNetworksTotal);
            }
            if (this.numLastResortWatchdogAvailableNetworksTotal != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(25, this.numLastResortWatchdogAvailableNetworksTotal);
            }
            if (this.numLastResortWatchdogTriggersWithBadAssociation != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(26, this.numLastResortWatchdogTriggersWithBadAssociation);
            }
            if (this.numLastResortWatchdogTriggersWithBadAuthentication != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(27, this.numLastResortWatchdogTriggersWithBadAuthentication);
            }
            if (this.numLastResortWatchdogTriggersWithBadDhcp != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(28, this.numLastResortWatchdogTriggersWithBadDhcp);
            }
            if (this.numLastResortWatchdogTriggersWithBadOther != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(29, this.numLastResortWatchdogTriggersWithBadOther);
            }
            if (this.numConnectivityWatchdogPnoGood != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(30, this.numConnectivityWatchdogPnoGood);
            }
            if (this.numConnectivityWatchdogPnoBad != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(31, this.numConnectivityWatchdogPnoBad);
            }
            if (this.numConnectivityWatchdogBackgroundGood != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(32, this.numConnectivityWatchdogBackgroundGood);
            }
            if (this.numConnectivityWatchdogBackgroundBad != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(33, this.numConnectivityWatchdogBackgroundBad);
            }
            if (this.recordDurationSec != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(34, this.recordDurationSec);
            }
            if (this.rssiPollRssiCount != null && this.rssiPollRssiCount.length > 0) {
                for (i = 0; i < this.rssiPollRssiCount.length; ++i) {
                    element = this.rssiPollRssiCount[i];
                    if (element == null) continue;
                    size += CodedOutputByteBufferNano.computeMessageSize(35, element);
                }
            }
            if (this.numLastResortWatchdogSuccesses != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(36, this.numLastResortWatchdogSuccesses);
            }
            if (this.numHiddenNetworks != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(37, this.numHiddenNetworks);
            }
            if (this.numPasspointNetworks != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(38, this.numPasspointNetworks);
            }
            if (this.numTotalScanResults != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(39, this.numTotalScanResults);
            }
            if (this.numOpenNetworkScanResults != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(40, this.numOpenNetworkScanResults);
            }
            if (this.numLegacyPersonalNetworkScanResults != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(41, this.numLegacyPersonalNetworkScanResults);
            }
            if (this.numLegacyEnterpriseNetworkScanResults != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(42, this.numLegacyEnterpriseNetworkScanResults);
            }
            if (this.numHiddenNetworkScanResults != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(43, this.numHiddenNetworkScanResults);
            }
            if (this.numHotspot2R1NetworkScanResults != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(44, this.numHotspot2R1NetworkScanResults);
            }
            if (this.numHotspot2R2NetworkScanResults != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(45, this.numHotspot2R2NetworkScanResults);
            }
            if (this.numScans != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(46, this.numScans);
            }
            if (this.alertReasonCount != null && this.alertReasonCount.length > 0) {
                for (i = 0; i < this.alertReasonCount.length; ++i) {
                    element = this.alertReasonCount[i];
                    if (element == null) continue;
                    size += CodedOutputByteBufferNano.computeMessageSize(47, element);
                }
            }
            if (this.wifiScoreCount != null && this.wifiScoreCount.length > 0) {
                for (i = 0; i < this.wifiScoreCount.length; ++i) {
                    element = this.wifiScoreCount[i];
                    if (element == null) continue;
                    size += CodedOutputByteBufferNano.computeMessageSize(48, element);
                }
            }
            if (this.softApDuration != null && this.softApDuration.length > 0) {
                for (i = 0; i < this.softApDuration.length; ++i) {
                    element = this.softApDuration[i];
                    if (element == null) continue;
                    size += CodedOutputByteBufferNano.computeMessageSize(49, element);
                }
            }
            if (this.softApReturnCode != null && this.softApReturnCode.length > 0) {
                for (i = 0; i < this.softApReturnCode.length; ++i) {
                    element = this.softApReturnCode[i];
                    if (element == null) continue;
                    size += CodedOutputByteBufferNano.computeMessageSize(50, element);
                }
            }
            if (this.rssiPollDeltaCount != null && this.rssiPollDeltaCount.length > 0) {
                for (i = 0; i < this.rssiPollDeltaCount.length; ++i) {
                    element = this.rssiPollDeltaCount[i];
                    if (element == null) continue;
                    size += CodedOutputByteBufferNano.computeMessageSize(51, element);
                }
            }
            if (this.staEventList != null && this.staEventList.length > 0) {
                for (i = 0; i < this.staEventList.length; ++i) {
                    element = this.staEventList[i];
                    if (element == null) continue;
                    size += CodedOutputByteBufferNano.computeMessageSize(52, element);
                }
            }
            if (this.numHalCrashes != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(53, this.numHalCrashes);
            }
            if (this.numWificondCrashes != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(54, this.numWificondCrashes);
            }
            if (this.numSetupClientInterfaceFailureDueToHal != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(55, this.numSetupClientInterfaceFailureDueToHal);
            }
            if (this.numSetupClientInterfaceFailureDueToWificond != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(56, this.numSetupClientInterfaceFailureDueToWificond);
            }
            if (this.wifiAwareLog != null) {
                size += CodedOutputByteBufferNano.computeMessageSize(57, this.wifiAwareLog);
            }
            if (this.numPasspointProviders != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(58, this.numPasspointProviders);
            }
            if (this.numPasspointProviderInstallation != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(59, this.numPasspointProviderInstallation);
            }
            if (this.numPasspointProviderInstallSuccess != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(60, this.numPasspointProviderInstallSuccess);
            }
            if (this.numPasspointProviderUninstallation != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(61, this.numPasspointProviderUninstallation);
            }
            if (this.numPasspointProviderUninstallSuccess != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(62, this.numPasspointProviderUninstallSuccess);
            }
            if (this.numPasspointProvidersSuccessfullyConnected != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(63, this.numPasspointProvidersSuccessfullyConnected);
            }
            if (this.totalSsidsInScanHistogram != null && this.totalSsidsInScanHistogram.length > 0) {
                for (i = 0; i < this.totalSsidsInScanHistogram.length; ++i) {
                    element = this.totalSsidsInScanHistogram[i];
                    if (element == null) continue;
                    size += CodedOutputByteBufferNano.computeMessageSize(64, element);
                }
            }
            if (this.totalBssidsInScanHistogram != null && this.totalBssidsInScanHistogram.length > 0) {
                for (i = 0; i < this.totalBssidsInScanHistogram.length; ++i) {
                    element = this.totalBssidsInScanHistogram[i];
                    if (element == null) continue;
                    size += CodedOutputByteBufferNano.computeMessageSize(65, element);
                }
            }
            if (this.availableOpenSsidsInScanHistogram != null && this.availableOpenSsidsInScanHistogram.length > 0) {
                for (i = 0; i < this.availableOpenSsidsInScanHistogram.length; ++i) {
                    element = this.availableOpenSsidsInScanHistogram[i];
                    if (element == null) continue;
                    size += CodedOutputByteBufferNano.computeMessageSize(66, element);
                }
            }
            if (this.availableOpenBssidsInScanHistogram != null && this.availableOpenBssidsInScanHistogram.length > 0) {
                for (i = 0; i < this.availableOpenBssidsInScanHistogram.length; ++i) {
                    element = this.availableOpenBssidsInScanHistogram[i];
                    if (element == null) continue;
                    size += CodedOutputByteBufferNano.computeMessageSize(67, element);
                }
            }
            if (this.availableSavedSsidsInScanHistogram != null && this.availableSavedSsidsInScanHistogram.length > 0) {
                for (i = 0; i < this.availableSavedSsidsInScanHistogram.length; ++i) {
                    element = this.availableSavedSsidsInScanHistogram[i];
                    if (element == null) continue;
                    size += CodedOutputByteBufferNano.computeMessageSize(68, element);
                }
            }
            if (this.availableSavedBssidsInScanHistogram != null && this.availableSavedBssidsInScanHistogram.length > 0) {
                for (i = 0; i < this.availableSavedBssidsInScanHistogram.length; ++i) {
                    element = this.availableSavedBssidsInScanHistogram[i];
                    if (element == null) continue;
                    size += CodedOutputByteBufferNano.computeMessageSize(69, element);
                }
            }
            if (this.availableOpenOrSavedSsidsInScanHistogram != null && this.availableOpenOrSavedSsidsInScanHistogram.length > 0) {
                for (i = 0; i < this.availableOpenOrSavedSsidsInScanHistogram.length; ++i) {
                    element = this.availableOpenOrSavedSsidsInScanHistogram[i];
                    if (element == null) continue;
                    size += CodedOutputByteBufferNano.computeMessageSize(70, element);
                }
            }
            if (this.availableOpenOrSavedBssidsInScanHistogram != null && this.availableOpenOrSavedBssidsInScanHistogram.length > 0) {
                for (i = 0; i < this.availableOpenOrSavedBssidsInScanHistogram.length; ++i) {
                    element = this.availableOpenOrSavedBssidsInScanHistogram[i];
                    if (element == null) continue;
                    size += CodedOutputByteBufferNano.computeMessageSize(71, element);
                }
            }
            if (this.availableSavedPasspointProviderProfilesInScanHistogram != null && this.availableSavedPasspointProviderProfilesInScanHistogram.length > 0) {
                for (i = 0; i < this.availableSavedPasspointProviderProfilesInScanHistogram.length; ++i) {
                    element = this.availableSavedPasspointProviderProfilesInScanHistogram[i];
                    if (element == null) continue;
                    size += CodedOutputByteBufferNano.computeMessageSize(72, element);
                }
            }
            if (this.availableSavedPasspointProviderBssidsInScanHistogram != null && this.availableSavedPasspointProviderBssidsInScanHistogram.length > 0) {
                for (i = 0; i < this.availableSavedPasspointProviderBssidsInScanHistogram.length; ++i) {
                    element = this.availableSavedPasspointProviderBssidsInScanHistogram[i];
                    if (element == null) continue;
                    size += CodedOutputByteBufferNano.computeMessageSize(73, element);
                }
            }
            if (this.fullBandAllSingleScanListenerResults != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(74, this.fullBandAllSingleScanListenerResults);
            }
            if (this.partialAllSingleScanListenerResults != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(75, this.partialAllSingleScanListenerResults);
            }
            if (this.pnoScanMetrics != null) {
                size += CodedOutputByteBufferNano.computeMessageSize(76, this.pnoScanMetrics);
            }
            if (this.connectToNetworkNotificationCount != null && this.connectToNetworkNotificationCount.length > 0) {
                for (i = 0; i < this.connectToNetworkNotificationCount.length; ++i) {
                    element = this.connectToNetworkNotificationCount[i];
                    if (element == null) continue;
                    size += CodedOutputByteBufferNano.computeMessageSize(77, element);
                }
            }
            if (this.connectToNetworkNotificationActionCount != null && this.connectToNetworkNotificationActionCount.length > 0) {
                for (i = 0; i < this.connectToNetworkNotificationActionCount.length; ++i) {
                    element = this.connectToNetworkNotificationActionCount[i];
                    if (element == null) continue;
                    size += CodedOutputByteBufferNano.computeMessageSize(78, element);
                }
            }
            if (this.openNetworkRecommenderBlacklistSize != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(79, this.openNetworkRecommenderBlacklistSize);
            }
            if (this.isWifiNetworksAvailableNotificationOn) {
                size += CodedOutputByteBufferNano.computeBoolSize(80, this.isWifiNetworksAvailableNotificationOn);
            }
            if (this.numOpenNetworkRecommendationUpdates != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(81, this.numOpenNetworkRecommendationUpdates);
            }
            if (this.numOpenNetworkConnectMessageFailedToSend != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(82, this.numOpenNetworkConnectMessageFailedToSend);
            }
            if (this.observedHotspotR1ApsInScanHistogram != null && this.observedHotspotR1ApsInScanHistogram.length > 0) {
                for (i = 0; i < this.observedHotspotR1ApsInScanHistogram.length; ++i) {
                    element = this.observedHotspotR1ApsInScanHistogram[i];
                    if (element == null) continue;
                    size += CodedOutputByteBufferNano.computeMessageSize(83, element);
                }
            }
            if (this.observedHotspotR2ApsInScanHistogram != null && this.observedHotspotR2ApsInScanHistogram.length > 0) {
                for (i = 0; i < this.observedHotspotR2ApsInScanHistogram.length; ++i) {
                    element = this.observedHotspotR2ApsInScanHistogram[i];
                    if (element == null) continue;
                    size += CodedOutputByteBufferNano.computeMessageSize(84, element);
                }
            }
            if (this.observedHotspotR1EssInScanHistogram != null && this.observedHotspotR1EssInScanHistogram.length > 0) {
                for (i = 0; i < this.observedHotspotR1EssInScanHistogram.length; ++i) {
                    element = this.observedHotspotR1EssInScanHistogram[i];
                    if (element == null) continue;
                    size += CodedOutputByteBufferNano.computeMessageSize(85, element);
                }
            }
            if (this.observedHotspotR2EssInScanHistogram != null && this.observedHotspotR2EssInScanHistogram.length > 0) {
                for (i = 0; i < this.observedHotspotR2EssInScanHistogram.length; ++i) {
                    element = this.observedHotspotR2EssInScanHistogram[i];
                    if (element == null) continue;
                    size += CodedOutputByteBufferNano.computeMessageSize(86, element);
                }
            }
            if (this.observedHotspotR1ApsPerEssInScanHistogram != null && this.observedHotspotR1ApsPerEssInScanHistogram.length > 0) {
                for (i = 0; i < this.observedHotspotR1ApsPerEssInScanHistogram.length; ++i) {
                    element = this.observedHotspotR1ApsPerEssInScanHistogram[i];
                    if (element == null) continue;
                    size += CodedOutputByteBufferNano.computeMessageSize(87, element);
                }
            }
            if (this.observedHotspotR2ApsPerEssInScanHistogram != null && this.observedHotspotR2ApsPerEssInScanHistogram.length > 0) {
                for (i = 0; i < this.observedHotspotR2ApsPerEssInScanHistogram.length; ++i) {
                    element = this.observedHotspotR2ApsPerEssInScanHistogram[i];
                    if (element == null) continue;
                    size += CodedOutputByteBufferNano.computeMessageSize(88, element);
                }
            }
            if (this.softApConnectedClientsEventsTethered != null && this.softApConnectedClientsEventsTethered.length > 0) {
                for (i = 0; i < this.softApConnectedClientsEventsTethered.length; ++i) {
                    element = this.softApConnectedClientsEventsTethered[i];
                    if (element == null) continue;
                    size += CodedOutputByteBufferNano.computeMessageSize(89, element);
                }
            }
            if (this.softApConnectedClientsEventsLocalOnly != null && this.softApConnectedClientsEventsLocalOnly.length > 0) {
                for (i = 0; i < this.softApConnectedClientsEventsLocalOnly.length; ++i) {
                    element = this.softApConnectedClientsEventsLocalOnly[i];
                    if (element == null) continue;
                    size += CodedOutputByteBufferNano.computeMessageSize(90, element);
                }
            }
            if (this.wpsMetrics != null) {
                size += CodedOutputByteBufferNano.computeMessageSize(91, this.wpsMetrics);
            }
            if (this.wifiPowerStats != null) {
                size += CodedOutputByteBufferNano.computeMessageSize(92, this.wifiPowerStats);
            }
            if (this.numConnectivityOneshotScans != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(93, this.numConnectivityOneshotScans);
            }
            if (this.wifiWakeStats != null) {
                size += CodedOutputByteBufferNano.computeMessageSize(94, this.wifiWakeStats);
            }
            if (this.observed80211McSupportingApsInScanHistogram != null && this.observed80211McSupportingApsInScanHistogram.length > 0) {
                for (i = 0; i < this.observed80211McSupportingApsInScanHistogram.length; ++i) {
                    element = this.observed80211McSupportingApsInScanHistogram[i];
                    if (element == null) continue;
                    size += CodedOutputByteBufferNano.computeMessageSize(95, element);
                }
            }
            if (this.numSupplicantCrashes != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(96, this.numSupplicantCrashes);
            }
            if (this.numHostapdCrashes != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(97, this.numHostapdCrashes);
            }
            if (this.numSetupClientInterfaceFailureDueToSupplicant != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(98, this.numSetupClientInterfaceFailureDueToSupplicant);
            }
            if (this.numSetupSoftApInterfaceFailureDueToHal != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(99, this.numSetupSoftApInterfaceFailureDueToHal);
            }
            if (this.numSetupSoftApInterfaceFailureDueToWificond != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(100, this.numSetupSoftApInterfaceFailureDueToWificond);
            }
            if (this.numSetupSoftApInterfaceFailureDueToHostapd != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(101, this.numSetupSoftApInterfaceFailureDueToHostapd);
            }
            if (this.numClientInterfaceDown != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(102, this.numClientInterfaceDown);
            }
            if (this.numSoftApInterfaceDown != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(103, this.numSoftApInterfaceDown);
            }
            if (this.numExternalAppOneshotScanRequests != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(104, this.numExternalAppOneshotScanRequests);
            }
            if (this.numExternalForegroundAppOneshotScanRequestsThrottled != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(105, this.numExternalForegroundAppOneshotScanRequestsThrottled);
            }
            if (this.numExternalBackgroundAppOneshotScanRequestsThrottled != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(106, this.numExternalBackgroundAppOneshotScanRequestsThrottled);
            }
            if (this.watchdogTriggerToConnectionSuccessDurationMs != -1L) {
                size += CodedOutputByteBufferNano.computeInt64Size(107, this.watchdogTriggerToConnectionSuccessDurationMs);
            }
            if (this.watchdogTotalConnectionFailureCountAfterTrigger != 0L) {
                size += CodedOutputByteBufferNano.computeInt64Size(108, this.watchdogTotalConnectionFailureCountAfterTrigger);
            }
            if (this.numOneshotHasDfsChannelScans != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(109, this.numOneshotHasDfsChannelScans);
            }
            if (this.wifiRttLog != null) {
                size += CodedOutputByteBufferNano.computeMessageSize(110, this.wifiRttLog);
            }
            if (this.isMacRandomizationOn) {
                size += CodedOutputByteBufferNano.computeBoolSize(111, this.isMacRandomizationOn);
            }
            if (this.numRadioModeChangeToMcc != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(112, this.numRadioModeChangeToMcc);
            }
            if (this.numRadioModeChangeToScc != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(113, this.numRadioModeChangeToScc);
            }
            if (this.numRadioModeChangeToSbs != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(114, this.numRadioModeChangeToSbs);
            }
            if (this.numRadioModeChangeToDbs != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(115, this.numRadioModeChangeToDbs);
            }
            if (this.numSoftApUserBandPreferenceUnsatisfied != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(116, this.numSoftApUserBandPreferenceUnsatisfied);
            }
            if (!this.scoreExperimentId.equals("")) {
                size += CodedOutputByteBufferNano.computeStringSize(117, this.scoreExperimentId);
            }
            if (this.wifiRadioUsage != null) {
                size += CodedOutputByteBufferNano.computeMessageSize(118, this.wifiRadioUsage);
            }
            if (this.experimentValues != null) {
                size += CodedOutputByteBufferNano.computeMessageSize(119, this.experimentValues);
            }
            if (this.wifiIsUnusableEventList != null && this.wifiIsUnusableEventList.length > 0) {
                for (i = 0; i < this.wifiIsUnusableEventList.length; ++i) {
                    element = this.wifiIsUnusableEventList[i];
                    if (element == null) continue;
                    size += CodedOutputByteBufferNano.computeMessageSize(120, element);
                }
            }
            if (this.linkSpeedCounts != null && this.linkSpeedCounts.length > 0) {
                for (i = 0; i < this.linkSpeedCounts.length; ++i) {
                    element = this.linkSpeedCounts[i];
                    if (element == null) continue;
                    size += CodedOutputByteBufferNano.computeMessageSize(121, element);
                }
            }
            if (this.numSarSensorRegistrationFailures != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(122, this.numSarSensorRegistrationFailures);
            }
            if (this.installedPasspointProfileTypeForR1 != null && this.installedPasspointProfileTypeForR1.length > 0) {
                for (i = 0; i < this.installedPasspointProfileTypeForR1.length; ++i) {
                    element = this.installedPasspointProfileTypeForR1[i];
                    if (element == null) continue;
                    size += CodedOutputByteBufferNano.computeMessageSize(123, element);
                }
            }
            if (!this.hardwareRevision.equals("")) {
                size += CodedOutputByteBufferNano.computeStringSize(124, this.hardwareRevision);
            }
            if (this.wifiLinkLayerUsageStats != null) {
                size += CodedOutputByteBufferNano.computeMessageSize(125, this.wifiLinkLayerUsageStats);
            }
            if (this.wifiUsabilityStatsList != null && this.wifiUsabilityStatsList.length > 0) {
                for (i = 0; i < this.wifiUsabilityStatsList.length; ++i) {
                    element = this.wifiUsabilityStatsList[i];
                    if (element == null) continue;
                    size += CodedOutputByteBufferNano.computeMessageSize(126, element);
                }
            }
            if (this.wifiUsabilityScoreCount != null && this.wifiUsabilityScoreCount.length > 0) {
                for (i = 0; i < this.wifiUsabilityScoreCount.length; ++i) {
                    element = this.wifiUsabilityScoreCount[i];
                    if (element == null) continue;
                    size += CodedOutputByteBufferNano.computeMessageSize(127, element);
                }
            }
            if (this.mobilityStatePnoStatsList != null && this.mobilityStatePnoStatsList.length > 0) {
                for (i = 0; i < this.mobilityStatePnoStatsList.length; ++i) {
                    element = this.mobilityStatePnoStatsList[i];
                    if (element == null) continue;
                    size += CodedOutputByteBufferNano.computeMessageSize(128, element);
                }
            }
            if (this.wifiP2PStats != null) {
                size += CodedOutputByteBufferNano.computeMessageSize(129, this.wifiP2PStats);
            }
            if (this.wifiDppLog != null) {
                size += CodedOutputByteBufferNano.computeMessageSize(130, this.wifiDppLog);
            }
            if (this.numEnhancedOpenNetworks != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(131, this.numEnhancedOpenNetworks);
            }
            if (this.numWpa3PersonalNetworks != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(132, this.numWpa3PersonalNetworks);
            }
            if (this.numWpa3EnterpriseNetworks != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(133, this.numWpa3EnterpriseNetworks);
            }
            if (this.numEnhancedOpenNetworkScanResults != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(134, this.numEnhancedOpenNetworkScanResults);
            }
            if (this.numWpa3PersonalNetworkScanResults != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(135, this.numWpa3PersonalNetworkScanResults);
            }
            if (this.numWpa3EnterpriseNetworkScanResults != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(136, this.numWpa3EnterpriseNetworkScanResults);
            }
            if (this.wifiConfigStoreIo != null) {
                size += CodedOutputByteBufferNano.computeMessageSize(137, this.wifiConfigStoreIo);
            }
            if (this.numSavedNetworksWithMacRandomization != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(138, this.numSavedNetworksWithMacRandomization);
            }
            if (this.linkProbeStats != null) {
                size += CodedOutputByteBufferNano.computeMessageSize(139, this.linkProbeStats);
            }
            if (this.networkSelectionExperimentDecisionsList != null && this.networkSelectionExperimentDecisionsList.length > 0) {
                for (i = 0; i < this.networkSelectionExperimentDecisionsList.length; ++i) {
                    element = this.networkSelectionExperimentDecisionsList[i];
                    if (element == null) continue;
                    size += CodedOutputByteBufferNano.computeMessageSize(140, element);
                }
            }
            if (this.wifiNetworkRequestApiLog != null) {
                size += CodedOutputByteBufferNano.computeMessageSize(141, this.wifiNetworkRequestApiLog);
            }
            if (this.wifiNetworkSuggestionApiLog != null) {
                size += CodedOutputByteBufferNano.computeMessageSize(142, this.wifiNetworkSuggestionApiLog);
            }
            if (this.wifiLockStats != null) {
                size += CodedOutputByteBufferNano.computeMessageSize(143, this.wifiLockStats);
            }
            if (this.wifiToggleStats != null) {
                size += CodedOutputByteBufferNano.computeMessageSize(144, this.wifiToggleStats);
            }
            if (this.numAddOrUpdateNetworkCalls != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(145, this.numAddOrUpdateNetworkCalls);
            }
            if (this.numEnableNetworkCalls != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(146, this.numEnableNetworkCalls);
            }
            if (this.passpointProvisionStats != null) {
                size += CodedOutputByteBufferNano.computeMessageSize(147, this.passpointProvisionStats);
            }
            if (this.installedPasspointProfileTypeForR2 != null && this.installedPasspointProfileTypeForR2.length > 0) {
                for (i = 0; i < this.installedPasspointProfileTypeForR2.length; ++i) {
                    element = this.installedPasspointProfileTypeForR2[i];
                    if (element == null) continue;
                    size += CodedOutputByteBufferNano.computeMessageSize(148, element);
                }
            }
            return size;
        }

        @Override
        public WifiLog mergeFrom(CodedInputByteBufferNano input) throws IOException {
            block151: while (true) {
                MessageNano[] newArray;
                int i;
                int arrayLength;
                int tag = input.readTag();
                switch (tag) {
                    case 0: {
                        return this;
                    }
                    default: {
                        if (WireFormatNano.parseUnknownField(input, tag)) continue block151;
                        return this;
                    }
                    case 10: {
                        arrayLength = WireFormatNano.getRepeatedFieldArrayLength(input, 10);
                        i = this.connectionEvent == null ? 0 : this.connectionEvent.length;
                        newArray = new ConnectionEvent[i + arrayLength];
                        if (i != 0) {
                            System.arraycopy(this.connectionEvent, 0, newArray, 0, i);
                        }
                        while (i < newArray.length - 1) {
                            newArray[i] = new ConnectionEvent();
                            input.readMessage(newArray[i]);
                            input.readTag();
                            ++i;
                        }
                        newArray[i] = new ConnectionEvent();
                        input.readMessage(newArray[i]);
                        this.connectionEvent = newArray;
                        continue block151;
                    }
                    case 16: {
                        this.numSavedNetworks = input.readInt32();
                        continue block151;
                    }
                    case 24: {
                        this.numOpenNetworks = input.readInt32();
                        continue block151;
                    }
                    case 32: {
                        this.numLegacyPersonalNetworks = input.readInt32();
                        continue block151;
                    }
                    case 40: {
                        this.numLegacyEnterpriseNetworks = input.readInt32();
                        continue block151;
                    }
                    case 48: {
                        this.isLocationEnabled = input.readBool();
                        continue block151;
                    }
                    case 56: {
                        this.isScanningAlwaysEnabled = input.readBool();
                        continue block151;
                    }
                    case 64: {
                        this.numWifiToggledViaSettings = input.readInt32();
                        continue block151;
                    }
                    case 72: {
                        this.numWifiToggledViaAirplane = input.readInt32();
                        continue block151;
                    }
                    case 80: {
                        this.numNetworksAddedByUser = input.readInt32();
                        continue block151;
                    }
                    case 88: {
                        this.numNetworksAddedByApps = input.readInt32();
                        continue block151;
                    }
                    case 96: {
                        this.numEmptyScanResults = input.readInt32();
                        continue block151;
                    }
                    case 104: {
                        this.numNonEmptyScanResults = input.readInt32();
                        continue block151;
                    }
                    case 112: {
                        this.numOneshotScans = input.readInt32();
                        continue block151;
                    }
                    case 120: {
                        this.numBackgroundScans = input.readInt32();
                        continue block151;
                    }
                    case 130: {
                        arrayLength = WireFormatNano.getRepeatedFieldArrayLength(input, 130);
                        i = this.scanReturnEntries == null ? 0 : this.scanReturnEntries.length;
                        newArray = new ScanReturnEntry[i + arrayLength];
                        if (i != 0) {
                            System.arraycopy(this.scanReturnEntries, 0, newArray, 0, i);
                        }
                        while (i < newArray.length - 1) {
                            newArray[i] = new ScanReturnEntry();
                            input.readMessage(newArray[i]);
                            input.readTag();
                            ++i;
                        }
                        newArray[i] = new ScanReturnEntry();
                        input.readMessage(newArray[i]);
                        this.scanReturnEntries = newArray;
                        continue block151;
                    }
                    case 138: {
                        arrayLength = WireFormatNano.getRepeatedFieldArrayLength(input, 138);
                        i = this.wifiSystemStateEntries == null ? 0 : this.wifiSystemStateEntries.length;
                        newArray = new WifiSystemStateEntry[i + arrayLength];
                        if (i != 0) {
                            System.arraycopy(this.wifiSystemStateEntries, 0, newArray, 0, i);
                        }
                        while (i < newArray.length - 1) {
                            newArray[i] = new WifiSystemStateEntry();
                            input.readMessage(newArray[i]);
                            input.readTag();
                            ++i;
                        }
                        newArray[i] = new WifiSystemStateEntry();
                        input.readMessage(newArray[i]);
                        this.wifiSystemStateEntries = newArray;
                        continue block151;
                    }
                    case 146: {
                        arrayLength = WireFormatNano.getRepeatedFieldArrayLength(input, 146);
                        i = this.backgroundScanReturnEntries == null ? 0 : this.backgroundScanReturnEntries.length;
                        newArray = new ScanReturnEntry[i + arrayLength];
                        if (i != 0) {
                            System.arraycopy(this.backgroundScanReturnEntries, 0, newArray, 0, i);
                        }
                        while (i < newArray.length - 1) {
                            newArray[i] = new ScanReturnEntry();
                            input.readMessage(newArray[i]);
                            input.readTag();
                            ++i;
                        }
                        newArray[i] = new ScanReturnEntry();
                        input.readMessage(newArray[i]);
                        this.backgroundScanReturnEntries = newArray;
                        continue block151;
                    }
                    case 154: {
                        arrayLength = WireFormatNano.getRepeatedFieldArrayLength(input, 154);
                        i = this.backgroundScanRequestState == null ? 0 : this.backgroundScanRequestState.length;
                        newArray = new WifiSystemStateEntry[i + arrayLength];
                        if (i != 0) {
                            System.arraycopy(this.backgroundScanRequestState, 0, newArray, 0, i);
                        }
                        while (i < newArray.length - 1) {
                            newArray[i] = new WifiSystemStateEntry();
                            input.readMessage(newArray[i]);
                            input.readTag();
                            ++i;
                        }
                        newArray[i] = new WifiSystemStateEntry();
                        input.readMessage(newArray[i]);
                        this.backgroundScanRequestState = newArray;
                        continue block151;
                    }
                    case 160: {
                        this.numLastResortWatchdogTriggers = input.readInt32();
                        continue block151;
                    }
                    case 168: {
                        this.numLastResortWatchdogBadAssociationNetworksTotal = input.readInt32();
                        continue block151;
                    }
                    case 176: {
                        this.numLastResortWatchdogBadAuthenticationNetworksTotal = input.readInt32();
                        continue block151;
                    }
                    case 184: {
                        this.numLastResortWatchdogBadDhcpNetworksTotal = input.readInt32();
                        continue block151;
                    }
                    case 192: {
                        this.numLastResortWatchdogBadOtherNetworksTotal = input.readInt32();
                        continue block151;
                    }
                    case 200: {
                        this.numLastResortWatchdogAvailableNetworksTotal = input.readInt32();
                        continue block151;
                    }
                    case 208: {
                        this.numLastResortWatchdogTriggersWithBadAssociation = input.readInt32();
                        continue block151;
                    }
                    case 216: {
                        this.numLastResortWatchdogTriggersWithBadAuthentication = input.readInt32();
                        continue block151;
                    }
                    case 224: {
                        this.numLastResortWatchdogTriggersWithBadDhcp = input.readInt32();
                        continue block151;
                    }
                    case 232: {
                        this.numLastResortWatchdogTriggersWithBadOther = input.readInt32();
                        continue block151;
                    }
                    case 240: {
                        this.numConnectivityWatchdogPnoGood = input.readInt32();
                        continue block151;
                    }
                    case 248: {
                        this.numConnectivityWatchdogPnoBad = input.readInt32();
                        continue block151;
                    }
                    case 256: {
                        this.numConnectivityWatchdogBackgroundGood = input.readInt32();
                        continue block151;
                    }
                    case 264: {
                        this.numConnectivityWatchdogBackgroundBad = input.readInt32();
                        continue block151;
                    }
                    case 272: {
                        this.recordDurationSec = input.readInt32();
                        continue block151;
                    }
                    case 282: {
                        arrayLength = WireFormatNano.getRepeatedFieldArrayLength(input, 282);
                        i = this.rssiPollRssiCount == null ? 0 : this.rssiPollRssiCount.length;
                        newArray = new RssiPollCount[i + arrayLength];
                        if (i != 0) {
                            System.arraycopy(this.rssiPollRssiCount, 0, newArray, 0, i);
                        }
                        while (i < newArray.length - 1) {
                            newArray[i] = new RssiPollCount();
                            input.readMessage(newArray[i]);
                            input.readTag();
                            ++i;
                        }
                        newArray[i] = new RssiPollCount();
                        input.readMessage(newArray[i]);
                        this.rssiPollRssiCount = newArray;
                        continue block151;
                    }
                    case 288: {
                        this.numLastResortWatchdogSuccesses = input.readInt32();
                        continue block151;
                    }
                    case 296: {
                        this.numHiddenNetworks = input.readInt32();
                        continue block151;
                    }
                    case 304: {
                        this.numPasspointNetworks = input.readInt32();
                        continue block151;
                    }
                    case 312: {
                        this.numTotalScanResults = input.readInt32();
                        continue block151;
                    }
                    case 320: {
                        this.numOpenNetworkScanResults = input.readInt32();
                        continue block151;
                    }
                    case 328: {
                        this.numLegacyPersonalNetworkScanResults = input.readInt32();
                        continue block151;
                    }
                    case 336: {
                        this.numLegacyEnterpriseNetworkScanResults = input.readInt32();
                        continue block151;
                    }
                    case 344: {
                        this.numHiddenNetworkScanResults = input.readInt32();
                        continue block151;
                    }
                    case 352: {
                        this.numHotspot2R1NetworkScanResults = input.readInt32();
                        continue block151;
                    }
                    case 360: {
                        this.numHotspot2R2NetworkScanResults = input.readInt32();
                        continue block151;
                    }
                    case 368: {
                        this.numScans = input.readInt32();
                        continue block151;
                    }
                    case 378: {
                        arrayLength = WireFormatNano.getRepeatedFieldArrayLength(input, 378);
                        i = this.alertReasonCount == null ? 0 : this.alertReasonCount.length;
                        newArray = new AlertReasonCount[i + arrayLength];
                        if (i != 0) {
                            System.arraycopy(this.alertReasonCount, 0, newArray, 0, i);
                        }
                        while (i < newArray.length - 1) {
                            newArray[i] = new AlertReasonCount();
                            input.readMessage(newArray[i]);
                            input.readTag();
                            ++i;
                        }
                        newArray[i] = new AlertReasonCount();
                        input.readMessage(newArray[i]);
                        this.alertReasonCount = newArray;
                        continue block151;
                    }
                    case 386: {
                        arrayLength = WireFormatNano.getRepeatedFieldArrayLength(input, 386);
                        i = this.wifiScoreCount == null ? 0 : this.wifiScoreCount.length;
                        newArray = new WifiScoreCount[i + arrayLength];
                        if (i != 0) {
                            System.arraycopy(this.wifiScoreCount, 0, newArray, 0, i);
                        }
                        while (i < newArray.length - 1) {
                            newArray[i] = new WifiScoreCount();
                            input.readMessage(newArray[i]);
                            input.readTag();
                            ++i;
                        }
                        newArray[i] = new WifiScoreCount();
                        input.readMessage(newArray[i]);
                        this.wifiScoreCount = newArray;
                        continue block151;
                    }
                    case 394: {
                        arrayLength = WireFormatNano.getRepeatedFieldArrayLength(input, 394);
                        i = this.softApDuration == null ? 0 : this.softApDuration.length;
                        newArray = new SoftApDurationBucket[i + arrayLength];
                        if (i != 0) {
                            System.arraycopy(this.softApDuration, 0, newArray, 0, i);
                        }
                        while (i < newArray.length - 1) {
                            newArray[i] = new SoftApDurationBucket();
                            input.readMessage(newArray[i]);
                            input.readTag();
                            ++i;
                        }
                        newArray[i] = new SoftApDurationBucket();
                        input.readMessage(newArray[i]);
                        this.softApDuration = newArray;
                        continue block151;
                    }
                    case 402: {
                        arrayLength = WireFormatNano.getRepeatedFieldArrayLength(input, 402);
                        i = this.softApReturnCode == null ? 0 : this.softApReturnCode.length;
                        newArray = new SoftApReturnCodeCount[i + arrayLength];
                        if (i != 0) {
                            System.arraycopy(this.softApReturnCode, 0, newArray, 0, i);
                        }
                        while (i < newArray.length - 1) {
                            newArray[i] = new SoftApReturnCodeCount();
                            input.readMessage(newArray[i]);
                            input.readTag();
                            ++i;
                        }
                        newArray[i] = new SoftApReturnCodeCount();
                        input.readMessage(newArray[i]);
                        this.softApReturnCode = newArray;
                        continue block151;
                    }
                    case 410: {
                        arrayLength = WireFormatNano.getRepeatedFieldArrayLength(input, 410);
                        i = this.rssiPollDeltaCount == null ? 0 : this.rssiPollDeltaCount.length;
                        newArray = new RssiPollCount[i + arrayLength];
                        if (i != 0) {
                            System.arraycopy(this.rssiPollDeltaCount, 0, newArray, 0, i);
                        }
                        while (i < newArray.length - 1) {
                            newArray[i] = new RssiPollCount();
                            input.readMessage(newArray[i]);
                            input.readTag();
                            ++i;
                        }
                        newArray[i] = new RssiPollCount();
                        input.readMessage(newArray[i]);
                        this.rssiPollDeltaCount = newArray;
                        continue block151;
                    }
                    case 418: {
                        arrayLength = WireFormatNano.getRepeatedFieldArrayLength(input, 418);
                        i = this.staEventList == null ? 0 : this.staEventList.length;
                        newArray = new StaEvent[i + arrayLength];
                        if (i != 0) {
                            System.arraycopy(this.staEventList, 0, newArray, 0, i);
                        }
                        while (i < newArray.length - 1) {
                            newArray[i] = new StaEvent();
                            input.readMessage(newArray[i]);
                            input.readTag();
                            ++i;
                        }
                        newArray[i] = new StaEvent();
                        input.readMessage(newArray[i]);
                        this.staEventList = newArray;
                        continue block151;
                    }
                    case 424: {
                        this.numHalCrashes = input.readInt32();
                        continue block151;
                    }
                    case 432: {
                        this.numWificondCrashes = input.readInt32();
                        continue block151;
                    }
                    case 440: {
                        this.numSetupClientInterfaceFailureDueToHal = input.readInt32();
                        continue block151;
                    }
                    case 448: {
                        this.numSetupClientInterfaceFailureDueToWificond = input.readInt32();
                        continue block151;
                    }
                    case 458: {
                        if (this.wifiAwareLog == null) {
                            this.wifiAwareLog = new WifiAwareLog();
                        }
                        input.readMessage(this.wifiAwareLog);
                        continue block151;
                    }
                    case 464: {
                        this.numPasspointProviders = input.readInt32();
                        continue block151;
                    }
                    case 472: {
                        this.numPasspointProviderInstallation = input.readInt32();
                        continue block151;
                    }
                    case 480: {
                        this.numPasspointProviderInstallSuccess = input.readInt32();
                        continue block151;
                    }
                    case 488: {
                        this.numPasspointProviderUninstallation = input.readInt32();
                        continue block151;
                    }
                    case 496: {
                        this.numPasspointProviderUninstallSuccess = input.readInt32();
                        continue block151;
                    }
                    case 504: {
                        this.numPasspointProvidersSuccessfullyConnected = input.readInt32();
                        continue block151;
                    }
                    case 514: {
                        arrayLength = WireFormatNano.getRepeatedFieldArrayLength(input, 514);
                        i = this.totalSsidsInScanHistogram == null ? 0 : this.totalSsidsInScanHistogram.length;
                        newArray = new NumConnectableNetworksBucket[i + arrayLength];
                        if (i != 0) {
                            System.arraycopy(this.totalSsidsInScanHistogram, 0, newArray, 0, i);
                        }
                        while (i < newArray.length - 1) {
                            newArray[i] = new NumConnectableNetworksBucket();
                            input.readMessage(newArray[i]);
                            input.readTag();
                            ++i;
                        }
                        newArray[i] = new NumConnectableNetworksBucket();
                        input.readMessage(newArray[i]);
                        this.totalSsidsInScanHistogram = newArray;
                        continue block151;
                    }
                    case 522: {
                        arrayLength = WireFormatNano.getRepeatedFieldArrayLength(input, 522);
                        i = this.totalBssidsInScanHistogram == null ? 0 : this.totalBssidsInScanHistogram.length;
                        newArray = new NumConnectableNetworksBucket[i + arrayLength];
                        if (i != 0) {
                            System.arraycopy(this.totalBssidsInScanHistogram, 0, newArray, 0, i);
                        }
                        while (i < newArray.length - 1) {
                            newArray[i] = new NumConnectableNetworksBucket();
                            input.readMessage(newArray[i]);
                            input.readTag();
                            ++i;
                        }
                        newArray[i] = new NumConnectableNetworksBucket();
                        input.readMessage(newArray[i]);
                        this.totalBssidsInScanHistogram = newArray;
                        continue block151;
                    }
                    case 530: {
                        arrayLength = WireFormatNano.getRepeatedFieldArrayLength(input, 530);
                        i = this.availableOpenSsidsInScanHistogram == null ? 0 : this.availableOpenSsidsInScanHistogram.length;
                        newArray = new NumConnectableNetworksBucket[i + arrayLength];
                        if (i != 0) {
                            System.arraycopy(this.availableOpenSsidsInScanHistogram, 0, newArray, 0, i);
                        }
                        while (i < newArray.length - 1) {
                            newArray[i] = new NumConnectableNetworksBucket();
                            input.readMessage(newArray[i]);
                            input.readTag();
                            ++i;
                        }
                        newArray[i] = new NumConnectableNetworksBucket();
                        input.readMessage(newArray[i]);
                        this.availableOpenSsidsInScanHistogram = newArray;
                        continue block151;
                    }
                    case 538: {
                        arrayLength = WireFormatNano.getRepeatedFieldArrayLength(input, 538);
                        i = this.availableOpenBssidsInScanHistogram == null ? 0 : this.availableOpenBssidsInScanHistogram.length;
                        newArray = new NumConnectableNetworksBucket[i + arrayLength];
                        if (i != 0) {
                            System.arraycopy(this.availableOpenBssidsInScanHistogram, 0, newArray, 0, i);
                        }
                        while (i < newArray.length - 1) {
                            newArray[i] = new NumConnectableNetworksBucket();
                            input.readMessage(newArray[i]);
                            input.readTag();
                            ++i;
                        }
                        newArray[i] = new NumConnectableNetworksBucket();
                        input.readMessage(newArray[i]);
                        this.availableOpenBssidsInScanHistogram = newArray;
                        continue block151;
                    }
                    case 546: {
                        arrayLength = WireFormatNano.getRepeatedFieldArrayLength(input, 546);
                        i = this.availableSavedSsidsInScanHistogram == null ? 0 : this.availableSavedSsidsInScanHistogram.length;
                        newArray = new NumConnectableNetworksBucket[i + arrayLength];
                        if (i != 0) {
                            System.arraycopy(this.availableSavedSsidsInScanHistogram, 0, newArray, 0, i);
                        }
                        while (i < newArray.length - 1) {
                            newArray[i] = new NumConnectableNetworksBucket();
                            input.readMessage(newArray[i]);
                            input.readTag();
                            ++i;
                        }
                        newArray[i] = new NumConnectableNetworksBucket();
                        input.readMessage(newArray[i]);
                        this.availableSavedSsidsInScanHistogram = newArray;
                        continue block151;
                    }
                    case 554: {
                        arrayLength = WireFormatNano.getRepeatedFieldArrayLength(input, 554);
                        i = this.availableSavedBssidsInScanHistogram == null ? 0 : this.availableSavedBssidsInScanHistogram.length;
                        newArray = new NumConnectableNetworksBucket[i + arrayLength];
                        if (i != 0) {
                            System.arraycopy(this.availableSavedBssidsInScanHistogram, 0, newArray, 0, i);
                        }
                        while (i < newArray.length - 1) {
                            newArray[i] = new NumConnectableNetworksBucket();
                            input.readMessage(newArray[i]);
                            input.readTag();
                            ++i;
                        }
                        newArray[i] = new NumConnectableNetworksBucket();
                        input.readMessage(newArray[i]);
                        this.availableSavedBssidsInScanHistogram = newArray;
                        continue block151;
                    }
                    case 562: {
                        arrayLength = WireFormatNano.getRepeatedFieldArrayLength(input, 562);
                        i = this.availableOpenOrSavedSsidsInScanHistogram == null ? 0 : this.availableOpenOrSavedSsidsInScanHistogram.length;
                        newArray = new NumConnectableNetworksBucket[i + arrayLength];
                        if (i != 0) {
                            System.arraycopy(this.availableOpenOrSavedSsidsInScanHistogram, 0, newArray, 0, i);
                        }
                        while (i < newArray.length - 1) {
                            newArray[i] = new NumConnectableNetworksBucket();
                            input.readMessage(newArray[i]);
                            input.readTag();
                            ++i;
                        }
                        newArray[i] = new NumConnectableNetworksBucket();
                        input.readMessage(newArray[i]);
                        this.availableOpenOrSavedSsidsInScanHistogram = newArray;
                        continue block151;
                    }
                    case 570: {
                        arrayLength = WireFormatNano.getRepeatedFieldArrayLength(input, 570);
                        i = this.availableOpenOrSavedBssidsInScanHistogram == null ? 0 : this.availableOpenOrSavedBssidsInScanHistogram.length;
                        newArray = new NumConnectableNetworksBucket[i + arrayLength];
                        if (i != 0) {
                            System.arraycopy(this.availableOpenOrSavedBssidsInScanHistogram, 0, newArray, 0, i);
                        }
                        while (i < newArray.length - 1) {
                            newArray[i] = new NumConnectableNetworksBucket();
                            input.readMessage(newArray[i]);
                            input.readTag();
                            ++i;
                        }
                        newArray[i] = new NumConnectableNetworksBucket();
                        input.readMessage(newArray[i]);
                        this.availableOpenOrSavedBssidsInScanHistogram = newArray;
                        continue block151;
                    }
                    case 578: {
                        arrayLength = WireFormatNano.getRepeatedFieldArrayLength(input, 578);
                        i = this.availableSavedPasspointProviderProfilesInScanHistogram == null ? 0 : this.availableSavedPasspointProviderProfilesInScanHistogram.length;
                        newArray = new NumConnectableNetworksBucket[i + arrayLength];
                        if (i != 0) {
                            System.arraycopy(this.availableSavedPasspointProviderProfilesInScanHistogram, 0, newArray, 0, i);
                        }
                        while (i < newArray.length - 1) {
                            newArray[i] = new NumConnectableNetworksBucket();
                            input.readMessage(newArray[i]);
                            input.readTag();
                            ++i;
                        }
                        newArray[i] = new NumConnectableNetworksBucket();
                        input.readMessage(newArray[i]);
                        this.availableSavedPasspointProviderProfilesInScanHistogram = newArray;
                        continue block151;
                    }
                    case 586: {
                        arrayLength = WireFormatNano.getRepeatedFieldArrayLength(input, 586);
                        i = this.availableSavedPasspointProviderBssidsInScanHistogram == null ? 0 : this.availableSavedPasspointProviderBssidsInScanHistogram.length;
                        newArray = new NumConnectableNetworksBucket[i + arrayLength];
                        if (i != 0) {
                            System.arraycopy(this.availableSavedPasspointProviderBssidsInScanHistogram, 0, newArray, 0, i);
                        }
                        while (i < newArray.length - 1) {
                            newArray[i] = new NumConnectableNetworksBucket();
                            input.readMessage(newArray[i]);
                            input.readTag();
                            ++i;
                        }
                        newArray[i] = new NumConnectableNetworksBucket();
                        input.readMessage(newArray[i]);
                        this.availableSavedPasspointProviderBssidsInScanHistogram = newArray;
                        continue block151;
                    }
                    case 592: {
                        this.fullBandAllSingleScanListenerResults = input.readInt32();
                        continue block151;
                    }
                    case 600: {
                        this.partialAllSingleScanListenerResults = input.readInt32();
                        continue block151;
                    }
                    case 610: {
                        if (this.pnoScanMetrics == null) {
                            this.pnoScanMetrics = new PnoScanMetrics();
                        }
                        input.readMessage(this.pnoScanMetrics);
                        continue block151;
                    }
                    case 618: {
                        arrayLength = WireFormatNano.getRepeatedFieldArrayLength(input, 618);
                        i = this.connectToNetworkNotificationCount == null ? 0 : this.connectToNetworkNotificationCount.length;
                        newArray = new ConnectToNetworkNotificationAndActionCount[i + arrayLength];
                        if (i != 0) {
                            System.arraycopy(this.connectToNetworkNotificationCount, 0, newArray, 0, i);
                        }
                        while (i < newArray.length - 1) {
                            newArray[i] = new ConnectToNetworkNotificationAndActionCount();
                            input.readMessage(newArray[i]);
                            input.readTag();
                            ++i;
                        }
                        newArray[i] = new ConnectToNetworkNotificationAndActionCount();
                        input.readMessage(newArray[i]);
                        this.connectToNetworkNotificationCount = newArray;
                        continue block151;
                    }
                    case 626: {
                        arrayLength = WireFormatNano.getRepeatedFieldArrayLength(input, 626);
                        i = this.connectToNetworkNotificationActionCount == null ? 0 : this.connectToNetworkNotificationActionCount.length;
                        newArray = new ConnectToNetworkNotificationAndActionCount[i + arrayLength];
                        if (i != 0) {
                            System.arraycopy(this.connectToNetworkNotificationActionCount, 0, newArray, 0, i);
                        }
                        while (i < newArray.length - 1) {
                            newArray[i] = new ConnectToNetworkNotificationAndActionCount();
                            input.readMessage(newArray[i]);
                            input.readTag();
                            ++i;
                        }
                        newArray[i] = new ConnectToNetworkNotificationAndActionCount();
                        input.readMessage(newArray[i]);
                        this.connectToNetworkNotificationActionCount = newArray;
                        continue block151;
                    }
                    case 632: {
                        this.openNetworkRecommenderBlacklistSize = input.readInt32();
                        continue block151;
                    }
                    case 640: {
                        this.isWifiNetworksAvailableNotificationOn = input.readBool();
                        continue block151;
                    }
                    case 648: {
                        this.numOpenNetworkRecommendationUpdates = input.readInt32();
                        continue block151;
                    }
                    case 656: {
                        this.numOpenNetworkConnectMessageFailedToSend = input.readInt32();
                        continue block151;
                    }
                    case 666: {
                        arrayLength = WireFormatNano.getRepeatedFieldArrayLength(input, 666);
                        i = this.observedHotspotR1ApsInScanHistogram == null ? 0 : this.observedHotspotR1ApsInScanHistogram.length;
                        newArray = new NumConnectableNetworksBucket[i + arrayLength];
                        if (i != 0) {
                            System.arraycopy(this.observedHotspotR1ApsInScanHistogram, 0, newArray, 0, i);
                        }
                        while (i < newArray.length - 1) {
                            newArray[i] = new NumConnectableNetworksBucket();
                            input.readMessage(newArray[i]);
                            input.readTag();
                            ++i;
                        }
                        newArray[i] = new NumConnectableNetworksBucket();
                        input.readMessage(newArray[i]);
                        this.observedHotspotR1ApsInScanHistogram = newArray;
                        continue block151;
                    }
                    case 674: {
                        arrayLength = WireFormatNano.getRepeatedFieldArrayLength(input, 674);
                        i = this.observedHotspotR2ApsInScanHistogram == null ? 0 : this.observedHotspotR2ApsInScanHistogram.length;
                        newArray = new NumConnectableNetworksBucket[i + arrayLength];
                        if (i != 0) {
                            System.arraycopy(this.observedHotspotR2ApsInScanHistogram, 0, newArray, 0, i);
                        }
                        while (i < newArray.length - 1) {
                            newArray[i] = new NumConnectableNetworksBucket();
                            input.readMessage(newArray[i]);
                            input.readTag();
                            ++i;
                        }
                        newArray[i] = new NumConnectableNetworksBucket();
                        input.readMessage(newArray[i]);
                        this.observedHotspotR2ApsInScanHistogram = newArray;
                        continue block151;
                    }
                    case 682: {
                        arrayLength = WireFormatNano.getRepeatedFieldArrayLength(input, 682);
                        i = this.observedHotspotR1EssInScanHistogram == null ? 0 : this.observedHotspotR1EssInScanHistogram.length;
                        newArray = new NumConnectableNetworksBucket[i + arrayLength];
                        if (i != 0) {
                            System.arraycopy(this.observedHotspotR1EssInScanHistogram, 0, newArray, 0, i);
                        }
                        while (i < newArray.length - 1) {
                            newArray[i] = new NumConnectableNetworksBucket();
                            input.readMessage(newArray[i]);
                            input.readTag();
                            ++i;
                        }
                        newArray[i] = new NumConnectableNetworksBucket();
                        input.readMessage(newArray[i]);
                        this.observedHotspotR1EssInScanHistogram = newArray;
                        continue block151;
                    }
                    case 690: {
                        arrayLength = WireFormatNano.getRepeatedFieldArrayLength(input, 690);
                        i = this.observedHotspotR2EssInScanHistogram == null ? 0 : this.observedHotspotR2EssInScanHistogram.length;
                        newArray = new NumConnectableNetworksBucket[i + arrayLength];
                        if (i != 0) {
                            System.arraycopy(this.observedHotspotR2EssInScanHistogram, 0, newArray, 0, i);
                        }
                        while (i < newArray.length - 1) {
                            newArray[i] = new NumConnectableNetworksBucket();
                            input.readMessage(newArray[i]);
                            input.readTag();
                            ++i;
                        }
                        newArray[i] = new NumConnectableNetworksBucket();
                        input.readMessage(newArray[i]);
                        this.observedHotspotR2EssInScanHistogram = newArray;
                        continue block151;
                    }
                    case 698: {
                        arrayLength = WireFormatNano.getRepeatedFieldArrayLength(input, 698);
                        i = this.observedHotspotR1ApsPerEssInScanHistogram == null ? 0 : this.observedHotspotR1ApsPerEssInScanHistogram.length;
                        newArray = new NumConnectableNetworksBucket[i + arrayLength];
                        if (i != 0) {
                            System.arraycopy(this.observedHotspotR1ApsPerEssInScanHistogram, 0, newArray, 0, i);
                        }
                        while (i < newArray.length - 1) {
                            newArray[i] = new NumConnectableNetworksBucket();
                            input.readMessage(newArray[i]);
                            input.readTag();
                            ++i;
                        }
                        newArray[i] = new NumConnectableNetworksBucket();
                        input.readMessage(newArray[i]);
                        this.observedHotspotR1ApsPerEssInScanHistogram = newArray;
                        continue block151;
                    }
                    case 706: {
                        arrayLength = WireFormatNano.getRepeatedFieldArrayLength(input, 706);
                        i = this.observedHotspotR2ApsPerEssInScanHistogram == null ? 0 : this.observedHotspotR2ApsPerEssInScanHistogram.length;
                        newArray = new NumConnectableNetworksBucket[i + arrayLength];
                        if (i != 0) {
                            System.arraycopy(this.observedHotspotR2ApsPerEssInScanHistogram, 0, newArray, 0, i);
                        }
                        while (i < newArray.length - 1) {
                            newArray[i] = new NumConnectableNetworksBucket();
                            input.readMessage(newArray[i]);
                            input.readTag();
                            ++i;
                        }
                        newArray[i] = new NumConnectableNetworksBucket();
                        input.readMessage(newArray[i]);
                        this.observedHotspotR2ApsPerEssInScanHistogram = newArray;
                        continue block151;
                    }
                    case 714: {
                        arrayLength = WireFormatNano.getRepeatedFieldArrayLength(input, 714);
                        i = this.softApConnectedClientsEventsTethered == null ? 0 : this.softApConnectedClientsEventsTethered.length;
                        newArray = new SoftApConnectedClientsEvent[i + arrayLength];
                        if (i != 0) {
                            System.arraycopy(this.softApConnectedClientsEventsTethered, 0, newArray, 0, i);
                        }
                        while (i < newArray.length - 1) {
                            newArray[i] = new SoftApConnectedClientsEvent();
                            input.readMessage(newArray[i]);
                            input.readTag();
                            ++i;
                        }
                        newArray[i] = new SoftApConnectedClientsEvent();
                        input.readMessage(newArray[i]);
                        this.softApConnectedClientsEventsTethered = newArray;
                        continue block151;
                    }
                    case 722: {
                        arrayLength = WireFormatNano.getRepeatedFieldArrayLength(input, 722);
                        i = this.softApConnectedClientsEventsLocalOnly == null ? 0 : this.softApConnectedClientsEventsLocalOnly.length;
                        newArray = new SoftApConnectedClientsEvent[i + arrayLength];
                        if (i != 0) {
                            System.arraycopy(this.softApConnectedClientsEventsLocalOnly, 0, newArray, 0, i);
                        }
                        while (i < newArray.length - 1) {
                            newArray[i] = new SoftApConnectedClientsEvent();
                            input.readMessage(newArray[i]);
                            input.readTag();
                            ++i;
                        }
                        newArray[i] = new SoftApConnectedClientsEvent();
                        input.readMessage(newArray[i]);
                        this.softApConnectedClientsEventsLocalOnly = newArray;
                        continue block151;
                    }
                    case 730: {
                        if (this.wpsMetrics == null) {
                            this.wpsMetrics = new WpsMetrics();
                        }
                        input.readMessage(this.wpsMetrics);
                        continue block151;
                    }
                    case 738: {
                        if (this.wifiPowerStats == null) {
                            this.wifiPowerStats = new WifiPowerStats();
                        }
                        input.readMessage(this.wifiPowerStats);
                        continue block151;
                    }
                    case 744: {
                        this.numConnectivityOneshotScans = input.readInt32();
                        continue block151;
                    }
                    case 754: {
                        if (this.wifiWakeStats == null) {
                            this.wifiWakeStats = new WifiWakeStats();
                        }
                        input.readMessage(this.wifiWakeStats);
                        continue block151;
                    }
                    case 762: {
                        arrayLength = WireFormatNano.getRepeatedFieldArrayLength(input, 762);
                        i = this.observed80211McSupportingApsInScanHistogram == null ? 0 : this.observed80211McSupportingApsInScanHistogram.length;
                        newArray = new NumConnectableNetworksBucket[i + arrayLength];
                        if (i != 0) {
                            System.arraycopy(this.observed80211McSupportingApsInScanHistogram, 0, newArray, 0, i);
                        }
                        while (i < newArray.length - 1) {
                            newArray[i] = new NumConnectableNetworksBucket();
                            input.readMessage(newArray[i]);
                            input.readTag();
                            ++i;
                        }
                        newArray[i] = new NumConnectableNetworksBucket();
                        input.readMessage(newArray[i]);
                        this.observed80211McSupportingApsInScanHistogram = newArray;
                        continue block151;
                    }
                    case 768: {
                        this.numSupplicantCrashes = input.readInt32();
                        continue block151;
                    }
                    case 776: {
                        this.numHostapdCrashes = input.readInt32();
                        continue block151;
                    }
                    case 784: {
                        this.numSetupClientInterfaceFailureDueToSupplicant = input.readInt32();
                        continue block151;
                    }
                    case 792: {
                        this.numSetupSoftApInterfaceFailureDueToHal = input.readInt32();
                        continue block151;
                    }
                    case 800: {
                        this.numSetupSoftApInterfaceFailureDueToWificond = input.readInt32();
                        continue block151;
                    }
                    case 808: {
                        this.numSetupSoftApInterfaceFailureDueToHostapd = input.readInt32();
                        continue block151;
                    }
                    case 816: {
                        this.numClientInterfaceDown = input.readInt32();
                        continue block151;
                    }
                    case 824: {
                        this.numSoftApInterfaceDown = input.readInt32();
                        continue block151;
                    }
                    case 832: {
                        this.numExternalAppOneshotScanRequests = input.readInt32();
                        continue block151;
                    }
                    case 840: {
                        this.numExternalForegroundAppOneshotScanRequestsThrottled = input.readInt32();
                        continue block151;
                    }
                    case 848: {
                        this.numExternalBackgroundAppOneshotScanRequestsThrottled = input.readInt32();
                        continue block151;
                    }
                    case 856: {
                        this.watchdogTriggerToConnectionSuccessDurationMs = input.readInt64();
                        continue block151;
                    }
                    case 864: {
                        this.watchdogTotalConnectionFailureCountAfterTrigger = input.readInt64();
                        continue block151;
                    }
                    case 872: {
                        this.numOneshotHasDfsChannelScans = input.readInt32();
                        continue block151;
                    }
                    case 882: {
                        if (this.wifiRttLog == null) {
                            this.wifiRttLog = new WifiRttLog();
                        }
                        input.readMessage(this.wifiRttLog);
                        continue block151;
                    }
                    case 888: {
                        this.isMacRandomizationOn = input.readBool();
                        continue block151;
                    }
                    case 896: {
                        this.numRadioModeChangeToMcc = input.readInt32();
                        continue block151;
                    }
                    case 904: {
                        this.numRadioModeChangeToScc = input.readInt32();
                        continue block151;
                    }
                    case 912: {
                        this.numRadioModeChangeToSbs = input.readInt32();
                        continue block151;
                    }
                    case 920: {
                        this.numRadioModeChangeToDbs = input.readInt32();
                        continue block151;
                    }
                    case 928: {
                        this.numSoftApUserBandPreferenceUnsatisfied = input.readInt32();
                        continue block151;
                    }
                    case 938: {
                        this.scoreExperimentId = input.readString();
                        continue block151;
                    }
                    case 946: {
                        if (this.wifiRadioUsage == null) {
                            this.wifiRadioUsage = new WifiRadioUsage();
                        }
                        input.readMessage(this.wifiRadioUsage);
                        continue block151;
                    }
                    case 954: {
                        if (this.experimentValues == null) {
                            this.experimentValues = new ExperimentValues();
                        }
                        input.readMessage(this.experimentValues);
                        continue block151;
                    }
                    case 962: {
                        arrayLength = WireFormatNano.getRepeatedFieldArrayLength(input, 962);
                        i = this.wifiIsUnusableEventList == null ? 0 : this.wifiIsUnusableEventList.length;
                        newArray = new WifiIsUnusableEvent[i + arrayLength];
                        if (i != 0) {
                            System.arraycopy(this.wifiIsUnusableEventList, 0, newArray, 0, i);
                        }
                        while (i < newArray.length - 1) {
                            newArray[i] = new WifiIsUnusableEvent();
                            input.readMessage(newArray[i]);
                            input.readTag();
                            ++i;
                        }
                        newArray[i] = new WifiIsUnusableEvent();
                        input.readMessage(newArray[i]);
                        this.wifiIsUnusableEventList = newArray;
                        continue block151;
                    }
                    case 970: {
                        arrayLength = WireFormatNano.getRepeatedFieldArrayLength(input, 970);
                        i = this.linkSpeedCounts == null ? 0 : this.linkSpeedCounts.length;
                        newArray = new LinkSpeedCount[i + arrayLength];
                        if (i != 0) {
                            System.arraycopy(this.linkSpeedCounts, 0, newArray, 0, i);
                        }
                        while (i < newArray.length - 1) {
                            newArray[i] = new LinkSpeedCount();
                            input.readMessage(newArray[i]);
                            input.readTag();
                            ++i;
                        }
                        newArray[i] = new LinkSpeedCount();
                        input.readMessage(newArray[i]);
                        this.linkSpeedCounts = newArray;
                        continue block151;
                    }
                    case 976: {
                        this.numSarSensorRegistrationFailures = input.readInt32();
                        continue block151;
                    }
                    case 986: {
                        arrayLength = WireFormatNano.getRepeatedFieldArrayLength(input, 986);
                        i = this.installedPasspointProfileTypeForR1 == null ? 0 : this.installedPasspointProfileTypeForR1.length;
                        newArray = new PasspointProfileTypeCount[i + arrayLength];
                        if (i != 0) {
                            System.arraycopy(this.installedPasspointProfileTypeForR1, 0, newArray, 0, i);
                        }
                        while (i < newArray.length - 1) {
                            newArray[i] = new PasspointProfileTypeCount();
                            input.readMessage(newArray[i]);
                            input.readTag();
                            ++i;
                        }
                        newArray[i] = new PasspointProfileTypeCount();
                        input.readMessage(newArray[i]);
                        this.installedPasspointProfileTypeForR1 = newArray;
                        continue block151;
                    }
                    case 994: {
                        this.hardwareRevision = input.readString();
                        continue block151;
                    }
                    case 1002: {
                        if (this.wifiLinkLayerUsageStats == null) {
                            this.wifiLinkLayerUsageStats = new WifiLinkLayerUsageStats();
                        }
                        input.readMessage(this.wifiLinkLayerUsageStats);
                        continue block151;
                    }
                    case 1010: {
                        arrayLength = WireFormatNano.getRepeatedFieldArrayLength(input, 1010);
                        i = this.wifiUsabilityStatsList == null ? 0 : this.wifiUsabilityStatsList.length;
                        newArray = new WifiUsabilityStats[i + arrayLength];
                        if (i != 0) {
                            System.arraycopy(this.wifiUsabilityStatsList, 0, newArray, 0, i);
                        }
                        while (i < newArray.length - 1) {
                            newArray[i] = new WifiUsabilityStats();
                            input.readMessage(newArray[i]);
                            input.readTag();
                            ++i;
                        }
                        newArray[i] = new WifiUsabilityStats();
                        input.readMessage(newArray[i]);
                        this.wifiUsabilityStatsList = newArray;
                        continue block151;
                    }
                    case 1018: {
                        arrayLength = WireFormatNano.getRepeatedFieldArrayLength(input, 1018);
                        i = this.wifiUsabilityScoreCount == null ? 0 : this.wifiUsabilityScoreCount.length;
                        newArray = new WifiUsabilityScoreCount[i + arrayLength];
                        if (i != 0) {
                            System.arraycopy(this.wifiUsabilityScoreCount, 0, newArray, 0, i);
                        }
                        while (i < newArray.length - 1) {
                            newArray[i] = new WifiUsabilityScoreCount();
                            input.readMessage(newArray[i]);
                            input.readTag();
                            ++i;
                        }
                        newArray[i] = new WifiUsabilityScoreCount();
                        input.readMessage(newArray[i]);
                        this.wifiUsabilityScoreCount = newArray;
                        continue block151;
                    }
                    case 1026: {
                        arrayLength = WireFormatNano.getRepeatedFieldArrayLength(input, 1026);
                        i = this.mobilityStatePnoStatsList == null ? 0 : this.mobilityStatePnoStatsList.length;
                        newArray = new DeviceMobilityStatePnoScanStats[i + arrayLength];
                        if (i != 0) {
                            System.arraycopy(this.mobilityStatePnoStatsList, 0, newArray, 0, i);
                        }
                        while (i < newArray.length - 1) {
                            newArray[i] = new DeviceMobilityStatePnoScanStats();
                            input.readMessage(newArray[i]);
                            input.readTag();
                            ++i;
                        }
                        newArray[i] = new DeviceMobilityStatePnoScanStats();
                        input.readMessage(newArray[i]);
                        this.mobilityStatePnoStatsList = newArray;
                        continue block151;
                    }
                    case 1034: {
                        if (this.wifiP2PStats == null) {
                            this.wifiP2PStats = new WifiP2pStats();
                        }
                        input.readMessage(this.wifiP2PStats);
                        continue block151;
                    }
                    case 1042: {
                        if (this.wifiDppLog == null) {
                            this.wifiDppLog = new WifiDppLog();
                        }
                        input.readMessage(this.wifiDppLog);
                        continue block151;
                    }
                    case 1048: {
                        this.numEnhancedOpenNetworks = input.readInt32();
                        continue block151;
                    }
                    case 1056: {
                        this.numWpa3PersonalNetworks = input.readInt32();
                        continue block151;
                    }
                    case 1064: {
                        this.numWpa3EnterpriseNetworks = input.readInt32();
                        continue block151;
                    }
                    case 1072: {
                        this.numEnhancedOpenNetworkScanResults = input.readInt32();
                        continue block151;
                    }
                    case 1080: {
                        this.numWpa3PersonalNetworkScanResults = input.readInt32();
                        continue block151;
                    }
                    case 1088: {
                        this.numWpa3EnterpriseNetworkScanResults = input.readInt32();
                        continue block151;
                    }
                    case 1098: {
                        if (this.wifiConfigStoreIo == null) {
                            this.wifiConfigStoreIo = new WifiConfigStoreIO();
                        }
                        input.readMessage(this.wifiConfigStoreIo);
                        continue block151;
                    }
                    case 1104: {
                        this.numSavedNetworksWithMacRandomization = input.readInt32();
                        continue block151;
                    }
                    case 1114: {
                        if (this.linkProbeStats == null) {
                            this.linkProbeStats = new LinkProbeStats();
                        }
                        input.readMessage(this.linkProbeStats);
                        continue block151;
                    }
                    case 1122: {
                        arrayLength = WireFormatNano.getRepeatedFieldArrayLength(input, 1122);
                        i = this.networkSelectionExperimentDecisionsList == null ? 0 : this.networkSelectionExperimentDecisionsList.length;
                        newArray = new NetworkSelectionExperimentDecisions[i + arrayLength];
                        if (i != 0) {
                            System.arraycopy(this.networkSelectionExperimentDecisionsList, 0, newArray, 0, i);
                        }
                        while (i < newArray.length - 1) {
                            newArray[i] = new NetworkSelectionExperimentDecisions();
                            input.readMessage(newArray[i]);
                            input.readTag();
                            ++i;
                        }
                        newArray[i] = new NetworkSelectionExperimentDecisions();
                        input.readMessage(newArray[i]);
                        this.networkSelectionExperimentDecisionsList = newArray;
                        continue block151;
                    }
                    case 1130: {
                        if (this.wifiNetworkRequestApiLog == null) {
                            this.wifiNetworkRequestApiLog = new WifiNetworkRequestApiLog();
                        }
                        input.readMessage(this.wifiNetworkRequestApiLog);
                        continue block151;
                    }
                    case 1138: {
                        if (this.wifiNetworkSuggestionApiLog == null) {
                            this.wifiNetworkSuggestionApiLog = new WifiNetworkSuggestionApiLog();
                        }
                        input.readMessage(this.wifiNetworkSuggestionApiLog);
                        continue block151;
                    }
                    case 1146: {
                        if (this.wifiLockStats == null) {
                            this.wifiLockStats = new WifiLockStats();
                        }
                        input.readMessage(this.wifiLockStats);
                        continue block151;
                    }
                    case 1154: {
                        if (this.wifiToggleStats == null) {
                            this.wifiToggleStats = new WifiToggleStats();
                        }
                        input.readMessage(this.wifiToggleStats);
                        continue block151;
                    }
                    case 1160: {
                        this.numAddOrUpdateNetworkCalls = input.readInt32();
                        continue block151;
                    }
                    case 1168: {
                        this.numEnableNetworkCalls = input.readInt32();
                        continue block151;
                    }
                    case 1178: {
                        if (this.passpointProvisionStats == null) {
                            this.passpointProvisionStats = new PasspointProvisionStats();
                        }
                        input.readMessage(this.passpointProvisionStats);
                        continue block151;
                    }
                    case 1186: 
                }
                arrayLength = WireFormatNano.getRepeatedFieldArrayLength(input, 1186);
                i = this.installedPasspointProfileTypeForR2 == null ? 0 : this.installedPasspointProfileTypeForR2.length;
                newArray = new PasspointProfileTypeCount[i + arrayLength];
                if (i != 0) {
                    System.arraycopy(this.installedPasspointProfileTypeForR2, 0, newArray, 0, i);
                }
                while (i < newArray.length - 1) {
                    newArray[i] = new PasspointProfileTypeCount();
                    input.readMessage(newArray[i]);
                    input.readTag();
                    ++i;
                }
                newArray[i] = new PasspointProfileTypeCount();
                input.readMessage(newArray[i]);
                this.installedPasspointProfileTypeForR2 = newArray;
            }
        }

        public static WifiLog parseFrom(byte[] data) throws InvalidProtocolBufferNanoException {
            return MessageNano.mergeFrom(new WifiLog(), data);
        }

        public static WifiLog parseFrom(CodedInputByteBufferNano input) throws IOException {
            return new WifiLog().mergeFrom(input);
        }

        public static final class WifiSystemStateEntry
        extends MessageNano {
            private static volatile WifiSystemStateEntry[] _emptyArray;
            public int wifiState;
            public int wifiStateCount;
            public boolean isScreenOn;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public static WifiSystemStateEntry[] emptyArray() {
                if (_emptyArray == null) {
                    Object object = InternalNano.LAZY_INIT_LOCK;
                    synchronized (object) {
                        if (_emptyArray == null) {
                            _emptyArray = new WifiSystemStateEntry[0];
                        }
                    }
                }
                return _emptyArray;
            }

            public WifiSystemStateEntry() {
                this.clear();
            }

            public WifiSystemStateEntry clear() {
                this.wifiState = 0;
                this.wifiStateCount = 0;
                this.isScreenOn = false;
                this.cachedSize = -1;
                return this;
            }

            @Override
            public void writeTo(CodedOutputByteBufferNano output) throws IOException {
                if (this.wifiState != 0) {
                    output.writeInt32(1, this.wifiState);
                }
                if (this.wifiStateCount != 0) {
                    output.writeInt32(2, this.wifiStateCount);
                }
                if (this.isScreenOn) {
                    output.writeBool(3, this.isScreenOn);
                }
                super.writeTo(output);
            }

            @Override
            protected int computeSerializedSize() {
                int size = super.computeSerializedSize();
                if (this.wifiState != 0) {
                    size += CodedOutputByteBufferNano.computeInt32Size(1, this.wifiState);
                }
                if (this.wifiStateCount != 0) {
                    size += CodedOutputByteBufferNano.computeInt32Size(2, this.wifiStateCount);
                }
                if (this.isScreenOn) {
                    size += CodedOutputByteBufferNano.computeBoolSize(3, this.isScreenOn);
                }
                return size;
            }

            @Override
            public WifiSystemStateEntry mergeFrom(CodedInputByteBufferNano input) throws IOException {
                block9: while (true) {
                    int tag = input.readTag();
                    switch (tag) {
                        case 0: {
                            return this;
                        }
                        default: {
                            if (WireFormatNano.parseUnknownField(input, tag)) continue block9;
                            return this;
                        }
                        case 8: {
                            int value = input.readInt32();
                            switch (value) {
                                case 0: 
                                case 1: 
                                case 2: 
                                case 3: {
                                    this.wifiState = value;
                                }
                            }
                            continue block9;
                        }
                        case 16: {
                            this.wifiStateCount = input.readInt32();
                            continue block9;
                        }
                        case 24: 
                    }
                    this.isScreenOn = input.readBool();
                }
            }

            public static WifiSystemStateEntry parseFrom(byte[] data) throws InvalidProtocolBufferNanoException {
                return MessageNano.mergeFrom(new WifiSystemStateEntry(), data);
            }

            public static WifiSystemStateEntry parseFrom(CodedInputByteBufferNano input) throws IOException {
                return new WifiSystemStateEntry().mergeFrom(input);
            }
        }

        public static final class ScanReturnEntry
        extends MessageNano {
            private static volatile ScanReturnEntry[] _emptyArray;
            public int scanReturnCode;
            public int scanResultsCount;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public static ScanReturnEntry[] emptyArray() {
                if (_emptyArray == null) {
                    Object object = InternalNano.LAZY_INIT_LOCK;
                    synchronized (object) {
                        if (_emptyArray == null) {
                            _emptyArray = new ScanReturnEntry[0];
                        }
                    }
                }
                return _emptyArray;
            }

            public ScanReturnEntry() {
                this.clear();
            }

            public ScanReturnEntry clear() {
                this.scanReturnCode = 0;
                this.scanResultsCount = 0;
                this.cachedSize = -1;
                return this;
            }

            @Override
            public void writeTo(CodedOutputByteBufferNano output) throws IOException {
                if (this.scanReturnCode != 0) {
                    output.writeInt32(1, this.scanReturnCode);
                }
                if (this.scanResultsCount != 0) {
                    output.writeInt32(2, this.scanResultsCount);
                }
                super.writeTo(output);
            }

            @Override
            protected int computeSerializedSize() {
                int size = super.computeSerializedSize();
                if (this.scanReturnCode != 0) {
                    size += CodedOutputByteBufferNano.computeInt32Size(1, this.scanReturnCode);
                }
                if (this.scanResultsCount != 0) {
                    size += CodedOutputByteBufferNano.computeInt32Size(2, this.scanResultsCount);
                }
                return size;
            }

            @Override
            public ScanReturnEntry mergeFrom(CodedInputByteBufferNano input) throws IOException {
                block8: while (true) {
                    int tag = input.readTag();
                    switch (tag) {
                        case 0: {
                            return this;
                        }
                        default: {
                            if (WireFormatNano.parseUnknownField(input, tag)) continue block8;
                            return this;
                        }
                        case 8: {
                            int value = input.readInt32();
                            switch (value) {
                                case 0: 
                                case 1: 
                                case 2: 
                                case 3: 
                                case 4: {
                                    this.scanReturnCode = value;
                                }
                            }
                            continue block8;
                        }
                        case 16: 
                    }
                    this.scanResultsCount = input.readInt32();
                }
            }

            public static ScanReturnEntry parseFrom(byte[] data) throws InvalidProtocolBufferNanoException {
                return MessageNano.mergeFrom(new ScanReturnEntry(), data);
            }

            public static ScanReturnEntry parseFrom(CodedInputByteBufferNano input) throws IOException {
                return new ScanReturnEntry().mergeFrom(input);
            }
        }
    }
}

