/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import android.app.ActivityOptions;
import android.app.WindowConfiguration;
import android.content.res.Configuration;
import android.graphics.Point;
import android.util.IntArray;
import android.util.Slog;
import android.util.proto.ProtoOutputStream;
import android.view.Display;
import android.view.IApplicationToken;
import com.android.internal.annotations.VisibleForTesting;
import com.android.server.am.EventLogTags;
import com.android.server.wm.ActivityRecord;
import com.android.server.wm.ActivityStack;
import com.android.server.wm.ActivityTaskManagerInternal;
import com.android.server.wm.ActivityTaskManagerService;
import com.android.server.wm.AppWindowToken;
import com.android.server.wm.ConfigurationContainer;
import com.android.server.wm.DisplayContent;
import com.android.server.wm.RootActivityContainer;
import com.android.server.wm.TaskRecord;
import com.android.server.wm.WindowContainerListener;
import java.io.PrintWriter;
import java.util.ArrayList;

class ActivityDisplay
extends ConfigurationContainer<ActivityStack>
implements WindowContainerListener {
    private static final String TAG = "ActivityTaskManager";
    private static final String TAG_STACK = "ActivityTaskManager";
    static final int POSITION_TOP = Integer.MAX_VALUE;
    static final int POSITION_BOTTOM = Integer.MIN_VALUE;
    private static int sNextFreeStackId = 0;
    private ActivityTaskManagerService mService;
    private RootActivityContainer mRootActivityContainer;
    DisplayContent mDisplayContent;
    int mDisplayId;
    Display mDisplay;
    private final ArrayList<ActivityStack> mStacks = new ArrayList();
    private ArrayList<OnStackOrderChangedListener> mStackOrderChangedCallbacks = new ArrayList();
    private IntArray mDisplayAccessUIDs = new IntArray();
    final ArrayList<ActivityTaskManagerInternal.SleepToken> mAllSleepTokens = new ArrayList();
    ActivityTaskManagerInternal.SleepToken mOffToken;
    private boolean mSleeping;
    private boolean mRemoved;
    private boolean mSingleTaskInstance;
    private ActivityRecord mLastCompatModeActivity;
    private ActivityStack mPreferredTopFocusableStack;
    private ActivityStack mLastFocusedStack;
    private ActivityStack mHomeStack = null;
    private ActivityStack mRecentsStack = null;
    private ActivityStack mPinnedStack = null;
    private ActivityStack mSplitScreenPrimaryStack = null;
    private Point mTmpDisplaySize = new Point();
    private final RootActivityContainer.FindTaskResult mTmpFindTaskResult = new RootActivityContainer.FindTaskResult();

    ActivityDisplay(RootActivityContainer root, Display display) {
        this.mRootActivityContainer = root;
        this.mService = root.mService;
        this.mDisplayId = display.getDisplayId();
        this.mDisplay = display;
        this.mDisplayContent = this.createDisplayContent();
        this.updateBounds();
    }

    protected DisplayContent createDisplayContent() {
        return this.mService.mWindowManager.mRoot.createDisplayContent(this.mDisplay, this);
    }

    private void updateBounds() {
        this.mDisplay.getRealSize(this.mTmpDisplaySize);
        this.setBounds(0, 0, this.mTmpDisplaySize.x, this.mTmpDisplaySize.y);
    }

    void onDisplayChanged() {
        int displayId = this.mDisplay.getDisplayId();
        if (displayId != 0) {
            int displayState = this.mDisplay.getState();
            if (displayState == 1 && this.mOffToken == null) {
                this.mOffToken = this.mService.acquireSleepToken("Display-off", displayId);
            } else if (displayState == 2 && this.mOffToken != null) {
                this.mOffToken.release();
                this.mOffToken = null;
            }
        }
        this.updateBounds();
        if (this.mDisplayContent != null) {
            this.mDisplayContent.updateDisplayInfo();
            this.mService.mWindowManager.requestTraversal();
        }
    }

    @Override
    public void onInitializeOverrideConfiguration(Configuration config) {
        this.getRequestedOverrideConfiguration().updateFrom(config);
    }

    void addChild(ActivityStack stack, int position) {
        if (position == Integer.MIN_VALUE) {
            position = 0;
        } else if (position == Integer.MAX_VALUE) {
            position = this.mStacks.size();
        }
        this.addStackReferenceIfNeeded(stack);
        this.positionChildAt(stack, position);
        this.mService.updateSleepIfNeededLocked();
    }

    void removeChild(ActivityStack stack) {
        this.mStacks.remove(stack);
        if (this.mPreferredTopFocusableStack == stack) {
            this.mPreferredTopFocusableStack = null;
        }
        this.removeStackReferenceIfNeeded(stack);
        this.releaseSelfIfNeeded();
        this.mService.updateSleepIfNeededLocked();
        this.onStackOrderChanged(stack);
    }

    void positionChildAtTop(ActivityStack stack, boolean includingParents) {
        this.positionChildAtTop(stack, includingParents, null);
    }

    void positionChildAtTop(ActivityStack stack, boolean includingParents, String updateLastFocusedStackReason) {
        this.positionChildAt(stack, this.mStacks.size(), includingParents, updateLastFocusedStackReason);
    }

    void positionChildAtBottom(ActivityStack stack) {
        this.positionChildAtBottom(stack, null);
    }

    void positionChildAtBottom(ActivityStack stack, String updateLastFocusedStackReason) {
        this.positionChildAt(stack, 0, false, updateLastFocusedStackReason);
    }

    private void positionChildAt(ActivityStack stack, int position) {
        this.positionChildAt(stack, position, false, null);
    }

    private void positionChildAt(ActivityStack stack, int position, boolean includingParents, String updateLastFocusedStackReason) {
        ActivityStack currentFocusedStack;
        ActivityStack prevFocusedStack = updateLastFocusedStackReason != null ? this.getFocusedStack() : null;
        boolean wasContained = this.mStacks.remove(stack);
        if (this.mSingleTaskInstance && this.getChildCount() > 0) {
            throw new IllegalStateException("positionChildAt: Can only have one child on display=" + this);
        }
        int insertPosition = this.getTopInsertPosition(stack, position);
        this.mStacks.add(insertPosition, stack);
        if (wasContained && position >= this.mStacks.size() - 1 && stack.isFocusableAndVisible()) {
            this.mPreferredTopFocusableStack = stack;
        } else if (this.mPreferredTopFocusableStack == stack) {
            this.mPreferredTopFocusableStack = null;
        }
        if (updateLastFocusedStackReason != null && (currentFocusedStack = this.getFocusedStack()) != prevFocusedStack) {
            this.mLastFocusedStack = prevFocusedStack;
            EventLogTags.writeAmFocusedStack(this.mRootActivityContainer.mCurrentUser, this.mDisplayId, currentFocusedStack == null ? -1 : currentFocusedStack.getStackId(), this.mLastFocusedStack == null ? -1 : this.mLastFocusedStack.getStackId(), updateLastFocusedStackReason);
        }
        if (stack.getTaskStack() != null && this.mDisplayContent != null) {
            this.mDisplayContent.positionStackAt(insertPosition, stack.getTaskStack(), includingParents);
        }
        if (!wasContained) {
            stack.setParent(this);
        }
        this.onStackOrderChanged(stack);
    }

    private int getTopInsertPosition(ActivityStack stack, int candidatePosition) {
        ActivityStack targetStack;
        int position;
        if (stack.inPinnedWindowingMode()) {
            return Math.min(position, candidatePosition);
        }
        for (position = this.mStacks.size(); position > 0 && (targetStack = this.mStacks.get(position - 1)).isAlwaysOnTop() && (!stack.isAlwaysOnTop() || targetStack.inPinnedWindowingMode()); --position) {
        }
        return Math.min(position, candidatePosition);
    }

    <T extends ActivityStack> T getStack(int stackId) {
        for (int i = this.mStacks.size() - 1; i >= 0; --i) {
            ActivityStack stack = this.mStacks.get(i);
            if (stack.mStackId != stackId) continue;
            return (T)stack;
        }
        return null;
    }

    <T extends ActivityStack> T getStack(int windowingMode, int activityType) {
        if (activityType == 2) {
            return (T)this.mHomeStack;
        }
        if (activityType == 3) {
            return (T)this.mRecentsStack;
        }
        if (windowingMode == 2) {
            return (T)this.mPinnedStack;
        }
        if (windowingMode == 3) {
            return (T)this.mSplitScreenPrimaryStack;
        }
        for (int i = this.mStacks.size() - 1; i >= 0; --i) {
            ActivityStack stack = this.mStacks.get(i);
            if (!stack.isCompatible(windowingMode, activityType)) continue;
            return (T)stack;
        }
        return null;
    }

    private boolean alwaysCreateStack(int windowingMode, int activityType) {
        return activityType == 1 && (windowingMode == 1 || windowingMode == 5 || windowingMode == 4);
    }

    <T extends ActivityStack> T getOrCreateStack(int windowingMode, int activityType, boolean onTop) {
        T stack;
        if (!this.alwaysCreateStack(windowingMode, activityType) && (stack = this.getStack(windowingMode, activityType)) != null) {
            return stack;
        }
        return this.createStack(windowingMode, activityType, onTop);
    }

    <T extends ActivityStack> T getOrCreateStack(ActivityRecord r, ActivityOptions options, TaskRecord candidateTask, int activityType, boolean onTop) {
        int windowingMode = options != null ? options.getLaunchWindowingMode() : 0;
        windowingMode = this.validateWindowingMode(windowingMode, r, candidateTask, activityType);
        return this.getOrCreateStack(windowingMode, activityType, onTop);
    }

    @VisibleForTesting
    int getNextStackId() {
        return sNextFreeStackId++;
    }

    <T extends ActivityStack> T createStack(int windowingMode, int activityType, boolean onTop) {
        T stack;
        if (this.mSingleTaskInstance && this.getChildCount() > 0) {
            return this.mRootActivityContainer.getDefaultDisplay().createStack(windowingMode, activityType, onTop);
        }
        if (activityType == 0) {
            activityType = 1;
        }
        if (activityType != 1 && (stack = this.getStack(0, activityType)) != null) {
            throw new IllegalArgumentException("Stack=" + stack + " of activityType=" + activityType + " already on display=" + this + ". Can't have multiple.");
        }
        if (!this.isWindowingModeSupported(windowingMode, this.mService.mSupportsMultiWindow, this.mService.mSupportsSplitScreenMultiWindow, this.mService.mSupportsFreeformWindowManagement, this.mService.mSupportsPictureInPicture, activityType)) {
            throw new IllegalArgumentException("Can't create stack for unsupported windowingMode=" + windowingMode);
        }
        int stackId = this.getNextStackId();
        return this.createStackUnchecked(windowingMode, activityType, stackId, onTop);
    }

    @VisibleForTesting
    <T extends ActivityStack> T createStackUnchecked(int windowingMode, int activityType, int stackId, boolean onTop) {
        if (windowingMode == 2 && activityType != 1) {
            throw new IllegalArgumentException("Stack with windowing mode cannot with non standard activity type.");
        }
        return (T)new ActivityStack(this, stackId, this.mRootActivityContainer.mStackSupervisor, windowingMode, activityType, onTop);
    }

    ActivityStack getFocusedStack() {
        if (this.mPreferredTopFocusableStack != null) {
            return this.mPreferredTopFocusableStack;
        }
        for (int i = this.mStacks.size() - 1; i >= 0; --i) {
            ActivityStack stack = this.mStacks.get(i);
            if (!stack.isFocusableAndVisible()) continue;
            return stack;
        }
        return null;
    }

    ActivityStack getNextFocusableStack() {
        return this.getNextFocusableStack(null, false);
    }

    ActivityStack getNextFocusableStack(ActivityStack currentFocus, boolean ignoreCurrent) {
        int currentWindowingMode = currentFocus != null ? currentFocus.getWindowingMode() : 0;
        ActivityStack candidate = null;
        for (int i = this.mStacks.size() - 1; i >= 0; --i) {
            ActivityStack stack = this.mStacks.get(i);
            if (ignoreCurrent && stack == currentFocus || !stack.isFocusableAndVisible()) continue;
            if (currentWindowingMode == 4 && candidate == null && stack.inSplitScreenPrimaryWindowingMode()) {
                candidate = stack;
                continue;
            }
            if (candidate != null && stack.inSplitScreenSecondaryWindowingMode()) {
                return candidate;
            }
            return stack;
        }
        return candidate;
    }

    ActivityRecord getResumedActivity() {
        ActivityStack focusedStack = this.getFocusedStack();
        if (focusedStack == null) {
            return null;
        }
        ActivityRecord resumedActivity = focusedStack.getResumedActivity();
        if (!(resumedActivity != null && resumedActivity.app != null || (resumedActivity = focusedStack.mPausingActivity) != null && resumedActivity.app != null)) {
            resumedActivity = focusedStack.topRunningActivityLocked(true);
        }
        return resumedActivity;
    }

    ActivityStack getLastFocusedStack() {
        return this.mLastFocusedStack;
    }

    boolean allResumedActivitiesComplete() {
        ActivityStack currentFocusedStack;
        for (int stackNdx = this.mStacks.size() - 1; stackNdx >= 0; --stackNdx) {
            ActivityRecord r = this.mStacks.get(stackNdx).getResumedActivity();
            if (r == null || r.isState(ActivityStack.ActivityState.RESUMED)) continue;
            return false;
        }
        this.mLastFocusedStack = currentFocusedStack = this.getFocusedStack();
        return true;
    }

    boolean pauseBackStacks(boolean userLeaving, ActivityRecord resuming, boolean dontWait) {
        boolean someActivityPaused = false;
        for (int stackNdx = this.mStacks.size() - 1; stackNdx >= 0; --stackNdx) {
            ActivityStack stack = this.mStacks.get(stackNdx);
            ActivityRecord resumedActivity = stack.getResumedActivity();
            if (resumedActivity == null || stack.getVisibility(resuming) == 0 && stack.isFocusable()) continue;
            someActivityPaused |= stack.startPausingLocked(userLeaving, false, resuming, dontWait);
        }
        return someActivityPaused;
    }

    void findTaskLocked(ActivityRecord r, boolean isPreferredDisplay, RootActivityContainer.FindTaskResult result) {
        this.mTmpFindTaskResult.clear();
        for (int stackNdx = this.getChildCount() - 1; stackNdx >= 0; --stackNdx) {
            ActivityStack stack = this.getChildAt(stackNdx);
            if (!r.hasCompatibleActivityType(stack)) continue;
            stack.findTaskLocked(r, this.mTmpFindTaskResult);
            if (this.mTmpFindTaskResult.mRecord == null) continue;
            if (this.mTmpFindTaskResult.mIdealMatch) {
                result.setTo(this.mTmpFindTaskResult);
                return;
            }
            if (!isPreferredDisplay) continue;
            result.setTo(this.mTmpFindTaskResult);
        }
    }

    void removeStacksInWindowingModes(int ... windowingModes) {
        if (windowingModes == null || windowingModes.length == 0) {
            return;
        }
        ArrayList<ActivityStack> stacks = new ArrayList<ActivityStack>();
        for (int j = windowingModes.length - 1; j >= 0; --j) {
            int windowingMode = windowingModes[j];
            for (int i = this.mStacks.size() - 1; i >= 0; --i) {
                ActivityStack stack = this.mStacks.get(i);
                if (!stack.isActivityTypeStandardOrUndefined() || stack.getWindowingMode() != windowingMode) continue;
                stacks.add(stack);
            }
        }
        for (int i = stacks.size() - 1; i >= 0; --i) {
            this.mRootActivityContainer.mStackSupervisor.removeStack((ActivityStack)stacks.get(i));
        }
    }

    void removeStacksWithActivityTypes(int ... activityTypes) {
        if (activityTypes == null || activityTypes.length == 0) {
            return;
        }
        ArrayList<ActivityStack> stacks = new ArrayList<ActivityStack>();
        for (int j = activityTypes.length - 1; j >= 0; --j) {
            int activityType = activityTypes[j];
            for (int i = this.mStacks.size() - 1; i >= 0; --i) {
                ActivityStack stack = this.mStacks.get(i);
                if (stack.getActivityType() != activityType) continue;
                stacks.add(stack);
            }
        }
        for (int i = stacks.size() - 1; i >= 0; --i) {
            this.mRootActivityContainer.mStackSupervisor.removeStack((ActivityStack)stacks.get(i));
        }
    }

    void onStackWindowingModeChanged(ActivityStack stack) {
        this.removeStackReferenceIfNeeded(stack);
        this.addStackReferenceIfNeeded(stack);
    }

    private void addStackReferenceIfNeeded(ActivityStack stack) {
        int activityType = stack.getActivityType();
        int windowingMode = stack.getWindowingMode();
        if (activityType == 2) {
            if (this.mHomeStack != null && this.mHomeStack != stack) {
                throw new IllegalArgumentException("addStackReferenceIfNeeded: home stack=" + this.mHomeStack + " already exist on display=" + this + " stack=" + stack);
            }
            this.mHomeStack = stack;
        } else if (activityType == 3) {
            if (this.mRecentsStack != null && this.mRecentsStack != stack) {
                throw new IllegalArgumentException("addStackReferenceIfNeeded: recents stack=" + this.mRecentsStack + " already exist on display=" + this + " stack=" + stack);
            }
            this.mRecentsStack = stack;
        }
        if (windowingMode == 2) {
            if (this.mPinnedStack != null && this.mPinnedStack != stack) {
                throw new IllegalArgumentException("addStackReferenceIfNeeded: pinned stack=" + this.mPinnedStack + " already exist on display=" + this + " stack=" + stack);
            }
            this.mPinnedStack = stack;
        } else if (windowingMode == 3) {
            if (this.mSplitScreenPrimaryStack != null && this.mSplitScreenPrimaryStack != stack) {
                throw new IllegalArgumentException("addStackReferenceIfNeeded: split-screen-primary stack=" + this.mSplitScreenPrimaryStack + " already exist on display=" + this + " stack=" + stack);
            }
            this.mSplitScreenPrimaryStack = stack;
            this.onSplitScreenModeActivated();
        }
    }

    private void removeStackReferenceIfNeeded(ActivityStack stack) {
        if (stack == this.mHomeStack) {
            this.mHomeStack = null;
        } else if (stack == this.mRecentsStack) {
            this.mRecentsStack = null;
        } else if (stack == this.mPinnedStack) {
            this.mPinnedStack = null;
        } else if (stack == this.mSplitScreenPrimaryStack) {
            this.mSplitScreenPrimaryStack = null;
            this.onSplitScreenModeDismissed();
        }
    }

    private void onSplitScreenModeDismissed() {
        this.mRootActivityContainer.mWindowManager.deferSurfaceLayout();
        try {
            for (int i = this.mStacks.size() - 1; i >= 0; --i) {
                ActivityStack otherStack = this.mStacks.get(i);
                if (!otherStack.inSplitScreenSecondaryWindowingMode()) continue;
                otherStack.setWindowingMode(0, false, false, false, true, false);
            }
        }
        finally {
            ActivityStack topFullscreenStack = this.getTopStackInWindowingMode(1);
            if (topFullscreenStack != null && this.mHomeStack != null && !this.isTopStack(this.mHomeStack)) {
                this.mHomeStack.moveToFront("onSplitScreenModeDismissed");
                topFullscreenStack.moveToFront("onSplitScreenModeDismissed");
            }
            this.mRootActivityContainer.mWindowManager.continueSurfaceLayout();
        }
    }

    private void onSplitScreenModeActivated() {
        this.mRootActivityContainer.mWindowManager.deferSurfaceLayout();
        try {
            for (int i = this.mStacks.size() - 1; i >= 0; --i) {
                ActivityStack otherStack = this.mStacks.get(i);
                if (otherStack == this.mSplitScreenPrimaryStack || !otherStack.affectedBySplitScreenResize()) continue;
                otherStack.setWindowingMode(4, false, false, true, true, false);
            }
        }
        finally {
            this.mRootActivityContainer.mWindowManager.continueSurfaceLayout();
        }
    }

    private boolean isWindowingModeSupported(int windowingMode, boolean supportsMultiWindow, boolean supportsSplitScreen, boolean supportsFreeform, boolean supportsPip, int activityType) {
        if (windowingMode == 0 || windowingMode == 1) {
            return true;
        }
        if (!supportsMultiWindow) {
            return false;
        }
        int displayWindowingMode = this.getWindowingMode();
        if (windowingMode == 3 || windowingMode == 4) {
            return supportsSplitScreen && WindowConfiguration.supportSplitScreenWindowingMode(activityType) && displayWindowingMode != 5;
        }
        if (!supportsFreeform && windowingMode == 5) {
            return false;
        }
        return supportsPip || windowingMode != 2;
    }

    int resolveWindowingMode(ActivityRecord r, ActivityOptions options, TaskRecord task, int activityType) {
        int windowingMode;
        int n = windowingMode = options != null ? options.getLaunchWindowingMode() : 0;
        if (windowingMode == 0) {
            if (task != null) {
                windowingMode = task.getWindowingMode();
            }
            if (windowingMode == 0 && r != null) {
                windowingMode = r.getWindowingMode();
            }
            if (windowingMode == 0) {
                windowingMode = this.getWindowingMode();
            }
        }
        return (windowingMode = this.validateWindowingMode(windowingMode, r, task, activityType)) != 0 ? windowingMode : 1;
    }

    int validateWindowingMode(int windowingMode, ActivityRecord r, TaskRecord task, int activityType) {
        boolean inSplitScreenMode;
        boolean supportsMultiWindow = this.mService.mSupportsMultiWindow;
        boolean supportsSplitScreen = this.mService.mSupportsSplitScreenMultiWindow;
        boolean supportsFreeform = this.mService.mSupportsFreeformWindowManagement;
        boolean supportsPip = this.mService.mSupportsPictureInPicture;
        if (supportsMultiWindow) {
            if (task != null) {
                supportsMultiWindow = task.isResizeable();
                supportsSplitScreen = task.supportsSplitScreenWindowingMode();
            } else if (r != null) {
                supportsMultiWindow = r.isResizeable();
                supportsSplitScreen = r.supportsSplitScreenWindowingMode();
                supportsFreeform = r.supportsFreeform();
                supportsPip = r.supportsPictureInPicture();
            }
        }
        if (!(inSplitScreenMode = this.hasSplitScreenPrimaryStack()) && windowingMode == 4) {
            windowingMode = 0;
        } else if (inSplitScreenMode && (windowingMode == 1 || windowingMode == 0) && supportsSplitScreen) {
            windowingMode = 4;
        }
        if (windowingMode != 0 && this.isWindowingModeSupported(windowingMode, supportsMultiWindow, supportsSplitScreen, supportsFreeform, supportsPip, activityType)) {
            return windowingMode;
        }
        return 0;
    }

    ActivityStack getTopStack() {
        return this.mStacks.isEmpty() ? null : this.mStacks.get(this.mStacks.size() - 1);
    }

    boolean isTopStack(ActivityStack stack) {
        return stack == this.getTopStack();
    }

    boolean isTopNotPinnedStack(ActivityStack stack) {
        for (int i = this.mStacks.size() - 1; i >= 0; --i) {
            ActivityStack current = this.mStacks.get(i);
            if (current.inPinnedWindowingMode()) continue;
            return current == stack;
        }
        return false;
    }

    ActivityStack getTopStackInWindowingMode(int windowingMode) {
        for (int i = this.mStacks.size() - 1; i >= 0; --i) {
            ActivityStack current = this.mStacks.get(i);
            if (windowingMode != current.getWindowingMode()) continue;
            return current;
        }
        return null;
    }

    ActivityRecord topRunningActivity() {
        return this.topRunningActivity(false);
    }

    ActivityRecord topRunningActivity(boolean considerKeyguardState) {
        ActivityRecord topRunning = null;
        ActivityStack focusedStack = this.getFocusedStack();
        if (focusedStack != null) {
            topRunning = focusedStack.topRunningActivityLocked();
        }
        if (topRunning == null) {
            ActivityStack stack;
            for (int i = this.mStacks.size() - 1; !(i < 0 || (stack = this.mStacks.get(i)) != focusedStack && stack.isFocusable() && (topRunning = stack.topRunningActivityLocked()) != null); --i) {
            }
        }
        if (topRunning != null && considerKeyguardState && this.mRootActivityContainer.mStackSupervisor.getKeyguardController().isKeyguardLocked() && !topRunning.canShowWhenLocked()) {
            return null;
        }
        return topRunning;
    }

    int getIndexOf(ActivityStack stack) {
        return this.mStacks.indexOf(stack);
    }

    @Override
    public void onRequestedOverrideConfigurationChanged(Configuration overrideConfiguration) {
        int currRotation = this.getRequestedOverrideConfiguration().windowConfiguration.getRotation();
        if (currRotation != -1 && currRotation != overrideConfiguration.windowConfiguration.getRotation() && this.mDisplayContent != null) {
            this.mDisplayContent.applyRotationLocked(currRotation, overrideConfiguration.windowConfiguration.getRotation());
        }
        super.onRequestedOverrideConfigurationChanged(overrideConfiguration);
        if (this.mDisplayContent != null) {
            this.mService.mWindowManager.setNewDisplayOverrideConfiguration(overrideConfiguration, this.mDisplayContent);
        }
    }

    @Override
    public void onConfigurationChanged(Configuration newParentConfig) {
        if (this.mDisplayContent != null) {
            this.mDisplayContent.preOnConfigurationChanged();
        }
        super.onConfigurationChanged(newParentConfig);
    }

    void onLockTaskPackagesUpdated() {
        for (int i = this.mStacks.size() - 1; i >= 0; --i) {
            this.mStacks.get(i).onLockTaskPackagesUpdated();
        }
    }

    void onExitingSplitScreenMode() {
        this.mSplitScreenPrimaryStack = null;
    }

    void handleActivitySizeCompatModeIfNeeded(ActivityRecord r) {
        if (!r.isState(ActivityStack.ActivityState.RESUMED) || r.getWindowingMode() != 1) {
            return;
        }
        if (!r.inSizeCompatMode()) {
            if (this.mLastCompatModeActivity != null) {
                this.mService.getTaskChangeNotificationController().notifySizeCompatModeActivityChanged(this.mDisplayId, null);
            }
            this.mLastCompatModeActivity = null;
            return;
        }
        if (this.mLastCompatModeActivity == r) {
            return;
        }
        this.mLastCompatModeActivity = r;
        this.mService.getTaskChangeNotificationController().notifySizeCompatModeActivityChanged(this.mDisplayId, r.appToken);
    }

    ActivityStack getSplitScreenPrimaryStack() {
        return this.mSplitScreenPrimaryStack;
    }

    boolean hasSplitScreenPrimaryStack() {
        return this.mSplitScreenPrimaryStack != null;
    }

    ActivityStack getPinnedStack() {
        return this.mPinnedStack;
    }

    boolean hasPinnedStack() {
        return this.mPinnedStack != null;
    }

    public String toString() {
        return "ActivityDisplay={" + this.mDisplayId + " numStacks=" + this.mStacks.size() + "}";
    }

    @Override
    protected int getChildCount() {
        return this.mStacks.size();
    }

    @Override
    protected ActivityStack getChildAt(int index) {
        return this.mStacks.get(index);
    }

    @Override
    protected ConfigurationContainer getParent() {
        return this.mRootActivityContainer;
    }

    boolean isPrivate() {
        return (this.mDisplay.getFlags() & 4) != 0;
    }

    boolean isUidPresent(int uid) {
        for (ActivityStack stack : this.mStacks) {
            if (!stack.isUidPresent(uid)) continue;
            return true;
        }
        return false;
    }

    boolean isRemoved() {
        return this.mRemoved;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void remove() {
        boolean destroyContentOnRemoval = this.shouldDestroyContentOnRemove();
        ActivityStack lastReparentedStack = null;
        this.mPreferredTopFocusableStack = null;
        ActivityDisplay toDisplay = this.mRootActivityContainer.getDefaultDisplay();
        this.mRootActivityContainer.mStackSupervisor.beginDeferResume();
        try {
            int numStacks = this.mStacks.size();
            for (int stackNdx = 0; stackNdx < numStacks; ++stackNdx) {
                ActivityStack stack = this.mStacks.get(stackNdx);
                if (destroyContentOnRemoval || !stack.isActivityTypeStandardOrUndefined()) {
                    stack.finishAllActivitiesLocked(true);
                } else {
                    int windowingMode = toDisplay.hasSplitScreenPrimaryStack() ? 4 : 0;
                    stack.reparent(toDisplay, true, true);
                    stack.setWindowingMode(windowingMode);
                    lastReparentedStack = stack;
                }
                stackNdx -= numStacks - this.mStacks.size();
                numStacks = this.mStacks.size();
            }
        }
        finally {
            this.mRootActivityContainer.mStackSupervisor.endDeferResume();
        }
        this.mRemoved = true;
        if (lastReparentedStack != null) {
            lastReparentedStack.postReparent();
        }
        this.releaseSelfIfNeeded();
        if (!this.mAllSleepTokens.isEmpty()) {
            this.mRootActivityContainer.mSleepTokens.removeAll(this.mAllSleepTokens);
            this.mAllSleepTokens.clear();
            this.mService.updateSleepIfNeededLocked();
        }
    }

    private void releaseSelfIfNeeded() {
        ActivityStack stack;
        if (!this.mRemoved || this.mDisplayContent == null) {
            return;
        }
        ActivityStack activityStack = stack = this.mStacks.size() == 1 ? this.mStacks.get(0) : null;
        if (stack != null && stack.isActivityTypeHome() && stack.getAllTasks().isEmpty()) {
            stack.remove();
        } else if (this.mStacks.isEmpty()) {
            this.mDisplayContent.removeIfPossible();
            this.mDisplayContent = null;
            this.mRootActivityContainer.removeChild(this);
            this.mRootActivityContainer.mStackSupervisor.getKeyguardController().onDisplayRemoved(this.mDisplayId);
        }
    }

    IntArray getPresentUIDs() {
        this.mDisplayAccessUIDs.clear();
        for (ActivityStack stack : this.mStacks) {
            stack.getPresentUIDs(this.mDisplayAccessUIDs);
        }
        return this.mDisplayAccessUIDs;
    }

    boolean supportsSystemDecorations() {
        return this.mDisplayContent.supportsSystemDecorations();
    }

    @VisibleForTesting
    boolean shouldDestroyContentOnRemove() {
        return this.mDisplay.getRemoveMode() == 1;
    }

    boolean shouldSleep() {
        return (this.mStacks.isEmpty() || !this.mAllSleepTokens.isEmpty()) && this.mService.mRunningVoice == null;
    }

    void setFocusedApp(ActivityRecord r, boolean moveFocusNow) {
        AppWindowToken newFocus;
        if (this.mDisplayContent == null) {
            return;
        }
        IApplicationToken.Stub token = r.appToken;
        if (token == null) {
            newFocus = null;
        } else {
            newFocus = this.mService.mWindowManager.mRoot.getAppWindowToken(token);
            if (newFocus == null) {
                Slog.w("WindowManager", "Attempted to set focus to non-existing app token: " + token + ", displayId=" + this.mDisplayId);
            }
        }
        boolean changed = this.mDisplayContent.setFocusedApp(newFocus);
        if (moveFocusNow && changed) {
            this.mService.mWindowManager.updateFocusedWindowLocked(0, true);
        }
    }

    ActivityStack getStackAbove(ActivityStack stack) {
        int stackIndex = this.mStacks.indexOf(stack) + 1;
        return stackIndex < this.mStacks.size() ? this.mStacks.get(stackIndex) : null;
    }

    void moveStackBehindBottomMostVisibleStack(ActivityStack stack) {
        if (stack.shouldBeVisible(null)) {
            return;
        }
        this.positionChildAtBottom(stack);
        int numStacks = this.mStacks.size();
        for (int stackNdx = 0; stackNdx < numStacks; ++stackNdx) {
            boolean isValidWindowingMode;
            ActivityStack s = this.mStacks.get(stackNdx);
            if (s == stack) continue;
            int winMode = s.getWindowingMode();
            boolean bl = isValidWindowingMode = winMode == 1 || winMode == 4;
            if (!s.shouldBeVisible(null) || !isValidWindowingMode) continue;
            this.positionChildAt(stack, Math.max(0, stackNdx - 1));
            break;
        }
    }

    void moveStackBehindStack(ActivityStack stack, ActivityStack behindStack) {
        int behindStackIndex;
        if (behindStack == null || behindStack == stack) {
            return;
        }
        int stackIndex = this.mStacks.indexOf(stack);
        int insertIndex = stackIndex <= (behindStackIndex = this.mStacks.indexOf(behindStack)) ? behindStackIndex - 1 : behindStackIndex;
        this.positionChildAt(stack, Math.max(0, insertIndex));
    }

    void ensureActivitiesVisible(ActivityRecord starting, int configChanges, boolean preserveWindows, boolean notifyClients) {
        for (int stackNdx = this.getChildCount() - 1; stackNdx >= 0; --stackNdx) {
            ActivityStack stack = this.getChildAt(stackNdx);
            stack.ensureActivitiesVisibleLocked(starting, configChanges, preserveWindows, notifyClients);
        }
    }

    void moveHomeStackToFront(String reason) {
        if (this.mHomeStack != null) {
            this.mHomeStack.moveToFront(reason);
        }
    }

    void moveHomeActivityToTop(String reason) {
        ActivityRecord top = this.getHomeActivity();
        if (top == null) {
            this.moveHomeStackToFront(reason);
            return;
        }
        top.moveFocusableActivityToTop(reason);
    }

    ActivityStack getHomeStack() {
        return this.mHomeStack;
    }

    ActivityRecord getHomeActivity() {
        return this.getHomeActivityForUser(this.mRootActivityContainer.mCurrentUser);
    }

    ActivityRecord getHomeActivityForUser(int userId) {
        if (this.mHomeStack == null) {
            return null;
        }
        ArrayList<TaskRecord> tasks = this.mHomeStack.getAllTasks();
        for (int taskNdx = tasks.size() - 1; taskNdx >= 0; --taskNdx) {
            TaskRecord task = tasks.get(taskNdx);
            if (!task.isActivityTypeHome()) continue;
            ArrayList<ActivityRecord> activities = task.mActivities;
            for (int activityNdx = activities.size() - 1; activityNdx >= 0; --activityNdx) {
                ActivityRecord r = activities.get(activityNdx);
                if (!r.isActivityTypeHome() || userId != -1 && r.mUserId != userId) continue;
                return r;
            }
        }
        return null;
    }

    boolean isSleeping() {
        return this.mSleeping;
    }

    void setIsSleeping(boolean asleep) {
        this.mSleeping = asleep;
    }

    void registerStackOrderChangedListener(OnStackOrderChangedListener listener) {
        if (!this.mStackOrderChangedCallbacks.contains(listener)) {
            this.mStackOrderChangedCallbacks.add(listener);
        }
    }

    void unregisterStackOrderChangedListener(OnStackOrderChangedListener listener) {
        this.mStackOrderChangedCallbacks.remove(listener);
    }

    private void onStackOrderChanged(ActivityStack stack) {
        for (int i = this.mStackOrderChangedCallbacks.size() - 1; i >= 0; --i) {
            this.mStackOrderChangedCallbacks.get(i).onStackOrderChanged(stack);
        }
    }

    public void deferUpdateImeTarget() {
        if (this.mDisplayContent != null) {
            this.mDisplayContent.deferUpdateImeTarget();
        }
    }

    public void continueUpdateImeTarget() {
        if (this.mDisplayContent != null) {
            this.mDisplayContent.continueUpdateImeTarget();
        }
    }

    void setDisplayToSingleTaskInstance() {
        ActivityStack stack;
        int childCount = this.getChildCount();
        if (childCount > 1) {
            throw new IllegalArgumentException("Display already has multiple stacks. display=" + this);
        }
        if (childCount > 0 && (stack = this.getChildAt(0)).getChildCount() > 1) {
            throw new IllegalArgumentException("Display stack already has multiple tasks. display=" + this + " stack=" + stack);
        }
        this.mSingleTaskInstance = true;
    }

    boolean isSingleTaskInstance() {
        return this.mSingleTaskInstance;
    }

    public void dump(PrintWriter pw, String prefix) {
        pw.println(prefix + "displayId=" + this.mDisplayId + " stacks=" + this.mStacks.size() + (this.mSingleTaskInstance ? " mSingleTaskInstance" : ""));
        String myPrefix = prefix + " ";
        if (this.mHomeStack != null) {
            pw.println(myPrefix + "mHomeStack=" + this.mHomeStack);
        }
        if (this.mRecentsStack != null) {
            pw.println(myPrefix + "mRecentsStack=" + this.mRecentsStack);
        }
        if (this.mPinnedStack != null) {
            pw.println(myPrefix + "mPinnedStack=" + this.mPinnedStack);
        }
        if (this.mSplitScreenPrimaryStack != null) {
            pw.println(myPrefix + "mSplitScreenPrimaryStack=" + this.mSplitScreenPrimaryStack);
        }
        if (this.mPreferredTopFocusableStack != null) {
            pw.println(myPrefix + "mPreferredTopFocusableStack=" + this.mPreferredTopFocusableStack);
        }
        if (this.mLastFocusedStack != null) {
            pw.println(myPrefix + "mLastFocusedStack=" + this.mLastFocusedStack);
        }
    }

    public void dumpStacks(PrintWriter pw) {
        for (int i = this.mStacks.size() - 1; i >= 0; --i) {
            pw.print(this.mStacks.get((int)i).mStackId);
            if (i <= 0) continue;
            pw.print(",");
        }
    }

    @Override
    public void writeToProto(ProtoOutputStream proto, long fieldId, int logLevel) {
        long token = proto.start(fieldId);
        super.writeToProto(proto, 0x10B00000001L, logLevel);
        proto.write(1120986464258L, this.mDisplayId);
        proto.write(1133871366150L, this.mSingleTaskInstance);
        ActivityStack focusedStack = this.getFocusedStack();
        if (focusedStack != null) {
            proto.write(1120986464260L, focusedStack.mStackId);
            ActivityRecord focusedActivity = focusedStack.getDisplay().getResumedActivity();
            if (focusedActivity != null) {
                focusedActivity.writeIdentifierToProto(proto, 1146756268037L);
            }
        } else {
            proto.write(1120986464260L, -1);
        }
        for (int stackNdx = this.mStacks.size() - 1; stackNdx >= 0; --stackNdx) {
            ActivityStack stack = this.mStacks.get(stackNdx);
            stack.writeToProto(proto, 2246267895811L, logLevel);
        }
        proto.end(token);
    }

    static interface OnStackOrderChangedListener {
        public void onStackOrderChanged(ActivityStack var1);
    }
}

