/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import android.app.ActivityManager;
import android.app.WindowConfiguration;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.dex.ArtManagerInternal;
import android.content.pm.dex.PackageOptimizationInfo;
import android.metrics.LogMaker;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.SystemClock;
import android.os.Trace;
import android.util.EventLog;
import android.util.Log;
import android.util.SparseArray;
import android.util.SparseIntArray;
import android.util.StatsLog;
import android.util.TimeUtils;
import android.util.proto.ProtoOutputStream;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.logging.MetricsLogger;
import com.android.internal.os.BackgroundThread;
import com.android.internal.os.SomeArgs;
import com.android.server.LocalServices;
import com.android.server.am.MemoryStatUtil;
import com.android.server.wm.ActivityMetricsLaunchObserverRegistry;
import com.android.server.wm.ActivityRecord;
import com.android.server.wm.ActivityStack;
import com.android.server.wm.ActivityStackSupervisor;
import com.android.server.wm.LaunchObserverRegistryImpl;
import com.android.server.wm.TaskRecord;
import com.android.server.wm.WindowManagerGlobalLock;
import com.android.server.wm.WindowManagerService;
import com.android.server.wm.WindowProcessController;

class ActivityMetricsLogger {
    private static final String TAG = "ActivityTaskManager";
    private static final int WINDOW_STATE_STANDARD = 0;
    private static final int WINDOW_STATE_SIDE_BY_SIDE = 1;
    private static final int WINDOW_STATE_FREEFORM = 2;
    private static final int WINDOW_STATE_ASSISTANT = 3;
    private static final int WINDOW_STATE_INVALID = -1;
    private static final long INVALID_START_TIME = -1L;
    private static final int INVALID_DELAY = -1;
    private static final int INVALID_TRANSITION_TYPE = -1;
    private static final int MSG_CHECK_VISIBILITY = 0;
    private static final String[] TRON_WINDOW_STATE_VARZ_STRINGS = new String[]{"window_time_0", "window_time_1", "window_time_2", "window_time_3"};
    private int mWindowState = 0;
    private long mLastLogTimeSecs;
    private final ActivityStackSupervisor mSupervisor;
    private final Context mContext;
    private final MetricsLogger mMetricsLogger = new MetricsLogger();
    private long mCurrentTransitionStartTime = -1L;
    private long mLastTransitionStartTime = -1L;
    private int mCurrentTransitionDeviceUptime;
    private int mCurrentTransitionDelayMs;
    private boolean mLoggedTransitionStarting;
    private final SparseArray<WindowingModeTransitionInfo> mWindowingModeTransitionInfo = new SparseArray();
    private final SparseArray<WindowingModeTransitionInfo> mLastWindowingModeTransitionInfo = new SparseArray();
    private final H mHandler;
    private ArtManagerInternal mArtManagerInternal;
    private final StringBuilder mStringBuilder = new StringBuilder();
    private final LaunchObserverRegistryImpl mLaunchObserver;
    @VisibleForTesting
    static final int LAUNCH_OBSERVER_ACTIVITY_RECORD_PROTO_CHUNK_SIZE = 512;

    ActivityMetricsLogger(ActivityStackSupervisor supervisor, Context context, Looper looper) {
        this.mLastLogTimeSecs = SystemClock.elapsedRealtime() / 1000L;
        this.mSupervisor = supervisor;
        this.mContext = context;
        this.mHandler = new H(looper);
        this.mLaunchObserver = new LaunchObserverRegistryImpl(looper);
    }

    void logWindowState() {
        long now = SystemClock.elapsedRealtime() / 1000L;
        if (this.mWindowState != -1) {
            MetricsLogger.count(this.mContext, TRON_WINDOW_STATE_VARZ_STRINGS[this.mWindowState], (int)(now - this.mLastLogTimeSecs));
        }
        this.mLastLogTimeSecs = now;
        this.mWindowState = -1;
        ActivityStack stack = this.mSupervisor.mRootActivityContainer.getTopDisplayFocusedStack();
        if (stack == null) {
            return;
        }
        if (stack.isActivityTypeAssistant()) {
            this.mWindowState = 3;
            return;
        }
        int windowingMode = stack.getWindowingMode();
        if (windowingMode == 2) {
            stack = this.mSupervisor.mRootActivityContainer.findStackBehind(stack);
            windowingMode = stack.getWindowingMode();
        }
        switch (windowingMode) {
            case 1: {
                this.mWindowState = 0;
                break;
            }
            case 3: 
            case 4: {
                this.mWindowState = 1;
                break;
            }
            case 5: {
                this.mWindowState = 2;
                break;
            }
            default: {
                if (windowingMode == 0) break;
                throw new IllegalStateException("Unknown windowing mode for stack=" + stack + " windowingMode=" + windowingMode);
            }
        }
    }

    void notifyActivityLaunching(Intent intent) {
        if (this.mCurrentTransitionStartTime == -1L) {
            this.mLastTransitionStartTime = this.mCurrentTransitionStartTime = SystemClock.uptimeMillis();
            this.launchObserverNotifyIntentStarted(intent);
        }
    }

    void notifyActivityLaunched(int resultCode, ActivityRecord launchedActivity) {
        WindowProcessController processRecord = this.findProcessForActivity(launchedActivity);
        boolean processRunning = processRecord != null;
        boolean processSwitch = processRecord == null || !processRecord.hasStartedActivity(launchedActivity);
        this.notifyActivityLaunched(resultCode, launchedActivity, processRunning, processSwitch);
    }

    private void notifyActivityLaunched(int resultCode, ActivityRecord launchedActivity, boolean processRunning, boolean processSwitch) {
        boolean otherWindowModesLaunching;
        int windowingMode = launchedActivity != null ? launchedActivity.getWindowingMode() : 0;
        WindowingModeTransitionInfo info = this.mWindowingModeTransitionInfo.get(windowingMode);
        if (this.mCurrentTransitionStartTime == -1L) {
            return;
        }
        if (launchedActivity != null && launchedActivity.mDrawn) {
            this.reset(true, info, "launched activity already visible");
            return;
        }
        if (launchedActivity != null && info != null) {
            info.launchedActivity = launchedActivity;
            return;
        }
        boolean bl = otherWindowModesLaunching = this.mWindowingModeTransitionInfo.size() > 0 && info == null;
        if (!(this.isLoggableResultCode(resultCode) && launchedActivity != null && processSwitch && windowingMode != 0 || otherWindowModesLaunching)) {
            this.reset(true, info, "failed to launch or not a process switch");
            return;
        }
        if (otherWindowModesLaunching) {
            return;
        }
        WindowingModeTransitionInfo newInfo = new WindowingModeTransitionInfo();
        newInfo.launchedActivity = launchedActivity;
        newInfo.currentTransitionProcessRunning = processRunning;
        newInfo.startResult = resultCode;
        this.mWindowingModeTransitionInfo.put(windowingMode, newInfo);
        this.mLastWindowingModeTransitionInfo.put(windowingMode, newInfo);
        this.mCurrentTransitionDeviceUptime = (int)(SystemClock.uptimeMillis() / 1000L);
        this.startTraces(newInfo);
        this.launchObserverNotifyActivityLaunched(newInfo);
    }

    private boolean isLoggableResultCode(int resultCode) {
        return resultCode == 0 || resultCode == 2;
    }

    WindowingModeTransitionInfoSnapshot notifyWindowsDrawn(@WindowConfiguration.WindowingMode int windowingMode, long timestamp) {
        WindowingModeTransitionInfo info = this.mWindowingModeTransitionInfo.get(windowingMode);
        if (info == null || info.loggedWindowsDrawn) {
            return null;
        }
        info.windowsDrawnDelayMs = this.calculateDelay(timestamp);
        info.loggedWindowsDrawn = true;
        WindowingModeTransitionInfoSnapshot infoSnapshot = new WindowingModeTransitionInfoSnapshot(info);
        if (this.allWindowsDrawn() && this.mLoggedTransitionStarting) {
            this.reset(false, info, "notifyWindowsDrawn - all windows drawn");
        }
        return infoSnapshot;
    }

    void notifyStartingWindowDrawn(@WindowConfiguration.WindowingMode int windowingMode, long timestamp) {
        WindowingModeTransitionInfo info = this.mWindowingModeTransitionInfo.get(windowingMode);
        if (info == null || info.loggedStartingWindowDrawn) {
            return;
        }
        info.loggedStartingWindowDrawn = true;
        info.startingWindowDelayMs = this.calculateDelay(timestamp);
    }

    void notifyTransitionStarting(SparseIntArray windowingModeToReason, long timestamp) {
        if (!this.isAnyTransitionActive() || this.mLoggedTransitionStarting) {
            return;
        }
        this.mCurrentTransitionDelayMs = this.calculateDelay(timestamp);
        this.mLoggedTransitionStarting = true;
        WindowingModeTransitionInfo foundInfo = null;
        for (int index = windowingModeToReason.size() - 1; index >= 0; --index) {
            int windowingMode = windowingModeToReason.keyAt(index);
            WindowingModeTransitionInfo info = this.mWindowingModeTransitionInfo.get(windowingMode);
            if (info == null) continue;
            info.reason = windowingModeToReason.valueAt(index);
            foundInfo = info;
        }
        if (this.allWindowsDrawn()) {
            boolean abortMetrics = foundInfo == null;
            this.reset(abortMetrics, foundInfo, "notifyTransitionStarting - all windows drawn");
        }
    }

    void notifyVisibilityChanged(ActivityRecord activityRecord) {
        WindowingModeTransitionInfo info = this.mWindowingModeTransitionInfo.get(activityRecord.getWindowingMode());
        if (info == null) {
            return;
        }
        if (info.launchedActivity != activityRecord) {
            return;
        }
        TaskRecord t = activityRecord.getTaskRecord();
        SomeArgs args = SomeArgs.obtain();
        args.arg1 = t;
        args.arg2 = activityRecord;
        this.mHandler.obtainMessage(0, args).sendToTarget();
    }

    private boolean hasVisibleNonFinishingActivity(TaskRecord t) {
        for (int i = t.mActivities.size() - 1; i >= 0; --i) {
            ActivityRecord r = t.mActivities.get(i);
            if (!r.visible || r.finishing) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void checkVisibility(TaskRecord t, ActivityRecord r) {
        WindowingModeTransitionInfo info;
        block9: {
            block8: {
                block7: {
                    WindowManagerGlobalLock windowManagerGlobalLock = this.mSupervisor.mService.mGlobalLock;
                    // MONITORENTER : windowManagerGlobalLock
                    try {
                        WindowManagerService.boostPriorityForLockedSection();
                        info = this.mWindowingModeTransitionInfo.get(r.getWindowingMode());
                        if (info != null) break block7;
                        // MONITOREXIT : windowManagerGlobalLock
                    }
                    catch (Throwable throwable) {
                        // MONITOREXIT : windowManagerGlobalLock
                        WindowManagerService.resetPriorityAfterLockedSection();
                        throw throwable;
                    }
                    WindowManagerService.resetPriorityAfterLockedSection();
                    return;
                }
                if (info.launchedActivity == r) break block8;
                // MONITOREXIT : windowManagerGlobalLock
                WindowManagerService.resetPriorityAfterLockedSection();
                return;
            }
            if (!this.hasVisibleNonFinishingActivity(t)) break block9;
            // MONITOREXIT : windowManagerGlobalLock
            WindowManagerService.resetPriorityAfterLockedSection();
            return;
        }
        this.logAppTransitionCancel(info);
        this.mWindowingModeTransitionInfo.remove(r.getWindowingMode());
        if (this.mWindowingModeTransitionInfo.size() == 0) {
            this.reset(true, info, "notifyVisibilityChanged to invisible");
        }
        // MONITOREXIT : windowManagerGlobalLock
        WindowManagerService.resetPriorityAfterLockedSection();
    }

    void notifyBindApplication(ApplicationInfo appInfo) {
        for (int i = this.mWindowingModeTransitionInfo.size() - 1; i >= 0; --i) {
            WindowingModeTransitionInfo info = this.mWindowingModeTransitionInfo.valueAt(i);
            if (((WindowingModeTransitionInfo)info).launchedActivity.appInfo != appInfo) continue;
            info.bindApplicationDelayMs = this.calculateCurrentDelay();
        }
    }

    private boolean allWindowsDrawn() {
        for (int index = this.mWindowingModeTransitionInfo.size() - 1; index >= 0; --index) {
            if (this.mWindowingModeTransitionInfo.valueAt(index).loggedWindowsDrawn) continue;
            return false;
        }
        return true;
    }

    private boolean isAnyTransitionActive() {
        return this.mCurrentTransitionStartTime != -1L && this.mWindowingModeTransitionInfo.size() > 0;
    }

    private void reset(boolean abort, WindowingModeTransitionInfo info, String cause) {
        if (!abort && this.isAnyTransitionActive()) {
            this.logAppTransitionMultiEvents();
        }
        this.stopLaunchTrace(info);
        if (this.isAnyTransitionActive()) {
            if (abort) {
                this.launchObserverNotifyActivityLaunchCancelled(info);
            } else {
                this.launchObserverNotifyActivityLaunchFinished(info);
            }
        } else {
            this.launchObserverNotifyIntentFailed();
        }
        this.mCurrentTransitionStartTime = -1L;
        this.mCurrentTransitionDelayMs = -1;
        this.mLoggedTransitionStarting = false;
        this.mWindowingModeTransitionInfo.clear();
    }

    private int calculateCurrentDelay() {
        return (int)(SystemClock.uptimeMillis() - this.mCurrentTransitionStartTime);
    }

    private int calculateDelay(long timestamp) {
        return (int)(timestamp - this.mCurrentTransitionStartTime);
    }

    private void logAppTransitionCancel(WindowingModeTransitionInfo info) {
        int type = this.getTransitionType(info);
        if (type == -1) {
            return;
        }
        LogMaker builder = new LogMaker(1144);
        builder.setPackageName(((WindowingModeTransitionInfo)info).launchedActivity.packageName);
        builder.setType(type);
        builder.addTaggedData(871, ((WindowingModeTransitionInfo)info).launchedActivity.info.name);
        this.mMetricsLogger.write(builder);
        StatsLog.write(49, ((WindowingModeTransitionInfo)info).launchedActivity.appInfo.uid, ((WindowingModeTransitionInfo)info).launchedActivity.packageName, this.convertAppStartTransitionType(type), ((WindowingModeTransitionInfo)info).launchedActivity.info.name);
    }

    private void logAppTransitionMultiEvents() {
        for (int index = this.mWindowingModeTransitionInfo.size() - 1; index >= 0; --index) {
            WindowingModeTransitionInfo info = this.mWindowingModeTransitionInfo.valueAt(index);
            int type = this.getTransitionType(info);
            if (type == -1) {
                return;
            }
            WindowingModeTransitionInfoSnapshot infoSnapshot = new WindowingModeTransitionInfoSnapshot(info);
            int currentTransitionDeviceUptime = this.mCurrentTransitionDeviceUptime;
            int currentTransitionDelayMs = this.mCurrentTransitionDelayMs;
            BackgroundThread.getHandler().post(() -> this.logAppTransition(currentTransitionDeviceUptime, currentTransitionDelayMs, infoSnapshot));
            BackgroundThread.getHandler().post(() -> this.logAppDisplayed(infoSnapshot));
            ((WindowingModeTransitionInfo)info).launchedActivity.info.launchToken = null;
        }
    }

    private void logAppTransition(int currentTransitionDeviceUptime, int currentTransitionDelayMs, WindowingModeTransitionInfoSnapshot info) {
        String launchToken;
        LogMaker builder = new LogMaker(761);
        builder.setPackageName(info.packageName);
        builder.setType(info.type);
        builder.addTaggedData(871, info.launchedActivityName);
        boolean isInstantApp = info.applicationInfo.isInstantApp();
        if (info.launchedActivityLaunchedFromPackage != null) {
            builder.addTaggedData(904, info.launchedActivityLaunchedFromPackage);
        }
        if ((launchToken = info.launchedActivityLaunchToken) != null) {
            builder.addTaggedData(903, launchToken);
        }
        builder.addTaggedData(905, isInstantApp ? 1 : 0);
        builder.addTaggedData(325, currentTransitionDeviceUptime);
        builder.addTaggedData(319, currentTransitionDelayMs);
        builder.setSubtype(info.reason);
        if (info.startingWindowDelayMs != -1) {
            builder.addTaggedData(321, info.startingWindowDelayMs);
        }
        if (info.bindApplicationDelayMs != -1) {
            builder.addTaggedData(945, info.bindApplicationDelayMs);
        }
        builder.addTaggedData(322, info.windowsDrawnDelayMs);
        ArtManagerInternal artManagerInternal = this.getArtManagerInternal();
        PackageOptimizationInfo packageOptimizationInfo = artManagerInternal == null || info.launchedActivityAppRecordRequiredAbi == null ? PackageOptimizationInfo.createWithNoInfo() : artManagerInternal.getPackageOptimizationInfo(info.applicationInfo, info.launchedActivityAppRecordRequiredAbi);
        builder.addTaggedData(1321, packageOptimizationInfo.getCompilationReason());
        builder.addTaggedData(1320, packageOptimizationInfo.getCompilationFilter());
        this.mMetricsLogger.write(builder);
        StatsLog.write(48, ((WindowingModeTransitionInfoSnapshot)info).applicationInfo.uid, info.packageName, this.convertAppStartTransitionType(info.type), info.launchedActivityName, info.launchedActivityLaunchedFromPackage, isInstantApp, (long)(currentTransitionDeviceUptime * 1000), info.reason, currentTransitionDelayMs, info.startingWindowDelayMs, info.bindApplicationDelayMs, info.windowsDrawnDelayMs, launchToken, packageOptimizationInfo.getCompilationReason(), packageOptimizationInfo.getCompilationFilter());
        this.logAppStartMemoryStateCapture(info);
    }

    private void logAppDisplayed(WindowingModeTransitionInfoSnapshot info) {
        if (info.type != 8 && info.type != 7) {
            return;
        }
        EventLog.writeEvent(30009, info.userId, info.activityRecordIdHashCode, info.launchedActivityShortComponentName, info.windowsDrawnDelayMs);
        StringBuilder sb = this.mStringBuilder;
        sb.setLength(0);
        sb.append("Displayed ");
        sb.append(info.launchedActivityShortComponentName);
        sb.append(": ");
        TimeUtils.formatDuration((long)info.windowsDrawnDelayMs, sb);
        Log.i(TAG, sb.toString());
    }

    private int convertAppStartTransitionType(int tronType) {
        if (tronType == 7) {
            return 3;
        }
        if (tronType == 8) {
            return 1;
        }
        if (tronType == 9) {
            return 2;
        }
        return 0;
    }

    WindowingModeTransitionInfoSnapshot logAppTransitionReportedDrawn(ActivityRecord r, boolean restoredFromBundle) {
        WindowingModeTransitionInfo info = this.mLastWindowingModeTransitionInfo.get(r.getWindowingMode());
        if (info == null) {
            return null;
        }
        Trace.traceBegin(64L, "ActivityManager:ReportingFullyDrawn " + ((WindowingModeTransitionInfo)info).launchedActivity.packageName);
        LogMaker builder = new LogMaker(1090);
        builder.setPackageName(r.packageName);
        builder.addTaggedData(871, r.info.name);
        long startupTimeMs = SystemClock.uptimeMillis() - this.mLastTransitionStartTime;
        builder.addTaggedData(1091, startupTimeMs);
        builder.setType(restoredFromBundle ? 13 : 12);
        builder.addTaggedData(324, info.currentTransitionProcessRunning ? 1 : 0);
        this.mMetricsLogger.write(builder);
        StatsLog.write(50, ((WindowingModeTransitionInfo)info).launchedActivity.appInfo.uid, ((WindowingModeTransitionInfo)info).launchedActivity.packageName, restoredFromBundle ? 1 : 2, ((WindowingModeTransitionInfo)info).launchedActivity.info.name, info.currentTransitionProcessRunning, startupTimeMs);
        Trace.traceEnd(64L);
        WindowingModeTransitionInfoSnapshot infoSnapshot = new WindowingModeTransitionInfoSnapshot(info, r, (int)startupTimeMs);
        BackgroundThread.getHandler().post(() -> this.logAppFullyDrawn(infoSnapshot));
        return infoSnapshot;
    }

    private void logAppFullyDrawn(WindowingModeTransitionInfoSnapshot info) {
        if (info.type != 8 && info.type != 7) {
            return;
        }
        StringBuilder sb = this.mStringBuilder;
        sb.setLength(0);
        sb.append("Fully drawn ");
        sb.append(info.launchedActivityShortComponentName);
        sb.append(": ");
        TimeUtils.formatDuration((long)info.windowsFullyDrawnDelayMs, sb);
        Log.i(TAG, sb.toString());
    }

    void logAbortedBgActivityStart(Intent intent, WindowProcessController callerApp, int callingUid, String callingPackage, int callingUidProcState, boolean callingUidHasAnyVisibleWindow, int realCallingUid, int realCallingUidProcState, boolean realCallingUidHasAnyVisibleWindow, boolean comingFromPendingIntent) {
        long nowElapsed = SystemClock.elapsedRealtime();
        long nowUptime = SystemClock.uptimeMillis();
        LogMaker builder = new LogMaker(1513);
        builder.setTimestamp(System.currentTimeMillis());
        builder.addTaggedData(1514, callingUid);
        builder.addTaggedData(1515, callingPackage);
        builder.addTaggedData(1516, ActivityManager.processStateAmToProto(callingUidProcState));
        builder.addTaggedData(1517, callingUidHasAnyVisibleWindow ? 1 : 0);
        builder.addTaggedData(1518, realCallingUid);
        builder.addTaggedData(1519, ActivityManager.processStateAmToProto(realCallingUidProcState));
        builder.addTaggedData(1520, realCallingUidHasAnyVisibleWindow ? 1 : 0);
        builder.addTaggedData(1527, comingFromPendingIntent ? 1 : 0);
        if (intent != null) {
            builder.addTaggedData(1528, intent.getAction());
            ComponentName component = intent.getComponent();
            if (component != null) {
                builder.addTaggedData(1526, component.flattenToShortString());
            }
        }
        if (callerApp != null) {
            builder.addTaggedData(1529, callerApp.mName);
            builder.addTaggedData(1530, ActivityManager.processStateAmToProto(callerApp.getCurrentProcState()));
            builder.addTaggedData(1531, callerApp.hasClientActivities() ? 1 : 0);
            builder.addTaggedData(1532, callerApp.hasForegroundServices() ? 1 : 0);
            builder.addTaggedData(1533, callerApp.hasForegroundActivities() ? 1 : 0);
            builder.addTaggedData(1534, callerApp.hasTopUi() ? 1 : 0);
            builder.addTaggedData(1535, callerApp.hasOverlayUi() ? 1 : 0);
            builder.addTaggedData(1536, callerApp.hasPendingUiClean() ? 1 : 0);
            if (callerApp.getInteractionEventTime() != 0L) {
                builder.addTaggedData(1537, nowElapsed - callerApp.getInteractionEventTime());
            }
            if (callerApp.getFgInteractionTime() != 0L) {
                builder.addTaggedData(1538, nowElapsed - callerApp.getFgInteractionTime());
            }
            if (callerApp.getWhenUnimportant() != 0L) {
                builder.addTaggedData(1539, nowUptime - callerApp.getWhenUnimportant());
            }
        }
        this.mMetricsLogger.write(builder);
    }

    private int getTransitionType(WindowingModeTransitionInfo info) {
        if (info.currentTransitionProcessRunning) {
            if (info.startResult == 0) {
                return 8;
            }
            if (info.startResult == 2) {
                return 9;
            }
        } else if (info.startResult == 0 || info.startResult == 2) {
            return 7;
        }
        return -1;
    }

    private void logAppStartMemoryStateCapture(WindowingModeTransitionInfoSnapshot info) {
        if (info.processRecord == null) {
            return;
        }
        int uid = ((WindowingModeTransitionInfoSnapshot)info).applicationInfo.uid;
        int pid = info.processRecord.getPid();
        MemoryStatUtil.MemoryStat memoryStat = MemoryStatUtil.readMemoryStatFromFilesystem(uid, pid);
        if (memoryStat == null) {
            return;
        }
        StatsLog.write(55, uid, info.processName, info.launchedActivityName, memoryStat.pgfault, memoryStat.pgmajfault, memoryStat.rssInBytes, memoryStat.cacheInBytes, memoryStat.swapInBytes);
    }

    private WindowProcessController findProcessForActivity(ActivityRecord launchedActivity) {
        return launchedActivity != null ? this.mSupervisor.mService.mProcessNames.get(launchedActivity.processName, launchedActivity.appInfo.uid) : null;
    }

    private ArtManagerInternal getArtManagerInternal() {
        if (this.mArtManagerInternal == null) {
            this.mArtManagerInternal = LocalServices.getService(ArtManagerInternal.class);
        }
        return this.mArtManagerInternal;
    }

    private void startTraces(WindowingModeTransitionInfo info) {
        if (!Trace.isTagEnabled(64L) || info == null || info.launchTraceActive) {
            return;
        }
        Trace.asyncTraceBegin(64L, "launching: " + ((WindowingModeTransitionInfo)info).launchedActivity.packageName, 0);
        info.launchTraceActive = true;
    }

    private void stopLaunchTrace(WindowingModeTransitionInfo info) {
        if (info == null) {
            return;
        }
        if (info.launchTraceActive) {
            Trace.asyncTraceEnd(64L, "launching: " + ((WindowingModeTransitionInfo)info).launchedActivity.packageName, 0);
            info.launchTraceActive = false;
        }
    }

    public ActivityMetricsLaunchObserverRegistry getLaunchObserverRegistry() {
        return this.mLaunchObserver;
    }

    private void launchObserverNotifyIntentStarted(Intent intent) {
        Trace.traceBegin(64L, "MetricsLogger:launchObserverNotifyIntentStarted");
        this.mLaunchObserver.onIntentStarted(intent);
        Trace.traceEnd(64L);
    }

    private void launchObserverNotifyIntentFailed() {
        Trace.traceBegin(64L, "MetricsLogger:launchObserverNotifyIntentFailed");
        this.mLaunchObserver.onIntentFailed();
        Trace.traceEnd(64L);
    }

    private void launchObserverNotifyActivityLaunched(WindowingModeTransitionInfo info) {
        Trace.traceBegin(64L, "MetricsLogger:launchObserverNotifyActivityLaunched");
        int temperature = ActivityMetricsLogger.convertTransitionTypeToLaunchObserverTemperature(this.getTransitionType(info));
        this.mLaunchObserver.onActivityLaunched(ActivityMetricsLogger.convertActivityRecordToProto(info.launchedActivity), temperature);
        Trace.traceEnd(64L);
    }

    private void launchObserverNotifyActivityLaunchCancelled(WindowingModeTransitionInfo info) {
        Trace.traceBegin(64L, "MetricsLogger:launchObserverNotifyActivityLaunchCancelled");
        byte[] activityRecordProto = info != null ? ActivityMetricsLogger.convertActivityRecordToProto(info.launchedActivity) : null;
        this.mLaunchObserver.onActivityLaunchCancelled(activityRecordProto);
        Trace.traceEnd(64L);
    }

    private void launchObserverNotifyActivityLaunchFinished(WindowingModeTransitionInfo info) {
        Trace.traceBegin(64L, "MetricsLogger:launchObserverNotifyActivityLaunchFinished");
        this.mLaunchObserver.onActivityLaunchFinished(ActivityMetricsLogger.convertActivityRecordToProto(info.launchedActivity));
        Trace.traceEnd(64L);
    }

    @VisibleForTesting
    static byte[] convertActivityRecordToProto(ActivityRecord record) {
        Trace.traceBegin(64L, "MetricsLogger:convertActivityRecordToProto");
        ProtoOutputStream protoOutputStream = new ProtoOutputStream(512);
        record.writeToProto(protoOutputStream);
        byte[] bytes = protoOutputStream.getBytes();
        Trace.traceEnd(64L);
        return bytes;
    }

    private static int convertTransitionTypeToLaunchObserverTemperature(int transitionType) {
        switch (transitionType) {
            case 8: {
                return 2;
            }
            case 9: {
                return 3;
            }
            case 7: {
                return 1;
            }
        }
        return -1;
    }

    final class WindowingModeTransitionInfoSnapshot {
        private final ApplicationInfo applicationInfo;
        private final WindowProcessController processRecord;
        final String packageName;
        final String launchedActivityName;
        private final String launchedActivityLaunchedFromPackage;
        private final String launchedActivityLaunchToken;
        private final String launchedActivityAppRecordRequiredAbi;
        final String launchedActivityShortComponentName;
        private final String processName;
        private final int reason;
        private final int startingWindowDelayMs;
        private final int bindApplicationDelayMs;
        final int windowsDrawnDelayMs;
        final int type;
        final int userId;
        final int windowsFullyDrawnDelayMs;
        final int activityRecordIdHashCode;

        private WindowingModeTransitionInfoSnapshot(WindowingModeTransitionInfo info) {
            this(info, info.launchedActivity);
        }

        private WindowingModeTransitionInfoSnapshot(WindowingModeTransitionInfo info, ActivityRecord launchedActivity) {
            this(info, launchedActivity, -1);
        }

        private WindowingModeTransitionInfoSnapshot(WindowingModeTransitionInfo info, ActivityRecord launchedActivity, int windowsFullyDrawnDelayMs) {
            this.applicationInfo = launchedActivity.appInfo;
            this.packageName = launchedActivity.packageName;
            this.launchedActivityName = launchedActivity.info.name;
            this.launchedActivityLaunchedFromPackage = launchedActivity.launchedFromPackage;
            this.launchedActivityLaunchToken = launchedActivity.info.launchToken;
            this.launchedActivityAppRecordRequiredAbi = launchedActivity.app == null ? null : launchedActivity.app.getRequiredAbi();
            this.reason = info.reason;
            this.startingWindowDelayMs = info.startingWindowDelayMs;
            this.bindApplicationDelayMs = info.bindApplicationDelayMs;
            this.windowsDrawnDelayMs = info.windowsDrawnDelayMs;
            this.type = ActivityMetricsLogger.this.getTransitionType(info);
            this.processRecord = ActivityMetricsLogger.this.findProcessForActivity(launchedActivity);
            this.processName = launchedActivity.processName;
            this.userId = launchedActivity.mUserId;
            this.launchedActivityShortComponentName = launchedActivity.shortComponentName;
            this.activityRecordIdHashCode = System.identityHashCode(launchedActivity);
            this.windowsFullyDrawnDelayMs = windowsFullyDrawnDelayMs;
        }

        int getLaunchState() {
            switch (this.type) {
                case 8: {
                    return 2;
                }
                case 9: {
                    return 3;
                }
                case 7: {
                    return 1;
                }
            }
            return -1;
        }
    }

    private final class WindowingModeTransitionInfo {
        private ActivityRecord launchedActivity;
        private int startResult;
        private boolean currentTransitionProcessRunning;
        private int windowsDrawnDelayMs;
        private int startingWindowDelayMs = -1;
        private int bindApplicationDelayMs = -1;
        private int reason = 3;
        private boolean loggedWindowsDrawn;
        private boolean loggedStartingWindowDrawn;
        private boolean launchTraceActive;

        private WindowingModeTransitionInfo() {
        }
    }

    private final class H
    extends Handler {
        public H(Looper looper) {
            super(looper);
        }

        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 0: {
                    SomeArgs args = (SomeArgs)msg.obj;
                    ActivityMetricsLogger.this.checkVisibility((TaskRecord)args.arg1, (ActivityRecord)args.arg2);
                }
            }
        }
    }
}

