/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import android.app.ActivityManager;
import android.app.ActivityOptions;
import android.app.PendingIntent;
import android.app.PictureInPictureParams;
import android.app.ResultInfo;
import android.app.WindowConfiguration;
import android.app.servertransaction.ActivityConfigurationChangeItem;
import android.app.servertransaction.ActivityLifecycleItem;
import android.app.servertransaction.ActivityRelaunchItem;
import android.app.servertransaction.ClientTransaction;
import android.app.servertransaction.MoveToDisplayItem;
import android.app.servertransaction.MultiWindowModeChangeItem;
import android.app.servertransaction.NewIntentItem;
import android.app.servertransaction.PauseActivityItem;
import android.app.servertransaction.PipModeChangeItem;
import android.app.servertransaction.ResumeActivityItem;
import android.app.servertransaction.StopActivityItem;
import android.app.servertransaction.TopResumedActivityChangeItem;
import android.app.servertransaction.WindowVisibilityItem;
import android.content.ComponentName;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.ApplicationInfo;
import android.content.res.CompatibilityInfo;
import android.content.res.Configuration;
import android.graphics.Bitmap;
import android.graphics.GraphicBuffer;
import android.graphics.Rect;
import android.os.Binder;
import android.os.Build;
import android.os.Bundle;
import android.os.IBinder;
import android.os.Message;
import android.os.PersistableBundle;
import android.os.Process;
import android.os.RemoteException;
import android.os.SystemClock;
import android.os.UserHandle;
import android.os.storage.StorageManager;
import android.service.voice.IVoiceInteractionSession;
import android.util.EventLog;
import android.util.Log;
import android.util.MergedConfiguration;
import android.util.Slog;
import android.util.TimeUtils;
import android.util.proto.ProtoOutputStream;
import android.view.AppTransitionAnimationSpec;
import android.view.DisplayCutout;
import android.view.IAppTransitionAnimationSpecsFuture;
import android.view.IApplicationToken;
import android.view.RemoteAnimationDefinition;
import com.android.internal.R;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.app.ResolverActivity;
import com.android.internal.content.ReferrerIntent;
import com.android.internal.util.XmlUtils;
import com.android.server.AttributeCache;
import com.android.server.am.AppTimeTracker;
import com.android.server.am.PendingIntentRecord;
import com.android.server.uri.UriPermissionOwner;
import com.android.server.wm.ActivityDisplay;
import com.android.server.wm.ActivityMetricsLogger;
import com.android.server.wm.ActivityResult;
import com.android.server.wm.ActivityServiceConnectionsHolder;
import com.android.server.wm.ActivityStack;
import com.android.server.wm.ActivityStackSupervisor;
import com.android.server.wm.ActivityTaskManagerService;
import com.android.server.wm.AppWindowToken;
import com.android.server.wm.ConfigurationContainer;
import com.android.server.wm.DisplayContent;
import com.android.server.wm.DisplayPolicy;
import com.android.server.wm.RecentTasks;
import com.android.server.wm.RootActivityContainer;
import com.android.server.wm.Task;
import com.android.server.wm.TaskPersister;
import com.android.server.wm.TaskRecord;
import com.android.server.wm.WindowManagerGlobalLock;
import com.android.server.wm.WindowManagerService;
import com.android.server.wm.WindowProcessController;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

final class ActivityRecord
extends ConfigurationContainer {
    private static final String TAG = "ActivityTaskManager";
    private static final String TAG_CONFIGURATION = "ActivityTaskManager";
    private static final String TAG_SAVED_STATE = "ActivityTaskManager";
    private static final String TAG_STATES = "ActivityTaskManager";
    private static final String TAG_SWITCH = "ActivityTaskManager";
    private static final String TAG_VISIBILITY = "ActivityTaskManager";
    private static final String TAG_FOCUS = "ActivityTaskManager";
    private static final String LEGACY_RECENTS_PACKAGE_NAME = "com.android.systemui.recents";
    private static final boolean SHOW_ACTIVITY_START_TIME = true;
    private static final String ATTR_ID = "id";
    private static final String TAG_INTENT = "intent";
    private static final String ATTR_USERID = "user_id";
    private static final String TAG_PERSISTABLEBUNDLE = "persistable_bundle";
    private static final String ATTR_LAUNCHEDFROMUID = "launched_from_uid";
    private static final String ATTR_LAUNCHEDFROMPACKAGE = "launched_from_package";
    private static final String ATTR_RESOLVEDTYPE = "resolved_type";
    private static final String ATTR_COMPONENTSPECIFIED = "component_specified";
    static final String ACTIVITY_ICON_SUFFIX = "_activity_icon_";
    final ActivityTaskManagerService mAtmService;
    final IApplicationToken.Stub appToken;
    AppWindowToken mAppWindowToken;
    final ActivityInfo info;
    ApplicationInfo appInfo;
    final int launchedFromPid;
    final int launchedFromUid;
    final String launchedFromPackage;
    final int mUserId;
    final Intent intent;
    final ComponentName mActivityComponent;
    final String shortComponentName;
    final String resolvedType;
    final String packageName;
    final String processName;
    final String taskAffinity;
    final boolean stateNotNeeded;
    boolean fullscreen;
    final boolean hasWallpaper;
    @VisibleForTesting
    boolean noDisplay;
    @VisibleForTesting
    int mHandoverLaunchDisplayId = -1;
    private final boolean componentSpecified;
    final boolean rootVoiceInteraction;
    private CharSequence nonLocalizedLabel;
    private int labelRes;
    private int icon;
    private int logo;
    private int theme;
    private int realTheme;
    private int windowFlags;
    private TaskRecord task;
    private long createTime = System.currentTimeMillis();
    long lastVisibleTime;
    long cpuTimeAtResume;
    long pauseTime;
    long launchTickTime;
    long topResumedStateLossTime;
    private MergedConfiguration mLastReportedConfiguration;
    private int mLastReportedDisplayId;
    private boolean mLastReportedMultiWindowMode;
    private boolean mLastReportedPictureInPictureMode;
    CompatibilityInfo compat;
    ActivityRecord resultTo;
    final String resultWho;
    final int requestCode;
    ArrayList<ResultInfo> results;
    HashSet<WeakReference<PendingIntentRecord>> pendingResults;
    ArrayList<ReferrerIntent> newIntents;
    ActivityOptions pendingOptions;
    ActivityOptions returningOptions;
    AppTimeTracker appTimeTracker;
    ActivityServiceConnectionsHolder mServiceConnectionsHolder;
    UriPermissionOwner uriPermissions;
    WindowProcessController app;
    private ActivityStack.ActivityState mState;
    Bundle icicle;
    PersistableBundle persistentState;
    boolean frontOfTask;
    boolean launchFailed;
    boolean haveState;
    boolean stopped;
    boolean delayedResume;
    boolean finishing;
    boolean deferRelaunchUntilPaused;
    boolean preserveWindowOnDeferredRelaunch;
    int configChangeFlags;
    private boolean keysPaused;
    int launchMode;
    int lockTaskLaunchMode;
    boolean visible;
    boolean visibleIgnoringKeyguard;
    private boolean mDeferHidingClient;
    boolean sleeping;
    boolean nowVisible;
    boolean mDrawn;
    boolean mClientVisibilityDeferred;
    boolean idle;
    boolean hasBeenLaunched;
    boolean frozenBeforeDestroy;
    boolean immersive;
    boolean forceNewConfig;
    boolean supportsEnterPipOnTaskSwitch;
    PictureInPictureParams pictureInPictureArgs = new PictureInPictureParams.Builder().build();
    int launchCount;
    long lastLaunchTime;
    ComponentName requestedVrComponent;
    String stringName;
    private boolean inHistory;
    final ActivityStackSupervisor mStackSupervisor;
    final RootActivityContainer mRootActivityContainer;
    static final int STARTING_WINDOW_NOT_SHOWN = 0;
    static final int STARTING_WINDOW_SHOWN = 1;
    static final int STARTING_WINDOW_REMOVED = 2;
    int mStartingWindowState = 0;
    boolean mTaskOverlay = false;
    int mRelaunchReason = 0;
    ActivityManager.TaskDescription taskDescription;
    boolean mLaunchTaskBehind;
    private int[] mVerticalSizeConfigurations;
    private int[] mHorizontalSizeConfigurations;
    private int[] mSmallestSizeConfigurations;
    private CompatDisplayInsets mCompatDisplayInsets;
    boolean pendingVoiceInteractionStart;
    IVoiceInteractionSession voiceSession;
    int mRotationAnimationHint = -1;
    private boolean mShowWhenLocked;
    private boolean mInheritShownWhenLocked;
    private boolean mTurnScreenOn;
    private int mConfigurationSeq;
    private final Configuration mTmpConfig = new Configuration();
    private final Rect mTmpBounds = new Rect();
    final Binder assistToken = new Binder();

    private static String startingWindowStateToString(int state) {
        switch (state) {
            case 0: {
                return "STARTING_WINDOW_NOT_SHOWN";
            }
            case 1: {
                return "STARTING_WINDOW_SHOWN";
            }
            case 2: {
                return "STARTING_WINDOW_REMOVED";
            }
        }
        return "unknown state=" + state;
    }

    void dump(PrintWriter pw, String prefix) {
        Object iconFilename;
        long now = SystemClock.uptimeMillis();
        pw.print(prefix);
        pw.print("packageName=");
        pw.print(this.packageName);
        pw.print(" processName=");
        pw.println(this.processName);
        pw.print(prefix);
        pw.print("launchedFromUid=");
        pw.print(this.launchedFromUid);
        pw.print(" launchedFromPackage=");
        pw.print(this.launchedFromPackage);
        pw.print(" userId=");
        pw.println(this.mUserId);
        pw.print(prefix);
        pw.print("app=");
        pw.println(this.app);
        pw.print(prefix);
        pw.println(this.intent.toInsecureStringWithClip());
        pw.print(prefix);
        pw.print("frontOfTask=");
        pw.print(this.frontOfTask);
        pw.print(" task=");
        pw.println(this.task);
        pw.print(prefix);
        pw.print("taskAffinity=");
        pw.println(this.taskAffinity);
        pw.print(prefix);
        pw.print("mActivityComponent=");
        pw.println(this.mActivityComponent.flattenToShortString());
        if (this.appInfo != null) {
            pw.print(prefix);
            pw.print("baseDir=");
            pw.println(this.appInfo.sourceDir);
            if (!Objects.equals(this.appInfo.sourceDir, this.appInfo.publicSourceDir)) {
                pw.print(prefix);
                pw.print("resDir=");
                pw.println(this.appInfo.publicSourceDir);
            }
            pw.print(prefix);
            pw.print("dataDir=");
            pw.println(this.appInfo.dataDir);
            if (this.appInfo.splitSourceDirs != null) {
                pw.print(prefix);
                pw.print("splitDir=");
                pw.println(Arrays.toString(this.appInfo.splitSourceDirs));
            }
        }
        pw.print(prefix);
        pw.print("stateNotNeeded=");
        pw.print(this.stateNotNeeded);
        pw.print(" componentSpecified=");
        pw.print(this.componentSpecified);
        pw.print(" mActivityType=");
        pw.println(WindowConfiguration.activityTypeToString(this.getActivityType()));
        if (this.rootVoiceInteraction) {
            pw.print(prefix);
            pw.print("rootVoiceInteraction=");
            pw.println(this.rootVoiceInteraction);
        }
        pw.print(prefix);
        pw.print("compat=");
        pw.print(this.compat);
        pw.print(" labelRes=0x");
        pw.print(Integer.toHexString(this.labelRes));
        pw.print(" icon=0x");
        pw.print(Integer.toHexString(this.icon));
        pw.print(" theme=0x");
        pw.println(Integer.toHexString(this.theme));
        pw.println(prefix + "mLastReportedConfigurations:");
        this.mLastReportedConfiguration.dump(pw, prefix + " ");
        pw.print(prefix);
        pw.print("CurrentConfiguration=");
        pw.println(this.getConfiguration());
        if (!this.getRequestedOverrideConfiguration().equals(Configuration.EMPTY)) {
            pw.println(prefix + "RequestedOverrideConfiguration=" + this.getRequestedOverrideConfiguration());
        }
        if (!this.getResolvedOverrideConfiguration().equals(this.getRequestedOverrideConfiguration())) {
            pw.println(prefix + "ResolvedOverrideConfiguration=" + this.getResolvedOverrideConfiguration());
        }
        if (!this.matchParentBounds()) {
            pw.println(prefix + "bounds=" + this.getBounds());
        }
        if (this.resultTo != null || this.resultWho != null) {
            pw.print(prefix);
            pw.print("resultTo=");
            pw.print(this.resultTo);
            pw.print(" resultWho=");
            pw.print(this.resultWho);
            pw.print(" resultCode=");
            pw.println(this.requestCode);
        }
        if (this.taskDescription != null && ((iconFilename = this.taskDescription.getIconFilename()) != null || this.taskDescription.getLabel() != null || this.taskDescription.getPrimaryColor() != 0)) {
            pw.print(prefix);
            pw.print("taskDescription:");
            pw.print(" label=\"");
            pw.print(this.taskDescription.getLabel());
            pw.print("\"");
            pw.print(" icon=");
            pw.print(this.taskDescription.getInMemoryIcon() != null ? this.taskDescription.getInMemoryIcon().getByteCount() + " bytes" : "null");
            pw.print(" iconResource=");
            pw.print(this.taskDescription.getIconResource());
            pw.print(" iconFilename=");
            pw.print(this.taskDescription.getIconFilename());
            pw.print(" primaryColor=");
            pw.println(Integer.toHexString(this.taskDescription.getPrimaryColor()));
            pw.print(prefix + " backgroundColor=");
            pw.println(Integer.toHexString(this.taskDescription.getBackgroundColor()));
            pw.print(prefix + " statusBarColor=");
            pw.println(Integer.toHexString(this.taskDescription.getStatusBarColor()));
            pw.print(prefix + " navigationBarColor=");
            pw.println(Integer.toHexString(this.taskDescription.getNavigationBarColor()));
        }
        if (this.results != null) {
            pw.print(prefix);
            pw.print("results=");
            pw.println(this.results);
        }
        if (this.pendingResults != null && this.pendingResults.size() > 0) {
            pw.print(prefix);
            pw.println("Pending Results:");
            for (WeakReference weakReference : this.pendingResults) {
                PendingIntentRecord pir = weakReference != null ? (PendingIntentRecord)weakReference.get() : null;
                pw.print(prefix);
                pw.print("  - ");
                if (pir == null) {
                    pw.println("null");
                    continue;
                }
                pw.println(pir);
                pir.dump(pw, prefix + "    ");
            }
        }
        if (this.newIntents != null && this.newIntents.size() > 0) {
            pw.print(prefix);
            pw.println("Pending New Intents:");
            for (int i = 0; i < this.newIntents.size(); ++i) {
                Intent intent = this.newIntents.get(i);
                pw.print(prefix);
                pw.print("  - ");
                if (intent == null) {
                    pw.println("null");
                    continue;
                }
                pw.println(intent.toShortString(false, true, false, true));
            }
        }
        if (this.pendingOptions != null) {
            pw.print(prefix);
            pw.print("pendingOptions=");
            pw.println(this.pendingOptions);
        }
        if (this.appTimeTracker != null) {
            this.appTimeTracker.dumpWithHeader(pw, prefix, false);
        }
        if (this.uriPermissions != null) {
            this.uriPermissions.dump(pw, prefix);
        }
        pw.print(prefix);
        pw.print("launchFailed=");
        pw.print(this.launchFailed);
        pw.print(" launchCount=");
        pw.print(this.launchCount);
        pw.print(" lastLaunchTime=");
        if (this.lastLaunchTime == 0L) {
            pw.print("0");
        } else {
            TimeUtils.formatDuration(this.lastLaunchTime, now, pw);
        }
        pw.println();
        pw.print(prefix);
        pw.print("haveState=");
        pw.print(this.haveState);
        pw.print(" icicle=");
        pw.println(this.icicle);
        pw.print(prefix);
        pw.print("state=");
        pw.print((Object)this.mState);
        pw.print(" stopped=");
        pw.print(this.stopped);
        pw.print(" delayedResume=");
        pw.print(this.delayedResume);
        pw.print(" finishing=");
        pw.println(this.finishing);
        pw.print(prefix);
        pw.print("keysPaused=");
        pw.print(this.keysPaused);
        pw.print(" inHistory=");
        pw.print(this.inHistory);
        pw.print(" visible=");
        pw.print(this.visible);
        pw.print(" sleeping=");
        pw.print(this.sleeping);
        pw.print(" idle=");
        pw.print(this.idle);
        pw.print(" mStartingWindowState=");
        pw.println(ActivityRecord.startingWindowStateToString(this.mStartingWindowState));
        pw.print(prefix);
        pw.print("fullscreen=");
        pw.print(this.fullscreen);
        pw.print(" noDisplay=");
        pw.print(this.noDisplay);
        pw.print(" immersive=");
        pw.print(this.immersive);
        pw.print(" launchMode=");
        pw.println(this.launchMode);
        pw.print(prefix);
        pw.print("frozenBeforeDestroy=");
        pw.print(this.frozenBeforeDestroy);
        pw.print(" forceNewConfig=");
        pw.println(this.forceNewConfig);
        pw.print(prefix);
        pw.print("mActivityType=");
        pw.println(WindowConfiguration.activityTypeToString(this.getActivityType()));
        if (this.requestedVrComponent != null) {
            pw.print(prefix);
            pw.print("requestedVrComponent=");
            pw.println(this.requestedVrComponent);
        }
        if (this.lastVisibleTime != 0L || this.nowVisible) {
            pw.print(prefix);
            pw.print(" nowVisible=");
            pw.print(this.nowVisible);
            pw.print(" lastVisibleTime=");
            if (this.lastVisibleTime == 0L) {
                pw.print("0");
            } else {
                TimeUtils.formatDuration(this.lastVisibleTime, now, pw);
            }
            pw.println();
        }
        if (this.mDeferHidingClient) {
            pw.println(prefix + "mDeferHidingClient=" + this.mDeferHidingClient);
        }
        if (this.deferRelaunchUntilPaused || this.configChangeFlags != 0) {
            pw.print(prefix);
            pw.print("deferRelaunchUntilPaused=");
            pw.print(this.deferRelaunchUntilPaused);
            pw.print(" configChangeFlags=");
            pw.println(Integer.toHexString(this.configChangeFlags));
        }
        if (this.mServiceConnectionsHolder != null) {
            pw.print(prefix);
            pw.print("connections=");
            pw.println(this.mServiceConnectionsHolder);
        }
        if (this.info != null) {
            pw.println(prefix + "resizeMode=" + ActivityInfo.resizeModeToString(this.info.resizeMode));
            pw.println(prefix + "mLastReportedMultiWindowMode=" + this.mLastReportedMultiWindowMode + " mLastReportedPictureInPictureMode=" + this.mLastReportedPictureInPictureMode);
            if (this.info.supportsPictureInPicture()) {
                pw.println(prefix + "supportsPictureInPicture=" + this.info.supportsPictureInPicture());
                pw.println(prefix + "supportsEnterPipOnTaskSwitch: " + this.supportsEnterPipOnTaskSwitch);
            }
            if (this.info.maxAspectRatio != 0.0f) {
                pw.println(prefix + "maxAspectRatio=" + this.info.maxAspectRatio);
            }
            if (this.info.minAspectRatio != 0.0f) {
                pw.println(prefix + "minAspectRatio=" + this.info.minAspectRatio);
            }
        }
    }

    void updateApplicationInfo(ApplicationInfo aInfo) {
        this.appInfo = aInfo;
        this.info.applicationInfo = aInfo;
    }

    private boolean crossesHorizontalSizeThreshold(int firstDp, int secondDp) {
        return ActivityRecord.crossesSizeThreshold(this.mHorizontalSizeConfigurations, firstDp, secondDp);
    }

    private boolean crossesVerticalSizeThreshold(int firstDp, int secondDp) {
        return ActivityRecord.crossesSizeThreshold(this.mVerticalSizeConfigurations, firstDp, secondDp);
    }

    private boolean crossesSmallestSizeThreshold(int firstDp, int secondDp) {
        return ActivityRecord.crossesSizeThreshold(this.mSmallestSizeConfigurations, firstDp, secondDp);
    }

    private static boolean crossesSizeThreshold(int[] thresholds, int firstDp, int secondDp) {
        if (thresholds == null) {
            return false;
        }
        for (int i = thresholds.length - 1; i >= 0; --i) {
            int threshold = thresholds[i];
            if ((firstDp >= threshold || secondDp < threshold) && (firstDp < threshold || secondDp >= threshold)) continue;
            return true;
        }
        return false;
    }

    void setSizeConfigurations(int[] horizontalSizeConfiguration, int[] verticalSizeConfigurations, int[] smallestSizeConfigurations) {
        this.mHorizontalSizeConfigurations = horizontalSizeConfiguration;
        this.mVerticalSizeConfigurations = verticalSizeConfigurations;
        this.mSmallestSizeConfigurations = smallestSizeConfigurations;
    }

    private void scheduleActivityMovedToDisplay(int displayId, Configuration config) {
        if (!this.attachedToProcess()) {
            return;
        }
        try {
            this.mAtmService.getLifecycleManager().scheduleTransaction(this.app.getThread(), (IBinder)this.appToken, MoveToDisplayItem.obtain(displayId, config));
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private void scheduleConfigurationChanged(Configuration config) {
        if (!this.attachedToProcess()) {
            return;
        }
        try {
            this.mAtmService.getLifecycleManager().scheduleTransaction(this.app.getThread(), (IBinder)this.appToken, ActivityConfigurationChangeItem.obtain(config));
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    boolean scheduleTopResumedActivityChanged(boolean onTop) {
        if (!this.attachedToProcess()) {
            return false;
        }
        try {
            this.mAtmService.getLifecycleManager().scheduleTransaction(this.app.getThread(), (IBinder)this.appToken, TopResumedActivityChangeItem.obtain(onTop));
        }
        catch (RemoteException e) {
            return false;
        }
        return true;
    }

    void updateMultiWindowMode() {
        if (this.task == null || this.task.getStack() == null || !this.attachedToProcess()) {
            return;
        }
        if (((ActivityStack)this.task.getStack()).deferScheduleMultiWindowModeChanged()) {
            return;
        }
        boolean inMultiWindowMode = this.inMultiWindowMode();
        if (inMultiWindowMode != this.mLastReportedMultiWindowMode) {
            this.mLastReportedMultiWindowMode = inMultiWindowMode;
            this.scheduleMultiWindowModeChanged(this.getConfiguration());
        }
    }

    private void scheduleMultiWindowModeChanged(Configuration overrideConfig) {
        try {
            this.mAtmService.getLifecycleManager().scheduleTransaction(this.app.getThread(), (IBinder)this.appToken, MultiWindowModeChangeItem.obtain(this.mLastReportedMultiWindowMode, overrideConfig));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void updatePictureInPictureMode(Rect targetStackBounds, boolean forceUpdate) {
        boolean inPictureInPictureMode;
        if (this.task == null || this.task.getStack() == null || !this.attachedToProcess()) {
            return;
        }
        boolean bl = inPictureInPictureMode = this.inPinnedWindowingMode() && targetStackBounds != null;
        if (inPictureInPictureMode != this.mLastReportedPictureInPictureMode || forceUpdate) {
            this.mLastReportedPictureInPictureMode = inPictureInPictureMode;
            this.mLastReportedMultiWindowMode = inPictureInPictureMode;
            Configuration newConfig = new Configuration();
            if (targetStackBounds != null && !targetStackBounds.isEmpty()) {
                newConfig.setTo(this.task.getRequestedOverrideConfiguration());
                Rect outBounds = newConfig.windowConfiguration.getBounds();
                this.task.adjustForMinimalTaskDimensions(outBounds, outBounds);
                this.task.computeConfigResourceOverrides(newConfig, this.task.getParent().getConfiguration());
            }
            this.schedulePictureInPictureModeChanged(newConfig);
            this.scheduleMultiWindowModeChanged(newConfig);
        }
    }

    private void schedulePictureInPictureModeChanged(Configuration overrideConfig) {
        try {
            this.mAtmService.getLifecycleManager().scheduleTransaction(this.app.getThread(), (IBinder)this.appToken, PipModeChangeItem.obtain(this.mLastReportedPictureInPictureMode, overrideConfig));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    protected int getChildCount() {
        return 0;
    }

    protected ConfigurationContainer getChildAt(int index) {
        return null;
    }

    @Override
    protected ConfigurationContainer getParent() {
        return this.getTaskRecord();
    }

    TaskRecord getTaskRecord() {
        return this.task;
    }

    void setTask(TaskRecord task) {
        this.setTask(task, false);
    }

    void setTask(TaskRecord task, boolean reparenting) {
        ActivityStack newStack;
        if (task != null && task == this.getTaskRecord()) {
            return;
        }
        Object oldStack = this.getActivityStack();
        ActivityStack activityStack = newStack = task != null ? (ActivityStack)task.getStack() : null;
        if (oldStack != newStack) {
            if (!reparenting && oldStack != null) {
                ((ActivityStack)oldStack).onActivityRemovedFromStack(this);
            }
            if (newStack != null) {
                newStack.onActivityAddedToStack(this);
            }
        }
        this.task = task;
        if (!reparenting) {
            this.onParentChanged();
        }
    }

    void setWillCloseOrEnterPip(boolean willCloseOrEnterPip) {
        if (this.mAppWindowToken == null) {
            return;
        }
        this.mAppWindowToken.setWillCloseOrEnterPip(willCloseOrEnterPip);
    }

    static ActivityRecord forTokenLocked(IBinder token) {
        try {
            return Token.tokenToActivityRecordLocked((Token)token);
        }
        catch (ClassCastException e) {
            Slog.w("ActivityTaskManager", "Bad activity token: " + token, e);
            return null;
        }
    }

    static boolean isResolverActivity(String className) {
        return ResolverActivity.class.getName().equals(className);
    }

    boolean isResolverActivity() {
        return ActivityRecord.isResolverActivity(this.mActivityComponent.getClassName());
    }

    boolean isResolverOrChildActivity() {
        if (!"android".equals(this.packageName)) {
            return false;
        }
        try {
            return ResolverActivity.class.isAssignableFrom(Object.class.getClassLoader().loadClass(this.mActivityComponent.getClassName()));
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    ActivityRecord(ActivityTaskManagerService _service, WindowProcessController _caller, int _launchedFromPid, int _launchedFromUid, String _launchedFromPackage, Intent _intent, String _resolvedType, ActivityInfo aInfo, Configuration _configuration, ActivityRecord _resultTo, String _resultWho, int _reqCode, boolean _componentSpecified, boolean _rootVoiceInteraction, ActivityStackSupervisor supervisor, ActivityOptions options, ActivityRecord sourceRecord) {
        this.mAtmService = _service;
        this.mRootActivityContainer = _service.mRootActivityContainer;
        this.appToken = new Token(this, _intent);
        this.info = aInfo;
        this.launchedFromPid = _launchedFromPid;
        this.launchedFromUid = _launchedFromUid;
        this.launchedFromPackage = _launchedFromPackage;
        this.mUserId = UserHandle.getUserId(aInfo.applicationInfo.uid);
        this.intent = _intent;
        this.shortComponentName = _intent.getComponent().flattenToShortString();
        this.resolvedType = _resolvedType;
        this.componentSpecified = _componentSpecified;
        this.rootVoiceInteraction = _rootVoiceInteraction;
        this.mLastReportedConfiguration = new MergedConfiguration(_configuration);
        this.resultTo = _resultTo;
        this.resultWho = _resultWho;
        this.requestCode = _reqCode;
        this.setState(ActivityStack.ActivityState.INITIALIZING, "ActivityRecord ctor");
        this.frontOfTask = false;
        this.launchFailed = false;
        this.stopped = false;
        this.delayedResume = false;
        this.finishing = false;
        this.deferRelaunchUntilPaused = false;
        this.keysPaused = false;
        this.inHistory = false;
        this.visible = false;
        this.nowVisible = false;
        this.mDrawn = false;
        this.idle = false;
        this.hasBeenLaunched = false;
        this.mStackSupervisor = supervisor;
        this.haveState = true;
        this.mActivityComponent = aInfo.targetActivity == null || aInfo.targetActivity.equals(_intent.getComponent().getClassName()) && (aInfo.launchMode == 0 || aInfo.launchMode == 1) ? _intent.getComponent() : new ComponentName(aInfo.packageName, aInfo.targetActivity);
        this.taskAffinity = aInfo.taskAffinity;
        this.stateNotNeeded = (aInfo.flags & 0x10) != 0;
        this.appInfo = aInfo.applicationInfo;
        this.nonLocalizedLabel = aInfo.nonLocalizedLabel;
        this.labelRes = aInfo.labelRes;
        if (this.nonLocalizedLabel == null && this.labelRes == 0) {
            ApplicationInfo app = aInfo.applicationInfo;
            this.nonLocalizedLabel = app.nonLocalizedLabel;
            this.labelRes = app.labelRes;
        }
        this.icon = aInfo.getIconResource();
        this.logo = aInfo.getLogoResource();
        this.realTheme = this.theme = aInfo.getThemeResource();
        if (this.realTheme == 0) {
            int n = this.realTheme = aInfo.applicationInfo.targetSdkVersion < 11 ? 16973829 : 16973931;
        }
        if ((aInfo.flags & 0x200) != 0) {
            this.windowFlags |= 0x1000000;
        }
        this.processName = (aInfo.flags & 1) != 0 && _caller != null && (aInfo.applicationInfo.uid == 1000 || aInfo.applicationInfo.uid == _caller.mInfo.uid) ? _caller.mName : aInfo.processName;
        if ((aInfo.flags & 0x20) != 0) {
            this.intent.addFlags(0x800000);
        }
        this.packageName = aInfo.applicationInfo.packageName;
        this.launchMode = aInfo.launchMode;
        AttributeCache.Entry ent = AttributeCache.instance().get(this.packageName, this.realTheme, R.styleable.Window, this.mUserId);
        if (ent != null) {
            this.fullscreen = !ActivityInfo.isTranslucentOrFloating(ent.array);
            this.hasWallpaper = ent.array.getBoolean(14, false);
            this.noDisplay = ent.array.getBoolean(10, false);
        } else {
            this.hasWallpaper = false;
            this.noDisplay = false;
        }
        this.setActivityType(_componentSpecified, _launchedFromUid, _intent, options, sourceRecord);
        this.immersive = (aInfo.flags & 0x800) != 0;
        this.requestedVrComponent = aInfo.requestedVrComponent == null ? null : ComponentName.unflattenFromString(aInfo.requestedVrComponent);
        this.mShowWhenLocked = (aInfo.flags & 0x800000) != 0;
        this.mInheritShownWhenLocked = (aInfo.privateFlags & 1) != 0;
        this.mTurnScreenOn = (aInfo.flags & 0x1000000) != 0;
        this.mRotationAnimationHint = aInfo.rotationAnimation;
        this.lockTaskLaunchMode = aInfo.lockTaskLaunchMode;
        if (this.appInfo.isPrivilegedApp() && (this.lockTaskLaunchMode == 2 || this.lockTaskLaunchMode == 1)) {
            this.lockTaskLaunchMode = 0;
        }
        if (options != null) {
            boolean useLockTask;
            PendingIntent usageReport;
            this.pendingOptions = options;
            this.mLaunchTaskBehind = options.getLaunchTaskBehind();
            int rotationAnimation = this.pendingOptions.getRotationAnimationHint();
            if (rotationAnimation >= 0) {
                this.mRotationAnimationHint = rotationAnimation;
            }
            if ((usageReport = this.pendingOptions.getUsageTimeReport()) != null) {
                this.appTimeTracker = new AppTimeTracker(usageReport);
            }
            if ((useLockTask = this.pendingOptions.getLockTaskMode()) && this.lockTaskLaunchMode == 0) {
                this.lockTaskLaunchMode = 3;
            }
            this.mHandoverLaunchDisplayId = options.getLaunchDisplayId();
        }
    }

    void setProcess(WindowProcessController proc) {
        ActivityRecord root;
        this.app = proc;
        ActivityRecord activityRecord = root = this.task != null ? this.task.getRootActivity() : null;
        if (root == this) {
            this.task.setRootProcess(proc);
        }
    }

    boolean hasProcess() {
        return this.app != null;
    }

    boolean attachedToProcess() {
        return this.hasProcess() && this.app.hasThread();
    }

    void createAppWindowToken() {
        if (this.mAppWindowToken != null) {
            throw new IllegalArgumentException("App Window Token=" + this.mAppWindowToken + " already created for r=" + this);
        }
        this.inHistory = true;
        this.task.updateOverrideConfigurationFromLaunchBounds();
        this.updateOverrideConfiguration();
        this.mAppWindowToken = this.mAtmService.mWindowManager.mRoot.getAppWindowToken(this.appToken.asBinder());
        if (this.mAppWindowToken != null) {
            Slog.w("ActivityTaskManager", "Attempted to add existing app token: " + this.appToken);
        } else {
            Task container = this.task.getTask();
            if (container == null) {
                throw new IllegalArgumentException("createAppWindowToken: invalid task =" + this.task);
            }
            this.mAppWindowToken = this.createAppWindow(this.mAtmService.mWindowManager, this.appToken, this.task.voiceSession != null, container.getDisplayContent(), ActivityTaskManagerService.getInputDispatchingTimeoutLocked(this) * 1000000L, this.fullscreen, (this.info.flags & 0x400) != 0, this.appInfo.targetSdkVersion, this.info.screenOrientation, this.mRotationAnimationHint, this.mLaunchTaskBehind, this.isAlwaysFocusable());
            container.addChild(this.mAppWindowToken, Integer.MAX_VALUE);
        }
        this.task.addActivityToTop(this);
        this.mLastReportedMultiWindowMode = this.inMultiWindowMode();
        this.mLastReportedPictureInPictureMode = this.inPinnedWindowingMode();
    }

    boolean addStartingWindow(String pkg, int theme, CompatibilityInfo compatInfo, CharSequence nonLocalizedLabel, int labelRes, int icon, int logo, int windowFlags, IBinder transferFrom, boolean newTask, boolean taskSwitch, boolean processRunning, boolean allowTaskSnapshot, boolean activityCreated, boolean fromRecents) {
        if (this.mAppWindowToken == null) {
            Slog.w("WindowManager", "Attempted to set icon of non-existing app token: " + this.appToken);
            return false;
        }
        if (this.mAppWindowToken.getTask() == null) {
            Slog.w("WindowManager", "Attempted to start a window to an app token not having attached to any task: " + this.appToken);
            return false;
        }
        return this.mAppWindowToken.addStartingWindow(pkg, theme, compatInfo, nonLocalizedLabel, labelRes, icon, logo, windowFlags, transferFrom, newTask, taskSwitch, processRunning, allowTaskSnapshot, activityCreated, fromRecents);
    }

    @VisibleForTesting
    AppWindowToken createAppWindow(WindowManagerService service, IApplicationToken token, boolean voiceInteraction, DisplayContent dc, long inputDispatchingTimeoutNanos, boolean fullscreen, boolean showForAllUsers, int targetSdk, int orientation, int rotationAnimationHint, boolean launchTaskBehind, boolean alwaysFocusable) {
        return new AppWindowToken(service, token, this.mActivityComponent, voiceInteraction, dc, inputDispatchingTimeoutNanos, fullscreen, showForAllUsers, targetSdk, orientation, rotationAnimationHint, launchTaskBehind, alwaysFocusable, this);
    }

    void removeWindowContainer() {
        if (this.mAtmService.mWindowManager.mRoot == null) {
            return;
        }
        DisplayContent dc = this.mAtmService.mWindowManager.mRoot.getDisplayContent(this.getDisplayId());
        if (dc == null) {
            Slog.w("ActivityTaskManager", "removeWindowContainer: Attempted to remove token: " + this.appToken + " from non-existing displayId=" + this.getDisplayId());
            return;
        }
        this.resumeKeyDispatchingLocked();
        dc.removeAppToken(this.appToken.asBinder());
    }

    void reparent(TaskRecord newTask, int position, String reason) {
        if (this.mAppWindowToken == null) {
            Slog.w("ActivityTaskManager", "reparent: Attempted to reparent non-existing app token: " + this.appToken);
            return;
        }
        TaskRecord prevTask = this.task;
        if (prevTask == newTask) {
            throw new IllegalArgumentException(reason + ": task=" + newTask + " is already the parent of r=" + this);
        }
        if (prevTask != null && newTask != null && prevTask.getStack() != newTask.getStack()) {
            throw new IllegalArgumentException(reason + ": task=" + newTask + " is in a different stack (" + newTask.getStackId() + ") than the parent of r=" + this + " (" + prevTask.getStackId() + ")");
        }
        this.mAppWindowToken.reparent(newTask.getTask(), position);
        Object prevStack = prevTask.getStack();
        if (prevStack != newTask.getStack()) {
            ((ActivityStack)prevStack).onActivityRemovedFromStack(this);
        }
        prevTask.removeActivity(this, true);
        newTask.addActivityAtIndex(position, this);
    }

    private boolean isHomeIntent(Intent intent) {
        return "android.intent.action.MAIN".equals(intent.getAction()) && (intent.hasCategory("android.intent.category.HOME") || intent.hasCategory("android.intent.category.SECONDARY_HOME")) && intent.getCategories().size() == 1 && intent.getData() == null && intent.getType() == null;
    }

    static boolean isMainIntent(Intent intent) {
        return "android.intent.action.MAIN".equals(intent.getAction()) && intent.hasCategory("android.intent.category.LAUNCHER") && intent.getCategories().size() == 1 && intent.getData() == null && intent.getType() == null;
    }

    private boolean canLaunchHomeActivity(int uid, ActivityRecord sourceRecord) {
        if (uid == Process.myUid() || uid == 0) {
            return true;
        }
        RecentTasks recentTasks = this.mStackSupervisor.mService.getRecentTasks();
        if (recentTasks != null && recentTasks.isCallerRecents(uid)) {
            return true;
        }
        return sourceRecord != null && sourceRecord.isResolverActivity();
    }

    private boolean canLaunchAssistActivity(String packageName) {
        ComponentName assistComponent = this.mAtmService.mActiveVoiceInteractionServiceComponent;
        if (assistComponent != null) {
            return assistComponent.getPackageName().equals(packageName);
        }
        return false;
    }

    private void setActivityType(boolean componentSpecified, int launchedFromUid, Intent intent, ActivityOptions options, ActivityRecord sourceRecord) {
        int activityType = 0;
        if ((!componentSpecified || this.canLaunchHomeActivity(launchedFromUid, sourceRecord)) && this.isHomeIntent(intent) && !this.isResolverActivity()) {
            activityType = 2;
            if (this.info.resizeMode == 4 || this.info.resizeMode == 1) {
                this.info.resizeMode = 0;
            }
        } else if (this.mActivityComponent.getClassName().contains(LEGACY_RECENTS_PACKAGE_NAME) || this.mAtmService.getRecentTasks().isRecentsComponent(this.mActivityComponent, this.appInfo.uid)) {
            activityType = 3;
        } else if (options != null && options.getLaunchActivityType() == 4 && this.canLaunchAssistActivity(this.launchedFromPackage)) {
            activityType = 4;
        }
        this.setActivityType(activityType);
    }

    void setTaskToAffiliateWith(TaskRecord taskToAffiliateWith) {
        if (this.launchMode != 3 && this.launchMode != 2) {
            this.task.setTaskToAffiliateWith(taskToAffiliateWith);
        }
    }

    <T extends ActivityStack> T getActivityStack() {
        return this.task != null ? (T)this.task.getStack() : null;
    }

    int getStackId() {
        return this.getActivityStack() != null ? ((ActivityStack)this.getActivityStack()).mStackId : -1;
    }

    ActivityDisplay getDisplay() {
        Object stack = this.getActivityStack();
        return stack != null ? ((ActivityStack)stack).getDisplay() : null;
    }

    boolean changeWindowTranslucency(boolean toOpaque) {
        if (this.fullscreen == toOpaque) {
            return false;
        }
        this.task.numFullscreen = this.task.numFullscreen + (toOpaque ? 1 : -1);
        this.fullscreen = toOpaque;
        return true;
    }

    void takeFromHistory() {
        if (this.inHistory) {
            this.inHistory = false;
            if (this.task != null && !this.finishing) {
                this.task = null;
            }
            this.clearOptionsLocked();
        }
    }

    boolean isInHistory() {
        return this.inHistory;
    }

    boolean isInStackLocked() {
        Object stack = this.getActivityStack();
        return stack != null && ((ActivityStack)stack).isInStackLocked(this) != null;
    }

    boolean isPersistable() {
        return !(this.info.persistableMode != 0 && this.info.persistableMode != 2 || this.intent != null && (this.intent.getFlags() & 0x800000) != 0);
    }

    boolean isFocusable() {
        return this.mRootActivityContainer.isFocusable(this, this.isAlwaysFocusable());
    }

    boolean isResizeable() {
        return ActivityInfo.isResizeableMode(this.info.resizeMode) || this.info.supportsPictureInPicture();
    }

    boolean isNonResizableOrForcedResizable() {
        return this.info.resizeMode != 2 && this.info.resizeMode != 1;
    }

    boolean supportsPictureInPicture() {
        return this.mAtmService.mSupportsPictureInPicture && this.isActivityTypeStandardOrUndefined() && this.info.supportsPictureInPicture();
    }

    @Override
    public boolean supportsSplitScreenWindowingMode() {
        return super.supportsSplitScreenWindowingMode() && this.mAtmService.mSupportsSplitScreenMultiWindow && this.supportsResizeableMultiWindow();
    }

    boolean supportsFreeform() {
        return this.mAtmService.mSupportsFreeformWindowManagement && this.supportsResizeableMultiWindow();
    }

    private boolean supportsResizeableMultiWindow() {
        return this.mAtmService.mSupportsMultiWindow && !this.isActivityTypeHome() && (ActivityInfo.isResizeableMode(this.info.resizeMode) || this.mAtmService.mForceResizableActivities);
    }

    boolean canBeLaunchedOnDisplay(int displayId) {
        return this.mAtmService.mStackSupervisor.canPlaceEntityOnDisplay(displayId, this.launchedFromPid, this.launchedFromUid, this.info);
    }

    boolean checkEnterPictureInPictureState(String caller, boolean beforeStopping) {
        boolean isNotLockedOrOnKeyguard;
        if (!this.supportsPictureInPicture()) {
            return false;
        }
        if (!this.checkEnterPictureInPictureAppOpsState()) {
            return false;
        }
        if (this.mAtmService.shouldDisableNonVrUiLocked()) {
            return false;
        }
        boolean isKeyguardLocked = this.mAtmService.isKeyguardLocked();
        boolean isCurrentAppLocked = this.mAtmService.getLockTaskModeState() != 0;
        ActivityDisplay display = this.getDisplay();
        boolean hasPinnedStack = display != null && display.hasPinnedStack();
        boolean bl = isNotLockedOrOnKeyguard = !isKeyguardLocked && !isCurrentAppLocked;
        if (beforeStopping && hasPinnedStack) {
            return false;
        }
        switch (this.mState) {
            case RESUMED: {
                return !isCurrentAppLocked && (this.supportsEnterPipOnTaskSwitch || !beforeStopping);
            }
            case PAUSING: 
            case PAUSED: {
                return isNotLockedOrOnKeyguard && !hasPinnedStack && this.supportsEnterPipOnTaskSwitch;
            }
            case STOPPING: {
                if (!this.supportsEnterPipOnTaskSwitch) break;
                return isNotLockedOrOnKeyguard && !hasPinnedStack;
            }
        }
        return false;
    }

    private boolean checkEnterPictureInPictureAppOpsState() {
        return this.mAtmService.getAppOpsService().checkOperation(67, this.appInfo.uid, this.packageName) == 0;
    }

    boolean isAlwaysFocusable() {
        return (this.info.flags & 0x40000) != 0;
    }

    boolean moveFocusableActivityToTop(String reason) {
        if (!this.isFocusable()) {
            return false;
        }
        TaskRecord task = this.getTaskRecord();
        Object stack = this.getActivityStack();
        if (stack == null) {
            Slog.w("ActivityTaskManager", "moveActivityStackToFront: invalid task or stack: activity=" + this + " task=" + task);
            return false;
        }
        if (this.mRootActivityContainer.getTopResumedActivity() == this) {
            return false;
        }
        ((ActivityStack)stack).moveToFront(reason, task);
        if (this.mRootActivityContainer.getTopResumedActivity() == this) {
            this.mAtmService.setResumedActivityUncheckLocked(this, reason);
        }
        return true;
    }

    void makeFinishingLocked() {
        if (this.finishing) {
            return;
        }
        this.finishing = true;
        if (this.stopped) {
            this.clearOptionsLocked();
        }
        if (this.mAtmService != null) {
            this.mAtmService.getTaskChangeNotificationController().notifyTaskStackChanged();
        }
    }

    UriPermissionOwner getUriPermissionsLocked() {
        if (this.uriPermissions == null) {
            this.uriPermissions = new UriPermissionOwner(this.mAtmService.mUgmInternal, this);
        }
        return this.uriPermissions;
    }

    void addResultLocked(ActivityRecord from, String resultWho, int requestCode, int resultCode, Intent resultData) {
        ActivityResult r = new ActivityResult(from, resultWho, requestCode, resultCode, resultData);
        if (this.results == null) {
            this.results = new ArrayList();
        }
        this.results.add(r);
    }

    void removeResultsLocked(ActivityRecord from, String resultWho, int requestCode) {
        if (this.results != null) {
            for (int i = this.results.size() - 1; i >= 0; --i) {
                ActivityResult r = (ActivityResult)this.results.get(i);
                if (r.mFrom != from || (r.mResultWho != null ? !r.mResultWho.equals(resultWho) : resultWho != null) || r.mRequestCode != requestCode) continue;
                this.results.remove(i);
            }
        }
    }

    private void addNewIntentLocked(ReferrerIntent intent) {
        if (this.newIntents == null) {
            this.newIntents = new ArrayList();
        }
        this.newIntents.add(intent);
    }

    final boolean isSleeping() {
        Object stack = this.getActivityStack();
        return stack != null ? ((ActivityStack)stack).shouldSleepActivities() : this.mAtmService.isSleepingLocked();
    }

    final void deliverNewIntentLocked(int callingUid, Intent intent, String referrer) {
        boolean isTopActivityWhileSleeping;
        this.mAtmService.mUgmInternal.grantUriPermissionFromIntent(callingUid, this.packageName, intent, this.getUriPermissionsLocked(), this.mUserId);
        ReferrerIntent rintent = new ReferrerIntent(intent, referrer);
        boolean unsent = true;
        boolean bl = isTopActivityWhileSleeping = this.isTopRunningActivity() && this.isSleeping();
        if ((this.mState == ActivityStack.ActivityState.RESUMED || this.mState == ActivityStack.ActivityState.PAUSED || isTopActivityWhileSleeping) && this.attachedToProcess()) {
            try {
                ArrayList<ReferrerIntent> ar = new ArrayList<ReferrerIntent>(1);
                ar.add(rintent);
                this.mAtmService.getLifecycleManager().scheduleTransaction(this.app.getThread(), (IBinder)this.appToken, NewIntentItem.obtain(ar, this.mState == ActivityStack.ActivityState.RESUMED));
                unsent = false;
            }
            catch (RemoteException e) {
                Slog.w("ActivityTaskManager", "Exception thrown sending new intent to " + this, e);
            }
            catch (NullPointerException e) {
                Slog.w("ActivityTaskManager", "Exception thrown sending new intent to " + this, e);
            }
        }
        if (unsent) {
            this.addNewIntentLocked(rintent);
        }
    }

    void updateOptionsLocked(ActivityOptions options) {
        if (options != null) {
            if (this.pendingOptions != null) {
                this.pendingOptions.abort();
            }
            this.pendingOptions = options;
        }
    }

    void applyOptionsLocked() {
        if (this.pendingOptions != null && this.pendingOptions.getAnimationType() != 5) {
            this.applyOptionsLocked(this.pendingOptions, this.intent);
            if (this.task == null) {
                this.clearOptionsLocked(false);
            } else {
                this.task.clearAllPendingOptions();
            }
        }
    }

    void applyOptionsLocked(ActivityOptions pendingOptions, Intent intent) {
        int animationType = pendingOptions.getAnimationType();
        DisplayContent displayContent = this.mAppWindowToken.getDisplayContent();
        switch (animationType) {
            case 1: {
                displayContent.mAppTransition.overridePendingAppTransition(pendingOptions.getPackageName(), pendingOptions.getCustomEnterResId(), pendingOptions.getCustomExitResId(), pendingOptions.getOnAnimationStartListener());
                break;
            }
            case 11: {
                displayContent.mAppTransition.overridePendingAppTransitionClipReveal(pendingOptions.getStartX(), pendingOptions.getStartY(), pendingOptions.getWidth(), pendingOptions.getHeight());
                if (intent.getSourceBounds() != null) break;
                intent.setSourceBounds(new Rect(pendingOptions.getStartX(), pendingOptions.getStartY(), pendingOptions.getStartX() + pendingOptions.getWidth(), pendingOptions.getStartY() + pendingOptions.getHeight()));
                break;
            }
            case 2: {
                displayContent.mAppTransition.overridePendingAppTransitionScaleUp(pendingOptions.getStartX(), pendingOptions.getStartY(), pendingOptions.getWidth(), pendingOptions.getHeight());
                if (intent.getSourceBounds() != null) break;
                intent.setSourceBounds(new Rect(pendingOptions.getStartX(), pendingOptions.getStartY(), pendingOptions.getStartX() + pendingOptions.getWidth(), pendingOptions.getStartY() + pendingOptions.getHeight()));
                break;
            }
            case 3: 
            case 4: {
                boolean scaleUp = animationType == 3;
                GraphicBuffer buffer = pendingOptions.getThumbnail();
                displayContent.mAppTransition.overridePendingAppTransitionThumb(buffer, pendingOptions.getStartX(), pendingOptions.getStartY(), pendingOptions.getOnAnimationStartListener(), scaleUp);
                if (intent.getSourceBounds() != null || buffer == null) break;
                intent.setSourceBounds(new Rect(pendingOptions.getStartX(), pendingOptions.getStartY(), pendingOptions.getStartX() + buffer.getWidth(), pendingOptions.getStartY() + buffer.getHeight()));
                break;
            }
            case 8: 
            case 9: {
                AppTransitionAnimationSpec[] specs = pendingOptions.getAnimSpecs();
                IAppTransitionAnimationSpecsFuture specsFuture = pendingOptions.getSpecsFuture();
                if (specsFuture != null) {
                    displayContent.mAppTransition.overridePendingAppTransitionMultiThumbFuture(specsFuture, pendingOptions.getOnAnimationStartListener(), animationType == 8);
                    break;
                }
                if (animationType == 9 && specs != null) {
                    displayContent.mAppTransition.overridePendingAppTransitionMultiThumb(specs, pendingOptions.getOnAnimationStartListener(), pendingOptions.getAnimationFinishedListener(), false);
                    break;
                }
                displayContent.mAppTransition.overridePendingAppTransitionAspectScaledThumb(pendingOptions.getThumbnail(), pendingOptions.getStartX(), pendingOptions.getStartY(), pendingOptions.getWidth(), pendingOptions.getHeight(), pendingOptions.getOnAnimationStartListener(), animationType == 8);
                if (intent.getSourceBounds() != null) break;
                intent.setSourceBounds(new Rect(pendingOptions.getStartX(), pendingOptions.getStartY(), pendingOptions.getStartX() + pendingOptions.getWidth(), pendingOptions.getStartY() + pendingOptions.getHeight()));
                break;
            }
            case 12: {
                displayContent.mAppTransition.overridePendingAppTransitionStartCrossProfileApps();
                break;
            }
            case 13: {
                displayContent.mAppTransition.overridePendingAppTransitionRemote(pendingOptions.getRemoteAnimationAdapter());
                break;
            }
            case 0: {
                break;
            }
            default: {
                Slog.e("WindowManager", "applyOptionsLocked: Unknown animationType=" + animationType);
            }
        }
    }

    ActivityOptions getOptionsForTargetActivityLocked() {
        return this.pendingOptions != null ? this.pendingOptions.forTargetActivity() : null;
    }

    void clearOptionsLocked() {
        this.clearOptionsLocked(true);
    }

    void clearOptionsLocked(boolean withAbort) {
        if (withAbort && this.pendingOptions != null) {
            this.pendingOptions.abort();
        }
        this.pendingOptions = null;
    }

    ActivityOptions takeOptionsLocked(boolean fromClient) {
        ActivityOptions opts = this.pendingOptions;
        if (!fromClient || opts == null || opts.getRemoteAnimationAdapter() == null) {
            this.pendingOptions = null;
        }
        return opts;
    }

    void removeUriPermissionsLocked() {
        if (this.uriPermissions != null) {
            this.uriPermissions.removeUriPermissions();
            this.uriPermissions = null;
        }
    }

    void pauseKeyDispatchingLocked() {
        if (!this.keysPaused) {
            this.keysPaused = true;
            if (this.mAppWindowToken != null && this.mAppWindowToken.getDisplayContent() != null) {
                this.mAppWindowToken.getDisplayContent().getInputMonitor().pauseDispatchingLw(this.mAppWindowToken);
            }
        }
    }

    void resumeKeyDispatchingLocked() {
        if (this.keysPaused) {
            this.keysPaused = false;
            if (this.mAppWindowToken != null && this.mAppWindowToken.getDisplayContent() != null) {
                this.mAppWindowToken.getDisplayContent().getInputMonitor().resumeDispatchingLw(this.mAppWindowToken);
            }
        }
    }

    private void updateTaskDescription(CharSequence description) {
        this.task.lastDescription = description;
    }

    void setDeferHidingClient(boolean deferHidingClient) {
        if (this.mDeferHidingClient == deferHidingClient) {
            return;
        }
        this.mDeferHidingClient = deferHidingClient;
        if (!this.mDeferHidingClient && !this.visible) {
            this.setVisibility(false);
        }
    }

    void setVisibility(boolean visible) {
        if (this.mAppWindowToken == null) {
            Slog.w("WindowManager", "Attempted to set visibility of non-existing app token: " + this.appToken);
            return;
        }
        this.mAppWindowToken.setVisibility(visible, this.mDeferHidingClient);
        this.mStackSupervisor.getActivityMetricsLogger().notifyVisibilityChanged(this);
    }

    void setVisible(boolean newVisible) {
        this.visible = newVisible;
        this.mDeferHidingClient = !this.visible && this.mDeferHidingClient;
        this.setVisibility(this.visible);
        this.mStackSupervisor.mAppVisibilitiesChangedSinceLastPause = true;
    }

    void setState(ActivityStack.ActivityState state, String reason) {
        if (state == this.mState) {
            return;
        }
        this.mState = state;
        TaskRecord parent = this.getTaskRecord();
        if (parent != null) {
            parent.onActivityStateChanged(this, state, reason);
        }
        if (state == ActivityStack.ActivityState.STOPPING && !this.isSleeping()) {
            if (this.mAppWindowToken == null) {
                Slog.w("WindowManager", "Attempted to notify stopping on non-existing app token: " + this.appToken);
                return;
            }
            this.mAppWindowToken.detachChildren();
        }
        if (state == ActivityStack.ActivityState.RESUMED) {
            this.mAtmService.updateBatteryStats(this, true);
            this.mAtmService.updateActivityUsageStats(this, 1);
        } else if (state == ActivityStack.ActivityState.PAUSED) {
            this.mAtmService.updateBatteryStats(this, false);
            this.mAtmService.updateActivityUsageStats(this, 2);
        } else if (state == ActivityStack.ActivityState.STOPPED) {
            this.mAtmService.updateActivityUsageStats(this, 23);
        } else if (state == ActivityStack.ActivityState.DESTROYED) {
            this.mAtmService.updateActivityUsageStats(this, 24);
        }
    }

    ActivityStack.ActivityState getState() {
        return this.mState;
    }

    boolean isState(ActivityStack.ActivityState state) {
        return state == this.mState;
    }

    boolean isState(ActivityStack.ActivityState state1, ActivityStack.ActivityState state2) {
        return state1 == this.mState || state2 == this.mState;
    }

    boolean isState(ActivityStack.ActivityState state1, ActivityStack.ActivityState state2, ActivityStack.ActivityState state3) {
        return state1 == this.mState || state2 == this.mState || state3 == this.mState;
    }

    boolean isState(ActivityStack.ActivityState state1, ActivityStack.ActivityState state2, ActivityStack.ActivityState state3, ActivityStack.ActivityState state4) {
        return state1 == this.mState || state2 == this.mState || state3 == this.mState || state4 == this.mState;
    }

    void notifyAppResumed(boolean wasStopped) {
        if (this.mAppWindowToken == null) {
            Slog.w("WindowManager", "Attempted to notify resumed of non-existing app token: " + this.appToken);
            return;
        }
        this.mAppWindowToken.notifyAppResumed(wasStopped);
    }

    void notifyUnknownVisibilityLaunched() {
        if (!this.noDisplay && this.mAppWindowToken != null) {
            this.mAppWindowToken.getDisplayContent().mUnknownAppVisibilityController.notifyLaunched(this.mAppWindowToken);
        }
    }

    boolean shouldBeVisibleIgnoringKeyguard(boolean behindFullscreenActivity) {
        if (!this.okToShowLocked()) {
            return false;
        }
        return !behindFullscreenActivity || this.mLaunchTaskBehind;
    }

    boolean shouldBeVisible(boolean behindFullscreenActivity) {
        this.visibleIgnoringKeyguard = this.shouldBeVisibleIgnoringKeyguard(behindFullscreenActivity);
        Object stack = this.getActivityStack();
        if (stack == null) {
            return false;
        }
        boolean isDisplaySleeping = this.getDisplay().isSleeping() && this.getDisplayId() != 0;
        boolean isTop = this == ((ActivityStack)stack).getTopActivity();
        boolean isTopNotPinnedStack = ((ActivityStack)stack).isAttached() && ((ActivityStack)stack).getDisplay().isTopNotPinnedStack((ActivityStack)stack);
        boolean visibleIgnoringDisplayStatus = ((ActivityStack)stack).checkKeyguardVisibility(this, this.visibleIgnoringKeyguard, isTop && isTopNotPinnedStack);
        return visibleIgnoringDisplayStatus && !isDisplaySleeping;
    }

    boolean shouldBeVisible() {
        Object stack = this.getActivityStack();
        if (stack == null) {
            return false;
        }
        return this.shouldBeVisible(!((ActivityStack)stack).shouldBeVisible(null));
    }

    void makeVisibleIfNeeded(ActivityRecord starting, boolean reportToClient) {
        if (this.mState == ActivityStack.ActivityState.RESUMED || this == starting) {
            return;
        }
        Object stack = this.getActivityStack();
        try {
            if (((ActivityStack)stack).mTranslucentActivityWaiting != null) {
                this.updateOptionsLocked(this.returningOptions);
                ((ActivityStack)stack).mUndrawnActivitiesBelowTopTranslucent.add(this);
            }
            this.setVisible(true);
            this.sleeping = false;
            this.app.postPendingUiCleanMsg(true);
            if (reportToClient) {
                this.makeClientVisible();
            } else {
                this.mClientVisibilityDeferred = true;
            }
            this.mStackSupervisor.mStoppingActivities.remove(this);
            this.mStackSupervisor.mGoingToSleepActivities.remove(this);
        }
        catch (Exception e) {
            Slog.w("ActivityTaskManager", "Exception thrown making visible: " + this.intent.getComponent(), e);
        }
        this.handleAlreadyVisible();
    }

    void makeClientVisible() {
        this.mClientVisibilityDeferred = false;
        try {
            this.mAtmService.getLifecycleManager().scheduleTransaction(this.app.getThread(), (IBinder)this.appToken, WindowVisibilityItem.obtain(true));
            this.makeActiveIfNeeded(null);
            if (this.isState(ActivityStack.ActivityState.STOPPING, ActivityStack.ActivityState.STOPPED) && this.isFocusable()) {
                this.setState(ActivityStack.ActivityState.PAUSED, "makeClientVisible");
            }
        }
        catch (Exception e) {
            Slog.w("ActivityTaskManager", "Exception thrown sending visibility update: " + this.intent.getComponent(), e);
        }
    }

    boolean makeActiveIfNeeded(ActivityRecord activeActivity) {
        if (this.shouldResumeActivity(activeActivity)) {
            return ((ActivityStack)this.getActivityStack()).resumeTopActivityUncheckedLocked(activeActivity, null);
        }
        if (this.shouldPauseActivity(activeActivity)) {
            this.setState(ActivityStack.ActivityState.PAUSING, "makeVisibleIfNeeded");
            try {
                this.mAtmService.getLifecycleManager().scheduleTransaction(this.app.getThread(), (IBinder)this.appToken, PauseActivityItem.obtain(this.finishing, false, this.configChangeFlags, false));
            }
            catch (Exception e) {
                Slog.w("ActivityTaskManager", "Exception thrown sending pause: " + this.intent.getComponent(), e);
            }
        }
        return false;
    }

    private boolean shouldPauseActivity(ActivityRecord activeActivity) {
        return this.shouldMakeActive(activeActivity) && !this.isFocusable() && !this.isState(ActivityStack.ActivityState.PAUSING, ActivityStack.ActivityState.PAUSED);
    }

    @VisibleForTesting
    boolean shouldResumeActivity(ActivityRecord activeActivity) {
        return this.shouldMakeActive(activeActivity) && this.isFocusable() && !this.isState(ActivityStack.ActivityState.RESUMED) && ((ActivityStack)this.getActivityStack()).getVisibility(activeActivity) == 0;
    }

    @VisibleForTesting
    boolean shouldMakeActive(ActivityRecord activeActivity) {
        if (!this.isState(ActivityStack.ActivityState.RESUMED, ActivityStack.ActivityState.PAUSED, ActivityStack.ActivityState.STOPPED, ActivityStack.ActivityState.STOPPING) || ((ActivityStack)this.getActivityStack()).mTranslucentActivityWaiting != null) {
            return false;
        }
        if (this == activeActivity) {
            return false;
        }
        if (!this.mStackSupervisor.readyToResume()) {
            return false;
        }
        if (this.mLaunchTaskBehind) {
            return false;
        }
        int positionInTask = this.task.mActivities.indexOf(this);
        if (positionInTask == -1) {
            throw new IllegalStateException("Activity not found in its task");
        }
        if (positionInTask == this.task.mActivities.size() - 1) {
            return true;
        }
        ActivityRecord activityAbove = this.task.mActivities.get(positionInTask + 1);
        return activityAbove.finishing && this.results == null;
    }

    boolean handleAlreadyVisible() {
        this.stopFreezingScreenLocked(false);
        try {
            if (this.returningOptions != null) {
                this.app.getThread().scheduleOnNewActivityOptions(this.appToken, this.returningOptions.toBundle());
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return this.mState == ActivityStack.ActivityState.RESUMED;
    }

    static void activityResumedLocked(IBinder token) {
        ActivityRecord r = ActivityRecord.forTokenLocked(token);
        if (r == null) {
            return;
        }
        r.icicle = null;
        r.haveState = false;
        ActivityDisplay display = r.getDisplay();
        if (display != null) {
            display.handleActivitySizeCompatModeIfNeeded(r);
        }
    }

    void completeResumeLocked() {
        boolean wasVisible = this.visible;
        this.setVisible(true);
        if (!wasVisible) {
            this.mStackSupervisor.mAppVisibilitiesChangedSinceLastPause = true;
        }
        this.idle = false;
        this.results = null;
        this.newIntents = null;
        this.stopped = false;
        if (this.isActivityTypeHome()) {
            this.mStackSupervisor.updateHomeProcess(this.task.mActivities.get((int)0).app);
        }
        if (this.nowVisible) {
            this.mStackSupervisor.stopWaitingForActivityVisible(this);
        }
        this.mStackSupervisor.scheduleIdleTimeoutLocked(this);
        this.mStackSupervisor.reportResumedActivityLocked(this);
        this.resumeKeyDispatchingLocked();
        Object stack = this.getActivityStack();
        this.mStackSupervisor.mNoAnimActivities.clear();
        this.cpuTimeAtResume = this.hasProcess() ? this.app.getCpuTime() : 0L;
        this.returningOptions = null;
        if (this.canTurnScreenOn()) {
            this.mStackSupervisor.wakeUp("turnScreenOnFlag");
        } else {
            ((ActivityStack)stack).checkReadyForSleep();
        }
    }

    final void activityStoppedLocked(Bundle newIcicle, PersistableBundle newPersistentState, CharSequence description) {
        boolean isStopping;
        Object stack = this.getActivityStack();
        boolean bl = isStopping = this.mState == ActivityStack.ActivityState.STOPPING;
        if (!isStopping && this.mState != ActivityStack.ActivityState.RESTARTING_PROCESS) {
            Slog.i("ActivityTaskManager", "Activity reported stop, but no longer stopping: " + this);
            ((ActivityStack)stack).mHandler.removeMessages(104, this);
            return;
        }
        if (newPersistentState != null) {
            this.persistentState = newPersistentState;
            this.mAtmService.notifyTaskPersisterLocked(this.task, false);
        }
        if (newIcicle != null) {
            this.icicle = newIcicle;
            this.haveState = true;
            this.launchCount = 0;
            this.updateTaskDescription(description);
        }
        if (!this.stopped) {
            ((ActivityStack)stack).mHandler.removeMessages(104, this);
            this.stopped = true;
            if (isStopping) {
                this.setState(ActivityStack.ActivityState.STOPPED, "activityStoppedLocked");
            }
            if (this.mAppWindowToken != null) {
                this.mAppWindowToken.notifyAppStopped();
            }
            if (this.finishing) {
                this.clearOptionsLocked();
            } else if (this.deferRelaunchUntilPaused) {
                ((ActivityStack)stack).destroyActivityLocked(this, true, "stop-config");
                this.mRootActivityContainer.resumeFocusedStacksTopActivities();
            } else {
                this.mRootActivityContainer.updatePreviousProcess(this);
            }
        }
    }

    void startLaunchTickingLocked() {
        if (Build.IS_USER) {
            return;
        }
        if (this.launchTickTime == 0L) {
            this.launchTickTime = SystemClock.uptimeMillis();
            this.continueLaunchTickingLocked();
        }
    }

    boolean continueLaunchTickingLocked() {
        if (this.launchTickTime == 0L) {
            return false;
        }
        Object stack = this.getActivityStack();
        if (stack == null) {
            return false;
        }
        Message msg = ((ActivityStack)stack).mHandler.obtainMessage(103, this);
        ((ActivityStack)stack).mHandler.removeMessages(103);
        ((ActivityStack)stack).mHandler.sendMessageDelayed(msg, 500L);
        return true;
    }

    void finishLaunchTickingLocked() {
        this.launchTickTime = 0L;
        Object stack = this.getActivityStack();
        if (stack != null) {
            ((ActivityStack)stack).mHandler.removeMessages(103);
        }
    }

    public boolean mayFreezeScreenLocked(WindowProcessController app) {
        return this.hasProcess() && !app.isCrashing() && !app.isNotResponding();
    }

    public void startFreezingScreenLocked(WindowProcessController app, int configChanges) {
        if (this.mayFreezeScreenLocked(app)) {
            if (this.mAppWindowToken == null) {
                Slog.w("WindowManager", "Attempted to freeze screen with non-existing app token: " + this.appToken);
                return;
            }
            int freezableConfigChanges = configChanges & 0xDFFFFFFF;
            if (freezableConfigChanges == 0 && this.mAppWindowToken.okToDisplay()) {
                return;
            }
            this.mAppWindowToken.startFreezingScreen();
        }
    }

    public void stopFreezingScreenLocked(boolean force) {
        if (force || this.frozenBeforeDestroy) {
            this.frozenBeforeDestroy = false;
            if (this.mAppWindowToken == null) {
                return;
            }
            this.mAppWindowToken.stopFreezingScreen(true, force);
        }
    }

    public void reportFullyDrawnLocked(boolean restoredFromBundle) {
        ActivityMetricsLogger.WindowingModeTransitionInfoSnapshot info = this.mStackSupervisor.getActivityMetricsLogger().logAppTransitionReportedDrawn(this, restoredFromBundle);
        if (info != null) {
            this.mStackSupervisor.reportActivityLaunchedLocked(false, this, info.windowsFullyDrawnDelayMs, info.getLaunchState());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onStartingWindowDrawn(long timestamp) {
        WindowManagerGlobalLock windowManagerGlobalLock = this.mAtmService.mGlobalLock;
        synchronized (windowManagerGlobalLock) {
            try {
                WindowManagerService.boostPriorityForLockedSection();
                this.mStackSupervisor.getActivityMetricsLogger().notifyStartingWindowDrawn(this.getWindowingMode(), timestamp);
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl9 : MonitorExitStatement: MONITOREXIT : var3_2
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        WindowManagerService.resetPriorityAfterLockedSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void onWindowsDrawn(boolean drawn, long timestamp) {
        block5: {
            WindowManagerGlobalLock windowManagerGlobalLock = this.mAtmService.mGlobalLock;
            // MONITORENTER : windowManagerGlobalLock
            try {
                WindowManagerService.boostPriorityForLockedSection();
                this.mDrawn = drawn;
                if (drawn) break block5;
                // MONITOREXIT : windowManagerGlobalLock
            }
            catch (Throwable throwable) {
                // MONITOREXIT : windowManagerGlobalLock
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
            WindowManagerService.resetPriorityAfterLockedSection();
            return;
        }
        ActivityMetricsLogger.WindowingModeTransitionInfoSnapshot info = this.mStackSupervisor.getActivityMetricsLogger().notifyWindowsDrawn(this.getWindowingMode(), timestamp);
        int windowsDrawnDelayMs = info != null ? info.windowsDrawnDelayMs : -1;
        int launchState = info != null ? info.getLaunchState() : -1;
        this.mStackSupervisor.reportActivityLaunchedLocked(false, this, windowsDrawnDelayMs, launchState);
        this.mStackSupervisor.stopWaitingForActivityVisible(this);
        this.finishLaunchTickingLocked();
        if (this.task != null) {
            this.task.hasBeenVisible = true;
        }
        // MONITOREXIT : windowManagerGlobalLock
        WindowManagerService.resetPriorityAfterLockedSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onWindowsVisible() {
        WindowManagerGlobalLock windowManagerGlobalLock = this.mAtmService.mGlobalLock;
        synchronized (windowManagerGlobalLock) {
            try {
                WindowManagerService.boostPriorityForLockedSection();
                this.mStackSupervisor.stopWaitingForActivityVisible(this);
                if (!this.nowVisible) {
                    this.nowVisible = true;
                    this.lastVisibleTime = SystemClock.uptimeMillis();
                    this.mAtmService.scheduleAppGcsLocked();
                }
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl13 : MonitorExitStatement: MONITOREXIT : var1_1
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        WindowManagerService.resetPriorityAfterLockedSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onWindowsGone() {
        WindowManagerGlobalLock windowManagerGlobalLock = this.mAtmService.mGlobalLock;
        synchronized (windowManagerGlobalLock) {
            try {
                WindowManagerService.boostPriorityForLockedSection();
                this.nowVisible = false;
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl9 : MonitorExitStatement: MONITOREXIT : var1_1
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        WindowManagerService.resetPriorityAfterLockedSection();
    }

    void onAnimationFinished() {
        if (this.mRootActivityContainer.allResumedActivitiesIdle() || this.mStackSupervisor.isStoppingNoHistoryActivity()) {
            if (this.mStackSupervisor.mStoppingActivities.contains(this)) {
                this.mStackSupervisor.scheduleIdleLocked();
            }
        } else {
            this.mStackSupervisor.processStoppingActivitiesLocked(null, false, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean keyDispatchingTimedOut(String reason, int windowPid) {
        boolean windowFromSameProcessAsActivity;
        WindowProcessController anrApp;
        ActivityRecord anrActivity;
        WindowManagerGlobalLock windowManagerGlobalLock = this.mAtmService.mGlobalLock;
        synchronized (windowManagerGlobalLock) {
            try {
                WindowManagerService.boostPriorityForLockedSection();
                anrActivity = this.getWaitingHistoryRecordLocked();
                anrApp = this.app;
                windowFromSameProcessAsActivity = !this.hasProcess() || this.app.getPid() == windowPid || windowPid == -1;
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl11 : MonitorExitStatement: MONITOREXIT : var6_3
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        WindowManagerService.resetPriorityAfterLockedSection();
        if (windowFromSameProcessAsActivity) {
            return this.mAtmService.mAmInternal.inputDispatchingTimedOut(anrApp.mOwner, anrActivity.shortComponentName, anrActivity.appInfo, this.shortComponentName, this.app, false, reason);
        }
        return this.mAtmService.mAmInternal.inputDispatchingTimedOut(windowPid, false, reason) < 0L;
    }

    private ActivityRecord getWaitingHistoryRecordLocked() {
        if (this.stopped) {
            ActivityStack stack = this.mRootActivityContainer.getTopDisplayFocusedStack();
            ActivityRecord r = stack.getResumedActivity();
            if (r == null) {
                r = stack.mPausingActivity;
            }
            if (r != null) {
                return r;
            }
        }
        return this;
    }

    public boolean okToShowLocked() {
        if (!StorageManager.isUserKeyUnlocked(this.mUserId) && !this.info.applicationInfo.isEncryptionAware()) {
            return false;
        }
        return (this.info.flags & 0x400) != 0 || this.mStackSupervisor.isCurrentProfileLocked(this.mUserId) && this.mAtmService.mAmInternal.isUserRunning(this.mUserId, 0);
    }

    public boolean isInterestingToUserLocked() {
        return this.visible || this.nowVisible || this.mState == ActivityStack.ActivityState.PAUSING || this.mState == ActivityStack.ActivityState.RESUMED;
    }

    void setSleeping(boolean _sleeping) {
        this.setSleeping(_sleeping, false);
    }

    void setSleeping(boolean _sleeping, boolean force) {
        if (!force && this.sleeping == _sleeping) {
            return;
        }
        if (this.attachedToProcess()) {
            try {
                this.app.getThread().scheduleSleeping(this.appToken, _sleeping);
                if (_sleeping && !this.mStackSupervisor.mGoingToSleepActivities.contains(this)) {
                    this.mStackSupervisor.mGoingToSleepActivities.add(this);
                }
                this.sleeping = _sleeping;
            }
            catch (RemoteException e) {
                Slog.w("ActivityTaskManager", "Exception thrown when sleeping: " + this.intent.getComponent(), e);
            }
        }
    }

    static int getTaskForActivityLocked(IBinder token, boolean onlyRoot) {
        ActivityRecord r = ActivityRecord.forTokenLocked(token);
        if (r == null) {
            return -1;
        }
        TaskRecord task = r.task;
        int activityNdx = task.mActivities.indexOf(r);
        if (activityNdx < 0 || onlyRoot && activityNdx > task.findEffectiveRootIndex()) {
            return -1;
        }
        return task.taskId;
    }

    static ActivityRecord isInStackLocked(IBinder token) {
        ActivityRecord r = ActivityRecord.forTokenLocked(token);
        return r != null ? ((ActivityStack)r.getActivityStack()).isInStackLocked(r) : null;
    }

    static ActivityStack getStackLocked(IBinder token) {
        ActivityRecord r = ActivityRecord.isInStackLocked(token);
        if (r != null) {
            return r.getActivityStack();
        }
        return null;
    }

    int getDisplayId() {
        Object stack = this.getActivityStack();
        if (stack == null) {
            return -1;
        }
        return ((ActivityStack)stack).mDisplayId;
    }

    final boolean isDestroyable() {
        if (this.finishing || !this.hasProcess()) {
            return false;
        }
        Object stack = this.getActivityStack();
        if (stack == null || this == ((ActivityStack)stack).getResumedActivity() || this == ((ActivityStack)stack).mPausingActivity || !this.haveState || !this.stopped) {
            return false;
        }
        return !this.visible;
    }

    private static String createImageFilename(long createTime, int taskId) {
        return String.valueOf(taskId) + ACTIVITY_ICON_SUFFIX + createTime + ".png";
    }

    void setTaskDescription(ActivityManager.TaskDescription _taskDescription) {
        Bitmap icon;
        if (_taskDescription.getIconFilename() == null && (icon = _taskDescription.getIcon()) != null) {
            String iconFilename = ActivityRecord.createImageFilename(this.createTime, this.task.taskId);
            File iconFile = new File(TaskPersister.getUserImagesDir(this.task.userId), iconFilename);
            String iconFilePath = iconFile.getAbsolutePath();
            this.mAtmService.getRecentTasks().saveImage(icon, iconFilePath);
            _taskDescription.setIconFilename(iconFilePath);
        }
        this.taskDescription = _taskDescription;
    }

    void setVoiceSessionLocked(IVoiceInteractionSession session) {
        this.voiceSession = session;
        this.pendingVoiceInteractionStart = false;
    }

    void clearVoiceSessionLocked() {
        this.voiceSession = null;
        this.pendingVoiceInteractionStart = false;
    }

    void showStartingWindow(ActivityRecord prev, boolean newTask, boolean taskSwitch) {
        this.showStartingWindow(prev, newTask, taskSwitch, false);
    }

    void showStartingWindow(ActivityRecord prev, boolean newTask, boolean taskSwitch, boolean fromRecents) {
        if (this.mAppWindowToken == null) {
            return;
        }
        if (this.mTaskOverlay) {
            return;
        }
        if (this.pendingOptions != null && this.pendingOptions.getAnimationType() == 5) {
            return;
        }
        CompatibilityInfo compatInfo = this.mAtmService.compatibilityInfoForPackageLocked(this.info.applicationInfo);
        boolean shown = this.addStartingWindow(this.packageName, this.theme, compatInfo, this.nonLocalizedLabel, this.labelRes, this.icon, this.logo, this.windowFlags, prev != null ? prev.appToken : null, newTask, taskSwitch, this.isProcessRunning(), this.allowTaskSnapshot(), this.mState.ordinal() >= ActivityStack.ActivityState.RESUMED.ordinal() && this.mState.ordinal() <= ActivityStack.ActivityState.STOPPED.ordinal(), fromRecents);
        if (shown) {
            this.mStartingWindowState = 1;
        }
    }

    void removeOrphanedStartingWindow(boolean behindFullscreenActivity) {
        if (this.mStartingWindowState == 1 && behindFullscreenActivity) {
            this.mStartingWindowState = 2;
            this.mAppWindowToken.removeStartingWindow();
        }
    }

    void setRequestedOrientation(int requestedOrientation) {
        this.setOrientation(requestedOrientation, this.mayFreezeScreenLocked(this.app));
        this.mAtmService.getTaskChangeNotificationController().notifyActivityRequestedOrientationChanged(this.task.taskId, requestedOrientation);
    }

    private void setOrientation(int requestedOrientation, boolean freezeScreenIfNeeded) {
        if (this.mAppWindowToken == null) {
            Slog.w("WindowManager", "Attempted to set orientation of non-existing app token: " + this.appToken);
            return;
        }
        IBinder binder = freezeScreenIfNeeded && this.appToken != null ? this.appToken.asBinder() : null;
        this.mAppWindowToken.setOrientation(requestedOrientation, binder, this);
        if (!this.getMergedOverrideConfiguration().equals(this.mLastReportedConfiguration.getMergedConfiguration())) {
            this.ensureActivityConfiguration(0, false);
        }
    }

    int getOrientation() {
        if (this.mAppWindowToken == null) {
            return this.info.screenOrientation;
        }
        return this.mAppWindowToken.getOrientationIgnoreVisibility();
    }

    void setDisablePreviewScreenshots(boolean disable) {
        if (this.mAppWindowToken == null) {
            Slog.w("WindowManager", "Attempted to set disable screenshots of non-existing app token: " + this.appToken);
            return;
        }
        this.mAppWindowToken.setDisablePreviewScreenshots(disable);
    }

    void setLastReportedGlobalConfiguration(Configuration config) {
        this.mLastReportedConfiguration.setGlobalConfiguration(config);
    }

    void setLastReportedConfiguration(MergedConfiguration config) {
        this.setLastReportedConfiguration(config.getGlobalConfiguration(), config.getOverrideConfiguration());
    }

    private void setLastReportedConfiguration(Configuration global, Configuration override) {
        this.mLastReportedConfiguration.setConfiguration(global, override);
    }

    int getRequestedConfigurationOrientation() {
        int screenOrientation = this.getOrientation();
        if (screenOrientation == 5) {
            ActivityDisplay display = this.getDisplay();
            if (display != null && display.mDisplayContent != null) {
                return display.mDisplayContent.getNaturalOrientation();
            }
        } else {
            if (screenOrientation == 14) {
                return this.getConfiguration().orientation;
            }
            if (ActivityInfo.isFixedOrientationLandscape(screenOrientation)) {
                return 2;
            }
            if (ActivityInfo.isFixedOrientationPortrait(screenOrientation)) {
                return 1;
            }
        }
        return 0;
    }

    boolean inSizeCompatMode() {
        float parentAspectRatio;
        float aspectRatio;
        if (!this.shouldUseSizeCompatMode()) {
            return false;
        }
        Configuration resolvedConfig = this.getResolvedOverrideConfiguration();
        Rect resolvedAppBounds = resolvedConfig.windowConfiguration.getAppBounds();
        if (resolvedAppBounds == null) {
            return false;
        }
        Configuration parentConfig = this.getParent().getConfiguration();
        if (parentConfig.densityDpi != resolvedConfig.densityDpi) {
            return true;
        }
        Rect parentAppBounds = parentConfig.windowConfiguration.getAppBounds();
        int appWidth = resolvedAppBounds.width();
        int appHeight = resolvedAppBounds.height();
        int parentAppWidth = parentAppBounds.width();
        int parentAppHeight = parentAppBounds.height();
        if (parentAppWidth == appWidth && parentAppHeight == appHeight) {
            return false;
        }
        if (parentAppWidth > appWidth && parentAppHeight > appHeight) {
            return true;
        }
        if (parentAppWidth < appWidth || parentAppHeight < appHeight) {
            return true;
        }
        if (this.info.maxAspectRatio > 0.0f && (aspectRatio = (0.5f + (float)Math.max(appWidth, appHeight)) / (float)Math.min(appWidth, appHeight)) >= this.info.maxAspectRatio) {
            return false;
        }
        return !(this.info.minAspectRatio > 0.0f) || !((parentAspectRatio = (0.5f + (float)Math.max(parentAppWidth, parentAppHeight)) / (float)Math.min(parentAppWidth, parentAppHeight)) <= this.info.minAspectRatio);
    }

    boolean shouldUseSizeCompatMode() {
        return !this.isResizeable() && (this.info.isFixedOrientation() || this.info.hasFixedAspectRatio()) && this.isActivityTypeStandard() && !this.mAtmService.mForceResizableActivities;
    }

    private void updateOverrideConfiguration() {
        Configuration overrideConfig = this.mTmpConfig;
        if (this.shouldUseSizeCompatMode()) {
            if (this.mCompatDisplayInsets != null) {
                return;
            }
            Configuration parentConfig = this.getParent().getConfiguration();
            if (!this.hasProcess() && !this.isConfigurationCompatible(parentConfig)) {
                return;
            }
            overrideConfig.unset();
            overrideConfig.colorMode = parentConfig.colorMode;
            overrideConfig.densityDpi = parentConfig.densityDpi;
            overrideConfig.screenLayout = parentConfig.screenLayout & 0x3F;
            overrideConfig.smallestScreenWidthDp = parentConfig.smallestScreenWidthDp;
            ActivityDisplay display = this.getDisplay();
            if (display != null && display.mDisplayContent != null) {
                this.mCompatDisplayInsets = new CompatDisplayInsets(display.mDisplayContent);
            }
        } else {
            this.computeBounds(this.mTmpBounds, this.getParent().getWindowConfiguration().getAppBounds());
            if (this.mTmpBounds.equals(this.getRequestedOverrideBounds())) {
                return;
            }
            overrideConfig.unset();
            overrideConfig.windowConfiguration.setBounds(this.mTmpBounds);
        }
        this.onRequestedOverrideConfigurationChanged(overrideConfig);
    }

    @Override
    void resolveOverrideConfiguration(Configuration newParentConfiguration) {
        if (this.mCompatDisplayInsets != null) {
            this.resolveSizeCompatModeConfiguration(newParentConfiguration);
        } else {
            super.resolveOverrideConfiguration(newParentConfiguration);
            if (!this.matchParentBounds()) {
                this.task.computeConfigResourceOverrides(this.getResolvedOverrideConfiguration(), newParentConfiguration);
            }
        }
        this.getResolvedOverrideConfiguration().seq = this.mConfigurationSeq = Math.max(++this.mConfigurationSeq, 1);
    }

    private void resolveSizeCompatModeConfiguration(Configuration newParentConfiguration) {
        Configuration resolvedConfig = this.getResolvedOverrideConfiguration();
        Rect resolvedBounds = resolvedConfig.windowConfiguration.getBounds();
        int parentRotation = newParentConfiguration.windowConfiguration.getRotation();
        int orientation = this.getConfiguration().orientation;
        int parentOrientation = newParentConfiguration.orientation;
        if (orientation != parentOrientation && this.isConfigurationCompatible(newParentConfiguration)) {
            orientation = parentOrientation;
        } else {
            if (!resolvedBounds.isEmpty() && this.getWindowConfiguration().getRotation() == parentRotation) {
                return;
            }
            int requestedOrientation = this.getRequestedConfigurationOrientation();
            if (requestedOrientation != 0) {
                orientation = requestedOrientation;
            }
        }
        super.resolveOverrideConfiguration(newParentConfiguration);
        boolean useParentOverrideBounds = false;
        Rect displayBounds = this.mTmpBounds;
        Rect containingAppBounds = new Rect();
        if (this.task.handlesOrientationChangeFromDescendant()) {
            this.mCompatDisplayInsets.getDisplayBoundsByOrientation(displayBounds, orientation);
        } else {
            int baseOrientation = this.task.getParent().getConfiguration().orientation;
            this.mCompatDisplayInsets.getDisplayBoundsByOrientation(displayBounds, baseOrientation);
            this.task.computeFullscreenBounds(containingAppBounds, this, displayBounds, baseOrientation);
            useParentOverrideBounds = !containingAppBounds.isEmpty();
        }
        int containingOffsetX = containingAppBounds.left;
        int containingOffsetY = containingAppBounds.top;
        if (!useParentOverrideBounds) {
            containingAppBounds.set(displayBounds);
        }
        if (parentRotation != -1) {
            TaskRecord.intersectWithInsetsIfFits(containingAppBounds, displayBounds, this.mCompatDisplayInsets.mNonDecorInsets[parentRotation]);
        }
        this.computeBounds(resolvedBounds, containingAppBounds);
        if (resolvedBounds.isEmpty()) {
            resolvedBounds.set(useParentOverrideBounds ? containingAppBounds : displayBounds);
        } else {
            resolvedBounds.left += containingOffsetX;
            resolvedBounds.top += containingOffsetY;
        }
        this.task.computeConfigResourceOverrides(resolvedConfig, newParentConfiguration, this.mCompatDisplayInsets);
        Rect resolvedAppBounds = resolvedConfig.windowConfiguration.getAppBounds();
        Rect parentAppBounds = newParentConfiguration.windowConfiguration.getAppBounds();
        if (resolvedBounds.width() < parentAppBounds.width()) {
            resolvedBounds.right -= resolvedAppBounds.left;
        }
        if (resolvedConfig.screenWidthDp == resolvedConfig.screenHeightDp) {
            resolvedConfig.orientation = newParentConfiguration.orientation;
        }
    }

    @Override
    public void onConfigurationChanged(Configuration newParentConfig) {
        ActivityDisplay display;
        super.onConfigurationChanged(newParentConfig);
        if (this.getMergedOverrideConfiguration().seq != this.getResolvedOverrideConfiguration().seq) {
            this.onMergedOverrideConfigurationChanged();
        }
        if (this.mAppWindowToken == null) {
            return;
        }
        Configuration appWindowTokenRequestedOverrideConfig = this.mAppWindowToken.getRequestedOverrideConfiguration();
        if (appWindowTokenRequestedOverrideConfig.seq != this.getResolvedOverrideConfiguration().seq) {
            appWindowTokenRequestedOverrideConfig.seq = this.getResolvedOverrideConfiguration().seq;
            this.mAppWindowToken.onMergedOverrideConfigurationChanged();
        }
        if ((display = this.getDisplay()) == null) {
            return;
        }
        if (this.visible) {
            display.handleActivitySizeCompatModeIfNeeded(this);
        } else if (this.shouldUseSizeCompatMode()) {
            boolean hasNonOrienSizeChanged;
            int displayChanges = display.getLastOverrideConfigurationChanges();
            int orientationChanges = 536872064;
            boolean bl = hasNonOrienSizeChanged = ActivityRecord.hasResizeChange(displayChanges) && (displayChanges & 0x20000480) != 536872064;
            if (hasNonOrienSizeChanged || (displayChanges & 0x1000) != 0) {
                this.restartProcessIfVisible();
            }
        }
    }

    boolean isConfigurationCompatible(Configuration config) {
        int orientation = this.getOrientation();
        if (ActivityInfo.isFixedOrientationPortrait(orientation) && config.orientation != 1) {
            return false;
        }
        return !ActivityInfo.isFixedOrientationLandscape(orientation) || config.orientation == 2;
    }

    private void computeBounds(Rect outBounds, Rect containingAppBounds) {
        outBounds.setEmpty();
        float maxAspectRatio = this.info.maxAspectRatio;
        Object stack = this.getActivityStack();
        float minAspectRatio = this.info.minAspectRatio;
        if (this.task == null || stack == null || this.task.inMultiWindowMode() || maxAspectRatio == 0.0f && minAspectRatio == 0.0f || ActivityRecord.isInVrUiMode(this.getConfiguration())) {
            return;
        }
        int containingAppWidth = containingAppBounds.width();
        int containingAppHeight = containingAppBounds.height();
        float containingRatio = (float)Math.max(containingAppWidth, containingAppHeight) / (float)Math.min(containingAppWidth, containingAppHeight);
        int activityWidth = containingAppWidth;
        int activityHeight = containingAppHeight;
        if (containingRatio > maxAspectRatio && maxAspectRatio != 0.0f) {
            if (containingAppWidth < containingAppHeight) {
                activityHeight = (int)((float)activityWidth * maxAspectRatio + 0.5f);
            } else {
                activityWidth = (int)((float)activityHeight * maxAspectRatio + 0.5f);
            }
        } else if (containingRatio < minAspectRatio) {
            boolean adjustWidth;
            switch (this.getRequestedConfigurationOrientation()) {
                case 2: {
                    adjustWidth = false;
                    break;
                }
                case 1: {
                    adjustWidth = true;
                    break;
                }
                default: {
                    adjustWidth = containingAppWidth < containingAppHeight;
                }
            }
            if (adjustWidth) {
                activityWidth = (int)((float)activityHeight / minAspectRatio + 0.5f);
            } else {
                activityHeight = (int)((float)activityWidth / minAspectRatio + 0.5f);
            }
        }
        if (containingAppWidth <= activityWidth && containingAppHeight <= activityHeight) {
            outBounds.set(this.getRequestedOverrideBounds());
            return;
        }
        outBounds.set(0, 0, activityWidth + containingAppBounds.left, activityHeight + containingAppBounds.top);
    }

    boolean shouldUpdateConfigForDisplayChanged() {
        return this.mLastReportedDisplayId != this.getDisplayId();
    }

    boolean ensureActivityConfiguration(int globalChanges, boolean preserveWindow) {
        return this.ensureActivityConfiguration(globalChanges, preserveWindow, false);
    }

    boolean ensureActivityConfiguration(int globalChanges, boolean preserveWindow, boolean ignoreStopState) {
        boolean displayChanged;
        Object stack = this.getActivityStack();
        if (((ActivityStack)stack).mConfigWillChange) {
            return true;
        }
        if (this.finishing) {
            this.stopFreezingScreenLocked(false);
            return true;
        }
        if (!(ignoreStopState || this.mState != ActivityStack.ActivityState.STOPPING && this.mState != ActivityStack.ActivityState.STOPPED)) {
            return true;
        }
        if (!this.shouldBeVisible()) {
            return true;
        }
        int newDisplayId = this.getDisplayId();
        boolean bl = displayChanged = this.mLastReportedDisplayId != newDisplayId;
        if (displayChanged) {
            this.mLastReportedDisplayId = newDisplayId;
        }
        this.updateOverrideConfiguration();
        this.mTmpConfig.setTo(this.mLastReportedConfiguration.getMergedConfiguration());
        if (this.getConfiguration().equals(this.mTmpConfig) && !this.forceNewConfig && !displayChanged) {
            return true;
        }
        int changes = this.getConfigurationChanges(this.mTmpConfig);
        Configuration newMergedOverrideConfig = this.getMergedOverrideConfiguration();
        this.setLastReportedConfiguration(this.mAtmService.getGlobalConfiguration(), newMergedOverrideConfig);
        if (this.mState == ActivityStack.ActivityState.INITIALIZING) {
            return true;
        }
        if (changes == 0 && !this.forceNewConfig) {
            if (displayChanged) {
                this.scheduleActivityMovedToDisplay(newDisplayId, newMergedOverrideConfig);
            } else {
                this.scheduleConfigurationChanged(newMergedOverrideConfig);
            }
            return true;
        }
        if (!this.attachedToProcess()) {
            this.stopFreezingScreenLocked(false);
            this.forceNewConfig = false;
            return true;
        }
        if (this.shouldRelaunchLocked(changes, this.mTmpConfig) || this.forceNewConfig) {
            boolean isDragResizing;
            this.configChangeFlags |= changes;
            this.startFreezingScreenLocked(this.app, globalChanges);
            this.forceNewConfig = false;
            preserveWindow &= ActivityRecord.isResizeOnlyChange(changes);
            boolean hasResizeChange = ActivityRecord.hasResizeChange(changes & ~this.info.getRealConfigChanged());
            this.mRelaunchReason = hasResizeChange ? ((isDragResizing = this.getTaskRecord().getTask().isDragResizing()) ? 2 : 1) : 0;
            if (!this.attachedToProcess()) {
                ((ActivityStack)stack).destroyActivityLocked(this, true, "config");
            } else {
                if (this.mState == ActivityStack.ActivityState.PAUSING) {
                    this.deferRelaunchUntilPaused = true;
                    this.preserveWindowOnDeferredRelaunch = preserveWindow;
                    return true;
                }
                if (this.mState == ActivityStack.ActivityState.RESUMED) {
                    this.relaunchActivityLocked(true, preserveWindow);
                } else {
                    this.relaunchActivityLocked(false, preserveWindow);
                }
            }
            return false;
        }
        if (displayChanged) {
            this.scheduleActivityMovedToDisplay(newDisplayId, newMergedOverrideConfig);
        } else {
            this.scheduleConfigurationChanged(newMergedOverrideConfig);
        }
        this.stopFreezingScreenLocked(false);
        return true;
    }

    private boolean shouldRelaunchLocked(int changes, Configuration changesConfig) {
        int configChanged = this.info.getRealConfigChanged();
        boolean onlyVrUiModeChanged = this.onlyVrUiModeChanged(changes, changesConfig);
        if (this.appInfo.targetSdkVersion < 26 && this.requestedVrComponent != null && onlyVrUiModeChanged) {
            configChanged |= 0x200;
        }
        return (changes & ~configChanged) != 0;
    }

    private boolean onlyVrUiModeChanged(int changes, Configuration lastReportedConfig) {
        Configuration currentConfig = this.getConfiguration();
        return changes == 512 && ActivityRecord.isInVrUiMode(currentConfig) != ActivityRecord.isInVrUiMode(lastReportedConfig);
    }

    private int getConfigurationChanges(Configuration lastReportedConfig) {
        int newSmallest;
        int oldSmallest;
        Configuration currentConfig = this.getConfiguration();
        int changes = lastReportedConfig.diff(currentConfig);
        if ((changes & 0x400) != 0) {
            boolean crosses;
            boolean bl = crosses = this.crossesHorizontalSizeThreshold(lastReportedConfig.screenWidthDp, currentConfig.screenWidthDp) || this.crossesVerticalSizeThreshold(lastReportedConfig.screenHeightDp, currentConfig.screenHeightDp);
            if (!crosses) {
                changes &= 0xFFFFFBFF;
            }
        }
        if ((changes & 0x800) != 0 && !this.crossesSmallestSizeThreshold(oldSmallest = lastReportedConfig.smallestScreenWidthDp, newSmallest = currentConfig.smallestScreenWidthDp)) {
            changes &= 0xFFFFF7FF;
        }
        if ((changes & 0x20000000) != 0) {
            changes &= 0xDFFFFFFF;
        }
        return changes;
    }

    private static boolean isResizeOnlyChange(int change) {
        return (change & 0xFFFFF27F) == 0;
    }

    private static boolean hasResizeChange(int change) {
        return (change & 0xD80) != 0;
    }

    void relaunchActivityLocked(boolean andResume, boolean preserveWindow) {
        if (this.mAtmService.mSuppressResizeConfigChanges && preserveWindow) {
            this.configChangeFlags = 0;
            return;
        }
        ArrayList<ResultInfo> pendingResults = null;
        ArrayList<ReferrerIntent> pendingNewIntents = null;
        if (andResume) {
            pendingResults = this.results;
            pendingNewIntents = this.newIntents;
        }
        EventLog.writeEvent(andResume ? 30019 : 30020, this.mUserId, System.identityHashCode(this), this.task.taskId, this.shortComponentName);
        this.startFreezingScreenLocked(this.app, 0);
        try {
            this.forceNewConfig = false;
            this.mStackSupervisor.activityRelaunchingLocked(this);
            ActivityRelaunchItem callbackItem = ActivityRelaunchItem.obtain(pendingResults, pendingNewIntents, this.configChangeFlags, new MergedConfiguration(this.mAtmService.getGlobalConfiguration(), this.getMergedOverrideConfiguration()), preserveWindow);
            ActivityLifecycleItem lifecycleItem = andResume ? ResumeActivityItem.obtain(this.getDisplay().mDisplayContent.isNextTransitionForward()) : PauseActivityItem.obtain();
            ClientTransaction transaction = ClientTransaction.obtain(this.app.getThread(), this.appToken);
            transaction.addCallback(callbackItem);
            transaction.setLifecycleStateRequest(lifecycleItem);
            this.mAtmService.getLifecycleManager().scheduleTransaction(transaction);
        }
        catch (RemoteException callbackItem) {
            // empty catch block
        }
        if (andResume) {
            this.results = null;
            this.newIntents = null;
            this.mAtmService.getAppWarningsLocked().onResumeActivity(this);
        } else {
            Object stack = this.getActivityStack();
            if (stack != null) {
                ((ActivityStack)stack).mHandler.removeMessages(101, this);
            }
            this.setState(ActivityStack.ActivityState.PAUSED, "relaunchActivityLocked");
        }
        this.configChangeFlags = 0;
        this.deferRelaunchUntilPaused = false;
        this.preserveWindowOnDeferredRelaunch = false;
    }

    void restartProcessIfVisible() {
        Slog.i("ActivityTaskManager", "Request to restart process of " + this);
        this.getRequestedOverrideConfiguration().unset();
        this.getResolvedOverrideConfiguration().unset();
        this.mCompatDisplayInsets = null;
        if (this.visible) {
            this.updateOverrideConfiguration();
        }
        if (!this.attachedToProcess()) {
            return;
        }
        this.setState(ActivityStack.ActivityState.RESTARTING_PROCESS, "restartActivityProcess");
        if (!this.visible || this.haveState) {
            this.mAtmService.mH.post(() -> {
                block4: {
                    WindowManagerGlobalLock windowManagerGlobalLock = this.mAtmService.mGlobalLock;
                    // MONITORENTER : windowManagerGlobalLock
                    try {
                        WindowManagerService.boostPriorityForLockedSection();
                        if (this.hasProcess() && this.app.getReportedProcState() > 7) break block4;
                        // MONITOREXIT : windowManagerGlobalLock
                    }
                    catch (Throwable throwable) {
                        // MONITOREXIT : windowManagerGlobalLock
                        WindowManagerService.resetPriorityAfterLockedSection();
                        throw throwable;
                    }
                    WindowManagerService.resetPriorityAfterLockedSection();
                    return;
                }
                WindowProcessController wpc = this.app;
                // MONITOREXIT : windowManagerGlobalLock
                WindowManagerService.resetPriorityAfterLockedSection();
                this.mAtmService.mAmInternal.killProcess(wpc.mName, wpc.mUid, "resetConfig");
            });
            return;
        }
        if (this.mAppWindowToken != null) {
            this.mAppWindowToken.startFreezingScreen();
        }
        try {
            this.mAtmService.getLifecycleManager().scheduleTransaction(this.app.getThread(), (IBinder)this.appToken, StopActivityItem.obtain(false, 0));
        }
        catch (RemoteException e) {
            Slog.w("ActivityTaskManager", "Exception thrown during restart " + this, e);
        }
        this.mStackSupervisor.scheduleRestartTimeout(this);
    }

    private boolean isProcessRunning() {
        WindowProcessController proc = this.app;
        if (proc == null) {
            proc = this.mAtmService.mProcessNames.get(this.processName, this.info.applicationInfo.uid);
        }
        return proc != null && proc.hasThread();
    }

    private boolean allowTaskSnapshot() {
        if (this.newIntents == null) {
            return true;
        }
        for (int i = this.newIntents.size() - 1; i >= 0; --i) {
            Intent intent = this.newIntents.get(i);
            if (intent == null || ActivityRecord.isMainIntent(intent)) continue;
            return false;
        }
        return true;
    }

    boolean isNoHistory() {
        return (this.intent.getFlags() & 0x40000000) != 0 || (this.info.flags & 0x80) != 0;
    }

    void saveToXml(XmlSerializer out) throws IOException, XmlPullParserException {
        out.attribute(null, ATTR_ID, String.valueOf(this.createTime));
        out.attribute(null, ATTR_LAUNCHEDFROMUID, String.valueOf(this.launchedFromUid));
        if (this.launchedFromPackage != null) {
            out.attribute(null, ATTR_LAUNCHEDFROMPACKAGE, this.launchedFromPackage);
        }
        if (this.resolvedType != null) {
            out.attribute(null, ATTR_RESOLVEDTYPE, this.resolvedType);
        }
        out.attribute(null, ATTR_COMPONENTSPECIFIED, String.valueOf(this.componentSpecified));
        out.attribute(null, ATTR_USERID, String.valueOf(this.mUserId));
        if (this.taskDescription != null) {
            this.taskDescription.saveToXml(out);
        }
        out.startTag(null, TAG_INTENT);
        this.intent.saveToXml(out);
        out.endTag(null, TAG_INTENT);
        if (this.isPersistable() && this.persistentState != null) {
            out.startTag(null, TAG_PERSISTABLEBUNDLE);
            this.persistentState.saveToXml(out);
            out.endTag(null, TAG_PERSISTABLEBUNDLE);
        }
    }

    static ActivityRecord restoreFromXml(XmlPullParser in, ActivityStackSupervisor stackSupervisor) throws IOException, XmlPullParserException {
        int event;
        Intent intent = null;
        PersistableBundle persistentState = null;
        int launchedFromUid = 0;
        String launchedFromPackage = null;
        String resolvedType = null;
        boolean componentSpecified = false;
        int userId = 0;
        long createTime = -1L;
        int outerDepth = in.getDepth();
        ActivityManager.TaskDescription taskDescription = new ActivityManager.TaskDescription();
        for (int attrNdx = in.getAttributeCount() - 1; attrNdx >= 0; --attrNdx) {
            String attrName = in.getAttributeName(attrNdx);
            String attrValue = in.getAttributeValue(attrNdx);
            if (ATTR_ID.equals(attrName)) {
                createTime = Long.parseLong(attrValue);
                continue;
            }
            if (ATTR_LAUNCHEDFROMUID.equals(attrName)) {
                launchedFromUid = Integer.parseInt(attrValue);
                continue;
            }
            if (ATTR_LAUNCHEDFROMPACKAGE.equals(attrName)) {
                launchedFromPackage = attrValue;
                continue;
            }
            if (ATTR_RESOLVEDTYPE.equals(attrName)) {
                resolvedType = attrValue;
                continue;
            }
            if (ATTR_COMPONENTSPECIFIED.equals(attrName)) {
                componentSpecified = Boolean.parseBoolean(attrValue);
                continue;
            }
            if (ATTR_USERID.equals(attrName)) {
                userId = Integer.parseInt(attrValue);
                continue;
            }
            if (attrName.startsWith("task_description_")) {
                taskDescription.restoreFromXml(attrName, attrValue);
                continue;
            }
            Log.d("ActivityTaskManager", "Unknown ActivityRecord attribute=" + attrName);
        }
        while ((event = in.next()) != 1 && (event != 3 || in.getDepth() >= outerDepth)) {
            if (event != 2) continue;
            String name = in.getName();
            if (TAG_INTENT.equals(name)) {
                intent = Intent.restoreFromXml(in);
                continue;
            }
            if (TAG_PERSISTABLEBUNDLE.equals(name)) {
                persistentState = PersistableBundle.restoreFromXml(in);
                continue;
            }
            Slog.w("ActivityTaskManager", "restoreActivity: unexpected name=" + name);
            XmlUtils.skipCurrentTag(in);
        }
        if (intent == null) {
            throw new XmlPullParserException("restoreActivity error intent=" + intent);
        }
        ActivityTaskManagerService service = stackSupervisor.mService;
        ActivityInfo aInfo = stackSupervisor.resolveActivity(intent, resolvedType, 0, null, userId, Binder.getCallingUid());
        if (aInfo == null) {
            throw new XmlPullParserException("restoreActivity resolver error. Intent=" + intent + " resolvedType=" + resolvedType);
        }
        ActivityRecord r = new ActivityRecord(service, null, 0, launchedFromUid, launchedFromPackage, intent, resolvedType, aInfo, service.getConfiguration(), null, null, 0, componentSpecified, false, stackSupervisor, null, null);
        r.persistentState = persistentState;
        r.taskDescription = taskDescription;
        r.createTime = createTime;
        return r;
    }

    private static boolean isInVrUiMode(Configuration config) {
        return (config.uiMode & 0xF) == 7;
    }

    int getUid() {
        return this.info.applicationInfo.uid;
    }

    void setShowWhenLocked(boolean showWhenLocked) {
        this.mShowWhenLocked = showWhenLocked;
        this.mRootActivityContainer.ensureActivitiesVisible(null, 0, false);
    }

    void setInheritShowWhenLocked(boolean inheritShowWhenLocked) {
        this.mInheritShownWhenLocked = inheritShowWhenLocked;
        this.mRootActivityContainer.ensureActivitiesVisible(null, 0, false);
    }

    boolean canShowWhenLocked() {
        if (!this.inPinnedWindowingMode() && (this.mShowWhenLocked || this.mAppWindowToken != null && this.mAppWindowToken.containsShowWhenLockedWindow())) {
            return true;
        }
        if (this.mInheritShownWhenLocked) {
            ActivityRecord r = this.getActivityBelow();
            return r != null && !r.inPinnedWindowingMode() && (r.mShowWhenLocked || r.mAppWindowToken != null && r.mAppWindowToken.containsShowWhenLockedWindow());
        }
        return false;
    }

    private ActivityRecord getActivityBelow() {
        int pos = this.task.mActivities.indexOf(this);
        if (pos == -1) {
            throw new IllegalStateException("Activity not found in its task");
        }
        return pos == 0 ? null : this.task.getChildAt(pos - 1);
    }

    void setTurnScreenOn(boolean turnScreenOn) {
        this.mTurnScreenOn = turnScreenOn;
    }

    boolean canTurnScreenOn() {
        Object stack = this.getActivityStack();
        return this.mTurnScreenOn && stack != null && ((ActivityStack)stack).checkKeyguardVisibility(this, true, true);
    }

    boolean canResumeByCompat() {
        return this.app == null || this.app.updateTopResumingActivityInProcessIfNeeded(this);
    }

    boolean getTurnScreenOnFlag() {
        return this.mTurnScreenOn;
    }

    boolean isTopRunningActivity() {
        return this.mRootActivityContainer.topRunningActivity() == this;
    }

    boolean isResumedActivityOnDisplay() {
        ActivityDisplay display = this.getDisplay();
        return display != null && this == display.getResumedActivity();
    }

    void registerRemoteAnimations(RemoteAnimationDefinition definition) {
        if (this.mAppWindowToken == null) {
            Slog.w("WindowManager", "Attempted to register remote animations with non-existing app token: " + this.appToken);
            return;
        }
        this.mAppWindowToken.registerRemoteAnimations(definition);
    }

    public String toString() {
        if (this.stringName != null) {
            return this.stringName + " t" + (this.task == null ? -1 : this.task.taskId) + (this.finishing ? " f}" : "}");
        }
        StringBuilder sb = new StringBuilder(128);
        sb.append("ActivityRecord{");
        sb.append(Integer.toHexString(System.identityHashCode(this)));
        sb.append(" u");
        sb.append(this.mUserId);
        sb.append(' ');
        sb.append(this.intent.getComponent().flattenToShortString());
        this.stringName = sb.toString();
        return this.toString();
    }

    void writeIdentifierToProto(ProtoOutputStream proto, long fieldId) {
        long token = proto.start(fieldId);
        proto.write(0x10500000001L, System.identityHashCode(this));
        proto.write(1120986464258L, this.mUserId);
        proto.write(1138166333443L, this.intent.getComponent().flattenToShortString());
        proto.end(token);
    }

    void writeToProto(ProtoOutputStream proto) {
        super.writeToProto(proto, 0x10B00000001L, 0);
        this.writeIdentifierToProto(proto, 1146756268034L);
        proto.write(1138166333443L, this.mState.toString());
        proto.write(1133871366148L, this.visible);
        proto.write(1133871366149L, this.frontOfTask);
        if (this.hasProcess()) {
            proto.write(1120986464262L, this.app.getPid());
        }
        proto.write(1133871366151L, !this.fullscreen);
    }

    public void writeToProto(ProtoOutputStream proto, long fieldId) {
        long token = proto.start(fieldId);
        this.writeToProto(proto);
        proto.end(token);
    }

    static class CompatDisplayInsets {
        final int mDisplayWidth;
        final int mDisplayHeight;
        final Rect[] mNonDecorInsets = new Rect[4];
        final Rect[] mStableInsets = new Rect[4];

        CompatDisplayInsets(DisplayContent display) {
            this.mDisplayWidth = display.mBaseDisplayWidth;
            this.mDisplayHeight = display.mBaseDisplayHeight;
            DisplayPolicy policy = display.getDisplayPolicy();
            for (int rotation = 0; rotation < 4; ++rotation) {
                this.mNonDecorInsets[rotation] = new Rect();
                this.mStableInsets[rotation] = new Rect();
                boolean rotated = rotation == 1 || rotation == 3;
                int dw = rotated ? this.mDisplayHeight : this.mDisplayWidth;
                int dh = rotated ? this.mDisplayWidth : this.mDisplayHeight;
                DisplayCutout cutout = display.calculateDisplayCutoutForRotation(rotation).getDisplayCutout();
                policy.getNonDecorInsetsLw(rotation, dw, dh, cutout, this.mNonDecorInsets[rotation]);
                this.mStableInsets[rotation].set(this.mNonDecorInsets[rotation]);
                policy.convertNonDecorInsetsToStableInsets(this.mStableInsets[rotation], rotation);
            }
        }

        void getDisplayBoundsByRotation(Rect outBounds, int rotation) {
            boolean rotated = rotation == 1 || rotation == 3;
            int dw = rotated ? this.mDisplayHeight : this.mDisplayWidth;
            int dh = rotated ? this.mDisplayWidth : this.mDisplayHeight;
            outBounds.set(0, 0, dw, dh);
        }

        void getDisplayBoundsByOrientation(Rect outBounds, int orientation) {
            int longSide = Math.max(this.mDisplayWidth, this.mDisplayHeight);
            int shortSide = Math.min(this.mDisplayWidth, this.mDisplayHeight);
            boolean isLandscape = orientation == 2;
            outBounds.set(0, 0, isLandscape ? longSide : shortSide, isLandscape ? shortSide : longSide);
        }
    }

    static class Token
    extends IApplicationToken.Stub {
        private final WeakReference<ActivityRecord> weakActivity;
        private final String name;

        Token(ActivityRecord activity, Intent intent) {
            this.weakActivity = new WeakReference<ActivityRecord>(activity);
            this.name = intent.getComponent().flattenToShortString();
        }

        private static ActivityRecord tokenToActivityRecordLocked(Token token) {
            if (token == null) {
                return null;
            }
            ActivityRecord r = (ActivityRecord)token.weakActivity.get();
            if (r == null || r.getActivityStack() == null) {
                return null;
            }
            return r;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(128);
            sb.append("Token{");
            sb.append(Integer.toHexString(System.identityHashCode(this)));
            sb.append(' ');
            sb.append(this.weakActivity.get());
            sb.append('}');
            return sb.toString();
        }

        @Override
        public String getName() {
            return this.name;
        }
    }
}

