/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import com.android.server.wm.ActivityRecord;
import com.android.server.wm.ActivityStack;
import com.android.server.wm.ActivityTaskManagerService;
import com.android.server.wm.WindowManagerGlobalLock;
import com.android.server.wm.WindowManagerService;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.function.Consumer;

public class ActivityServiceConnectionsHolder<T> {
    private final ActivityTaskManagerService mService;
    private final ActivityRecord mActivity;
    private HashSet<T> mConnections;

    ActivityServiceConnectionsHolder(ActivityTaskManagerService service, ActivityRecord activity) {
        this.mService = service;
        this.mActivity = activity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnection(T c) {
        WindowManagerGlobalLock windowManagerGlobalLock = this.mService.mGlobalLock;
        synchronized (windowManagerGlobalLock) {
            try {
                WindowManagerService.boostPriorityForLockedSection();
                if (this.mConnections == null) {
                    this.mConnections = new HashSet();
                }
                this.mConnections.add(c);
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl12 : MonitorExitStatement: MONITOREXIT : var2_2
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        WindowManagerService.resetPriorityAfterLockedSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void removeConnection(T c) {
        block4: {
            WindowManagerGlobalLock windowManagerGlobalLock = this.mService.mGlobalLock;
            // MONITORENTER : windowManagerGlobalLock
            try {
                WindowManagerService.boostPriorityForLockedSection();
                if (this.mConnections != null) break block4;
                // MONITOREXIT : windowManagerGlobalLock
            }
            catch (Throwable throwable) {
                // MONITOREXIT : windowManagerGlobalLock
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
            WindowManagerService.resetPriorityAfterLockedSection();
            return;
        }
        this.mConnections.remove(c);
        // MONITOREXIT : windowManagerGlobalLock
        WindowManagerService.resetPriorityAfterLockedSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isActivityVisible() {
        boolean bl;
        WindowManagerGlobalLock windowManagerGlobalLock = this.mService.mGlobalLock;
        synchronized (windowManagerGlobalLock) {
            try {
                WindowManagerService.boostPriorityForLockedSection();
                bl = this.mActivity.visible || this.mActivity.isState(ActivityStack.ActivityState.RESUMED, ActivityStack.ActivityState.PAUSING);
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl9 : MonitorExitStatement: MONITOREXIT : windowManagerGlobalLock
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        WindowManagerService.resetPriorityAfterLockedSection();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getActivityPid() {
        int n;
        WindowManagerGlobalLock windowManagerGlobalLock = this.mService.mGlobalLock;
        synchronized (windowManagerGlobalLock) {
            try {
                WindowManagerService.boostPriorityForLockedSection();
                n = this.mActivity.hasProcess() ? this.mActivity.app.getPid() : -1;
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl9 : MonitorExitStatement: MONITOREXIT : windowManagerGlobalLock
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        WindowManagerService.resetPriorityAfterLockedSection();
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void forEachConnection(Consumer<T> consumer) {
        block5: {
            WindowManagerGlobalLock windowManagerGlobalLock = this.mService.mGlobalLock;
            // MONITORENTER : windowManagerGlobalLock
            WindowManagerService.boostPriorityForLockedSection();
            if (this.mConnections != null && !this.mConnections.isEmpty()) break block5;
            // MONITOREXIT : windowManagerGlobalLock
            WindowManagerService.resetPriorityAfterLockedSection();
            return;
        }
        try {
            for (T c : this.mConnections) {
                consumer.accept(c);
            }
            // MONITOREXIT : windowManagerGlobalLock
        }
        catch (Throwable throwable) {
            // MONITOREXIT : windowManagerGlobalLock
            WindowManagerService.resetPriorityAfterLockedSection();
            throw throwable;
        }
        WindowManagerService.resetPriorityAfterLockedSection();
    }

    void disconnectActivityFromServices() {
        if (this.mConnections == null || this.mConnections.isEmpty()) {
            return;
        }
        HashSet<T> disc = this.mConnections;
        this.mConnections = null;
        this.mService.mH.post(() -> this.mService.mAmInternal.disconnectActivityFromServices(this, disc));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump(PrintWriter pw, String prefix) {
        WindowManagerGlobalLock windowManagerGlobalLock = this.mService.mGlobalLock;
        synchronized (windowManagerGlobalLock) {
            try {
                WindowManagerService.boostPriorityForLockedSection();
                pw.println(prefix + "activity=" + this.mActivity);
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl9 : MonitorExitStatement: MONITOREXIT : var3_3
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        WindowManagerService.resetPriorityAfterLockedSection();
    }
}

