/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import android.app.ActivityManagerInternal;
import android.app.ActivityOptions;
import android.app.AppOpsManager;
import android.app.ProfilerInfo;
import android.app.ResultInfo;
import android.app.WaitResult;
import android.app.servertransaction.ActivityLifecycleItem;
import android.app.servertransaction.ClientTransaction;
import android.app.servertransaction.LaunchActivityItem;
import android.app.servertransaction.PauseActivityItem;
import android.app.servertransaction.ResumeActivityItem;
import android.content.ComponentName;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.pm.UserInfo;
import android.content.res.Configuration;
import android.graphics.Rect;
import android.os.Binder;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.PowerManager;
import android.os.RemoteException;
import android.os.SystemClock;
import android.os.Trace;
import android.os.UserManager;
import android.os.WorkSource;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.EventLog;
import android.util.MergedConfiguration;
import android.util.Slog;
import android.util.SparseArray;
import android.util.SparseIntArray;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.content.ReferrerIntent;
import com.android.internal.os.TransferPipe;
import com.android.internal.os.logging.MetricsLoggerWrapper;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.function.pooled.PooledLambda;
import com.android.server.am.UserState;
import com.android.server.wm.ActivityDisplay;
import com.android.server.wm.ActivityMetricsLogger;
import com.android.server.wm.ActivityRecord;
import com.android.server.wm.ActivityStack;
import com.android.server.wm.ActivityTaskManagerService;
import com.android.server.wm.ConfigurationContainer;
import com.android.server.wm.DisplayContent;
import com.android.server.wm.KeyguardController;
import com.android.server.wm.LaunchParamsController;
import com.android.server.wm.LaunchParamsPersister;
import com.android.server.wm.LockTaskController;
import com.android.server.wm.PersisterQueue;
import com.android.server.wm.RecentTasks;
import com.android.server.wm.RootActivityContainer;
import com.android.server.wm.RunningTasks;
import com.android.server.wm.SafeActivityOptions;
import com.android.server.wm.TaskRecord;
import com.android.server.wm.TaskStack;
import com.android.server.wm.WindowManagerGlobalLock;
import com.android.server.wm.WindowManagerService;
import com.android.server.wm.WindowProcessController;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;

public class ActivityStackSupervisor
implements RecentTasks.Callbacks {
    private static final String TAG = "ActivityTaskManager";
    private static final String TAG_IDLE = "ActivityTaskManager";
    private static final String TAG_PAUSE = "ActivityTaskManager";
    private static final String TAG_RECENTS = "ActivityTaskManager";
    private static final String TAG_STACK = "ActivityTaskManager";
    private static final String TAG_SWITCH = "ActivityTaskManager";
    static final String TAG_TASKS = "ActivityTaskManager";
    static final int IDLE_TIMEOUT = 10000;
    static final int SLEEP_TIMEOUT = 5000;
    static final int LAUNCH_TIMEOUT = 10000;
    static final int TOP_RESUMED_STATE_LOSS_TIMEOUT = 500;
    static final int IDLE_TIMEOUT_MSG = 200;
    static final int IDLE_NOW_MSG = 201;
    static final int RESUME_TOP_ACTIVITY_MSG = 202;
    static final int SLEEP_TIMEOUT_MSG = 203;
    static final int LAUNCH_TIMEOUT_MSG = 204;
    static final int LAUNCH_TASK_BEHIND_COMPLETE = 212;
    static final int RESTART_ACTIVITY_PROCESS_TIMEOUT_MSG = 213;
    static final int REPORT_MULTI_WINDOW_MODE_CHANGED_MSG = 214;
    static final int REPORT_PIP_MODE_CHANGED_MSG = 215;
    static final int REPORT_HOME_CHANGED_MSG = 216;
    static final int TOP_RESUMED_STATE_LOSS_TIMEOUT_MSG = 217;
    static final boolean PRESERVE_WINDOWS = true;
    static final boolean ON_TOP = true;
    static final boolean DEFER_RESUME = true;
    static final boolean REMOVE_FROM_RECENTS = true;
    static final boolean PAUSE_IMMEDIATELY = true;
    private boolean mDockedStackResizing;
    private boolean mHasPendingDockedBounds;
    private Rect mPendingDockedBounds;
    private Rect mPendingTempDockedTaskBounds;
    private Rect mPendingTempDockedTaskInsetBounds;
    private Rect mPendingTempOtherTaskBounds;
    private Rect mPendingTempOtherTaskInsetBounds;
    private static final ArrayMap<String, String> ACTION_TO_RUNTIME_PERMISSION = new ArrayMap();
    private static final int ACTIVITY_RESTRICTION_NONE = 0;
    private static final int ACTIVITY_RESTRICTION_PERMISSION = 1;
    private static final int ACTIVITY_RESTRICTION_APPOP = 2;
    static final boolean VALIDATE_WAKE_LOCK_CALLER = false;
    private static final int MAX_TASK_IDS_PER_USER = 100000;
    final ActivityTaskManagerService mService;
    RootActivityContainer mRootActivityContainer;
    RecentTasks mRecentTasks;
    RunningTasks mRunningTasks;
    final ActivityStackSupervisorHandler mHandler;
    final Looper mLooper;
    WindowManagerService mWindowManager;
    PersisterQueue mPersisterQueue;
    LaunchParamsPersister mLaunchParamsPersister;
    private LaunchParamsController mLaunchParamsController;
    private final SparseIntArray mCurTaskIdForUser = new SparseIntArray(20);
    private final ArrayList<WaitInfo> mWaitingForActivityVisible = new ArrayList();
    final ArrayList<WaitResult> mWaitingActivityLaunched = new ArrayList();
    final ArrayList<ActivityRecord> mStoppingActivities = new ArrayList();
    final ArrayList<ActivityRecord> mFinishingActivities = new ArrayList();
    final ArrayList<ActivityRecord> mGoingToSleepActivities = new ArrayList();
    final ArrayList<ActivityRecord> mMultiWindowModeChangedActivities = new ArrayList();
    final ArrayList<ActivityRecord> mPipModeChangedActivities = new ArrayList();
    final ArrayList<ActivityRecord> mNoAnimActivities = new ArrayList();
    private ActivityRecord mTopResumedActivity;
    private boolean mTopResumedActivityWaitingForPrev;
    Rect mPipModeChangedTargetStackBounds;
    final ArrayList<UserState> mStartingUsers = new ArrayList();
    boolean mUserLeaving = false;
    PowerManager.WakeLock mLaunchingActivityWakeLock;
    PowerManager.WakeLock mGoingToSleepWakeLock;
    private final Rect tempRect = new Rect();
    private final ActivityOptions mTmpOptions = ActivityOptions.makeBasic();
    private ActivityMetricsLogger mActivityMetricsLogger;
    boolean mAppVisibilitiesChangedSinceLastPause;
    private final ArraySet<Integer> mResizingTasksDuringAnimation = new ArraySet();
    private boolean mAllowDockedStackResize = true;
    private KeyguardController mKeyguardController;
    private PowerManager mPowerManager;
    private int mDeferResumeCount;
    private boolean mInitialized;

    boolean canPlaceEntityOnDisplay(int displayId, int callingPid, int callingUid, ActivityInfo activityInfo) {
        if (displayId == 0) {
            return true;
        }
        if (!this.mService.mSupportsMultiDisplay) {
            return false;
        }
        return this.isCallerAllowedToLaunchOnDisplay(callingPid, callingUid, displayId, activityInfo);
    }

    public ActivityStackSupervisor(ActivityTaskManagerService service, Looper looper) {
        this.mService = service;
        this.mLooper = looper;
        this.mHandler = new ActivityStackSupervisorHandler(looper);
    }

    public void initialize() {
        if (this.mInitialized) {
            return;
        }
        this.mInitialized = true;
        this.mRunningTasks = this.createRunningTasks();
        this.mActivityMetricsLogger = new ActivityMetricsLogger(this, this.mService.mContext, this.mHandler.getLooper());
        this.mKeyguardController = new KeyguardController(this.mService, this);
        this.mPersisterQueue = new PersisterQueue();
        this.mLaunchParamsPersister = new LaunchParamsPersister(this.mPersisterQueue, this);
        this.mLaunchParamsController = new LaunchParamsController(this.mService, this.mLaunchParamsPersister);
        this.mLaunchParamsController.registerDefaultModifiers(this);
    }

    void onSystemReady() {
        this.mLaunchParamsPersister.onSystemReady();
    }

    void onUserUnlocked(int userId) {
        this.mPersisterQueue.startPersisting();
        this.mLaunchParamsPersister.onUnlockUser(userId);
    }

    public ActivityMetricsLogger getActivityMetricsLogger() {
        return this.mActivityMetricsLogger;
    }

    public KeyguardController getKeyguardController() {
        return this.mKeyguardController;
    }

    void setRecentTasks(RecentTasks recentTasks) {
        this.mRecentTasks = recentTasks;
        this.mRecentTasks.registerCallback(this);
    }

    @VisibleForTesting
    RunningTasks createRunningTasks() {
        return new RunningTasks();
    }

    void initPowerManagement() {
        this.mPowerManager = this.mService.mContext.getSystemService(PowerManager.class);
        this.mGoingToSleepWakeLock = this.mPowerManager.newWakeLock(1, "ActivityManager-Sleep");
        this.mLaunchingActivityWakeLock = this.mPowerManager.newWakeLock(1, "*launch*");
        this.mLaunchingActivityWakeLock.setReferenceCounted(false);
    }

    void setWindowManager(WindowManagerService wm) {
        this.mWindowManager = wm;
        this.getKeyguardController().setWindowManager(wm);
    }

    void moveRecentsStackToFront(String reason) {
        Object recentsStack = this.mRootActivityContainer.getDefaultDisplay().getStack(0, 3);
        if (recentsStack != null) {
            ((ActivityStack)recentsStack).moveToFront(reason);
        }
    }

    void setNextTaskIdForUserLocked(int taskId, int userId) {
        int currentTaskId = this.mCurTaskIdForUser.get(userId, -1);
        if (taskId > currentTaskId) {
            this.mCurTaskIdForUser.put(userId, taskId);
        }
    }

    static int nextTaskIdForUser(int taskId, int userId) {
        int nextTaskId = taskId + 1;
        if (nextTaskId == (userId + 1) * 100000) {
            nextTaskId -= 100000;
        }
        return nextTaskId;
    }

    int getNextTaskIdForUserLocked(int userId) {
        int currentTaskId = this.mCurTaskIdForUser.get(userId, userId * 100000);
        int candidateTaskId = ActivityStackSupervisor.nextTaskIdForUser(currentTaskId, userId);
        while (this.mRecentTasks.containsTaskId(candidateTaskId, userId) || this.mRootActivityContainer.anyTaskForId(candidateTaskId, 1) != null) {
            if ((candidateTaskId = ActivityStackSupervisor.nextTaskIdForUser(candidateTaskId, userId)) != currentTaskId) continue;
            throw new IllegalStateException("Cannot get an available task id. Reached limit of 100000 running tasks per user.");
        }
        this.mCurTaskIdForUser.put(userId, candidateTaskId);
        return candidateTaskId;
    }

    void waitActivityVisible(ComponentName name, WaitResult result, long startTimeMs) {
        WaitInfo waitInfo = new WaitInfo(name, result, startTimeMs);
        this.mWaitingForActivityVisible.add(waitInfo);
    }

    void cleanupActivity(ActivityRecord r) {
        this.mFinishingActivities.remove(r);
        this.stopWaitingForActivityVisible(r);
    }

    void stopWaitingForActivityVisible(ActivityRecord r) {
        boolean changed = false;
        for (int i = this.mWaitingForActivityVisible.size() - 1; i >= 0; --i) {
            WaitInfo w = this.mWaitingForActivityVisible.get(i);
            if (!w.matches(r.mActivityComponent)) continue;
            WaitResult result = w.getResult();
            changed = true;
            result.timeout = false;
            result.who = w.getComponent();
            result.totalTime = SystemClock.uptimeMillis() - w.getStartTime();
            this.mWaitingForActivityVisible.remove(w);
        }
        if (changed) {
            this.mService.mGlobalLock.notifyAll();
        }
    }

    void reportWaitingActivityLaunchedIfNeeded(ActivityRecord r, int result) {
        if (this.mWaitingActivityLaunched.isEmpty()) {
            return;
        }
        if (result != 3 && result != 2) {
            return;
        }
        boolean changed = false;
        for (int i = this.mWaitingActivityLaunched.size() - 1; i >= 0; --i) {
            WaitResult w = this.mWaitingActivityLaunched.remove(i);
            if (w.who != null) continue;
            changed = true;
            w.result = result;
            if (result != 3) continue;
            w.who = r.mActivityComponent;
        }
        if (changed) {
            this.mService.mGlobalLock.notifyAll();
        }
    }

    void reportActivityLaunchedLocked(boolean timeout, ActivityRecord r, long totalTime, int launchState) {
        boolean changed = false;
        for (int i = this.mWaitingActivityLaunched.size() - 1; i >= 0; --i) {
            WaitResult w = this.mWaitingActivityLaunched.remove(i);
            if (w.who != null) continue;
            changed = true;
            w.timeout = timeout;
            if (r != null) {
                w.who = new ComponentName(r.info.packageName, r.info.name);
            }
            w.totalTime = totalTime;
            w.launchState = launchState;
        }
        if (changed) {
            this.mService.mGlobalLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    ActivityInfo resolveActivity(Intent intent, ResolveInfo rInfo, int startFlags, ProfilerInfo profilerInfo) {
        if (rInfo == null) return null;
        ActivityInfo activityInfo = rInfo.activityInfo;
        ActivityInfo aInfo = activityInfo;
        if (aInfo == null) return aInfo;
        intent.setComponent(new ComponentName(aInfo.applicationInfo.packageName, aInfo.name));
        if (!(aInfo.processName.equals("system") || (startFlags & 0xE) == 0 && profilerInfo == null)) {
            WindowManagerGlobalLock windowManagerGlobalLock = this.mService.mGlobalLock;
            synchronized (windowManagerGlobalLock) {
                try {
                    WindowManagerService.boostPriorityForLockedSection();
                    Message msg = PooledLambda.obtainMessage(ActivityManagerInternal::setDebugFlagsForStartingActivity, this.mService.mAmInternal, aInfo, startFlags, profilerInfo, this.mService.mGlobalLock);
                    this.mService.mH.sendMessage(msg);
                    try {
                        this.mService.mGlobalLock.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                catch (Throwable throwable) {
                    // MONITOREXIT @DISABLED, blocks:[2, 4, 5] lbl23 : MonitorExitStatement: MONITOREXIT : windowManagerGlobalLock
                    WindowManagerService.resetPriorityAfterLockedSection();
                    throw throwable;
                }
            }
            WindowManagerService.resetPriorityAfterLockedSection();
        }
        String intentLaunchToken = intent.getLaunchToken();
        if (aInfo.launchToken != null) return aInfo;
        if (intentLaunchToken == null) return aInfo;
        aInfo.launchToken = intentLaunchToken;
        return aInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ResolveInfo resolveIntent(Intent intent, String resolvedType, int userId, int flags, int filterCallingUid) {
        try {
            ResolveInfo resolveInfo;
            Trace.traceBegin(64L, "resolveIntent");
            int modifiedFlags = flags | 0x10000 | 0x400;
            if (intent.isWebIntent() || (intent.getFlags() & 0x800) != 0) {
                modifiedFlags |= 0x800000;
            }
            long token = Binder.clearCallingIdentity();
            try {
                resolveInfo = this.mService.getPackageManagerInternalLocked().resolveIntent(intent, resolvedType, modifiedFlags, userId, true, filterCallingUid);
            }
            catch (Throwable throwable) {
                Binder.restoreCallingIdentity(token);
                throw throwable;
            }
            Binder.restoreCallingIdentity(token);
            return resolveInfo;
        }
        finally {
            Trace.traceEnd(64L);
        }
    }

    ActivityInfo resolveActivity(Intent intent, String resolvedType, int startFlags, ProfilerInfo profilerInfo, int userId, int filterCallingUid) {
        ResolveInfo rInfo = this.resolveIntent(intent, resolvedType, userId, 0, filterCallingUid);
        return this.resolveActivity(intent, rInfo, startFlags, profilerInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean realStartActivityLocked(ActivityRecord r, WindowProcessController proc, boolean andResume, boolean checkConfig) throws RemoteException {
        if (!this.mRootActivityContainer.allPausedActivitiesComplete()) {
            return false;
        }
        TaskRecord task = r.getTaskRecord();
        Object stack = task.getStack();
        this.beginDeferResume();
        try {
            int applicationInfoUid;
            r.startFreezingScreenLocked(proc, 0);
            r.startLaunchTickingLocked();
            r.setProcess(proc);
            if (andResume && !r.canResumeByCompat()) {
                andResume = false;
            }
            if (this.getKeyguardController().isKeyguardLocked()) {
                r.notifyUnknownVisibilityLaunched();
            }
            if (checkConfig) {
                this.mRootActivityContainer.ensureVisibilityAndConfig(r, r.getDisplayId(), false, true);
            }
            if (((ActivityStack)r.getActivityStack()).checkKeyguardVisibility(r, true, true)) {
                r.setVisibility(true);
            }
            int n = applicationInfoUid = r.info.applicationInfo != null ? r.info.applicationInfo.uid : -1;
            if (r.mUserId != proc.mUserId || r.appInfo.uid != applicationInfoUid) {
                Slog.wtf("ActivityTaskManager", "User ID for activity changing for " + r + " appInfo.uid=" + r.appInfo.uid + " info.ai.uid=" + applicationInfoUid + " old=" + r.app + " new=" + proc);
            }
            ++r.launchCount;
            r.lastLaunchTime = SystemClock.uptimeMillis();
            proc.addActivityIfNeeded(r);
            LockTaskController lockTaskController = this.mService.getLockTaskController();
            if (task.mLockTaskAuth == 2 || task.mLockTaskAuth == 4 || task.mLockTaskAuth == 3 && lockTaskController.getLockTaskModeState() == 1) {
                lockTaskController.startLockTaskMode(task, false, 0);
            }
            try {
                if (!proc.hasThread()) {
                    throw new RemoteException();
                }
                ArrayList<ResultInfo> results = null;
                ArrayList<ReferrerIntent> newIntents = null;
                if (andResume) {
                    results = r.results;
                    newIntents = r.newIntents;
                }
                EventLog.writeEvent(30006, r.mUserId, System.identityHashCode(r), task.taskId, r.shortComponentName);
                if (r.isActivityTypeHome()) {
                    this.updateHomeProcess(task.mActivities.get((int)0).app);
                }
                this.mService.getPackageManagerInternalLocked().notifyPackageUse(r.intent.getComponent().getPackageName(), 0);
                r.sleeping = false;
                r.forceNewConfig = false;
                this.mService.getAppWarningsLocked().onStartActivity(r);
                r.compat = this.mService.compatibilityInfoForPackageLocked(r.info.applicationInfo);
                MergedConfiguration mergedConfiguration = new MergedConfiguration(proc.getConfiguration(), r.getMergedOverrideConfiguration());
                r.setLastReportedConfiguration(mergedConfiguration);
                this.logIfTransactionTooLarge(r.intent, r.icicle);
                ClientTransaction clientTransaction = ClientTransaction.obtain(proc.getThread(), r.appToken);
                DisplayContent dc = r.getDisplay().mDisplayContent;
                clientTransaction.addCallback(LaunchActivityItem.obtain(new Intent(r.intent), System.identityHashCode(r), r.info, mergedConfiguration.getGlobalConfiguration(), mergedConfiguration.getOverrideConfiguration(), r.compat, r.launchedFromPackage, task.voiceInteractor, proc.getReportedProcState(), r.icicle, r.persistentState, results, newIntents, dc.isNextTransitionForward(), proc.createProfilerInfoIfNeeded(), r.assistToken));
                ActivityLifecycleItem lifecycleItem = andResume ? ResumeActivityItem.obtain(dc.isNextTransitionForward()) : PauseActivityItem.obtain();
                clientTransaction.setLifecycleStateRequest(lifecycleItem);
                this.mService.getLifecycleManager().scheduleTransaction(clientTransaction);
                if ((proc.mInfo.privateFlags & 2) != 0 && this.mService.mHasHeavyWeightFeature && proc.mName.equals(proc.mInfo.packageName)) {
                    if (this.mService.mHeavyWeightProcess != null && this.mService.mHeavyWeightProcess != proc) {
                        Slog.w("ActivityTaskManager", "Starting new heavy weight process " + proc + " when already running " + this.mService.mHeavyWeightProcess);
                    }
                    this.mService.setHeavyWeightProcess(r);
                }
            }
            catch (RemoteException e) {
                if (r.launchFailed) {
                    Slog.e("ActivityTaskManager", "Second failure launching " + r.intent.getComponent().flattenToShortString() + ", giving up", e);
                    proc.appDied();
                    ((ActivityStack)stack).requestFinishActivityLocked(r.appToken, 0, null, "2nd-crash", false);
                    boolean bl = false;
                    this.endDeferResume();
                    return bl;
                }
                r.launchFailed = true;
                proc.removeActivity(r);
                throw e;
            }
        }
        finally {
            this.endDeferResume();
        }
        r.launchFailed = false;
        if (((ActivityStack)stack).updateLRUListLocked(r)) {
            Slog.w("ActivityTaskManager", "Activity " + r + " being launched, but already in LRU list");
        }
        if (andResume && this.readyToResume()) {
            ((ActivityStack)stack).minimalResumeActivityLocked(r);
        } else {
            r.setState(ActivityStack.ActivityState.PAUSED, "realStartActivityLocked");
        }
        proc.onStartActivity(this.mService.mTopProcessState, r.info);
        if (this.mRootActivityContainer.isTopDisplayFocusedStack((ActivityStack)stack)) {
            this.mService.getActivityStartController().startSetupActivity();
        }
        if (r.app != null) {
            r.app.updateServiceConnectionActivities();
        }
        return true;
    }

    void updateHomeProcess(WindowProcessController app) {
        if (app != null && this.mService.mHomeProcess != app) {
            if (!this.mHandler.hasMessages(216)) {
                this.mHandler.sendEmptyMessage(216);
            }
            this.mService.mHomeProcess = app;
        }
    }

    private void logIfTransactionTooLarge(Intent intent, Bundle icicle) {
        int icicleSize;
        Bundle extras;
        int extrasSize = 0;
        if (intent != null && (extras = intent.getExtras()) != null) {
            extrasSize = extras.getSize();
        }
        int n = icicleSize = icicle == null ? 0 : icicle.getSize();
        if (extrasSize + icicleSize > 200000) {
            Slog.e("ActivityTaskManager", "Transaction too large, intent: " + intent + ", extras size: " + extrasSize + ", icicle size: " + icicleSize);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startSpecificActivityLocked(ActivityRecord r, boolean andResume, boolean checkConfig) {
        WindowProcessController wpc = this.mService.getProcessController(r.processName, r.info.applicationInfo.uid);
        boolean knownToBeDead = false;
        if (wpc != null && wpc.hasThread()) {
            try {
                this.realStartActivityLocked(r, wpc, andResume, checkConfig);
                return;
            }
            catch (RemoteException e) {
                Slog.w("ActivityTaskManager", "Exception when starting activity " + r.intent.getComponent().flattenToShortString(), e);
                knownToBeDead = true;
            }
        }
        if (this.getKeyguardController().isKeyguardLocked()) {
            r.notifyUnknownVisibilityLaunched();
        }
        try {
            if (Trace.isTagEnabled(64L)) {
                Trace.traceBegin(64L, "dispatchingStartProcess:" + r.processName);
            }
            Message msg = PooledLambda.obtainMessage(ActivityManagerInternal::startProcess, this.mService.mAmInternal, r.processName, r.info.applicationInfo, knownToBeDead, "activity", r.intent.getComponent());
            this.mService.mH.sendMessage(msg);
        }
        finally {
            Trace.traceEnd(64L);
        }
    }

    boolean checkStartAnyActivityPermission(Intent intent, ActivityInfo aInfo, String resultWho, int requestCode, int callingPid, int callingUid, String callingPackage, boolean ignoreTargetSecurity, boolean launchingInTask, WindowProcessController callerApp, ActivityRecord resultRecord, ActivityStack resultStack) {
        boolean isCallerRecents = this.mService.getRecentTasks() != null && this.mService.getRecentTasks().isCallerRecents(callingUid);
        int startAnyPerm = ActivityTaskManagerService.checkPermission("android.permission.START_ANY_ACTIVITY", callingPid, callingUid);
        if (startAnyPerm == 0 || isCallerRecents && launchingInTask) {
            return true;
        }
        int componentRestriction = this.getComponentRestrictionForCallingPackage(aInfo, callingPackage, callingPid, callingUid, ignoreTargetSecurity);
        int actionRestriction = this.getActionRestrictionForCallingPackage(intent.getAction(), callingPackage, callingPid, callingUid);
        if (componentRestriction == 1 || actionRestriction == 1) {
            if (resultRecord != null) {
                resultStack.sendActivityResultLocked(-1, resultRecord, resultWho, requestCode, 0, null);
            }
            String msg = actionRestriction == 1 ? "Permission Denial: starting " + intent.toString() + " from " + callerApp + " (pid=" + callingPid + ", uid=" + callingUid + ") with revoked permission " + ACTION_TO_RUNTIME_PERMISSION.get(intent.getAction()) : (!aInfo.exported ? "Permission Denial: starting " + intent.toString() + " from " + callerApp + " (pid=" + callingPid + ", uid=" + callingUid + ") not exported from uid " + aInfo.applicationInfo.uid : "Permission Denial: starting " + intent.toString() + " from " + callerApp + " (pid=" + callingPid + ", uid=" + callingUid + ") requires " + aInfo.permission);
            Slog.w("ActivityTaskManager", msg);
            throw new SecurityException(msg);
        }
        if (actionRestriction == 2) {
            String message = "Appop Denial: starting " + intent.toString() + " from " + callerApp + " (pid=" + callingPid + ", uid=" + callingUid + ") requires " + AppOpsManager.permissionToOp(ACTION_TO_RUNTIME_PERMISSION.get(intent.getAction()));
            Slog.w("ActivityTaskManager", message);
            return false;
        }
        if (componentRestriction == 2) {
            String message = "Appop Denial: starting " + intent.toString() + " from " + callerApp + " (pid=" + callingPid + ", uid=" + callingUid + ") requires appop " + AppOpsManager.permissionToOp(aInfo.permission);
            Slog.w("ActivityTaskManager", message);
            return false;
        }
        return true;
    }

    boolean isCallerAllowedToLaunchOnDisplay(int callingPid, int callingUid, int launchDisplayId, ActivityInfo aInfo) {
        if (callingPid == -1 && callingUid == -1) {
            return true;
        }
        ActivityDisplay activityDisplay = this.mRootActivityContainer.getActivityDisplayOrCreate(launchDisplayId);
        if (activityDisplay == null || activityDisplay.isRemoved()) {
            Slog.w("ActivityTaskManager", "Launch on display check: display not found");
            return false;
        }
        int startAnyPerm = ActivityTaskManagerService.checkPermission("android.permission.INTERNAL_SYSTEM_WINDOW", callingPid, callingUid);
        if (startAnyPerm == 0) {
            return true;
        }
        boolean uidPresentOnDisplay = activityDisplay.isUidPresent(callingUid);
        int displayOwnerUid = activityDisplay.mDisplay.getOwnerUid();
        if (activityDisplay.mDisplay.getType() == 5 && displayOwnerUid != 1000 && displayOwnerUid != aInfo.applicationInfo.uid) {
            if ((aInfo.flags & Integer.MIN_VALUE) == 0) {
                return false;
            }
            if (ActivityTaskManagerService.checkPermission("android.permission.ACTIVITY_EMBEDDING", callingPid, callingUid) == -1 && !uidPresentOnDisplay) {
                return false;
            }
        }
        if (!activityDisplay.isPrivate()) {
            return true;
        }
        if (displayOwnerUid == callingUid) {
            return true;
        }
        if (uidPresentOnDisplay) {
            return true;
        }
        Slog.w("ActivityTaskManager", "Launch on display check: denied");
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    UserInfo getUserInfo(int userId) {
        long identity = Binder.clearCallingIdentity();
        try {
            UserInfo userInfo = UserManager.get(this.mService.mContext).getUserInfo(userId);
            return userInfo;
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
    }

    private int getComponentRestrictionForCallingPackage(ActivityInfo activityInfo, String callingPackage, int callingPid, int callingUid, boolean ignoreTargetSecurity) {
        if (!ignoreTargetSecurity) {
            if (ActivityTaskManagerService.checkComponentPermission(activityInfo.permission, callingPid, callingUid, activityInfo.applicationInfo.uid, activityInfo.exported) == -1) {
                return 1;
            }
        }
        if (activityInfo.permission == null) {
            return 0;
        }
        int opCode = AppOpsManager.permissionToOpCode(activityInfo.permission);
        if (opCode == -1) {
            return 0;
        }
        if (this.mService.getAppOpsService().noteOperation(opCode, callingUid, callingPackage) != 0 && !ignoreTargetSecurity) {
            return 2;
        }
        return 0;
    }

    private int getActionRestrictionForCallingPackage(String action, String callingPackage, int callingPid, int callingUid) {
        PackageInfo packageInfo;
        if (action == null) {
            return 0;
        }
        String permission2 = ACTION_TO_RUNTIME_PERMISSION.get(action);
        if (permission2 == null) {
            return 0;
        }
        try {
            packageInfo = this.mService.mContext.getPackageManager().getPackageInfo(callingPackage, 4096);
        }
        catch (PackageManager.NameNotFoundException e) {
            Slog.i("ActivityTaskManager", "Cannot find package info for " + callingPackage);
            return 0;
        }
        if (!ArrayUtils.contains(packageInfo.requestedPermissions, permission2)) {
            return 0;
        }
        if (ActivityTaskManagerService.checkPermission(permission2, callingPid, callingUid) == -1) {
            return 1;
        }
        int opCode = AppOpsManager.permissionToOpCode(permission2);
        if (opCode == -1) {
            return 0;
        }
        if (this.mService.getAppOpsService().noteOperation(opCode, callingUid, callingPackage) != 0) {
            return 2;
        }
        return 0;
    }

    void setLaunchSource(int uid) {
        this.mLaunchingActivityWakeLock.setWorkSource(new WorkSource(uid));
    }

    void acquireLaunchWakelock() {
        this.mLaunchingActivityWakeLock.acquire();
        if (!this.mHandler.hasMessages(204)) {
            this.mHandler.sendEmptyMessageDelayed(204, 10000L);
        }
    }

    @GuardedBy(value={"mService"})
    private boolean checkFinishBootingLocked() {
        boolean booting = this.mService.isBooting();
        boolean enableScreen = false;
        this.mService.setBooting(false);
        if (!this.mService.isBooted()) {
            this.mService.setBooted(true);
            enableScreen = true;
        }
        if (booting || enableScreen) {
            this.mService.postFinishBooting(booting, enableScreen);
        }
        return booting;
    }

    @GuardedBy(value={"mService"})
    final ActivityRecord activityIdleInternalLocked(IBinder token, boolean fromTimeout, boolean processPausingActivities, Configuration config) {
        Object stack;
        int i;
        ArrayList<ActivityRecord> stops;
        ArrayList<ActivityRecord> finishes = null;
        ArrayList<UserState> startingUsers = null;
        int NS = 0;
        int NF = 0;
        boolean booting = false;
        boolean activityRemoved = false;
        ActivityRecord r = ActivityRecord.forTokenLocked(token);
        if (r != null) {
            this.mHandler.removeMessages(200, r);
            r.finishLaunchTickingLocked();
            if (fromTimeout) {
                this.reportActivityLaunchedLocked(fromTimeout, r, -1L, -1);
            }
            if (config != null) {
                r.setLastReportedGlobalConfiguration(config);
            }
            r.idle = true;
            if (this.mService.isBooting() && this.mRootActivityContainer.allResumedActivitiesIdle() || fromTimeout) {
                booting = this.checkFinishBootingLocked();
            }
            r.mRelaunchReason = 0;
        }
        if (this.mRootActivityContainer.allResumedActivitiesIdle()) {
            if (r != null) {
                this.mService.scheduleAppGcsLocked();
            }
            if (this.mLaunchingActivityWakeLock.isHeld()) {
                this.mHandler.removeMessages(204);
                this.mLaunchingActivityWakeLock.release();
            }
            this.mRootActivityContainer.ensureActivitiesVisible(null, 0, false);
        }
        NS = (stops = this.processStoppingActivitiesLocked(r, true, processPausingActivities)) != null ? stops.size() : 0;
        NF = this.mFinishingActivities.size();
        if (NF > 0) {
            finishes = new ArrayList<ActivityRecord>(this.mFinishingActivities);
            this.mFinishingActivities.clear();
        }
        if (this.mStartingUsers.size() > 0) {
            startingUsers = new ArrayList<UserState>(this.mStartingUsers);
            this.mStartingUsers.clear();
        }
        for (i = 0; i < NS; ++i) {
            r = stops.get(i);
            stack = r.getActivityStack();
            if (stack == null) continue;
            if (r.finishing) {
                ((ActivityStack)stack).finishCurrentActivityLocked(r, 0, false, "activityIdleInternalLocked");
                continue;
            }
            ((ActivityStack)stack).stopActivityLocked(r);
        }
        for (i = 0; i < NF; ++i) {
            r = finishes.get(i);
            stack = r.getActivityStack();
            if (stack == null) continue;
            activityRemoved |= ((ActivityStack)stack).destroyActivityLocked(r, true, "finish-idle");
        }
        if (!booting && startingUsers != null) {
            for (i = 0; i < startingUsers.size(); ++i) {
                this.mService.mAmInternal.finishUserSwitch(startingUsers.get(i));
            }
        }
        this.mService.mH.post(() -> this.mService.mAmInternal.trimApplications());
        if (activityRemoved) {
            this.mRootActivityContainer.resumeFocusedStacksTopActivities();
        }
        return r;
    }

    void findTaskToMoveToFront(TaskRecord task, int flags, ActivityOptions options, String reason, boolean forceNonResizeable) {
        ActivityRecord r;
        Object currentStack = task.getStack();
        if (currentStack == null) {
            Slog.e("ActivityTaskManager", "findTaskToMoveToFront: can't move task=" + task + " to front. Stack is null");
            return;
        }
        if ((flags & 2) == 0) {
            this.mUserLeaving = true;
        }
        reason = reason + " findTaskToMoveToFront";
        boolean reparented = false;
        if (task.isResizeable() && this.canUseActivityOptionsLaunchBounds(options)) {
            Rect bounds = options.getLaunchBounds();
            task.updateOverrideConfiguration(bounds);
            Object stack = this.mRootActivityContainer.getLaunchStack(null, options, task, true);
            if (stack != currentStack) {
                this.moveHomeStackToFrontIfNeeded(flags, ((ActivityStack)stack).getDisplay(), reason);
                task.reparent((ActivityStack)stack, true, 1, false, true, reason);
                currentStack = stack;
                reparented = true;
            }
            if (((ActivityStack)stack).resizeStackWithLaunchBounds()) {
                this.mRootActivityContainer.resizeStack((ActivityStack)stack, bounds, null, null, false, true, false);
            } else {
                task.resizeWindowContainer();
            }
        }
        if (!reparented) {
            this.moveHomeStackToFrontIfNeeded(flags, ((ActivityStack)currentStack).getDisplay(), reason);
        }
        ((ActivityStack)currentStack).moveTaskToFrontLocked(task, false, options, (r = task.getTopActivity()) == null ? null : r.appTimeTracker, reason);
        this.handleNonResizableTaskIfNeeded(task, 0, 0, (ActivityStack)currentStack, forceNonResizeable);
    }

    private void moveHomeStackToFrontIfNeeded(int flags, ActivityDisplay display, String reason) {
        ActivityStack focusedStack = display.getFocusedStack();
        if (display.getWindowingMode() == 1 && (flags & 1) != 0 || focusedStack != null && focusedStack.isActivityTypeRecents()) {
            display.moveHomeStackToFront(reason);
        }
    }

    boolean canUseActivityOptionsLaunchBounds(ActivityOptions options) {
        if (options == null || options.getLaunchBounds() == null) {
            return false;
        }
        return this.mService.mSupportsPictureInPicture && options.getLaunchWindowingMode() == 2 || this.mService.mSupportsFreeformWindowManagement;
    }

    LaunchParamsController getLaunchParamsController() {
        return this.mLaunchParamsController;
    }

    private void deferUpdateRecentsHomeStackBounds() {
        this.mRootActivityContainer.deferUpdateBounds(3);
        this.mRootActivityContainer.deferUpdateBounds(2);
    }

    private void continueUpdateRecentsHomeStackBounds() {
        this.mRootActivityContainer.continueUpdateBounds(3);
        this.mRootActivityContainer.continueUpdateBounds(2);
    }

    void notifyAppTransitionDone() {
        this.continueUpdateRecentsHomeStackBounds();
        for (int i = this.mResizingTasksDuringAnimation.size() - 1; i >= 0; --i) {
            int taskId = this.mResizingTasksDuringAnimation.valueAt(i);
            TaskRecord task = this.mRootActivityContainer.anyTaskForId(taskId, 0);
            if (task == null) continue;
            task.setTaskDockedResizing(false);
        }
        this.mResizingTasksDuringAnimation.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void moveTasksToFullscreenStackInSurfaceTransaction(ActivityStack fromStack, int toDisplayId, boolean onTop) {
        this.mWindowManager.deferSurfaceLayout();
        try {
            int windowingMode = fromStack.getWindowingMode();
            boolean inPinnedWindowingMode = windowingMode == 2;
            ActivityDisplay toDisplay = this.mRootActivityContainer.getActivityDisplay(toDisplayId);
            if (windowingMode == 3) {
                toDisplay.onExitingSplitScreenMode();
                for (int i = toDisplay.getChildCount() - 1; i >= 0; --i) {
                    ActivityStack otherStack = toDisplay.getChildAt(i);
                    if (!otherStack.inSplitScreenSecondaryWindowingMode()) continue;
                    otherStack.setWindowingMode(0);
                }
                this.mAllowDockedStackResize = false;
            }
            boolean schedulePictureInPictureModeChange = inPinnedWindowingMode;
            ArrayList<TaskRecord> tasks = fromStack.getAllTasks();
            if (!tasks.isEmpty()) {
                this.mTmpOptions.setLaunchWindowingMode(1);
                int size = tasks.size();
                for (int i = 0; i < size; ++i) {
                    TaskRecord task = tasks.get(i);
                    Object toStack = toDisplay.getOrCreateStack(null, this.mTmpOptions, task, task.getActivityType(), onTop);
                    if (onTop) {
                        boolean isTopTask = i == size - 1;
                        task.reparent((ActivityStack)toStack, true, 0, isTopTask, true, schedulePictureInPictureModeChange, "moveTasksToFullscreenStack - onTop");
                        MetricsLoggerWrapper.logPictureInPictureFullScreen(this.mService.mContext, task.effectiveUid, task.realActivity.flattenToString());
                        continue;
                    }
                    task.reparent((ActivityStack)toStack, true, 2, false, true, schedulePictureInPictureModeChange, "moveTasksToFullscreenStack - NOT_onTop");
                }
            }
            this.mRootActivityContainer.ensureActivitiesVisible(null, 0, true);
            this.mRootActivityContainer.resumeFocusedStacksTopActivities();
        }
        finally {
            this.mAllowDockedStackResize = true;
            this.mWindowManager.continueSurfaceLayout();
        }
    }

    void moveTasksToFullscreenStackLocked(ActivityStack fromStack, boolean onTop) {
        this.moveTasksToFullscreenStackLocked(fromStack, 0, onTop);
    }

    void moveTasksToFullscreenStackLocked(ActivityStack fromStack, int toDisplayId, boolean onTop) {
        this.mWindowManager.inSurfaceTransaction(() -> this.moveTasksToFullscreenStackInSurfaceTransaction(fromStack, toDisplayId, onTop));
    }

    void setSplitScreenResizing(boolean resizing) {
        if (resizing == this.mDockedStackResizing) {
            return;
        }
        this.mDockedStackResizing = resizing;
        this.mWindowManager.setDockedStackResizing(resizing);
        if (!resizing && this.mHasPendingDockedBounds) {
            this.resizeDockedStackLocked(this.mPendingDockedBounds, this.mPendingTempDockedTaskBounds, this.mPendingTempDockedTaskInsetBounds, this.mPendingTempOtherTaskBounds, this.mPendingTempOtherTaskInsetBounds, true);
            this.mHasPendingDockedBounds = false;
            this.mPendingDockedBounds = null;
            this.mPendingTempDockedTaskBounds = null;
            this.mPendingTempDockedTaskInsetBounds = null;
            this.mPendingTempOtherTaskBounds = null;
            this.mPendingTempOtherTaskInsetBounds = null;
        }
    }

    void resizeDockedStackLocked(Rect dockedBounds, Rect tempDockedTaskBounds, Rect tempDockedTaskInsetBounds, Rect tempOtherTaskBounds, Rect tempOtherTaskInsetBounds, boolean preserveWindows) {
        this.resizeDockedStackLocked(dockedBounds, tempDockedTaskBounds, tempDockedTaskInsetBounds, tempOtherTaskBounds, tempOtherTaskInsetBounds, preserveWindows, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resizeDockedStackLocked(Rect dockedBounds, Rect tempDockedTaskBounds, Rect tempDockedTaskInsetBounds, Rect tempOtherTaskBounds, Rect tempOtherTaskInsetBounds, boolean preserveWindows, boolean deferResume) {
        if (!this.mAllowDockedStackResize) {
            return;
        }
        ActivityStack stack = this.mRootActivityContainer.getDefaultDisplay().getSplitScreenPrimaryStack();
        if (stack == null) {
            Slog.w("ActivityTaskManager", "resizeDockedStackLocked: docked stack not found");
            return;
        }
        if (this.mDockedStackResizing) {
            this.mHasPendingDockedBounds = true;
            this.mPendingDockedBounds = Rect.copyOrNull(dockedBounds);
            this.mPendingTempDockedTaskBounds = Rect.copyOrNull(tempDockedTaskBounds);
            this.mPendingTempDockedTaskInsetBounds = Rect.copyOrNull(tempDockedTaskInsetBounds);
            this.mPendingTempOtherTaskBounds = Rect.copyOrNull(tempOtherTaskBounds);
            this.mPendingTempOtherTaskInsetBounds = Rect.copyOrNull(tempOtherTaskInsetBounds);
        }
        Trace.traceBegin(64L, "am.resizeDockedStack");
        this.mWindowManager.deferSurfaceLayout();
        try {
            this.mAllowDockedStackResize = false;
            ActivityRecord r = stack.topRunningActivityLocked();
            stack.resize(dockedBounds, tempDockedTaskBounds, tempDockedTaskInsetBounds);
            if (stack.getWindowingMode() == 1 || dockedBounds == null && !stack.isAttached()) {
                this.moveTasksToFullscreenStackLocked(stack, true);
                r = null;
            } else {
                ActivityDisplay display = this.mRootActivityContainer.getDefaultDisplay();
                Rect otherTaskRect = new Rect();
                for (int i = display.getChildCount() - 1; i >= 0; --i) {
                    ActivityStack current = display.getChildAt(i);
                    if (!current.inSplitScreenSecondaryWindowingMode() || !current.affectedBySplitScreenResize() || this.mDockedStackResizing && !current.isTopActivityVisible()) continue;
                    current.getStackDockedModeBounds(dockedBounds, tempOtherTaskBounds, this.tempRect, otherTaskRect);
                    this.mRootActivityContainer.resizeStack(current, !this.tempRect.isEmpty() ? this.tempRect : null, !otherTaskRect.isEmpty() ? otherTaskRect : tempOtherTaskBounds, tempOtherTaskInsetBounds, preserveWindows, true, deferResume);
                }
            }
            if (!deferResume) {
                stack.ensureVisibleActivitiesConfigurationLocked(r, preserveWindows);
            }
        }
        finally {
            this.mAllowDockedStackResize = true;
            this.mWindowManager.continueSurfaceLayout();
            Trace.traceEnd(64L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resizePinnedStackLocked(Rect pinnedBounds, Rect tempPinnedTaskBounds) {
        ActivityStack stack = this.mRootActivityContainer.getDefaultDisplay().getPinnedStack();
        if (stack == null) {
            Slog.w("ActivityTaskManager", "resizePinnedStackLocked: pinned stack not found");
            return;
        }
        TaskStack stackController = stack.getTaskStack();
        if (stackController.pinnedStackResizeDisallowed()) {
            return;
        }
        Trace.traceBegin(64L, "am.resizePinnedStack");
        this.mWindowManager.deferSurfaceLayout();
        try {
            ActivityRecord r = stack.topRunningActivityLocked();
            Rect insetBounds = null;
            if (tempPinnedTaskBounds != null && stack.isAnimatingBoundsToFullscreen()) {
                insetBounds = this.tempRect;
                insetBounds.top = 0;
                insetBounds.left = 0;
                insetBounds.right = tempPinnedTaskBounds.width();
                insetBounds.bottom = tempPinnedTaskBounds.height();
            }
            if (pinnedBounds != null && tempPinnedTaskBounds == null) {
                stack.onPipAnimationEndResize();
            }
            stack.resize(pinnedBounds, tempPinnedTaskBounds, insetBounds);
            stack.ensureVisibleActivitiesConfigurationLocked(r, false);
        }
        finally {
            this.mWindowManager.continueSurfaceLayout();
            Trace.traceEnd(64L);
        }
    }

    private void removeStackInSurfaceTransaction(ActivityStack stack) {
        ArrayList<TaskRecord> tasks = stack.getAllTasks();
        if (stack.getWindowingMode() == 2) {
            stack.mForceHidden = true;
            stack.ensureActivitiesVisibleLocked(null, 0, true);
            stack.mForceHidden = false;
            this.activityIdleInternalLocked(null, false, true, null);
            this.moveTasksToFullscreenStackLocked(stack, false);
        } else {
            for (int i = tasks.size() - 1; i >= 0; --i) {
                this.removeTaskByIdLocked(tasks.get((int)i).taskId, true, true, "remove-stack");
            }
        }
    }

    void removeStack(ActivityStack stack) {
        this.mWindowManager.inSurfaceTransaction(() -> this.removeStackInSurfaceTransaction(stack));
    }

    boolean removeTaskByIdLocked(int taskId, boolean killProcess, boolean removeFromRecents, String reason) {
        return this.removeTaskByIdLocked(taskId, killProcess, removeFromRecents, false, reason);
    }

    boolean removeTaskByIdLocked(int taskId, boolean killProcess, boolean removeFromRecents, boolean pauseImmediately, String reason) {
        TaskRecord tr = this.mRootActivityContainer.anyTaskForId(taskId, 1);
        if (tr != null) {
            tr.removeTaskActivitiesLocked(pauseImmediately, reason);
            this.cleanUpRemovedTaskLocked(tr, killProcess, removeFromRecents);
            this.mService.getLockTaskController().clearLockedTask(tr);
            if (tr.isPersistable) {
                this.mService.notifyTaskPersisterLocked(null, true);
            }
            return true;
        }
        Slog.w("ActivityTaskManager", "Request to remove task ignored for non-existent task " + taskId);
        return false;
    }

    void cleanUpRemovedTaskLocked(TaskRecord tr, boolean killProcess, boolean removeFromRecents) {
        ComponentName component;
        if (removeFromRecents) {
            this.mRecentTasks.remove(tr);
        }
        if ((component = tr.getBaseIntent().getComponent()) == null) {
            Slog.w("ActivityTaskManager", "No component for base intent of task: " + tr);
            return;
        }
        Message msg = PooledLambda.obtainMessage(ActivityManagerInternal::cleanUpServices, this.mService.mAmInternal, tr.userId, component, new Intent(tr.getBaseIntent()));
        this.mService.mH.sendMessage(msg);
        if (!killProcess) {
            return;
        }
        String pkg = component.getPackageName();
        ArrayList<WindowProcessController> procsToKill = new ArrayList<WindowProcessController>();
        ArrayMap<String, SparseArray<WindowProcessController>> pmap = this.mService.mProcessNames.getMap();
        for (int i = 0; i < pmap.size(); ++i) {
            SparseArray<WindowProcessController> uids = pmap.valueAt(i);
            for (int j = 0; j < uids.size(); ++j) {
                WindowProcessController proc = uids.valueAt(j);
                if (proc.mUserId != tr.userId || proc == this.mService.mHomeProcess || !proc.mPkgList.contains(pkg)) continue;
                if (!proc.shouldKillProcessForRemovedTask(tr)) {
                    return;
                }
                if (proc.hasForegroundServices()) {
                    return;
                }
                procsToKill.add(proc);
            }
        }
        Message m = PooledLambda.obtainMessage(ActivityManagerInternal::killProcessesForRemovedTask, this.mService.mAmInternal, procsToKill);
        this.mService.mH.sendMessage(m);
    }

    boolean restoreRecentTaskLocked(TaskRecord task, ActivityOptions aOptions, boolean onTop) {
        Object stack = this.mRootActivityContainer.getLaunchStack(null, aOptions, task, onTop);
        Object currentStack = task.getStack();
        if (currentStack != null) {
            if (currentStack == stack) {
                return true;
            }
            ((ActivityStack)currentStack).removeTask(task, "restoreRecentTaskLocked", 1);
        }
        ((ActivityStack)stack).addTask(task, onTop, "restoreRecentTask");
        task.createTask(onTop, true);
        ArrayList<ActivityRecord> activities = task.mActivities;
        for (int activityNdx = activities.size() - 1; activityNdx >= 0; --activityNdx) {
            activities.get(activityNdx).createAppWindowToken();
        }
        return true;
    }

    @Override
    public void onRecentTaskAdded(TaskRecord task) {
        task.touchActiveTime();
    }

    @Override
    public void onRecentTaskRemoved(TaskRecord task, boolean wasTrimmed, boolean killProcess) {
        if (wasTrimmed) {
            this.removeTaskByIdLocked(task.taskId, killProcess, false, false, "recent-task-trimmed");
        }
        task.removedFromRecents();
    }

    ActivityStack getReparentTargetStack(TaskRecord task, ActivityStack stack, boolean toTop) {
        Object prevStack = task.getStack();
        int stackId = stack.mStackId;
        boolean inMultiWindowMode = stack.inMultiWindowMode();
        if (prevStack != null && ((ActivityStack)prevStack).mStackId == stackId) {
            Slog.w("ActivityTaskManager", "Can not reparent to same stack, task=" + task + " already in stackId=" + stackId);
            return prevStack;
        }
        if (inMultiWindowMode && !this.mService.mSupportsMultiWindow) {
            throw new IllegalArgumentException("Device doesn't support multi-window, can not reparent task=" + task + " to stack=" + stack);
        }
        if (stack.mDisplayId != 0 && !this.mService.mSupportsMultiDisplay) {
            throw new IllegalArgumentException("Device doesn't support multi-display, can not reparent task=" + task + " to stackId=" + stackId);
        }
        if (stack.getWindowingMode() == 5 && !this.mService.mSupportsFreeformWindowManagement) {
            throw new IllegalArgumentException("Device doesn't support freeform, can not reparent task=" + task);
        }
        if (inMultiWindowMode && !task.isResizeable()) {
            Slog.w("ActivityTaskManager", "Can not move unresizeable task=" + task + " to multi-window stack=" + stack + " Moving to a fullscreen stack instead.");
            if (prevStack != null) {
                return prevStack;
            }
            stack = stack.getDisplay().createStack(1, stack.getActivityType(), toTop);
        }
        return stack;
    }

    void goingToSleepLocked() {
        this.scheduleSleepTimeout();
        if (!this.mGoingToSleepWakeLock.isHeld()) {
            this.mGoingToSleepWakeLock.acquire();
            if (this.mLaunchingActivityWakeLock.isHeld()) {
                this.mLaunchingActivityWakeLock.release();
                this.mHandler.removeMessages(204);
            }
        }
        this.mRootActivityContainer.applySleepTokens(false);
        this.checkReadyForSleepLocked(true);
    }

    boolean shutdownLocked(int timeout) {
        this.goingToSleepLocked();
        boolean timedout = false;
        long endTime = System.currentTimeMillis() + (long)timeout;
        while (!this.mRootActivityContainer.putStacksToSleep(true, true)) {
            long timeRemaining = endTime - System.currentTimeMillis();
            if (timeRemaining > 0L) {
                try {
                    this.mService.mGlobalLock.wait(timeRemaining);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            Slog.w("ActivityTaskManager", "Activity manager shutdown timed out");
            timedout = true;
            break;
        }
        this.checkReadyForSleepLocked(false);
        return timedout;
    }

    void comeOutOfSleepIfNeededLocked() {
        this.removeSleepTimeouts();
        if (this.mGoingToSleepWakeLock.isHeld()) {
            this.mGoingToSleepWakeLock.release();
        }
    }

    void activitySleptLocked(ActivityRecord r) {
        this.mGoingToSleepActivities.remove(r);
        Object s = r.getActivityStack();
        if (s != null) {
            ((ActivityStack)s).checkReadyForSleep();
        } else {
            this.checkReadyForSleepLocked(true);
        }
    }

    void checkReadyForSleepLocked(boolean allowDelay) {
        if (!this.mService.isSleepingOrShuttingDownLocked()) {
            return;
        }
        if (!this.mRootActivityContainer.putStacksToSleep(allowDelay, false)) {
            return;
        }
        this.mRootActivityContainer.sendPowerHintForLaunchEndIfNeeded();
        this.removeSleepTimeouts();
        if (this.mGoingToSleepWakeLock.isHeld()) {
            this.mGoingToSleepWakeLock.release();
        }
        if (this.mService.mShuttingDown) {
            this.mService.mGlobalLock.notifyAll();
        }
    }

    boolean reportResumedActivityLocked(ActivityRecord r) {
        this.mStoppingActivities.remove(r);
        Object stack = r.getActivityStack();
        if (((ActivityStack)stack).getDisplay().allResumedActivitiesComplete()) {
            this.mRootActivityContainer.ensureActivitiesVisible(null, 0, false);
            this.mRootActivityContainer.executeAppTransitionForAllDisplay();
            return true;
        }
        return false;
    }

    private void handleLaunchTaskBehindCompleteLocked(ActivityRecord r) {
        TaskRecord task = r.getTaskRecord();
        Object stack = task.getStack();
        r.mLaunchTaskBehind = false;
        this.mRecentTasks.add(task);
        this.mService.getTaskChangeNotificationController().notifyTaskStackChanged();
        r.setVisibility(false);
        ActivityRecord top = ((ActivityStack)stack).getTopActivity();
        if (top != null) {
            top.getTaskRecord().touchActiveTime();
        }
    }

    void scheduleLaunchTaskBehindComplete(IBinder token) {
        this.mHandler.obtainMessage(212, token).sendToTarget();
    }

    boolean isCurrentProfileLocked(int userId) {
        if (userId == this.mRootActivityContainer.mCurrentUser) {
            return true;
        }
        return this.mService.mAmInternal.isCurrentProfile(userId);
    }

    boolean isStoppingNoHistoryActivity() {
        for (ActivityRecord record : this.mStoppingActivities) {
            if (!record.isNoHistory()) continue;
            return true;
        }
        return false;
    }

    final ArrayList<ActivityRecord> processStoppingActivitiesLocked(ActivityRecord idleActivity, boolean remove, boolean processPausingActivities) {
        ArrayList<ActivityRecord> stops = null;
        boolean nowVisible = this.mRootActivityContainer.allResumedActivitiesVisible();
        for (int activityNdx = this.mStoppingActivities.size() - 1; activityNdx >= 0; --activityNdx) {
            boolean shouldSleepOrShutDown;
            ActivityRecord s = this.mStoppingActivities.get(activityNdx);
            boolean animating = s.mAppWindowToken.isSelfAnimating();
            if (nowVisible && s.finishing) {
                s.setVisibility(false);
            }
            if (!remove) continue;
            Object stack = s.getActivityStack();
            boolean bl = shouldSleepOrShutDown = stack != null ? ((ActivityStack)stack).shouldSleepOrShutDownActivities() : this.mService.isSleepingOrShuttingDownLocked();
            if (animating && !shouldSleepOrShutDown) continue;
            if (!processPausingActivities && s.isState(ActivityStack.ActivityState.PAUSING)) {
                this.removeTimeoutsForActivityLocked(idleActivity);
                this.scheduleIdleTimeoutLocked(idleActivity);
                continue;
            }
            if (stops == null) {
                stops = new ArrayList<ActivityRecord>();
            }
            stops.add(s);
            this.mStoppingActivities.remove(activityNdx);
        }
        return stops;
    }

    public void dump(PrintWriter pw, String prefix) {
        pw.println();
        pw.println("ActivityStackSupervisor state:");
        this.mRootActivityContainer.dump(pw, prefix);
        pw.print(prefix);
        pw.println("mCurTaskIdForUser=" + this.mCurTaskIdForUser);
        pw.println(prefix + "mUserStackInFront=" + this.mRootActivityContainer.mUserStackInFront);
        if (!this.mWaitingForActivityVisible.isEmpty()) {
            pw.println(prefix + "mWaitingForActivityVisible=");
            for (int i = 0; i < this.mWaitingForActivityVisible.size(); ++i) {
                pw.print(prefix + prefix);
                this.mWaitingForActivityVisible.get(i).dump(pw, prefix);
            }
        }
        pw.print(prefix);
        pw.print("isHomeRecentsComponent=");
        pw.print(this.mRecentTasks.isRecentsComponentHomeActivity(this.mRootActivityContainer.mCurrentUser));
        this.getKeyguardController().dump(pw, prefix);
        this.mService.getLockTaskController().dump(pw, prefix);
    }

    static boolean printThisActivity(PrintWriter pw, ActivityRecord activity, String dumpPackage, boolean needSep, String prefix) {
        if (activity != null && (dumpPackage == null || dumpPackage.equals(activity.packageName))) {
            if (needSep) {
                pw.println();
            }
            pw.print(prefix);
            pw.println(activity);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean dumpHistoryList(FileDescriptor fd, PrintWriter pw, List<ActivityRecord> list, String prefix, String label, boolean complete, boolean brief, boolean client, String dumpPackage, boolean needNL, String header, TaskRecord lastTask) {
        String innerPrefix = null;
        String[] args = null;
        boolean printed = false;
        for (int i = list.size() - 1; i >= 0; --i) {
            boolean full;
            ActivityRecord r = list.get(i);
            if (dumpPackage != null && !dumpPackage.equals(r.packageName)) continue;
            if (innerPrefix == null) {
                innerPrefix = prefix + "      ";
                args = new String[]{};
            }
            printed = true;
            boolean bl = full = !brief && (complete || !r.isInHistory());
            if (needNL) {
                pw.println("");
                needNL = false;
            }
            if (header != null) {
                pw.println(header);
                header = null;
            }
            if (lastTask != r.getTaskRecord()) {
                lastTask = r.getTaskRecord();
                pw.print(prefix);
                pw.print(full ? "* " : "  ");
                pw.println(lastTask);
                if (full) {
                    lastTask.dump(pw, prefix + "  ");
                } else if (complete && lastTask.intent != null) {
                    pw.print(prefix);
                    pw.print("  ");
                    pw.println(lastTask.intent.toInsecureStringWithClip());
                }
            }
            pw.print(prefix);
            pw.print(full ? "  * " : "    ");
            pw.print(label);
            pw.print(" #");
            pw.print(i);
            pw.print(": ");
            pw.println(r);
            if (full) {
                r.dump(pw, innerPrefix);
            } else if (complete) {
                pw.print(innerPrefix);
                pw.println(r.intent.toInsecureString());
                if (r.app != null) {
                    pw.print(innerPrefix);
                    pw.println(r.app);
                }
            }
            if (!client || !r.attachedToProcess()) continue;
            pw.flush();
            try {
                TransferPipe tp = new TransferPipe();
                try {
                    r.app.getThread().dumpActivity(tp.getWriteFd(), r.appToken, innerPrefix, args);
                    tp.go(fd, 2000L);
                }
                finally {
                    tp.kill();
                }
            }
            catch (IOException e) {
                pw.println(innerPrefix + "Failure while dumping the activity: " + e);
            }
            catch (RemoteException e) {
                pw.println(innerPrefix + "Got a RemoteException while dumping the activity");
            }
            needNL = true;
        }
        return printed;
    }

    void scheduleIdleTimeoutLocked(ActivityRecord next) {
        Message msg = this.mHandler.obtainMessage(200, next);
        this.mHandler.sendMessageDelayed(msg, 10000L);
    }

    final void scheduleIdleLocked() {
        this.mHandler.sendEmptyMessage(201);
    }

    void updateTopResumedActivityIfNeeded() {
        boolean prevActivityReceivedTopState;
        ActivityRecord prevTopActivity = this.mTopResumedActivity;
        ActivityStack topStack = this.mRootActivityContainer.getTopDisplayFocusedStack();
        if (topStack == null || topStack.mResumedActivity == prevTopActivity) {
            return;
        }
        boolean bl = prevActivityReceivedTopState = prevTopActivity != null && !this.mTopResumedActivityWaitingForPrev;
        if (prevActivityReceivedTopState && prevTopActivity.scheduleTopResumedActivityChanged(false)) {
            this.scheduleTopResumedStateLossTimeout(prevTopActivity);
            this.mTopResumedActivityWaitingForPrev = true;
        }
        this.mTopResumedActivity = topStack.mResumedActivity;
        this.scheduleTopResumedActivityStateIfNeeded();
    }

    private void scheduleTopResumedActivityStateIfNeeded() {
        if (this.mTopResumedActivity != null && !this.mTopResumedActivityWaitingForPrev) {
            this.mTopResumedActivity.scheduleTopResumedActivityChanged(true);
        }
    }

    private void scheduleTopResumedStateLossTimeout(ActivityRecord r) {
        Message msg = this.mHandler.obtainMessage(217);
        msg.obj = r;
        r.topResumedStateLossTime = SystemClock.uptimeMillis();
        this.mHandler.sendMessageDelayed(msg, 500L);
    }

    void handleTopResumedStateReleased(boolean timeout) {
        this.mHandler.removeMessages(217);
        if (!this.mTopResumedActivityWaitingForPrev) {
            return;
        }
        this.mTopResumedActivityWaitingForPrev = false;
        this.scheduleTopResumedActivityStateIfNeeded();
    }

    void removeTimeoutsForActivityLocked(ActivityRecord r) {
        this.mHandler.removeMessages(200, r);
    }

    final void scheduleResumeTopActivities() {
        if (!this.mHandler.hasMessages(202)) {
            this.mHandler.sendEmptyMessage(202);
        }
    }

    void removeSleepTimeouts() {
        this.mHandler.removeMessages(203);
    }

    final void scheduleSleepTimeout() {
        this.removeSleepTimeouts();
        this.mHandler.sendEmptyMessageDelayed(203, 5000L);
    }

    void removeRestartTimeouts(ActivityRecord r) {
        this.mHandler.removeMessages(213, r);
    }

    final void scheduleRestartTimeout(ActivityRecord r) {
        this.removeRestartTimeouts(r);
        this.mHandler.sendMessageDelayed(this.mHandler.obtainMessage(213, r), 2000L);
    }

    void handleNonResizableTaskIfNeeded(TaskRecord task, int preferredWindowingMode, int preferredDisplayId, ActivityStack actualStack) {
        this.handleNonResizableTaskIfNeeded(task, preferredWindowingMode, preferredDisplayId, actualStack, false);
    }

    void handleNonResizableTaskIfNeeded(TaskRecord task, int preferredWindowingMode, int preferredDisplayId, ActivityStack actualStack, boolean forceNonResizable) {
        boolean inSplitScreenMode;
        boolean isSecondaryDisplayPreferred = preferredDisplayId != 0 && preferredDisplayId != -1;
        boolean bl = inSplitScreenMode = actualStack != null && actualStack.getDisplay().hasSplitScreenPrimaryStack();
        if (!inSplitScreenMode && preferredWindowingMode != 3 && !isSecondaryDisplayPreferred || !task.isActivityTypeStandardOrUndefined()) {
            return;
        }
        if (isSecondaryDisplayPreferred) {
            boolean singleTaskInstance;
            int actualDisplayId = ((ActivityStack)task.getStack()).mDisplayId;
            if (!task.canBeLaunchedOnDisplay(actualDisplayId)) {
                throw new IllegalStateException("Task resolved to incompatible display");
            }
            ActivityDisplay preferredDisplay = this.mRootActivityContainer.getActivityDisplay(preferredDisplayId);
            boolean bl2 = singleTaskInstance = preferredDisplay != null && preferredDisplay.isSingleTaskInstance();
            if (preferredDisplayId != actualDisplayId) {
                if (singleTaskInstance) {
                    this.mService.getTaskChangeNotificationController().notifyActivityLaunchOnSecondaryDisplayRerouted(task.getTaskInfo(), preferredDisplayId);
                    return;
                }
                Slog.w("ActivityTaskManager", "Failed to put " + task + " on display " + preferredDisplayId);
                this.mService.getTaskChangeNotificationController().notifyActivityLaunchOnSecondaryDisplayFailed(task.getTaskInfo(), preferredDisplayId);
            } else if (!forceNonResizable) {
                this.handleForcedResizableTaskIfNeeded(task, 2);
            }
            return;
        }
        if (!task.supportsSplitScreenWindowingMode() || forceNonResizable) {
            ActivityStack dockedStack = ((ActivityStack)task.getStack()).getDisplay().getSplitScreenPrimaryStack();
            if (dockedStack != null) {
                this.mService.getTaskChangeNotificationController().notifyActivityDismissingDockedStack();
                this.moveTasksToFullscreenStackLocked(dockedStack, actualStack == dockedStack);
            }
            return;
        }
        this.handleForcedResizableTaskIfNeeded(task, 1);
    }

    private void handleForcedResizableTaskIfNeeded(TaskRecord task, int reason) {
        ActivityRecord topActivity = task.getTopActivity();
        if (topActivity == null || topActivity.noDisplay || !topActivity.isNonResizableOrForcedResizable()) {
            return;
        }
        this.mService.getTaskChangeNotificationController().notifyActivityForcedResizable(task.taskId, reason, topActivity.appInfo.packageName);
    }

    void activityRelaunchedLocked(IBinder token) {
        this.mWindowManager.notifyAppRelaunchingFinished(token);
        ActivityRecord r = ActivityRecord.isInStackLocked(token);
        if (r != null && ((ActivityStack)r.getActivityStack()).shouldSleepOrShutDownActivities()) {
            r.setSleeping(true, true);
        }
    }

    void activityRelaunchingLocked(ActivityRecord r) {
        this.mWindowManager.notifyAppRelaunching(r.appToken);
    }

    void logStackState() {
        this.mActivityMetricsLogger.logWindowState();
    }

    void scheduleUpdateMultiWindowMode(TaskRecord task) {
        if (((ActivityStack)task.getStack()).deferScheduleMultiWindowModeChanged()) {
            return;
        }
        for (int i = task.mActivities.size() - 1; i >= 0; --i) {
            ActivityRecord r = task.mActivities.get(i);
            if (!r.attachedToProcess()) continue;
            this.mMultiWindowModeChangedActivities.add(r);
        }
        if (!this.mHandler.hasMessages(214)) {
            this.mHandler.sendEmptyMessage(214);
        }
    }

    void scheduleUpdatePictureInPictureModeIfNeeded(TaskRecord task, ActivityStack prevStack) {
        Object stack = task.getStack();
        if (prevStack == null || prevStack == stack || !prevStack.inPinnedWindowingMode() && !((ConfigurationContainer)stack).inPinnedWindowingMode()) {
            return;
        }
        this.scheduleUpdatePictureInPictureModeIfNeeded(task, ((ConfigurationContainer)stack).getRequestedOverrideBounds());
    }

    void scheduleUpdatePictureInPictureModeIfNeeded(TaskRecord task, Rect targetStackBounds) {
        for (int i = task.mActivities.size() - 1; i >= 0; --i) {
            ActivityRecord r = task.mActivities.get(i);
            if (!r.attachedToProcess()) continue;
            this.mPipModeChangedActivities.add(r);
            this.mMultiWindowModeChangedActivities.remove(r);
        }
        this.mPipModeChangedTargetStackBounds = targetStackBounds;
        if (!this.mHandler.hasMessages(215)) {
            this.mHandler.sendEmptyMessage(215);
        }
    }

    void updatePictureInPictureMode(TaskRecord task, Rect targetStackBounds, boolean forceUpdate) {
        this.mHandler.removeMessages(215);
        for (int i = task.mActivities.size() - 1; i >= 0; --i) {
            ActivityRecord r = task.mActivities.get(i);
            if (!r.attachedToProcess()) continue;
            r.updatePictureInPictureMode(targetStackBounds, forceUpdate);
        }
    }

    void wakeUp(String reason) {
        this.mPowerManager.wakeUp(SystemClock.uptimeMillis(), 2, "android.server.am:TURN_ON:" + reason);
    }

    void beginDeferResume() {
        ++this.mDeferResumeCount;
    }

    void endDeferResume() {
        --this.mDeferResumeCount;
    }

    boolean readyToResume() {
        return this.mDeferResumeCount == 0;
    }

    void setResizingDuringAnimation(TaskRecord task) {
        this.mResizingTasksDuringAnimation.add(task.taskId);
        task.setTaskDockedResizing(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int startActivityFromRecents(int callingPid, int callingUid, int taskId, SafeActivityOptions options) {
        int n;
        block19: {
            int windowingMode;
            TaskRecord task;
            block16: {
                int n2;
                block18: {
                    ActivityStack topSecondaryStack;
                    ActivityDisplay display;
                    ActivityOptions activityOptions;
                    task = null;
                    int activityType = 0;
                    windowingMode = 0;
                    ActivityOptions activityOptions2 = activityOptions = options != null ? options.getOptions(this) : null;
                    if (activityOptions != null) {
                        activityType = activityOptions.getLaunchActivityType();
                        windowingMode = activityOptions.getLaunchWindowingMode();
                        if (activityOptions.freezeRecentTasksReordering() && this.mRecentTasks.isCallerRecents(callingUid)) {
                            this.mRecentTasks.setFreezeTaskListReordering();
                        }
                    }
                    if (activityType == 2 || activityType == 3) {
                        throw new IllegalArgumentException("startActivityFromRecents: Task " + taskId + " can't be launch in the home/recents stack.");
                    }
                    this.mWindowManager.deferSurfaceLayout();
                    try {
                        if (windowingMode == 3) {
                            this.mWindowManager.setDockedStackCreateState(activityOptions.getSplitScreenCreateMode(), null);
                            this.deferUpdateRecentsHomeStackBounds();
                            this.mWindowManager.prepareAppTransition(19, false);
                        }
                        if ((task = this.mRootActivityContainer.anyTaskForId(taskId, 2, activityOptions, true)) == null) {
                            this.continueUpdateRecentsHomeStackBounds();
                            this.mWindowManager.executeAppTransition();
                            throw new IllegalArgumentException("startActivityFromRecents: Task " + taskId + " not found.");
                        }
                        if (windowingMode != 3) {
                            this.mRootActivityContainer.getDefaultDisplay().moveHomeStackToFront("startActivityFromRecents");
                        }
                        if (this.mService.mAmInternal.shouldConfirmCredentials(task.userId) || task.getRootActivity() == null) break block16;
                        ActivityRecord targetActivity = task.getTopActivity();
                        this.mRootActivityContainer.sendPowerHintForLaunchStartIfNeeded(true, targetActivity);
                        this.mActivityMetricsLogger.notifyActivityLaunching(task.intent);
                        try {
                            this.mService.moveTaskToFrontLocked(null, null, task.taskId, 0, options, true);
                            targetActivity.applyOptionsLocked();
                        }
                        finally {
                            this.mActivityMetricsLogger.notifyActivityLaunched(2, targetActivity);
                        }
                        this.mService.getActivityStartController().postStartActivityProcessingForLastStarter(task.getTopActivity(), 2, (ActivityStack)task.getStack());
                        n2 = 2;
                        if (windowingMode != 3 || task == null) break block18;
                        this.setResizingDuringAnimation(task);
                        display = ((ActivityStack)task.getStack()).getDisplay();
                        topSecondaryStack = display.getTopStackInWindowingMode(4);
                    }
                    catch (Throwable throwable) {
                        if (windowingMode == 3 && task != null) {
                            this.setResizingDuringAnimation(task);
                            ActivityDisplay display2 = ((ActivityStack)task.getStack()).getDisplay();
                            ActivityStack topSecondaryStack2 = display2.getTopStackInWindowingMode(4);
                            if (topSecondaryStack2.isActivityTypeHome()) {
                                display2.moveHomeStackToFront("startActivityFromRecents: homeVisibleInSplitScreen");
                                this.mWindowManager.checkSplitScreenMinimizedChanged(false);
                            }
                        }
                        this.mWindowManager.continueSurfaceLayout();
                        throw throwable;
                    }
                    if (topSecondaryStack.isActivityTypeHome()) {
                        display.moveHomeStackToFront("startActivityFromRecents: homeVisibleInSplitScreen");
                        this.mWindowManager.checkSplitScreenMinimizedChanged(false);
                    }
                }
                this.mWindowManager.continueSurfaceLayout();
                return n2;
            }
            String callingPackage = task.mCallingPackage;
            Intent intent = task.intent;
            intent.addFlags(0x100000);
            int userId = task.userId;
            n = this.mService.getActivityStartController().startActivityInPackage(task.mCallingUid, callingPid, callingUid, callingPackage, intent, null, null, null, 0, 0, options, userId, task, "startActivityFromRecents", false, null, false);
            if (windowingMode != 3 || task == null) break block19;
            this.setResizingDuringAnimation(task);
            ActivityDisplay display = ((ActivityStack)task.getStack()).getDisplay();
            ActivityStack topSecondaryStack = display.getTopStackInWindowingMode(4);
            if (topSecondaryStack.isActivityTypeHome()) {
                display.moveHomeStackToFront("startActivityFromRecents: homeVisibleInSplitScreen");
                this.mWindowManager.checkSplitScreenMinimizedChanged(false);
            }
        }
        this.mWindowManager.continueSurfaceLayout();
        return n;
    }

    static {
        ACTION_TO_RUNTIME_PERMISSION.put("android.media.action.IMAGE_CAPTURE", "android.permission.CAMERA");
        ACTION_TO_RUNTIME_PERMISSION.put("android.media.action.VIDEO_CAPTURE", "android.permission.CAMERA");
        ACTION_TO_RUNTIME_PERMISSION.put("android.intent.action.CALL", "android.permission.CALL_PHONE");
    }

    static class WaitInfo {
        private final ComponentName mTargetComponent;
        private final WaitResult mResult;
        private final long mStartTimeMs;

        WaitInfo(ComponentName targetComponent, WaitResult result, long startTimeMs) {
            this.mTargetComponent = targetComponent;
            this.mResult = result;
            this.mStartTimeMs = startTimeMs;
        }

        public boolean matches(ComponentName targetComponent) {
            return this.mTargetComponent == null || this.mTargetComponent.equals(targetComponent);
        }

        public WaitResult getResult() {
            return this.mResult;
        }

        public long getStartTime() {
            return this.mStartTimeMs;
        }

        public ComponentName getComponent() {
            return this.mTargetComponent;
        }

        public void dump(PrintWriter pw, String prefix) {
            pw.println(prefix + "WaitInfo:");
            pw.println(prefix + "  mTargetComponent=" + this.mTargetComponent);
            pw.println(prefix + "  mResult=");
            this.mResult.dump(pw, prefix);
        }
    }

    private final class ActivityStackSupervisorHandler
    extends Handler {
        public ActivityStackSupervisorHandler(Looper looper) {
            super(looper);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void activityIdleInternal(ActivityRecord r, boolean processPausingActivities) {
            WindowManagerGlobalLock windowManagerGlobalLock = ActivityStackSupervisor.this.mService.mGlobalLock;
            synchronized (windowManagerGlobalLock) {
                try {
                    WindowManagerService.boostPriorityForLockedSection();
                    ActivityStackSupervisor.this.activityIdleInternalLocked(r != null ? r.appToken : null, true, processPausingActivities, null);
                }
                catch (Throwable throwable) {
                    // MONITOREXIT @DISABLED, blocks:[1, 2] lbl10 : MonitorExitStatement: MONITOREXIT : var3_3
                    WindowManagerService.resetPriorityAfterLockedSection();
                    throw throwable;
                }
            }
            WindowManagerService.resetPriorityAfterLockedSection();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 214: {
                    WindowManagerGlobalLock windowManagerGlobalLock = ActivityStackSupervisor.this.mService.mGlobalLock;
                    synchronized (windowManagerGlobalLock) {
                        try {
                            WindowManagerService.boostPriorityForLockedSection();
                            for (int i = ActivityStackSupervisor.this.mMultiWindowModeChangedActivities.size() - 1; i >= 0; --i) {
                                ActivityRecord r = ActivityStackSupervisor.this.mMultiWindowModeChangedActivities.remove(i);
                                r.updateMultiWindowMode();
                            }
                        }
                        catch (Throwable throwable) {
                            // MONITOREXIT @DISABLED, blocks:[18, 19, 9, 31] lbl14 : MonitorExitStatement: MONITOREXIT : windowManagerGlobalLock
                            WindowManagerService.resetPriorityAfterLockedSection();
                            throw throwable;
                        }
                    }
                    WindowManagerService.resetPriorityAfterLockedSection();
                    return;
                }
                case 215: {
                    WindowManagerGlobalLock windowManagerGlobalLock = ActivityStackSupervisor.this.mService.mGlobalLock;
                    synchronized (windowManagerGlobalLock) {
                        try {
                            WindowManagerService.boostPriorityForLockedSection();
                            for (int i = ActivityStackSupervisor.this.mPipModeChangedActivities.size() - 1; i >= 0; --i) {
                                ActivityRecord r = ActivityStackSupervisor.this.mPipModeChangedActivities.remove(i);
                                r.updatePictureInPictureMode(ActivityStackSupervisor.this.mPipModeChangedTargetStackBounds, false);
                            }
                        }
                        catch (Throwable throwable) {
                            // MONITOREXIT @DISABLED, blocks:[32, 18, 20, 10] lbl31 : MonitorExitStatement: MONITOREXIT : windowManagerGlobalLock
                            WindowManagerService.resetPriorityAfterLockedSection();
                            throw throwable;
                        }
                    }
                    WindowManagerService.resetPriorityAfterLockedSection();
                    return;
                }
                case 200: {
                    this.activityIdleInternal((ActivityRecord)msg.obj, true);
                    return;
                }
                case 201: {
                    this.activityIdleInternal((ActivityRecord)msg.obj, false);
                    return;
                }
                case 202: {
                    WindowManagerGlobalLock windowManagerGlobalLock = ActivityStackSupervisor.this.mService.mGlobalLock;
                    synchronized (windowManagerGlobalLock) {
                        try {
                            WindowManagerService.boostPriorityForLockedSection();
                            ActivityStackSupervisor.this.mRootActivityContainer.resumeFocusedStacksTopActivities();
                        }
                        catch (Throwable throwable) {
                            // MONITOREXIT @DISABLED, blocks:[33, 18, 23, 11] lbl52 : MonitorExitStatement: MONITOREXIT : windowManagerGlobalLock
                            WindowManagerService.resetPriorityAfterLockedSection();
                            throw throwable;
                        }
                    }
                    WindowManagerService.resetPriorityAfterLockedSection();
                    return;
                }
                case 203: {
                    WindowManagerGlobalLock windowManagerGlobalLock = ActivityStackSupervisor.this.mService.mGlobalLock;
                    synchronized (windowManagerGlobalLock) {
                        try {
                            WindowManagerService.boostPriorityForLockedSection();
                            if (ActivityStackSupervisor.this.mService.isSleepingOrShuttingDownLocked()) {
                                Slog.w("ActivityTaskManager", "Sleep timeout!  Sleeping now.");
                                ActivityStackSupervisor.this.checkReadyForSleepLocked(false);
                            }
                        }
                        catch (Throwable throwable) {
                            // MONITOREXIT @DISABLED, blocks:[18, 34, 24, 12] lbl69 : MonitorExitStatement: MONITOREXIT : windowManagerGlobalLock
                            WindowManagerService.resetPriorityAfterLockedSection();
                            throw throwable;
                        }
                    }
                    WindowManagerService.resetPriorityAfterLockedSection();
                    return;
                }
                case 204: {
                    WindowManagerGlobalLock windowManagerGlobalLock = ActivityStackSupervisor.this.mService.mGlobalLock;
                    synchronized (windowManagerGlobalLock) {
                        try {
                            WindowManagerService.boostPriorityForLockedSection();
                            if (ActivityStackSupervisor.this.mLaunchingActivityWakeLock.isHeld()) {
                                Slog.w("ActivityTaskManager", "Launch timeout has expired, giving up wake lock!");
                                ActivityStackSupervisor.this.mLaunchingActivityWakeLock.release();
                            }
                        }
                        catch (Throwable throwable) {
                            // MONITOREXIT @DISABLED, blocks:[18, 35, 25, 13] lbl86 : MonitorExitStatement: MONITOREXIT : windowManagerGlobalLock
                            WindowManagerService.resetPriorityAfterLockedSection();
                            throw throwable;
                        }
                    }
                    WindowManagerService.resetPriorityAfterLockedSection();
                    return;
                }
                case 212: {
                    WindowManagerGlobalLock windowManagerGlobalLock = ActivityStackSupervisor.this.mService.mGlobalLock;
                    synchronized (windowManagerGlobalLock) {
                        try {
                            WindowManagerService.boostPriorityForLockedSection();
                            ActivityRecord r = ActivityRecord.forTokenLocked((IBinder)msg.obj);
                            if (r != null) {
                                ActivityStackSupervisor.this.handleLaunchTaskBehindCompleteLocked(r);
                            }
                        }
                        catch (Throwable throwable) {
                            // MONITOREXIT @DISABLED, blocks:[18, 36, 26, 14] lbl102 : MonitorExitStatement: MONITOREXIT : windowManagerGlobalLock
                            WindowManagerService.resetPriorityAfterLockedSection();
                            throw throwable;
                        }
                    }
                    WindowManagerService.resetPriorityAfterLockedSection();
                    return;
                }
                case 213: {
                    ActivityRecord r = (ActivityRecord)msg.obj;
                    String processName = null;
                    int uid = 0;
                    WindowManagerGlobalLock windowManagerGlobalLock = ActivityStackSupervisor.this.mService.mGlobalLock;
                    synchronized (windowManagerGlobalLock) {
                        try {
                            WindowManagerService.boostPriorityForLockedSection();
                            if (r.attachedToProcess() && r.isState(ActivityStack.ActivityState.RESTARTING_PROCESS)) {
                                processName = r.app.mName;
                                uid = r.app.mUid;
                            }
                        }
                        catch (Throwable throwable) {
                            // MONITOREXIT @DISABLED, blocks:[16, 18, 37, 27] lbl121 : MonitorExitStatement: MONITOREXIT : windowManagerGlobalLock
                            WindowManagerService.resetPriorityAfterLockedSection();
                            throw throwable;
                        }
                    }
                    WindowManagerService.resetPriorityAfterLockedSection();
                    if (processName == null) return;
                    ActivityStackSupervisor.this.mService.mAmInternal.killProcess(processName, uid, "restartActivityProcessTimeout");
                    return;
                }
                case 216: {
                    WindowManagerGlobalLock r = ActivityStackSupervisor.this.mService.mGlobalLock;
                    synchronized (r) {
                        try {
                            WindowManagerService.boostPriorityForLockedSection();
                            ActivityStackSupervisor.this.mHandler.removeMessages(216);
                            ActivityStackSupervisor.this.mRootActivityContainer.startHomeOnEmptyDisplays("homeChanged");
                        }
                        catch (Throwable throwable) {
                            // MONITOREXIT @DISABLED, blocks:[18, 38, 28, 15] lbl138 : MonitorExitStatement: MONITOREXIT : r
                            WindowManagerService.resetPriorityAfterLockedSection();
                            throw throwable;
                        }
                    }
                    WindowManagerService.resetPriorityAfterLockedSection();
                    return;
                }
                case 217: {
                    ActivityRecord r = (ActivityRecord)msg.obj;
                    Slog.w("ActivityTaskManager", "Activity top resumed state loss timeout for " + r);
                    WindowManagerGlobalLock windowManagerGlobalLock = ActivityStackSupervisor.this.mService.mGlobalLock;
                    synchronized (windowManagerGlobalLock) {
                        try {
                            WindowManagerService.boostPriorityForLockedSection();
                            if (r.hasProcess()) {
                                ActivityStackSupervisor.this.mService.logAppTooSlow(r.app, r.topResumedStateLossTime, "top state loss for " + r);
                            }
                        }
                        catch (Throwable throwable) {
                            // MONITOREXIT @DISABLED, blocks:[17, 18, 39, 29] lbl156 : MonitorExitStatement: MONITOREXIT : windowManagerGlobalLock
                            WindowManagerService.resetPriorityAfterLockedSection();
                            throw throwable;
                        }
                    }
                    WindowManagerService.resetPriorityAfterLockedSection();
                    ActivityStackSupervisor.this.handleTopResumedStateReleased(true);
                    return;
                }
            }
        }
    }

    static class PendingActivityLaunch {
        final ActivityRecord r;
        final ActivityRecord sourceRecord;
        final int startFlags;
        final ActivityStack stack;
        final WindowProcessController callerApp;

        PendingActivityLaunch(ActivityRecord _r, ActivityRecord _sourceRecord, int _startFlags, ActivityStack _stack, WindowProcessController app) {
            this.r = _r;
            this.sourceRecord = _sourceRecord;
            this.startFlags = _startFlags;
            this.stack = _stack;
            this.callerApp = app;
        }

        void sendErrorResult(String message) {
            try {
                if (this.callerApp != null && this.callerApp.hasThread()) {
                    this.callerApp.getThread().scheduleCrash(message);
                }
            }
            catch (RemoteException e) {
                Slog.e("ActivityTaskManager", "Exception scheduling crash of failed activity launcher sourceRecord=" + this.sourceRecord, e);
            }
        }
    }
}

