/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import android.app.ActivityManager;
import android.app.ActivityOptions;
import android.app.IApplicationThread;
import android.app.ProfilerInfo;
import android.app.WaitResult;
import android.content.IIntentSender;
import android.content.Intent;
import android.content.IntentSender;
import android.content.pm.ActivityInfo;
import android.content.pm.AuxiliaryResolveInfo;
import android.content.pm.ResolveInfo;
import android.content.res.Configuration;
import android.graphics.Rect;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.SystemClock;
import android.os.Trace;
import android.os.UserHandle;
import android.os.UserManager;
import android.service.voice.IVoiceInteractionSession;
import android.text.TextUtils;
import android.util.ArraySet;
import android.util.EventLog;
import android.util.Pools;
import android.util.Slog;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.app.HeavyWeightSwitcherActivity;
import com.android.internal.app.IVoiceInteractor;
import com.android.server.am.PendingIntentRecord;
import com.android.server.pm.InstantAppResolver;
import com.android.server.wm.ActivityRecord;
import com.android.server.wm.ActivityStack;
import com.android.server.wm.ActivityStackSupervisor;
import com.android.server.wm.ActivityStartController;
import com.android.server.wm.ActivityStartInterceptor;
import com.android.server.wm.ActivityTaskManagerService;
import com.android.server.wm.ConfigurationContainer;
import com.android.server.wm.LaunchParamsController;
import com.android.server.wm.RootActivityContainer;
import com.android.server.wm.SafeActivityOptions;
import com.android.server.wm.TaskRecord;
import com.android.server.wm.WindowManagerService;
import com.android.server.wm.WindowProcessController;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.util.Date;

class ActivityStarter {
    private static final String TAG = "ActivityTaskManager";
    private static final String TAG_RESULTS = "ActivityTaskManager";
    private static final String TAG_FOCUS = "ActivityTaskManager";
    private static final String TAG_CONFIGURATION = "ActivityTaskManager";
    private static final String TAG_USER_LEAVING = "ActivityTaskManager";
    private static final int INVALID_LAUNCH_MODE = -1;
    private final ActivityTaskManagerService mService;
    private final RootActivityContainer mRootActivityContainer;
    private final ActivityStackSupervisor mSupervisor;
    private final ActivityStartInterceptor mInterceptor;
    private final ActivityStartController mController;
    private ActivityRecord mStartActivity;
    private Intent mIntent;
    private int mCallingUid;
    private ActivityOptions mOptions;
    private boolean mRestrictedBgActivity;
    private int mLaunchMode;
    private boolean mLaunchTaskBehind;
    private int mLaunchFlags;
    private LaunchParamsController.LaunchParams mLaunchParams = new LaunchParamsController.LaunchParams();
    private ActivityRecord mNotTop;
    private boolean mDoResume;
    private int mStartFlags;
    private ActivityRecord mSourceRecord;
    private int mPreferredDisplayId;
    private TaskRecord mInTask;
    private boolean mAddingToTask;
    private TaskRecord mReuseTask;
    private ActivityInfo mNewTaskInfo;
    private Intent mNewTaskIntent;
    private ActivityStack mSourceStack;
    private ActivityStack mTargetStack;
    private boolean mMovedToFront;
    private boolean mNoAnimation;
    private boolean mKeepCurTransition;
    private boolean mAvoidMoveToFront;
    private boolean mIntentDelivered;
    private IVoiceInteractionSession mVoiceSession;
    private IVoiceInteractor mVoiceInteractor;
    private final ActivityRecord[] mLastStartActivityRecord = new ActivityRecord[1];
    private int mLastStartActivityResult;
    private long mLastStartActivityTimeMs;
    private String mLastStartReason;
    private Request mRequest = new Request();

    ActivityStarter(ActivityStartController controller, ActivityTaskManagerService service, ActivityStackSupervisor supervisor, ActivityStartInterceptor interceptor) {
        this.mController = controller;
        this.mService = service;
        this.mRootActivityContainer = service.mRootActivityContainer;
        this.mSupervisor = supervisor;
        this.mInterceptor = interceptor;
        this.reset(true);
    }

    void set(ActivityStarter starter) {
        this.mStartActivity = starter.mStartActivity;
        this.mIntent = starter.mIntent;
        this.mCallingUid = starter.mCallingUid;
        this.mOptions = starter.mOptions;
        this.mRestrictedBgActivity = starter.mRestrictedBgActivity;
        this.mLaunchTaskBehind = starter.mLaunchTaskBehind;
        this.mLaunchFlags = starter.mLaunchFlags;
        this.mLaunchMode = starter.mLaunchMode;
        this.mLaunchParams.set(starter.mLaunchParams);
        this.mNotTop = starter.mNotTop;
        this.mDoResume = starter.mDoResume;
        this.mStartFlags = starter.mStartFlags;
        this.mSourceRecord = starter.mSourceRecord;
        this.mPreferredDisplayId = starter.mPreferredDisplayId;
        this.mInTask = starter.mInTask;
        this.mAddingToTask = starter.mAddingToTask;
        this.mReuseTask = starter.mReuseTask;
        this.mNewTaskInfo = starter.mNewTaskInfo;
        this.mNewTaskIntent = starter.mNewTaskIntent;
        this.mSourceStack = starter.mSourceStack;
        this.mTargetStack = starter.mTargetStack;
        this.mMovedToFront = starter.mMovedToFront;
        this.mNoAnimation = starter.mNoAnimation;
        this.mKeepCurTransition = starter.mKeepCurTransition;
        this.mAvoidMoveToFront = starter.mAvoidMoveToFront;
        this.mVoiceSession = starter.mVoiceSession;
        this.mVoiceInteractor = starter.mVoiceInteractor;
        this.mIntentDelivered = starter.mIntentDelivered;
        this.mRequest.set(starter.mRequest);
    }

    ActivityRecord getStartActivity() {
        return this.mStartActivity;
    }

    boolean relatedToPackage(String packageName) {
        return this.mLastStartActivityRecord[0] != null && packageName.equals(this.mLastStartActivityRecord[0].packageName) || this.mStartActivity != null && packageName.equals(this.mStartActivity.packageName);
    }

    int execute() {
        try {
            if (this.mRequest.mayWait) {
                int n = this.startActivityMayWait(this.mRequest.caller, this.mRequest.callingUid, this.mRequest.callingPackage, this.mRequest.realCallingPid, this.mRequest.realCallingUid, this.mRequest.intent, this.mRequest.resolvedType, this.mRequest.voiceSession, this.mRequest.voiceInteractor, this.mRequest.resultTo, this.mRequest.resultWho, this.mRequest.requestCode, this.mRequest.startFlags, this.mRequest.profilerInfo, this.mRequest.waitResult, this.mRequest.globalConfig, this.mRequest.activityOptions, this.mRequest.ignoreTargetSecurity, this.mRequest.userId, this.mRequest.inTask, this.mRequest.reason, this.mRequest.allowPendingRemoteAnimationRegistryLookup, this.mRequest.originatingPendingIntent, this.mRequest.allowBackgroundActivityStart);
                return n;
            }
            int n = this.startActivity(this.mRequest.caller, this.mRequest.intent, this.mRequest.ephemeralIntent, this.mRequest.resolvedType, this.mRequest.activityInfo, this.mRequest.resolveInfo, this.mRequest.voiceSession, this.mRequest.voiceInteractor, this.mRequest.resultTo, this.mRequest.resultWho, this.mRequest.requestCode, this.mRequest.callingPid, this.mRequest.callingUid, this.mRequest.callingPackage, this.mRequest.realCallingPid, this.mRequest.realCallingUid, this.mRequest.startFlags, this.mRequest.activityOptions, this.mRequest.ignoreTargetSecurity, this.mRequest.componentSpecified, this.mRequest.outActivity, this.mRequest.inTask, this.mRequest.reason, this.mRequest.allowPendingRemoteAnimationRegistryLookup, this.mRequest.originatingPendingIntent, this.mRequest.allowBackgroundActivityStart);
            return n;
        }
        finally {
            this.onExecutionComplete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int startResolvedActivity(ActivityRecord r, ActivityRecord sourceRecord, IVoiceInteractionSession voiceSession, IVoiceInteractor voiceInteractor, int startFlags, boolean doResume, ActivityOptions options, TaskRecord inTask) {
        try {
            this.mSupervisor.getActivityMetricsLogger().notifyActivityLaunching(r.intent);
            this.mLastStartReason = "startResolvedActivity";
            this.mLastStartActivityTimeMs = System.currentTimeMillis();
            this.mLastStartActivityRecord[0] = r;
            this.mLastStartActivityResult = this.startActivity(r, sourceRecord, voiceSession, voiceInteractor, startFlags, doResume, options, inTask, this.mLastStartActivityRecord, false);
            this.mSupervisor.getActivityMetricsLogger().notifyActivityLaunched(this.mLastStartActivityResult, this.mLastStartActivityRecord[0]);
            int n = this.mLastStartActivityResult;
            return n;
        }
        finally {
            this.onExecutionComplete();
        }
    }

    private int startActivity(IApplicationThread caller, Intent intent, Intent ephemeralIntent, String resolvedType, ActivityInfo aInfo, ResolveInfo rInfo, IVoiceInteractionSession voiceSession, IVoiceInteractor voiceInteractor, IBinder resultTo, String resultWho, int requestCode, int callingPid, int callingUid, String callingPackage, int realCallingPid, int realCallingUid, int startFlags, SafeActivityOptions options, boolean ignoreTargetSecurity, boolean componentSpecified, ActivityRecord[] outActivity, TaskRecord inTask, String reason, boolean allowPendingRemoteAnimationRegistryLookup, PendingIntentRecord originatingPendingIntent, boolean allowBackgroundActivityStart) {
        if (TextUtils.isEmpty(reason)) {
            throw new IllegalArgumentException("Need to specify a reason.");
        }
        this.mLastStartReason = reason;
        this.mLastStartActivityTimeMs = System.currentTimeMillis();
        this.mLastStartActivityRecord[0] = null;
        this.mLastStartActivityResult = this.startActivity(caller, intent, ephemeralIntent, resolvedType, aInfo, rInfo, voiceSession, voiceInteractor, resultTo, resultWho, requestCode, callingPid, callingUid, callingPackage, realCallingPid, realCallingUid, startFlags, options, ignoreTargetSecurity, componentSpecified, this.mLastStartActivityRecord, inTask, allowPendingRemoteAnimationRegistryLookup, originatingPendingIntent, allowBackgroundActivityStart);
        if (outActivity != null) {
            outActivity[0] = this.mLastStartActivityRecord[0];
        }
        return ActivityStarter.getExternalResult(this.mLastStartActivityResult);
    }

    static int getExternalResult(int result) {
        return result != 102 ? result : 0;
    }

    private void onExecutionComplete() {
        this.mController.onExecutionComplete(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int startActivity(IApplicationThread caller, Intent intent, Intent ephemeralIntent, String resolvedType, ActivityInfo aInfo, ResolveInfo rInfo, IVoiceInteractionSession voiceSession, IVoiceInteractor voiceInteractor, IBinder resultTo, String resultWho, int requestCode, int callingPid, int callingUid, String callingPackage, int realCallingPid, int realCallingUid, int startFlags, SafeActivityOptions options, boolean ignoreTargetSecurity, boolean componentSpecified, ActivityRecord[] outActivity, TaskRecord inTask, boolean allowPendingRemoteAnimationRegistryLookup, PendingIntentRecord originatingPendingIntent, boolean allowBackgroundActivityStart) {
        ActivityOptions checkedOptions;
        ActivityStack resultStack;
        int launchFlags;
        int userId;
        this.mSupervisor.getActivityMetricsLogger().notifyActivityLaunching(intent);
        int err = 0;
        Bundle verificationBundle = options != null ? options.popAppVerificationBundle() : null;
        WindowProcessController callerApp = null;
        if (caller != null) {
            callerApp = this.mService.getProcessController(caller);
            if (callerApp != null) {
                callingPid = callerApp.getPid();
                callingUid = callerApp.mInfo.uid;
            } else {
                Slog.w("ActivityTaskManager", "Unable to find app for caller " + caller + " (pid=" + callingPid + ") when starting: " + intent.toString());
                err = -94;
            }
        }
        int n = userId = aInfo != null && aInfo.applicationInfo != null ? UserHandle.getUserId(aInfo.applicationInfo.uid) : 0;
        if (err == 0) {
            Slog.i("ActivityTaskManager", "START u" + userId + " {" + intent.toShortString(true, true, true, false) + "} from uid " + callingUid);
        }
        ActivityRecord sourceRecord = null;
        ActivityRecord resultRecord = null;
        if (resultTo != null && (sourceRecord = this.mRootActivityContainer.isInAnyStack(resultTo)) != null && requestCode >= 0 && !sourceRecord.finishing) {
            resultRecord = sourceRecord;
        }
        if (((launchFlags = intent.getFlags()) & 0x2000000) != 0 && sourceRecord != null) {
            if (requestCode >= 0) {
                SafeActivityOptions.abort(options);
                return -93;
            }
            resultRecord = sourceRecord.resultTo;
            if (resultRecord != null && !resultRecord.isInStackLocked()) {
                resultRecord = null;
            }
            resultWho = sourceRecord.resultWho;
            requestCode = sourceRecord.requestCode;
            sourceRecord.resultTo = null;
            if (resultRecord != null) {
                resultRecord.removeResultsLocked(sourceRecord, resultWho, requestCode);
            }
            if (sourceRecord.launchedFromUid == callingUid) {
                callingPackage = sourceRecord.launchedFromPackage;
            }
        }
        if (err == 0 && intent.getComponent() == null) {
            err = -91;
        }
        if (err == 0 && aInfo == null) {
            err = -92;
        }
        if (err == 0 && sourceRecord != null && sourceRecord.getTaskRecord().voiceSession != null && (launchFlags & 0x10000000) == 0 && sourceRecord.info.applicationInfo.uid != aInfo.applicationInfo.uid) {
            try {
                intent.addCategory("android.intent.category.VOICE");
                if (!this.mService.getPackageManager().activitySupportsIntent(intent.getComponent(), intent, resolvedType)) {
                    Slog.w("ActivityTaskManager", "Activity being started in current voice task does not support voice: " + intent);
                    err = -97;
                }
            }
            catch (RemoteException e) {
                Slog.w("ActivityTaskManager", "Failure checking voice capabilities", e);
                err = -97;
            }
        }
        if (err == 0 && voiceSession != null) {
            try {
                if (!this.mService.getPackageManager().activitySupportsIntent(intent.getComponent(), intent, resolvedType)) {
                    Slog.w("ActivityTaskManager", "Activity being started in new voice task does not support: " + intent);
                    err = -97;
                }
            }
            catch (RemoteException e) {
                Slog.w("ActivityTaskManager", "Failure checking voice capabilities", e);
                err = -97;
            }
        }
        ActivityStack activityStack = resultStack = resultRecord == null ? null : (ActivityStack)resultRecord.getActivityStack();
        if (err != 0) {
            if (resultRecord != null) {
                resultStack.sendActivityResultLocked(-1, resultRecord, resultWho, requestCode, 0, null);
            }
            SafeActivityOptions.abort(options);
            return err;
        }
        boolean abort = !this.mSupervisor.checkStartAnyActivityPermission(intent, aInfo, resultWho, requestCode, callingPid, callingUid, callingPackage, ignoreTargetSecurity, inTask != null, callerApp, resultRecord, resultStack);
        abort |= !this.mService.mIntentFirewall.checkStartActivity(intent, callingUid, callingPid, resolvedType, aInfo.applicationInfo);
        boolean bl = !this.mService.getPermissionPolicyInternal().checkStartActivity(intent, callingUid, callingPackage);
        boolean restrictedBgActivity = false;
        if (!(abort |= bl)) {
            try {
                Trace.traceBegin(64L, "shouldAbortBackgroundActivityStart");
                restrictedBgActivity = this.shouldAbortBackgroundActivityStart(callingUid, callingPid, callingPackage, realCallingUid, realCallingPid, callerApp, originatingPendingIntent, allowBackgroundActivityStart, intent);
            }
            finally {
                Trace.traceEnd(64L);
            }
        }
        ActivityOptions activityOptions = checkedOptions = options != null ? options.getOptions(intent, aInfo, callerApp, this.mSupervisor) : null;
        if (allowPendingRemoteAnimationRegistryLookup) {
            checkedOptions = this.mService.getActivityStartController().getPendingRemoteAnimationRegistry().overrideOptionsIfNeeded(callingPackage, checkedOptions);
        }
        if (this.mService.mController != null) {
            try {
                Intent watchIntent = intent.cloneFilter();
                abort |= !this.mService.mController.activityStarting(watchIntent, aInfo.applicationInfo.packageName);
            }
            catch (RemoteException e) {
                this.mService.mController = null;
            }
        }
        this.mInterceptor.setStates(userId, realCallingPid, realCallingUid, startFlags, callingPackage);
        if (this.mInterceptor.intercept(intent, rInfo, aInfo, resolvedType, inTask, callingPid, callingUid, checkedOptions)) {
            intent = this.mInterceptor.mIntent;
            rInfo = this.mInterceptor.mRInfo;
            aInfo = this.mInterceptor.mAInfo;
            resolvedType = this.mInterceptor.mResolvedType;
            inTask = this.mInterceptor.mInTask;
            callingPid = this.mInterceptor.mCallingPid;
            callingUid = this.mInterceptor.mCallingUid;
            checkedOptions = this.mInterceptor.mActivityOptions;
        }
        if (abort) {
            if (resultRecord != null) {
                resultStack.sendActivityResultLocked(-1, resultRecord, resultWho, requestCode, 0, null);
            }
            ActivityOptions.abort(checkedOptions);
            return 102;
        }
        if (aInfo != null && this.mService.getPackageManagerInternalLocked().isPermissionsReviewRequired(aInfo.packageName, userId)) {
            IIntentSender target = this.mService.getIntentSenderLocked(2, callingPackage, callingUid, userId, null, null, 0, new Intent[]{intent}, new String[]{resolvedType}, 0x50000000, null);
            Intent newIntent = new Intent("android.intent.action.REVIEW_PERMISSIONS");
            int flags = intent.getFlags();
            if (((flags |= 0x800000) & 0x10080000) != 0) {
                flags |= 0x8000000;
            }
            newIntent.setFlags(flags);
            newIntent.putExtra("android.intent.extra.PACKAGE_NAME", aInfo.packageName);
            newIntent.putExtra("android.intent.extra.INTENT", new IntentSender(target));
            if (resultRecord != null) {
                newIntent.putExtra("android.intent.extra.RESULT_NEEDED", true);
            }
            intent = newIntent;
            resolvedType = null;
            callingUid = realCallingUid;
            callingPid = realCallingPid;
            rInfo = this.mSupervisor.resolveIntent(intent, resolvedType, userId, 0, ActivityStarter.computeResolveFilterUid(callingUid, realCallingUid, this.mRequest.filterCallingUid));
            aInfo = this.mSupervisor.resolveActivity(intent, rInfo, startFlags, null);
        }
        if (rInfo != null && rInfo.auxiliaryInfo != null) {
            intent = this.createLaunchIntent(rInfo.auxiliaryInfo, ephemeralIntent, callingPackage, verificationBundle, resolvedType, userId);
            resolvedType = null;
            callingUid = realCallingUid;
            callingPid = realCallingPid;
            aInfo = this.mSupervisor.resolveActivity(intent, rInfo, startFlags, null);
        }
        ActivityRecord r = new ActivityRecord(this.mService, callerApp, callingPid, callingUid, callingPackage, intent, resolvedType, aInfo, this.mService.getGlobalConfiguration(), resultRecord, resultWho, requestCode, componentSpecified, voiceSession != null, this.mSupervisor, checkedOptions, sourceRecord);
        if (outActivity != null) {
            outActivity[0] = r;
        }
        if (r.appTimeTracker == null && sourceRecord != null) {
            r.appTimeTracker = sourceRecord.appTimeTracker;
        }
        ActivityStack stack = this.mRootActivityContainer.getTopDisplayFocusedStack();
        if (!(voiceSession != null || stack.getResumedActivity() != null && stack.getResumedActivity().info.applicationInfo.uid == realCallingUid || this.mService.checkAppSwitchAllowedLocked(callingPid, callingUid, realCallingPid, realCallingUid, "Activity start"))) {
            if (!restrictedBgActivity || !this.handleBackgroundActivityAbort(r)) {
                this.mController.addPendingActivityLaunch(new ActivityStackSupervisor.PendingActivityLaunch(r, sourceRecord, startFlags, stack, callerApp));
            }
            ActivityOptions.abort(checkedOptions);
            return 100;
        }
        this.mService.onStartActivitySetDidAppSwitch();
        this.mController.doPendingActivityLaunches(false);
        int res = this.startActivity(r, sourceRecord, voiceSession, voiceInteractor, startFlags, true, checkedOptions, inTask, outActivity, restrictedBgActivity);
        this.mSupervisor.getActivityMetricsLogger().notifyActivityLaunched(res, outActivity[0]);
        return res;
    }

    boolean shouldAbortBackgroundActivityStart(int callingUid, int callingPid, String callingPackage, int realCallingUid, int realCallingPid, WindowProcessController callerApp, PendingIntentRecord originatingPendingIntent, boolean allowBackgroundActivityStart, Intent intent) {
        boolean isRealCallingUidPersistentSystemProcess;
        boolean realCallingUidHasAnyVisibleWindow;
        boolean isCallingUidPersistentSystemProcess;
        int callingAppId = UserHandle.getAppId(callingUid);
        if (callingUid == 0 || callingAppId == 1000 || callingAppId == 1027) {
            return false;
        }
        int callingUidProcState = this.mService.getUidState(callingUid);
        boolean callingUidHasAnyVisibleWindow = this.mService.mWindowManager.mRoot.isAnyNonToastWindowVisibleForUid(callingUid);
        boolean isCallingUidForeground = callingUidHasAnyVisibleWindow || callingUidProcState == 2 || callingUidProcState == 4;
        boolean bl = isCallingUidPersistentSystemProcess = callingUidProcState <= 1;
        if (callingUidHasAnyVisibleWindow || isCallingUidPersistentSystemProcess) {
            return false;
        }
        int realCallingUidProcState = callingUid == realCallingUid ? callingUidProcState : this.mService.getUidState(realCallingUid);
        boolean bl2 = realCallingUidHasAnyVisibleWindow = callingUid == realCallingUid ? callingUidHasAnyVisibleWindow : this.mService.mWindowManager.mRoot.isAnyNonToastWindowVisibleForUid(realCallingUid);
        boolean isRealCallingUidForeground = callingUid == realCallingUid ? isCallingUidForeground : realCallingUidHasAnyVisibleWindow || realCallingUidProcState == 2;
        int realCallingAppId = UserHandle.getAppId(realCallingUid);
        boolean bl3 = callingUid == realCallingUid ? isCallingUidPersistentSystemProcess : (isRealCallingUidPersistentSystemProcess = realCallingAppId == 1000 || realCallingUidProcState <= 1);
        if (realCallingUid != callingUid) {
            if (realCallingUidHasAnyVisibleWindow) {
                return false;
            }
            if (isRealCallingUidPersistentSystemProcess && allowBackgroundActivityStart) {
                return false;
            }
            if (this.mService.isAssociatedCompanionApp(UserHandle.getUserId(realCallingUid), realCallingUid)) {
                return false;
            }
        }
        if (ActivityTaskManagerService.checkPermission("android.permission.START_ACTIVITIES_FROM_BACKGROUND", callingPid, callingUid) == 0) {
            return false;
        }
        if (this.mSupervisor.mRecentTasks.isCallerRecents(callingUid)) {
            return false;
        }
        if (this.mService.isDeviceOwner(callingUid)) {
            return false;
        }
        int callingUserId = UserHandle.getUserId(callingUid);
        if (this.mService.isAssociatedCompanionApp(callingUserId, callingUid)) {
            return false;
        }
        int callerAppUid = callingUid;
        if (callerApp == null) {
            callerApp = this.mService.getProcessController(realCallingPid, realCallingUid);
            callerAppUid = realCallingUid;
        }
        if (callerApp != null) {
            if (callerApp.areBackgroundActivityStartsAllowed()) {
                return false;
            }
            ArraySet<WindowProcessController> uidProcesses = this.mService.mProcessMap.getProcesses(callerAppUid);
            if (uidProcesses != null) {
                for (int i = uidProcesses.size() - 1; i >= 0; --i) {
                    WindowProcessController proc = uidProcesses.valueAt(i);
                    if (proc == callerApp || !proc.areBackgroundActivityStartsAllowed()) continue;
                    return false;
                }
            }
        }
        if (this.mService.hasSystemAlertWindowPermission(callingUid, callingPid, callingPackage)) {
            Slog.w("ActivityTaskManager", "Background activity start for " + callingPackage + " allowed because SYSTEM_ALERT_WINDOW permission is granted.");
            return false;
        }
        Slog.w("ActivityTaskManager", "Background activity start [callingPackage: " + callingPackage + "; callingUid: " + callingUid + "; isCallingUidForeground: " + isCallingUidForeground + "; isCallingUidPersistentSystemProcess: " + isCallingUidPersistentSystemProcess + "; realCallingUid: " + realCallingUid + "; isRealCallingUidForeground: " + isRealCallingUidForeground + "; isRealCallingUidPersistentSystemProcess: " + isRealCallingUidPersistentSystemProcess + "; originatingPendingIntent: " + originatingPendingIntent + "; isBgStartWhitelisted: " + allowBackgroundActivityStart + "; intent: " + intent + "; callerApp: " + callerApp + "]");
        if (this.mService.isActivityStartsLoggingEnabled()) {
            this.mSupervisor.getActivityMetricsLogger().logAbortedBgActivityStart(intent, callerApp, callingUid, callingPackage, callingUidProcState, callingUidHasAnyVisibleWindow, realCallingUid, realCallingUidProcState, realCallingUidHasAnyVisibleWindow, originatingPendingIntent != null);
        }
        return true;
    }

    private Intent createLaunchIntent(AuxiliaryResolveInfo auxiliaryResponse, Intent originalIntent, String callingPackage, Bundle verificationBundle, String resolvedType, int userId) {
        if (auxiliaryResponse != null && auxiliaryResponse.needsPhaseTwo) {
            this.mService.getPackageManagerInternalLocked().requestInstantAppResolutionPhaseTwo(auxiliaryResponse, originalIntent, resolvedType, callingPackage, verificationBundle, userId);
        }
        return InstantAppResolver.buildEphemeralInstallerIntent(originalIntent, InstantAppResolver.sanitizeIntent(originalIntent), auxiliaryResponse == null ? null : auxiliaryResponse.failureIntent, callingPackage, verificationBundle, resolvedType, userId, auxiliaryResponse == null ? null : auxiliaryResponse.installFailureActivity, auxiliaryResponse == null ? null : auxiliaryResponse.token, auxiliaryResponse != null && auxiliaryResponse.needsPhaseTwo, auxiliaryResponse == null ? null : auxiliaryResponse.filters);
    }

    void postStartActivityProcessing(ActivityRecord r, int result, ActivityStack startedActivityStack) {
        boolean clearedTask;
        if (ActivityManager.isStartResultFatalError(result)) {
            return;
        }
        this.mSupervisor.reportWaitingActivityLaunchedIfNeeded(r, result);
        if (startedActivityStack == null) {
            return;
        }
        int clearTaskFlags = 0x10008000;
        boolean bl = clearedTask = (this.mLaunchFlags & 0x10008000) == 0x10008000 && this.mReuseTask != null;
        if (result == 2 || result == 3 || clearedTask) {
            switch (startedActivityStack.getWindowingMode()) {
                case 2: {
                    this.mService.getTaskChangeNotificationController().notifyPinnedActivityRestartAttempt(clearedTask);
                    break;
                }
                case 3: {
                    ActivityStack homeStack = startedActivityStack.getDisplay().getHomeStack();
                    if (homeStack == null || !homeStack.shouldBeVisible(null)) break;
                    this.mService.mWindowManager.showRecentApps();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private int startActivityMayWait(IApplicationThread caller, int callingUid, String callingPackage, int requestRealCallingPid, int requestRealCallingUid, Intent intent, String resolvedType, IVoiceInteractionSession voiceSession, IVoiceInteractor voiceInteractor, IBinder resultTo, String resultWho, int requestCode, int startFlags, ProfilerInfo profilerInfo, WaitResult outResult, Configuration globalConfig, SafeActivityOptions options, boolean ignoreTargetSecurity, int userId, TaskRecord inTask, String reason, boolean allowPendingRemoteAnimationRegistryLookup, PendingIntentRecord originatingPendingIntent, boolean allowBackgroundActivityStart) {
        if (intent != null && intent.hasFileDescriptors()) {
            throw new IllegalArgumentException("File descriptors passed in Intent");
        }
        this.mSupervisor.getActivityMetricsLogger().notifyActivityLaunching(intent);
        componentSpecified = intent.getComponent() != null;
        realCallingPid = requestRealCallingPid != 0 ? requestRealCallingPid : Binder.getCallingPid();
        v0 = realCallingUid = requestRealCallingUid != -1 ? requestRealCallingUid : Binder.getCallingUid();
        if (callingUid >= 0) {
            callingPid = -1;
        } else if (caller == null) {
            callingPid = realCallingPid;
            callingUid = realCallingUid;
        } else {
            callingUid = -1;
            callingPid = -1;
        }
        ephemeralIntent = new Intent(intent);
        intent = new Intent(intent);
        if (!(!componentSpecified || "android.intent.action.VIEW".equals(intent.getAction()) && intent.getData() == null || "android.intent.action.INSTALL_INSTANT_APP_PACKAGE".equals(intent.getAction()) || "android.intent.action.RESOLVE_INSTANT_APP_PACKAGE".equals(intent.getAction()) || !this.mService.getPackageManagerInternalLocked().isInstantAppInstallerComponent(intent.getComponent()))) {
            intent.setComponent(null);
            componentSpecified = false;
        }
        if ((rInfo = this.mSupervisor.resolveIntent(intent, resolvedType, userId, 0, ActivityStarter.computeResolveFilterUid(callingUid, realCallingUid, this.mRequest.filterCallingUid))) == null && (userInfo = this.mSupervisor.getUserInfo(userId)) != null && userInfo.isManagedProfile()) {
            userManager = UserManager.get(this.mService.mContext);
            profileLockedAndParentUnlockingOrUnlocked = false;
            token = Binder.clearCallingIdentity();
            try {
                parent = userManager.getProfileParent(userId);
                profileLockedAndParentUnlockingOrUnlocked = parent != null && userManager.isUserUnlockingOrUnlocked(parent.id) != false && userManager.isUserUnlockingOrUnlocked(userId) == false;
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
            if (profileLockedAndParentUnlockingOrUnlocked) {
                rInfo = this.mSupervisor.resolveIntent(intent, resolvedType, userId, 786432, ActivityStarter.computeResolveFilterUid(callingUid, realCallingUid, this.mRequest.filterCallingUid));
            }
        }
        aInfo = this.mSupervisor.resolveActivity(intent, rInfo, startFlags, profilerInfo);
        var32_32 = this.mService.mGlobalLock;
        synchronized (var32_32) {
            WindowManagerService.boostPriorityForLockedSection();
            stack = this.mRootActivityContainer.getTopDisplayFocusedStack();
            stack.mConfigWillChange = globalConfig != null && this.mService.getGlobalConfiguration().diff(globalConfig) != 0;
            origId = Binder.clearCallingIdentity();
            if (aInfo == null || (aInfo.applicationInfo.privateFlags & 2) == 0 || !this.mService.mHasHeavyWeightFeature || !aInfo.processName.equals(aInfo.applicationInfo.packageName) || (heavy = this.mService.mHeavyWeightProcess) == null || heavy.mInfo.uid == aInfo.applicationInfo.uid && heavy.mName.equals(aInfo.processName)) ** GOTO lbl83
            appCallingUid = callingUid;
            if (caller == null) ** break block33
            callerApp = this.mService.getProcessController(caller);
            if (callerApp != null) {
                appCallingUid = callerApp.mInfo.uid;
                ** break block33
            }
            Slog.w("ActivityTaskManager", "Unable to find app for caller " + caller + " (pid=" + callingPid + ") when starting: " + intent.toString());
            SafeActivityOptions.abort(options);
            v1 = -94;
        }
        WindowManagerService.resetPriorityAfterLockedSection();
        return v1;
lbl-1000:
        // 2 sources

        {
            target = this.mService.getIntentSenderLocked(2, "android", appCallingUid, userId, null, null, 0, new Intent[]{intent}, new String[]{resolvedType}, 0x50000000, null);
            newIntent = new Intent();
            if (requestCode >= 0) {
                newIntent.putExtra("has_result", true);
            }
            newIntent.putExtra("intent", new IntentSender(target));
            heavy.updateIntentForHeavyWeightActivity(newIntent);
            newIntent.putExtra("new_app", aInfo.packageName);
            newIntent.setFlags(intent.getFlags());
            newIntent.setClassName("android", HeavyWeightSwitcherActivity.class.getName());
            intent = newIntent;
            resolvedType = null;
            caller = null;
            callingUid = Binder.getCallingUid();
            callingPid = Binder.getCallingPid();
            componentSpecified = true;
            rInfo = this.mSupervisor.resolveIntent(intent, null, userId, 0, ActivityStarter.computeResolveFilterUid(callingUid, realCallingUid, this.mRequest.filterCallingUid));
            v2 = aInfo = rInfo != null ? rInfo.activityInfo : null;
            if (aInfo != null) {
                aInfo = this.mService.mAmInternal.getActivityInfoForUser(aInfo, userId);
            }
lbl83:
            // 4 sources

            outRecord = new ActivityRecord[1];
            res = this.startActivity(caller, intent, ephemeralIntent, resolvedType, aInfo, rInfo, voiceSession, voiceInteractor, resultTo, resultWho, requestCode, callingPid, callingUid, callingPackage, realCallingPid, realCallingUid, startFlags, options, ignoreTargetSecurity, componentSpecified, outRecord, inTask, reason, allowPendingRemoteAnimationRegistryLookup, originatingPendingIntent, allowBackgroundActivityStart);
            Binder.restoreCallingIdentity(origId);
            if (stack.mConfigWillChange) {
                this.mService.mAmInternal.enforceCallingPermission("android.permission.CHANGE_CONFIGURATION", "updateConfiguration()");
                stack.mConfigWillChange = false;
                this.mService.updateConfigurationLocked(globalConfig, null, false);
            }
            this.mSupervisor.getActivityMetricsLogger().notifyActivityLaunched(res, outRecord[0]);
            if (outResult != null) {
                outResult.result = res;
                r = outRecord[0];
                switch (res) {
                    case 0: {
                        this.mSupervisor.mWaitingActivityLaunched.add(outResult);
                        do {
                            try {
                                this.mService.mGlobalLock.wait();
                            }
                            catch (InterruptedException newIntent) {
                                // empty catch block
                            }
                        } while (outResult.result != 2 && !outResult.timeout && outResult.who == null);
                        if (outResult.result != 2) break;
                        res = 2;
                        break;
                    }
                    case 3: {
                        outResult.timeout = false;
                        outResult.who = r.mActivityComponent;
                        outResult.totalTime = 0L;
                        break;
                    }
                    case 2: {
                        v3 = outResult.launchState = r.attachedToProcess() != false ? 3 : 1;
                        if (r.nowVisible && r.isState(ActivityStack.ActivityState.RESUMED)) {
                            outResult.timeout = false;
                            outResult.who = r.mActivityComponent;
                            outResult.totalTime = 0L;
                            break;
                        }
                        startTimeMs = SystemClock.uptimeMillis();
                        this.mSupervisor.waitActivityVisible(r.mActivityComponent, outResult, startTimeMs);
                        do {
                            try {
                                this.mService.mGlobalLock.wait();
                            }
                            catch (InterruptedException var41_43) {
                                // empty catch block
                            }
                        } while (!outResult.timeout && outResult.who == null);
                    }
                }
            }
            v4 = res;
        }
        WindowManagerService.resetPriorityAfterLockedSection();
        return v4;
        {
            catch (Throwable var42_44) {
                // MONITOREXIT @DISABLED, blocks:[5, 14] lbl135 : MonitorExitStatement: MONITOREXIT : var32_32
                WindowManagerService.resetPriorityAfterLockedSection();
                throw var42_44;
            }
        }
    }

    static int computeResolveFilterUid(int customCallingUid, int actualCallingUid, int filterCallingUid) {
        return filterCallingUid != -10000 ? filterCallingUid : (customCallingUid >= 0 ? customCallingUid : actualCallingUid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int startActivity(ActivityRecord r, ActivityRecord sourceRecord, IVoiceInteractionSession voiceSession, IVoiceInteractor voiceInteractor, int startFlags, boolean doResume, ActivityOptions options, TaskRecord inTask, ActivityRecord[] outActivity, boolean restrictedBgActivity) {
        Object startedActivityStack;
        int result = -96;
        try {
            this.mService.mWindowManager.deferSurfaceLayout();
            result = this.startActivityUnchecked(r, sourceRecord, voiceSession, voiceInteractor, startFlags, doResume, options, inTask, outActivity, restrictedBgActivity);
            Object currentStack = r.getActivityStack();
            Object object = startedActivityStack = currentStack != null ? currentStack : this.mTargetStack;
        }
        catch (Throwable throwable) {
            Object startedActivityStack2;
            Object currentStack = r.getActivityStack();
            Object object = startedActivityStack2 = currentStack != null ? currentStack : this.mTargetStack;
            if (ActivityManager.isStartResultSuccessful(result)) {
                ActivityRecord currentTop;
                if (startedActivityStack2 != null && (currentTop = ((ActivityStack)startedActivityStack2).topRunningActivityLocked()) != null && currentTop.shouldUpdateConfigForDisplayChanged()) {
                    this.mRootActivityContainer.ensureVisibilityAndConfig(currentTop, currentTop.getDisplayId(), true, false);
                }
            } else {
                Object stack = this.mStartActivity.getActivityStack();
                if (stack != null) {
                    ((ActivityStack)stack).finishActivityLocked(this.mStartActivity, 0, null, "startActivity", true);
                }
                if (startedActivityStack2 != null && ((ActivityStack)startedActivityStack2).isAttached() && ((ActivityStack)startedActivityStack2).numActivities() == 0 && !((ConfigurationContainer)startedActivityStack2).isActivityTypeHome()) {
                    ((ActivityStack)startedActivityStack2).remove();
                }
            }
            this.mService.mWindowManager.continueSurfaceLayout();
            throw throwable;
        }
        if (ActivityManager.isStartResultSuccessful(result)) {
            ActivityRecord currentTop;
            if (startedActivityStack != null && (currentTop = ((ActivityStack)startedActivityStack).topRunningActivityLocked()) != null && currentTop.shouldUpdateConfigForDisplayChanged()) {
                this.mRootActivityContainer.ensureVisibilityAndConfig(currentTop, currentTop.getDisplayId(), true, false);
            }
        } else {
            Object stack = this.mStartActivity.getActivityStack();
            if (stack != null) {
                ((ActivityStack)stack).finishActivityLocked(this.mStartActivity, 0, null, "startActivity", true);
            }
            if (startedActivityStack != null && ((ActivityStack)startedActivityStack).isAttached() && ((ActivityStack)startedActivityStack).numActivities() == 0 && !((ConfigurationContainer)startedActivityStack).isActivityTypeHome()) {
                ((ActivityStack)startedActivityStack).remove();
            }
        }
        this.mService.mWindowManager.continueSurfaceLayout();
        this.postStartActivityProcessing(r, result, (ActivityStack)startedActivityStack);
        return result;
    }

    private boolean handleBackgroundActivityAbort(ActivityRecord r) {
        boolean abort;
        boolean bl = abort = !this.mService.isBackgroundActivityStartsEnabled();
        if (!abort) {
            return false;
        }
        ActivityRecord resultRecord = r.resultTo;
        String resultWho = r.resultWho;
        int requestCode = r.requestCode;
        if (resultRecord != null) {
            Object resultStack = resultRecord.getActivityStack();
            ((ActivityStack)resultStack).sendActivityResultLocked(-1, resultRecord, resultWho, requestCode, 0, null);
        }
        ActivityOptions.abort(r.pendingOptions);
        return true;
    }

    private int startActivityUnchecked(ActivityRecord r, ActivityRecord sourceRecord, IVoiceInteractionSession voiceSession, IVoiceInteractor voiceInteractor, int startFlags, boolean doResume, ActivityOptions options, TaskRecord inTask, ActivityRecord[] outActivity, boolean restrictedBgActivity) {
        boolean dontStart;
        ActivityRecord top;
        this.setInitialState(r, options, inTask, doResume, startFlags, sourceRecord, voiceSession, voiceInteractor, restrictedBgActivity);
        int preferredWindowingMode = this.mLaunchParams.mWindowingMode;
        this.computeLaunchingTaskFlags();
        this.computeSourceStack();
        this.mIntent.setFlags(this.mLaunchFlags);
        ActivityRecord reusedActivity = this.getReusableIntentActivity();
        this.mSupervisor.getLaunchParamsController().calculate(reusedActivity != null ? reusedActivity.getTaskRecord() : this.mInTask, r.info.windowLayout, r, sourceRecord, options, 2, this.mLaunchParams);
        int n = this.mPreferredDisplayId = this.mLaunchParams.hasPreferredDisplay() ? this.mLaunchParams.mPreferredDisplayId : 0;
        if (r.isActivityTypeHome() && !this.mRootActivityContainer.canStartHomeOnDisplay(r.info, this.mPreferredDisplayId, true)) {
            Slog.w("ActivityTaskManager", "Cannot launch home on display " + this.mPreferredDisplayId);
            return -96;
        }
        if (reusedActivity != null) {
            ActivityRecord outResult;
            boolean clearTopAndResetStandardLaunchMode;
            if (this.mService.getLockTaskController().isLockTaskModeViolation(reusedActivity.getTaskRecord(), (this.mLaunchFlags & 0x10008000) == 0x10008000)) {
                Slog.e("ActivityTaskManager", "startActivityUnchecked: Attempt to violate Lock Task Mode");
                return 101;
            }
            boolean bl = clearTopAndResetStandardLaunchMode = (this.mLaunchFlags & 0x4200000) == 0x4200000 && this.mLaunchMode == 0;
            if (this.mStartActivity.getTaskRecord() == null && !clearTopAndResetStandardLaunchMode) {
                this.mStartActivity.setTask(reusedActivity.getTaskRecord());
            }
            if (reusedActivity.getTaskRecord().intent == null) {
                reusedActivity.getTaskRecord().setIntent(this.mStartActivity);
            } else {
                boolean taskOnHome;
                boolean bl2 = taskOnHome = (this.mStartActivity.intent.getFlags() & 0x4000) != 0;
                if (taskOnHome) {
                    reusedActivity.getTaskRecord().intent.addFlags(16384);
                } else {
                    reusedActivity.getTaskRecord().intent.removeFlags(16384);
                }
            }
            if ((this.mLaunchFlags & 0x4000000) != 0 || ActivityStarter.isDocumentLaunchesIntoExisting(this.mLaunchFlags) || this.isLaunchModeOneOf(3, 2)) {
                TaskRecord task = reusedActivity.getTaskRecord();
                top = task.performClearTaskForReuseLocked(this.mStartActivity, this.mLaunchFlags);
                if (reusedActivity.getTaskRecord() == null) {
                    reusedActivity.setTask(task);
                }
                if (top != null) {
                    if (top.frontOfTask) {
                        top.getTaskRecord().setIntent(this.mStartActivity);
                    }
                    this.deliverNewIntent(top);
                }
            }
            this.mRootActivityContainer.sendPowerHintForLaunchStartIfNeeded(false, reusedActivity);
            reusedActivity = this.setTargetStackAndMoveToFrontIfNeeded(reusedActivity);
            ActivityRecord activityRecord = outResult = outActivity != null && outActivity.length > 0 ? outActivity[0] : null;
            if (outResult != null && (outResult.finishing || outResult.noDisplay)) {
                outActivity[0] = reusedActivity;
            }
            if ((this.mStartFlags & 1) != 0) {
                this.resumeTargetStackIfNeeded();
                return 1;
            }
            if (reusedActivity != null) {
                this.setTaskFromIntentActivity(reusedActivity);
                if (!this.mAddingToTask && this.mReuseTask == null) {
                    this.resumeTargetStackIfNeeded();
                    if (outActivity != null && outActivity.length > 0) {
                        outActivity[0] = reusedActivity.finishing ? reusedActivity.getTaskRecord().getTopActivity() : reusedActivity;
                    }
                    return this.mMovedToFront ? 2 : 3;
                }
            }
        }
        if (this.mStartActivity.packageName == null) {
            ActivityStack sourceStack;
            ActivityStack activityStack = sourceStack = this.mStartActivity.resultTo != null ? (ActivityStack)this.mStartActivity.resultTo.getActivityStack() : null;
            if (sourceStack != null) {
                sourceStack.sendActivityResultLocked(-1, this.mStartActivity.resultTo, this.mStartActivity.resultWho, this.mStartActivity.requestCode, 0, null);
            }
            ActivityOptions.abort(this.mOptions);
            return -92;
        }
        ActivityStack topStack = this.mRootActivityContainer.getTopDisplayFocusedStack();
        ActivityRecord topFocused = topStack.getTopActivity();
        top = topStack.topRunningNonDelayedActivityLocked(this.mNotTop);
        boolean bl = dontStart = !(top == null || this.mStartActivity.resultTo != null || !top.mActivityComponent.equals(this.mStartActivity.mActivityComponent) || top.mUserId != this.mStartActivity.mUserId || !top.attachedToProcess() || (this.mLaunchFlags & 0x20000000) == 0 && !this.isLaunchModeOneOf(1, 2) || top.isActivityTypeHome() && top.getDisplayId() != this.mPreferredDisplayId);
        if (dontStart) {
            topStack.mLastPausedActivity = null;
            if (this.mDoResume) {
                this.mRootActivityContainer.resumeFocusedStacksTopActivities();
            }
            ActivityOptions.abort(this.mOptions);
            if ((this.mStartFlags & 1) != 0) {
                return 1;
            }
            this.deliverNewIntent(top);
            this.mSupervisor.handleNonResizableTaskIfNeeded(top.getTaskRecord(), preferredWindowingMode, this.mPreferredDisplayId, topStack);
            return 3;
        }
        boolean newTask = false;
        TaskRecord taskToAffiliate = this.mLaunchTaskBehind && this.mSourceRecord != null ? this.mSourceRecord.getTaskRecord() : null;
        int result = 0;
        if (this.mStartActivity.resultTo == null && this.mInTask == null && !this.mAddingToTask && (this.mLaunchFlags & 0x10000000) != 0) {
            newTask = true;
            result = this.setTaskFromReuseOrCreateNewTask(taskToAffiliate);
        } else {
            result = this.mSourceRecord != null ? this.setTaskFromSourceRecord() : (this.mInTask != null ? this.setTaskFromInTask() : this.setTaskToCurrentTopOrCreateNewTask());
        }
        if (result != 0) {
            return result;
        }
        this.mService.mUgmInternal.grantUriPermissionFromIntent(this.mCallingUid, this.mStartActivity.packageName, this.mIntent, this.mStartActivity.getUriPermissionsLocked(), this.mStartActivity.mUserId);
        this.mService.getPackageManagerInternalLocked().grantEphemeralAccess(this.mStartActivity.mUserId, this.mIntent, UserHandle.getAppId(this.mStartActivity.appInfo.uid), UserHandle.getAppId(this.mCallingUid));
        if (newTask) {
            EventLog.writeEvent(30004, this.mStartActivity.mUserId, this.mStartActivity.getTaskRecord().taskId);
        }
        ActivityStack.logStartActivity(30005, this.mStartActivity, this.mStartActivity.getTaskRecord());
        this.mTargetStack.mLastPausedActivity = null;
        this.mRootActivityContainer.sendPowerHintForLaunchStartIfNeeded(false, this.mStartActivity);
        this.mTargetStack.startActivityLocked(this.mStartActivity, topFocused, newTask, this.mKeepCurTransition, this.mOptions);
        if (this.mDoResume) {
            ActivityRecord topTaskActivity = this.mStartActivity.getTaskRecord().topRunningActivityLocked();
            if (!this.mTargetStack.isFocusable() || topTaskActivity != null && topTaskActivity.mTaskOverlay && this.mStartActivity != topTaskActivity) {
                this.mTargetStack.ensureActivitiesVisibleLocked(this.mStartActivity, 0, false);
                this.mTargetStack.getDisplay().mDisplayContent.executeAppTransition();
            } else {
                if (this.mTargetStack.isFocusable() && !this.mRootActivityContainer.isTopDisplayFocusedStack(this.mTargetStack)) {
                    this.mTargetStack.moveToFront("startActivityUnchecked");
                }
                this.mRootActivityContainer.resumeFocusedStacksTopActivities(this.mTargetStack, this.mStartActivity, this.mOptions);
            }
        } else if (this.mStartActivity != null) {
            this.mSupervisor.mRecentTasks.add(this.mStartActivity.getTaskRecord());
        }
        this.mRootActivityContainer.updateUserStack(this.mStartActivity.mUserId, this.mTargetStack);
        this.mSupervisor.handleNonResizableTaskIfNeeded(this.mStartActivity.getTaskRecord(), preferredWindowingMode, this.mPreferredDisplayId, this.mTargetStack);
        return 0;
    }

    void reset(boolean clearRequest) {
        this.mStartActivity = null;
        this.mIntent = null;
        this.mCallingUid = -1;
        this.mOptions = null;
        this.mRestrictedBgActivity = false;
        this.mLaunchTaskBehind = false;
        this.mLaunchFlags = 0;
        this.mLaunchMode = -1;
        this.mLaunchParams.reset();
        this.mNotTop = null;
        this.mDoResume = false;
        this.mStartFlags = 0;
        this.mSourceRecord = null;
        this.mPreferredDisplayId = -1;
        this.mInTask = null;
        this.mAddingToTask = false;
        this.mReuseTask = null;
        this.mNewTaskInfo = null;
        this.mNewTaskIntent = null;
        this.mSourceStack = null;
        this.mTargetStack = null;
        this.mMovedToFront = false;
        this.mNoAnimation = false;
        this.mKeepCurTransition = false;
        this.mAvoidMoveToFront = false;
        this.mVoiceSession = null;
        this.mVoiceInteractor = null;
        this.mIntentDelivered = false;
        if (clearRequest) {
            this.mRequest.reset();
        }
    }

    private void setInitialState(ActivityRecord r, ActivityOptions options, TaskRecord inTask, boolean doResume, int startFlags, ActivityRecord sourceRecord, IVoiceInteractionSession voiceSession, IVoiceInteractor voiceInteractor, boolean restrictedBgActivity) {
        this.reset(false);
        this.mStartActivity = r;
        this.mIntent = r.intent;
        this.mOptions = options;
        this.mCallingUid = r.launchedFromUid;
        this.mSourceRecord = sourceRecord;
        this.mVoiceSession = voiceSession;
        this.mVoiceInteractor = voiceInteractor;
        this.mRestrictedBgActivity = restrictedBgActivity;
        this.mLaunchParams.reset();
        this.mSupervisor.getLaunchParamsController().calculate(inTask, r.info.windowLayout, r, sourceRecord, options, 0, this.mLaunchParams);
        this.mPreferredDisplayId = this.mLaunchParams.hasPreferredDisplay() ? this.mLaunchParams.mPreferredDisplayId : 0;
        this.mLaunchMode = r.launchMode;
        this.mLaunchFlags = this.adjustLaunchFlagsToDocumentMode(r, 3 == this.mLaunchMode, 2 == this.mLaunchMode, this.mIntent.getFlags());
        this.mLaunchTaskBehind = r.mLaunchTaskBehind && !this.isLaunchModeOneOf(2, 3) && (this.mLaunchFlags & 0x80000) != 0;
        this.sendNewTaskResultRequestIfNeeded();
        if ((this.mLaunchFlags & 0x80000) != 0 && r.resultTo == null) {
            this.mLaunchFlags |= 0x10000000;
        }
        if ((this.mLaunchFlags & 0x10000000) != 0 && (this.mLaunchTaskBehind || r.info.documentLaunchMode == 2)) {
            this.mLaunchFlags |= 0x8000000;
        }
        this.mSupervisor.mUserLeaving = (this.mLaunchFlags & 0x40000) == 0;
        this.mDoResume = doResume;
        if (!doResume || !r.okToShowLocked()) {
            r.delayedResume = true;
            this.mDoResume = false;
        }
        if (this.mOptions != null) {
            if (this.mOptions.getLaunchTaskId() != -1 && this.mOptions.getTaskOverlay()) {
                r.mTaskOverlay = true;
                if (!this.mOptions.canTaskOverlayResume()) {
                    ActivityRecord top;
                    TaskRecord task = this.mRootActivityContainer.anyTaskForId(this.mOptions.getLaunchTaskId());
                    ActivityRecord activityRecord = top = task != null ? task.getTopActivity() : null;
                    if (top != null && !top.isState(ActivityStack.ActivityState.RESUMED)) {
                        this.mDoResume = false;
                        this.mAvoidMoveToFront = true;
                    }
                }
            } else if (this.mOptions.getAvoidMoveToFront()) {
                this.mDoResume = false;
                this.mAvoidMoveToFront = true;
            }
        }
        this.mNotTop = (this.mLaunchFlags & 0x1000000) != 0 ? sourceRecord : null;
        this.mInTask = inTask;
        if (inTask != null && !inTask.inRecents) {
            Slog.w("ActivityTaskManager", "Starting activity in task not in recents: " + inTask);
            this.mInTask = null;
        }
        this.mStartFlags = startFlags;
        if ((startFlags & 1) != 0) {
            ActivityRecord checkedCaller = sourceRecord;
            if (checkedCaller == null) {
                checkedCaller = this.mRootActivityContainer.getTopDisplayFocusedStack().topRunningNonDelayedActivityLocked(this.mNotTop);
            }
            if (!checkedCaller.mActivityComponent.equals(r.mActivityComponent)) {
                this.mStartFlags &= 0xFFFFFFFE;
            }
        }
        boolean bl = this.mNoAnimation = (this.mLaunchFlags & 0x10000) != 0;
        if (this.mRestrictedBgActivity && !this.mService.isBackgroundActivityStartsEnabled()) {
            this.mAvoidMoveToFront = true;
            this.mDoResume = false;
        }
    }

    private void sendNewTaskResultRequestIfNeeded() {
        ActivityStack sourceStack;
        ActivityStack activityStack = sourceStack = this.mStartActivity.resultTo != null ? (ActivityStack)this.mStartActivity.resultTo.getActivityStack() : null;
        if (sourceStack != null && (this.mLaunchFlags & 0x10000000) != 0) {
            Slog.w("ActivityTaskManager", "Activity is launching as a new task, so cancelling activity result.");
            sourceStack.sendActivityResultLocked(-1, this.mStartActivity.resultTo, this.mStartActivity.resultWho, this.mStartActivity.requestCode, 0, null);
            this.mStartActivity.resultTo = null;
        }
    }

    private void computeLaunchingTaskFlags() {
        if (this.mSourceRecord == null && this.mInTask != null && this.mInTask.getStack() != null) {
            Intent baseIntent = this.mInTask.getBaseIntent();
            ActivityRecord root = this.mInTask.getRootActivity();
            if (baseIntent == null) {
                ActivityOptions.abort(this.mOptions);
                throw new IllegalArgumentException("Launching into task without base intent: " + this.mInTask);
            }
            if (this.isLaunchModeOneOf(3, 2)) {
                if (!baseIntent.getComponent().equals(this.mStartActivity.intent.getComponent())) {
                    ActivityOptions.abort(this.mOptions);
                    throw new IllegalArgumentException("Trying to launch singleInstance/Task " + this.mStartActivity + " into different task " + this.mInTask);
                }
                if (root != null) {
                    ActivityOptions.abort(this.mOptions);
                    throw new IllegalArgumentException("Caller with mInTask " + this.mInTask + " has root " + root + " but target is singleInstance/Task");
                }
            }
            if (root == null) {
                int flagsOfInterest = 403185664;
                this.mLaunchFlags = this.mLaunchFlags & 0xE7F7DFFF | baseIntent.getFlags() & 0x18082000;
                this.mIntent.setFlags(this.mLaunchFlags);
                this.mInTask.setIntent(this.mStartActivity);
                this.mAddingToTask = true;
            } else {
                this.mAddingToTask = (this.mLaunchFlags & 0x10000000) == 0;
            }
            this.mReuseTask = this.mInTask;
        } else {
            this.mInTask = null;
            if ((this.mStartActivity.isResolverActivity() || this.mStartActivity.noDisplay) && this.mSourceRecord != null && this.mSourceRecord.inFreeformWindowingMode()) {
                this.mAddingToTask = true;
            }
        }
        if (this.mInTask == null) {
            if (this.mSourceRecord == null) {
                if ((this.mLaunchFlags & 0x10000000) == 0 && this.mInTask == null) {
                    Slog.w("ActivityTaskManager", "startActivity called from non-Activity context; forcing Intent.FLAG_ACTIVITY_NEW_TASK for: " + this.mIntent);
                    this.mLaunchFlags |= 0x10000000;
                }
            } else if (this.mSourceRecord.launchMode == 3) {
                this.mLaunchFlags |= 0x10000000;
            } else if (this.isLaunchModeOneOf(3, 2)) {
                this.mLaunchFlags |= 0x10000000;
            }
        }
    }

    private void computeSourceStack() {
        if (this.mSourceRecord == null) {
            this.mSourceStack = null;
            return;
        }
        if (!this.mSourceRecord.finishing) {
            this.mSourceStack = this.mSourceRecord.getActivityStack();
            return;
        }
        if ((this.mLaunchFlags & 0x10000000) == 0) {
            Slog.w("ActivityTaskManager", "startActivity called from finishing " + this.mSourceRecord + "; forcing Intent.FLAG_ACTIVITY_NEW_TASK for: " + this.mIntent);
            this.mLaunchFlags |= 0x10000000;
            this.mNewTaskInfo = this.mSourceRecord.info;
            TaskRecord sourceTask = this.mSourceRecord.getTaskRecord();
            this.mNewTaskIntent = sourceTask != null ? sourceTask.intent : null;
        }
        this.mSourceRecord = null;
        this.mSourceStack = null;
    }

    private ActivityRecord getReusableIntentActivity() {
        boolean putIntoExistingTask = (this.mLaunchFlags & 0x10000000) != 0 && (this.mLaunchFlags & 0x8000000) == 0 || this.isLaunchModeOneOf(3, 2);
        putIntoExistingTask &= this.mInTask == null && this.mStartActivity.resultTo == null;
        ConfigurationContainer intentActivity = null;
        if (this.mOptions != null && this.mOptions.getLaunchTaskId() != -1) {
            TaskRecord task = this.mRootActivityContainer.anyTaskForId(this.mOptions.getLaunchTaskId());
            intentActivity = task != null ? task.getTopActivity() : null;
        } else if (putIntoExistingTask) {
            intentActivity = 3 == this.mLaunchMode ? this.mRootActivityContainer.findActivity(this.mIntent, this.mStartActivity.info, this.mStartActivity.isActivityTypeHome()) : ((this.mLaunchFlags & 0x1000) != 0 ? this.mRootActivityContainer.findActivity(this.mIntent, this.mStartActivity.info, 2 != this.mLaunchMode) : this.mRootActivityContainer.findTask(this.mStartActivity, this.mPreferredDisplayId));
        }
        if (intentActivity != null && (this.mStartActivity.isActivityTypeHome() || intentActivity.isActivityTypeHome()) && ((ActivityRecord)intentActivity).getDisplayId() != this.mPreferredDisplayId) {
            intentActivity = null;
        }
        return intentActivity;
    }

    private ActivityRecord setTargetStackAndMoveToFrontIfNeeded(ActivityRecord intentActivity) {
        boolean differentTopTask;
        this.mTargetStack = intentActivity.getActivityStack();
        this.mTargetStack.mLastPausedActivity = null;
        if (this.mPreferredDisplayId == this.mTargetStack.mDisplayId) {
            ActivityStack focusStack = this.mTargetStack.getDisplay().getFocusedStack();
            ActivityRecord curTop = focusStack == null ? null : focusStack.topRunningNonDelayedActivityLocked(this.mNotTop);
            TaskRecord topTask = curTop != null ? curTop.getTaskRecord() : null;
            differentTopTask = topTask != intentActivity.getTaskRecord() || focusStack != null && topTask != focusStack.topTask();
        } else {
            differentTopTask = true;
        }
        if (differentTopTask && !this.mAvoidMoveToFront) {
            this.mStartActivity.intent.addFlags(0x400000);
            if (this.mSourceRecord == null || this.mSourceStack.getTopActivity() != null && this.mSourceStack.getTopActivity().getTaskRecord() == this.mSourceRecord.getTaskRecord()) {
                boolean willClearTask;
                if (this.mLaunchTaskBehind && this.mSourceRecord != null) {
                    intentActivity.setTaskToAffiliateWith(this.mSourceRecord.getTaskRecord());
                }
                boolean bl = willClearTask = (this.mLaunchFlags & 0x10008000) == 0x10008000;
                if (!willClearTask) {
                    ActivityStack launchStack = this.getLaunchStack(this.mStartActivity, this.mLaunchFlags, this.mStartActivity.getTaskRecord(), this.mOptions);
                    TaskRecord intentTask = intentActivity.getTaskRecord();
                    if (launchStack == null || launchStack == this.mTargetStack) {
                        this.mTargetStack.moveTaskToFrontLocked(intentTask, this.mNoAnimation, this.mOptions, this.mStartActivity.appTimeTracker, "bringingFoundTaskToFront");
                        this.mMovedToFront = true;
                    } else if (launchStack.inSplitScreenWindowingMode()) {
                        if ((this.mLaunchFlags & 0x1000) != 0) {
                            intentTask.reparent(launchStack, true, 0, true, true, "launchToSide");
                        } else {
                            this.mTargetStack.moveTaskToFrontLocked(intentTask, this.mNoAnimation, this.mOptions, this.mStartActivity.appTimeTracker, "bringToFrontInsteadOfAdjacentLaunch");
                        }
                        this.mMovedToFront = launchStack != launchStack.getDisplay().getTopStackInWindowingMode(launchStack.getWindowingMode());
                    } else if (launchStack.mDisplayId != this.mTargetStack.mDisplayId) {
                        intentActivity.getTaskRecord().reparent(launchStack, true, 0, true, true, "reparentToDisplay");
                        this.mMovedToFront = true;
                    } else if (launchStack.isActivityTypeHome() && !this.mTargetStack.isActivityTypeHome()) {
                        intentActivity.getTaskRecord().reparent(launchStack, true, 0, true, true, "reparentingHome");
                        this.mMovedToFront = true;
                    }
                    this.mOptions = null;
                    intentActivity.showStartingWindow(null, false, true);
                }
            }
        }
        this.mTargetStack = intentActivity.getActivityStack();
        if (!this.mMovedToFront && this.mDoResume) {
            this.mTargetStack.moveToFront("intentActivityFound");
        }
        this.mSupervisor.handleNonResizableTaskIfNeeded(intentActivity.getTaskRecord(), 0, 0, this.mTargetStack);
        if ((this.mLaunchFlags & 0x200000) != 0) {
            return this.mTargetStack.resetTaskIfNeededLocked(intentActivity, this.mStartActivity);
        }
        return intentActivity;
    }

    private void setTaskFromIntentActivity(ActivityRecord intentActivity) {
        if ((this.mLaunchFlags & 0x10008000) == 0x10008000) {
            TaskRecord task = intentActivity.getTaskRecord();
            task.performClearTaskLocked();
            this.mReuseTask = task;
            this.mReuseTask.setIntent(this.mStartActivity);
        } else if ((this.mLaunchFlags & 0x4000000) != 0 || this.isLaunchModeOneOf(3, 2)) {
            ActivityRecord top = intentActivity.getTaskRecord().performClearTaskLocked(this.mStartActivity, this.mLaunchFlags);
            if (top == null) {
                this.mAddingToTask = true;
                this.mStartActivity.setTask(null);
                this.mSourceRecord = intentActivity;
                TaskRecord task = this.mSourceRecord.getTaskRecord();
                if (task != null && task.getStack() == null) {
                    this.mTargetStack = this.computeStackFocus(this.mSourceRecord, false, this.mLaunchFlags, this.mOptions);
                    this.mTargetStack.addTask(task, !this.mLaunchTaskBehind, "startActivityUnchecked");
                }
            }
        } else if (this.mStartActivity.mActivityComponent.equals(intentActivity.getTaskRecord().realActivity)) {
            if (((this.mLaunchFlags & 0x20000000) != 0 || 1 == this.mLaunchMode) && intentActivity.mActivityComponent.equals(this.mStartActivity.mActivityComponent)) {
                if (intentActivity.frontOfTask) {
                    intentActivity.getTaskRecord().setIntent(this.mStartActivity);
                }
                this.deliverNewIntent(intentActivity);
            } else if (!intentActivity.getTaskRecord().isSameIntentFilter(this.mStartActivity)) {
                this.mAddingToTask = true;
                this.mSourceRecord = intentActivity;
            }
        } else if ((this.mLaunchFlags & 0x200000) == 0) {
            this.mAddingToTask = true;
            this.mSourceRecord = intentActivity;
        } else if (!intentActivity.getTaskRecord().rootWasReset) {
            intentActivity.getTaskRecord().setIntent(this.mStartActivity);
        }
    }

    private void resumeTargetStackIfNeeded() {
        if (this.mDoResume) {
            this.mRootActivityContainer.resumeFocusedStacksTopActivities(this.mTargetStack, null, this.mOptions);
        } else {
            ActivityOptions.abort(this.mOptions);
        }
        this.mRootActivityContainer.updateUserStack(this.mStartActivity.mUserId, this.mTargetStack);
    }

    private int setTaskFromReuseOrCreateNewTask(TaskRecord taskToAffiliate) {
        if (this.mRestrictedBgActivity && (this.mReuseTask == null || !this.mReuseTask.containsAppUid(this.mCallingUid)) && this.handleBackgroundActivityAbort(this.mStartActivity)) {
            return 102;
        }
        this.mTargetStack = this.computeStackFocus(this.mStartActivity, true, this.mLaunchFlags, this.mOptions);
        if (this.mReuseTask == null) {
            TaskRecord task = this.mTargetStack.createTaskRecord(this.mSupervisor.getNextTaskIdForUserLocked(this.mStartActivity.mUserId), this.mNewTaskInfo != null ? this.mNewTaskInfo : this.mStartActivity.info, this.mNewTaskIntent != null ? this.mNewTaskIntent : this.mIntent, this.mVoiceSession, this.mVoiceInteractor, !this.mLaunchTaskBehind, this.mStartActivity, this.mSourceRecord, this.mOptions);
            this.addOrReparentStartingActivity(task, "setTaskFromReuseOrCreateNewTask - mReuseTask");
            this.updateBounds(this.mStartActivity.getTaskRecord(), this.mLaunchParams.mBounds);
        } else {
            this.addOrReparentStartingActivity(this.mReuseTask, "setTaskFromReuseOrCreateNewTask");
        }
        if (taskToAffiliate != null) {
            this.mStartActivity.setTaskToAffiliateWith(taskToAffiliate);
        }
        if (this.mService.getLockTaskController().isLockTaskModeViolation(this.mStartActivity.getTaskRecord())) {
            Slog.e("ActivityTaskManager", "Attempted Lock Task Mode violation mStartActivity=" + this.mStartActivity);
            return 101;
        }
        if (this.mDoResume) {
            this.mTargetStack.moveToFront("reuseOrNewTask");
        }
        return 0;
    }

    private void deliverNewIntent(ActivityRecord activity) {
        if (this.mIntentDelivered) {
            return;
        }
        ActivityStack.logStartActivity(30003, activity, activity.getTaskRecord());
        activity.deliverNewIntentLocked(this.mCallingUid, this.mStartActivity.intent, this.mStartActivity.launchedFromPackage);
        this.mIntentDelivered = true;
    }

    private int setTaskFromSourceRecord() {
        ActivityRecord top;
        boolean moveStackAllowed;
        if (this.mService.getLockTaskController().isLockTaskModeViolation(this.mSourceRecord.getTaskRecord())) {
            Slog.e("ActivityTaskManager", "Attempted Lock Task Mode violation mStartActivity=" + this.mStartActivity);
            return 101;
        }
        TaskRecord sourceTask = this.mSourceRecord.getTaskRecord();
        Object sourceStack = this.mSourceRecord.getActivityStack();
        if (this.mRestrictedBgActivity && !sourceTask.containsAppUid(this.mCallingUid) && this.handleBackgroundActivityAbort(this.mStartActivity)) {
            return 102;
        }
        int targetDisplayId = this.mTargetStack != null ? this.mTargetStack.mDisplayId : ((ActivityStack)sourceStack).mDisplayId;
        boolean bl = moveStackAllowed = ((ActivityStack)sourceStack).topTask() != sourceTask || !this.mStartActivity.canBeLaunchedOnDisplay(targetDisplayId);
        if (moveStackAllowed) {
            this.mTargetStack = this.getLaunchStack(this.mStartActivity, this.mLaunchFlags, this.mStartActivity.getTaskRecord(), this.mOptions);
            if (this.mTargetStack == null && targetDisplayId != ((ActivityStack)sourceStack).mDisplayId) {
                this.mTargetStack = this.mRootActivityContainer.getValidLaunchStackOnDisplay(((ActivityStack)sourceStack).mDisplayId, this.mStartActivity, this.mOptions, this.mLaunchParams);
            }
            if (this.mTargetStack == null) {
                this.mTargetStack = this.mRootActivityContainer.getNextValidLaunchStack(this.mStartActivity, -1);
            }
        }
        if (this.mTargetStack == null) {
            this.mTargetStack = sourceStack;
        } else if (this.mTargetStack != sourceStack) {
            sourceTask.reparent(this.mTargetStack, true, 0, false, true, "launchToSide");
        }
        TaskRecord topTask = this.mTargetStack.topTask();
        if (topTask != sourceTask && !this.mAvoidMoveToFront) {
            this.mTargetStack.moveTaskToFrontLocked(sourceTask, this.mNoAnimation, this.mOptions, this.mStartActivity.appTimeTracker, "sourceTaskToFront");
        } else if (this.mDoResume) {
            this.mTargetStack.moveToFront("sourceStackToFront");
        }
        if (!this.mAddingToTask && (this.mLaunchFlags & 0x4000000) != 0) {
            ActivityRecord top2 = sourceTask.performClearTaskLocked(this.mStartActivity, this.mLaunchFlags);
            this.mKeepCurTransition = true;
            if (top2 != null) {
                ActivityStack.logStartActivity(30003, this.mStartActivity, top2.getTaskRecord());
                this.deliverNewIntent(top2);
                this.mTargetStack.mLastPausedActivity = null;
                if (this.mDoResume) {
                    this.mRootActivityContainer.resumeFocusedStacksTopActivities();
                }
                ActivityOptions.abort(this.mOptions);
                return 3;
            }
        } else if (!this.mAddingToTask && (this.mLaunchFlags & 0x20000) != 0 && (top = sourceTask.findActivityInHistoryLocked(this.mStartActivity)) != null) {
            TaskRecord task = top.getTaskRecord();
            task.moveActivityToFrontLocked(top);
            top.updateOptionsLocked(this.mOptions);
            ActivityStack.logStartActivity(30003, this.mStartActivity, task);
            this.deliverNewIntent(top);
            this.mTargetStack.mLastPausedActivity = null;
            if (this.mDoResume) {
                this.mRootActivityContainer.resumeFocusedStacksTopActivities();
            }
            return 3;
        }
        this.addOrReparentStartingActivity(sourceTask, "setTaskFromSourceRecord");
        return 0;
    }

    private int setTaskFromInTask() {
        if (this.mService.getLockTaskController().isLockTaskModeViolation(this.mInTask)) {
            Slog.e("ActivityTaskManager", "Attempted Lock Task Mode violation mStartActivity=" + this.mStartActivity);
            return 101;
        }
        this.mTargetStack = this.mInTask.getStack();
        ActivityRecord top = this.mInTask.getTopActivity();
        if (top != null && top.mActivityComponent.equals(this.mStartActivity.mActivityComponent) && top.mUserId == this.mStartActivity.mUserId && ((this.mLaunchFlags & 0x20000000) != 0 || this.isLaunchModeOneOf(1, 2))) {
            this.mTargetStack.moveTaskToFrontLocked(this.mInTask, this.mNoAnimation, this.mOptions, this.mStartActivity.appTimeTracker, "inTaskToFront");
            if ((this.mStartFlags & 1) != 0) {
                return 1;
            }
            this.deliverNewIntent(top);
            return 3;
        }
        if (!this.mAddingToTask) {
            this.mTargetStack.moveTaskToFrontLocked(this.mInTask, this.mNoAnimation, this.mOptions, this.mStartActivity.appTimeTracker, "inTaskToFront");
            ActivityOptions.abort(this.mOptions);
            return 2;
        }
        if (!this.mLaunchParams.mBounds.isEmpty()) {
            Object stack = this.mRootActivityContainer.getLaunchStack(null, null, this.mInTask, true);
            if (stack != this.mInTask.getStack()) {
                this.mInTask.reparent((ActivityStack)stack, true, 1, false, true, "inTaskToFront");
                this.mTargetStack = this.mInTask.getStack();
            }
            this.updateBounds(this.mInTask, this.mLaunchParams.mBounds);
        }
        this.mTargetStack.moveTaskToFrontLocked(this.mInTask, this.mNoAnimation, this.mOptions, this.mStartActivity.appTimeTracker, "inTaskToFront");
        this.addOrReparentStartingActivity(this.mInTask, "setTaskFromInTask");
        return 0;
    }

    @VisibleForTesting
    void updateBounds(TaskRecord task, Rect bounds) {
        if (bounds.isEmpty()) {
            return;
        }
        Object stack = task.getStack();
        if (stack != null && ((ActivityStack)stack).resizeStackWithLaunchBounds()) {
            this.mService.resizeStack(((ActivityStack)stack).mStackId, bounds, true, false, true, -1);
        } else {
            task.updateOverrideConfiguration(bounds);
        }
    }

    private int setTaskToCurrentTopOrCreateNewTask() {
        TaskRecord task;
        this.mTargetStack = this.computeStackFocus(this.mStartActivity, false, this.mLaunchFlags, this.mOptions);
        if (this.mDoResume) {
            this.mTargetStack.moveToFront("addingToTopTask");
        }
        ActivityRecord prev = this.mTargetStack.getTopActivity();
        if (this.mRestrictedBgActivity && prev == null && this.handleBackgroundActivityAbort(this.mStartActivity)) {
            return 102;
        }
        TaskRecord taskRecord = task = prev != null ? prev.getTaskRecord() : this.mTargetStack.createTaskRecord(this.mSupervisor.getNextTaskIdForUserLocked(this.mStartActivity.mUserId), this.mStartActivity.info, this.mIntent, null, null, true, this.mStartActivity, this.mSourceRecord, this.mOptions);
        if (this.mRestrictedBgActivity && prev != null && !task.containsAppUid(this.mCallingUid) && this.handleBackgroundActivityAbort(this.mStartActivity)) {
            return 102;
        }
        this.addOrReparentStartingActivity(task, "setTaskToCurrentTopOrCreateNewTask");
        this.mTargetStack.positionChildWindowContainerAtTop(task);
        return 0;
    }

    private void addOrReparentStartingActivity(TaskRecord parent, String reason) {
        if (this.mStartActivity.getTaskRecord() == null || this.mStartActivity.getTaskRecord() == parent) {
            parent.addActivityToTop(this.mStartActivity);
        } else {
            this.mStartActivity.reparent(parent, parent.mActivities.size(), reason);
        }
    }

    private int adjustLaunchFlagsToDocumentMode(ActivityRecord r, boolean launchSingleInstance, boolean launchSingleTask, int launchFlags) {
        if ((launchFlags & 0x80000) != 0 && (launchSingleInstance || launchSingleTask)) {
            Slog.i("ActivityTaskManager", "Ignoring FLAG_ACTIVITY_NEW_DOCUMENT, launchMode is \"singleInstance\" or \"singleTask\"");
            launchFlags &= 0xF7F7FFFF;
        } else {
            switch (r.info.documentLaunchMode) {
                case 0: {
                    break;
                }
                case 1: {
                    launchFlags |= 0x80000;
                    break;
                }
                case 2: {
                    launchFlags |= 0x80000;
                    break;
                }
                case 3: {
                    launchFlags &= 0xF7FFFFFF;
                }
            }
        }
        return launchFlags;
    }

    private ActivityStack computeStackFocus(ActivityRecord r, boolean newTask, int launchFlags, ActivityOptions aOptions) {
        TaskRecord task = r.getTaskRecord();
        ActivityStack stack = this.getLaunchStack(r, launchFlags, task, aOptions);
        if (stack != null) {
            return stack;
        }
        ActivityStack currentStack = task != null ? (ActivityStack)task.getStack() : null;
        ActivityStack focusedStack = this.mRootActivityContainer.getTopDisplayFocusedStack();
        if (currentStack != null) {
            if (focusedStack != currentStack) {
                // empty if block
            }
            return currentStack;
        }
        if (this.canLaunchIntoFocusedStack(r, newTask)) {
            return focusedStack;
        }
        if (this.mPreferredDisplayId != 0 && (stack = this.mRootActivityContainer.getValidLaunchStackOnDisplay(this.mPreferredDisplayId, r, aOptions, this.mLaunchParams)) == null) {
            stack = this.mRootActivityContainer.getNextValidLaunchStack(r, this.mPreferredDisplayId);
        }
        if (stack == null) {
            stack = this.mRootActivityContainer.getLaunchStack(r, aOptions, task, true);
        }
        return stack;
    }

    private boolean canLaunchIntoFocusedStack(ActivityRecord r, boolean newTask) {
        boolean canUseFocusedStack;
        ActivityStack focusedStack = this.mRootActivityContainer.getTopDisplayFocusedStack();
        if (focusedStack.isActivityTypeAssistant()) {
            canUseFocusedStack = r.isActivityTypeAssistant();
        } else {
            switch (focusedStack.getWindowingMode()) {
                case 1: {
                    canUseFocusedStack = true;
                    break;
                }
                case 3: 
                case 4: {
                    canUseFocusedStack = r.supportsSplitScreenWindowingMode();
                    break;
                }
                case 5: {
                    canUseFocusedStack = r.supportsFreeform();
                    break;
                }
                default: {
                    canUseFocusedStack = !focusedStack.isOnHomeDisplay() && r.canBeLaunchedOnDisplay(focusedStack.mDisplayId);
                }
            }
        }
        return canUseFocusedStack && !newTask && this.mPreferredDisplayId == focusedStack.mDisplayId;
    }

    private ActivityStack getLaunchStack(ActivityRecord r, int launchFlags, TaskRecord task, ActivityOptions aOptions) {
        ActivityStack parentStack;
        if (this.mReuseTask != null) {
            return this.mReuseTask.getStack();
        }
        if ((launchFlags & 0x1000) == 0 || this.mPreferredDisplayId != 0) {
            boolean onTop = aOptions == null || !aOptions.getAvoidMoveToFront();
            Object stack = this.mRootActivityContainer.getLaunchStack(r, aOptions, task, onTop, this.mLaunchParams);
            return stack;
        }
        ActivityStack focusedStack = this.mRootActivityContainer.getTopDisplayFocusedStack();
        ActivityStack activityStack = parentStack = task != null ? task.getStack() : focusedStack;
        if (parentStack != focusedStack) {
            return parentStack;
        }
        if (focusedStack != null && task == focusedStack.topTask()) {
            return focusedStack;
        }
        if (parentStack != null && parentStack.inSplitScreenPrimaryWindowingMode()) {
            int activityType = this.mRootActivityContainer.resolveActivityType(r, this.mOptions, task);
            return parentStack.getDisplay().getOrCreateStack(4, activityType, true);
        }
        ActivityStack dockedStack = this.mRootActivityContainer.getDefaultDisplay().getSplitScreenPrimaryStack();
        if (dockedStack != null && !dockedStack.shouldBeVisible(r)) {
            return this.mRootActivityContainer.getLaunchStack(r, aOptions, task, true);
        }
        return dockedStack;
    }

    private boolean isLaunchModeOneOf(int mode1, int mode2) {
        return mode1 == this.mLaunchMode || mode2 == this.mLaunchMode;
    }

    static boolean isDocumentLaunchesIntoExisting(int flags) {
        return (flags & 0x80000) != 0 && (flags & 0x8000000) == 0;
    }

    ActivityStarter setIntent(Intent intent) {
        this.mRequest.intent = intent;
        return this;
    }

    @VisibleForTesting
    Intent getIntent() {
        return this.mRequest.intent;
    }

    ActivityStarter setReason(String reason) {
        this.mRequest.reason = reason;
        return this;
    }

    ActivityStarter setCaller(IApplicationThread caller) {
        this.mRequest.caller = caller;
        return this;
    }

    ActivityStarter setEphemeralIntent(Intent intent) {
        this.mRequest.ephemeralIntent = intent;
        return this;
    }

    ActivityStarter setResolvedType(String type) {
        this.mRequest.resolvedType = type;
        return this;
    }

    ActivityStarter setActivityInfo(ActivityInfo info) {
        this.mRequest.activityInfo = info;
        return this;
    }

    ActivityStarter setResolveInfo(ResolveInfo info) {
        this.mRequest.resolveInfo = info;
        return this;
    }

    ActivityStarter setVoiceSession(IVoiceInteractionSession voiceSession) {
        this.mRequest.voiceSession = voiceSession;
        return this;
    }

    ActivityStarter setVoiceInteractor(IVoiceInteractor voiceInteractor) {
        this.mRequest.voiceInteractor = voiceInteractor;
        return this;
    }

    ActivityStarter setResultTo(IBinder resultTo) {
        this.mRequest.resultTo = resultTo;
        return this;
    }

    ActivityStarter setResultWho(String resultWho) {
        this.mRequest.resultWho = resultWho;
        return this;
    }

    ActivityStarter setRequestCode(int requestCode) {
        this.mRequest.requestCode = requestCode;
        return this;
    }

    ActivityStarter setCallingPid(int pid) {
        this.mRequest.callingPid = pid;
        return this;
    }

    ActivityStarter setCallingUid(int uid) {
        this.mRequest.callingUid = uid;
        return this;
    }

    ActivityStarter setCallingPackage(String callingPackage) {
        this.mRequest.callingPackage = callingPackage;
        return this;
    }

    ActivityStarter setRealCallingPid(int pid) {
        this.mRequest.realCallingPid = pid;
        return this;
    }

    ActivityStarter setRealCallingUid(int uid) {
        this.mRequest.realCallingUid = uid;
        return this;
    }

    ActivityStarter setStartFlags(int startFlags) {
        this.mRequest.startFlags = startFlags;
        return this;
    }

    ActivityStarter setActivityOptions(SafeActivityOptions options) {
        this.mRequest.activityOptions = options;
        return this;
    }

    ActivityStarter setActivityOptions(Bundle bOptions) {
        return this.setActivityOptions(SafeActivityOptions.fromBundle(bOptions));
    }

    ActivityStarter setIgnoreTargetSecurity(boolean ignoreTargetSecurity) {
        this.mRequest.ignoreTargetSecurity = ignoreTargetSecurity;
        return this;
    }

    ActivityStarter setFilterCallingUid(int filterCallingUid) {
        this.mRequest.filterCallingUid = filterCallingUid;
        return this;
    }

    ActivityStarter setComponentSpecified(boolean componentSpecified) {
        this.mRequest.componentSpecified = componentSpecified;
        return this;
    }

    ActivityStarter setOutActivity(ActivityRecord[] outActivity) {
        this.mRequest.outActivity = outActivity;
        return this;
    }

    ActivityStarter setInTask(TaskRecord inTask) {
        this.mRequest.inTask = inTask;
        return this;
    }

    ActivityStarter setWaitResult(WaitResult result) {
        this.mRequest.waitResult = result;
        return this;
    }

    ActivityStarter setProfilerInfo(ProfilerInfo info) {
        this.mRequest.profilerInfo = info;
        return this;
    }

    ActivityStarter setGlobalConfiguration(Configuration config) {
        this.mRequest.globalConfig = config;
        return this;
    }

    ActivityStarter setUserId(int userId) {
        this.mRequest.userId = userId;
        return this;
    }

    ActivityStarter setMayWait(int userId) {
        this.mRequest.mayWait = true;
        this.mRequest.userId = userId;
        return this;
    }

    ActivityStarter setAllowPendingRemoteAnimationRegistryLookup(boolean allowLookup) {
        this.mRequest.allowPendingRemoteAnimationRegistryLookup = allowLookup;
        return this;
    }

    ActivityStarter setOriginatingPendingIntent(PendingIntentRecord originatingPendingIntent) {
        this.mRequest.originatingPendingIntent = originatingPendingIntent;
        return this;
    }

    ActivityStarter setAllowBackgroundActivityStart(boolean allowBackgroundActivityStart) {
        this.mRequest.allowBackgroundActivityStart = allowBackgroundActivityStart;
        return this;
    }

    void dump(PrintWriter pw, String prefix) {
        prefix = prefix + "  ";
        pw.print(prefix);
        pw.print("mCurrentUser=");
        pw.println(this.mRootActivityContainer.mCurrentUser);
        pw.print(prefix);
        pw.print("mLastStartReason=");
        pw.println(this.mLastStartReason);
        pw.print(prefix);
        pw.print("mLastStartActivityTimeMs=");
        pw.println(DateFormat.getDateTimeInstance().format(new Date(this.mLastStartActivityTimeMs)));
        pw.print(prefix);
        pw.print("mLastStartActivityResult=");
        pw.println(this.mLastStartActivityResult);
        ActivityRecord r = this.mLastStartActivityRecord[0];
        if (r != null) {
            pw.print(prefix);
            pw.println("mLastStartActivityRecord:");
            r.dump(pw, prefix + "  ");
        }
        if (this.mStartActivity != null) {
            pw.print(prefix);
            pw.println("mStartActivity:");
            this.mStartActivity.dump(pw, prefix + "  ");
        }
        if (this.mIntent != null) {
            pw.print(prefix);
            pw.print("mIntent=");
            pw.println(this.mIntent);
        }
        if (this.mOptions != null) {
            pw.print(prefix);
            pw.print("mOptions=");
            pw.println(this.mOptions);
        }
        pw.print(prefix);
        pw.print("mLaunchSingleTop=");
        pw.print(1 == this.mLaunchMode);
        pw.print(" mLaunchSingleInstance=");
        pw.print(3 == this.mLaunchMode);
        pw.print(" mLaunchSingleTask=");
        pw.println(2 == this.mLaunchMode);
        pw.print(prefix);
        pw.print("mLaunchFlags=0x");
        pw.print(Integer.toHexString(this.mLaunchFlags));
        pw.print(" mDoResume=");
        pw.print(this.mDoResume);
        pw.print(" mAddingToTask=");
        pw.println(this.mAddingToTask);
    }

    private static class Request {
        private static final int DEFAULT_CALLING_UID = -1;
        private static final int DEFAULT_CALLING_PID = 0;
        static final int DEFAULT_REAL_CALLING_UID = -1;
        static final int DEFAULT_REAL_CALLING_PID = 0;
        IApplicationThread caller;
        Intent intent;
        Intent ephemeralIntent;
        String resolvedType;
        ActivityInfo activityInfo;
        ResolveInfo resolveInfo;
        IVoiceInteractionSession voiceSession;
        IVoiceInteractor voiceInteractor;
        IBinder resultTo;
        String resultWho;
        int requestCode;
        int callingPid = 0;
        int callingUid = -1;
        String callingPackage;
        int realCallingPid = 0;
        int realCallingUid = -1;
        int startFlags;
        SafeActivityOptions activityOptions;
        boolean ignoreTargetSecurity;
        boolean componentSpecified;
        boolean avoidMoveToFront;
        ActivityRecord[] outActivity;
        TaskRecord inTask;
        String reason;
        ProfilerInfo profilerInfo;
        Configuration globalConfig;
        int userId;
        WaitResult waitResult;
        int filterCallingUid;
        PendingIntentRecord originatingPendingIntent;
        boolean allowBackgroundActivityStart;
        boolean allowPendingRemoteAnimationRegistryLookup;
        boolean mayWait;

        Request() {
            this.reset();
        }

        void reset() {
            this.caller = null;
            this.intent = null;
            this.ephemeralIntent = null;
            this.resolvedType = null;
            this.activityInfo = null;
            this.resolveInfo = null;
            this.voiceSession = null;
            this.voiceInteractor = null;
            this.resultTo = null;
            this.resultWho = null;
            this.requestCode = 0;
            this.callingPid = 0;
            this.callingUid = -1;
            this.callingPackage = null;
            this.realCallingPid = 0;
            this.realCallingUid = -1;
            this.startFlags = 0;
            this.activityOptions = null;
            this.ignoreTargetSecurity = false;
            this.componentSpecified = false;
            this.outActivity = null;
            this.inTask = null;
            this.reason = null;
            this.profilerInfo = null;
            this.globalConfig = null;
            this.userId = 0;
            this.waitResult = null;
            this.mayWait = false;
            this.avoidMoveToFront = false;
            this.allowPendingRemoteAnimationRegistryLookup = true;
            this.filterCallingUid = -10000;
            this.originatingPendingIntent = null;
            this.allowBackgroundActivityStart = false;
        }

        void set(Request request) {
            this.caller = request.caller;
            this.intent = request.intent;
            this.ephemeralIntent = request.ephemeralIntent;
            this.resolvedType = request.resolvedType;
            this.activityInfo = request.activityInfo;
            this.resolveInfo = request.resolveInfo;
            this.voiceSession = request.voiceSession;
            this.voiceInteractor = request.voiceInteractor;
            this.resultTo = request.resultTo;
            this.resultWho = request.resultWho;
            this.requestCode = request.requestCode;
            this.callingPid = request.callingPid;
            this.callingUid = request.callingUid;
            this.callingPackage = request.callingPackage;
            this.realCallingPid = request.realCallingPid;
            this.realCallingUid = request.realCallingUid;
            this.startFlags = request.startFlags;
            this.activityOptions = request.activityOptions;
            this.ignoreTargetSecurity = request.ignoreTargetSecurity;
            this.componentSpecified = request.componentSpecified;
            this.outActivity = request.outActivity;
            this.inTask = request.inTask;
            this.reason = request.reason;
            this.profilerInfo = request.profilerInfo;
            this.globalConfig = request.globalConfig;
            this.userId = request.userId;
            this.waitResult = request.waitResult;
            this.mayWait = request.mayWait;
            this.avoidMoveToFront = request.avoidMoveToFront;
            this.allowPendingRemoteAnimationRegistryLookup = request.allowPendingRemoteAnimationRegistryLookup;
            this.filterCallingUid = request.filterCallingUid;
            this.originatingPendingIntent = request.originatingPendingIntent;
            this.allowBackgroundActivityStart = request.allowBackgroundActivityStart;
        }
    }

    static class DefaultFactory
    implements Factory {
        private final int MAX_STARTER_COUNT = 3;
        private ActivityStartController mController;
        private ActivityTaskManagerService mService;
        private ActivityStackSupervisor mSupervisor;
        private ActivityStartInterceptor mInterceptor;
        private Pools.SynchronizedPool<ActivityStarter> mStarterPool = new Pools.SynchronizedPool(3);

        DefaultFactory(ActivityTaskManagerService service, ActivityStackSupervisor supervisor, ActivityStartInterceptor interceptor) {
            this.mService = service;
            this.mSupervisor = supervisor;
            this.mInterceptor = interceptor;
        }

        @Override
        public void setController(ActivityStartController controller) {
            this.mController = controller;
        }

        @Override
        public ActivityStarter obtain() {
            ActivityStarter starter = this.mStarterPool.acquire();
            if (starter == null) {
                starter = new ActivityStarter(this.mController, this.mService, this.mSupervisor, this.mInterceptor);
            }
            return starter;
        }

        @Override
        public void recycle(ActivityStarter starter) {
            starter.reset(true);
            this.mStarterPool.release(starter);
        }
    }

    @VisibleForTesting
    static interface Factory {
        public void setController(ActivityStartController var1);

        public ActivityStarter obtain();

        public void recycle(ActivityStarter var1);
    }
}

