/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import android.app.ActivityManager;
import android.app.IApplicationThread;
import android.app.ProfilerInfo;
import android.content.ComponentName;
import android.content.IIntentSender;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.res.CompatibilityInfo;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import android.service.voice.IVoiceInteractionSession;
import android.util.SparseIntArray;
import android.util.proto.ProtoOutputStream;
import com.android.internal.app.IVoiceInteractor;
import com.android.server.am.PendingIntentRecord;
import com.android.server.am.UserState;
import com.android.server.wm.ActivityMetricsLaunchObserverRegistry;
import com.android.server.wm.ActivityServiceConnectionsHolder;
import com.android.server.wm.SafeActivityOptions;
import com.android.server.wm.TaskRecord;
import com.android.server.wm.WindowProcessController;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.Set;

public abstract class ActivityTaskManagerInternal {
    public static final int APP_TRANSITION_SPLASH_SCREEN = 1;
    public static final int APP_TRANSITION_WINDOWS_DRAWN = 2;
    public static final int APP_TRANSITION_TIMEOUT = 3;
    public static final int APP_TRANSITION_SNAPSHOT = 4;
    public static final int APP_TRANSITION_RECENTS_ANIM = 5;
    public static final String ASSIST_TASK_ID = "taskId";
    public static final String ASSIST_ACTIVITY_ID = "activityId";
    public static final String ASSIST_KEY_DATA = "data";
    public static final String ASSIST_KEY_STRUCTURE = "structure";
    public static final String ASSIST_KEY_CONTENT = "content";
    public static final String ASSIST_KEY_RECEIVER_EXTRAS = "receiverExtras";

    public abstract SleepToken acquireSleepToken(String var1, int var2);

    public abstract ComponentName getHomeActivityForUser(int var1);

    public abstract void onLocalVoiceInteractionStarted(IBinder var1, IVoiceInteractionSession var2, IVoiceInteractor var3);

    public abstract void notifyAppTransitionStarting(SparseIntArray var1, long var2);

    public abstract void notifyAppTransitionCancelled();

    public abstract void notifyAppTransitionFinished();

    public abstract List<IBinder> getTopVisibleActivities();

    public abstract void notifyDockedStackMinimizedChanged(boolean var1);

    public abstract int startActivitiesAsPackage(String var1, int var2, Intent[] var3, Bundle var4);

    public abstract int startActivitiesInPackage(int var1, int var2, int var3, String var4, Intent[] var5, String[] var6, IBinder var7, SafeActivityOptions var8, int var9, boolean var10, PendingIntentRecord var11, boolean var12);

    public abstract int startActivityInPackage(int var1, int var2, int var3, String var4, Intent var5, String var6, IBinder var7, String var8, int var9, int var10, SafeActivityOptions var11, int var12, TaskRecord var13, String var14, boolean var15, PendingIntentRecord var16, boolean var17);

    public abstract int startActivityAsUser(IApplicationThread var1, String var2, Intent var3, Bundle var4, int var5);

    public abstract void notifyKeyguardFlagsChanged(Runnable var1, int var2);

    public abstract void notifyKeyguardTrustedChanged();

    public abstract void setVr2dDisplayId(int var1);

    public abstract void setFocusedActivity(IBinder var1);

    public abstract void registerScreenObserver(ScreenObserver var1);

    public abstract boolean isCallerRecents(int var1);

    public abstract boolean isRecentsComponentHomeActivity(int var1);

    public abstract void cancelRecentsAnimation(boolean var1);

    public abstract void enforceCallerIsRecentsOrHasPermission(String var1, String var2);

    public abstract void notifyActiveVoiceInteractionServiceChanged(ComponentName var1);

    public abstract void setAllowAppSwitches(String var1, int var2, int var3);

    public abstract void onUserStopped(int var1);

    public abstract boolean isGetTasksAllowed(String var1, int var2, int var3);

    public abstract void onProcessAdded(WindowProcessController var1);

    public abstract void onProcessRemoved(String var1, int var2);

    public abstract void onCleanUpApplicationRecord(WindowProcessController var1);

    public abstract int getTopProcessState();

    public abstract boolean isHeavyWeightProcess(WindowProcessController var1);

    public abstract void clearHeavyWeightProcessIfEquals(WindowProcessController var1);

    public abstract void finishHeavyWeightApp();

    public abstract boolean isSleeping();

    public abstract boolean isShuttingDown();

    public abstract boolean shuttingDown(boolean var1, int var2);

    public abstract void enableScreenAfterBoot(boolean var1);

    public abstract boolean showStrictModeViolationDialog();

    public abstract void showSystemReadyErrorDialogsIfNeeded();

    public abstract void onProcessMapped(int var1, WindowProcessController var2);

    public abstract void onProcessUnMapped(int var1);

    public abstract void onPackageDataCleared(String var1);

    public abstract void onPackageUninstalled(String var1);

    public abstract void onPackageAdded(String var1, boolean var2);

    public abstract void onPackageReplaced(ApplicationInfo var1);

    public abstract CompatibilityInfo compatibilityInfoForPackage(ApplicationInfo var1);

    public abstract void onImeWindowSetOnDisplay(int var1, int var2);

    public abstract void sendActivityResult(int var1, IBinder var2, String var3, int var4, int var5, Intent var6);

    public abstract void clearPendingResultForActivity(IBinder var1, WeakReference<PendingIntentRecord> var2);

    public abstract ActivityTokens getTopActivityForTask(int var1);

    public abstract IIntentSender getIntentSender(int var1, String var2, int var3, int var4, IBinder var5, String var6, int var7, Intent[] var8, String[] var9, int var10, Bundle var11);

    public abstract ActivityServiceConnectionsHolder getServiceConnectionsHolder(IBinder var1);

    public abstract Intent getHomeIntent();

    public abstract boolean startHomeActivity(int var1, String var2);

    public abstract boolean startHomeOnDisplay(int var1, String var2, int var3, boolean var4, boolean var5);

    public abstract boolean startHomeOnAllDisplays(int var1, String var2);

    public abstract boolean isFactoryTestProcess(WindowProcessController var1);

    public abstract void updateTopComponentForFactoryTest();

    public abstract void handleAppDied(WindowProcessController var1, boolean var2, Runnable var3);

    public abstract void closeSystemDialogs(String var1);

    public abstract void cleanupDisabledPackageComponents(String var1, Set<String> var2, int var3, boolean var4);

    public abstract boolean onForceStopPackage(String var1, boolean var2, boolean var3, int var4);

    public abstract void resumeTopActivities(boolean var1);

    public abstract void preBindApplication(WindowProcessController var1);

    public abstract boolean attachApplication(WindowProcessController var1) throws RemoteException;

    public abstract void notifyLockedProfile(int var1, int var2);

    public abstract void startConfirmDeviceCredentialIntent(Intent var1, Bundle var2);

    public abstract void writeActivitiesToProto(ProtoOutputStream var1);

    public abstract void saveANRState(String var1);

    public abstract void clearSavedANRState();

    public abstract void dump(String var1, FileDescriptor var2, PrintWriter var3, String[] var4, int var5, boolean var6, boolean var7, String var8);

    public abstract boolean dumpForProcesses(FileDescriptor var1, PrintWriter var2, boolean var3, String var4, int var5, boolean var6, boolean var7, int var8);

    public abstract void writeProcessesToProto(ProtoOutputStream var1, String var2, int var3, boolean var4);

    public abstract boolean dumpActivity(FileDescriptor var1, PrintWriter var2, String var3, String[] var4, int var5, boolean var6, boolean var7, boolean var8);

    public abstract void dumpForOom(PrintWriter var1);

    public abstract boolean canGcNow();

    public abstract WindowProcessController getTopApp();

    public abstract void rankTaskLayersIfNeeded();

    public abstract void scheduleDestroyAllActivities(String var1);

    public abstract void removeUser(int var1);

    public abstract boolean switchUser(int var1, UserState var2);

    public abstract void onHandleAppCrash(WindowProcessController var1);

    public abstract int finishTopCrashedActivities(WindowProcessController var1, String var2);

    public abstract void onUidActive(int var1, int var2);

    public abstract void onUidInactive(int var1);

    public abstract void onActiveUidsCleared();

    public abstract void onUidProcStateChanged(int var1, int var2);

    public abstract void onUidAddedToPendingTempWhitelist(int var1, String var2);

    public abstract void onUidRemovedFromPendingTempWhitelist(int var1);

    public abstract boolean handleAppCrashInActivityController(String var1, int var2, String var3, String var4, long var5, String var7, Runnable var8);

    public abstract void removeRecentTasksByPackageName(String var1, int var2);

    public abstract void cleanupRecentTasksForUser(int var1);

    public abstract void loadRecentTasksForUser(int var1);

    public abstract void onPackagesSuspendedChanged(String[] var1, boolean var2, int var3);

    public abstract void flushRecentTasks();

    public abstract WindowProcessController getHomeProcess();

    public abstract WindowProcessController getPreviousProcess();

    public abstract void clearLockedTasks(String var1);

    public abstract void updateUserConfiguration();

    public abstract boolean canShowErrorDialogs();

    public abstract void setProfileApp(String var1);

    public abstract void setProfileProc(WindowProcessController var1);

    public abstract void setProfilerInfo(ProfilerInfo var1);

    public abstract ActivityMetricsLaunchObserverRegistry getLaunchObserverRegistry();

    public abstract ActivityManager.TaskSnapshot getTaskSnapshotNoRestore(int var1, boolean var2);

    public abstract boolean isUidForeground(int var1);

    public abstract void setDeviceOwnerUid(int var1);

    public abstract void setCompanionAppPackages(int var1, Set<String> var2);

    public final class ActivityTokens {
        private final IBinder mActivityToken;
        private final IBinder mAssistToken;
        private final IApplicationThread mAppThread;

        public ActivityTokens(IBinder activityToken, IBinder assistToken, IApplicationThread appThread) {
            this.mActivityToken = activityToken;
            this.mAssistToken = assistToken;
            this.mAppThread = appThread;
        }

        public IBinder getActivityToken() {
            return this.mActivityToken;
        }

        public IBinder getAssistToken() {
            return this.mAssistToken;
        }

        public IApplicationThread getApplicationThread() {
            return this.mAppThread;
        }
    }

    public static abstract class SleepToken {
        public abstract void release();
    }

    public static interface ScreenObserver {
        public void onAwakeStateChanged(boolean var1);

        public void onKeyguardStateChanged(boolean var1);
    }
}

