/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import android.app.ActivityManager;
import android.app.IAppTask;
import android.app.IApplicationThread;
import android.content.Intent;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.UserHandle;
import android.util.Slog;
import com.android.server.wm.ActivityStarter;
import com.android.server.wm.ActivityTaskManagerService;
import com.android.server.wm.TaskRecord;
import com.android.server.wm.WindowManagerGlobalLock;
import com.android.server.wm.WindowManagerService;
import com.android.server.wm.WindowProcessController;

class AppTaskImpl
extends IAppTask.Stub {
    private static final String TAG = "AppTaskImpl";
    private ActivityTaskManagerService mService;
    private int mTaskId;
    private int mCallingUid;

    public AppTaskImpl(ActivityTaskManagerService service, int taskId, int callingUid) {
        this.mService = service;
        this.mTaskId = taskId;
        this.mCallingUid = callingUid;
    }

    private void checkCaller() {
        if (this.mCallingUid != Binder.getCallingUid()) {
            throw new SecurityException("Caller " + this.mCallingUid + " does not match caller of getAppTasks(): " + Binder.getCallingUid());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finishAndRemoveTask() {
        this.checkCaller();
        WindowManagerGlobalLock windowManagerGlobalLock = this.mService.mGlobalLock;
        synchronized (windowManagerGlobalLock) {
            try {
                WindowManagerService.boostPriorityForLockedSection();
                long origId = Binder.clearCallingIdentity();
                try {
                    if (!this.mService.mStackSupervisor.removeTaskByIdLocked(this.mTaskId, false, true, "finish-and-remove-task")) {
                        throw new IllegalArgumentException("Unable to find task ID " + this.mTaskId);
                    }
                }
                finally {
                    Binder.restoreCallingIdentity(origId);
                }
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[2, 4] lbl17 : MonitorExitStatement: MONITOREXIT : var1_1
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        WindowManagerService.resetPriorityAfterLockedSection();
    }

    /*
     * Exception decompiling
     */
    @Override
    public ActivityManager.RecentTaskInfo getTaskInfo() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void moveToFront(IApplicationThread appThread, String callingPackage) {
        int callingUid;
        int callingPid;
        block12: {
            ActivityStarter starter;
            long origId;
            block11: {
                this.checkCaller();
                callingPid = Binder.getCallingPid();
                callingUid = Binder.getCallingUid();
                if (!this.mService.isSameApp(callingUid, callingPackage)) {
                    String msg = "Permission Denial: moveToFront() from pid=" + Binder.getCallingPid() + " as package " + callingPackage;
                    Slog.w(TAG, msg);
                    throw new SecurityException(msg);
                }
                origId = Binder.clearCallingIdentity();
                WindowManagerGlobalLock windowManagerGlobalLock = this.mService.mGlobalLock;
                // MONITORENTER : windowManagerGlobalLock
                try {
                    WindowManagerService.boostPriorityForLockedSection();
                    if (this.mService.checkAppSwitchAllowedLocked(callingPid, callingUid, -1, -1, "Move to front")) break block11;
                    // MONITOREXIT : windowManagerGlobalLock
                }
                catch (Throwable throwable) {
                    // MONITOREXIT : windowManagerGlobalLock
                    WindowManagerService.resetPriorityAfterLockedSection();
                    throw throwable;
                }
                WindowManagerService.resetPriorityAfterLockedSection();
                Binder.restoreCallingIdentity(origId);
                return;
            }
            WindowProcessController callerApp = null;
            if (appThread != null) {
                callerApp = this.mService.getProcessController(appThread);
            }
            if (!(starter = this.mService.getActivityStartController().obtainStarter(null, "moveToFront")).shouldAbortBackgroundActivityStart(callingUid, callingPid, callingPackage, -1, -1, callerApp, null, false, null) || this.mService.isBackgroundActivityStartsEnabled()) break block12;
            // MONITOREXIT : windowManagerGlobalLock
            WindowManagerService.resetPriorityAfterLockedSection();
            Binder.restoreCallingIdentity(origId);
            return;
        }
        this.mService.mStackSupervisor.startActivityFromRecents(callingPid, callingUid, this.mTaskId, null);
        // MONITOREXIT : windowManagerGlobalLock
        WindowManagerService.resetPriorityAfterLockedSection();
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int startActivity(IBinder whoThread, String callingPackage, Intent intent, String resolvedType, Bundle bOptions) {
        IApplicationThread appThread;
        TaskRecord tr;
        this.checkCaller();
        int callingUser = UserHandle.getCallingUserId();
        WindowManagerGlobalLock windowManagerGlobalLock = this.mService.mGlobalLock;
        synchronized (windowManagerGlobalLock) {
            try {
                WindowManagerService.boostPriorityForLockedSection();
                tr = this.mService.mRootActivityContainer.anyTaskForId(this.mTaskId, 1);
                if (tr == null) {
                    throw new IllegalArgumentException("Unable to find task ID " + this.mTaskId);
                }
                appThread = IApplicationThread.Stub.asInterface(whoThread);
                if (appThread == null) {
                    throw new IllegalArgumentException("Bad app thread " + appThread);
                }
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl16 : MonitorExitStatement: MONITOREXIT : var9_7
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        WindowManagerService.resetPriorityAfterLockedSection();
        return this.mService.getActivityStartController().obtainStarter(intent, TAG).setCaller(appThread).setCallingPackage(callingPackage).setResolvedType(resolvedType).setActivityOptions(bOptions).setMayWait(callingUser).setInTask(tr).execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setExcludeFromRecents(boolean exclude) {
        this.checkCaller();
        WindowManagerGlobalLock windowManagerGlobalLock = this.mService.mGlobalLock;
        synchronized (windowManagerGlobalLock) {
            try {
                WindowManagerService.boostPriorityForLockedSection();
                long origId = Binder.clearCallingIdentity();
                try {
                    TaskRecord tr = this.mService.mRootActivityContainer.anyTaskForId(this.mTaskId, 1);
                    if (tr == null) {
                        throw new IllegalArgumentException("Unable to find task ID " + this.mTaskId);
                    }
                    Intent intent = tr.getBaseIntent();
                    if (exclude) {
                        intent.addFlags(0x800000);
                    } else {
                        intent.setFlags(intent.getFlags() & 0xFF7FFFFF);
                    }
                }
                finally {
                    Binder.restoreCallingIdentity(origId);
                }
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[2, 4] lbl25 : MonitorExitStatement: MONITOREXIT : var2_2
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        WindowManagerService.resetPriorityAfterLockedSection();
    }
}

