/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import android.os.SystemClock;
import android.os.Trace;
import android.util.ArraySet;
import android.util.SparseIntArray;
import android.view.RemoteAnimationAdapter;
import android.view.RemoteAnimationDefinition;
import android.view.WindowManager;
import android.view.animation.Animation;
import com.android.internal.annotations.VisibleForTesting;
import com.android.server.wm.AppTransition;
import com.android.server.wm.AppWindowToken;
import com.android.server.wm.DisplayContent;
import com.android.server.wm.ScreenRotationAnimation;
import com.android.server.wm.SplashScreenStartingData;
import com.android.server.wm.Task;
import com.android.server.wm.WallpaperController;
import com.android.server.wm.WindowManagerService;
import com.android.server.wm.WindowState;
import java.util.function.Predicate;

public class AppTransitionController {
    private static final String TAG = "WindowManager";
    private final WindowManagerService mService;
    private final DisplayContent mDisplayContent;
    private final WallpaperController mWallpaperControllerLocked;
    private RemoteAnimationDefinition mRemoteAnimationDefinition = null;
    private final SparseIntArray mTempTransitionReasons = new SparseIntArray();

    AppTransitionController(WindowManagerService service, DisplayContent displayContent) {
        this.mService = service;
        this.mDisplayContent = displayContent;
        this.mWallpaperControllerLocked = this.mDisplayContent.mWallpaperController;
    }

    void registerRemoteAnimations(RemoteAnimationDefinition definition) {
        this.mRemoteAnimationDefinition = definition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleAppTransitionReady() {
        int layoutRedo;
        int i;
        this.mTempTransitionReasons.clear();
        if (!this.transitionGoodToGo(this.mDisplayContent.mOpeningApps, this.mTempTransitionReasons) || !this.transitionGoodToGo(this.mDisplayContent.mChangingApps, this.mTempTransitionReasons)) {
            return;
        }
        Trace.traceBegin(32L, "AppTransitionReady");
        AppTransition appTransition = this.mDisplayContent.mAppTransition;
        int transit = appTransition.getAppTransition();
        if (this.mDisplayContent.mSkipAppTransitionAnimation && !AppTransition.isKeyguardGoingAwayTransit(transit)) {
            transit = -1;
        }
        this.mDisplayContent.mSkipAppTransitionAnimation = false;
        this.mDisplayContent.mNoAnimationNotifyOnTransitionFinished.clear();
        appTransition.removeAppTransitionTimeoutCallbacks();
        this.mDisplayContent.mWallpaperMayChange = false;
        int appCount = this.mDisplayContent.mOpeningApps.size();
        for (i = 0; i < appCount; ++i) {
            this.mDisplayContent.mOpeningApps.valueAtUnchecked(i).clearAnimatingFlags();
        }
        appCount = this.mDisplayContent.mChangingApps.size();
        for (i = 0; i < appCount; ++i) {
            this.mDisplayContent.mChangingApps.valueAtUnchecked(i).clearAnimatingFlags();
        }
        this.mWallpaperControllerLocked.adjustWallpaperWindowsForAppTransitionIfNeeded(this.mDisplayContent.mOpeningApps, this.mDisplayContent.mChangingApps);
        boolean hasWallpaperTarget = this.mWallpaperControllerLocked.getWallpaperTarget() != null;
        boolean openingAppHasWallpaper = this.canBeWallpaperTarget(this.mDisplayContent.mOpeningApps) && hasWallpaperTarget;
        boolean closingAppHasWallpaper = this.canBeWallpaperTarget(this.mDisplayContent.mClosingApps) && hasWallpaperTarget;
        transit = this.maybeUpdateTransitToTranslucentAnim(transit);
        transit = this.maybeUpdateTransitToWallpaper(transit, openingAppHasWallpaper, closingAppHasWallpaper);
        ArraySet<Integer> activityTypes = AppTransitionController.collectActivityTypes(this.mDisplayContent.mOpeningApps, this.mDisplayContent.mClosingApps, this.mDisplayContent.mChangingApps);
        boolean allowAnimations = this.mDisplayContent.getDisplayPolicy().allowAppAnimationsLw();
        AppWindowToken animLpToken = allowAnimations ? this.findAnimLayoutParamsToken(transit, activityTypes) : null;
        AppWindowToken topOpeningApp = allowAnimations ? this.getTopApp(this.mDisplayContent.mOpeningApps, false) : null;
        AppWindowToken topClosingApp = allowAnimations ? this.getTopApp(this.mDisplayContent.mClosingApps, false) : null;
        AppWindowToken topChangingApp = allowAnimations ? this.getTopApp(this.mDisplayContent.mChangingApps, false) : null;
        WindowManager.LayoutParams animLp = AppTransitionController.getAnimLp(animLpToken);
        this.overrideWithRemoteAnimationIfSet(animLpToken, transit, activityTypes);
        boolean voiceInteraction = this.containsVoiceInteraction(this.mDisplayContent.mOpeningApps) || this.containsVoiceInteraction(this.mDisplayContent.mOpeningApps) || this.containsVoiceInteraction(this.mDisplayContent.mChangingApps);
        this.mService.mSurfaceAnimationRunner.deferStartingAnimations();
        try {
            this.processApplicationsAnimatingInPlace(transit);
            this.handleClosingApps(transit, animLp, voiceInteraction);
            this.handleOpeningApps(transit, animLp, voiceInteraction);
            this.handleChangingApps(transit, animLp, voiceInteraction);
            appTransition.setLastAppTransition(transit, topOpeningApp, topClosingApp, topChangingApp);
            int flags = appTransition.getTransitFlags();
            layoutRedo = appTransition.goodToGo(transit, topOpeningApp, this.mDisplayContent.mOpeningApps);
            this.handleNonAppWindowsInTransition(transit, flags);
            appTransition.postAnimationCallback();
            appTransition.clear();
        }
        finally {
            this.mService.mSurfaceAnimationRunner.continueStartingAnimations();
        }
        this.mService.mTaskSnapshotController.onTransitionStarting(this.mDisplayContent);
        this.mDisplayContent.mOpeningApps.clear();
        this.mDisplayContent.mClosingApps.clear();
        this.mDisplayContent.mChangingApps.clear();
        this.mDisplayContent.mUnknownAppVisibilityController.clear();
        this.mDisplayContent.setLayoutNeeded();
        this.mDisplayContent.computeImeTarget(true);
        this.mService.mAtmInternal.notifyAppTransitionStarting(this.mTempTransitionReasons.clone(), SystemClock.uptimeMillis());
        Trace.traceEnd(32L);
        this.mDisplayContent.pendingLayoutChanges |= layoutRedo | 1 | 2;
    }

    private static WindowManager.LayoutParams getAnimLp(AppWindowToken wtoken) {
        WindowState mainWindow = wtoken != null ? wtoken.findMainWindow() : null;
        return mainWindow != null ? mainWindow.mAttrs : null;
    }

    RemoteAnimationAdapter getRemoteAnimationOverride(AppWindowToken animLpToken, int transit, ArraySet<Integer> activityTypes) {
        RemoteAnimationAdapter adapter;
        RemoteAnimationDefinition definition = animLpToken.getRemoteAnimationDefinition();
        if (definition != null && (adapter = definition.getAdapter(transit, activityTypes)) != null) {
            return adapter;
        }
        if (this.mRemoteAnimationDefinition == null) {
            return null;
        }
        return this.mRemoteAnimationDefinition.getAdapter(transit, activityTypes);
    }

    private void overrideWithRemoteAnimationIfSet(AppWindowToken animLpToken, int transit, ArraySet<Integer> activityTypes) {
        if (transit == 26) {
            return;
        }
        if (animLpToken == null) {
            return;
        }
        RemoteAnimationAdapter adapter = this.getRemoteAnimationOverride(animLpToken, transit, activityTypes);
        if (adapter != null) {
            animLpToken.getDisplayContent().mAppTransition.overridePendingAppTransitionRemote(adapter);
        }
    }

    private AppWindowToken findAnimLayoutParamsToken(int transit, ArraySet<Integer> activityTypes) {
        ArraySet<AppWindowToken> closingApps = this.mDisplayContent.mClosingApps;
        ArraySet<AppWindowToken> openingApps = this.mDisplayContent.mOpeningApps;
        ArraySet<AppWindowToken> changingApps = this.mDisplayContent.mChangingApps;
        AppWindowToken result = AppTransitionController.lookForHighestTokenWithFilter(closingApps, openingApps, changingApps, w -> w.getRemoteAnimationDefinition() != null && w.getRemoteAnimationDefinition().hasTransition(transit, activityTypes));
        if (result != null) {
            return result;
        }
        result = AppTransitionController.lookForHighestTokenWithFilter(closingApps, openingApps, changingApps, w -> w.fillsParent() && w.findMainWindow() != null);
        if (result != null) {
            return result;
        }
        return AppTransitionController.lookForHighestTokenWithFilter(closingApps, openingApps, changingApps, w -> w.findMainWindow() != null);
    }

    private static ArraySet<Integer> collectActivityTypes(ArraySet<AppWindowToken> array1, ArraySet<AppWindowToken> array2, ArraySet<AppWindowToken> array3) {
        int i;
        ArraySet<Integer> result = new ArraySet<Integer>();
        for (i = array1.size() - 1; i >= 0; --i) {
            result.add(array1.valueAt(i).getActivityType());
        }
        for (i = array2.size() - 1; i >= 0; --i) {
            result.add(array2.valueAt(i).getActivityType());
        }
        for (i = array3.size() - 1; i >= 0; --i) {
            result.add(array3.valueAt(i).getActivityType());
        }
        return result;
    }

    private static AppWindowToken lookForHighestTokenWithFilter(ArraySet<AppWindowToken> array1, ArraySet<AppWindowToken> array2, ArraySet<AppWindowToken> array3, Predicate<AppWindowToken> filter) {
        int array2base = array1.size();
        int array3base = array2.size() + array2base;
        int count = array3base + array3.size();
        int bestPrefixOrderIndex = Integer.MIN_VALUE;
        AppWindowToken bestToken = null;
        for (int i = 0; i < count; ++i) {
            AppWindowToken wtoken = i < array2base ? array1.valueAt(i) : (i < array3base ? array2.valueAt(i - array2base) : array3.valueAt(i - array3base));
            int prefixOrderIndex = wtoken.getPrefixOrderIndex();
            if (!filter.test(wtoken) || prefixOrderIndex <= bestPrefixOrderIndex) continue;
            bestPrefixOrderIndex = prefixOrderIndex;
            bestToken = wtoken;
        }
        return bestToken;
    }

    private boolean containsVoiceInteraction(ArraySet<AppWindowToken> apps) {
        for (int i = apps.size() - 1; i >= 0; --i) {
            if (!apps.valueAt((int)i).mVoiceInteraction) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleOpeningApps(int transit, WindowManager.LayoutParams animLp, boolean voiceInteraction) {
        ArraySet<AppWindowToken> openingApps = this.mDisplayContent.mOpeningApps;
        int appsCount = openingApps.size();
        for (int i = 0; i < appsCount; ++i) {
            AppWindowToken wtoken = openingApps.valueAt(i);
            if (!wtoken.commitVisibility(animLp, true, transit, false, voiceInteraction)) {
                this.mDisplayContent.mNoAnimationNotifyOnTransitionFinished.add(wtoken.token);
            }
            wtoken.updateReportedVisibilityLocked();
            wtoken.waitingToShow = false;
            this.mService.openSurfaceTransaction();
            try {
                wtoken.showAllWindowsLocked();
            }
            finally {
                this.mService.closeSurfaceTransaction("handleAppTransitionReady");
            }
            if (this.mDisplayContent.mAppTransition.isNextAppTransitionThumbnailUp()) {
                wtoken.attachThumbnailAnimation();
                continue;
            }
            if (!this.mDisplayContent.mAppTransition.isNextAppTransitionOpenCrossProfileApps()) continue;
            wtoken.attachCrossProfileAppsThumbnailAnimation();
        }
    }

    private void handleClosingApps(int transit, WindowManager.LayoutParams animLp, boolean voiceInteraction) {
        ArraySet<AppWindowToken> closingApps = this.mDisplayContent.mClosingApps;
        int appsCount = closingApps.size();
        for (int i = 0; i < appsCount; ++i) {
            AppWindowToken wtoken = closingApps.valueAt(i);
            wtoken.commitVisibility(animLp, false, transit, false, voiceInteraction);
            wtoken.updateReportedVisibilityLocked();
            wtoken.allDrawn = true;
            wtoken.deferClearAllDrawn = false;
            if (wtoken.startingWindow != null && !wtoken.startingWindow.mAnimatingExit) {
                wtoken.removeStartingWindow();
            }
            if (!this.mDisplayContent.mAppTransition.isNextAppTransitionThumbnailDown()) continue;
            wtoken.attachThumbnailAnimation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleChangingApps(int transit, WindowManager.LayoutParams animLp, boolean voiceInteraction) {
        ArraySet<AppWindowToken> apps = this.mDisplayContent.mChangingApps;
        int appsCount = apps.size();
        for (int i = 0; i < appsCount; ++i) {
            AppWindowToken wtoken = apps.valueAt(i);
            wtoken.cancelAnimationOnly();
            wtoken.applyAnimationLocked(null, transit, true, false);
            wtoken.updateReportedVisibilityLocked();
            this.mService.openSurfaceTransaction();
            try {
                wtoken.showAllWindowsLocked();
                continue;
            }
            finally {
                this.mService.closeSurfaceTransaction("handleChangingApps");
            }
        }
    }

    private void handleNonAppWindowsInTransition(int transit, int flags) {
        Animation anim2;
        if (transit == 20 && (flags & 4) != 0 && (flags & 2) == 0 && (anim2 = this.mService.mPolicy.createKeyguardWallpaperExit((flags & 1) != 0)) != null) {
            this.mDisplayContent.mWallpaperController.startWallpaperAnimation(anim2);
        }
        if (transit == 20 || transit == 21) {
            this.mDisplayContent.startKeyguardExitOnNonAppWindows(transit == 21, (flags & 1) != 0);
        }
    }

    private boolean transitionGoodToGo(ArraySet<AppWindowToken> apps, SparseIntArray outReasons) {
        ScreenRotationAnimation screenRotationAnimation = this.mService.mAnimator.getScreenRotationAnimationLocked(0);
        if (!this.mDisplayContent.mAppTransition.isTimeout()) {
            boolean wallpaperReady;
            if (screenRotationAnimation != null && screenRotationAnimation.isAnimating() && this.mService.getDefaultDisplayContentLocked().rotationNeedsUpdate()) {
                return false;
            }
            for (int i = 0; i < apps.size(); ++i) {
                boolean allDrawn;
                AppWindowToken wtoken = apps.valueAt(i);
                boolean bl = allDrawn = wtoken.allDrawn && !wtoken.isRelaunching();
                if (!(allDrawn || wtoken.startingDisplayed || wtoken.startingMoved)) {
                    return false;
                }
                int windowingMode = wtoken.getWindowingMode();
                if (allDrawn) {
                    outReasons.put(windowingMode, 2);
                    continue;
                }
                outReasons.put(windowingMode, wtoken.mStartingData instanceof SplashScreenStartingData ? 1 : 4);
            }
            if (this.mDisplayContent.mAppTransition.isFetchingAppTransitionsSpecs()) {
                return false;
            }
            if (!this.mDisplayContent.mUnknownAppVisibilityController.allResolved()) {
                return false;
            }
            boolean bl = wallpaperReady = !this.mWallpaperControllerLocked.isWallpaperVisible() || this.mWallpaperControllerLocked.wallpaperTransitionReady();
            return wallpaperReady;
        }
        return true;
    }

    private int maybeUpdateTransitToWallpaper(int transit, boolean openingAppHasWallpaper, boolean closingAppHasWallpaper) {
        if (transit == 0 || transit == 26 || transit == 19 || AppTransition.isChangeTransit(transit)) {
            return transit;
        }
        WindowState wallpaperTarget = this.mWallpaperControllerLocked.getWallpaperTarget();
        boolean showWallpaper = wallpaperTarget != null && (wallpaperTarget.mAttrs.flags & 0x100000) != 0;
        WindowState oldWallpaper = this.mWallpaperControllerLocked.isWallpaperTargetAnimating() || !showWallpaper ? null : wallpaperTarget;
        ArraySet<AppWindowToken> openingApps = this.mDisplayContent.mOpeningApps;
        ArraySet<AppWindowToken> closingApps = this.mDisplayContent.mClosingApps;
        AppWindowToken topOpeningApp = this.getTopApp(this.mDisplayContent.mOpeningApps, false);
        AppWindowToken topClosingApp = this.getTopApp(this.mDisplayContent.mClosingApps, true);
        boolean openingCanBeWallpaperTarget = this.canBeWallpaperTarget(openingApps);
        if (openingCanBeWallpaperTarget && transit == 20) {
            transit = 21;
        } else if (!AppTransition.isKeyguardGoingAwayTransit(transit)) {
            if (closingAppHasWallpaper && openingAppHasWallpaper) {
                switch (transit) {
                    case 6: 
                    case 8: 
                    case 10: {
                        transit = 14;
                        break;
                    }
                    case 7: 
                    case 9: 
                    case 11: {
                        transit = 15;
                    }
                }
            } else if (oldWallpaper != null && !this.mDisplayContent.mOpeningApps.isEmpty() && !openingApps.contains(oldWallpaper.mAppToken) && closingApps.contains(oldWallpaper.mAppToken) && topClosingApp == oldWallpaper.mAppToken) {
                transit = 12;
            } else if (wallpaperTarget != null && wallpaperTarget.isVisibleLw() && openingApps.contains(wallpaperTarget.mAppToken) && topOpeningApp == wallpaperTarget.mAppToken && transit != 25) {
                transit = 13;
            }
        }
        return transit;
    }

    @VisibleForTesting
    int maybeUpdateTransitToTranslucentAnim(int transit) {
        if (AppTransition.isChangeTransit(transit)) {
            return transit;
        }
        boolean taskOrActivity = AppTransition.isTaskTransit(transit) || AppTransition.isActivityTransit(transit);
        boolean allOpeningVisible = true;
        boolean allTranslucentOpeningApps = !this.mDisplayContent.mOpeningApps.isEmpty();
        for (int i = this.mDisplayContent.mOpeningApps.size() - 1; i >= 0; --i) {
            AppWindowToken token = this.mDisplayContent.mOpeningApps.valueAt(i);
            if (token.isVisible()) continue;
            allOpeningVisible = false;
            if (!token.fillsParent()) continue;
            allTranslucentOpeningApps = false;
        }
        boolean allTranslucentClosingApps = !this.mDisplayContent.mClosingApps.isEmpty();
        for (int i = this.mDisplayContent.mClosingApps.size() - 1; i >= 0; --i) {
            if (!this.mDisplayContent.mClosingApps.valueAt(i).fillsParent()) continue;
            allTranslucentClosingApps = false;
            break;
        }
        if (taskOrActivity && allTranslucentClosingApps && allOpeningVisible) {
            return 25;
        }
        if (taskOrActivity && allTranslucentOpeningApps && this.mDisplayContent.mClosingApps.isEmpty()) {
            return 24;
        }
        return transit;
    }

    @VisibleForTesting
    boolean isTransitWithinTask(int transit, Task task) {
        if (task == null || !this.mDisplayContent.mChangingApps.isEmpty()) {
            return false;
        }
        if (transit != 6 && transit != 7 && transit != 18) {
            return false;
        }
        for (AppWindowToken activity : this.mDisplayContent.mOpeningApps) {
            Task activityTask = activity.getTask();
            if (activityTask == task) continue;
            return false;
        }
        for (AppWindowToken activity : this.mDisplayContent.mClosingApps) {
            if (activity.getTask() == task) continue;
            return false;
        }
        return true;
    }

    private boolean canBeWallpaperTarget(ArraySet<AppWindowToken> apps) {
        for (int i = apps.size() - 1; i >= 0; --i) {
            if (!apps.valueAt(i).windowsCanBeWallpaperTarget()) continue;
            return true;
        }
        return false;
    }

    private AppWindowToken getTopApp(ArraySet<AppWindowToken> apps, boolean ignoreHidden) {
        int topPrefixOrderIndex = Integer.MIN_VALUE;
        AppWindowToken topApp = null;
        for (int i = apps.size() - 1; i >= 0; --i) {
            int prefixOrderIndex;
            AppWindowToken app = apps.valueAt(i);
            if (ignoreHidden && app.isHidden() || (prefixOrderIndex = app.getPrefixOrderIndex()) <= topPrefixOrderIndex) continue;
            topPrefixOrderIndex = prefixOrderIndex;
            topApp = app;
        }
        return topApp;
    }

    private void processApplicationsAnimatingInPlace(int transit) {
        WindowState win;
        if (transit == 17 && (win = this.mDisplayContent.findFocusedWindow()) != null) {
            AppWindowToken wtoken = win.mAppToken;
            wtoken.cancelAnimation();
            wtoken.applyAnimationLocked(null, transit, false, false);
            wtoken.updateReportedVisibilityLocked();
            wtoken.showAllWindowsLocked();
        }
    }
}

