/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import android.content.ComponentName;
import android.content.Context;
import android.content.res.Configuration;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.util.AtomicFile;
import android.util.DisplayMetrics;
import android.util.Slog;
import android.util.Xml;
import com.android.internal.util.FastXmlSerializer;
import com.android.server.wm.ActivityRecord;
import com.android.server.wm.ActivityTaskManagerService;
import com.android.server.wm.DeprecatedTargetSdkVersionDialog;
import com.android.server.wm.UnsupportedCompileSdkDialog;
import com.android.server.wm.UnsupportedDisplaySizeDialog;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

class AppWarnings {
    private static final String TAG = "AppWarnings";
    private static final String CONFIG_FILE_NAME = "packages-warnings.xml";
    public static final int FLAG_HIDE_DISPLAY_SIZE = 1;
    public static final int FLAG_HIDE_COMPILE_SDK = 2;
    public static final int FLAG_HIDE_DEPRECATED_SDK = 4;
    private final HashMap<String, Integer> mPackageFlags = new HashMap();
    private final ActivityTaskManagerService mAtm;
    private final Context mUiContext;
    private final ConfigHandler mHandler;
    private final UiHandler mUiHandler;
    private final AtomicFile mConfigFile;
    private UnsupportedDisplaySizeDialog mUnsupportedDisplaySizeDialog;
    private UnsupportedCompileSdkDialog mUnsupportedCompileSdkDialog;
    private DeprecatedTargetSdkVersionDialog mDeprecatedTargetSdkVersionDialog;
    private HashSet<ComponentName> mAlwaysShowUnsupportedCompileSdkWarningActivities = new HashSet();

    void alwaysShowUnsupportedCompileSdkWarning(ComponentName activity) {
        this.mAlwaysShowUnsupportedCompileSdkWarningActivities.add(activity);
    }

    public AppWarnings(ActivityTaskManagerService atm, Context uiContext, Handler handler, Handler uiHandler, File systemDir) {
        this.mAtm = atm;
        this.mUiContext = uiContext;
        this.mHandler = new ConfigHandler(handler.getLooper());
        this.mUiHandler = new UiHandler(uiHandler.getLooper());
        this.mConfigFile = new AtomicFile(new File(systemDir, CONFIG_FILE_NAME), "warnings-config");
        this.readConfigFromFileAmsThread();
    }

    public void showUnsupportedDisplaySizeDialogIfNeeded(ActivityRecord r) {
        Configuration globalConfig = this.mAtm.getGlobalConfiguration();
        if (globalConfig.densityDpi != DisplayMetrics.DENSITY_DEVICE_STABLE && r.appInfo.requiresSmallestWidthDp > globalConfig.smallestScreenWidthDp) {
            this.mUiHandler.showUnsupportedDisplaySizeDialog(r);
        }
    }

    public void showUnsupportedCompileSdkDialogIfNeeded(ActivityRecord r) {
        boolean isPlatformSdkPreview;
        if (r.appInfo.compileSdkVersion == 0 || r.appInfo.compileSdkVersionCodename == null) {
            return;
        }
        if (!this.mAlwaysShowUnsupportedCompileSdkWarningActivities.contains(r.mActivityComponent)) {
            return;
        }
        int compileSdk = r.appInfo.compileSdkVersion;
        int platformSdk = Build.VERSION.SDK_INT;
        boolean isCompileSdkPreview = !"REL".equals(r.appInfo.compileSdkVersionCodename);
        boolean bl = isPlatformSdkPreview = !"REL".equals(Build.VERSION.CODENAME);
        if (isCompileSdkPreview && compileSdk < platformSdk || isPlatformSdkPreview && platformSdk < compileSdk || isCompileSdkPreview && isPlatformSdkPreview && platformSdk == compileSdk && !Build.VERSION.CODENAME.equals(r.appInfo.compileSdkVersionCodename)) {
            this.mUiHandler.showUnsupportedCompileSdkDialog(r);
        }
    }

    public void showDeprecatedTargetDialogIfNeeded(ActivityRecord r) {
        if (r.appInfo.targetSdkVersion < Build.VERSION.MIN_SUPPORTED_TARGET_SDK_INT) {
            this.mUiHandler.showDeprecatedTargetDialog(r);
        }
    }

    public void onStartActivity(ActivityRecord r) {
        this.showUnsupportedCompileSdkDialogIfNeeded(r);
        this.showUnsupportedDisplaySizeDialogIfNeeded(r);
        this.showDeprecatedTargetDialogIfNeeded(r);
    }

    public void onResumeActivity(ActivityRecord r) {
        this.showUnsupportedDisplaySizeDialogIfNeeded(r);
    }

    public void onPackageDataCleared(String name) {
        this.removePackageAndHideDialogs(name);
    }

    public void onPackageUninstalled(String name) {
        this.removePackageAndHideDialogs(name);
    }

    public void onDensityChanged() {
        this.mUiHandler.hideUnsupportedDisplaySizeDialog();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removePackageAndHideDialogs(String name) {
        this.mUiHandler.hideDialogsForPackage(name);
        HashMap<String, Integer> hashMap = this.mPackageFlags;
        synchronized (hashMap) {
            this.mPackageFlags.remove(name);
            this.mHandler.scheduleWrite();
        }
    }

    private void hideUnsupportedDisplaySizeDialogUiThread() {
        if (this.mUnsupportedDisplaySizeDialog != null) {
            this.mUnsupportedDisplaySizeDialog.dismiss();
            this.mUnsupportedDisplaySizeDialog = null;
        }
    }

    private void showUnsupportedDisplaySizeDialogUiThread(ActivityRecord ar) {
        if (this.mUnsupportedDisplaySizeDialog != null) {
            this.mUnsupportedDisplaySizeDialog.dismiss();
            this.mUnsupportedDisplaySizeDialog = null;
        }
        if (ar != null && !this.hasPackageFlag(ar.packageName, 1)) {
            this.mUnsupportedDisplaySizeDialog = new UnsupportedDisplaySizeDialog(this, this.mUiContext, ar.info.applicationInfo);
            this.mUnsupportedDisplaySizeDialog.show();
        }
    }

    private void showUnsupportedCompileSdkDialogUiThread(ActivityRecord ar) {
        if (this.mUnsupportedCompileSdkDialog != null) {
            this.mUnsupportedCompileSdkDialog.dismiss();
            this.mUnsupportedCompileSdkDialog = null;
        }
        if (ar != null && !this.hasPackageFlag(ar.packageName, 2)) {
            this.mUnsupportedCompileSdkDialog = new UnsupportedCompileSdkDialog(this, this.mUiContext, ar.info.applicationInfo);
            this.mUnsupportedCompileSdkDialog.show();
        }
    }

    private void showDeprecatedTargetSdkDialogUiThread(ActivityRecord ar) {
        if (this.mDeprecatedTargetSdkVersionDialog != null) {
            this.mDeprecatedTargetSdkVersionDialog.dismiss();
            this.mDeprecatedTargetSdkVersionDialog = null;
        }
        if (ar != null && !this.hasPackageFlag(ar.packageName, 4)) {
            this.mDeprecatedTargetSdkVersionDialog = new DeprecatedTargetSdkVersionDialog(this, this.mUiContext, ar.info.applicationInfo);
            this.mDeprecatedTargetSdkVersionDialog.show();
        }
    }

    private void hideDialogsForPackageUiThread(String name) {
        if (this.mUnsupportedDisplaySizeDialog != null && (name == null || name.equals(this.mUnsupportedDisplaySizeDialog.getPackageName()))) {
            this.mUnsupportedDisplaySizeDialog.dismiss();
            this.mUnsupportedDisplaySizeDialog = null;
        }
        if (this.mUnsupportedCompileSdkDialog != null && (name == null || name.equals(this.mUnsupportedCompileSdkDialog.getPackageName()))) {
            this.mUnsupportedCompileSdkDialog.dismiss();
            this.mUnsupportedCompileSdkDialog = null;
        }
        if (this.mDeprecatedTargetSdkVersionDialog != null && (name == null || name.equals(this.mDeprecatedTargetSdkVersionDialog.getPackageName()))) {
            this.mDeprecatedTargetSdkVersionDialog.dismiss();
            this.mDeprecatedTargetSdkVersionDialog = null;
        }
    }

    boolean hasPackageFlag(String name, int flag) {
        return (this.getPackageFlags(name) & flag) == flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setPackageFlag(String name, int flag, boolean enabled) {
        HashMap<String, Integer> hashMap = this.mPackageFlags;
        synchronized (hashMap) {
            int newFlags;
            int curFlags = this.getPackageFlags(name);
            int n = newFlags = enabled ? curFlags | flag : curFlags & ~flag;
            if (curFlags != newFlags) {
                if (newFlags != 0) {
                    this.mPackageFlags.put(name, newFlags);
                } else {
                    this.mPackageFlags.remove(name);
                }
                this.mHandler.scheduleWrite();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getPackageFlags(String name) {
        HashMap<String, Integer> hashMap = this.mPackageFlags;
        synchronized (hashMap) {
            return this.mPackageFlags.getOrDefault(name, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeConfigToFileAmsThread() {
        block6: {
            HashMap<String, Integer> packageFlags;
            HashMap<String, Integer> hashMap = this.mPackageFlags;
            synchronized (hashMap) {
                packageFlags = new HashMap<String, Integer>(this.mPackageFlags);
            }
            FileOutputStream fos = null;
            try {
                fos = this.mConfigFile.startWrite();
                FastXmlSerializer out = new FastXmlSerializer();
                out.setOutput(fos, StandardCharsets.UTF_8.name());
                out.startDocument(null, true);
                out.setFeature("http://xmlpull.org/v1/doc/features.html#indent-output", true);
                out.startTag(null, "packages");
                for (Map.Entry<String, Integer> entry : packageFlags.entrySet()) {
                    String pkg = entry.getKey();
                    int mode = entry.getValue();
                    if (mode == 0) continue;
                    out.startTag(null, "package");
                    out.attribute(null, "name", pkg);
                    out.attribute(null, "flags", Integer.toString(mode));
                    out.endTag(null, "package");
                }
                out.endTag(null, "packages");
                out.endDocument();
                this.mConfigFile.finishWrite(fos);
            }
            catch (IOException e1) {
                Slog.w(TAG, "Error writing package metadata", e1);
                if (fos == null) break block6;
                this.mConfigFile.failWrite(fos);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readConfigFromFileAmsThread() {
        block26: {
            FileInputStream fis = null;
            try {
                fis = this.mConfigFile.openRead();
                XmlPullParser parser = Xml.newPullParser();
                parser.setInput(fis, StandardCharsets.UTF_8.name());
                int eventType = parser.getEventType();
                while (eventType != 2 && eventType != 1) {
                    eventType = parser.next();
                }
                if (eventType == 1) {
                    return;
                }
                String tagName = parser.getName();
                if (!"packages".equals(tagName)) break block26;
                eventType = parser.next();
                do {
                    String name;
                    if (eventType != 2) continue;
                    tagName = parser.getName();
                    if (parser.getDepth() != 2 || !"package".equals(tagName) || (name = parser.getAttributeValue(null, "name")) == null) continue;
                    String flags = parser.getAttributeValue(null, "flags");
                    int flagsInt = 0;
                    if (flags != null) {
                        try {
                            flagsInt = Integer.parseInt(flags);
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    this.mPackageFlags.put(name, flagsInt);
                } while ((eventType = parser.next()) != 1);
            }
            catch (XmlPullParserException e) {
                Slog.w(TAG, "Error reading package metadata", e);
            }
            catch (IOException e) {
                if (fis != null) {
                    Slog.w(TAG, "Error reading package metadata", e);
                }
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
    }

    private final class ConfigHandler
    extends Handler {
        private static final int MSG_WRITE = 1;
        private static final int DELAY_MSG_WRITE = 10000;

        public ConfigHandler(Looper looper) {
            super(looper, null, true);
        }

        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    AppWarnings.this.writeConfigToFileAmsThread();
                }
            }
        }

        public void scheduleWrite() {
            this.removeMessages(1);
            this.sendEmptyMessageDelayed(1, 10000L);
        }
    }

    private final class UiHandler
    extends Handler {
        private static final int MSG_SHOW_UNSUPPORTED_DISPLAY_SIZE_DIALOG = 1;
        private static final int MSG_HIDE_UNSUPPORTED_DISPLAY_SIZE_DIALOG = 2;
        private static final int MSG_SHOW_UNSUPPORTED_COMPILE_SDK_DIALOG = 3;
        private static final int MSG_HIDE_DIALOGS_FOR_PACKAGE = 4;
        private static final int MSG_SHOW_DEPRECATED_TARGET_SDK_DIALOG = 5;

        public UiHandler(Looper looper) {
            super(looper, null, true);
        }

        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    ActivityRecord ar = (ActivityRecord)msg.obj;
                    AppWarnings.this.showUnsupportedDisplaySizeDialogUiThread(ar);
                    break;
                }
                case 2: {
                    AppWarnings.this.hideUnsupportedDisplaySizeDialogUiThread();
                    break;
                }
                case 3: {
                    ActivityRecord ar = (ActivityRecord)msg.obj;
                    AppWarnings.this.showUnsupportedCompileSdkDialogUiThread(ar);
                    break;
                }
                case 4: {
                    String name = (String)msg.obj;
                    AppWarnings.this.hideDialogsForPackageUiThread(name);
                    break;
                }
                case 5: {
                    ActivityRecord ar = (ActivityRecord)msg.obj;
                    AppWarnings.this.showDeprecatedTargetSdkDialogUiThread(ar);
                }
            }
        }

        public void showUnsupportedDisplaySizeDialog(ActivityRecord r) {
            this.removeMessages(1);
            this.obtainMessage(1, r).sendToTarget();
        }

        public void hideUnsupportedDisplaySizeDialog() {
            this.removeMessages(2);
            this.sendEmptyMessage(2);
        }

        public void showUnsupportedCompileSdkDialog(ActivityRecord r) {
            this.removeMessages(3);
            this.obtainMessage(3, r).sendToTarget();
        }

        public void showDeprecatedTargetDialog(ActivityRecord r) {
            this.removeMessages(5);
            this.obtainMessage(5, r).sendToTarget();
        }

        public void hideDialogsForPackage(String name) {
            this.obtainMessage(4, name).sendToTarget();
        }
    }
}

